// Copyright 2013 Dolphin Emulator Project
// Licensed under GPLv2+
// Refer to the license.txt file included.

#include "VideoBackends/OGL/GLExtensions/gl_common.h"

typedef void (GLAPIENTRY * PFNGLCLEARINDEXPROC) ( GLfloat c );
typedef void (GLAPIENTRY * PFNGLCLEARCOLORPROC) ( GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha );
typedef void (GLAPIENTRY * PFNGLCLEARPROC) ( GLbitfield mask );
typedef void (GLAPIENTRY * PFNGLINDEXMASKPROC) ( GLuint mask );
typedef void (GLAPIENTRY * PFNGLCOLORMASKPROC) ( GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha );
typedef void (GLAPIENTRY * PFNGLALPHAFUNCPROC) ( GLenum func, GLclampf ref );
typedef void (GLAPIENTRY * PFNGLBLENDFUNCPROC) ( GLenum sfactor, GLenum dfactor );
typedef void (GLAPIENTRY * PFNGLLOGICOPPROC) ( GLenum opcode );
typedef void (GLAPIENTRY * PFNGLCULLFACEPROC) ( GLenum mode );
typedef void (GLAPIENTRY * PFNGLFRONTFACEPROC) ( GLenum mode );
typedef void (GLAPIENTRY * PFNGLPOINTSIZEPROC) ( GLfloat size );
typedef void (GLAPIENTRY * PFNGLLINEWIDTHPROC) ( GLfloat width );
typedef void (GLAPIENTRY * PFNGLLINESTIPPLEPROC) ( GLint factor, GLushort pattern );
typedef void (GLAPIENTRY * PFNGLPOLYGONMODEPROC) ( GLenum face, GLenum mode );
typedef void (GLAPIENTRY * PFNGLPOLYGONOFFSETPROC) ( GLfloat factor, GLfloat units );
typedef void (GLAPIENTRY * PFNGLPOLYGONSTIPPLEPROC) ( const GLubyte *mask );
typedef void (GLAPIENTRY * PFNGLGETPOLYGONSTIPPLEPROC) ( GLubyte *mask );
typedef void (GLAPIENTRY * PFNGLEDGEFLAGPROC) ( GLboolean flag );
typedef void (GLAPIENTRY * PFNGLEDGEFLAGVPROC) ( const GLboolean *flag );
typedef void (GLAPIENTRY * PFNGLSCISSORPROC) ( GLint x, GLint y, GLsizei width, GLsizei height);
typedef void (GLAPIENTRY * PFNGLCLIPPLANEPROC) ( GLenum plane, const GLdouble *equation );
typedef void (GLAPIENTRY * PFNGLGETCLIPPLANEPROC) ( GLenum plane, GLdouble *equation );
typedef void (GLAPIENTRY * PFNGLDRAWBUFFERPROC) ( GLenum mode );
typedef void (GLAPIENTRY * PFNGLREADBUFFERPROC) ( GLenum mode );
typedef void (GLAPIENTRY * PFNGLENABLEPROC) ( GLenum cap );
typedef void (GLAPIENTRY * PFNGLDISABLEPROC) ( GLenum cap );
typedef GLboolean (GLAPIENTRY * PFNGLISENABLEDPROC) ( GLenum cap );
typedef void (GLAPIENTRY * PFNGLENABLECLIENTSTATEPROC) ( GLenum cap ); /* 1.1 */
typedef void (GLAPIENTRY * PFNGLDISABLECLIENTSTATEPROC) ( GLenum cap ); /* 1.1 */
typedef void (GLAPIENTRY * PFNGLGETBOOLEANVPROC) ( GLenum pname, GLboolean *params );
typedef void (GLAPIENTRY * PFNGLGETDOUBLEVPROC) ( GLenum pname, GLdouble *params );
typedef void (GLAPIENTRY * PFNGLGETFLOATVPROC) ( GLenum pname, GLfloat *params );
typedef void (GLAPIENTRY * PFNGLGETINTEGERVPROC) ( GLenum pname, GLint *params );
typedef void (GLAPIENTRY * PFNGLPUSHATTRIBPROC) ( GLbitfield mask );
typedef void (GLAPIENTRY * PFNGLPOPATTRIBPROC) ( void );
typedef void (GLAPIENTRY * PFNGLPUSHCLIENTATTRIBPROC) ( GLbitfield mask ); /* 1.1 */
typedef void (GLAPIENTRY * PFNGLPOPCLIENTATTRIBPROC) ( void ); /* 1.1 */
typedef GLint (GLAPIENTRY * PFNGLRENDERMODEPROC) ( GLenum mode );
typedef GLenum (GLAPIENTRY * PFNGLGETERRORPROC) ( void );
typedef const GLubyte* (GLAPIENTRY * PFNGLGETSTRINGPROC) ( GLenum name );
typedef void (GLAPIENTRY * PFNGLFINISHPROC) ( void );
typedef void (GLAPIENTRY * PFNGLFLUSHPROC) ( void );
typedef void (GLAPIENTRY * PFNGLHINTPROC) ( GLenum target, GLenum mode );
typedef void (GLAPIENTRY * PFNGLCLEARDEPTHPROC) ( GLclampd depth );
typedef void (GLAPIENTRY * PFNGLDEPTHFUNCPROC) ( GLenum func );
typedef void (GLAPIENTRY * PFNGLDEPTHMASKPROC) ( GLboolean flag );
typedef void (GLAPIENTRY * PFNGLDEPTHRANGEPROC) ( GLclampd near_val, GLclampd far_val );
typedef void (GLAPIENTRY * PFNGLCLEARACCUMPROC) ( GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha );
typedef void (GLAPIENTRY * PFNGLACCUMPROC) ( GLenum op, GLfloat value );
typedef void (GLAPIENTRY * PFNGLMATRIXMODEPROC) ( GLenum mode );
typedef void (GLAPIENTRY * PFNGLORTHOPROC) ( GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble near_val, GLdouble far_val );
typedef void (GLAPIENTRY * PFNGLFRUSTUMPROC) ( GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble near_val, GLdouble far_val );
typedef void (GLAPIENTRY * PFNGLVIEWPORTPROC) ( GLint x, GLint y, GLsizei width, GLsizei height );
typedef void (GLAPIENTRY * PFNGLPUSHMATRIXPROC) ( void );
typedef void (GLAPIENTRY * PFNGLPOPMATRIXPROC) ( void );
typedef void (GLAPIENTRY * PFNGLLOADIDENTITYPROC) ( void );
typedef void (GLAPIENTRY * PFNGLLOADMATRIXDPROC) ( const GLdouble *m );
typedef void (GLAPIENTRY * PFNGLLOADMATRIXFPROC) ( const GLfloat *m );
typedef void (GLAPIENTRY * PFNGLMULTMATRIXDPROC) ( const GLdouble *m );
typedef void (GLAPIENTRY * PFNGLMULTMATRIXFPROC) ( const GLfloat *m );
typedef void (GLAPIENTRY * PFNGLROTATEDPROC) ( GLdouble angle, GLdouble x, GLdouble y, GLdouble z );
typedef void (GLAPIENTRY * PFNGLROTATEFPROC) ( GLfloat angle, GLfloat x, GLfloat y, GLfloat z );
typedef void (GLAPIENTRY * PFNGLSCALEDPROC) ( GLdouble x, GLdouble y, GLdouble z );
typedef void (GLAPIENTRY * PFNGLSCALEFPROC) ( GLfloat x, GLfloat y, GLfloat z );
typedef void (GLAPIENTRY * PFNGLTRANSLATEDPROC) ( GLdouble x, GLdouble y, GLdouble z );
typedef void (GLAPIENTRY * PFNGLTRANSLATEFPROC) ( GLfloat x, GLfloat y, GLfloat z );
typedef GLboolean (GLAPIENTRY * PFNGLISLISTPROC) ( GLuint list );
typedef void (GLAPIENTRY * PFNGLDELETELISTSPROC) ( GLuint list, GLsizei range );
typedef GLuint (GLAPIENTRY * PFNGLGENLISTSPROC) ( GLsizei range );
typedef void (GLAPIENTRY * PFNGLNEWLISTPROC) ( GLuint list, GLenum mode );
typedef void (GLAPIENTRY * PFNGLENDLISTPROC) ( void );
typedef void (GLAPIENTRY * PFNGLCALLLISTPROC) ( GLuint list );
typedef void (GLAPIENTRY * PFNGLCALLLISTSPROC) ( GLsizei n, GLenum type, const GLvoid *lists );
typedef void (GLAPIENTRY * PFNGLLISTBASEPROC) ( GLuint base );
typedef void (GLAPIENTRY * PFNGLBEGINPROC) ( GLenum mode );
typedef void (GLAPIENTRY * PFNGLENDPROC) ( void );
typedef void (GLAPIENTRY * PFNGLVERTEX2DPROC) ( GLdouble x, GLdouble y );
typedef void (GLAPIENTRY * PFNGLVERTEX2FPROC) ( GLfloat x, GLfloat y );
typedef void (GLAPIENTRY * PFNGLVERTEX2IPROC) ( GLint x, GLint y );
typedef void (GLAPIENTRY * PFNGLVERTEX2SPROC) ( GLshort x, GLshort y );
typedef void (GLAPIENTRY * PFNGLVERTEX3DPROC) ( GLdouble x, GLdouble y, GLdouble z );
typedef void (GLAPIENTRY * PFNGLVERTEX3FPROC) ( GLfloat x, GLfloat y, GLfloat z );
typedef void (GLAPIENTRY * PFNGLVERTEX3IPROC) ( GLint x, GLint y, GLint z );
typedef void (GLAPIENTRY * PFNGLVERTEX3SPROC) ( GLshort x, GLshort y, GLshort z );
typedef void (GLAPIENTRY * PFNGLVERTEX4DPROC) ( GLdouble x, GLdouble y, GLdouble z, GLdouble w );
typedef void (GLAPIENTRY * PFNGLVERTEX4FPROC) ( GLfloat x, GLfloat y, GLfloat z, GLfloat w );
typedef void (GLAPIENTRY * PFNGLVERTEX4IPROC) ( GLint x, GLint y, GLint z, GLint w );
typedef void (GLAPIENTRY * PFNGLVERTEX4SPROC) ( GLshort x, GLshort y, GLshort z, GLshort w );
typedef void (GLAPIENTRY * PFNGLVERTEX2DVPROC) ( const GLdouble *v );
typedef void (GLAPIENTRY * PFNGLVERTEX2FVPROC) ( const GLfloat *v );
typedef void (GLAPIENTRY * PFNGLVERTEX2IVPROC) ( const GLint *v );
typedef void (GLAPIENTRY * PFNGLVERTEX2SVPROC) ( const GLshort *v );
typedef void (GLAPIENTRY * PFNGLVERTEX3DVPROC) ( const GLdouble *v );
typedef void (GLAPIENTRY * PFNGLVERTEX3FVPROC) ( const GLfloat *v );
typedef void (GLAPIENTRY * PFNGLVERTEX3IVPROC) ( const GLint *v );
typedef void (GLAPIENTRY * PFNGLVERTEX3SVPROC) ( const GLshort *v );
typedef void (GLAPIENTRY * PFNGLVERTEX4DVPROC) ( const GLdouble *v );
typedef void (GLAPIENTRY * PFNGLVERTEX4FVPROC) ( const GLfloat *v );
typedef void (GLAPIENTRY * PFNGLVERTEX4IVPROC) ( const GLint *v );
typedef void (GLAPIENTRY * PFNGLVERTEX4SVPROC) ( const GLshort *v );
typedef void (GLAPIENTRY * PFNGLNORMAL3BPROC) ( GLbyte nx, GLbyte ny, GLbyte nz );
typedef void (GLAPIENTRY * PFNGLNORMAL3DPROC) ( GLdouble nx, GLdouble ny, GLdouble nz );
typedef void (GLAPIENTRY * PFNGLNORMAL3FPROC) ( GLfloat nx, GLfloat ny, GLfloat nz );
typedef void (GLAPIENTRY * PFNGLNORMAL3IPROC) ( GLint nx, GLint ny, GLint nz );
typedef void (GLAPIENTRY * PFNGLNORMAL3SPROC) ( GLshort nx, GLshort ny, GLshort nz );
typedef void (GLAPIENTRY * PFNGLNORMAL3BVPROC) ( const GLbyte *v );
typedef void (GLAPIENTRY * PFNGLNORMAL3DVPROC) ( const GLdouble *v );
typedef void (GLAPIENTRY * PFNGLNORMAL3FVPROC) ( const GLfloat *v );
typedef void (GLAPIENTRY * PFNGLNORMAL3IVPROC) ( const GLint *v );
typedef void (GLAPIENTRY * PFNGLNORMAL3SVPROC) ( const GLshort *v );
typedef void (GLAPIENTRY * PFNGLINDEXDPROC) ( GLdouble c );
typedef void (GLAPIENTRY * PFNGLINDEXFPROC) ( GLfloat c );
typedef void (GLAPIENTRY * PFNGLINDEXIPROC) ( GLint c );
typedef void (GLAPIENTRY * PFNGLINDEXSPROC) ( GLshort c );
typedef void (GLAPIENTRY * PFNGLINDEXUBPROC) ( GLubyte c ); /* 1.1 */
typedef void (GLAPIENTRY * PFNGLINDEXDVPROC) ( const GLdouble *c );
typedef void (GLAPIENTRY * PFNGLINDEXFVPROC) ( const GLfloat *c );
typedef void (GLAPIENTRY * PFNGLINDEXIVPROC) ( const GLint *c );
typedef void (GLAPIENTRY * PFNGLINDEXSVPROC) ( const GLshort *c );
typedef void (GLAPIENTRY * PFNGLINDEXUBVPROC) ( const GLubyte *c ); /* 1.1 */
typedef void (GLAPIENTRY * PFNGLCOLOR3BPROC) ( GLbyte red, GLbyte green, GLbyte blue );
typedef void (GLAPIENTRY * PFNGLCOLOR3DPROC) ( GLdouble red, GLdouble green, GLdouble blue );
typedef void (GLAPIENTRY * PFNGLCOLOR3FPROC) ( GLfloat red, GLfloat green, GLfloat blue );
typedef void (GLAPIENTRY * PFNGLCOLOR3IPROC) ( GLint red, GLint green, GLint blue );
typedef void (GLAPIENTRY * PFNGLCOLOR3SPROC) ( GLshort red, GLshort green, GLshort blue );
typedef void (GLAPIENTRY * PFNGLCOLOR3UBPROC) ( GLubyte red, GLubyte green, GLubyte blue );
typedef void (GLAPIENTRY * PFNGLCOLOR3UIPROC) ( GLuint red, GLuint green, GLuint blue );
typedef void (GLAPIENTRY * PFNGLCOLOR3USPROC) ( GLushort red, GLushort green, GLushort blue );
typedef void (GLAPIENTRY * PFNGLCOLOR4BPROC) ( GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha );
typedef void (GLAPIENTRY * PFNGLCOLOR4DPROC) ( GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha );
typedef void (GLAPIENTRY * PFNGLCOLOR4FPROC) ( GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha );
typedef void (GLAPIENTRY * PFNGLCOLOR4IPROC) ( GLint red, GLint green, GLint blue, GLint alpha );
typedef void (GLAPIENTRY * PFNGLCOLOR4SPROC) ( GLshort red, GLshort green, GLshort blue, GLshort alpha );
typedef void (GLAPIENTRY * PFNGLCOLOR4UBPROC) ( GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha );
typedef void (GLAPIENTRY * PFNGLCOLOR4UIPROC) ( GLuint red, GLuint green, GLuint blue, GLuint alpha );
typedef void (GLAPIENTRY * PFNGLCOLOR4USPROC) ( GLushort red, GLushort green, GLushort blue, GLushort alpha );
typedef void (GLAPIENTRY * PFNGLCOLOR3BVPROC) ( const GLbyte *v );
typedef void (GLAPIENTRY * PFNGLCOLOR3DVPROC) ( const GLdouble *v );
typedef void (GLAPIENTRY * PFNGLCOLOR3FVPROC) ( const GLfloat *v );
typedef void (GLAPIENTRY * PFNGLCOLOR3IVPROC) ( const GLint *v );
typedef void (GLAPIENTRY * PFNGLCOLOR3SVPROC) ( const GLshort *v );
typedef void (GLAPIENTRY * PFNGLCOLOR3UBVPROC) ( const GLubyte *v );
typedef void (GLAPIENTRY * PFNGLCOLOR3UIVPROC) ( const GLuint *v );
typedef void (GLAPIENTRY * PFNGLCOLOR3USVPROC) ( const GLushort *v );
typedef void (GLAPIENTRY * PFNGLCOLOR4BVPROC) ( const GLbyte *v );
typedef void (GLAPIENTRY * PFNGLCOLOR4DVPROC) ( const GLdouble *v );
typedef void (GLAPIENTRY * PFNGLCOLOR4FVPROC) ( const GLfloat *v );
typedef void (GLAPIENTRY * PFNGLCOLOR4IVPROC) ( const GLint *v );
typedef void (GLAPIENTRY * PFNGLCOLOR4SVPROC) ( const GLshort *v );
typedef void (GLAPIENTRY * PFNGLCOLOR4UBVPROC) ( const GLubyte *v );
typedef void (GLAPIENTRY * PFNGLCOLOR4UIVPROC) ( const GLuint *v );
typedef void (GLAPIENTRY * PFNGLCOLOR4USVPROC) ( const GLushort *v );
typedef void (GLAPIENTRY * PFNGLTEXCOORD1DPROC) ( GLdouble s );
typedef void (GLAPIENTRY * PFNGLTEXCOORD1FPROC) ( GLfloat s );
typedef void (GLAPIENTRY * PFNGLTEXCOORD1IPROC) ( GLint s );
typedef void (GLAPIENTRY * PFNGLTEXCOORD1SPROC) ( GLshort s );
typedef void (GLAPIENTRY * PFNGLTEXCOORD2DPROC) ( GLdouble s, GLdouble t );
typedef void (GLAPIENTRY * PFNGLTEXCOORD2FPROC) ( GLfloat s, GLfloat t );
typedef void (GLAPIENTRY * PFNGLTEXCOORD2IPROC) ( GLint s, GLint t );
typedef void (GLAPIENTRY * PFNGLTEXCOORD2SPROC) ( GLshort s, GLshort t );
typedef void (GLAPIENTRY * PFNGLTEXCOORD3DPROC) ( GLdouble s, GLdouble t, GLdouble r );
typedef void (GLAPIENTRY * PFNGLTEXCOORD3FPROC) ( GLfloat s, GLfloat t, GLfloat r );
typedef void (GLAPIENTRY * PFNGLTEXCOORD3IPROC) ( GLint s, GLint t, GLint r );
typedef void (GLAPIENTRY * PFNGLTEXCOORD3SPROC) ( GLshort s, GLshort t, GLshort r );
typedef void (GLAPIENTRY * PFNGLTEXCOORD4DPROC) ( GLdouble s, GLdouble t, GLdouble r, GLdouble q );
typedef void (GLAPIENTRY * PFNGLTEXCOORD4FPROC) ( GLfloat s, GLfloat t, GLfloat r, GLfloat q );
typedef void (GLAPIENTRY * PFNGLTEXCOORD4IPROC) ( GLint s, GLint t, GLint r, GLint q );
typedef void (GLAPIENTRY * PFNGLTEXCOORD4SPROC) ( GLshort s, GLshort t, GLshort r, GLshort q );
typedef void (GLAPIENTRY * PFNGLTEXCOORD1DVPROC) ( const GLdouble *v );
typedef void (GLAPIENTRY * PFNGLTEXCOORD1FVPROC) ( const GLfloat *v );
typedef void (GLAPIENTRY * PFNGLTEXCOORD1IVPROC) ( const GLint *v );
typedef void (GLAPIENTRY * PFNGLTEXCOORD1SVPROC) ( const GLshort *v );
typedef void (GLAPIENTRY * PFNGLTEXCOORD2DVPROC) ( const GLdouble *v );
typedef void (GLAPIENTRY * PFNGLTEXCOORD2FVPROC) ( const GLfloat *v );
typedef void (GLAPIENTRY * PFNGLTEXCOORD2IVPROC) ( const GLint *v );
typedef void (GLAPIENTRY * PFNGLTEXCOORD2SVPROC) ( const GLshort *v );
typedef void (GLAPIENTRY * PFNGLTEXCOORD3DVPROC) ( const GLdouble *v );
typedef void (GLAPIENTRY * PFNGLTEXCOORD3FVPROC) ( const GLfloat *v );
typedef void (GLAPIENTRY * PFNGLTEXCOORD3IVPROC) ( const GLint *v );
typedef void (GLAPIENTRY * PFNGLTEXCOORD3SVPROC) ( const GLshort *v );
typedef void (GLAPIENTRY * PFNGLTEXCOORD4DVPROC) ( const GLdouble *v );
typedef void (GLAPIENTRY * PFNGLTEXCOORD4FVPROC) ( const GLfloat *v );
typedef void (GLAPIENTRY * PFNGLTEXCOORD4IVPROC) ( const GLint *v );
typedef void (GLAPIENTRY * PFNGLTEXCOORD4SVPROC) ( const GLshort *v );
typedef void (GLAPIENTRY * PFNGLRASTERPOS2DPROC) ( GLdouble x, GLdouble y );
typedef void (GLAPIENTRY * PFNGLRASTERPOS2FPROC) ( GLfloat x, GLfloat y );
typedef void (GLAPIENTRY * PFNGLRASTERPOS2IPROC) ( GLint x, GLint y );
typedef void (GLAPIENTRY * PFNGLRASTERPOS2SPROC) ( GLshort x, GLshort y );
typedef void (GLAPIENTRY * PFNGLRASTERPOS3DPROC) ( GLdouble x, GLdouble y, GLdouble z );
typedef void (GLAPIENTRY * PFNGLRASTERPOS3FPROC) ( GLfloat x, GLfloat y, GLfloat z );
typedef void (GLAPIENTRY * PFNGLRASTERPOS3IPROC) ( GLint x, GLint y, GLint z );
typedef void (GLAPIENTRY * PFNGLRASTERPOS3SPROC) ( GLshort x, GLshort y, GLshort z );
typedef void (GLAPIENTRY * PFNGLRASTERPOS4DPROC) ( GLdouble x, GLdouble y, GLdouble z, GLdouble w );
typedef void (GLAPIENTRY * PFNGLRASTERPOS4FPROC) ( GLfloat x, GLfloat y, GLfloat z, GLfloat w );
typedef void (GLAPIENTRY * PFNGLRASTERPOS4IPROC) ( GLint x, GLint y, GLint z, GLint w );
typedef void (GLAPIENTRY * PFNGLRASTERPOS4SPROC) ( GLshort x, GLshort y, GLshort z, GLshort w );
typedef void (GLAPIENTRY * PFNGLRASTERPOS2DVPROC) ( const GLdouble *v );
typedef void (GLAPIENTRY * PFNGLRASTERPOS2FVPROC) ( const GLfloat *v );
typedef void (GLAPIENTRY * PFNGLRASTERPOS2IVPROC) ( const GLint *v );
typedef void (GLAPIENTRY * PFNGLRASTERPOS2SVPROC) ( const GLshort *v );
typedef void (GLAPIENTRY * PFNGLRASTERPOS3DVPROC) ( const GLdouble *v );
typedef void (GLAPIENTRY * PFNGLRASTERPOS3FVPROC) ( const GLfloat *v );
typedef void (GLAPIENTRY * PFNGLRASTERPOS3IVPROC) ( const GLint *v );
typedef void (GLAPIENTRY * PFNGLRASTERPOS3SVPROC) ( const GLshort *v );
typedef void (GLAPIENTRY * PFNGLRASTERPOS4DVPROC) ( const GLdouble *v );
typedef void (GLAPIENTRY * PFNGLRASTERPOS4FVPROC) ( const GLfloat *v );
typedef void (GLAPIENTRY * PFNGLRASTERPOS4IVPROC) ( const GLint *v );
typedef void (GLAPIENTRY * PFNGLRASTERPOS4SVPROC) ( const GLshort *v );
typedef void (GLAPIENTRY * PFNGLRECTDPROC) ( GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2 );
typedef void (GLAPIENTRY * PFNGLRECTFPROC) ( GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2 );
typedef void (GLAPIENTRY * PFNGLRECTIPROC) ( GLint x1, GLint y1, GLint x2, GLint y2 );
typedef void (GLAPIENTRY * PFNGLRECTSPROC) ( GLshort x1, GLshort y1, GLshort x2, GLshort y2 );
typedef void (GLAPIENTRY * PFNGLRECTDVPROC) ( const GLdouble *v1, const GLdouble *v2 );
typedef void (GLAPIENTRY * PFNGLRECTFVPROC) ( const GLfloat *v1, const GLfloat *v2 );
typedef void (GLAPIENTRY * PFNGLRECTIVPROC) ( const GLint *v1, const GLint *v2 );
typedef void (GLAPIENTRY * PFNGLRECTSVPROC) ( const GLshort *v1, const GLshort *v2 );
typedef void (GLAPIENTRY * PFNGLVERTEXPOINTERPROC) ( GLint size, GLenum type, GLsizei stride, const GLvoid *ptr );
typedef void (GLAPIENTRY * PFNGLNORMALPOINTERPROC) ( GLenum type, GLsizei stride, const GLvoid *ptr );
typedef void (GLAPIENTRY * PFNGLCOLORPOINTERPROC) ( GLint size, GLenum type, GLsizei stride, const GLvoid *ptr );
typedef void (GLAPIENTRY * PFNGLINDEXPOINTERPROC) ( GLenum type, GLsizei stride, const GLvoid *ptr );
typedef void (GLAPIENTRY * PFNGLTEXCOORDPOINTERPROC) ( GLint size, GLenum type, GLsizei stride, const GLvoid *ptr );
typedef void (GLAPIENTRY * PFNGLEDGEFLAGPOINTERPROC) ( GLsizei stride, const GLvoid *ptr );
typedef void (GLAPIENTRY * PFNGLGETPOINTERVPROC) ( GLenum pname, GLvoid **params );
typedef void (GLAPIENTRY * PFNGLARRAYELEMENTPROC) ( GLint i );
typedef void (GLAPIENTRY * PFNGLDRAWARRAYSPROC) ( GLenum mode, GLint first, GLsizei count );
typedef void (GLAPIENTRY * PFNGLDRAWELEMENTSPROC) ( GLenum mode, GLsizei count, GLenum type, const GLvoid *indices );
typedef void (GLAPIENTRY * PFNGLINTERLEAVEDARRAYSPROC) ( GLenum format, GLsizei stride, const GLvoid *pointer );
typedef void (GLAPIENTRY * PFNGLSHADEMODELPROC) ( GLenum mode );
typedef void (GLAPIENTRY * PFNGLLIGHTFPROC) ( GLenum light, GLenum pname, GLfloat param );
typedef void (GLAPIENTRY * PFNGLLIGHTIPROC) ( GLenum light, GLenum pname, GLint param );
typedef void (GLAPIENTRY * PFNGLLIGHTFVPROC) ( GLenum light, GLenum pname, const GLfloat *params );
typedef void (GLAPIENTRY * PFNGLLIGHTIVPROC) ( GLenum light, GLenum pname, const GLint *params );
typedef void (GLAPIENTRY * PFNGLGETLIGHTFVPROC) ( GLenum light, GLenum pname, GLfloat *params );
typedef void (GLAPIENTRY * PFNGLGETLIGHTIVPROC) ( GLenum light, GLenum pname, GLint *params );
typedef void (GLAPIENTRY * PFNGLLIGHTMODELFPROC) ( GLenum pname, GLfloat param );
typedef void (GLAPIENTRY * PFNGLLIGHTMODELIPROC) ( GLenum pname, GLint param );
typedef void (GLAPIENTRY * PFNGLLIGHTMODELFVPROC) ( GLenum pname, const GLfloat *params );
typedef void (GLAPIENTRY * PFNGLLIGHTMODELIVPROC) ( GLenum pname, const GLint *params );
typedef void (GLAPIENTRY * PFNGLMATERIALFPROC) ( GLenum face, GLenum pname, GLfloat param );
typedef void (GLAPIENTRY * PFNGLMATERIALIPROC) ( GLenum face, GLenum pname, GLint param );
typedef void (GLAPIENTRY * PFNGLMATERIALFVPROC) ( GLenum face, GLenum pname, const GLfloat *params );
typedef void (GLAPIENTRY * PFNGLMATERIALIVPROC) ( GLenum face, GLenum pname, const GLint *params );
typedef void (GLAPIENTRY * PFNGLGETMATERIALFVPROC) ( GLenum face, GLenum pname, GLfloat *params );
typedef void (GLAPIENTRY * PFNGLGETMATERIALIVPROC) ( GLenum face, GLenum pname, GLint *params );
typedef void (GLAPIENTRY * PFNGLCOLORMATERIALPROC) ( GLenum face, GLenum mode );
typedef void (GLAPIENTRY * PFNGLPIXELZOOMPROC) ( GLfloat xfactor, GLfloat yfactor );
typedef void (GLAPIENTRY * PFNGLPIXELSTOREFPROC) ( GLenum pname, GLfloat param );
typedef void (GLAPIENTRY * PFNGLPIXELSTOREIPROC) ( GLenum pname, GLint param );
typedef void (GLAPIENTRY * PFNGLPIXELTRANSFERFPROC) ( GLenum pname, GLfloat param );
typedef void (GLAPIENTRY * PFNGLPIXELTRANSFERIPROC) ( GLenum pname, GLint param );
typedef void (GLAPIENTRY * PFNGLPIXELMAPFVPROC) ( GLenum map, GLsizei mapsize, const GLfloat *values );
typedef void (GLAPIENTRY * PFNGLPIXELMAPUIVPROC) ( GLenum map, GLsizei mapsize, const GLuint *values );
typedef void (GLAPIENTRY * PFNGLPIXELMAPUSVPROC) ( GLenum map, GLsizei mapsize, const GLushort *values );
typedef void (GLAPIENTRY * PFNGLGETPIXELMAPFVPROC) ( GLenum map, GLfloat *values );
typedef void (GLAPIENTRY * PFNGLGETPIXELMAPUIVPROC) ( GLenum map, GLuint *values );
typedef void (GLAPIENTRY * PFNGLGETPIXELMAPUSVPROC) ( GLenum map, GLushort *values );
typedef void (GLAPIENTRY * PFNGLBITMAPPROC) ( GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap );
typedef void (GLAPIENTRY * PFNGLREADPIXELSPROC) ( GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels );
typedef void (GLAPIENTRY * PFNGLDRAWPIXELSPROC) ( GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels );
typedef void (GLAPIENTRY * PFNGLCOPYPIXELSPROC) ( GLint x, GLint y, GLsizei width, GLsizei height, GLenum type );
typedef void (GLAPIENTRY * PFNGLSTENCILFUNCPROC) ( GLenum func, GLint ref, GLuint mask );
typedef void (GLAPIENTRY * PFNGLSTENCILMASKPROC) ( GLuint mask );
typedef void (GLAPIENTRY * PFNGLSTENCILOPPROC) ( GLenum fail, GLenum zfail, GLenum zpass );
typedef void (GLAPIENTRY * PFNGLCLEARSTENCILPROC) ( GLint s );
typedef void (GLAPIENTRY * PFNGLTEXGENDPROC) ( GLenum coord, GLenum pname, GLdouble param );
typedef void (GLAPIENTRY * PFNGLTEXGENFPROC) ( GLenum coord, GLenum pname, GLfloat param );
typedef void (GLAPIENTRY * PFNGLTEXGENIPROC) ( GLenum coord, GLenum pname, GLint param );
typedef void (GLAPIENTRY * PFNGLTEXGENDVPROC) ( GLenum coord, GLenum pname, const GLdouble *params );
typedef void (GLAPIENTRY * PFNGLTEXGENFVPROC) ( GLenum coord, GLenum pname, const GLfloat *params );
typedef void (GLAPIENTRY * PFNGLTEXGENIVPROC) ( GLenum coord, GLenum pname, const GLint *params );
typedef void (GLAPIENTRY * PFNGLGETTEXGENDVPROC) ( GLenum coord, GLenum pname, GLdouble *params );
typedef void (GLAPIENTRY * PFNGLGETTEXGENFVPROC) ( GLenum coord, GLenum pname, GLfloat *params );
typedef void (GLAPIENTRY * PFNGLGETTEXGENIVPROC) ( GLenum coord, GLenum pname, GLint *params );
typedef void (GLAPIENTRY * PFNGLTEXENVFPROC) ( GLenum target, GLenum pname, GLfloat param );
typedef void (GLAPIENTRY * PFNGLTEXENVIPROC) ( GLenum target, GLenum pname, GLint param );
typedef void (GLAPIENTRY * PFNGLTEXENVFVPROC) ( GLenum target, GLenum pname, const GLfloat *params );
typedef void (GLAPIENTRY * PFNGLTEXENVIVPROC) ( GLenum target, GLenum pname, const GLint *params );
typedef void (GLAPIENTRY * PFNGLGETTEXENVFVPROC) ( GLenum target, GLenum pname, GLfloat *params );
typedef void (GLAPIENTRY * PFNGLGETTEXENVIVPROC) ( GLenum target, GLenum pname, GLint *params );
typedef void (GLAPIENTRY * PFNGLTEXPARAMETERFPROC) ( GLenum target, GLenum pname, GLfloat param );
typedef void (GLAPIENTRY * PFNGLTEXPARAMETERIPROC) ( GLenum target, GLenum pname, GLint param );
typedef void (GLAPIENTRY * PFNGLTEXPARAMETERFVPROC) ( GLenum target, GLenum pname, const GLfloat *params );
typedef void (GLAPIENTRY * PFNGLTEXPARAMETERIVPROC) ( GLenum target, GLenum pname, const GLint *params );
typedef void (GLAPIENTRY * PFNGLGETTEXPARAMETERFVPROC) ( GLenum target, GLenum pname, GLfloat *params);
typedef void (GLAPIENTRY * PFNGLGETTEXPARAMETERIVPROC) ( GLenum target, GLenum pname, GLint *params );
typedef void (GLAPIENTRY * PFNGLGETTEXLEVELPARAMETERFVPROC) ( GLenum target, GLint level, GLenum pname, GLfloat *params );
typedef void (GLAPIENTRY * PFNGLGETTEXLEVELPARAMETERIVPROC) ( GLenum target, GLint level, GLenum pname, GLint *params );
typedef void (GLAPIENTRY * PFNGLTEXIMAGE1DPROC) ( GLenum target, GLint level, GLint internalFormat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels );
typedef void (GLAPIENTRY * PFNGLTEXIMAGE2DPROC) ( GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels );
typedef void (GLAPIENTRY * PFNGLGETTEXIMAGEPROC) ( GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels );
typedef void (GLAPIENTRY * PFNGLGENTEXTURESPROC) ( GLsizei n, GLuint *textures );
typedef void (GLAPIENTRY * PFNGLDELETETEXTURESPROC) ( GLsizei n, const GLuint *textures);
typedef void (GLAPIENTRY * PFNGLBINDTEXTUREPROC) ( GLenum target, GLuint texture );
typedef void (GLAPIENTRY * PFNGLPRIORITIZETEXTURESPROC) ( GLsizei n, const GLuint *textures, const GLclampf *priorities );
typedef GLboolean (GLAPIENTRY * PFNGLARETEXTURESRESIDENTPROC) ( GLsizei n, const GLuint *textures, GLboolean *residences );
typedef GLboolean (GLAPIENTRY * PFNGLISTEXTUREPROC) ( GLuint texture );
typedef void (GLAPIENTRY * PFNGLTEXSUBIMAGE1DPROC) ( GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels );
typedef void (GLAPIENTRY * PFNGLTEXSUBIMAGE2DPROC) ( GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels );
typedef void (GLAPIENTRY * PFNGLCOPYTEXIMAGE1DPROC) ( GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border );
typedef void (GLAPIENTRY * PFNGLCOPYTEXIMAGE2DPROC) ( GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border );
typedef void (GLAPIENTRY * PFNGLCOPYTEXSUBIMAGE1DPROC) ( GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width );
typedef void (GLAPIENTRY * PFNGLCOPYTEXSUBIMAGE2DPROC) ( GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height );
typedef void (GLAPIENTRY * PFNGLMAP1DPROC) ( GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points );
typedef void (GLAPIENTRY * PFNGLMAP1FPROC) ( GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points );
typedef void (GLAPIENTRY * PFNGLMAP2DPROC) ( GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points );
typedef void (GLAPIENTRY * PFNGLMAP2FPROC) ( GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points );
typedef void (GLAPIENTRY * PFNGLGETMAPDVPROC) ( GLenum target, GLenum query, GLdouble *v );
typedef void (GLAPIENTRY * PFNGLGETMAPFVPROC) ( GLenum target, GLenum query, GLfloat *v );
typedef void (GLAPIENTRY * PFNGLGETMAPIVPROC) ( GLenum target, GLenum query, GLint *v );
typedef void (GLAPIENTRY * PFNGLEVALCOORD1DPROC) ( GLdouble u );
typedef void (GLAPIENTRY * PFNGLEVALCOORD1FPROC) ( GLfloat u );
typedef void (GLAPIENTRY * PFNGLEVALCOORD1DVPROC) ( const GLdouble *u );
typedef void (GLAPIENTRY * PFNGLEVALCOORD1FVPROC) ( const GLfloat *u );
typedef void (GLAPIENTRY * PFNGLEVALCOORD2DPROC) ( GLdouble u, GLdouble v );
typedef void (GLAPIENTRY * PFNGLEVALCOORD2FPROC) ( GLfloat u, GLfloat v );
typedef void (GLAPIENTRY * PFNGLEVALCOORD2DVPROC) ( const GLdouble *u );
typedef void (GLAPIENTRY * PFNGLEVALCOORD2FVPROC) ( const GLfloat *u );
typedef void (GLAPIENTRY * PFNGLMAPGRID1DPROC) ( GLint un, GLdouble u1, GLdouble u2 );
typedef void (GLAPIENTRY * PFNGLMAPGRID1FPROC) ( GLint un, GLfloat u1, GLfloat u2 );
typedef void (GLAPIENTRY * PFNGLMAPGRID2DPROC) ( GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2 );
typedef void (GLAPIENTRY * PFNGLMAPGRID2FPROC) ( GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2 );
typedef void (GLAPIENTRY * PFNGLEVALPOINT1PROC) ( GLint i );
typedef void (GLAPIENTRY * PFNGLEVALPOINT2PROC) ( GLint i, GLint j );
typedef void (GLAPIENTRY * PFNGLEVALMESH1PROC) ( GLenum mode, GLint i1, GLint i2 );
typedef void (GLAPIENTRY * PFNGLEVALMESH2PROC) ( GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2 );
typedef void (GLAPIENTRY * PFNGLFOGFPROC) ( GLenum pname, GLfloat param );
typedef void (GLAPIENTRY * PFNGLFOGIPROC) ( GLenum pname, GLint param );
typedef void (GLAPIENTRY * PFNGLFOGFVPROC) ( GLenum pname, const GLfloat *params );
typedef void (GLAPIENTRY * PFNGLFOGIVPROC) ( GLenum pname, const GLint *params );
typedef void (GLAPIENTRY * PFNGLFEEDBACKBUFFERPROC) ( GLsizei size, GLenum type, GLfloat *buffer );
typedef void (GLAPIENTRY * PFNGLPASSTHROUGHPROC) ( GLfloat token );
typedef void (GLAPIENTRY * PFNGLSELECTBUFFERPROC) ( GLsizei size, GLuint *buffer );
typedef void (GLAPIENTRY * PFNGLINITNAMESPROC) ( void );
typedef void (GLAPIENTRY * PFNGLLOADNAMEPROC) ( GLuint name );
typedef void (GLAPIENTRY * PFNGLPUSHNAMEPROC) ( GLuint name );
typedef void (GLAPIENTRY * PFNGLPOPNAMEPROC) ( void );

extern PFNGLCLEARINDEXPROC glClearIndex;
extern PFNGLCLEARCOLORPROC glClearColor;
extern PFNGLCLEARPROC glClear;
extern PFNGLINDEXMASKPROC glIndexMask;
extern PFNGLCOLORMASKPROC glColorMask;
extern PFNGLALPHAFUNCPROC glAlphaFunc;
extern PFNGLBLENDFUNCPROC glBlendFunc;
extern PFNGLLOGICOPPROC glLogicOp;
extern PFNGLCULLFACEPROC glCullFace;
extern PFNGLFRONTFACEPROC glFrontFace;
extern PFNGLPOINTSIZEPROC glPointSize;
extern PFNGLLINEWIDTHPROC glLineWidth;
extern PFNGLLINESTIPPLEPROC glLineStipple;
extern PFNGLPOLYGONMODEPROC glPolygonMode;
extern PFNGLPOLYGONOFFSETPROC glPolygonOffset;
extern PFNGLPOLYGONSTIPPLEPROC glPolygonStipple;
extern PFNGLGETPOLYGONSTIPPLEPROC glGetPolygonStipple;
extern PFNGLEDGEFLAGPROC glEdgeFlag;
extern PFNGLEDGEFLAGVPROC glEdgeFlagv;
extern PFNGLSCISSORPROC glScissor;
extern PFNGLCLIPPLANEPROC glClipPlane;
extern PFNGLGETCLIPPLANEPROC glGetClipPlane;
extern PFNGLDRAWBUFFERPROC glDrawBuffer;
extern PFNGLREADBUFFERPROC glReadBuffer;
extern PFNGLENABLEPROC glEnable;
extern PFNGLDISABLEPROC glDisable;
extern PFNGLISENABLEDPROC glIsEnabled;
extern PFNGLENABLECLIENTSTATEPROC glEnableClientState;
extern PFNGLDISABLECLIENTSTATEPROC glDisableClientState;
extern PFNGLGETBOOLEANVPROC glGetBooleanv;
extern PFNGLGETDOUBLEVPROC glGetDoublev;
extern PFNGLGETFLOATVPROC glGetFloatv;
extern PFNGLGETINTEGERVPROC glGetIntegerv;
extern PFNGLPUSHATTRIBPROC glPushAttrib;
extern PFNGLPOPATTRIBPROC glPopAttrib;
extern PFNGLPUSHCLIENTATTRIBPROC glPushClientAttrib;
extern PFNGLPOPCLIENTATTRIBPROC glPopClientAttrib;
extern PFNGLRENDERMODEPROC glRenderMode;
extern PFNGLGETERRORPROC glGetError;
extern PFNGLGETSTRINGPROC glGetString;
extern PFNGLFINISHPROC glFinish;
extern PFNGLFLUSHPROC glFlush;
extern PFNGLHINTPROC glHint;
extern PFNGLCLEARDEPTHPROC glClearDepth;
extern PFNGLDEPTHFUNCPROC glDepthFunc;
extern PFNGLDEPTHMASKPROC glDepthMask;
extern PFNGLDEPTHRANGEPROC glDepthRange;
extern PFNGLCLEARACCUMPROC glClearAccum;
extern PFNGLACCUMPROC glAccum;
extern PFNGLMATRIXMODEPROC glMatrixMode;
extern PFNGLORTHOPROC glOrtho;
extern PFNGLFRUSTUMPROC glFrustum;
extern PFNGLVIEWPORTPROC glViewport;
extern PFNGLPUSHMATRIXPROC glPushMatrix;
extern PFNGLPOPMATRIXPROC glPopMatrix;
extern PFNGLLOADIDENTITYPROC glLoadIdentity;
extern PFNGLLOADMATRIXDPROC glLoadMatrixd;
extern PFNGLLOADMATRIXFPROC glLoadMatrixf;
extern PFNGLMULTMATRIXDPROC glMultMatrixd;
extern PFNGLMULTMATRIXFPROC glMultMatrixf;
extern PFNGLROTATEDPROC glRotated;
extern PFNGLROTATEFPROC glRotatef;
extern PFNGLSCALEDPROC glScaled;
extern PFNGLSCALEFPROC glScalef;
extern PFNGLTRANSLATEDPROC glTranslated;
extern PFNGLTRANSLATEFPROC glTranslatef;
extern PFNGLISLISTPROC glIsList;
extern PFNGLDELETELISTSPROC glDeleteLists;
extern PFNGLGENLISTSPROC glGenLists;
extern PFNGLNEWLISTPROC glNewList;
extern PFNGLENDLISTPROC glEndList;
extern PFNGLCALLLISTPROC glCallList;
extern PFNGLCALLLISTSPROC glCallLists;
extern PFNGLLISTBASEPROC glListBase;
extern PFNGLBEGINPROC glBegin;
extern PFNGLENDPROC glEnd;
extern PFNGLVERTEX2DPROC glVertex2d;
extern PFNGLVERTEX2FPROC glVertex2f;
extern PFNGLVERTEX2IPROC glVertex2i;
extern PFNGLVERTEX2SPROC glVertex2s;
extern PFNGLVERTEX3DPROC glVertex3d;
extern PFNGLVERTEX3FPROC glVertex3f;
extern PFNGLVERTEX3IPROC glVertex3i;
extern PFNGLVERTEX3SPROC glVertex3s;
extern PFNGLVERTEX4DPROC glVertex4d;
extern PFNGLVERTEX4FPROC glVertex4f;
extern PFNGLVERTEX4IPROC glVertex4i;
extern PFNGLVERTEX4SPROC glVertex4s;
extern PFNGLVERTEX2DVPROC glVertex2dv;
extern PFNGLVERTEX2FVPROC glVertex2fv;
extern PFNGLVERTEX2IVPROC glVertex2iv;
extern PFNGLVERTEX2SVPROC glVertex2sv;
extern PFNGLVERTEX3DVPROC glVertex3dv;
extern PFNGLVERTEX3FVPROC glVertex3fv;
extern PFNGLVERTEX3IVPROC glVertex3iv;
extern PFNGLVERTEX3SVPROC glVertex3sv;
extern PFNGLVERTEX4DVPROC glVertex4dv;
extern PFNGLVERTEX4FVPROC glVertex4fv;
extern PFNGLVERTEX4IVPROC glVertex4iv;
extern PFNGLVERTEX4SVPROC glVertex4sv;
extern PFNGLNORMAL3BPROC glNormal3b;
extern PFNGLNORMAL3DPROC glNormal3d;
extern PFNGLNORMAL3FPROC glNormal3f;
extern PFNGLNORMAL3IPROC glNormal3i;
extern PFNGLNORMAL3SPROC glNormal3s;
extern PFNGLNORMAL3BVPROC glNormal3bv;
extern PFNGLNORMAL3DVPROC glNormal3dv;
extern PFNGLNORMAL3FVPROC glNormal3fv;
extern PFNGLNORMAL3IVPROC glNormal3iv;
extern PFNGLNORMAL3SVPROC glNormal3sv;
extern PFNGLINDEXDPROC glIndexd;
extern PFNGLINDEXFPROC glIndexf;
extern PFNGLINDEXIPROC glIndexi;
extern PFNGLINDEXSPROC glIndexs;
extern PFNGLINDEXUBPROC glIndexub;
extern PFNGLINDEXDVPROC glIndexdv;
extern PFNGLINDEXFVPROC glIndexfv;
extern PFNGLINDEXIVPROC glIndexiv;
extern PFNGLINDEXSVPROC glIndexsv;
extern PFNGLINDEXUBVPROC glIndexubv;
extern PFNGLCOLOR3BPROC glColor3b;
extern PFNGLCOLOR3DPROC glColor3d;
extern PFNGLCOLOR3FPROC glColor3f;
extern PFNGLCOLOR3IPROC glColor3i;
extern PFNGLCOLOR3SPROC glColor3s;
extern PFNGLCOLOR3UBPROC glColor3ub;
extern PFNGLCOLOR3UIPROC glColor3ui;
extern PFNGLCOLOR3USPROC glColor3us;
extern PFNGLCOLOR4BPROC glColor4b;
extern PFNGLCOLOR4DPROC glColor4d;
extern PFNGLCOLOR4FPROC glColor4f;
extern PFNGLCOLOR4IPROC glColor4i;
extern PFNGLCOLOR4SPROC glColor4s;
extern PFNGLCOLOR4UBPROC glColor4ub;
extern PFNGLCOLOR4UIPROC glColor4ui;
extern PFNGLCOLOR4USPROC glColor4us;
extern PFNGLCOLOR3BVPROC glColor3bv;
extern PFNGLCOLOR3DVPROC glColor3dv;
extern PFNGLCOLOR3FVPROC glColor3fv;
extern PFNGLCOLOR3IVPROC glColor3iv;
extern PFNGLCOLOR3SVPROC glColor3sv;
extern PFNGLCOLOR3UBVPROC glColor3ubv;
extern PFNGLCOLOR3UIVPROC glColor3uiv;
extern PFNGLCOLOR3USVPROC glColor3usv;
extern PFNGLCOLOR4BVPROC glColor4bv;
extern PFNGLCOLOR4DVPROC glColor4dv;
extern PFNGLCOLOR4FVPROC glColor4fv;
extern PFNGLCOLOR4IVPROC glColor4iv;
extern PFNGLCOLOR4SVPROC glColor4sv;
extern PFNGLCOLOR4UBVPROC glColor4ubv;
extern PFNGLCOLOR4UIVPROC glColor4uiv;
extern PFNGLCOLOR4USVPROC glColor4usv;
extern PFNGLTEXCOORD1DPROC glTexCoord1d;
extern PFNGLTEXCOORD1FPROC glTexCoord1f;
extern PFNGLTEXCOORD1IPROC glTexCoord1i;
extern PFNGLTEXCOORD1SPROC glTexCoord1s;
extern PFNGLTEXCOORD2DPROC glTexCoord2d;
extern PFNGLTEXCOORD2FPROC glTexCoord2f;
extern PFNGLTEXCOORD2IPROC glTexCoord2i;
extern PFNGLTEXCOORD2SPROC glTexCoord2s;
extern PFNGLTEXCOORD3DPROC glTexCoord3d;
extern PFNGLTEXCOORD3FPROC glTexCoord3f;
extern PFNGLTEXCOORD3IPROC glTexCoord3i;
extern PFNGLTEXCOORD3SPROC glTexCoord3s;
extern PFNGLTEXCOORD4DPROC glTexCoord4d;
extern PFNGLTEXCOORD4FPROC glTexCoord4f;
extern PFNGLTEXCOORD4IPROC glTexCoord4i;
extern PFNGLTEXCOORD4SPROC glTexCoord4s;
extern PFNGLTEXCOORD1DVPROC glTexCoord1dv;
extern PFNGLTEXCOORD1FVPROC glTexCoord1fv;
extern PFNGLTEXCOORD1IVPROC glTexCoord1iv;
extern PFNGLTEXCOORD1SVPROC glTexCoord1sv;
extern PFNGLTEXCOORD2DVPROC glTexCoord2dv;
extern PFNGLTEXCOORD2FVPROC glTexCoord2fv;
extern PFNGLTEXCOORD2IVPROC glTexCoord2iv;
extern PFNGLTEXCOORD2SVPROC glTexCoord2sv;
extern PFNGLTEXCOORD3DVPROC glTexCoord3dv;
extern PFNGLTEXCOORD3FVPROC glTexCoord3fv;
extern PFNGLTEXCOORD3IVPROC glTexCoord3iv;
extern PFNGLTEXCOORD3SVPROC glTexCoord3sv;
extern PFNGLTEXCOORD4DVPROC glTexCoord4dv;
extern PFNGLTEXCOORD4FVPROC glTexCoord4fv;
extern PFNGLTEXCOORD4IVPROC glTexCoord4iv;
extern PFNGLTEXCOORD4SVPROC glTexCoord4sv;
extern PFNGLRASTERPOS2DPROC glRasterPos2d;
extern PFNGLRASTERPOS2FPROC glRasterPos2f;
extern PFNGLRASTERPOS2IPROC glRasterPos2i;
extern PFNGLRASTERPOS2SPROC glRasterPos2s;
extern PFNGLRASTERPOS3DPROC glRasterPos3d;
extern PFNGLRASTERPOS3FPROC glRasterPos3f;
extern PFNGLRASTERPOS3IPROC glRasterPos3i;
extern PFNGLRASTERPOS3SPROC glRasterPos3s;
extern PFNGLRASTERPOS4DPROC glRasterPos4d;
extern PFNGLRASTERPOS4FPROC glRasterPos4f;
extern PFNGLRASTERPOS4IPROC glRasterPos4i;
extern PFNGLRASTERPOS4SPROC glRasterPos4s;
extern PFNGLRASTERPOS2DVPROC glRasterPos2dv;
extern PFNGLRASTERPOS2FVPROC glRasterPos2fv;
extern PFNGLRASTERPOS2IVPROC glRasterPos2iv;
extern PFNGLRASTERPOS2SVPROC glRasterPos2sv;
extern PFNGLRASTERPOS3DVPROC glRasterPos3dv;
extern PFNGLRASTERPOS3FVPROC glRasterPos3fv;
extern PFNGLRASTERPOS3IVPROC glRasterPos3iv;
extern PFNGLRASTERPOS3SVPROC glRasterPos3sv;
extern PFNGLRASTERPOS4DVPROC glRasterPos4dv;
extern PFNGLRASTERPOS4FVPROC glRasterPos4fv;
extern PFNGLRASTERPOS4IVPROC glRasterPos4iv;
extern PFNGLRASTERPOS4SVPROC glRasterPos4sv;
extern PFNGLRECTDPROC glRectd;
extern PFNGLRECTFPROC glRectf;
extern PFNGLRECTIPROC glRecti;
extern PFNGLRECTSPROC glRects;
extern PFNGLRECTDVPROC glRectdv;
extern PFNGLRECTFVPROC glRectfv;
extern PFNGLRECTIVPROC glRectiv;
extern PFNGLRECTSVPROC glRectsv;
extern PFNGLVERTEXPOINTERPROC glVertexPointer;
extern PFNGLNORMALPOINTERPROC glNormalPointer;
extern PFNGLCOLORPOINTERPROC glColorPointer;
extern PFNGLINDEXPOINTERPROC glIndexPointer;
extern PFNGLTEXCOORDPOINTERPROC glTexCoordPointer;
extern PFNGLEDGEFLAGPOINTERPROC glEdgeFlagPointer;
extern PFNGLGETPOINTERVPROC glGetPointerv;
extern PFNGLARRAYELEMENTPROC glArrayElement;
extern PFNGLDRAWARRAYSPROC glDrawArrays;
extern PFNGLDRAWELEMENTSPROC glDrawElements;
extern PFNGLINTERLEAVEDARRAYSPROC glInterleavedArrays;
extern PFNGLSHADEMODELPROC glShadeModel;
extern PFNGLLIGHTFPROC glLightf;
extern PFNGLLIGHTIPROC glLighti;
extern PFNGLLIGHTFVPROC glLightfv;
extern PFNGLLIGHTIVPROC glLightiv;
extern PFNGLGETLIGHTFVPROC glGetLightfv;
extern PFNGLGETLIGHTIVPROC glGetLightiv;
extern PFNGLLIGHTMODELFPROC glLightModelf;
extern PFNGLLIGHTMODELIPROC glLightModeli;
extern PFNGLLIGHTMODELFVPROC glLightModelfv;
extern PFNGLLIGHTMODELIVPROC glLightModeliv;
extern PFNGLMATERIALFPROC glMaterialf;
extern PFNGLMATERIALIPROC glMateriali;
extern PFNGLMATERIALFVPROC glMaterialfv;
extern PFNGLMATERIALIVPROC glMaterialiv;
extern PFNGLGETMATERIALFVPROC glGetMaterialfv;
extern PFNGLGETMATERIALIVPROC glGetMaterialiv;
extern PFNGLCOLORMATERIALPROC glColorMaterial;
extern PFNGLPIXELZOOMPROC glPixelZoom;
extern PFNGLPIXELSTOREFPROC glPixelStoref;
extern PFNGLPIXELSTOREIPROC glPixelStorei;
extern PFNGLPIXELTRANSFERFPROC glPixelTransferf;
extern PFNGLPIXELTRANSFERIPROC glPixelTransferi;
extern PFNGLPIXELMAPFVPROC glPixelMapfv;
extern PFNGLPIXELMAPUIVPROC glPixelMapuiv;
extern PFNGLPIXELMAPUSVPROC glPixelMapusv;
extern PFNGLGETPIXELMAPFVPROC glGetPixelMapfv;
extern PFNGLGETPIXELMAPUIVPROC glGetPixelMapuiv;
extern PFNGLGETPIXELMAPUSVPROC glGetPixelMapusv;
extern PFNGLBITMAPPROC glBitmap;
extern PFNGLREADPIXELSPROC glReadPixels;
extern PFNGLDRAWPIXELSPROC glDrawPixels;
extern PFNGLCOPYPIXELSPROC glCopyPixels;
extern PFNGLSTENCILFUNCPROC glStencilFunc;
extern PFNGLSTENCILMASKPROC glStencilMask;
extern PFNGLSTENCILOPPROC glStencilOp;
extern PFNGLCLEARSTENCILPROC glClearStencil;
extern PFNGLTEXGENDPROC glTexGend;
extern PFNGLTEXGENFPROC glTexGenf;
extern PFNGLTEXGENIPROC glTexGeni;
extern PFNGLTEXGENDVPROC glTexGendv;
extern PFNGLTEXGENFVPROC glTexGenfv;
extern PFNGLTEXGENIVPROC glTexGeniv;
extern PFNGLGETTEXGENDVPROC glGetTexGendv;
extern PFNGLGETTEXGENFVPROC glGetTexGenfv;
extern PFNGLGETTEXGENIVPROC glGetTexGeniv;
extern PFNGLTEXENVFPROC glTexEnvf;
extern PFNGLTEXENVIPROC glTexEnvi;
extern PFNGLTEXENVFVPROC glTexEnvfv;
extern PFNGLTEXENVIVPROC glTexEnviv;
extern PFNGLGETTEXENVFVPROC glGetTexEnvfv;
extern PFNGLGETTEXENVIVPROC glGetTexEnviv;
extern PFNGLTEXPARAMETERFPROC glTexParameterf;
extern PFNGLTEXPARAMETERIPROC glTexParameteri;
extern PFNGLTEXPARAMETERFVPROC glTexParameterfv;
extern PFNGLTEXPARAMETERIVPROC glTexParameteriv;
extern PFNGLGETTEXPARAMETERFVPROC glGetTexParameterfv;
extern PFNGLGETTEXPARAMETERIVPROC glGetTexParameteriv;
extern PFNGLGETTEXLEVELPARAMETERFVPROC glGetTexLevelParameterfv;
extern PFNGLGETTEXLEVELPARAMETERIVPROC glGetTexLevelParameteriv;
extern PFNGLTEXIMAGE1DPROC glTexImage1D;
extern PFNGLTEXIMAGE2DPROC glTexImage2D;
extern PFNGLGETTEXIMAGEPROC glGetTexImage;
extern PFNGLGENTEXTURESPROC glGenTextures;
extern PFNGLDELETETEXTURESPROC glDeleteTextures;
extern PFNGLBINDTEXTUREPROC glBindTexture;
extern PFNGLPRIORITIZETEXTURESPROC glPrioritizeTextures;
extern PFNGLARETEXTURESRESIDENTPROC glAreTexturesResident;
extern PFNGLISTEXTUREPROC glIsTexture;
extern PFNGLTEXSUBIMAGE1DPROC glTexSubImage1D;
extern PFNGLTEXSUBIMAGE2DPROC glTexSubImage2D;
extern PFNGLCOPYTEXIMAGE1DPROC glCopyTexImage1D;
extern PFNGLCOPYTEXIMAGE2DPROC glCopyTexImage2D;
extern PFNGLCOPYTEXSUBIMAGE1DPROC glCopyTexSubImage1D;
extern PFNGLCOPYTEXSUBIMAGE2DPROC glCopyTexSubImage2D;
extern PFNGLMAP1DPROC glMap1d;
extern PFNGLMAP1FPROC glMap1f;
extern PFNGLMAP2DPROC glMap2d;
extern PFNGLMAP2FPROC glMap2f;
extern PFNGLGETMAPDVPROC glGetMapdv;
extern PFNGLGETMAPFVPROC glGetMapfv;
extern PFNGLGETMAPIVPROC glGetMapiv;
extern PFNGLEVALCOORD1DPROC glEvalCoord1d;
extern PFNGLEVALCOORD1FPROC glEvalCoord1f;
extern PFNGLEVALCOORD1DVPROC glEvalCoord1dv;
extern PFNGLEVALCOORD1FVPROC glEvalCoord1fv;
extern PFNGLEVALCOORD2DPROC glEvalCoord2d;
extern PFNGLEVALCOORD2FPROC glEvalCoord2f;
extern PFNGLEVALCOORD2DVPROC glEvalCoord2dv;
extern PFNGLEVALCOORD2FVPROC glEvalCoord2fv;
extern PFNGLMAPGRID1DPROC glMapGrid1d;
extern PFNGLMAPGRID1FPROC glMapGrid1f;
extern PFNGLMAPGRID2DPROC glMapGrid2d;
extern PFNGLMAPGRID2FPROC glMapGrid2f;
extern PFNGLEVALPOINT1PROC glEvalPoint1;
extern PFNGLEVALPOINT2PROC glEvalPoint2;
extern PFNGLEVALMESH1PROC glEvalMesh1;
extern PFNGLEVALMESH2PROC glEvalMesh2;
extern PFNGLFOGFPROC glFogf;
extern PFNGLFOGIPROC glFogi;
extern PFNGLFOGFVPROC glFogfv;
extern PFNGLFOGIVPROC glFogiv;
extern PFNGLFEEDBACKBUFFERPROC glFeedbackBuffer;
extern PFNGLPASSTHROUGHPROC glPassThrough;
extern PFNGLSELECTBUFFERPROC glSelectBuffer;
extern PFNGLINITNAMESPROC glInitNames;
extern PFNGLLOADNAMEPROC glLoadName;
extern PFNGLPUSHNAMEPROC glPushName;
extern PFNGLPOPNAMEPROC glPopName;

