/******************************************************************************
 *
 * Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *****************************************************************************
 * Originally developed and contributed by Ittiam Systems Pvt. Ltd, Bangalore
*/


/**
******************************************************************************
* @file
*  ih264_cabac_tables.c
*
* @brief
*  This file contains H264 cabac tables for init contexts, rlps and
*  cabac state transitions
*
* @author
*   Ittiam
*
* @par List of Tables
*   - gau4_ih264_cabac_table[][]
*   - gau1_ih264_cabac_ctxt_init_table[][][]
*
******************************************************************************
*/


/*****************************************************************************/
/* File Includes                                                             */
/*****************************************************************************/

/* User include files */
#include "ih264_typedefs.h"
#include "ih264_cabac_tables.h"


/*****************************************************************************/
/* Extern global definitions                                                 */
/*****************************************************************************/
/*****************************************************************************/
/*  CABAC TABLES                                                             */
/*****************************************************************************/
/*combined table :guc_RTAB,NextStateLPS,NextStateMPS
 input(combined_state):
 bits 0-5: state
 bits 6:mps
 output
 bits 0-7:rangeTabLPS
 bits 8-14 :combined_next_state_if_mps
 bits 15 -21:combined_next_state_if_lps

 */

const UWORD32 gau4_ih264_cabac_table[128][4] =
    {
        { 2097536, 2097584, 2097616, 2097648 },

          { 640, 679, 709, 739 },

          { 33664, 33694, 33723, 33752 },

          { 66683, 66710, 66738, 66765 },

          { 66932, 66958, 66985, 67011 },

          { 132719, 132743, 132768, 132793 },

          { 132969, 132992, 133016, 133039 },

          { 165988, 166010, 166032, 166054 },

          { 199007, 199028, 199049, 199070 },

          { 232026, 232046, 232066, 232086 },

          { 265045, 265064, 265083, 265102 },

          { 298065, 298083, 298101, 298119 },

          { 298317, 298334, 298351, 298368 },

          { 364105, 364121, 364137, 364154 },

          { 364357, 364373, 364388, 364404 },

          { 397378, 397392, 397407, 397422 },

          { 430398, 430412, 430426, 430440 },

          { 430651, 430664, 430678, 430691 },

          { 496440, 496453, 496465, 496478 },

          { 496693, 496705, 496717, 496729 },

          { 529715, 529726, 529737, 529749 },

          { 529968, 529979, 529989, 530000 },

          { 595758, 595768, 595778, 595788 },

          { 596011, 596021, 596031, 596040 },

          { 629033, 629042, 629051, 629061 },

          { 629287, 629296, 629304, 629313 },

          { 695077, 695085, 695094, 695102 },

          { 695331, 695339, 695347, 695355 },

          { 728353, 728361, 728368, 728376 },

          { 728608, 728615, 728622, 728629 },

          { 761630, 761637, 761643, 761650 },

          { 794653, 794659, 794665, 794672 },

          { 794907, 794913, 794919, 794925 },

          { 827930, 827935, 827941, 827947 },

          { 860952, 860958, 860963, 860969 },

          { 861207, 861212, 861217, 861223 },

          { 894230, 894235, 894240, 894245 },

          { 894485, 894490, 894494, 894499 },

          { 927508, 927512, 927517, 927521 },

          { 960531, 960535, 960539, 960543 },

          { 960786, 960790, 960794, 960798 },

          { 993809, 993813, 993817, 993820 },

          { 994064, 994068, 994071, 994075 },

          { 994319, 994323, 994326, 994329 },

          { 1027342, 1027346, 1027349, 1027352 },

          { 1060366, 1060369, 1060372, 1060375 },

          { 1060621, 1060624, 1060627, 1060630 },

          { 1093644, 1093647, 1093650, 1093653 },

          { 1093900, 1093902, 1093905, 1093908 },

          { 1094155, 1094158, 1094160, 1094163 },

          { 1127179, 1127181, 1127183, 1127186 },

          { 1127434, 1127436, 1127439, 1127441 },

          { 1160458, 1160460, 1160462, 1160464 },

          { 1160713, 1160715, 1160717, 1160719 },

          { 1160969, 1160971, 1160972, 1160974 },

          { 1193992, 1193994, 1193996, 1193998 },

          { 1194248, 1194249, 1194251, 1194253 },

          { 1194503, 1194505, 1194507, 1194508 },

          { 1227527, 1227529, 1227530, 1227532 },

          { 1227783, 1227784, 1227786, 1227787 },

          { 1228038, 1228040, 1228041, 1228043 },

          { 1261062, 1261063, 1261065, 1261066 },

          { 1261062, 1261063, 1261064, 1261065 },

          { 2080514, 2080514, 2080514, 2080514 },

          { 16768, 16816, 16848, 16880 },

          { 2114176, 2114215, 2114245, 2114275 },

          { 2147200, 2147230, 2147259, 2147288 },

          { 2180219, 2180246, 2180274, 2180301 },

          { 2180468, 2180494, 2180521, 2180547 },

          { 2246255, 2246279, 2246304, 2246329 },

          { 2246505, 2246528, 2246552, 2246575 },

          { 2279524, 2279546, 2279568, 2279590 },

          { 2312543, 2312564, 2312585, 2312606 },

          { 2345562, 2345582, 2345602, 2345622 },

          { 2378581, 2378600, 2378619, 2378638 },

          { 2411601, 2411619, 2411637, 2411655 },

          { 2411853, 2411870, 2411887, 2411904 },

          { 2477641, 2477657, 2477673, 2477690 },

          { 2477893, 2477909, 2477924, 2477940 },

          { 2510914, 2510928, 2510943, 2510958 },

          { 2543934, 2543948, 2543962, 2543976 },

          { 2544187, 2544200, 2544214, 2544227 },

          { 2609976, 2609989, 2610001, 2610014 },

          { 2610229, 2610241, 2610253, 2610265 },

          { 2643251, 2643262, 2643273, 2643285 },

          { 2643504, 2643515, 2643525, 2643536 },

          { 2709294, 2709304, 2709314, 2709324 },

          { 2709547, 2709557, 2709567, 2709576 },

          { 2742569, 2742578, 2742587, 2742597 },

          { 2742823, 2742832, 2742840, 2742849 },

          { 2808613, 2808621, 2808630, 2808638 },

          { 2808867, 2808875, 2808883, 2808891 },

          { 2841889, 2841897, 2841904, 2841912 },

          { 2842144, 2842151, 2842158, 2842165 },

          { 2875166, 2875173, 2875179, 2875186 },

          { 2908189, 2908195, 2908201, 2908208 },

          { 2908443, 2908449, 2908455, 2908461 },

          { 2941466, 2941471, 2941477, 2941483 },

          { 2974488, 2974494, 2974499, 2974505 },

          { 2974743, 2974748, 2974753, 2974759 },

          { 3007766, 3007771, 3007776, 3007781 },

          { 3008021, 3008026, 3008030, 3008035 },

          { 3041044, 3041048, 3041053, 3041057 },

          { 3074067, 3074071, 3074075, 3074079 },

          { 3074322, 3074326, 3074330, 3074334 },

          { 3107345, 3107349, 3107353, 3107356 },

          { 3107600, 3107604, 3107607, 3107611 },

          { 3107855, 3107859, 3107862, 3107865 },

          { 3140878, 3140882, 3140885, 3140888 },

          { 3173902, 3173905, 3173908, 3173911 },

          { 3174157, 3174160, 3174163, 3174166 },

          { 3207180, 3207183, 3207186, 3207189 },

          { 3207436, 3207438, 3207441, 3207444 },

          { 3207691, 3207694, 3207696, 3207699 },

          { 3240715, 3240717, 3240719, 3240722 },

          { 3240970, 3240972, 3240975, 3240977 },

          { 3273994, 3273996, 3273998, 3274000 },

          { 3274249, 3274251, 3274253, 3274255 },

          { 3274505, 3274507, 3274508, 3274510 },

          { 3307528, 3307530, 3307532, 3307534 },

          { 3307784, 3307785, 3307787, 3307789 },

          { 3308039, 3308041, 3308043, 3308044 },

          { 3341063, 3341065, 3341066, 3341068 },

          { 3341319, 3341320, 3341322, 3341323 },

          { 3341574, 3341576, 3341577, 3341579 },

          { 3374598, 3374599, 3374601, 3374602 },

          { 3374598, 3374599, 3374600, 3374601 },

          { 4194050, 4194050, 4194050, 4194050 },

    };

/*****************************************************************************/
/* Global Variable Initialization                                            */
/*****************************************************************************/
const UWORD8 gau1_ih264_cabac_ctxt_init_table[NUM_CAB_INIT_IDC_PLUS_ONE][QP_RANGE][NUM_CABAC_CTXTS] =

                    {

                        {

                            {

                            62,
                              9, 74, 62, 9, 74, 126, 104, 10, 9, 12, 30, 61, 62,
                              54, 14, 118, 6, 78, 65, 1, 14, 73, 13, 64, 20, 62,
                              67, 90, 104, 126, 104, 67, 78, 65, 1, 86, 95, 2,
                              18, 69, 81, 96, 8, 67, 86, 88, 5, 76, 94, 9, 69,
                              81, 88, 67, 74, 74, 80, 72, 5, 22, 0, 0, 0, 83,
                              86, 97, 72, 22, 1, 18, 78, 96, 126, 98, 101, 67,
                              82, 94, 83, 110, 91, 102, 93, 126, 92, 89, 96,
                              108, 17, 65, 6, 93, 74, 92, 87, 126, 9, 3, 4, 69,
                              15, 68, 69, 88, 85, 78, 75, 77, 9, 13, 68, 13, 21,
                              81, 0, 70, 67, 6, 76, 28, 64, 2, 28, 38, 39, 34,
                              27, 93, 73, 73, 17, 14, 100, 10, 10, 10, 2, 7, 7,
                              0, 3, 1, 6, 69, 6, 24, 12, 68, 64, 2, 0, 13, 24,
                              19, 11, 15, 3, 4, 4, 30, 19, 20, 78, 3, 69, 35,
                              23, 19, 14, 17, 19, 12, 16, 24, 1, 17, 9, 9, 5, 0,
                              12, 6, 10, 11, 8, 18, 27, 10, 82, 8, 78, 17, 32,
                              84, 56, 62, 60, 59, 62, 62, 57, 57, 54, 44, 36,
                              33, 43, 29, 70, 67, 4, 67, 33, 31, 28, 34, 32, 25,
                              20, 22, 0, 4, 64, 94, 89, 108, 76, 19, 18, 11, 64,
                              4, 70, 75, 82, 102, 77, 39, 21, 15, 8, 4, 71, 83,
                              87, 119, 5, 34, 27, 25, 20, 8, 5, 64, 74, 90, 70,
                              34, 32, 21, 4, 5, 72, 81, 97, 5, 58, 49, 45, 36,
                              23, 5, 70, 79, 85, 62, 106, 106, 87, 114, 110, 98,
                              110, 106, 103, 107, 108, 112, 96, 95, 91, 93, 94,
                              86, 67, 80, 85, 70, 3, 5, 2, 13, 13, 14, 9, 22,
                              17, 12, 14, 11, 22, 16, 8, 22, 19, 13, 10, 14, 0,
                              64, 69, 4, 70, 19, 32, 20, 10, 29, 25, 11, 23, 31,
                              19, 25, 13, 6, 20, 52, 49, 52, 52, 54, 62, 62, 62,
                              62, 62, 62, 62, 62, 62, 34, 62, 62, 62, 62, 62,
                              62, 54, 37, 36, 6, 82, 75, 97, 125, 62, 62, 62,
                              57, 55, 53, 41, 44, 31, 32, 22, 19, 16, 65, 71, 3,
                              0, 65, 39, 43, 40, 31, 40, 39, 23, 31, 34, 21, 6,
                              10, 2, 86, 23, 12, 4, 79, 71, 69, 70, 66, 68, 73,
                              69, 70, 67, 1, 70, 66, 65, 0, 62, 62, 62, 62, 62,
                              60, 54, 36, 4, 66, 28, 21, 18, 15, 7, 3, 1, 66,
                              76, 85, 81, 77, 81, 80, 73, 74, 83, 71, 67, 2, 66,
                              66, 4, 4, 62, 62, 62, 62, 61, 57, 46, 29, 1 },

                              {

                              62,
                                9, 74, 62, 9, 74, 125, 102, 11, 10, 12, 29, 60,
                                62, 54, 14, 115, 6, 77, 64, 1, 14, 72, 12, 65,
                                20, 62, 68, 91, 104, 124, 102, 67, 77, 64, 1,
                                85, 93, 3, 18, 68, 80, 95, 8, 67, 85, 88, 5, 75,
                                93, 9, 69, 80, 88, 66, 73, 73, 79, 71, 5, 22, 0,
                                0, 0, 82, 86, 97, 71, 22, 1, 18, 77, 95, 124,
                                96, 99, 65, 80, 92, 82, 108, 89, 100, 92, 125,
                                91, 88, 95, 107, 18, 64, 7, 92, 73, 91, 86, 124,
                                9, 3, 4, 69, 16, 68, 68, 87, 84, 77, 74, 76, 9,
                                13, 67, 13, 21, 80, 0, 69, 67, 6, 75, 28, 64, 2,
                                28, 37, 39, 34, 27, 92, 72, 72, 17, 14, 99, 10,
                                10, 10, 3, 7, 7, 1, 4, 2, 6, 68, 6, 24, 12, 68,
                                64, 2, 0, 13, 23, 19, 11, 15, 4, 5, 4, 29, 19,
                                20, 77, 3, 69, 35, 23, 19, 14, 17, 19, 12, 16,
                                24, 1, 17, 9, 9, 5, 0, 12, 6, 10, 11, 8, 18, 27,
                                10, 81, 8, 77, 17, 31, 83, 55, 62, 59, 58, 61,
                                62, 56, 56, 52, 43, 35, 32, 41, 28, 71, 67, 4,
                                67, 32, 30, 27, 33, 31, 24, 19, 21, 0, 4, 64,
                                93, 88, 107, 75, 20, 18, 11, 0, 5, 69, 74, 81,
                                100, 76, 39, 21, 15, 8, 5, 70, 82, 86, 117, 5,
                                35, 28, 25, 20, 9, 5, 64, 73, 89, 70, 35, 32,
                                21, 4, 6, 71, 80, 96, 5, 58, 49, 45, 36, 23, 5,
                                69, 78, 84, 62, 105, 105, 86, 112, 108, 97, 108,
                                104, 101, 105, 106, 110, 95, 94, 90, 92, 92, 85,
                                67, 79, 84, 69, 3, 5, 2, 13, 13, 13, 8, 22, 17,
                                13, 14, 11, 22, 16, 8, 22, 19, 13, 10, 14, 0,
                                64, 68, 5, 70, 19, 32, 20, 10, 29, 25, 12, 23,
                                30, 19, 25, 13, 6, 19, 52, 49, 52, 51, 53, 62,
                                62, 62, 62, 62, 62, 62, 62, 62, 33, 62, 62, 62,
                                62, 62, 62, 53, 36, 35, 6, 81, 74, 95, 122, 62,
                                62, 62, 56, 53, 52, 40, 42, 30, 31, 21, 18, 15,
                                66, 71, 3, 0, 66, 38, 42, 39, 30, 39, 38, 22,
                                30, 33, 20, 5, 9, 1, 86, 23, 12, 4, 78, 70, 68,
                                69, 65, 67, 71, 68, 69, 66, 3, 68, 65, 0, 2, 62,
                                62, 62, 62, 62, 58, 51, 34, 2, 65, 29, 22, 19,
                                16, 8, 4, 2, 65, 75, 84, 80, 76, 80, 78, 71, 73,
                                82, 70, 66, 3, 65, 65, 4, 4, 62, 62, 62, 62, 58,
                                54, 43, 26, 64 },

                              {

                              62,
                                9, 74, 62, 9, 74, 123, 101, 11, 10, 12, 28, 59,
                                61, 54, 14, 113, 6, 76, 0, 1, 13, 72, 11, 66,
                                19, 60, 70, 92, 105, 121, 101, 67, 76, 0, 1, 85,
                                92, 3, 17, 68, 80, 94, 8, 67, 85, 88, 5, 75, 92,
                                9, 69, 80, 88, 66, 73, 73, 79, 71, 5, 22, 0, 0,
                                0, 81, 86, 97, 71, 21, 1, 18, 77, 95, 122, 94,
                                97, 64, 78, 91, 81, 107, 88, 99, 91, 123, 91,
                                88, 95, 106, 18, 64, 7, 91, 73, 90, 86, 123, 9,
                                3, 4, 69, 16, 68, 68, 87, 84, 77, 74, 76, 9, 13,
                                67, 13, 21, 80, 0, 69, 67, 6, 75, 27, 64, 2, 27,
                                36, 38, 33, 26, 91, 72, 72, 16, 13, 99, 9, 10,
                                10, 3, 7, 7, 2, 4, 2, 6, 68, 6, 23, 12, 69, 64,
                                2, 64, 13, 22, 19, 11, 14, 4, 5, 4, 28, 19, 19,
                                77, 3, 70, 34, 23, 19, 14, 17, 19, 12, 16, 24,
                                1, 17, 9, 9, 5, 0, 12, 6, 10, 11, 8, 17, 26, 9,
                                81, 8, 77, 16, 30, 83, 53, 62, 57, 56, 59, 60,
                                54, 54, 50, 41, 33, 30, 39, 26, 72, 67, 4, 68,
                                31, 29, 26, 32, 29, 23, 18, 20, 64, 3, 65, 93,
                                88, 106, 75, 20, 18, 11, 0, 5, 69, 74, 81, 99,
                                75, 39, 21, 15, 8, 5, 70, 81, 85, 115, 5, 35,
                                28, 25, 20, 9, 5, 64, 73, 88, 70, 35, 32, 21, 4,
                                6, 71, 80, 95, 5, 57, 48, 44, 35, 23, 5, 69, 78,
                                84, 62, 104, 104, 85, 111, 107, 96, 107, 103,
                                100, 104, 105, 108, 94, 93, 90, 91, 91, 85, 68,
                                79, 83, 69, 3, 4, 2, 12, 12, 12, 7, 21, 17, 13,
                                14, 10, 21, 16, 8, 21, 18, 13, 10, 13, 0, 64,
                                68, 5, 70, 18, 31, 19, 10, 28, 24, 12, 22, 29,
                                19, 25, 12, 5, 17, 51, 48, 51, 50, 52, 62, 62,
                                62, 62, 62, 62, 62, 62, 62, 32, 62, 62, 62, 62,
                                62, 62, 51, 35, 34, 6, 80, 74, 94, 120, 60, 60,
                                62, 54, 51, 50, 38, 40, 29, 29, 20, 16, 14, 67,
                                72, 2, 0, 67, 37, 41, 37, 28, 37, 36, 21, 28,
                                31, 19, 4, 8, 0, 87, 22, 11, 3, 78, 70, 68, 68,
                                65, 66, 70, 67, 68, 65, 4, 67, 64, 1, 3, 62, 62,
                                62, 62, 60, 55, 48, 31, 0, 65, 29, 22, 19, 16,
                                9, 4, 2, 65, 75, 84, 80, 75, 80, 77, 70, 73, 81,
                                69, 65, 3, 65, 64, 4, 4, 62, 62, 62, 60, 55, 50,
                                39, 23, 67 },

                              {

                              62,
                                9, 74, 62, 9, 74, 121, 99, 12, 10, 11, 26, 57,
                                60, 54, 14, 111, 6, 75, 1, 1, 12, 72, 10, 67,
                                19, 58, 71, 93, 105, 118, 100, 67, 75, 1, 1, 84,
                                91, 4, 17, 68, 79, 93, 7, 68, 85, 88, 5, 75, 92,
                                9, 69, 80, 88, 65, 73, 73, 79, 70, 5, 22, 0, 0,
                                0, 81, 86, 97, 70, 20, 1, 18, 77, 95, 120, 92,
                                96, 1, 76, 90, 80, 105, 87, 98, 90, 121, 90, 88,
                                94, 105, 18, 64, 7, 91, 73, 90, 85, 121, 9, 2,
                                3, 70, 16, 68, 68, 86, 84, 76, 74, 75, 9, 13,
                                67, 13, 20, 80, 0, 69, 67, 6, 75, 26, 64, 2, 26,
                                35, 37, 32, 25, 91, 71, 72, 15, 13, 98, 9, 10,
                                10, 3, 7, 7, 3, 4, 2, 6, 67, 6, 22, 12, 70, 64,
                                2, 64, 12, 21, 19, 11, 13, 4, 5, 4, 26, 19, 18,
                                77, 3, 70, 33, 23, 19, 14, 17, 19, 12, 16, 24,
                                1, 16, 9, 9, 5, 0, 11, 5, 9, 10, 7, 16, 25, 9,
                                81, 7, 77, 15, 28, 83, 52, 62, 55, 54, 57, 58,
                                52, 52, 48, 39, 32, 29, 37, 24, 73, 67, 4, 68,
                                30, 28, 25, 30, 28, 21, 17, 19, 65, 3, 65, 93,
                                88, 106, 74, 20, 18, 11, 0, 5, 69, 74, 80, 98,
                                75, 39, 21, 15, 8, 6, 69, 80, 84, 113, 5, 35,
                                28, 25, 20, 10, 5, 64, 73, 88, 70, 35, 32, 20,
                                4, 6, 71, 80, 94, 5, 57, 48, 43, 34, 23, 5, 69,
                                77, 83, 62, 103, 103, 85, 110, 106, 95, 105,
                                102, 99, 103, 103, 107, 94, 92, 90, 91, 89, 85,
                                68, 79, 83, 69, 2, 4, 2, 11, 11, 11, 6, 21, 16,
                                13, 13, 10, 21, 15, 8, 20, 18, 12, 10, 12, 0,
                                65, 68, 5, 71, 18, 31, 18, 10, 27, 24, 12, 21,
                                28, 18, 24, 11, 5, 16, 50, 47, 51, 49, 51, 61,
                                62, 62, 62, 62, 62, 62, 62, 62, 31, 62, 62, 62,
                                62, 62, 62, 49, 34, 33, 6, 79, 74, 93, 118, 58,
                                58, 62, 52, 49, 48, 37, 38, 27, 28, 19, 15, 12,
                                68, 73, 2, 64, 68, 36, 39, 36, 26, 35, 34, 19,
                                27, 29, 17, 3, 6, 65, 88, 21, 10, 2, 78, 69, 68,
                                68, 64, 66, 69, 66, 67, 64, 5, 66, 0, 3, 4, 62,
                                62, 62, 62, 58, 52, 45, 28, 65, 64, 30, 23, 20,
                                16, 10, 5, 2, 64, 74, 84, 79, 75, 79, 76, 69,
                                73, 81, 69, 65, 3, 64, 0, 4, 4, 62, 62, 62, 57,
                                52, 46, 35, 19, 69 },

                              {

                              62,
                                9, 74, 62, 9, 74, 120, 98, 12, 10, 11, 25, 56,
                                58, 54, 14, 108, 5, 74, 1, 1, 11, 72, 9, 68, 18,
                                56, 73, 94, 106, 115, 99, 67, 74, 1, 1, 84, 90,
                                4, 16, 68, 79, 93, 7, 68, 84, 88, 5, 75, 91, 8,
                                70, 80, 88, 65, 72, 73, 78, 70, 5, 22, 0, 0, 0,
                                80, 87, 97, 70, 19, 1, 18, 77, 95, 119, 91, 94,
                                2, 75, 89, 79, 104, 85, 97, 89, 119, 90, 87, 94,
                                104, 18, 64, 7, 90, 73, 89, 85, 120, 8, 2, 3,
                                70, 16, 68, 68, 86, 84, 76, 74, 75, 9, 12, 67,
                                13, 20, 80, 0, 69, 67, 6, 75, 26, 65, 2, 26, 34,
                                36, 31, 24, 90, 71, 72, 14, 12, 98, 8, 10, 9, 3,
                                7, 7, 4, 5, 2, 5, 67, 5, 21, 11, 71, 64, 2, 65,
                                12, 20, 18, 10, 13, 5, 5, 4, 25, 18, 17, 77, 3,
                                71, 33, 23, 19, 14, 17, 19, 12, 16, 23, 1, 16,
                                9, 9, 5, 64, 11, 5, 9, 10, 7, 16, 24, 8, 81, 7,
                                77, 14, 27, 83, 50, 62, 53, 52, 55, 56, 50, 50,
                                46, 37, 30, 27, 34, 22, 74, 67, 3, 69, 29, 27,
                                24, 29, 26, 20, 16, 17, 65, 2, 66, 93, 88, 105,
                                74, 20, 18, 11, 0, 5, 69, 74, 80, 97, 74, 39,
                                21, 15, 8, 6, 69, 80, 84, 111, 5, 35, 28, 25,
                                20, 10, 5, 64, 73, 87, 70, 35, 31, 20, 4, 6, 71,
                                80, 94, 5, 56, 47, 42, 33, 23, 5, 69, 77, 83,
                                62, 102, 102, 84, 108, 105, 94, 104, 100, 98,
                                101, 102, 105, 93, 92, 89, 90, 88, 84, 69, 79,
                                82, 69, 2, 3, 1, 10, 10, 10, 5, 20, 16, 13, 13,
                                9, 20, 15, 8, 19, 17, 12, 9, 11, 64, 65, 68, 5,
                                71, 17, 30, 17, 10, 26, 23, 12, 20, 27, 18, 24,
                                10, 4, 14, 49, 47, 50, 48, 49, 60, 62, 62, 62,
                                62, 62, 62, 62, 62, 29, 62, 62, 62, 62, 62, 62,
                                47, 33, 31, 6, 78, 73, 92, 116, 57, 56, 60, 51,
                                47, 46, 35, 36, 26, 26, 17, 13, 11, 69, 74, 1,
                                64, 69, 34, 38, 34, 25, 33, 32, 18, 25, 27, 16,
                                2, 5, 66, 88, 20, 10, 1, 78, 69, 67, 67, 64, 65,
                                68, 66, 66, 0, 6, 65, 1, 4, 5, 62, 62, 62, 61,
                                55, 49, 42, 25, 68, 64, 30, 23, 20, 17, 10, 5,
                                3, 64, 74, 83, 79, 74, 79, 75, 68, 73, 80, 68,
                                64, 3, 64, 1, 4, 4, 62, 62, 61, 54, 49, 42, 31,
                                16, 72 },

                              {

                              62,
                                9, 74, 62, 9, 74, 118, 96, 12, 10, 10, 23, 54,
                                57, 54, 14, 106, 5, 73, 2, 1, 11, 71, 8, 69, 18,
                                54, 75, 95, 106, 112, 97, 67, 73, 2, 1, 84, 89,
                                4, 16, 68, 79, 92, 7, 69, 84, 88, 5, 75, 90, 8,
                                70, 80, 88, 64, 72, 72, 78, 69, 5, 22, 0, 0, 0,
                                80, 87, 97, 69, 18, 1, 18, 76, 95, 117, 89, 93,
                                4, 73, 87, 78, 103, 84, 96, 88, 117, 89, 87, 93,
                                103, 18, 64, 7, 90, 73, 89, 84, 118, 8, 2, 3,
                                70, 16, 68, 67, 85, 84, 76, 74, 74, 9, 12, 67,
                                13, 20, 79, 0, 68, 67, 6, 75, 25, 65, 2, 25, 33,
                                36, 30, 23, 89, 70, 72, 13, 12, 97, 8, 10, 9, 3,
                                7, 7, 5, 5, 2, 5, 67, 5, 20, 11, 72, 64, 2, 65,
                                11, 19, 18, 10, 12, 5, 5, 4, 24, 18, 16, 77, 3,
                                71, 32, 23, 19, 14, 17, 19, 12, 16, 23, 1, 16,
                                9, 9, 5, 64, 11, 5, 8, 10, 7, 15, 23, 8, 81, 6,
                                77, 13, 26, 83, 49, 61, 52, 51, 53, 54, 48, 48,
                                44, 35, 28, 25, 32, 21, 75, 67, 3, 69, 28, 26,
                                23, 28, 25, 18, 15, 16, 66, 2, 66, 93, 88, 105,
                                74, 20, 18, 11, 0, 5, 68, 73, 79, 96, 74, 39,
                                21, 15, 8, 6, 68, 79, 83, 109, 5, 35, 28, 25,
                                20, 10, 5, 64, 73, 86, 70, 36, 31, 19, 4, 6, 71,
                                80, 93, 5, 56, 46, 41, 32, 23, 5, 69, 77, 82,
                                62, 101, 101, 83, 107, 104, 93, 103, 99, 97,
                                100, 100, 103, 92, 91, 89, 90, 87, 84, 69, 78,
                                81, 69, 1, 3, 1, 10, 9, 9, 4, 19, 15, 13, 12, 9,
                                20, 15, 8, 18, 16, 12, 9, 10, 64, 65, 68, 5, 71,
                                16, 30, 17, 10, 25, 22, 12, 19, 26, 17, 23, 9,
                                3, 12, 48, 46, 50, 47, 48, 58, 62, 62, 62, 62,
                                62, 62, 62, 62, 28, 62, 62, 62, 62, 62, 61, 45,
                                32, 30, 6, 77, 73, 91, 114, 55, 55, 58, 49, 45,
                                44, 34, 34, 25, 24, 16, 11, 9, 70, 75, 1, 64,
                                70, 33, 36, 32, 23, 32, 31, 16, 24, 26, 14, 1,
                                4, 67, 89, 20, 9, 0, 77, 68, 67, 67, 0, 64, 67,
                                65, 65, 1, 8, 64, 2, 5, 7, 62, 62, 62, 58, 53,
                                46, 39, 22, 70, 64, 31, 24, 21, 17, 11, 5, 3, 0,
                                73, 83, 79, 73, 78, 74, 67, 72, 79, 68, 64, 3,
                                0, 2, 4, 4, 62, 62, 58, 51, 46, 39, 27, 12, 75 },

                              {

                              62,
                                9, 75, 62, 9, 75, 116, 95, 13, 10, 10, 22, 53,
                                56, 54, 14, 104, 5, 73, 3, 1, 10, 71, 7, 70, 17,
                                53, 76, 96, 107, 109, 96, 67, 73, 3, 1, 83, 88,
                                5, 15, 67, 78, 91, 6, 69, 84, 88, 5, 74, 90, 8,
                                70, 79, 88, 64, 72, 72, 78, 69, 5, 22, 0, 0, 0,
                                79, 87, 97, 69, 18, 0, 18, 76, 94, 115, 87, 91,
                                5, 71, 86, 77, 101, 83, 95, 88, 116, 89, 87, 93,
                                103, 19, 64, 7, 89, 72, 88, 84, 117, 8, 1, 2,
                                71, 16, 68, 67, 85, 84, 75, 74, 74, 9, 12, 66,
                                13, 19, 79, 0, 68, 67, 6, 75, 24, 65, 2, 24, 32,
                                35, 30, 23, 89, 70, 72, 13, 11, 97, 7, 10, 9, 3,
                                7, 7, 5, 5, 2, 5, 66, 5, 19, 11, 72, 65, 2, 66,
                                11, 18, 18, 10, 11, 5, 5, 4, 22, 18, 15, 77, 3,
                                72, 31, 23, 18, 14, 17, 19, 12, 16, 23, 1, 15,
                                9, 8, 5, 64, 10, 4, 8, 9, 6, 14, 22, 7, 81, 6,
                                76, 12, 24, 83, 47, 59, 50, 49, 51, 52, 46, 46,
                                42, 33, 27, 24, 30, 19, 76, 67, 3, 70, 27, 25,
                                22, 26, 23, 17, 14, 15, 67, 1, 67, 93, 88, 104,
                                73, 20, 18, 11, 1, 5, 68, 73, 79, 95, 73, 38,
                                21, 15, 8, 7, 68, 78, 82, 107, 5, 36, 28, 25,
                                20, 11, 5, 64, 72, 86, 70, 36, 31, 19, 4, 6, 70,
                                79, 92, 5, 55, 46, 40, 32, 23, 5, 68, 76, 82,
                                62, 101, 100, 83, 106, 103, 92, 101, 98, 96, 99,
                                99, 102, 92, 90, 89, 89, 85, 84, 70, 78, 81, 69,
                                1, 2, 1, 9, 8, 8, 3, 19, 15, 13, 12, 8, 19, 14,
                                8, 18, 16, 11, 9, 10, 64, 66, 68, 5, 72, 16, 29,
                                16, 9, 24, 22, 13, 19, 25, 17, 23, 9, 3, 11, 47,
                                45, 49, 46, 47, 57, 62, 62, 62, 62, 62, 62, 62,
                                61, 27, 62, 62, 62, 62, 62, 59, 43, 31, 29, 6,
                                76, 73, 89, 111, 53, 53, 56, 47, 43, 42, 32, 32,
                                23, 23, 15, 10, 8, 71, 76, 0, 65, 71, 32, 35,
                                31, 21, 30, 29, 15, 22, 24, 13, 64, 2, 69, 90,
                                19, 8, 64, 77, 68, 67, 66, 0, 64, 65, 64, 64, 2,
                                9, 1, 3, 7, 8, 62, 62, 60, 56, 50, 44, 36, 20,
                                72, 0, 31, 24, 21, 17, 12, 6, 3, 0, 73, 83, 78,
                                73, 78, 73, 66, 72, 79, 67, 0, 3, 0, 3, 4, 4,
                                62, 62, 56, 48, 42, 35, 24, 9, 77 },

                              {

                              62,
                                9, 75, 62, 9, 75, 114, 93, 13, 10, 9, 20, 51,
                                54, 54, 14, 101, 4, 72, 3, 1, 9, 71, 6, 71, 17,
                                51, 78, 97, 107, 106, 95, 67, 72, 3, 1, 83, 87,
                                5, 15, 67, 78, 91, 6, 70, 83, 88, 5, 74, 89, 7,
                                70, 79, 88, 0, 71, 72, 77, 68, 5, 22, 0, 0, 0,
                                79, 87, 97, 68, 17, 0, 18, 76, 94, 114, 85, 90,
                                7, 69, 85, 76, 100, 81, 94, 87, 114, 88, 86, 92,
                                102, 19, 64, 7, 89, 72, 88, 83, 115, 7, 1, 2,
                                71, 16, 68, 67, 84, 84, 75, 74, 73, 9, 11, 66,
                                13, 19, 79, 0, 68, 67, 6, 75, 24, 65, 2, 24, 31,
                                34, 29, 22, 88, 69, 72, 12, 11, 96, 7, 10, 8, 3,
                                7, 7, 6, 6, 2, 5, 66, 5, 18, 11, 73, 65, 2, 66,
                                10, 17, 17, 10, 11, 6, 5, 4, 21, 17, 14, 77, 3,
                                72, 31, 23, 18, 14, 17, 19, 12, 16, 23, 1, 15,
                                9, 8, 5, 64, 10, 4, 7, 9, 6, 14, 21, 7, 81, 5,
                                76, 11, 23, 83, 46, 57, 48, 47, 49, 50, 44, 44,
                                40, 31, 25, 22, 27, 17, 77, 67, 2, 70, 26, 24,
                                21, 25, 22, 15, 13, 14, 67, 1, 67, 93, 88, 104,
                                73, 20, 18, 11, 1, 5, 68, 73, 78, 94, 73, 38,
                                21, 15, 8, 7, 67, 77, 82, 105, 5, 36, 28, 25,
                                20, 11, 5, 64, 72, 85, 70, 36, 30, 18, 4, 6, 70,
                                79, 92, 5, 55, 45, 39, 31, 23, 5, 68, 76, 81,
                                62, 100, 99, 82, 104, 102, 91, 100, 96, 95, 97,
                                97, 100, 91, 89, 88, 89, 84, 83, 70, 78, 80, 69,
                                0, 2, 0, 8, 7, 7, 2, 18, 14, 13, 11, 8, 19, 14,
                                8, 17, 15, 11, 8, 9, 64, 66, 68, 5, 72, 15, 29,
                                15, 9, 23, 21, 13, 18, 24, 16, 22, 8, 2, 9, 46,
                                45, 49, 45, 45, 55, 62, 62, 62, 62, 62, 62, 62,
                                59, 25, 62, 62, 62, 62, 62, 56, 41, 30, 28, 6,
                                75, 72, 88, 109, 52, 51, 54, 46, 41, 40, 31, 30,
                                22, 21, 13, 8, 6, 72, 77, 0, 65, 72, 30, 33, 29,
                                20, 28, 27, 13, 21, 22, 11, 65, 1, 70, 90, 18,
                                8, 65, 77, 67, 66, 66, 1, 0, 64, 0, 0, 3, 10, 2,
                                4, 8, 9, 62, 61, 58, 53, 48, 41, 33, 17, 74, 0,
                                32, 25, 22, 18, 13, 6, 4, 1, 72, 82, 78, 72, 77,
                                72, 65, 72, 78, 67, 0, 3, 1, 4, 4, 4, 62, 62,
                                53, 45, 39, 31, 20, 5, 80 },

                              {

                              62,
                                8, 75, 62, 8, 75, 113, 92, 13, 10, 9, 19, 50,
                                53, 54, 14, 99, 4, 71, 4, 1, 8, 71, 5, 73, 16,
                                49, 80, 98, 108, 104, 94, 67, 71, 4, 1, 83, 86,
                                5, 14, 67, 78, 90, 5, 70, 83, 89, 5, 74, 89, 7,
                                71, 79, 88, 0, 71, 72, 77, 68, 5, 22, 0, 0, 0,
                                78, 88, 97, 68, 16, 0, 18, 76, 94, 112, 84, 88,
                                8, 68, 84, 75, 99, 80, 93, 86, 112, 88, 86, 92,
                                101, 19, 64, 7, 88, 72, 87, 83, 114, 7, 0, 1,
                                72, 16, 68, 67, 84, 84, 75, 74, 73, 8, 11, 66,
                                13, 18, 79, 0, 68, 67, 5, 75, 23, 66, 2, 23, 29,
                                33, 28, 21, 88, 69, 72, 11, 10, 96, 6, 9, 8, 3,
                                7, 7, 7, 6, 2, 4, 66, 4, 17, 10, 74, 65, 2, 67,
                                10, 16, 17, 9, 10, 6, 5, 4, 19, 17, 13, 77, 3,
                                73, 30, 22, 18, 14, 17, 18, 11, 16, 22, 0, 14,
                                9, 8, 4, 65, 9, 3, 7, 8, 5, 13, 20, 6, 81, 5,
                                76, 10, 21, 83, 44, 55, 46, 45, 47, 47, 42, 42,
                                38, 29, 23, 20, 25, 15, 78, 67, 2, 71, 25, 22,
                                19, 23, 20, 14, 11, 12, 68, 0, 68, 93, 88, 103,
                                73, 20, 18, 11, 1, 5, 68, 73, 78, 93, 72, 38,
                                21, 15, 8, 7, 67, 77, 81, 104, 5, 36, 28, 25,
                                19, 11, 5, 64, 72, 85, 70, 36, 30, 18, 4, 6, 70,
                                79, 91, 5, 54, 44, 38, 30, 22, 5, 68, 76, 81,
                                62, 99, 98, 82, 103, 101, 91, 99, 95, 94, 96,
                                96, 99, 91, 89, 88, 88, 83, 83, 71, 78, 80, 69,
                                0, 1, 0, 7, 6, 5, 1, 17, 14, 13, 11, 7, 18, 13,
                                7, 16, 14, 10, 8, 8, 65, 67, 68, 5, 73, 14, 28,
                                14, 9, 22, 20, 13, 17, 23, 16, 22, 7, 1, 7, 45,
                                44, 48, 43, 44, 54, 62, 62, 62, 62, 62, 62, 62,
                                56, 24, 62, 62, 62, 62, 61, 54, 39, 28, 26, 6,
                                75, 72, 87, 107, 50, 49, 52, 44, 38, 38, 29, 28,
                                20, 19, 12, 6, 5, 73, 78, 64, 66, 73, 29, 32,
                                27, 18, 26, 25, 12, 19, 20, 10, 66, 64, 72, 91,
                                17, 7, 66, 77, 67, 66, 65, 1, 0, 0, 0, 1, 4, 11,
                                3, 5, 9, 10, 61, 59, 56, 51, 45, 38, 30, 14, 77,
                                0, 32, 25, 22, 18, 13, 6, 4, 1, 72, 82, 78, 72,
                                77, 71, 64, 72, 78, 66, 1, 3, 1, 4, 4, 3, 62,
                                61, 51, 42, 36, 27, 16, 2, 83 },

                              {

                              62,
                                8, 75, 62, 8, 75, 111, 91, 14, 10, 9, 18, 49,
                                52, 54, 14, 97, 4, 70, 5, 1, 8, 70, 4, 74, 15,
                                47, 81, 99, 109, 101, 92, 67, 70, 5, 1, 82, 85,
                                6, 13, 67, 77, 89, 5, 70, 83, 89, 5, 74, 88, 7,
                                71, 79, 88, 0, 71, 71, 77, 68, 5, 22, 0, 0, 0,
                                77, 88, 97, 68, 15, 0, 18, 75, 94, 110, 82, 86,
                                9, 66, 82, 74, 97, 79, 91, 85, 110, 88, 86, 92,
                                100, 19, 64, 7, 87, 72, 86, 82, 113, 7, 0, 1,
                                72, 16, 68, 66, 83, 83, 74, 74, 73, 8, 11, 66,
                                13, 18, 78, 0, 67, 67, 5, 74, 22, 66, 2, 22, 28,
                                33, 27, 20, 87, 69, 71, 10, 9, 96, 5, 9, 8, 4,
                                7, 7, 8, 6, 2, 4, 65, 4, 17, 10, 75, 65, 2, 68,
                                10, 15, 17, 9, 9, 6, 5, 4, 18, 17, 13, 77, 3,
                                74, 29, 22, 18, 14, 17, 18, 11, 16, 22, 0, 14,
                                9, 8, 4, 65, 9, 3, 7, 8, 5, 12, 20, 6, 81, 5,
                                76, 9, 20, 83, 42, 54, 45, 44, 45, 45, 41, 41,
                                36, 27, 22, 19, 23, 14, 79, 67, 2, 72, 24, 21,
                                18, 22, 19, 13, 10, 11, 69, 64, 69, 93, 87, 102,
                                72, 21, 18, 11, 1, 6, 67, 72, 77, 92, 71, 38,
                                21, 15, 8, 8, 67, 76, 80, 102, 5, 36, 28, 25,
                                19, 12, 5, 64, 72, 84, 70, 37, 30, 18, 4, 7, 70,
                                79, 90, 5, 54, 44, 38, 29, 22, 5, 68, 75, 80,
                                62, 98, 97, 81, 102, 99, 90, 97, 94, 92, 95, 95,
                                97, 90, 88, 88, 87, 81, 83, 72, 77, 79, 69, 0,
                                0, 0, 7, 5, 4, 0, 17, 14, 13, 11, 7, 17, 13, 7,
                                15, 14, 10, 8, 7, 65, 67, 67, 6, 73, 14, 27, 14,
                                9, 22, 20, 13, 16, 22, 16, 22, 6, 1, 6, 45, 43,
                                47, 42, 43, 53, 60, 60, 62, 62, 62, 62, 62, 54,
                                23, 62, 62, 62, 62, 58, 52, 38, 27, 25, 6, 74,
                                72, 86, 105, 48, 48, 50, 42, 36, 37, 28, 26, 19,
                                18, 11, 5, 4, 74, 78, 64, 66, 74, 28, 31, 26,
                                16, 25, 24, 11, 18, 19, 9, 67, 65, 73, 92, 17,
                                6, 66, 76, 67, 66, 64, 2, 1, 1, 1, 2, 5, 13, 4,
                                6, 11, 12, 60, 58, 54, 49, 42, 35, 27, 11, 79,
                                1, 32, 25, 23, 18, 14, 7, 4, 2, 71, 82, 77, 71,
                                77, 70, 1, 71, 77, 65, 2, 3, 2, 5, 4, 3, 62, 59,
                                49, 40, 33, 24, 12, 64, 85 },

                              {

                              62,
                                8, 75, 62, 8, 75, 109, 89, 14, 10, 8, 16, 47,
                                50, 54, 14, 94, 3, 69, 5, 1, 7, 70, 3, 75, 15,
                                45, 83, 100, 109, 98, 91, 67, 69, 5, 1, 82, 84,
                                6, 13, 67, 77, 89, 5, 71, 82, 89, 5, 74, 87, 6,
                                71, 79, 88, 1, 70, 71, 76, 67, 5, 22, 0, 0, 0,
                                77, 88, 97, 67, 14, 0, 18, 75, 94, 109, 80, 85,
                                11, 64, 81, 73, 96, 77, 90, 84, 108, 87, 85, 91,
                                99, 19, 64, 7, 87, 72, 86, 82, 111, 6, 0, 1, 72,
                                16, 68, 66, 83, 83, 74, 74, 72, 8, 10, 66, 13,
                                18, 78, 0, 67, 67, 5, 74, 22, 66, 2, 22, 27, 32,
                                26, 19, 86, 68, 71, 9, 9, 95, 5, 9, 7, 4, 7, 7,
                                9, 7, 2, 4, 65, 4, 16, 10, 76, 65, 2, 68, 9, 14,
                                16, 9, 9, 7, 5, 4, 17, 16, 12, 77, 3, 74, 29,
                                22, 18, 14, 17, 18, 11, 16, 22, 0, 14, 9, 8, 4,
                                65, 9, 3, 6, 8, 5, 12, 19, 5, 81, 4, 76, 8, 19,
                                83, 41, 52, 43, 42, 43, 43, 39, 39, 34, 25, 20,
                                17, 20, 12, 80, 67, 1, 72, 23, 20, 17, 21, 17,
                                11, 9, 10, 69, 64, 69, 93, 87, 102, 72, 21, 18,
                                11, 1, 6, 67, 72, 77, 91, 71, 38, 21, 15, 8, 8,
                                66, 75, 80, 100, 5, 36, 28, 25, 19, 12, 5, 64,
                                72, 83, 70, 37, 29, 17, 4, 7, 70, 79, 90, 5, 53,
                                43, 37, 28, 22, 5, 68, 75, 80, 62, 97, 96, 80,
                                100, 98, 89, 96, 92, 91, 93, 93, 95, 89, 87, 87,
                                87, 80, 82, 72, 77, 78, 69, 64, 0, 64, 6, 4, 3,
                                64, 16, 13, 13, 10, 6, 17, 13, 7, 14, 13, 10, 7,
                                6, 65, 67, 67, 6, 73, 13, 27, 13, 9, 21, 19, 13,
                                15, 21, 15, 21, 5, 0, 4, 44, 43, 47, 41, 41, 51,
                                58, 58, 62, 62, 62, 62, 62, 52, 21, 59, 62, 59,
                                62, 56, 49, 36, 26, 24, 6, 73, 71, 85, 103, 47,
                                46, 48, 41, 34, 35, 26, 24, 18, 16, 9, 3, 2, 75,
                                79, 65, 66, 75, 26, 29, 24, 15, 23, 22, 9, 16,
                                17, 7, 68, 66, 74, 92, 16, 6, 67, 76, 66, 65,
                                64, 2, 2, 2, 2, 3, 6, 14, 5, 7, 12, 13, 60, 56,
                                52, 46, 40, 32, 24, 8, 81, 1, 33, 26, 23, 19,
                                15, 7, 5, 2, 71, 81, 77, 70, 76, 69, 2, 71, 76,
                                65, 2, 3, 2, 6, 4, 3, 62, 57, 46, 37, 30, 20, 8,
                                68, 88 },

                              {

                              62,
                                8, 76, 62, 8, 76, 107, 88, 15, 10, 8, 15, 46,
                                49, 54, 14, 92, 3, 69, 6, 1, 6, 70, 2, 76, 14,
                                44, 84, 101, 110, 95, 90, 67, 69, 6, 1, 81, 83,
                                7, 12, 66, 76, 88, 4, 71, 82, 89, 5, 73, 87, 6,
                                71, 78, 88, 1, 70, 71, 76, 67, 5, 22, 0, 0, 0,
                                76, 88, 97, 67, 14, 64, 18, 75, 93, 107, 78, 83,
                                12, 1, 80, 72, 94, 76, 89, 84, 107, 87, 85, 91,
                                99, 20, 64, 7, 86, 71, 85, 81, 110, 6, 64, 0,
                                73, 16, 68, 66, 82, 83, 73, 74, 72, 8, 10, 65,
                                13, 17, 78, 0, 67, 67, 5, 74, 21, 66, 2, 21, 26,
                                31, 26, 19, 86, 68, 71, 9, 8, 95, 4, 9, 7, 4, 7,
                                7, 9, 7, 2, 4, 64, 4, 15, 10, 76, 66, 2, 69, 9,
                                13, 16, 9, 8, 7, 5, 4, 15, 16, 11, 77, 3, 75,
                                28, 22, 17, 14, 17, 18, 11, 16, 22, 0, 13, 9, 7,
                                4, 65, 8, 2, 6, 7, 4, 11, 18, 5, 81, 4, 75, 7,
                                17, 83, 39, 50, 41, 40, 41, 41, 37, 37, 32, 23,
                                19, 16, 18, 10, 81, 67, 1, 73, 22, 19, 16, 19,
                                16, 10, 8, 9, 70, 65, 70, 93, 87, 101, 71, 21,
                                18, 11, 2, 6, 67, 72, 76, 90, 70, 37, 21, 15, 8,
                                9, 66, 74, 79, 98, 5, 37, 28, 25, 19, 13, 5, 64,
                                71, 83, 70, 37, 29, 17, 4, 7, 69, 78, 89, 5, 53,
                                43, 36, 28, 22, 5, 67, 74, 79, 62, 97, 95, 80,
                                99, 97, 88, 94, 91, 90, 92, 92, 94, 89, 86, 87,
                                86, 78, 82, 73, 77, 78, 69, 64, 64, 64, 5, 3, 2,
                                65, 16, 13, 13, 10, 6, 16, 12, 7, 14, 13, 9, 7,
                                6, 65, 68, 67, 6, 74, 13, 26, 12, 8, 20, 19, 14,
                                15, 20, 15, 21, 5, 0, 3, 43, 42, 46, 40, 40, 50,
                                56, 56, 61, 60, 62, 62, 60, 49, 20, 57, 62, 56,
                                62, 53, 47, 34, 25, 23, 6, 72, 71, 83, 100, 45,
                                44, 46, 39, 32, 33, 25, 22, 16, 15, 8, 2, 1, 76,
                                80, 65, 67, 76, 25, 28, 23, 13, 21, 20, 8, 15,
                                15, 6, 70, 68, 76, 93, 15, 5, 68, 76, 66, 65, 0,
                                3, 2, 4, 3, 4, 7, 15, 7, 8, 14, 14, 59, 55, 50,
                                44, 37, 30, 21, 6, 83, 2, 33, 26, 24, 19, 16, 8,
                                5, 3, 70, 81, 76, 70, 76, 68, 3, 71, 76, 64, 3,
                                3, 3, 7, 4, 3, 62, 55, 44, 34, 26, 16, 5, 71, 90 },

                              {

                              62,
                                8, 76, 62, 8, 76, 106, 86, 15, 10, 7, 13, 44,
                                48, 54, 14, 90, 3, 68, 7, 1, 5, 70, 1, 77, 14,
                                42, 86, 102, 110, 92, 89, 67, 68, 7, 1, 81, 82,
                                7, 12, 66, 76, 87, 4, 72, 82, 89, 5, 73, 86, 6,
                                72, 78, 88, 2, 70, 71, 76, 66, 5, 22, 0, 0, 0,
                                76, 89, 97, 66, 13, 64, 18, 75, 93, 105, 77, 82,
                                14, 2, 79, 71, 93, 75, 88, 83, 105, 86, 85, 90,
                                98, 20, 64, 7, 86, 71, 85, 81, 108, 6, 64, 0,
                                73, 16, 68, 66, 82, 83, 73, 74, 71, 8, 10, 65,
                                13, 17, 78, 0, 67, 67, 5, 74, 20, 67, 2, 20, 25,
                                30, 25, 18, 85, 67, 71, 8, 8, 94, 4, 9, 7, 4, 7,
                                7, 10, 7, 2, 3, 64, 3, 14, 9, 77, 66, 2, 69, 8,
                                12, 16, 8, 7, 7, 5, 4, 14, 16, 10, 77, 3, 75,
                                27, 22, 17, 14, 17, 18, 11, 16, 21, 0, 13, 9, 7,
                                4, 66, 8, 2, 5, 7, 4, 10, 17, 4, 81, 3, 75, 6,
                                16, 83, 38, 48, 39, 38, 39, 39, 35, 35, 30, 21,
                                17, 14, 16, 8, 82, 67, 1, 73, 21, 18, 15, 18,
                                14, 8, 7, 7, 71, 65, 70, 93, 87, 101, 71, 21,
                                18, 11, 2, 6, 67, 72, 76, 89, 70, 37, 21, 15, 8,
                                9, 65, 74, 78, 96, 5, 37, 28, 25, 19, 13, 5, 64,
                                71, 82, 70, 37, 29, 16, 4, 7, 69, 78, 88, 5, 52,
                                42, 35, 27, 22, 5, 67, 74, 79, 62, 96, 94, 79,
                                98, 96, 87, 93, 90, 89, 91, 90, 92, 88, 86, 87,
                                86, 77, 82, 73, 77, 77, 69, 65, 64, 64, 4, 2, 1,
                                66, 15, 12, 13, 9, 5, 16, 12, 7, 13, 12, 9, 7,
                                5, 66, 68, 67, 6, 74, 12, 26, 11, 8, 19, 18, 14,
                                14, 19, 14, 20, 4, 64, 1, 42, 41, 46, 39, 39,
                                48, 54, 54, 59, 57, 62, 62, 57, 47, 19, 54, 62,
                                53, 58, 50, 44, 32, 24, 21, 6, 71, 71, 82, 98,
                                43, 42, 44, 37, 30, 31, 23, 20, 15, 13, 7, 0,
                                64, 77, 81, 66, 67, 77, 24, 26, 21, 11, 19, 18,
                                6, 13, 13, 4, 71, 69, 77, 94, 14, 4, 69, 76, 65,
                                65, 0, 3, 3, 5, 3, 5, 8, 16, 8, 9, 15, 15, 59,
                                53, 48, 41, 35, 27, 18, 3, 86, 2, 34, 27, 24,
                                19, 16, 8, 5, 3, 70, 81, 76, 69, 75, 67, 4, 71,
                                75, 64, 3, 3, 3, 8, 4, 3, 61, 53, 41, 31, 23,
                                12, 1, 75, 93 },

                              {

                              62,
                                8, 76, 62, 8, 76, 104, 85, 15, 10, 7, 12, 43,
                                46, 54, 14, 87, 2, 67, 7, 1, 5, 69, 0, 78, 13,
                                40, 88, 103, 111, 89, 87, 67, 67, 7, 1, 81, 81,
                                7, 11, 66, 76, 87, 4, 72, 81, 89, 5, 73, 85, 5,
                                72, 78, 88, 2, 69, 70, 75, 66, 5, 22, 0, 0, 0,
                                75, 89, 97, 66, 12, 64, 18, 74, 93, 104, 75, 80,
                                15, 4, 77, 70, 92, 73, 87, 82, 103, 86, 84, 90,
                                97, 20, 64, 7, 85, 71, 84, 80, 107, 5, 64, 0,
                                73, 16, 68, 65, 81, 83, 73, 74, 71, 8, 9, 65,
                                13, 17, 77, 0, 66, 67, 5, 74, 20, 67, 2, 20, 24,
                                30, 24, 17, 84, 67, 71, 7, 7, 94, 3, 9, 6, 4, 7,
                                7, 11, 8, 2, 3, 64, 3, 13, 9, 78, 66, 2, 70, 8,
                                11, 15, 8, 7, 8, 5, 4, 13, 15, 9, 77, 3, 76, 27,
                                22, 17, 14, 17, 18, 11, 16, 21, 0, 13, 9, 7, 4,
                                66, 8, 2, 5, 7, 4, 10, 16, 4, 81, 3, 75, 5, 15,
                                83, 36, 46, 38, 37, 37, 37, 33, 33, 28, 19, 15,
                                12, 13, 7, 83, 67, 0, 74, 20, 17, 14, 17, 13, 7,
                                6, 6, 71, 66, 71, 93, 87, 100, 71, 21, 18, 11,
                                2, 6, 66, 71, 75, 88, 69, 37, 21, 15, 8, 9, 65,
                                73, 78, 94, 5, 37, 28, 25, 19, 13, 5, 64, 71,
                                81, 70, 38, 28, 16, 4, 7, 69, 78, 88, 5, 52, 41,
                                34, 26, 22, 5, 67, 74, 78, 62, 95, 93, 78, 96,
                                95, 86, 92, 88, 88, 89, 89, 90, 87, 85, 86, 85,
                                76, 81, 74, 76, 76, 69, 65, 65, 65, 4, 1, 0, 67,
                                14, 12, 13, 9, 5, 15, 12, 7, 12, 11, 9, 6, 4,
                                66, 68, 67, 6, 74, 11, 25, 11, 8, 18, 17, 14,
                                13, 18, 14, 20, 3, 65, 64, 41, 41, 45, 38, 37,
                                47, 52, 52, 57, 55, 62, 61, 54, 45, 17, 51, 62,
                                50, 54, 48, 42, 30, 23, 20, 6, 70, 70, 81, 96,
                                42, 41, 42, 36, 28, 29, 22, 18, 14, 11, 5, 65,
                                65, 78, 82, 66, 67, 78, 22, 25, 19, 10, 18, 17,
                                5, 12, 12, 3, 72, 70, 78, 94, 14, 4, 70, 75, 65,
                                64, 1, 4, 4, 6, 4, 6, 9, 18, 9, 10, 16, 17, 58,
                                51, 46, 39, 32, 24, 15, 0, 88, 2, 34, 27, 25,
                                20, 17, 8, 6, 4, 69, 80, 76, 68, 75, 66, 5, 70,
                                74, 0, 4, 3, 4, 9, 4, 3, 59, 51, 39, 28, 20, 9,
                                66, 78, 96 },

                              {

                              61,
                                8, 76, 61, 8, 76, 102, 83, 16, 10, 6, 10, 41,
                                45, 54, 14, 85, 2, 66, 8, 1, 4, 69, 64, 79, 13,
                                38, 89, 104, 111, 86, 86, 67, 66, 8, 1, 80, 80,
                                8, 11, 66, 75, 86, 3, 73, 81, 89, 5, 73, 85, 5,
                                72, 78, 88, 3, 69, 70, 75, 65, 5, 22, 0, 0, 0,
                                75, 89, 97, 65, 11, 64, 18, 74, 93, 102, 73, 79,
                                17, 6, 76, 69, 90, 72, 86, 81, 101, 85, 84, 89,
                                96, 20, 64, 7, 85, 71, 84, 80, 105, 5, 65, 64,
                                74, 16, 68, 65, 81, 83, 72, 74, 70, 8, 9, 65,
                                13, 16, 77, 0, 66, 67, 5, 74, 19, 67, 2, 19, 23,
                                29, 23, 16, 84, 66, 71, 6, 7, 93, 3, 9, 6, 4, 7,
                                7, 12, 8, 2, 3, 0, 3, 12, 9, 79, 66, 2, 70, 7,
                                10, 15, 8, 6, 8, 5, 4, 11, 15, 8, 77, 3, 76, 26,
                                22, 17, 14, 17, 18, 11, 16, 21, 0, 12, 9, 7, 4,
                                66, 7, 1, 4, 6, 3, 9, 15, 3, 81, 2, 75, 4, 13,
                                83, 35, 44, 36, 35, 35, 35, 31, 31, 26, 17, 14,
                                11, 11, 5, 84, 67, 0, 74, 19, 16, 13, 15, 11, 5,
                                5, 5, 72, 66, 71, 93, 87, 100, 70, 21, 18, 11,
                                2, 6, 66, 71, 75, 87, 69, 37, 21, 15, 8, 10, 64,
                                72, 77, 92, 5, 37, 28, 25, 19, 14, 5, 64, 71,
                                81, 70, 38, 28, 15, 4, 7, 69, 78, 87, 5, 51, 41,
                                33, 25, 22, 5, 67, 73, 78, 62, 94, 92, 78, 95,
                                94, 85, 90, 87, 87, 88, 87, 89, 87, 84, 86, 85,
                                74, 81, 74, 76, 76, 69, 66, 65, 65, 3, 0, 64,
                                68, 14, 11, 13, 8, 4, 15, 11, 7, 11, 11, 8, 6,
                                3, 66, 69, 67, 6, 75, 11, 25, 10, 8, 17, 17, 14,
                                12, 17, 13, 19, 2, 65, 65, 40, 40, 45, 37, 36,
                                45, 50, 50, 55, 52, 60, 59, 51, 42, 16, 48, 62,
                                47, 50, 45, 39, 28, 22, 19, 6, 69, 70, 80, 94,
                                40, 39, 40, 34, 26, 27, 20, 16, 12, 10, 4, 66,
                                67, 79, 83, 67, 68, 79, 21, 23, 18, 8, 16, 15,
                                3, 10, 10, 1, 73, 72, 80, 95, 13, 3, 71, 75, 64,
                                64, 1, 4, 4, 7, 5, 7, 10, 19, 10, 11, 18, 18,
                                58, 50, 44, 36, 30, 21, 12, 66, 90, 3, 35, 28,
                                25, 20, 18, 9, 6, 4, 69, 80, 75, 68, 74, 65, 6,
                                70, 74, 0, 4, 3, 4, 10, 4, 3, 58, 49, 36, 25,
                                17, 5, 70, 82, 98 },

                              {

                              60,
                                8, 76, 60, 8, 76, 100, 82, 16, 10, 6, 9, 40, 44,
                                54, 14, 83, 2, 65, 9, 1, 3, 69, 65, 80, 12, 36,
                                91, 105, 112, 83, 85, 67, 65, 9, 1, 80, 79, 8,
                                10, 66, 75, 85, 3, 73, 81, 89, 5, 73, 84, 5, 72,
                                78, 88, 3, 69, 70, 75, 65, 5, 22, 0, 0, 0, 74,
                                89, 97, 65, 10, 64, 18, 74, 93, 100, 71, 77, 18,
                                8, 75, 68, 89, 71, 85, 80, 99, 85, 84, 89, 95,
                                20, 64, 7, 84, 71, 83, 79, 104, 5, 65, 64, 74,
                                16, 68, 65, 80, 83, 72, 74, 70, 8, 9, 65, 13,
                                16, 77, 0, 66, 67, 5, 74, 18, 67, 2, 18, 22, 28,
                                22, 15, 83, 66, 71, 5, 6, 93, 2, 9, 6, 4, 7, 7,
                                13, 8, 2, 3, 0, 3, 11, 9, 80, 66, 2, 71, 7, 9,
                                15, 8, 5, 8, 5, 4, 10, 15, 7, 77, 3, 77, 25, 22,
                                17, 14, 17, 18, 11, 16, 21, 0, 12, 9, 7, 4, 66,
                                7, 1, 4, 6, 3, 8, 14, 3, 81, 2, 75, 3, 12, 83,
                                33, 42, 34, 33, 33, 33, 29, 29, 24, 15, 12, 9,
                                9, 3, 85, 67, 0, 75, 18, 15, 12, 14, 10, 4, 4,
                                4, 73, 67, 72, 93, 87, 99, 70, 21, 18, 11, 2, 6,
                                66, 71, 74, 86, 68, 37, 21, 15, 8, 10, 64, 71,
                                76, 90, 5, 37, 28, 25, 19, 14, 5, 64, 71, 80,
                                70, 38, 28, 15, 4, 7, 69, 78, 86, 5, 51, 40, 32,
                                24, 22, 5, 67, 73, 77, 62, 93, 91, 77, 94, 93,
                                84, 89, 86, 86, 87, 86, 87, 86, 83, 86, 84, 73,
                                81, 75, 76, 75, 69, 66, 66, 65, 2, 64, 65, 69,
                                13, 11, 13, 8, 4, 14, 11, 7, 10, 10, 8, 6, 2,
                                66, 69, 67, 6, 75, 10, 24, 9, 8, 16, 16, 14, 11,
                                16, 13, 19, 1, 66, 67, 39, 39, 44, 36, 35, 44,
                                48, 48, 53, 50, 57, 56, 48, 40, 15, 45, 59, 44,
                                46, 42, 37, 26, 21, 18, 6, 68, 70, 79, 92, 38,
                                37, 38, 32, 24, 25, 19, 14, 11, 8, 3, 68, 68,
                                80, 84, 67, 68, 80, 20, 22, 16, 6, 14, 13, 2, 9,
                                8, 0, 74, 73, 81, 96, 12, 2, 72, 75, 64, 64, 2,
                                5, 5, 8, 6, 8, 11, 20, 11, 12, 19, 19, 57, 48,
                                42, 34, 27, 18, 9, 69, 92, 3, 35, 28, 26, 20,
                                19, 9, 6, 5, 68, 80, 75, 67, 74, 64, 7, 70, 73,
                                1, 5, 3, 5, 11, 4, 3, 57, 47, 34, 22, 14, 1, 74,
                                85, 101 },

                              {

                              58,
                                7, 77, 58, 7, 77, 99, 81, 16, 10, 5, 7, 38, 42,
                                53, 14, 81, 1, 65, 9, 0, 2, 69, 67, 82, 11, 34,
                                93, 106, 113, 81, 84, 68, 65, 9, 0, 80, 78, 8,
                                9, 66, 75, 85, 2, 74, 81, 90, 5, 73, 84, 4, 73,
                                78, 88, 3, 69, 70, 75, 65, 4, 22, 0, 0, 0, 74,
                                90, 97, 65, 9, 65, 18, 74, 93, 99, 70, 76, 19,
                                9, 74, 67, 88, 70, 84, 80, 98, 85, 84, 89, 95,
                                20, 64, 7, 84, 71, 83, 79, 103, 4, 66, 65, 75,
                                16, 68, 65, 80, 83, 72, 74, 70, 7, 8, 65, 12,
                                15, 77, 64, 66, 67, 4, 74, 17, 68, 1, 17, 20,
                                27, 21, 14, 83, 66, 71, 4, 5, 93, 1, 8, 5, 4, 7,
                                7, 13, 8, 2, 2, 0, 2, 10, 8, 81, 67, 1, 72, 6,
                                8, 14, 7, 4, 8, 5, 4, 8, 14, 6, 77, 3, 78, 24,
                                21, 16, 14, 17, 17, 10, 16, 20, 64, 11, 9, 6, 3,
                                67, 6, 0, 3, 5, 2, 7, 13, 2, 81, 1, 75, 2, 10,
                                83, 31, 40, 32, 31, 31, 30, 27, 27, 22, 13, 10,
                                7, 6, 1, 87, 68, 64, 76, 17, 13, 10, 12, 8, 2,
                                2, 2, 74, 68, 73, 93, 87, 99, 70, 21, 18, 11, 2,
                                6, 66, 71, 74, 85, 68, 36, 21, 15, 8, 10, 64,
                                71, 76, 89, 4, 37, 28, 24, 18, 14, 5, 64, 71,
                                80, 70, 38, 27, 14, 3, 7, 69, 78, 86, 5, 50, 39,
                                31, 23, 21, 5, 67, 73, 77, 62, 93, 90, 77, 93,
                                92, 84, 88, 85, 85, 86, 85, 86, 86, 83, 86, 84,
                                72, 81, 76, 76, 75, 69, 67, 67, 66, 1, 65, 67,
                                71, 12, 10, 13, 7, 3, 13, 10, 6, 9, 9, 7, 5, 1,
                                67, 70, 67, 6, 76, 9, 23, 8, 7, 15, 15, 14, 10,
                                14, 12, 18, 0, 67, 69, 38, 38, 43, 34, 33, 42,
                                46, 46, 50, 47, 54, 53, 45, 37, 13, 42, 55, 41,
                                41, 39, 34, 24, 19, 16, 6, 68, 70, 78, 90, 36,
                                35, 36, 30, 21, 23, 17, 11, 9, 6, 1, 70, 70, 81,
                                85, 68, 69, 82, 18, 20, 14, 4, 12, 11, 0, 7, 6,
                                65, 76, 75, 83, 97, 11, 1, 73, 75, 64, 64, 2, 5,
                                5, 9, 6, 9, 11, 21, 12, 13, 20, 20, 56, 46, 39,
                                31, 24, 15, 5, 72, 95, 3, 35, 28, 26, 20, 19, 9,
                                6, 5, 68, 80, 75, 67, 74, 0, 8, 70, 73, 1, 5, 3,
                                5, 11, 4, 2, 55, 44, 31, 19, 10, 66, 78, 89, 104 },

                              {

                              57,
                                7, 77, 57, 7, 77, 97, 79, 17, 11, 5, 6, 37, 41,
                                53, 14, 78, 1, 64, 10, 0, 2, 68, 68, 83, 11, 33,
                                94, 107, 113, 78, 82, 68, 64, 10, 0, 79, 76, 9,
                                9, 65, 74, 84, 2, 74, 80, 90, 5, 72, 83, 4, 73,
                                77, 88, 4, 68, 69, 74, 64, 4, 22, 0, 0, 0, 73,
                                90, 97, 64, 9, 65, 18, 73, 92, 97, 68, 74, 21,
                                11, 72, 66, 86, 68, 82, 79, 96, 84, 83, 88, 94,
                                21, 0, 8, 83, 70, 82, 78, 101, 4, 66, 65, 75,
                                17, 68, 64, 79, 82, 71, 73, 69, 7, 8, 64, 12,
                                15, 76, 64, 65, 67, 4, 73, 17, 68, 1, 17, 19,
                                27, 21, 14, 82, 65, 70, 4, 5, 92, 1, 8, 5, 5, 7,
                                7, 14, 9, 3, 2, 1, 2, 10, 8, 81, 67, 1, 72, 6,
                                7, 14, 7, 4, 9, 6, 4, 7, 14, 6, 76, 3, 78, 24,
                                21, 16, 14, 17, 17, 10, 16, 20, 64, 11, 9, 6, 3,
                                67, 6, 0, 3, 5, 2, 7, 13, 2, 80, 1, 74, 2, 9,
                                82, 30, 39, 31, 30, 29, 28, 26, 26, 20, 12, 9,
                                6, 4, 0, 88, 68, 64, 76, 16, 12, 9, 11, 7, 1, 1,
                                1, 74, 68, 73, 92, 86, 98, 69, 22, 18, 11, 3, 7,
                                65, 70, 73, 83, 67, 36, 21, 15, 8, 11, 0, 70,
                                75, 87, 4, 38, 29, 24, 18, 15, 5, 64, 70, 79,
                                70, 39, 27, 14, 3, 8, 68, 77, 85, 5, 50, 39, 31,
                                23, 21, 5, 66, 72, 76, 62, 92, 89, 76, 91, 90,
                                83, 86, 83, 83, 84, 83, 84, 85, 82, 85, 83, 70,
                                80, 76, 75, 74, 68, 67, 67, 66, 1, 65, 68, 72,
                                12, 10, 14, 7, 3, 13, 10, 6, 9, 9, 7, 5, 1, 67,
                                70, 66, 7, 76, 9, 23, 8, 7, 15, 15, 15, 10, 13,
                                12, 18, 0, 67, 70, 38, 38, 43, 33, 32, 41, 44,
                                44, 48, 45, 52, 51, 43, 35, 12, 40, 52, 38, 37,
                                37, 32, 23, 18, 15, 6, 67, 69, 76, 87, 35, 34,
                                35, 29, 19, 22, 16, 9, 8, 5, 0, 71, 71, 82, 85,
                                68, 69, 83, 17, 19, 13, 3, 11, 10, 64, 6, 5, 66,
                                77, 76, 84, 97, 11, 1, 73, 74, 0, 0, 3, 6, 6,
                                11, 7, 10, 12, 23, 14, 14, 22, 22, 56, 45, 37,
                                29, 22, 13, 2, 74, 97, 4, 36, 29, 27, 21, 20,
                                10, 7, 6, 67, 79, 74, 66, 73, 2, 10, 69, 72, 2,
                                6, 4, 6, 12, 4, 2, 54, 42, 29, 17, 7, 69, 81,
                                92, 106 },

                              {

                              56,
                                7, 77, 56, 7, 77, 95, 78, 17, 11, 5, 5, 36, 40,
                                53, 14, 76, 1, 0, 11, 0, 1, 68, 69, 84, 10, 31,
                                96, 108, 114, 75, 81, 68, 0, 11, 0, 79, 75, 9,
                                8, 65, 74, 83, 2, 74, 80, 90, 5, 72, 82, 4, 73,
                                77, 88, 4, 68, 69, 74, 64, 4, 22, 0, 0, 0, 72,
                                90, 97, 64, 8, 65, 18, 73, 92, 95, 66, 72, 22,
                                13, 71, 65, 85, 67, 81, 78, 94, 84, 83, 88, 93,
                                21, 0, 8, 82, 70, 81, 78, 100, 4, 66, 65, 75,
                                17, 68, 64, 79, 82, 71, 73, 69, 7, 8, 64, 12,
                                15, 76, 64, 65, 67, 4, 73, 16, 68, 1, 16, 18,
                                26, 20, 13, 81, 65, 70, 3, 4, 92, 0, 8, 5, 5, 7,
                                7, 15, 9, 3, 2, 1, 2, 9, 8, 82, 67, 1, 73, 6, 6,
                                14, 7, 3, 9, 6, 4, 6, 14, 5, 76, 3, 79, 23, 21,
                                16, 14, 17, 17, 10, 16, 20, 64, 11, 9, 6, 3, 67,
                                6, 0, 3, 5, 2, 6, 12, 1, 80, 1, 74, 1, 8, 82,
                                28, 37, 29, 28, 27, 26, 24, 24, 18, 10, 7, 4, 2,
                                65, 89, 68, 64, 77, 15, 11, 8, 10, 5, 0, 0, 0,
                                75, 69, 74, 92, 86, 97, 69, 22, 18, 11, 3, 7,
                                65, 70, 73, 82, 66, 36, 21, 15, 8, 11, 0, 69,
                                74, 85, 4, 38, 29, 24, 18, 15, 5, 64, 70, 78,
                                70, 39, 27, 14, 3, 8, 68, 77, 84, 5, 49, 38, 30,
                                22, 21, 5, 66, 72, 76, 62, 91, 88, 75, 90, 89,
                                82, 85, 82, 82, 83, 82, 82, 84, 81, 85, 82, 69,
                                80, 77, 75, 73, 68, 67, 68, 66, 0, 66, 69, 73,
                                11, 10, 14, 7, 2, 12, 10, 6, 8, 8, 7, 5, 0, 67,
                                70, 66, 7, 76, 8, 22, 7, 7, 14, 14, 15, 9, 12,
                                12, 18, 64, 68, 72, 37, 37, 42, 32, 31, 40, 42,
                                42, 46, 43, 49, 48, 40, 33, 11, 37, 49, 35, 33,
                                34, 30, 21, 17, 14, 6, 66, 69, 75, 85, 33, 32,
                                33, 27, 17, 20, 14, 7, 7, 3, 64, 73, 72, 83, 86,
                                69, 69, 84, 16, 18, 11, 1, 9, 8, 65, 4, 3, 67,
                                78, 77, 85, 98, 10, 0, 74, 74, 0, 0, 4, 6, 7,
                                12, 8, 11, 13, 24, 15, 15, 23, 23, 55, 43, 35,
                                27, 19, 10, 64, 77, 99, 4, 36, 29, 27, 21, 21,
                                10, 7, 6, 67, 79, 74, 65, 73, 3, 11, 69, 71, 3,
                                7, 4, 6, 13, 4, 2, 53, 40, 27, 14, 4, 73, 85,
                                95, 109 },

                              {

                              55,
                                7, 77, 55, 7, 77, 93, 76, 18, 11, 4, 3, 34, 39,
                                53, 14, 74, 1, 1, 12, 0, 0, 68, 70, 85, 10, 29,
                                97, 109, 114, 72, 80, 68, 1, 12, 0, 78, 74, 10,
                                8, 65, 73, 82, 1, 75, 80, 90, 5, 72, 82, 4, 73,
                                77, 88, 5, 68, 69, 74, 0, 4, 22, 0, 0, 0, 72,
                                90, 97, 0, 7, 65, 18, 73, 92, 93, 64, 71, 24,
                                15, 70, 64, 83, 66, 80, 77, 92, 83, 83, 87, 92,
                                21, 0, 8, 82, 70, 81, 77, 98, 4, 67, 66, 76, 17,
                                68, 64, 78, 82, 70, 73, 68, 7, 8, 64, 12, 14,
                                76, 64, 65, 67, 4, 73, 15, 68, 1, 15, 17, 25,
                                19, 12, 81, 64, 70, 2, 4, 91, 0, 8, 5, 5, 7, 7,
                                16, 9, 3, 2, 2, 2, 8, 8, 83, 67, 1, 73, 5, 5,
                                14, 7, 2, 9, 6, 4, 4, 14, 4, 76, 3, 79, 22, 21,
                                16, 14, 17, 17, 10, 16, 20, 64, 10, 9, 6, 3, 67,
                                5, 64, 2, 4, 1, 5, 11, 1, 80, 0, 74, 0, 6, 82,
                                27, 35, 27, 26, 25, 24, 22, 22, 16, 8, 6, 3, 0,
                                67, 90, 68, 64, 77, 14, 10, 7, 8, 4, 65, 64, 64,
                                76, 69, 74, 92, 86, 97, 68, 22, 18, 11, 3, 7,
                                65, 70, 72, 81, 66, 36, 21, 15, 8, 12, 1, 68,
                                73, 83, 4, 38, 29, 24, 18, 16, 5, 64, 70, 78,
                                70, 39, 27, 13, 3, 8, 68, 77, 83, 5, 49, 38, 29,
                                21, 21, 5, 66, 71, 75, 62, 90, 87, 75, 89, 88,
                                81, 83, 81, 81, 82, 80, 81, 84, 80, 85, 82, 67,
                                80, 77, 75, 73, 68, 68, 68, 66, 64, 67, 70, 74,
                                11, 9, 14, 6, 2, 12, 9, 6, 7, 8, 6, 5, 64, 67,
                                71, 66, 7, 77, 8, 22, 6, 7, 13, 14, 15, 8, 11,
                                11, 17, 65, 68, 73, 36, 36, 42, 31, 30, 38, 40,
                                40, 44, 40, 47, 46, 37, 30, 10, 34, 46, 32, 29,
                                31, 27, 19, 16, 13, 6, 65, 69, 74, 83, 31, 30,
                                31, 25, 15, 18, 13, 5, 5, 2, 65, 74, 74, 84, 87,
                                69, 70, 85, 15, 16, 10, 64, 7, 6, 67, 3, 1, 69,
                                79, 79, 87, 99, 9, 64, 75, 74, 1, 0, 4, 7, 7,
                                13, 9, 12, 14, 25, 16, 16, 25, 24, 55, 42, 33,
                                24, 17, 7, 67, 80, 101, 5, 37, 30, 28, 21, 22,
                                11, 7, 7, 66, 79, 73, 65, 72, 4, 12, 69, 71, 3,
                                7, 4, 7, 14, 4, 2, 52, 38, 24, 11, 1, 77, 89,
                                99, 111 },

                              {

                              53,
                                7, 77, 53, 7, 77, 92, 75, 18, 11, 4, 2, 33, 37,
                                53, 14, 71, 0, 2, 12, 0, 64, 68, 71, 86, 9, 27,
                                99, 110, 115, 69, 79, 68, 2, 12, 0, 78, 73, 10,
                                7, 65, 73, 82, 1, 75, 79, 90, 5, 72, 81, 3, 74,
                                77, 88, 5, 67, 69, 73, 0, 4, 22, 0, 0, 0, 71,
                                91, 97, 0, 6, 65, 18, 73, 92, 92, 0, 69, 25, 16,
                                69, 0, 82, 64, 79, 76, 90, 83, 82, 87, 91, 21,
                                0, 8, 81, 70, 80, 77, 97, 3, 67, 66, 76, 17, 68,
                                64, 78, 82, 70, 73, 68, 7, 7, 64, 12, 14, 76,
                                64, 65, 67, 4, 73, 15, 69, 1, 15, 16, 24, 18,
                                11, 80, 64, 70, 1, 3, 91, 64, 8, 4, 5, 7, 7, 17,
                                10, 3, 1, 2, 1, 7, 7, 84, 67, 1, 74, 5, 4, 13,
                                6, 2, 10, 6, 4, 3, 13, 3, 76, 3, 80, 22, 21, 16,
                                14, 17, 17, 10, 16, 19, 64, 10, 9, 6, 3, 68, 5,
                                64, 2, 4, 1, 5, 10, 0, 80, 0, 74, 64, 5, 82, 25,
                                33, 25, 24, 23, 22, 20, 20, 14, 6, 4, 1, 66, 69,
                                91, 68, 65, 78, 13, 9, 6, 7, 2, 66, 65, 66, 76,
                                70, 75, 92, 86, 96, 68, 22, 18, 11, 3, 7, 65,
                                70, 72, 80, 65, 36, 21, 15, 8, 12, 1, 68, 73,
                                81, 4, 38, 29, 24, 18, 16, 5, 64, 70, 77, 70,
                                39, 26, 13, 3, 8, 68, 77, 83, 5, 48, 37, 28, 20,
                                21, 5, 66, 71, 75, 62, 89, 86, 74, 87, 87, 80,
                                82, 79, 80, 80, 79, 79, 83, 80, 84, 81, 66, 79,
                                78, 75, 72, 68, 68, 69, 67, 65, 68, 71, 75, 10,
                                9, 14, 6, 1, 11, 9, 6, 6, 7, 6, 4, 65, 68, 71,
                                66, 7, 77, 7, 21, 5, 7, 12, 13, 15, 7, 10, 11,
                                17, 66, 69, 75, 35, 36, 41, 30, 28, 37, 38, 38,
                                42, 38, 44, 43, 34, 28, 8, 31, 42, 29, 25, 29,
                                25, 17, 15, 11, 6, 64, 68, 73, 81, 30, 28, 29,
                                24, 13, 16, 11, 3, 4, 0, 67, 76, 75, 85, 88, 70,
                                70, 86, 13, 15, 8, 65, 5, 4, 68, 1, 64, 70, 80,
                                80, 88, 99, 8, 64, 76, 74, 1, 1, 5, 7, 8, 14, 9,
                                13, 15, 26, 17, 17, 26, 25, 54, 40, 31, 22, 14,
                                4, 70, 83, 104, 5, 37, 30, 28, 22, 22, 11, 8, 7,
                                66, 78, 73, 64, 72, 5, 13, 69, 70, 4, 8, 4, 7,
                                15, 4, 2, 50, 36, 22, 8, 65, 81, 93, 102, 114 },

                              {

                              52,
                                7, 77, 52, 7, 77, 90, 73, 18, 11, 3, 0, 31, 36,
                                53, 14, 69, 0, 3, 13, 0, 64, 67, 72, 87, 9, 25,
                                101, 111, 115, 66, 77, 68, 3, 13, 0, 78, 72, 10,
                                7, 65, 73, 81, 1, 76, 79, 90, 5, 72, 80, 3, 74,
                                77, 88, 6, 67, 68, 73, 1, 4, 22, 0, 0, 0, 71,
                                91, 97, 1, 5, 65, 18, 72, 92, 90, 2, 68, 27, 18,
                                67, 1, 81, 0, 78, 75, 88, 82, 82, 86, 90, 21, 0,
                                8, 81, 70, 80, 76, 95, 3, 67, 66, 76, 17, 68, 0,
                                77, 82, 70, 73, 67, 7, 7, 64, 12, 14, 75, 64,
                                64, 67, 4, 73, 14, 69, 1, 14, 15, 24, 17, 10,
                                79, 0, 70, 0, 3, 90, 64, 8, 4, 5, 7, 7, 18, 10,
                                3, 1, 2, 1, 6, 7, 85, 67, 1, 74, 4, 3, 13, 6, 1,
                                10, 6, 4, 2, 13, 2, 76, 3, 80, 21, 21, 16, 14,
                                17, 17, 10, 16, 19, 64, 10, 9, 6, 3, 68, 5, 64,
                                1, 4, 1, 4, 9, 0, 80, 64, 74, 65, 4, 82, 24, 31,
                                24, 23, 21, 20, 18, 18, 12, 4, 2, 64, 68, 70,
                                92, 68, 65, 78, 12, 8, 5, 6, 1, 68, 66, 67, 77,
                                70, 75, 92, 86, 96, 68, 22, 18, 11, 3, 7, 64,
                                69, 71, 79, 65, 36, 21, 15, 8, 12, 2, 67, 72,
                                79, 4, 38, 29, 24, 18, 16, 5, 64, 70, 76, 70,
                                40, 26, 12, 3, 8, 68, 77, 82, 5, 48, 36, 27, 19,
                                21, 5, 66, 71, 74, 62, 88, 85, 73, 86, 86, 79,
                                81, 78, 79, 79, 77, 77, 82, 79, 84, 81, 65, 79,
                                78, 74, 71, 68, 69, 69, 67, 65, 69, 72, 76, 9,
                                8, 14, 5, 1, 11, 9, 6, 5, 6, 6, 4, 66, 68, 71,
                                66, 7, 77, 6, 21, 5, 7, 11, 12, 15, 6, 9, 10,
                                16, 67, 70, 77, 34, 35, 41, 29, 27, 35, 36, 36,
                                40, 35, 41, 41, 31, 26, 7, 28, 39, 26, 21, 26,
                                22, 15, 14, 10, 6, 0, 68, 72, 79, 28, 27, 27,
                                22, 11, 14, 10, 1, 3, 65, 68, 78, 77, 86, 89,
                                70, 70, 87, 12, 13, 6, 67, 4, 3, 70, 0, 65, 72,
                                81, 81, 89, 100, 8, 65, 77, 73, 2, 1, 5, 8, 9,
                                15, 10, 14, 16, 28, 18, 18, 27, 27, 54, 38, 29,
                                19, 12, 1, 73, 86, 106, 5, 38, 31, 29, 22, 23,
                                11, 8, 8, 65, 78, 73, 0, 71, 6, 14, 68, 69, 4,
                                8, 4, 8, 16, 4, 2, 49, 34, 19, 5, 68, 84, 97,
                                106, 117 },

                              {

                              51,
                                7, 78, 51, 7, 78, 88, 72, 19, 11, 3, 64, 30, 35,
                                53, 14, 67, 0, 3, 14, 0, 65, 67, 73, 88, 8, 24,
                                102, 112, 116, 0, 76, 68, 3, 14, 0, 77, 71, 11,
                                6, 64, 72, 80, 0, 76, 79, 90, 5, 71, 80, 3, 74,
                                76, 88, 6, 67, 68, 73, 1, 4, 22, 0, 0, 0, 70,
                                91, 97, 1, 5, 66, 18, 72, 91, 88, 4, 66, 28, 20,
                                66, 2, 79, 1, 77, 75, 87, 82, 82, 86, 90, 22, 0,
                                8, 80, 69, 79, 76, 94, 3, 68, 67, 77, 17, 68, 0,
                                77, 82, 69, 73, 67, 7, 7, 0, 12, 13, 75, 64, 64,
                                67, 4, 73, 13, 69, 1, 13, 14, 23, 17, 10, 79, 0,
                                70, 0, 2, 90, 65, 8, 4, 5, 7, 7, 18, 10, 3, 1,
                                3, 1, 5, 7, 85, 68, 1, 75, 4, 2, 13, 6, 0, 10,
                                6, 4, 0, 13, 1, 76, 3, 81, 20, 21, 15, 14, 17,
                                17, 10, 16, 19, 64, 9, 9, 5, 3, 68, 4, 65, 1, 3,
                                0, 3, 8, 64, 80, 64, 73, 66, 2, 82, 22, 29, 22,
                                21, 19, 18, 16, 16, 10, 2, 1, 65, 70, 72, 93,
                                68, 65, 79, 11, 7, 4, 4, 64, 69, 67, 68, 78, 71,
                                76, 92, 86, 95, 67, 22, 18, 11, 4, 7, 64, 69,
                                71, 78, 64, 35, 21, 15, 8, 13, 2, 66, 71, 77, 4,
                                39, 29, 24, 18, 17, 5, 64, 69, 76, 70, 40, 26,
                                12, 3, 8, 67, 76, 81, 5, 47, 36, 26, 19, 21, 5,
                                65, 70, 74, 62, 88, 84, 73, 85, 85, 78, 79, 77,
                                78, 78, 76, 76, 82, 78, 84, 80, 0, 79, 79, 74,
                                71, 68, 69, 70, 67, 66, 70, 73, 77, 9, 8, 14, 5,
                                0, 10, 8, 6, 5, 6, 5, 4, 66, 68, 72, 66, 7, 78,
                                6, 20, 4, 6, 10, 12, 16, 6, 8, 10, 16, 67, 70,
                                78, 33, 34, 40, 28, 26, 34, 34, 34, 38, 33, 39,
                                38, 28, 23, 6, 26, 36, 23, 17, 23, 20, 13, 13,
                                9, 6, 1, 68, 70, 76, 26, 25, 25, 20, 9, 12, 8,
                                64, 1, 66, 69, 79, 78, 87, 90, 71, 71, 88, 11,
                                12, 5, 69, 2, 1, 71, 65, 67, 73, 83, 83, 91,
                                101, 7, 66, 78, 73, 2, 1, 6, 8, 9, 17, 11, 15,
                                17, 29, 20, 19, 29, 28, 53, 37, 27, 17, 9, 64,
                                76, 88, 108, 6, 38, 31, 29, 22, 24, 12, 8, 8,
                                65, 78, 72, 0, 71, 7, 15, 68, 69, 5, 9, 4, 8,
                                17, 4, 2, 48, 32, 17, 2, 72, 88, 100, 109, 119 },

                              {

                              50,
                                7, 78, 50, 7, 78, 86, 70, 19, 11, 2, 66, 28, 33,
                                53, 14, 64, 64, 4, 14, 0, 66, 67, 74, 89, 8, 22,
                                104, 113, 116, 3, 75, 68, 4, 14, 0, 77, 70, 11,
                                6, 64, 72, 80, 0, 77, 78, 90, 5, 71, 79, 2, 74,
                                76, 88, 7, 66, 68, 72, 2, 4, 22, 0, 0, 0, 70,
                                91, 97, 2, 4, 66, 18, 72, 91, 87, 6, 65, 30, 22,
                                65, 3, 78, 3, 76, 74, 85, 81, 81, 85, 89, 22, 0,
                                8, 80, 69, 79, 75, 92, 2, 68, 67, 77, 17, 68, 0,
                                76, 82, 69, 73, 66, 7, 6, 0, 12, 13, 75, 64, 64,
                                67, 4, 73, 13, 69, 1, 13, 13, 22, 16, 9, 78, 1,
                                70, 64, 2, 89, 65, 8, 3, 5, 7, 7, 19, 11, 3, 1,
                                3, 1, 4, 7, 86, 68, 1, 75, 3, 1, 12, 6, 0, 11,
                                6, 4, 64, 12, 0, 76, 3, 81, 20, 21, 15, 14, 17,
                                17, 10, 16, 19, 64, 9, 9, 5, 3, 68, 4, 65, 0, 3,
                                0, 3, 7, 64, 80, 65, 73, 67, 1, 82, 21, 27, 20,
                                19, 17, 16, 14, 14, 8, 0, 64, 67, 73, 74, 94,
                                68, 66, 79, 10, 6, 3, 3, 65, 71, 68, 69, 78, 71,
                                76, 92, 86, 95, 67, 22, 18, 11, 4, 7, 64, 69,
                                70, 77, 64, 35, 21, 15, 8, 13, 3, 65, 71, 75, 4,
                                39, 29, 24, 18, 17, 5, 64, 69, 75, 70, 40, 25,
                                11, 3, 8, 67, 76, 81, 5, 47, 35, 25, 18, 21, 5,
                                65, 70, 73, 62, 87, 83, 72, 83, 84, 77, 78, 75,
                                77, 76, 74, 74, 81, 77, 83, 80, 1, 78, 79, 74,
                                70, 68, 70, 70, 68, 67, 71, 74, 78, 8, 7, 14, 4,
                                0, 10, 8, 6, 4, 5, 5, 3, 67, 68, 72, 66, 7, 78,
                                5, 20, 3, 6, 9, 11, 16, 5, 7, 9, 15, 68, 71, 80,
                                32, 34, 40, 27, 24, 32, 32, 32, 36, 30, 36, 36,
                                25, 21, 4, 23, 32, 20, 13, 21, 17, 11, 12, 8, 6,
                                2, 67, 69, 74, 25, 23, 23, 19, 7, 10, 7, 66, 0,
                                68, 71, 81, 80, 88, 91, 71, 71, 89, 9, 10, 3,
                                70, 0, 64, 73, 66, 69, 75, 84, 84, 92, 101, 6,
                                66, 79, 73, 3, 2, 6, 9, 10, 18, 12, 16, 18, 30,
                                21, 20, 30, 29, 53, 35, 25, 14, 7, 67, 79, 91,
                                110, 6, 39, 32, 30, 23, 25, 12, 9, 9, 64, 77,
                                72, 1, 70, 8, 16, 68, 68, 5, 9, 4, 9, 18, 4, 2,
                                46, 30, 14, 64, 75, 92, 104, 113, 122 },

                              {

                              48,
                                6, 78, 48, 6, 78, 85, 69, 19, 11, 2, 67, 27, 32,
                                53, 14, 1, 64, 5, 15, 0, 67, 67, 75, 91, 7, 20,
                                106, 114, 117, 5, 74, 68, 5, 15, 0, 77, 69, 11,
                                5, 64, 72, 79, 64, 77, 78, 91, 5, 71, 79, 2, 75,
                                76, 88, 7, 66, 68, 72, 2, 4, 22, 0, 0, 0, 69,
                                92, 97, 2, 3, 66, 18, 72, 91, 85, 7, 0, 31, 23,
                                64, 4, 77, 4, 75, 73, 83, 81, 81, 85, 88, 22, 0,
                                8, 79, 69, 78, 75, 91, 2, 69, 68, 78, 17, 68, 0,
                                76, 82, 69, 73, 66, 6, 6, 0, 12, 12, 75, 64, 64,
                                67, 3, 73, 12, 70, 1, 12, 11, 21, 15, 8, 78, 1,
                                70, 65, 1, 89, 66, 7, 3, 5, 7, 7, 20, 11, 3, 0,
                                3, 0, 3, 6, 87, 68, 1, 76, 3, 0, 12, 5, 64, 11,
                                6, 4, 66, 12, 64, 76, 3, 82, 19, 20, 15, 14, 17,
                                16, 9, 16, 18, 65, 8, 9, 5, 2, 69, 3, 66, 0, 2,
                                64, 2, 6, 65, 80, 65, 73, 68, 64, 82, 19, 25,
                                18, 17, 15, 13, 12, 12, 6, 65, 66, 69, 75, 76,
                                95, 68, 66, 80, 9, 4, 1, 1, 67, 72, 70, 71, 79,
                                72, 77, 92, 86, 94, 67, 22, 18, 11, 4, 7, 64,
                                69, 70, 76, 0, 35, 21, 15, 8, 13, 3, 65, 70, 74,
                                4, 39, 29, 24, 17, 17, 5, 64, 69, 75, 70, 40,
                                25, 11, 3, 8, 67, 76, 80, 5, 46, 34, 24, 17, 20,
                                5, 65, 70, 73, 62, 86, 82, 72, 82, 83, 77, 77,
                                74, 76, 75, 73, 73, 81, 77, 83, 79, 2, 78, 80,
                                74, 70, 68, 70, 71, 68, 68, 72, 76, 79, 7, 7,
                                14, 4, 64, 9, 7, 5, 3, 4, 4, 3, 68, 69, 73, 66,
                                7, 79, 4, 19, 2, 6, 8, 10, 16, 4, 6, 9, 15, 69,
                                72, 82, 31, 33, 39, 25, 23, 31, 30, 30, 33, 28,
                                33, 33, 22, 18, 3, 20, 29, 17, 9, 18, 15, 9, 10,
                                6, 6, 2, 67, 68, 72, 23, 21, 21, 17, 4, 8, 5,
                                68, 65, 70, 72, 83, 81, 89, 92, 72, 72, 90, 8,
                                9, 1, 72, 65, 66, 74, 68, 71, 76, 85, 86, 94,
                                102, 5, 67, 80, 73, 3, 2, 7, 9, 10, 19, 12, 17,
                                19, 31, 22, 21, 31, 30, 52, 33, 23, 12, 4, 70,
                                82, 94, 113, 6, 39, 32, 30, 23, 25, 12, 9, 9,
                                64, 77, 72, 1, 70, 9, 17, 68, 68, 6, 10, 4, 9,
                                18, 4, 1, 45, 28, 12, 67, 78, 96, 108, 116, 125 },

                              {

                              47,
                                6, 78, 47, 6, 78, 83, 68, 20, 11, 2, 68, 26, 31,
                                53, 14, 3, 64, 6, 16, 0, 67, 66, 76, 92, 6, 18,
                                107, 115, 118, 8, 72, 68, 6, 16, 0, 76, 68, 12,
                                4, 64, 71, 78, 64, 77, 78, 91, 5, 71, 78, 2, 75,
                                76, 88, 7, 66, 67, 72, 2, 4, 22, 0, 0, 0, 68,
                                92, 97, 2, 2, 66, 18, 71, 91, 83, 9, 2, 32, 25,
                                1, 5, 75, 5, 73, 72, 81, 81, 81, 85, 87, 22, 0,
                                8, 78, 69, 77, 74, 90, 2, 69, 68, 78, 17, 68, 1,
                                75, 81, 68, 73, 66, 6, 6, 0, 12, 12, 74, 64, 0,
                                67, 3, 72, 11, 70, 1, 11, 10, 21, 14, 7, 77, 1,
                                69, 66, 0, 89, 67, 7, 3, 6, 7, 7, 21, 11, 3, 0,
                                4, 0, 3, 6, 88, 68, 1, 77, 3, 64, 12, 5, 65, 11,
                                6, 4, 67, 12, 64, 76, 3, 83, 18, 20, 15, 14, 17,
                                16, 9, 16, 18, 65, 8, 9, 5, 2, 69, 3, 66, 0, 2,
                                64, 1, 6, 65, 80, 65, 73, 69, 65, 82, 17, 24,
                                17, 16, 13, 11, 11, 11, 4, 67, 67, 70, 77, 77,
                                96, 68, 66, 81, 8, 3, 0, 0, 68, 73, 71, 72, 80,
                                73, 78, 92, 85, 93, 66, 23, 18, 11, 4, 8, 0, 68,
                                69, 75, 1, 35, 21, 15, 8, 14, 3, 64, 69, 72, 4,
                                39, 29, 24, 17, 18, 5, 64, 69, 74, 70, 41, 25,
                                11, 3, 9, 67, 76, 79, 5, 46, 34, 24, 16, 20, 5,
                                65, 69, 72, 62, 85, 81, 71, 81, 81, 76, 75, 73,
                                74, 74, 72, 71, 80, 76, 83, 78, 4, 78, 81, 73,
                                69, 68, 70, 72, 68, 68, 73, 77, 80, 7, 7, 14, 4,
                                64, 8, 7, 5, 2, 4, 4, 3, 69, 69, 73, 65, 8, 79,
                                4, 18, 2, 6, 8, 10, 16, 3, 5, 9, 15, 70, 72, 83,
                                31, 32, 38, 24, 22, 30, 28, 28, 31, 26, 31, 30,
                                20, 16, 2, 17, 26, 14, 5, 15, 13, 8, 9, 5, 6, 3,
                                67, 67, 70, 21, 20, 19, 15, 2, 7, 4, 70, 66, 71,
                                73, 84, 82, 90, 92, 72, 72, 91, 7, 8, 0, 74, 66,
                                67, 75, 69, 72, 77, 86, 87, 95, 103, 5, 68, 80,
                                72, 3, 2, 8, 10, 11, 20, 13, 18, 20, 33, 23, 22,
                                33, 32, 51, 32, 21, 10, 1, 73, 85, 97, 115, 7,
                                39, 32, 31, 23, 26, 13, 9, 10, 0, 77, 71, 2, 70,
                                10, 19, 67, 67, 7, 11, 4, 10, 19, 4, 1, 44, 26,
                                10, 69, 81, 99, 112, 119, 126 },

                              {

                              46,
                                6, 78, 46, 6, 78, 81, 66, 20, 11, 1, 70, 24, 29,
                                53, 14, 6, 65, 7, 16, 0, 68, 66, 77, 93, 6, 16,
                                109, 116, 118, 11, 71, 68, 7, 16, 0, 76, 67, 12,
                                4, 64, 71, 78, 64, 78, 77, 91, 5, 71, 77, 1, 75,
                                76, 88, 8, 65, 67, 71, 3, 4, 22, 0, 0, 0, 68,
                                92, 97, 3, 1, 66, 18, 71, 91, 82, 11, 3, 34, 27,
                                2, 6, 74, 7, 72, 71, 79, 80, 80, 84, 86, 22, 0,
                                8, 78, 69, 77, 74, 88, 1, 69, 68, 78, 17, 68, 1,
                                75, 81, 68, 73, 65, 6, 5, 0, 12, 12, 74, 64, 0,
                                67, 3, 72, 11, 70, 1, 11, 9, 20, 13, 6, 76, 2,
                                69, 67, 0, 88, 67, 7, 2, 6, 7, 7, 22, 12, 3, 0,
                                4, 0, 2, 6, 89, 68, 1, 77, 2, 65, 11, 5, 65, 12,
                                6, 4, 68, 11, 65, 76, 3, 83, 18, 20, 15, 14, 17,
                                16, 9, 16, 18, 65, 8, 9, 5, 2, 69, 3, 66, 64, 2,
                                64, 1, 5, 66, 80, 66, 73, 70, 66, 82, 16, 22,
                                15, 14, 11, 9, 9, 9, 2, 69, 69, 72, 80, 79, 97,
                                68, 67, 81, 7, 2, 64, 64, 70, 75, 72, 73, 80,
                                73, 78, 92, 85, 93, 66, 23, 18, 11, 4, 8, 0, 68,
                                69, 74, 1, 35, 21, 15, 8, 14, 4, 0, 69, 70, 4,
                                39, 29, 24, 17, 18, 5, 64, 69, 73, 70, 41, 24,
                                10, 3, 9, 67, 76, 79, 5, 45, 33, 23, 15, 20, 5,
                                65, 69, 72, 62, 84, 80, 70, 79, 80, 75, 74, 71,
                                73, 72, 70, 69, 79, 75, 82, 78, 5, 77, 81, 73,
                                68, 68, 71, 72, 69, 69, 74, 78, 81, 6, 6, 14, 3,
                                65, 8, 7, 5, 1, 3, 4, 2, 70, 69, 73, 65, 8, 79,
                                3, 18, 1, 6, 7, 9, 16, 2, 4, 8, 14, 71, 73, 85,
                                30, 32, 38, 23, 20, 28, 26, 26, 29, 23, 28, 28,
                                17, 14, 0, 14, 22, 11, 1, 13, 10, 6, 8, 4, 6, 4,
                                66, 66, 68, 20, 18, 17, 14, 0, 5, 2, 72, 67, 73,
                                75, 86, 84, 91, 93, 73, 72, 92, 5, 6, 65, 75,
                                68, 69, 77, 71, 74, 79, 87, 88, 96, 103, 4, 68,
                                81, 72, 4, 3, 8, 10, 12, 21, 14, 19, 21, 34, 24,
                                23, 34, 33, 51, 30, 19, 7, 64, 76, 88, 100, 117,
                                7, 40, 33, 31, 24, 27, 13, 10, 10, 0, 76, 71, 3,
                                69, 11, 20, 67, 66, 7, 11, 4, 10, 20, 4, 1, 42,
                                24, 7, 72, 84, 103, 116, 123, 126 },

                              {

                              45,
                                6, 79, 45, 6, 79, 79, 65, 21, 11, 1, 71, 23, 28,
                                53, 14, 8, 65, 7, 17, 0, 69, 66, 78, 94, 5, 15,
                                110, 117, 119, 14, 70, 68, 7, 17, 0, 75, 66, 13,
                                3, 0, 70, 77, 65, 78, 77, 91, 5, 70, 77, 1, 75,
                                75, 88, 8, 65, 67, 71, 3, 4, 22, 0, 0, 0, 67,
                                92, 97, 3, 1, 67, 18, 71, 90, 80, 13, 5, 35, 29,
                                3, 7, 72, 8, 71, 71, 78, 80, 80, 84, 86, 23, 0,
                                8, 77, 68, 76, 73, 87, 1, 70, 69, 79, 17, 68, 1,
                                74, 81, 67, 73, 65, 6, 5, 1, 12, 11, 74, 64, 0,
                                67, 3, 72, 10, 70, 1, 10, 8, 19, 13, 6, 76, 2,
                                69, 67, 64, 88, 68, 7, 2, 6, 7, 7, 22, 12, 3, 0,
                                5, 0, 1, 6, 89, 69, 1, 78, 2, 66, 11, 5, 66, 12,
                                6, 4, 70, 11, 66, 76, 3, 84, 17, 20, 14, 14, 17,
                                16, 9, 16, 18, 65, 7, 9, 4, 2, 69, 2, 67, 64, 1,
                                65, 0, 4, 66, 80, 66, 72, 71, 68, 82, 14, 20,
                                13, 12, 9, 7, 7, 7, 0, 71, 70, 73, 82, 81, 98,
                                68, 67, 82, 6, 1, 65, 66, 71, 76, 73, 74, 81,
                                74, 79, 92, 85, 92, 65, 23, 18, 11, 5, 8, 0, 68,
                                68, 73, 2, 34, 21, 15, 8, 15, 4, 1, 68, 68, 4,
                                40, 29, 24, 17, 19, 5, 64, 68, 73, 70, 41, 24,
                                10, 3, 9, 66, 75, 78, 5, 45, 33, 22, 15, 20, 5,
                                64, 68, 71, 62, 84, 79, 70, 78, 79, 74, 72, 70,
                                72, 71, 69, 68, 79, 74, 82, 77, 7, 77, 82, 73,
                                68, 68, 71, 73, 69, 70, 75, 79, 82, 6, 6, 14, 3,
                                65, 7, 6, 5, 1, 3, 3, 2, 70, 69, 74, 65, 8, 80,
                                3, 17, 0, 5, 6, 9, 17, 2, 3, 8, 14, 71, 73, 86,
                                29, 31, 37, 22, 19, 27, 24, 24, 27, 21, 26, 25,
                                14, 11, 64, 12, 19, 8, 66, 10, 8, 4, 7, 3, 6, 5,
                                66, 64, 65, 18, 16, 15, 12, 65, 3, 1, 74, 69,
                                74, 76, 87, 85, 92, 94, 73, 73, 93, 4, 5, 66,
                                77, 70, 71, 78, 72, 76, 80, 89, 90, 98, 104, 3,
                                69, 82, 72, 4, 3, 9, 11, 12, 23, 15, 20, 22, 35,
                                26, 24, 36, 34, 50, 29, 17, 5, 67, 78, 91, 102,
                                119, 8, 40, 33, 32, 24, 28, 14, 10, 11, 1, 76,
                                70, 3, 69, 12, 21, 67, 66, 8, 12, 4, 11, 21, 4,
                                1, 41, 22, 5, 75, 88, 107, 119, 126, 126 },

                              {

                              43,
                                6, 79, 43, 6, 79, 78, 0, 21, 11, 0, 73, 21, 27,
                                53, 14, 10, 65, 8, 18, 0, 70, 66, 79, 95, 5, 13,
                                112, 118, 119, 17, 69, 68, 8, 18, 0, 75, 65, 13,
                                3, 0, 70, 76, 65, 79, 77, 91, 5, 70, 76, 1, 76,
                                75, 88, 9, 65, 67, 71, 4, 4, 22, 0, 0, 0, 67,
                                93, 97, 4, 0, 67, 18, 71, 90, 78, 14, 6, 37, 30,
                                4, 8, 71, 9, 70, 70, 76, 79, 80, 83, 85, 23, 0,
                                8, 77, 68, 76, 73, 85, 1, 70, 69, 79, 17, 68, 1,
                                74, 81, 67, 73, 64, 6, 5, 1, 12, 11, 74, 64, 0,
                                67, 3, 72, 9, 71, 1, 9, 7, 18, 12, 5, 75, 3, 69,
                                68, 64, 87, 68, 7, 2, 6, 7, 7, 23, 12, 3, 64, 5,
                                64, 0, 5, 90, 69, 1, 78, 1, 67, 11, 4, 67, 12,
                                6, 4, 71, 11, 67, 76, 3, 84, 16, 20, 14, 14, 17,
                                16, 9, 16, 17, 65, 7, 9, 4, 2, 70, 2, 67, 65, 1,
                                65, 64, 3, 67, 80, 67, 72, 72, 69, 82, 13, 18,
                                11, 10, 7, 5, 5, 5, 65, 73, 72, 75, 84, 83, 99,
                                68, 67, 82, 5, 0, 66, 67, 73, 78, 74, 76, 82,
                                74, 79, 92, 85, 92, 65, 23, 18, 11, 5, 8, 0, 68,
                                68, 72, 2, 34, 21, 15, 8, 15, 5, 1, 67, 66, 4,
                                40, 29, 24, 17, 19, 5, 64, 68, 72, 70, 41, 24,
                                9, 3, 9, 66, 75, 77, 5, 44, 32, 21, 14, 20, 5,
                                64, 68, 71, 62, 83, 78, 69, 77, 78, 73, 71, 69,
                                71, 70, 67, 66, 78, 74, 82, 77, 8, 77, 82, 73,
                                67, 68, 72, 73, 69, 71, 76, 80, 83, 5, 5, 14, 2,
                                66, 7, 6, 5, 0, 2, 3, 2, 71, 70, 74, 65, 8, 80,
                                2, 17, 64, 5, 5, 8, 17, 1, 2, 7, 13, 72, 74, 88,
                                28, 30, 37, 21, 18, 25, 22, 22, 25, 18, 23, 23,
                                11, 9, 65, 9, 16, 5, 70, 7, 5, 2, 6, 1, 6, 6,
                                66, 0, 0, 16, 14, 13, 10, 67, 1, 64, 76, 70, 76,
                                77, 89, 87, 93, 95, 74, 73, 94, 3, 3, 68, 79,
                                72, 73, 80, 74, 78, 82, 90, 91, 99, 105, 2, 70,
                                83, 72, 5, 3, 9, 11, 13, 24, 15, 21, 23, 36, 27,
                                25, 37, 35, 50, 27, 15, 2, 69, 81, 94, 105, 122,
                                8, 41, 34, 32, 24, 28, 14, 10, 11, 1, 76, 70, 4,
                                68, 13, 22, 67, 65, 8, 12, 4, 11, 22, 4, 1, 40,
                                20, 2, 78, 91, 111, 123, 126, 126 },

                              {

                              42,
                                6, 79, 42, 6, 79, 76, 1, 21, 11, 0, 74, 20, 25,
                                53, 14, 13, 66, 9, 18, 0, 70, 65, 80, 96, 4, 11,
                                114, 119, 120, 20, 67, 68, 9, 18, 0, 75, 64, 13,
                                2, 0, 70, 76, 65, 79, 76, 91, 5, 70, 75, 0, 76,
                                75, 88, 9, 64, 66, 70, 4, 4, 22, 0, 0, 0, 66,
                                93, 97, 4, 64, 67, 18, 70, 90, 77, 16, 8, 38,
                                32, 6, 9, 70, 11, 69, 69, 74, 79, 79, 83, 84,
                                23, 0, 8, 76, 68, 75, 72, 84, 0, 70, 69, 79, 17,
                                68, 2, 73, 81, 67, 73, 64, 6, 4, 1, 12, 11, 73,
                                64, 1, 67, 3, 72, 9, 71, 1, 9, 6, 18, 11, 4, 74,
                                3, 69, 69, 65, 87, 69, 7, 1, 6, 7, 7, 24, 13, 3,
                                64, 5, 64, 64, 5, 91, 69, 1, 79, 1, 68, 10, 4,
                                67, 13, 6, 4, 72, 10, 68, 76, 3, 85, 16, 20, 14,
                                14, 17, 16, 9, 16, 17, 65, 7, 9, 4, 2, 70, 2,
                                67, 65, 1, 65, 64, 2, 67, 80, 67, 72, 73, 70,
                                82, 11, 16, 10, 9, 5, 3, 3, 3, 67, 75, 74, 77,
                                87, 84, 100, 68, 68, 83, 4, 64, 67, 68, 74, 79,
                                75, 77, 82, 75, 80, 92, 85, 91, 65, 23, 18, 11,
                                5, 8, 1, 67, 67, 71, 3, 34, 21, 15, 8, 15, 5, 2,
                                67, 64, 4, 40, 29, 24, 17, 19, 5, 64, 68, 71,
                                70, 42, 23, 9, 3, 9, 66, 75, 77, 5, 44, 31, 20,
                                13, 20, 5, 64, 68, 70, 62, 82, 77, 68, 75, 77,
                                72, 70, 67, 70, 68, 66, 64, 77, 73, 81, 76, 9,
                                76, 83, 72, 66, 68, 72, 74, 70, 71, 77, 81, 84,
                                4, 5, 14, 2, 66, 6, 6, 5, 64, 1, 3, 1, 72, 70,
                                74, 65, 8, 80, 1, 16, 64, 5, 4, 7, 17, 0, 1, 7,
                                13, 73, 75, 90, 27, 30, 36, 20, 16, 24, 20, 20,
                                23, 16, 20, 20, 8, 7, 67, 6, 12, 2, 74, 5, 3, 0,
                                5, 0, 6, 7, 65, 1, 2, 15, 13, 11, 9, 69, 64, 65,
                                78, 71, 78, 79, 91, 88, 94, 96, 74, 73, 95, 1,
                                2, 70, 80, 73, 74, 81, 75, 79, 83, 91, 92, 100,
                                105, 2, 70, 84, 71, 5, 4, 10, 12, 14, 25, 16,
                                22, 24, 38, 28, 26, 38, 37, 49, 25, 13, 0, 72,
                                84, 97, 108, 124, 8, 41, 34, 33, 25, 29, 14, 11,
                                12, 2, 75, 70, 5, 68, 14, 23, 66, 64, 9, 13, 4,
                                12, 23, 4, 1, 38, 18, 0, 81, 94, 114, 126, 126,
                                126 },

                              {

                              41,
                                6, 79, 41, 6, 79, 74, 3, 22, 11, 64, 76, 18, 24,
                                53, 14, 15, 66, 10, 19, 0, 71, 65, 81, 97, 4, 9,
                                115, 120, 120, 23, 66, 68, 10, 19, 0, 74, 0, 14,
                                2, 0, 69, 75, 66, 80, 76, 91, 5, 70, 75, 0, 76,
                                75, 88, 10, 64, 66, 70, 5, 4, 22, 0, 0, 0, 66,
                                93, 97, 5, 65, 67, 18, 70, 90, 75, 18, 9, 40,
                                34, 7, 10, 68, 12, 68, 68, 72, 78, 79, 82, 83,
                                23, 0, 8, 76, 68, 75, 72, 82, 0, 71, 70, 80, 17,
                                68, 2, 73, 81, 66, 73, 0, 6, 4, 1, 12, 10, 73,
                                64, 1, 67, 3, 72, 8, 71, 1, 8, 5, 17, 10, 3, 74,
                                4, 69, 70, 65, 86, 69, 7, 1, 6, 7, 7, 25, 13, 3,
                                64, 6, 64, 65, 5, 92, 69, 1, 79, 0, 69, 10, 4,
                                68, 13, 6, 4, 74, 10, 69, 76, 3, 85, 15, 20, 14,
                                14, 17, 16, 9, 16, 17, 65, 6, 9, 4, 2, 70, 1,
                                68, 66, 0, 66, 65, 1, 68, 80, 68, 72, 74, 72,
                                82, 10, 14, 8, 7, 3, 1, 1, 1, 69, 77, 75, 78,
                                89, 86, 101, 68, 68, 83, 3, 65, 68, 70, 76, 81,
                                76, 78, 83, 75, 80, 92, 85, 91, 64, 23, 18, 11,
                                5, 8, 1, 67, 67, 70, 3, 34, 21, 15, 8, 16, 6, 3,
                                66, 1, 4, 40, 29, 24, 17, 20, 5, 64, 68, 71, 70,
                                42, 23, 8, 3, 9, 66, 75, 76, 5, 43, 31, 19, 12,
                                20, 5, 64, 67, 70, 62, 81, 76, 68, 74, 76, 71,
                                68, 66, 69, 67, 64, 0, 77, 72, 81, 76, 11, 76,
                                83, 72, 66, 68, 73, 74, 70, 72, 78, 82, 85, 4,
                                4, 14, 1, 67, 6, 5, 5, 65, 1, 2, 1, 73, 70, 75,
                                65, 8, 81, 1, 16, 65, 5, 3, 7, 17, 64, 0, 6, 12,
                                74, 75, 91, 26, 29, 36, 19, 15, 22, 18, 18, 21,
                                13, 18, 18, 5, 4, 68, 3, 9, 64, 78, 2, 0, 65, 4,
                                64, 6, 8, 65, 2, 4, 13, 11, 9, 7, 71, 66, 67,
                                80, 73, 79, 80, 92, 90, 95, 97, 75, 74, 96, 0,
                                0, 71, 82, 75, 76, 83, 77, 81, 85, 92, 94, 102,
                                106, 1, 71, 85, 71, 6, 4, 10, 12, 14, 26, 17,
                                23, 25, 39, 29, 27, 40, 38, 49, 24, 11, 66, 74,
                                87, 100, 111, 126, 9, 42, 35, 33, 25, 30, 15,
                                11, 12, 2, 75, 69, 5, 67, 15, 24, 66, 64, 9, 13,
                                4, 12, 24, 4, 1, 37, 16, 66, 84, 97, 118, 126,
                                126, 126 },

                              {

                              40,
                                6, 79, 40, 6, 79, 72, 4, 22, 11, 64, 77, 17, 23,
                                53, 14, 17, 66, 11, 20, 0, 72, 65, 82, 98, 3, 7,
                                117, 121, 121, 26, 65, 68, 11, 20, 0, 74, 1, 14,
                                1, 0, 69, 74, 66, 80, 76, 91, 5, 70, 74, 0, 76,
                                75, 88, 10, 64, 66, 70, 5, 4, 22, 0, 0, 0, 65,
                                93, 97, 5, 66, 67, 18, 70, 90, 73, 20, 11, 41,
                                36, 8, 11, 67, 13, 67, 67, 70, 78, 79, 82, 82,
                                23, 0, 8, 75, 68, 74, 71, 81, 0, 71, 70, 80, 17,
                                68, 2, 72, 81, 66, 73, 0, 6, 4, 1, 12, 10, 73,
                                64, 1, 67, 3, 72, 7, 71, 1, 7, 4, 16, 9, 2, 73,
                                4, 69, 71, 66, 86, 70, 7, 1, 6, 7, 7, 26, 13, 3,
                                64, 6, 64, 66, 5, 93, 69, 1, 80, 0, 70, 10, 4,
                                69, 13, 6, 4, 75, 10, 70, 76, 3, 86, 14, 20, 14,
                                14, 17, 16, 9, 16, 17, 65, 6, 9, 4, 2, 70, 1,
                                68, 66, 0, 66, 66, 0, 68, 80, 68, 72, 75, 73,
                                82, 8, 12, 6, 5, 1, 64, 64, 64, 71, 79, 77, 80,
                                91, 88, 102, 68, 68, 84, 2, 66, 69, 71, 77, 82,
                                77, 79, 84, 76, 81, 92, 85, 90, 64, 23, 18, 11,
                                5, 8, 1, 67, 66, 69, 4, 34, 21, 15, 8, 16, 6, 4,
                                65, 3, 4, 40, 29, 24, 17, 20, 5, 64, 68, 70, 70,
                                42, 23, 8, 3, 9, 66, 75, 75, 5, 43, 30, 18, 11,
                                20, 5, 64, 67, 69, 62, 80, 75, 67, 73, 75, 70,
                                67, 65, 68, 66, 0, 2, 76, 71, 81, 75, 12, 76,
                                84, 72, 65, 68, 73, 75, 70, 73, 79, 83, 86, 3,
                                4, 14, 1, 67, 5, 5, 5, 66, 0, 2, 1, 74, 70, 75,
                                65, 8, 81, 0, 15, 66, 5, 2, 6, 17, 65, 64, 6,
                                12, 75, 76, 93, 25, 28, 35, 18, 14, 21, 16, 16,
                                19, 11, 15, 15, 2, 2, 69, 0, 6, 67, 82, 64, 65,
                                67, 3, 65, 6, 9, 65, 3, 6, 11, 9, 7, 5, 73, 68,
                                68, 82, 74, 81, 81, 94, 91, 96, 98, 75, 74, 97,
                                64, 64, 73, 84, 77, 78, 84, 78, 83, 86, 93, 95,
                                103, 107, 0, 72, 86, 71, 6, 4, 11, 13, 15, 27,
                                18, 24, 26, 40, 30, 28, 41, 39, 48, 22, 9, 68,
                                77, 90, 103, 114, 126, 9, 42, 35, 34, 25, 31,
                                15, 11, 13, 3, 75, 69, 6, 67, 16, 25, 66, 0, 10,
                                14, 4, 13, 25, 4, 1, 36, 14, 68, 87, 100, 122,
                                126, 126, 126 },

                              {

                              38,
                                5, 80, 38, 5, 80, 71, 5, 22, 11, 65, 79, 15, 21,
                                52, 14, 19, 67, 11, 20, 64, 73, 65, 84, 100, 2,
                                5, 119, 122, 122, 28, 64, 69, 11, 20, 64, 74, 2,
                                14, 0, 0, 69, 74, 67, 81, 76, 92, 5, 70, 74, 64,
                                77, 75, 88, 10, 64, 66, 70, 5, 3, 22, 0, 0, 0,
                                65, 94, 97, 5, 67, 68, 18, 70, 90, 72, 21, 12,
                                42, 37, 9, 12, 66, 14, 66, 67, 69, 78, 79, 82,
                                82, 23, 0, 8, 75, 68, 74, 71, 80, 64, 72, 71,
                                81, 17, 68, 2, 72, 81, 66, 73, 0, 5, 3, 1, 11,
                                9, 73, 65, 1, 67, 2, 72, 6, 72, 0, 6, 2, 15, 8,
                                1, 73, 4, 69, 72, 67, 86, 71, 6, 0, 6, 7, 7, 26,
                                13, 3, 65, 6, 65, 67, 4, 94, 70, 0, 81, 64, 71,
                                9, 3, 70, 13, 6, 4, 77, 9, 71, 76, 3, 87, 13,
                                19, 13, 14, 17, 15, 8, 16, 16, 66, 5, 9, 3, 1,
                                71, 0, 69, 67, 64, 67, 67, 64, 69, 80, 69, 72,
                                76, 75, 82, 6, 10, 4, 3, 64, 67, 66, 66, 73, 81,
                                79, 82, 94, 90, 104, 69, 69, 85, 1, 68, 71, 73,
                                79, 84, 79, 81, 85, 77, 82, 92, 85, 90, 64, 23,
                                18, 11, 5, 8, 1, 67, 66, 68, 4, 33, 21, 15, 8,
                                16, 6, 4, 65, 4, 3, 40, 29, 23, 16, 20, 5, 64,
                                68, 70, 70, 42, 22, 7, 2, 9, 66, 75, 75, 5, 42,
                                29, 17, 10, 19, 5, 64, 67, 69, 62, 80, 74, 67,
                                72, 74, 70, 66, 64, 67, 65, 1, 3, 76, 71, 81,
                                75, 13, 76, 85, 72, 65, 68, 74, 76, 71, 74, 80,
                                85, 88, 2, 3, 14, 0, 68, 4, 4, 4, 67, 64, 1, 0,
                                75, 71, 76, 65, 8, 82, 64, 14, 67, 4, 1, 5, 17,
                                66, 66, 5, 11, 76, 77, 95, 24, 27, 34, 16, 12,
                                19, 14, 14, 16, 8, 12, 12, 64, 64, 71, 66, 2,
                                70, 87, 67, 68, 69, 1, 67, 6, 9, 65, 4, 8, 9, 7,
                                5, 3, 76, 70, 70, 85, 76, 83, 83, 96, 93, 97,
                                99, 76, 75, 99, 66, 66, 75, 86, 79, 80, 86, 80,
                                85, 88, 95, 97, 105, 108, 64, 73, 87, 71, 6, 4,
                                11, 13, 15, 28, 18, 25, 26, 41, 31, 29, 42, 40,
                                47, 20, 6, 71, 80, 93, 107, 117, 126, 9, 42, 35,
                                34, 25, 31, 15, 11, 13, 3, 75, 69, 6, 67, 17,
                                26, 66, 0, 10, 14, 4, 13, 25, 4, 0, 34, 11, 71,
                                90, 104, 126, 126, 126, 126 },

                              {

                              37,
                                5, 80, 37, 5, 80, 69, 7, 23, 12, 65, 80, 14, 20,
                                52, 14, 22, 67, 12, 21, 64, 73, 64, 85, 101, 2,
                                4, 120, 123, 122, 31, 1, 69, 12, 21, 64, 73, 4,
                                15, 0, 1, 68, 73, 67, 81, 75, 92, 5, 69, 73, 64,
                                77, 74, 88, 11, 0, 65, 69, 6, 3, 22, 0, 0, 0,
                                64, 94, 97, 6, 67, 68, 18, 69, 89, 70, 23, 14,
                                44, 39, 11, 13, 64, 16, 64, 66, 67, 77, 78, 81,
                                81, 24, 1, 9, 74, 67, 73, 70, 78, 64, 72, 71,
                                81, 18, 68, 3, 71, 80, 65, 72, 1, 5, 3, 2, 11,
                                9, 72, 65, 2, 67, 2, 71, 6, 72, 0, 6, 1, 15, 8,
                                1, 72, 5, 68, 72, 67, 85, 71, 6, 0, 7, 7, 7, 27,
                                14, 4, 65, 7, 65, 67, 4, 94, 70, 0, 81, 64, 72,
                                9, 3, 70, 14, 7, 4, 78, 9, 71, 75, 3, 87, 13,
                                19, 13, 14, 17, 15, 8, 16, 16, 66, 5, 9, 3, 1,
                                71, 0, 69, 67, 64, 67, 67, 64, 69, 79, 69, 71,
                                76, 76, 81, 5, 9, 3, 2, 66, 69, 67, 67, 75, 82,
                                80, 83, 96, 91, 105, 69, 69, 85, 0, 69, 72, 74,
                                80, 85, 80, 82, 85, 77, 82, 91, 84, 89, 0, 24,
                                18, 11, 6, 9, 2, 66, 65, 66, 5, 33, 21, 15, 8,
                                17, 7, 5, 64, 6, 3, 41, 30, 23, 16, 21, 5, 64,
                                67, 69, 70, 43, 22, 7, 2, 10, 65, 74, 74, 5, 42,
                                29, 17, 10, 19, 5, 0, 66, 68, 62, 79, 73, 66,
                                70, 72, 69, 64, 1, 65, 0, 3, 5, 75, 70, 80, 74,
                                15, 75, 85, 71, 64, 67, 74, 76, 71, 74, 80, 86,
                                89, 2, 3, 15, 0, 68, 4, 4, 4, 67, 64, 1, 0, 75,
                                71, 76, 64, 9, 82, 64, 14, 67, 4, 1, 5, 18, 66,
                                67, 5, 11, 76, 77, 96, 24, 27, 34, 15, 11, 18,
                                12, 12, 14, 6, 10, 10, 66, 66, 72, 68, 64, 73,
                                91, 69, 70, 70, 0, 68, 6, 10, 64, 6, 11, 8, 6,
                                4, 2, 78, 71, 71, 87, 77, 84, 84, 97, 94, 98,
                                99, 76, 75, 100, 67, 67, 76, 87, 80, 81, 87, 81,
                                86, 89, 96, 98, 106, 108, 64, 73, 87, 70, 7, 5,
                                12, 14, 16, 30, 19, 26, 27, 43, 33, 30, 44, 42,
                                47, 19, 4, 73, 82, 95, 110, 119, 126, 10, 43,
                                36, 35, 26, 32, 16, 12, 14, 4, 74, 68, 7, 66,
                                19, 28, 65, 1, 11, 15, 5, 14, 26, 4, 0, 33, 9,
                                73, 92, 107, 126, 126, 126, 126 },

                              {

                              36,
                                5, 80, 36, 5, 80, 67, 8, 23, 12, 65, 81, 13, 19,
                                52, 14, 24, 67, 13, 22, 64, 74, 64, 86, 102, 1,
                                2, 122, 124, 123, 34, 2, 69, 13, 22, 64, 73, 5,
                                15, 64, 1, 68, 72, 67, 81, 75, 92, 5, 69, 72,
                                64, 77, 74, 88, 11, 0, 65, 69, 6, 3, 22, 0, 0,
                                0, 0, 94, 97, 6, 68, 68, 18, 69, 89, 68, 25, 16,
                                45, 41, 12, 14, 0, 17, 0, 65, 65, 77, 78, 81,
                                80, 24, 1, 9, 73, 67, 72, 70, 77, 64, 72, 71,
                                81, 18, 68, 3, 71, 80, 65, 72, 1, 5, 3, 2, 11,
                                9, 72, 65, 2, 67, 2, 71, 5, 72, 0, 5, 0, 14, 7,
                                0, 71, 5, 68, 73, 68, 85, 72, 6, 0, 7, 7, 7, 28,
                                14, 4, 65, 7, 65, 68, 4, 95, 70, 0, 82, 64, 73,
                                9, 3, 71, 14, 7, 4, 79, 9, 72, 75, 3, 88, 12,
                                19, 13, 14, 17, 15, 8, 16, 16, 66, 5, 9, 3, 1,
                                71, 0, 69, 67, 64, 67, 68, 65, 70, 79, 69, 71,
                                77, 77, 81, 3, 7, 1, 0, 68, 71, 69, 69, 77, 84,
                                82, 85, 98, 93, 106, 69, 69, 86, 64, 70, 73, 75,
                                82, 86, 81, 83, 86, 78, 83, 91, 84, 88, 0, 24,
                                18, 11, 6, 9, 2, 66, 65, 65, 6, 33, 21, 15, 8,
                                17, 7, 6, 0, 8, 3, 41, 30, 23, 16, 21, 5, 64,
                                67, 68, 70, 43, 22, 7, 2, 10, 65, 74, 73, 5, 41,
                                28, 16, 9, 19, 5, 0, 66, 68, 62, 78, 72, 65, 69,
                                71, 68, 0, 2, 64, 1, 4, 7, 74, 69, 80, 73, 16,
                                75, 86, 71, 0, 67, 74, 77, 71, 75, 81, 87, 90,
                                1, 3, 15, 0, 69, 3, 4, 4, 68, 65, 1, 0, 76, 71,
                                76, 64, 9, 82, 65, 13, 68, 4, 0, 4, 18, 67, 68,
                                5, 11, 77, 78, 98, 23, 26, 33, 14, 10, 17, 10,
                                10, 12, 4, 7, 7, 69, 68, 73, 71, 67, 76, 95, 72,
                                72, 72, 64, 69, 6, 11, 64, 7, 13, 6, 4, 2, 0,
                                80, 73, 73, 89, 78, 86, 85, 99, 95, 99, 100, 77,
                                75, 101, 68, 68, 78, 89, 82, 83, 88, 83, 88, 90,
                                97, 99, 107, 109, 65, 74, 88, 70, 7, 5, 13, 14,
                                17, 31, 20, 27, 28, 44, 34, 31, 45, 43, 46, 17,
                                2, 75, 85, 98, 113, 122, 126, 10, 43, 36, 35,
                                26, 33, 16, 12, 14, 4, 74, 68, 8, 66, 20, 29,
                                65, 2, 12, 16, 5, 14, 27, 4, 0, 32, 7, 75, 95,
                                110, 126, 126, 126, 126 },

                              {

                              35,
                                5, 80, 35, 5, 80, 65, 10, 24, 12, 66, 83, 11,
                                18, 52, 14, 26, 67, 14, 23, 64, 75, 64, 87, 103,
                                1, 0, 123, 125, 123, 37, 3, 69, 14, 23, 64, 72,
                                6, 16, 64, 1, 67, 71, 68, 82, 75, 92, 5, 69, 72,
                                64, 77, 74, 88, 12, 0, 65, 69, 7, 3, 22, 0, 0,
                                0, 0, 94, 97, 7, 69, 68, 18, 69, 89, 66, 27, 17,
                                47, 43, 13, 15, 2, 18, 1, 64, 0, 76, 78, 80, 79,
                                24, 1, 9, 73, 67, 72, 69, 75, 64, 73, 72, 82,
                                18, 68, 3, 70, 80, 64, 72, 2, 5, 3, 2, 11, 8,
                                72, 65, 2, 67, 2, 71, 4, 72, 0, 4, 64, 13, 6,
                                64, 71, 6, 68, 74, 68, 84, 72, 6, 0, 7, 7, 7,
                                29, 14, 4, 65, 8, 65, 69, 4, 96, 70, 0, 82, 65,
                                74, 9, 3, 72, 14, 7, 4, 81, 9, 73, 75, 3, 88,
                                11, 19, 13, 14, 17, 15, 8, 16, 16, 66, 4, 9, 3,
                                1, 71, 64, 70, 68, 65, 68, 69, 66, 70, 79, 70,
                                71, 78, 79, 81, 2, 5, 64, 65, 70, 73, 71, 71,
                                79, 86, 83, 86, 100, 95, 107, 69, 69, 86, 65,
                                71, 74, 77, 83, 88, 82, 84, 87, 78, 83, 91, 84,
                                88, 1, 24, 18, 11, 6, 9, 2, 66, 64, 64, 6, 33,
                                21, 15, 8, 18, 8, 7, 1, 10, 3, 41, 30, 23, 16,
                                22, 5, 64, 67, 68, 70, 43, 22, 6, 2, 10, 65, 74,
                                72, 5, 41, 28, 15, 8, 19, 5, 0, 65, 67, 62, 77,
                                71, 65, 68, 70, 67, 2, 3, 0, 2, 6, 8, 74, 68,
                                80, 73, 18, 75, 86, 71, 0, 67, 75, 77, 71, 76,
                                82, 88, 91, 1, 2, 15, 64, 69, 3, 3, 4, 69, 65,
                                0, 0, 77, 71, 77, 64, 9, 83, 65, 13, 69, 4, 64,
                                4, 18, 68, 69, 4, 10, 78, 78, 99, 22, 25, 33,
                                13, 9, 15, 8, 8, 10, 1, 5, 5, 72, 71, 74, 74,
                                70, 79, 99, 75, 75, 74, 65, 70, 6, 12, 64, 8,
                                15, 4, 2, 0, 65, 82, 75, 74, 91, 80, 87, 86,
                                100, 97, 100, 101, 77, 76, 102, 69, 70, 79, 91,
                                84, 85, 90, 84, 90, 92, 98, 101, 109, 110, 66,
                                75, 89, 70, 8, 5, 13, 15, 17, 32, 21, 28, 29,
                                45, 35, 32, 47, 44, 46, 16, 0, 78, 87, 101, 116,
                                125, 126, 11, 44, 37, 36, 26, 34, 17, 12, 15, 5,
                                74, 67, 8, 65, 21, 30, 65, 2, 12, 16, 5, 15, 28,
                                4, 0, 31, 5, 78, 98, 113, 126, 126, 126, 126 },

                              {

                              33,
                                5, 80, 33, 5, 80, 64, 11, 24, 12, 66, 84, 10,
                                16, 52, 14, 29, 68, 15, 23, 64, 76, 64, 88, 104,
                                0, 65, 125, 126, 124, 40, 4, 69, 15, 23, 64, 72,
                                7, 16, 65, 1, 67, 71, 68, 82, 74, 92, 5, 69, 71,
                                65, 78, 74, 88, 12, 1, 65, 68, 7, 3, 22, 0, 0,
                                0, 1, 95, 97, 7, 70, 68, 18, 69, 89, 65, 28, 19,
                                48, 44, 14, 16, 3, 20, 2, 0, 2, 76, 77, 80, 78,
                                24, 1, 9, 72, 67, 71, 69, 74, 65, 73, 72, 82,
                                18, 68, 3, 70, 80, 64, 72, 2, 5, 2, 2, 11, 8,
                                72, 65, 2, 67, 2, 71, 4, 73, 0, 4, 65, 12, 5,
                                65, 70, 6, 68, 75, 69, 84, 73, 6, 64, 7, 7, 7,
                                30, 15, 4, 66, 8, 66, 70, 3, 97, 70, 0, 83, 65,
                                75, 8, 2, 72, 15, 7, 4, 82, 8, 74, 75, 3, 89,
                                11, 19, 13, 14, 17, 15, 8, 16, 15, 66, 4, 9, 3,
                                1, 72, 64, 70, 68, 65, 68, 69, 67, 71, 79, 70,
                                71, 79, 80, 81, 0, 3, 66, 67, 72, 75, 73, 73,
                                81, 88, 85, 88, 103, 97, 108, 69, 70, 87, 66,
                                72, 75, 78, 85, 89, 83, 86, 87, 79, 84, 91, 84,
                                87, 1, 24, 18, 11, 6, 9, 2, 66, 64, 0, 7, 33,
                                21, 15, 8, 18, 8, 7, 1, 12, 3, 41, 30, 23, 16,
                                22, 5, 64, 67, 67, 70, 43, 21, 6, 2, 10, 65, 74,
                                72, 5, 40, 27, 14, 7, 19, 5, 0, 65, 67, 62, 76,
                                70, 64, 66, 69, 66, 3, 5, 1, 4, 7, 10, 73, 68,
                                79, 72, 19, 74, 87, 71, 1, 67, 75, 78, 72, 77,
                                83, 89, 92, 0, 2, 15, 64, 70, 2, 3, 4, 70, 66,
                                0, 64, 78, 72, 77, 64, 9, 83, 66, 12, 70, 4, 65,
                                3, 18, 69, 70, 4, 10, 79, 79, 101, 21, 25, 32,
                                12, 7, 14, 6, 6, 8, 64, 2, 2, 75, 73, 76, 77,
                                74, 82, 103, 77, 77, 76, 66, 72, 6, 13, 0, 9,
                                17, 3, 0, 65, 66, 84, 77, 76, 93, 81, 89, 88,
                                102, 98, 101, 102, 78, 76, 103, 71, 71, 81, 92,
                                86, 87, 91, 86, 92, 93, 99, 102, 110, 110, 67,
                                75, 90, 70, 8, 6, 14, 15, 18, 33, 21, 29, 30,
                                46, 36, 33, 48, 45, 45, 14, 65, 80, 90, 104,
                                119, 126, 126, 11, 44, 37, 36, 27, 34, 17, 13,
                                15, 5, 73, 67, 9, 65, 22, 31, 65, 3, 13, 17, 5,
                                15, 29, 4, 0, 29, 3, 80, 101, 116, 126, 126,
                                126, 126 },

                              {

                              32,
                                5, 80, 32, 5, 80, 1, 13, 24, 12, 67, 86, 8, 15,
                                52, 14, 31, 68, 16, 24, 64, 76, 0, 89, 105, 0,
                                67, 126, 126, 124, 43, 6, 69, 16, 24, 64, 72, 8,
                                16, 65, 1, 67, 70, 68, 83, 74, 92, 5, 69, 70,
                                65, 78, 74, 88, 13, 1, 64, 68, 8, 3, 22, 0, 0,
                                0, 1, 95, 97, 8, 71, 68, 18, 68, 89, 0, 30, 20,
                                50, 46, 16, 17, 4, 21, 3, 1, 4, 75, 77, 79, 77,
                                24, 1, 9, 72, 67, 71, 68, 72, 65, 73, 72, 82,
                                18, 68, 4, 69, 80, 64, 72, 3, 5, 2, 2, 11, 8,
                                71, 65, 3, 67, 2, 71, 3, 73, 0, 3, 66, 12, 4,
                                66, 69, 7, 68, 76, 69, 83, 73, 6, 64, 7, 7, 7,
                                31, 15, 4, 66, 8, 66, 71, 3, 98, 70, 0, 83, 66,
                                76, 8, 2, 73, 15, 7, 4, 83, 8, 75, 75, 3, 89,
                                10, 19, 13, 14, 17, 15, 8, 16, 15, 66, 4, 9, 3,
                                1, 72, 64, 70, 69, 65, 68, 70, 68, 71, 79, 71,
                                71, 80, 81, 81, 64, 1, 67, 68, 74, 77, 75, 75,
                                83, 90, 87, 90, 105, 98, 109, 69, 70, 87, 67,
                                73, 76, 79, 86, 91, 84, 87, 88, 79, 84, 91, 84,
                                87, 1, 24, 18, 11, 6, 9, 3, 65, 0, 1, 7, 33, 21,
                                15, 8, 18, 9, 8, 2, 14, 3, 41, 30, 23, 16, 22,
                                5, 64, 67, 66, 70, 44, 21, 5, 2, 10, 65, 74, 71,
                                5, 40, 26, 13, 6, 19, 5, 0, 65, 66, 62, 75, 69,
                                0, 65, 68, 65, 4, 6, 2, 5, 9, 12, 72, 67, 79,
                                72, 20, 74, 87, 70, 2, 67, 76, 78, 72, 77, 84,
                                90, 93, 64, 1, 15, 65, 70, 2, 3, 4, 71, 67, 0,
                                64, 79, 72, 77, 64, 9, 83, 67, 12, 70, 4, 66, 2,
                                18, 70, 71, 3, 9, 80, 80, 103, 20, 24, 32, 11,
                                6, 12, 4, 4, 6, 67, 64, 0, 78, 75, 77, 80, 77,
                                85, 107, 80, 80, 78, 67, 73, 6, 14, 0, 10, 19,
                                1, 64, 67, 68, 86, 79, 77, 95, 82, 91, 89, 104,
                                100, 102, 103, 78, 76, 104, 72, 73, 83, 94, 87,
                                88, 93, 87, 93, 95, 100, 103, 111, 111, 67, 76,
                                91, 69, 9, 6, 14, 16, 19, 34, 22, 30, 31, 48,
                                37, 34, 49, 47, 45, 12, 67, 83, 92, 107, 122,
                                126, 126, 11, 45, 38, 37, 27, 35, 17, 13, 16, 6,
                                73, 67, 10, 64, 23, 32, 64, 4, 13, 17, 5, 16,
                                30, 4, 0, 28, 1, 83, 104, 119, 126, 126, 126,
                                126 },

                              {

                              31,
                                5, 81, 31, 5, 81, 3, 14, 25, 12, 67, 87, 7, 14,
                                52, 14, 33, 68, 16, 25, 64, 77, 0, 90, 106, 64,
                                68, 126, 126, 125, 46, 7, 69, 16, 25, 64, 71, 9,
                                17, 66, 2, 66, 69, 69, 83, 74, 92, 5, 68, 70,
                                65, 78, 73, 88, 13, 1, 64, 68, 8, 3, 22, 0, 0,
                                0, 2, 95, 97, 8, 71, 69, 18, 68, 88, 2, 32, 22,
                                51, 48, 17, 18, 6, 22, 4, 1, 5, 75, 77, 79, 77,
                                25, 1, 9, 71, 66, 70, 68, 71, 65, 74, 73, 83,
                                18, 68, 4, 69, 80, 0, 72, 3, 5, 2, 3, 11, 7, 71,
                                65, 3, 67, 2, 71, 2, 73, 0, 2, 67, 11, 4, 66,
                                69, 7, 68, 76, 70, 83, 74, 6, 64, 7, 7, 7, 31,
                                15, 4, 66, 9, 66, 72, 3, 98, 71, 0, 84, 66, 77,
                                8, 2, 74, 15, 7, 4, 85, 8, 76, 75, 3, 90, 9, 19,
                                12, 14, 17, 15, 8, 16, 15, 66, 3, 9, 2, 1, 72,
                                65, 71, 69, 66, 69, 71, 69, 72, 79, 71, 70, 81,
                                83, 81, 66, 64, 69, 70, 76, 79, 77, 77, 85, 92,
                                88, 91, 107, 100, 110, 69, 70, 88, 68, 74, 77,
                                81, 88, 92, 85, 88, 89, 80, 85, 91, 84, 86, 2,
                                24, 18, 11, 7, 9, 3, 65, 0, 2, 8, 32, 21, 15, 8,
                                19, 9, 9, 3, 16, 3, 42, 30, 23, 16, 23, 5, 64,
                                66, 66, 70, 44, 21, 5, 2, 10, 64, 73, 70, 5, 39,
                                26, 12, 6, 19, 5, 1, 64, 66, 62, 75, 68, 0, 64,
                                67, 64, 6, 7, 3, 6, 10, 13, 72, 66, 79, 71, 22,
                                74, 88, 70, 2, 67, 76, 79, 72, 78, 85, 91, 94,
                                64, 1, 15, 65, 71, 1, 2, 4, 71, 67, 64, 64, 79,
                                72, 78, 64, 9, 84, 67, 11, 71, 3, 67, 2, 19, 70,
                                72, 3, 9, 80, 80, 104, 19, 23, 31, 10, 5, 11, 2,
                                2, 4, 69, 66, 66, 81, 78, 78, 82, 80, 88, 111,
                                83, 82, 80, 68, 74, 6, 15, 0, 12, 22, 64, 66,
                                69, 70, 88, 81, 79, 97, 84, 92, 90, 105, 101,
                                103, 104, 79, 77, 105, 73, 74, 84, 96, 89, 90,
                                94, 89, 95, 96, 102, 105, 113, 112, 68, 77, 92,
                                69, 9, 6, 15, 16, 19, 36, 23, 31, 32, 49, 39,
                                35, 51, 48, 44, 11, 69, 85, 95, 109, 125, 126,
                                126, 12, 45, 38, 37, 27, 36, 18, 13, 16, 6, 73,
                                66, 10, 64, 24, 33, 64, 4, 14, 18, 5, 16, 31, 4,
                                0, 27, 64, 85, 107, 123, 126, 126, 126, 126 },

                              {

                              30,
                                5, 81, 30, 5, 81, 5, 16, 25, 12, 68, 89, 5, 12,
                                52, 14, 36, 69, 17, 25, 64, 78, 0, 91, 107, 64,
                                70, 126, 126, 125, 49, 8, 69, 17, 25, 64, 71,
                                10, 17, 66, 2, 66, 69, 69, 84, 73, 92, 5, 68,
                                69, 66, 78, 73, 88, 14, 2, 64, 67, 9, 3, 22, 0,
                                0, 0, 2, 95, 97, 9, 72, 69, 18, 68, 88, 3, 34,
                                23, 53, 50, 18, 19, 7, 24, 5, 2, 7, 74, 76, 78,
                                76, 25, 1, 9, 71, 66, 70, 67, 69, 66, 74, 73,
                                83, 18, 68, 4, 68, 80, 0, 72, 4, 5, 1, 3, 11, 7,
                                71, 65, 3, 67, 2, 71, 2, 73, 0, 2, 68, 10, 3,
                                67, 68, 8, 68, 77, 70, 82, 74, 6, 65, 7, 7, 7,
                                32, 16, 4, 66, 9, 66, 73, 3, 99, 71, 0, 84, 67,
                                78, 7, 2, 74, 16, 7, 4, 86, 7, 77, 75, 3, 90, 9,
                                19, 12, 14, 17, 15, 8, 16, 15, 66, 3, 9, 2, 1,
                                72, 65, 71, 70, 66, 69, 71, 70, 72, 79, 72, 70,
                                82, 84, 81, 67, 66, 71, 72, 78, 81, 79, 79, 87,
                                94, 90, 93, 110, 102, 111, 69, 71, 88, 69, 75,
                                78, 82, 89, 94, 86, 89, 89, 80, 85, 91, 84, 86,
                                2, 24, 18, 11, 7, 9, 3, 65, 1, 3, 8, 32, 21, 15,
                                8, 19, 10, 10, 3, 18, 3, 42, 30, 23, 16, 23, 5,
                                64, 66, 65, 70, 44, 20, 4, 2, 10, 64, 73, 70, 5,
                                39, 25, 11, 5, 19, 5, 1, 64, 65, 62, 74, 67, 1,
                                1, 66, 0, 7, 9, 4, 8, 12, 15, 71, 65, 78, 71,
                                23, 73, 88, 70, 3, 67, 77, 79, 73, 79, 86, 92,
                                95, 65, 0, 15, 66, 71, 1, 2, 4, 72, 68, 64, 65,
                                80, 72, 78, 64, 9, 84, 68, 11, 72, 3, 68, 1, 19,
                                71, 73, 2, 8, 81, 81, 106, 18, 23, 31, 9, 3, 9,
                                0, 0, 2, 72, 69, 68, 84, 80, 80, 85, 84, 91,
                                115, 85, 85, 82, 69, 75, 6, 16, 1, 13, 24, 65,
                                68, 71, 71, 90, 83, 80, 99, 85, 94, 92, 107,
                                103, 104, 105, 79, 77, 106, 75, 76, 86, 97, 91,
                                92, 96, 90, 97, 98, 103, 106, 114, 112, 69, 77,
                                93, 69, 10, 7, 15, 17, 20, 37, 24, 32, 33, 50,
                                40, 36, 52, 49, 44, 9, 71, 88, 97, 112, 126,
                                126, 126, 12, 46, 39, 38, 28, 37, 18, 14, 17, 7,
                                72, 66, 11, 0, 25, 34, 64, 5, 14, 18, 5, 17, 32,
                                4, 0, 25, 66, 88, 110, 126, 126, 126, 126, 126 },

                              {

                              28,
                                4, 81, 28, 4, 81, 6, 17, 25, 12, 68, 90, 4, 11,
                                52, 14, 38, 69, 18, 26, 64, 79, 0, 92, 109, 65,
                                72, 126, 126, 126, 51, 9, 69, 18, 26, 64, 71,
                                11, 17, 67, 2, 66, 68, 70, 84, 73, 93, 5, 68,
                                69, 66, 79, 73, 88, 14, 2, 64, 67, 9, 3, 22, 0,
                                0, 0, 3, 96, 97, 9, 73, 69, 18, 68, 88, 5, 35,
                                25, 54, 51, 19, 20, 8, 25, 6, 3, 9, 74, 76, 78,
                                75, 25, 1, 9, 70, 66, 69, 67, 68, 66, 75, 74,
                                84, 18, 68, 4, 68, 80, 0, 72, 4, 4, 1, 3, 11, 6,
                                71, 65, 3, 67, 1, 71, 1, 74, 0, 1, 70, 9, 2, 68,
                                68, 8, 68, 78, 71, 82, 75, 5, 65, 7, 7, 7, 33,
                                16, 4, 67, 9, 67, 74, 2, 100, 71, 0, 85, 67, 79,
                                7, 1, 75, 16, 7, 4, 88, 7, 78, 75, 3, 91, 8, 18,
                                12, 14, 17, 14, 7, 16, 14, 67, 2, 9, 2, 0, 73,
                                66, 72, 70, 67, 70, 72, 71, 73, 79, 72, 70, 83,
                                86, 81, 69, 68, 73, 74, 80, 84, 81, 81, 89, 96,
                                92, 95, 112, 104, 112, 69, 71, 89, 70, 77, 80,
                                84, 91, 95, 88, 91, 90, 81, 86, 91, 84, 85, 2,
                                24, 18, 11, 7, 9, 3, 65, 1, 4, 9, 32, 21, 15, 8,
                                19, 10, 10, 4, 19, 3, 42, 30, 23, 15, 23, 5, 64,
                                66, 65, 70, 44, 20, 4, 2, 10, 64, 73, 69, 5, 38,
                                24, 10, 4, 18, 5, 1, 64, 65, 62, 73, 66, 1, 2,
                                65, 0, 8, 10, 5, 9, 13, 16, 71, 65, 78, 70, 24,
                                73, 89, 70, 3, 67, 77, 80, 73, 80, 87, 94, 96,
                                66, 0, 15, 66, 72, 0, 1, 3, 73, 69, 65, 65, 81,
                                73, 79, 64, 9, 85, 69, 10, 73, 3, 69, 0, 19, 72,
                                74, 2, 8, 82, 82, 108, 17, 22, 30, 7, 2, 8, 65,
                                65, 64, 74, 72, 71, 87, 83, 81, 88, 87, 94, 119,
                                88, 87, 84, 71, 77, 6, 16, 1, 14, 26, 67, 70,
                                73, 73, 93, 85, 82, 101, 87, 96, 93, 109, 104,
                                105, 106, 80, 78, 107, 76, 77, 88, 99, 93, 94,
                                97, 92, 99, 99, 104, 108, 116, 113, 70, 78, 94,
                                69, 10, 7, 16, 17, 20, 38, 24, 33, 34, 51, 41,
                                37, 53, 50, 43, 7, 73, 90, 100, 115, 126, 126,
                                126, 12, 46, 39, 38, 28, 37, 18, 14, 17, 7, 72,
                                66, 11, 0, 26, 35, 64, 5, 15, 19, 5, 17, 32, 4,
                                64, 24, 68, 90, 113, 126, 126, 126, 126, 126 },

                              {

                              27,
                                4, 81, 27, 4, 81, 8, 18, 26, 12, 68, 91, 3, 10,
                                52, 14, 40, 69, 19, 27, 64, 79, 1, 93, 110, 66,
                                74, 126, 126, 126, 54, 11, 69, 19, 27, 64, 70,
                                12, 18, 68, 2, 65, 67, 70, 84, 73, 93, 5, 68,
                                68, 66, 79, 73, 88, 14, 2, 0, 67, 9, 3, 22, 0,
                                0, 0, 4, 96, 97, 9, 74, 69, 18, 67, 88, 7, 37,
                                27, 55, 53, 21, 21, 10, 26, 8, 4, 11, 74, 76,
                                78, 74, 25, 1, 9, 69, 66, 68, 66, 67, 66, 75,
                                74, 84, 18, 68, 5, 67, 79, 1, 72, 4, 4, 1, 3,
                                11, 6, 70, 65, 4, 67, 1, 70, 0, 74, 0, 0, 71, 9,
                                1, 69, 67, 8, 67, 79, 72, 82, 76, 5, 65, 8, 7,
                                7, 34, 16, 4, 67, 10, 67, 74, 2, 101, 71, 0, 86,
                                67, 80, 7, 1, 76, 16, 7, 4, 89, 7, 78, 75, 3,
                                92, 7, 18, 12, 14, 17, 14, 7, 16, 14, 67, 2, 9,
                                2, 0, 73, 66, 72, 70, 67, 70, 73, 71, 73, 79,
                                72, 70, 84, 87, 81, 71, 69, 74, 75, 82, 86, 82,
                                82, 91, 98, 93, 96, 114, 105, 113, 69, 71, 90,
                                71, 78, 81, 85, 92, 96, 89, 92, 91, 82, 87, 91,
                                83, 84, 3, 25, 18, 11, 7, 10, 4, 64, 2, 5, 10,
                                32, 21, 15, 8, 20, 10, 11, 5, 21, 3, 42, 30, 23,
                                15, 24, 5, 64, 66, 64, 70, 45, 20, 4, 2, 11, 64,
                                73, 68, 5, 38, 24, 10, 3, 18, 5, 1, 0, 64, 62,
                                72, 65, 2, 3, 0, 1, 10, 11, 7, 10, 14, 18, 70,
                                64, 78, 69, 26, 73, 90, 69, 4, 67, 77, 81, 73,
                                80, 88, 95, 97, 66, 0, 15, 66, 72, 64, 1, 3, 74,
                                69, 65, 65, 82, 73, 79, 0, 10, 85, 69, 9, 73, 3,
                                69, 0, 19, 73, 75, 2, 8, 83, 82, 109, 17, 21,
                                29, 6, 1, 7, 67, 67, 66, 76, 74, 74, 89, 85, 82,
                                91, 90, 97, 123, 91, 89, 85, 72, 78, 6, 17, 1,
                                15, 28, 69, 71, 75, 75, 95, 86, 83, 103, 88, 97,
                                94, 110, 105, 106, 106, 80, 78, 108, 77, 78, 89,
                                101, 94, 95, 98, 93, 100, 100, 105, 109, 117,
                                114, 70, 79, 94, 68, 10, 7, 17, 18, 21, 39, 25,
                                34, 35, 53, 42, 38, 55, 52, 42, 6, 75, 92, 103,
                                118, 126, 126, 126, 13, 46, 39, 39, 28, 38, 19,
                                14, 18, 8, 72, 65, 12, 0, 27, 37, 0, 6, 16, 20,
                                5, 18, 33, 4, 64, 23, 70, 92, 115, 126, 126,
                                126, 126, 126 },

                              {

                              26,
                                4, 81, 26, 4, 81, 10, 20, 26, 12, 69, 93, 1, 8,
                                52, 14, 43, 70, 20, 27, 64, 80, 1, 94, 111, 66,
                                76, 126, 126, 126, 57, 12, 69, 20, 27, 64, 70,
                                13, 18, 68, 2, 65, 67, 70, 85, 72, 93, 5, 68,
                                67, 67, 79, 73, 88, 15, 3, 0, 66, 10, 3, 22, 0,
                                0, 0, 4, 96, 97, 10, 75, 69, 18, 67, 88, 8, 39,
                                28, 57, 55, 22, 22, 11, 28, 9, 5, 13, 73, 75,
                                77, 73, 25, 1, 9, 69, 66, 68, 66, 65, 67, 75,
                                74, 84, 18, 68, 5, 67, 79, 1, 72, 5, 4, 0, 3,
                                11, 6, 70, 65, 4, 67, 1, 70, 0, 74, 0, 0, 72, 8,
                                0, 70, 66, 9, 67, 80, 72, 81, 76, 5, 66, 8, 7,
                                7, 35, 17, 4, 67, 10, 67, 75, 2, 102, 71, 0, 86,
                                68, 81, 6, 1, 76, 17, 7, 4, 90, 6, 79, 75, 3,
                                92, 7, 18, 12, 14, 17, 14, 7, 16, 14, 67, 2, 9,
                                2, 0, 73, 66, 72, 71, 67, 70, 73, 72, 74, 79,
                                73, 70, 85, 88, 81, 72, 71, 76, 77, 84, 88, 84,
                                84, 93, 100, 95, 98, 117, 107, 114, 69, 72, 90,
                                72, 79, 82, 86, 94, 98, 90, 93, 91, 82, 87, 91,
                                83, 84, 3, 25, 18, 11, 7, 10, 4, 64, 2, 6, 10,
                                32, 21, 15, 8, 20, 11, 12, 5, 23, 3, 42, 30, 23,
                                15, 24, 5, 64, 66, 0, 70, 45, 19, 3, 2, 11, 64,
                                73, 68, 5, 37, 23, 9, 2, 18, 5, 1, 0, 64, 62,
                                71, 64, 3, 5, 1, 2, 11, 13, 8, 12, 16, 20, 69,
                                0, 77, 69, 27, 72, 90, 69, 5, 67, 78, 81, 74,
                                81, 89, 96, 98, 67, 64, 15, 67, 73, 64, 1, 3,
                                75, 70, 65, 66, 83, 73, 79, 0, 10, 85, 70, 9,
                                74, 3, 70, 64, 19, 74, 76, 1, 7, 84, 83, 111,
                                16, 21, 29, 5, 64, 5, 69, 69, 68, 79, 77, 76,
                                92, 87, 84, 94, 94, 100, 126, 93, 92, 87, 73,
                                79, 6, 18, 2, 16, 30, 70, 73, 77, 76, 97, 88,
                                85, 105, 89, 99, 96, 112, 107, 107, 107, 81, 78,
                                109, 79, 80, 91, 102, 96, 97, 100, 95, 102, 102,
                                106, 110, 118, 114, 71, 79, 95, 68, 11, 8, 17,
                                18, 22, 40, 26, 35, 36, 54, 43, 39, 56, 53, 42,
                                4, 77, 95, 105, 121, 126, 126, 126, 13, 47, 40,
                                39, 29, 39, 19, 15, 18, 8, 71, 65, 13, 1, 28,
                                38, 0, 7, 16, 20, 5, 18, 34, 4, 64, 21, 72, 95,
                                118, 126, 126, 126, 126, 126 },

                              {

                              25,
                                4, 82, 25, 4, 82, 12, 21, 27, 12, 69, 94, 0, 7,
                                52, 14, 45, 70, 20, 28, 64, 81, 1, 95, 112, 67,
                                77, 126, 126, 126, 60, 13, 69, 20, 28, 64, 69,
                                14, 19, 69, 3, 64, 66, 71, 85, 72, 93, 5, 67,
                                67, 67, 79, 72, 88, 15, 3, 0, 66, 10, 3, 22, 0,
                                0, 0, 5, 96, 97, 10, 75, 70, 18, 67, 87, 10, 41,
                                30, 58, 57, 23, 23, 13, 29, 10, 5, 14, 73, 75,
                                77, 73, 26, 1, 9, 68, 65, 67, 65, 64, 67, 76,
                                75, 85, 18, 68, 5, 66, 79, 2, 72, 5, 4, 0, 4,
                                11, 5, 70, 65, 4, 67, 1, 70, 64, 74, 0, 64, 73,
                                7, 0, 70, 66, 9, 67, 80, 73, 81, 77, 5, 66, 8,
                                7, 7, 35, 17, 4, 67, 11, 67, 76, 2, 102, 72, 0,
                                87, 68, 82, 6, 1, 77, 17, 7, 4, 92, 6, 80, 75,
                                3, 93, 6, 18, 11, 14, 17, 14, 7, 16, 14, 67, 1,
                                9, 1, 0, 73, 67, 73, 71, 68, 71, 74, 73, 74, 79,
                                73, 69, 86, 90, 81, 74, 73, 78, 79, 86, 90, 86,
                                86, 95, 102, 96, 99, 119, 109, 115, 69, 72, 91,
                                73, 80, 83, 88, 95, 99, 91, 94, 92, 83, 88, 91,
                                83, 83, 4, 25, 18, 11, 8, 10, 4, 64, 3, 7, 11,
                                31, 21, 15, 8, 21, 11, 13, 6, 25, 3, 43, 30, 23,
                                15, 25, 5, 64, 65, 0, 70, 45, 19, 3, 2, 11, 0,
                                72, 67, 5, 37, 23, 8, 2, 18, 5, 2, 1, 0, 62, 71,
                                0, 3, 6, 2, 3, 13, 14, 9, 13, 17, 21, 69, 1, 77,
                                68, 29, 72, 91, 69, 5, 67, 78, 82, 74, 82, 90,
                                97, 99, 67, 64, 15, 67, 73, 65, 0, 3, 75, 70,
                                66, 66, 83, 73, 80, 0, 10, 86, 70, 8, 75, 2, 71,
                                64, 20, 74, 77, 1, 7, 84, 83, 112, 15, 20, 28,
                                4, 65, 4, 71, 71, 70, 81, 79, 79, 95, 90, 85,
                                96, 97, 103, 126, 96, 94, 89, 74, 80, 6, 19, 2,
                                18, 33, 72, 75, 79, 78, 99, 90, 86, 107, 91,
                                100, 97, 113, 108, 108, 108, 81, 79, 110, 80,
                                81, 92, 104, 98, 99, 101, 96, 104, 103, 108,
                                112, 120, 115, 72, 80, 96, 68, 11, 8, 18, 19,
                                22, 42, 27, 36, 37, 55, 45, 40, 58, 54, 41, 3,
                                79, 97, 108, 123, 126, 126, 126, 14, 47, 40, 40,
                                29, 40, 20, 15, 19, 9, 71, 64, 13, 1, 29, 39, 0,
                                7, 17, 21, 5, 19, 35, 4, 64, 20, 74, 97, 121,
                                126, 126, 126, 126, 126 },

                              {

                              23,
                                4, 82, 23, 4, 82, 13, 23, 27, 12, 70, 96, 65, 6,
                                52, 14, 47, 70, 21, 29, 64, 82, 1, 96, 113, 67,
                                79, 126, 126, 126, 62, 14, 69, 21, 29, 64, 69,
                                15, 19, 69, 3, 64, 65, 71, 86, 72, 93, 5, 67,
                                66, 67, 80, 72, 88, 16, 3, 0, 66, 11, 3, 22, 0,
                                0, 0, 5, 97, 97, 11, 76, 70, 18, 67, 87, 12, 42,
                                31, 60, 58, 24, 24, 14, 30, 11, 6, 16, 72, 75,
                                76, 72, 26, 1, 9, 68, 65, 67, 65, 1, 67, 76, 75,
                                85, 18, 68, 5, 66, 79, 2, 72, 6, 4, 0, 4, 11, 5,
                                70, 65, 4, 67, 1, 70, 65, 75, 0, 65, 74, 6, 64,
                                71, 65, 10, 67, 81, 73, 80, 77, 5, 66, 8, 7, 7,
                                36, 17, 4, 68, 11, 68, 77, 1, 103, 72, 0, 87,
                                69, 83, 6, 0, 78, 17, 7, 4, 93, 6, 81, 75, 3,
                                93, 5, 18, 11, 14, 17, 14, 7, 16, 13, 67, 1, 9,
                                1, 0, 74, 67, 73, 72, 68, 71, 75, 74, 75, 79,
                                74, 69, 87, 91, 81, 75, 75, 80, 81, 88, 92, 88,
                                88, 97, 104, 98, 101, 121, 111, 116, 69, 72, 91,
                                74, 81, 84, 89, 97, 101, 92, 96, 93, 83, 88, 91,
                                83, 83, 4, 25, 18, 11, 8, 10, 4, 64, 3, 8, 11,
                                31, 21, 15, 8, 21, 12, 13, 7, 27, 3, 43, 30, 23,
                                15, 25, 5, 64, 65, 1, 70, 45, 19, 2, 2, 11, 0,
                                72, 66, 5, 36, 22, 7, 1, 18, 5, 2, 1, 0, 62, 70,
                                1, 4, 7, 3, 4, 14, 15, 10, 14, 19, 23, 68, 1,
                                77, 68, 30, 72, 91, 69, 6, 67, 79, 82, 74, 83,
                                91, 98, 100, 68, 65, 15, 68, 74, 65, 0, 3, 76,
                                71, 66, 66, 84, 74, 80, 0, 10, 86, 71, 8, 76, 2,
                                72, 65, 20, 75, 78, 0, 6, 85, 84, 114, 14, 19,
                                28, 3, 66, 2, 73, 73, 72, 84, 82, 81, 98, 92,
                                86, 99, 100, 106, 126, 99, 97, 91, 75, 82, 6,
                                20, 2, 19, 35, 74, 77, 81, 80, 101, 92, 88, 109,
                                92, 102, 98, 115, 110, 109, 109, 82, 79, 111,
                                81, 83, 94, 106, 100, 101, 103, 98, 106, 105,
                                109, 113, 121, 116, 73, 81, 97, 68, 12, 8, 18,
                                19, 23, 43, 27, 37, 38, 56, 46, 41, 59, 55, 41,
                                1, 81, 100, 110, 126, 126, 126, 126, 14, 48, 41,
                                40, 29, 40, 20, 15, 19, 9, 71, 64, 14, 2, 30,
                                40, 0, 8, 17, 21, 5, 19, 36, 4, 64, 19, 76, 100,
                                124, 126, 126, 126, 126, 126 },

                              {

                              22,
                                4, 82, 22, 4, 82, 15, 24, 27, 12, 70, 97, 66, 4,
                                52, 14, 50, 71, 22, 29, 64, 82, 2, 97, 114, 68,
                                81, 126, 126, 126, 62, 16, 69, 22, 29, 64, 69,
                                16, 19, 70, 3, 64, 65, 71, 86, 71, 93, 5, 67,
                                65, 68, 80, 72, 88, 16, 4, 1, 65, 11, 3, 22, 0,
                                0, 0, 6, 97, 97, 11, 77, 70, 18, 66, 87, 13, 44,
                                33, 61, 60, 26, 25, 15, 32, 12, 7, 18, 72, 74,
                                76, 71, 26, 1, 9, 67, 65, 66, 64, 2, 68, 76, 75,
                                85, 18, 68, 6, 65, 79, 2, 72, 6, 4, 64, 4, 11,
                                5, 69, 65, 5, 67, 1, 70, 65, 75, 0, 65, 75, 6,
                                65, 72, 64, 10, 67, 82, 74, 80, 78, 5, 67, 8, 7,
                                7, 37, 18, 4, 68, 11, 68, 78, 1, 104, 72, 0, 88,
                                69, 84, 5, 0, 78, 18, 7, 4, 94, 5, 82, 75, 3,
                                94, 5, 18, 11, 14, 17, 14, 7, 16, 13, 67, 1, 9,
                                1, 0, 74, 67, 73, 72, 68, 71, 75, 75, 75, 79,
                                74, 69, 88, 92, 81, 77, 77, 81, 82, 90, 94, 90,
                                90, 99, 106, 100, 103, 124, 112, 117, 69, 73,
                                92, 75, 82, 85, 90, 98, 102, 93, 97, 93, 84, 89,
                                91, 83, 82, 4, 25, 18, 11, 8, 10, 5, 0, 4, 9,
                                12, 31, 21, 15, 8, 21, 12, 14, 7, 29, 3, 43, 30,
                                23, 15, 25, 5, 64, 65, 2, 70, 46, 18, 2, 2, 11,
                                0, 72, 66, 5, 36, 21, 6, 0, 18, 5, 2, 1, 1, 62,
                                69, 2, 5, 9, 4, 5, 15, 17, 11, 16, 20, 25, 67,
                                2, 76, 67, 31, 71, 92, 68, 7, 67, 79, 83, 75,
                                83, 92, 99, 101, 69, 65, 15, 68, 74, 66, 0, 3,
                                77, 72, 66, 67, 85, 74, 80, 0, 10, 86, 72, 7,
                                76, 2, 73, 66, 20, 76, 79, 0, 6, 86, 85, 116,
                                13, 19, 27, 2, 68, 1, 75, 75, 74, 86, 85, 84,
                                101, 94, 88, 102, 104, 109, 126, 101, 99, 93,
                                76, 83, 6, 21, 3, 20, 37, 75, 78, 83, 81, 103,
                                94, 89, 111, 93, 104, 100, 117, 111, 110, 110,
                                82, 79, 112, 83, 84, 96, 107, 101, 102, 104, 99,
                                107, 106, 110, 114, 122, 116, 73, 81, 98, 67,
                                12, 9, 19, 20, 24, 44, 28, 38, 39, 58, 47, 42,
                                60, 57, 40, 64, 83, 102, 113, 126, 126, 126,
                                126, 14, 48, 41, 41, 30, 41, 20, 16, 20, 10, 70,
                                64, 15, 2, 31, 41, 1, 9, 18, 22, 5, 20, 37, 4,
                                64, 17, 78, 102, 126, 126, 126, 126, 126, 126 },

                              {

                              21,
                                4, 82, 21, 4, 82, 17, 26, 28, 12, 71, 99, 68, 3,
                                52, 14, 52, 71, 23, 30, 64, 83, 2, 98, 115, 68,
                                83, 126, 126, 126, 62, 17, 69, 23, 30, 64, 68,
                                17, 20, 70, 3, 0, 64, 72, 87, 71, 93, 5, 67, 65,
                                68, 80, 72, 88, 17, 4, 1, 65, 12, 3, 22, 0, 0,
                                0, 6, 97, 97, 12, 78, 70, 18, 66, 87, 15, 46,
                                34, 62, 62, 27, 26, 17, 33, 13, 8, 20, 71, 74,
                                75, 70, 26, 1, 9, 67, 65, 66, 64, 4, 68, 77, 76,
                                86, 18, 68, 6, 65, 79, 3, 72, 7, 4, 64, 4, 11,
                                4, 69, 65, 5, 67, 1, 70, 66, 75, 0, 66, 76, 5,
                                66, 73, 64, 11, 67, 83, 74, 79, 78, 5, 67, 8, 7,
                                7, 38, 18, 4, 68, 12, 68, 79, 1, 105, 72, 0, 88,
                                70, 85, 5, 0, 79, 18, 7, 4, 96, 5, 83, 75, 3,
                                94, 4, 18, 11, 14, 17, 14, 7, 16, 13, 67, 0, 9,
                                1, 0, 74, 68, 74, 73, 69, 72, 76, 76, 76, 79,
                                75, 69, 89, 94, 81, 78, 79, 83, 84, 92, 96, 92,
                                92, 101, 108, 101, 104, 126, 114, 118, 69, 73,
                                92, 76, 83, 86, 92, 100, 104, 94, 98, 94, 84,
                                89, 91, 83, 82, 5, 25, 18, 11, 8, 10, 5, 0, 4,
                                10, 12, 31, 21, 15, 8, 22, 13, 15, 8, 31, 3, 43,
                                30, 23, 15, 26, 5, 64, 65, 2, 70, 46, 18, 1, 2,
                                11, 0, 72, 65, 5, 35, 21, 5, 64, 18, 5, 2, 2, 1,
                                62, 68, 3, 5, 10, 5, 6, 17, 18, 12, 17, 22, 26,
                                67, 3, 76, 67, 33, 71, 92, 68, 7, 67, 80, 83,
                                75, 84, 93, 100, 102, 69, 66, 15, 69, 75, 66,
                                64, 3, 78, 72, 67, 67, 86, 74, 81, 0, 10, 87,
                                72, 7, 77, 2, 74, 66, 20, 77, 80, 64, 5, 87, 85,
                                117, 12, 18, 27, 1, 69, 64, 77, 77, 76, 89, 87,
                                86, 104, 97, 89, 105, 107, 112, 126, 104, 102,
                                95, 77, 84, 6, 22, 3, 21, 39, 77, 80, 85, 83,
                                105, 96, 91, 113, 95, 105, 101, 118, 113, 111,
                                111, 83, 80, 113, 84, 86, 97, 109, 103, 104,
                                106, 101, 109, 108, 111, 116, 124, 117, 74, 82,
                                99, 67, 13, 9, 19, 20, 24, 45, 29, 39, 40, 59,
                                48, 43, 62, 58, 40, 65, 85, 105, 115, 126, 126,
                                126, 126, 15, 49, 42, 41, 30, 42, 21, 16, 20,
                                10, 70, 0, 15, 3, 32, 42, 1, 9, 18, 22, 5, 20,
                                38, 4, 64, 16, 80, 105, 126, 126, 126, 126, 126,
                                126 },

                              {

                              20,
                                4, 82, 20, 4, 82, 19, 27, 28, 12, 71, 100, 69,
                                2, 52, 14, 54, 71, 24, 31, 64, 84, 2, 99, 116,
                                69, 85, 126, 126, 126, 62, 18, 69, 24, 31, 64,
                                68, 18, 20, 71, 3, 0, 0, 72, 87, 71, 93, 5, 67,
                                64, 68, 80, 72, 88, 17, 4, 1, 65, 12, 3, 22, 0,
                                0, 0, 7, 97, 97, 12, 79, 70, 18, 66, 87, 17, 48,
                                36, 62, 62, 28, 27, 18, 34, 14, 9, 22, 71, 74,
                                75, 69, 26, 1, 9, 66, 65, 65, 0, 5, 68, 77, 76,
                                86, 18, 68, 6, 64, 79, 3, 72, 7, 4, 64, 4, 11,
                                4, 69, 65, 5, 67, 1, 70, 67, 75, 0, 67, 77, 4,
                                67, 74, 0, 11, 67, 84, 75, 79, 79, 5, 67, 8, 7,
                                7, 39, 18, 4, 68, 12, 68, 80, 1, 106, 72, 0, 89,
                                70, 86, 5, 0, 80, 18, 7, 4, 97, 5, 84, 75, 3,
                                95, 3, 18, 11, 14, 17, 14, 7, 16, 13, 67, 0, 9,
                                1, 0, 74, 68, 74, 73, 69, 72, 77, 77, 76, 79,
                                75, 69, 90, 95, 81, 80, 81, 85, 86, 94, 98, 94,
                                94, 103, 110, 103, 106, 126, 116, 119, 69, 73,
                                93, 77, 84, 87, 93, 101, 105, 95, 99, 95, 85,
                                90, 91, 83, 81, 5, 25, 18, 11, 8, 10, 5, 0, 5,
                                11, 13, 31, 21, 15, 8, 22, 13, 16, 9, 33, 3, 43,
                                30, 23, 15, 26, 5, 64, 65, 3, 70, 46, 18, 1, 2,
                                11, 0, 72, 64, 5, 35, 20, 4, 65, 18, 5, 2, 2, 2,
                                62, 67, 4, 6, 11, 6, 7, 18, 19, 13, 18, 23, 28,
                                66, 4, 76, 66, 34, 71, 93, 68, 8, 67, 80, 84,
                                75, 85, 94, 101, 103, 70, 66, 15, 69, 75, 67,
                                64, 3, 79, 73, 67, 67, 87, 74, 81, 0, 10, 87,
                                73, 6, 78, 2, 75, 67, 20, 78, 81, 64, 5, 88, 86,
                                119, 11, 17, 26, 0, 70, 65, 79, 79, 78, 91, 90,
                                89, 107, 99, 90, 108, 110, 115, 126, 107, 104,
                                97, 78, 85, 6, 23, 3, 22, 41, 79, 82, 87, 85,
                                107, 98, 92, 115, 96, 107, 102, 120, 114, 112,
                                112, 83, 80, 114, 85, 87, 99, 111, 105, 106,
                                107, 102, 111, 109, 112, 117, 125, 118, 75, 83,
                                100, 67, 13, 9, 20, 21, 25, 46, 30, 40, 41, 60,
                                49, 44, 62, 59, 39, 67, 87, 107, 118, 126, 126,
                                126, 126, 15, 49, 42, 42, 30, 43, 21, 16, 21,
                                11, 70, 0, 16, 3, 33, 43, 1, 10, 19, 23, 5, 21,
                                39, 4, 64, 15, 82, 107, 126, 126, 126, 126, 126,
                                126 },

                              {

                              18,
                                3, 83, 18, 3, 83, 20, 28, 28, 12, 72, 102, 71,
                                0, 51, 14, 56, 72, 24, 31, 65, 85, 2, 101, 118,
                                70, 87, 126, 126, 126, 62, 19, 70, 24, 31, 65,
                                68, 19, 20, 72, 3, 0, 0, 73, 88, 71, 94, 5, 67,
                                64, 69, 81, 72, 88, 17, 4, 1, 65, 12, 2, 22, 0,
                                0, 0, 7, 98, 97, 12, 80, 71, 18, 66, 87, 18, 49,
                                37, 62, 62, 29, 28, 19, 35, 15, 9, 23, 71, 74,
                                75, 69, 26, 1, 9, 66, 65, 65, 0, 6, 69, 78, 77,
                                87, 18, 68, 6, 64, 79, 3, 72, 7, 3, 65, 4, 10,
                                3, 69, 66, 5, 67, 0, 70, 68, 76, 64, 68, 79, 3,
                                68, 75, 0, 11, 67, 85, 76, 79, 80, 4, 68, 8, 7,
                                7, 39, 18, 4, 69, 12, 69, 81, 0, 107, 73, 64,
                                90, 71, 87, 4, 64, 81, 18, 7, 4, 99, 4, 85, 75,
                                3, 96, 2, 17, 10, 14, 17, 13, 6, 16, 12, 68, 64,
                                9, 0, 64, 75, 69, 75, 74, 70, 73, 78, 78, 77,
                                79, 76, 69, 91, 97, 81, 82, 83, 87, 88, 96, 101,
                                96, 96, 105, 112, 105, 108, 126, 118, 121, 70,
                                74, 94, 78, 86, 89, 95, 103, 107, 97, 101, 96,
                                86, 91, 91, 83, 81, 5, 25, 18, 11, 8, 10, 5, 0,
                                5, 12, 13, 30, 21, 15, 8, 22, 13, 16, 9, 34, 2,
                                43, 30, 22, 14, 26, 5, 64, 65, 3, 70, 46, 17, 0,
                                1, 11, 0, 72, 64, 5, 34, 19, 3, 66, 17, 5, 2, 2,
                                2, 62, 67, 5, 6, 12, 7, 7, 19, 20, 14, 19, 24,
                                29, 66, 4, 76, 66, 35, 71, 94, 68, 8, 67, 81,
                                85, 76, 86, 95, 103, 105, 71, 67, 15, 70, 76,
                                68, 65, 2, 80, 74, 68, 68, 88, 75, 82, 0, 10,
                                88, 74, 5, 79, 1, 76, 68, 20, 79, 83, 65, 4, 89,
                                87, 121, 10, 16, 25, 65, 72, 67, 81, 81, 81, 94,
                                93, 92, 110, 102, 92, 111, 114, 118, 126, 110,
                                107, 99, 80, 87, 6, 23, 3, 23, 43, 81, 84, 89,
                                87, 110, 100, 94, 118, 98, 109, 104, 122, 116,
                                113, 113, 84, 81, 116, 87, 89, 101, 113, 107,
                                108, 109, 104, 113, 111, 114, 119, 126, 119, 76,
                                84, 101, 67, 13, 9, 20, 21, 25, 47, 30, 41, 41,
                                61, 50, 45, 62, 60, 38, 69, 90, 110, 121, 126,
                                126, 126, 126, 15, 49, 42, 42, 30, 43, 21, 16,
                                21, 11, 70, 0, 16, 3, 34, 44, 1, 10, 19, 23, 5,
                                21, 39, 4, 65, 13, 85, 110, 126, 126, 126, 126,
                                126, 126 },

                              {

                              17,
                                3, 83, 17, 3, 83, 22, 30, 29, 13, 72, 103, 72,
                                64, 51, 14, 59, 72, 25, 32, 65, 85, 3, 102, 119,
                                70, 88, 126, 126, 126, 62, 21, 70, 25, 32, 65,
                                67, 21, 21, 72, 4, 1, 1, 73, 88, 70, 94, 5, 66,
                                0, 69, 81, 71, 88, 18, 5, 2, 64, 13, 2, 22, 0,
                                0, 0, 8, 98, 97, 13, 80, 71, 18, 65, 86, 20, 51,
                                39, 62, 62, 31, 29, 21, 37, 17, 10, 25, 70, 73,
                                74, 68, 27, 2, 10, 65, 64, 64, 1, 8, 69, 78, 77,
                                87, 19, 68, 7, 0, 78, 4, 71, 8, 3, 65, 5, 10, 3,
                                68, 66, 6, 67, 0, 69, 68, 76, 64, 68, 80, 3, 68,
                                75, 1, 12, 66, 85, 76, 78, 80, 4, 68, 9, 7, 7,
                                40, 19, 5, 69, 13, 69, 81, 0, 107, 73, 64, 90,
                                71, 88, 4, 64, 81, 19, 8, 4, 100, 4, 85, 74, 3,
                                96, 2, 17, 10, 14, 17, 13, 6, 16, 12, 68, 64, 9,
                                0, 64, 75, 69, 75, 74, 70, 73, 78, 78, 77, 78,
                                76, 68, 91, 98, 80, 83, 84, 88, 89, 98, 103, 97,
                                97, 107, 113, 106, 109, 126, 119, 122, 70, 74,
                                94, 79, 87, 90, 96, 104, 108, 98, 102, 96, 86,
                                91, 90, 82, 80, 6, 26, 18, 11, 9, 11, 6, 1, 6,
                                14, 14, 30, 21, 15, 8, 23, 14, 17, 10, 36, 2,
                                44, 31, 22, 14, 27, 5, 64, 64, 4, 70, 47, 17, 0,
                                1, 12, 1, 71, 0, 5, 34, 19, 3, 66, 17, 5, 3, 3,
                                3, 62, 66, 6, 7, 14, 9, 8, 21, 22, 16, 21, 26,
                                31, 65, 5, 75, 65, 37, 70, 94, 67, 9, 66, 81,
                                85, 76, 86, 95, 104, 106, 71, 67, 16, 70, 76,
                                68, 65, 2, 80, 74, 68, 68, 88, 75, 82, 1, 11,
                                88, 74, 5, 79, 1, 76, 68, 21, 79, 84, 65, 4, 89,
                                87, 122, 10, 16, 25, 66, 73, 68, 83, 83, 83, 96,
                                95, 94, 112, 104, 93, 113, 117, 121, 126, 112,
                                109, 100, 81, 88, 6, 24, 4, 25, 46, 82, 85, 90,
                                88, 112, 101, 95, 120, 99, 110, 105, 123, 117,
                                114, 113, 84, 81, 117, 88, 90, 102, 114, 108,
                                109, 110, 105, 114, 112, 115, 120, 126, 119, 76,
                                84, 101, 66, 14, 10, 21, 22, 26, 49, 31, 42, 42,
                                62, 52, 46, 62, 62, 38, 70, 92, 112, 123, 126,
                                126, 126, 126, 16, 50, 43, 43, 31, 44, 22, 17,
                                22, 12, 69, 1, 17, 4, 36, 46, 2, 11, 20, 24, 6,
                                22, 40, 4, 65, 12, 87, 112, 126, 126, 126, 126,
                                126, 126 },

                              {

                              16,
                                3, 83, 16, 3, 83, 24, 31, 29, 13, 72, 104, 73,
                                65, 51, 14, 61, 72, 26, 33, 65, 86, 3, 103, 120,
                                71, 90, 126, 126, 126, 62, 22, 70, 26, 33, 65,
                                67, 22, 21, 73, 4, 1, 2, 73, 88, 70, 94, 5, 66,
                                1, 69, 81, 71, 88, 18, 5, 2, 64, 13, 2, 22, 0,
                                0, 0, 9, 98, 97, 13, 81, 71, 18, 65, 86, 22, 53,
                                41, 62, 62, 32, 30, 22, 38, 18, 11, 27, 70, 73,
                                74, 67, 27, 2, 10, 64, 64, 0, 1, 9, 69, 78, 77,
                                87, 19, 68, 7, 0, 78, 4, 71, 8, 3, 65, 5, 10, 3,
                                68, 66, 6, 67, 0, 69, 69, 76, 64, 69, 81, 2, 69,
                                76, 2, 12, 66, 86, 77, 78, 81, 4, 68, 9, 7, 7,
                                41, 19, 5, 69, 13, 69, 82, 0, 108, 73, 64, 91,
                                71, 89, 4, 64, 82, 19, 8, 4, 101, 4, 86, 74, 3,
                                97, 1, 17, 10, 14, 17, 13, 6, 16, 12, 68, 64, 9,
                                0, 64, 75, 69, 75, 74, 70, 73, 79, 79, 78, 78,
                                76, 68, 92, 99, 80, 85, 86, 90, 91, 100, 105,
                                99, 99, 109, 115, 108, 111, 126, 121, 123, 70,
                                74, 95, 80, 88, 91, 97, 106, 109, 99, 103, 97,
                                87, 92, 90, 82, 79, 6, 26, 18, 11, 9, 11, 6, 1,
                                6, 15, 15, 30, 21, 15, 8, 23, 14, 18, 11, 38, 2,
                                44, 31, 22, 14, 27, 5, 64, 64, 5, 70, 47, 17, 0,
                                1, 12, 1, 71, 1, 5, 33, 18, 2, 67, 17, 5, 3, 3,
                                3, 62, 65, 7, 8, 15, 10, 9, 22, 23, 17, 22, 27,
                                33, 64, 6, 75, 64, 38, 70, 95, 67, 10, 66, 81,
                                86, 76, 87, 96, 105, 107, 72, 67, 16, 70, 77,
                                69, 65, 2, 81, 75, 68, 68, 89, 75, 82, 1, 11,
                                88, 75, 4, 80, 1, 77, 69, 21, 80, 85, 65, 4, 90,
                                88, 124, 9, 15, 24, 67, 74, 69, 85, 85, 85, 98,
                                98, 97, 115, 106, 94, 116, 120, 124, 126, 115,
                                111, 102, 82, 89, 6, 25, 4, 26, 48, 84, 87, 92,
                                90, 114, 103, 97, 122, 100, 112, 106, 125, 118,
                                115, 114, 85, 81, 118, 89, 91, 104, 116, 110,
                                111, 111, 107, 116, 113, 116, 121, 126, 120, 77,
                                85, 102, 66, 14, 10, 22, 22, 27, 50, 32, 43, 43,
                                62, 53, 47, 62, 62, 37, 72, 94, 114, 126, 126,
                                126, 126, 126, 16, 50, 43, 43, 31, 45, 22, 17,
                                22, 12, 69, 1, 18, 4, 37, 47, 2, 12, 21, 25, 6,
                                22, 41, 4, 65, 11, 89, 114, 126, 126, 126, 126,
                                126, 126 },

                              {

                              15,
                                3, 83, 15, 3, 83, 26, 33, 30, 13, 73, 106, 75,
                                66, 51, 14, 62, 72, 27, 34, 65, 87, 3, 104, 121,
                                71, 92, 126, 126, 126, 62, 23, 70, 27, 34, 65,
                                66, 23, 22, 73, 4, 2, 3, 74, 89, 70, 94, 5, 66,
                                1, 69, 81, 71, 88, 19, 5, 2, 64, 14, 2, 22, 0,
                                0, 0, 9, 98, 97, 14, 82, 71, 18, 65, 86, 24, 55,
                                42, 62, 62, 33, 31, 24, 39, 19, 12, 29, 69, 73,
                                73, 66, 27, 2, 10, 64, 64, 0, 2, 11, 69, 79, 78,
                                88, 19, 68, 7, 1, 78, 5, 71, 9, 3, 65, 5, 10, 2,
                                68, 66, 6, 67, 0, 69, 70, 76, 64, 70, 82, 1, 70,
                                77, 2, 13, 66, 87, 77, 77, 81, 4, 68, 9, 7, 7,
                                42, 19, 5, 69, 14, 69, 83, 0, 109, 73, 64, 91,
                                72, 90, 4, 64, 83, 19, 8, 4, 103, 4, 87, 74, 3,
                                97, 0, 17, 10, 14, 17, 13, 6, 16, 12, 68, 65, 9,
                                0, 64, 75, 70, 76, 75, 71, 74, 80, 80, 78, 78,
                                77, 68, 93, 101, 80, 86, 88, 92, 93, 102, 107,
                                101, 101, 111, 117, 109, 112, 126, 123, 124, 70,
                                74, 95, 81, 89, 92, 99, 107, 111, 100, 104, 98,
                                87, 92, 90, 82, 79, 7, 26, 18, 11, 9, 11, 6, 1,
                                7, 16, 15, 30, 21, 15, 8, 24, 15, 19, 12, 40, 2,
                                44, 31, 22, 14, 28, 5, 64, 64, 5, 70, 47, 17,
                                64, 1, 12, 1, 71, 2, 5, 33, 18, 1, 68, 17, 5, 3,
                                4, 4, 62, 64, 8, 8, 16, 11, 10, 24, 24, 18, 23,
                                29, 34, 64, 7, 75, 64, 40, 70, 95, 67, 10, 66,
                                82, 86, 76, 88, 97, 106, 108, 72, 68, 16, 71,
                                77, 69, 66, 2, 82, 75, 69, 68, 90, 75, 83, 1,
                                11, 89, 75, 4, 81, 1, 78, 69, 21, 81, 86, 66, 3,
                                91, 88, 125, 8, 14, 24, 68, 75, 71, 87, 87, 87,
                                101, 100, 99, 118, 109, 95, 119, 123, 126, 126,
                                118, 114, 104, 83, 90, 6, 26, 4, 27, 50, 86, 89,
                                94, 92, 116, 105, 98, 124, 102, 113, 107, 126,
                                120, 116, 115, 85, 82, 119, 90, 93, 105, 118,
                                112, 113, 113, 108, 118, 115, 117, 123, 126,
                                121, 78, 86, 103, 66, 15, 10, 22, 23, 27, 51,
                                33, 44, 44, 62, 54, 48, 62, 62, 37, 73, 96, 117,
                                126, 126, 126, 126, 126, 17, 51, 44, 44, 31, 46,
                                23, 17, 23, 13, 69, 2, 18, 5, 38, 48, 2, 12, 21,
                                25, 6, 23, 42, 4, 65, 10, 91, 117, 126, 126,
                                126, 126, 126, 126 },

                        },

                          {

                              {

                              62,
                                9, 74, 62, 9, 74, 126, 104, 10, 9, 12, 38, 62,
                                62, 54, 22, 118, 65, 71, 79, 11, 13, 70, 9, 29,
                                41, 62, 61, 27, 69, 126, 101, 76, 71, 79, 11,
                                69, 90, 11, 20, 69, 82, 96, 4, 75, 87, 100, 7,
                                74, 85, 4, 81, 86, 95, 66, 77, 70, 86, 72, 2,
                                22, 0, 0, 0, 83, 86, 97, 72, 22, 1, 48, 12, 80,
                                126, 91, 96, 81, 98, 102, 97, 119, 99, 110, 102,
                                126, 80, 89, 94, 92, 24, 65, 84, 126, 73, 104,
                                91, 126, 8, 7, 8, 2, 10, 68, 74, 88, 103, 91,
                                89, 92, 76, 87, 110, 105, 78, 112, 99, 126, 126,
                                126, 126, 66, 78, 71, 72, 4, 8, 70, 75, 89, 119,
                                75, 43, 41, 126, 9, 2, 5, 3, 2, 67, 84, 74, 65,
                                11, 6, 2, 69, 70, 8, 71, 5, 2, 22, 38, 31, 20,
                                16, 19, 12, 17, 25, 66, 25, 21, 29, 89, 18, 35,
                                32, 62, 62, 48, 62, 62, 62, 62, 62, 62, 62, 62,
                                62, 62, 53, 62, 62, 62, 62, 62, 62, 62, 56, 62,
                                62, 62, 27, 62, 62, 62, 62, 62, 62, 62, 62, 62,
                                62, 62, 53, 45, 38, 22, 75, 72, 77, 28, 32, 28,
                                33, 18, 21, 18, 37, 9, 66, 7, 73, 67, 116, 112,
                                71, 2, 10, 66, 77, 80, 84, 87, 126, 101, 24, 10,
                                2, 75, 77, 91, 107, 111, 122, 76, 19, 11, 6, 5,
                                72, 69, 69, 74, 86, 66, 29, 31, 32, 11, 8, 67,
                                73, 89, 11, 59, 55, 55, 44, 26, 2, 73, 70, 78,
                                62, 126, 124, 110, 126, 124, 105, 121, 117, 102,
                                117, 116, 122, 95, 100, 95, 111, 114, 89, 80,
                                82, 85, 81, 72, 64, 67, 7, 69, 69, 69, 69, 67,
                                77, 64, 2, 67, 64, 6, 65, 66, 1, 12, 66, 71, 75,
                                70, 72, 3, 26, 16, 28, 26, 22, 22, 15, 22, 22,
                                4, 13, 23, 66, 13, 62, 62, 62, 62, 62, 62, 62,
                                62, 62, 62, 62, 62, 62, 62, 54, 62, 62, 62, 62,
                                62, 62, 62, 62, 62, 49, 37, 26, 8, 65, 62, 62,
                                62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 43, 33,
                                19, 15, 14, 18, 41, 41, 42, 43, 35, 39, 29, 21,
                                24, 13, 70, 9, 71, 83, 31, 14, 9, 85, 81, 77,
                                81, 80, 73, 74, 83, 71, 67, 2, 66, 66, 4, 4, 62,
                                62, 62, 62, 62, 60, 53, 36, 6, 71, 39, 27, 21,
                                11, 6, 0, 65, 67, 82, 81, 76, 72, 78, 72, 68,
                                70, 76, 66, 1, 6, 2, 3, 9, 5, 62, 62, 62, 62,
                                62, 60, 53, 36, 6 },

                                {

                                62,
                                  9, 74, 62, 9, 74, 125, 102, 11, 10, 12, 37,
                                  61, 62, 55, 22, 116, 65, 70, 78, 11, 13, 69,
                                  9, 28, 40, 61, 58, 25, 70, 124, 100, 75, 70,
                                  78, 11, 69, 89, 11, 20, 68, 81, 95, 4, 75, 86,
                                  99, 7, 73, 84, 4, 80, 85, 94, 65, 76, 70, 85,
                                  71, 2, 22, 0, 0, 0, 82, 86, 97, 71, 22, 1, 48,
                                  12, 80, 124, 89, 94, 79, 95, 100, 95, 117, 97,
                                  108, 100, 124, 80, 88, 93, 91, 24, 65, 83,
                                  124, 72, 103, 90, 125, 8, 7, 8, 2, 11, 68, 73,
                                  87, 102, 90, 88, 91, 75, 86, 108, 103, 77,
                                  110, 97, 122, 122, 123, 124, 65, 77, 70, 71,
                                  4, 9, 69, 74, 88, 116, 74, 41, 40, 124, 9, 3,
                                  5, 4, 3, 66, 82, 73, 64, 11, 6, 2, 68, 69, 7,
                                  70, 5, 2, 22, 37, 31, 20, 16, 19, 12, 17, 24,
                                  65, 25, 21, 29, 89, 18, 35, 32, 62, 62, 47,
                                  62, 62, 62, 61, 62, 62, 62, 62, 62, 62, 52,
                                  62, 62, 62, 62, 62, 62, 62, 54, 62, 60, 62,
                                  26, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
                                  61, 52, 44, 37, 21, 75, 72, 77, 28, 31, 27,
                                  32, 17, 20, 17, 36, 8, 66, 6, 73, 67, 115,
                                  110, 70, 3, 10, 65, 76, 79, 83, 86, 124, 99,
                                  25, 11, 3, 74, 76, 89, 105, 109, 120, 75, 20,
                                  12, 7, 6, 71, 68, 68, 73, 85, 66, 30, 31, 32,
                                  11, 9, 66, 73, 88, 11, 59, 55, 54, 43, 26, 3,
                                  72, 69, 77, 62, 124, 122, 108, 124, 122, 103,
                                  119, 115, 100, 115, 114, 119, 94, 99, 94, 109,
                                  112, 88, 79, 81, 84, 80, 71, 64, 67, 7, 69,
                                  69, 69, 68, 66, 76, 0, 2, 66, 0, 6, 64, 65, 1,
                                  12, 65, 70, 74, 69, 71, 3, 25, 16, 27, 26, 22,
                                  22, 15, 22, 22, 4, 13, 22, 66, 12, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
                                  52, 62, 62, 62, 62, 62, 62, 62, 61, 62, 48,
                                  36, 25, 8, 65, 62, 62, 62, 62, 62, 62, 62, 62,
                                  62, 62, 62, 62, 42, 32, 18, 15, 14, 17, 40,
                                  40, 41, 41, 34, 38, 28, 20, 23, 12, 70, 8, 71,
                                  83, 30, 13, 8, 84, 80, 76, 80, 78, 71, 73, 82,
                                  70, 66, 3, 65, 65, 4, 4, 62, 62, 62, 62, 60,
                                  56, 49, 32, 4, 70, 39, 28, 22, 12, 7, 1, 64,
                                  66, 81, 80, 75, 71, 77, 71, 67, 69, 75, 65, 2,
                                  6, 3, 4, 9, 5, 62, 62, 62, 62, 60, 56, 49, 32,
                                  4 },

                                {

                                62,
                                  9, 74, 62, 9, 74, 123, 101, 11, 10, 12, 36,
                                  59, 61, 55, 22, 114, 65, 70, 77, 11, 12, 69,
                                  8, 26, 39, 58, 54, 22, 72, 121, 99, 75, 70,
                                  77, 11, 69, 88, 11, 19, 68, 81, 94, 4, 75, 86,
                                  99, 7, 73, 84, 4, 80, 85, 94, 65, 76, 70, 85,
                                  71, 2, 22, 0, 0, 0, 81, 86, 97, 71, 21, 1, 47,
                                  12, 80, 122, 88, 93, 77, 93, 99, 94, 115, 96,
                                  107, 99, 122, 80, 88, 93, 91, 24, 65, 82, 122,
                                  72, 102, 89, 123, 8, 7, 8, 1, 11, 68, 73, 86,
                                  101, 89, 87, 90, 75, 85, 107, 102, 76, 109,
                                  96, 117, 118, 120, 121, 65, 77, 70, 71, 4, 9,
                                  69, 74, 88, 114, 74, 39, 38, 121, 9, 3, 5, 4,
                                  3, 66, 80, 72, 64, 11, 6, 2, 67, 68, 6, 70, 5,
                                  2, 21, 36, 30, 20, 15, 19, 12, 17, 23, 65, 24,
                                  20, 28, 89, 18, 34, 31, 62, 62, 46, 60, 62,
                                  62, 59, 62, 62, 62, 62, 62, 62, 50, 62, 62,
                                  62, 62, 62, 62, 62, 52, 62, 58, 62, 24, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 62, 59, 50,
                                  42, 35, 19, 75, 72, 78, 27, 30, 26, 31, 16,
                                  19, 16, 34, 7, 66, 5, 74, 68, 114, 109, 69, 3,
                                  10, 65, 75, 78, 82, 85, 122, 98, 25, 11, 3,
                                  73, 75, 88, 103, 107, 118, 74, 21, 13, 8, 7,
                                  70, 68, 68, 73, 84, 66, 31, 31, 31, 11, 9, 66,
                                  73, 88, 11, 59, 54, 53, 42, 26, 3, 72, 69, 77,
                                  62, 123, 121, 107, 122, 120, 102, 117, 113,
                                  99, 113, 112, 117, 93, 98, 94, 108, 110, 88,
                                  79, 81, 83, 80, 71, 64, 67, 6, 69, 69, 69, 68,
                                  66, 75, 0, 2, 66, 0, 6, 64, 65, 1, 11, 65, 70,
                                  74, 69, 70, 2, 24, 16, 26, 25, 21, 21, 15, 21,
                                  21, 4, 13, 21, 66, 11, 62, 62, 62, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 50, 62, 62,
                                  62, 62, 62, 62, 62, 59, 59, 46, 34, 24, 7, 66,
                                  62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
                                  62, 40, 30, 16, 14, 13, 15, 39, 39, 39, 39,
                                  32, 36, 26, 19, 21, 11, 71, 7, 72, 84, 28, 12,
                                  7, 84, 80, 75, 80, 77, 70, 73, 81, 69, 65, 3,
                                  65, 64, 4, 4, 62, 62, 62, 62, 57, 52, 45, 28,
                                  1, 70, 39, 28, 22, 12, 8, 1, 64, 66, 81, 80,
                                  75, 71, 77, 70, 66, 69, 75, 65, 2, 6, 3, 5, 9,
                                  5, 62, 62, 62, 62, 57, 52, 45, 28, 1 },

                                {

                                62,
                                  9, 74, 62, 9, 74, 121, 99, 12, 10, 11, 34, 57,
                                  60, 55, 22, 112, 65, 69, 76, 11, 12, 69, 8,
                                  25, 38, 56, 51, 20, 73, 118, 98, 75, 69, 76,
                                  11, 70, 87, 11, 19, 68, 81, 94, 4, 75, 86, 99,
                                  7, 73, 83, 4, 80, 84, 94, 65, 76, 70, 85, 71,
                                  2, 22, 0, 0, 0, 81, 86, 97, 70, 20, 1, 46, 11,
                                  80, 119, 87, 92, 76, 91, 97, 92, 113, 94, 106,
                                  98, 120, 80, 88, 92, 91, 24, 65, 81, 120, 72,
                                  101, 89, 121, 8, 6, 7, 1, 11, 68, 72, 86, 100,
                                  88, 87, 89, 74, 84, 105, 100, 76, 108, 95,
                                  112, 113, 117, 118, 65, 77, 70, 70, 4, 9, 68,
                                  73, 87, 112, 74, 37, 36, 118, 9, 3, 5, 4, 3,
                                  65, 79, 71, 64, 11, 6, 2, 67, 67, 5, 70, 5, 1,
                                  21, 35, 30, 20, 15, 19, 12, 17, 22, 65, 23,
                                  19, 28, 89, 18, 34, 31, 62, 62, 45, 58, 62,
                                  62, 57, 62, 62, 62, 62, 62, 61, 48, 62, 62,
                                  62, 62, 62, 62, 60, 50, 62, 56, 62, 22, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 62, 57, 48,
                                  40, 34, 17, 75, 72, 78, 26, 29, 25, 30, 15,
                                  18, 15, 32, 6, 67, 4, 75, 68, 114, 107, 68, 4,
                                  10, 65, 74, 78, 82, 85, 120, 97, 25, 11, 4,
                                  72, 74, 87, 102, 106, 116, 73, 21, 13, 8, 7,
                                  69, 67, 68, 73, 84, 66, 31, 31, 30, 11, 9, 66,
                                  73, 87, 11, 58, 54, 52, 41, 26, 3, 72, 69, 77,
                                  62, 122, 119, 106, 121, 119, 101, 115, 111,
                                  98, 112, 110, 115, 93, 97, 93, 107, 108, 87,
                                  79, 81, 83, 79, 71, 64, 67, 6, 69, 69, 70, 67,
                                  65, 74, 0, 2, 65, 0, 6, 64, 65, 1, 11, 65, 70,
                                  74, 69, 70, 1, 23, 16, 25, 24, 20, 21, 15, 20,
                                  20, 4, 13, 20, 66, 10, 62, 62, 61, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 48, 62, 62,
                                  62, 62, 62, 62, 62, 57, 57, 44, 32, 22, 6, 67,
                                  62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 59,
                                  60, 38, 28, 15, 13, 12, 14, 37, 37, 37, 37,
                                  31, 34, 24, 18, 20, 10, 72, 6, 73, 85, 27, 11,
                                  6, 84, 79, 75, 79, 76, 69, 73, 81, 69, 65, 3,
                                  64, 0, 4, 4, 62, 62, 62, 59, 54, 48, 41, 24,
                                  65, 70, 39, 28, 22, 12, 8, 2, 64, 66, 80, 80,
                                  75, 70, 76, 69, 65, 69, 74, 65, 2, 6, 3, 5, 9,
                                  5, 62, 62, 62, 59, 54, 48, 41, 24, 65 },

                                {

                                62,
                                  9, 74, 62, 9, 74, 120, 98, 12, 10, 11, 33, 55,
                                  59, 55, 21, 110, 65, 69, 75, 10, 11, 69, 7,
                                  23, 37, 53, 47, 17, 75, 115, 97, 75, 69, 75,
                                  10, 70, 86, 11, 18, 68, 80, 93, 4, 75, 86, 99,
                                  7, 73, 83, 4, 80, 84, 93, 65, 76, 70, 85, 70,
                                  2, 22, 0, 0, 0, 80, 87, 97, 70, 19, 1, 45, 11,
                                  80, 117, 86, 91, 74, 89, 96, 91, 112, 93, 104,
                                  97, 118, 80, 87, 92, 91, 24, 65, 80, 118, 72,
                                  101, 88, 119, 8, 6, 7, 0, 11, 68, 72, 85, 99,
                                  87, 86, 88, 74, 84, 104, 99, 75, 107, 94, 107,
                                  109, 114, 115, 65, 76, 70, 70, 4, 9, 68, 73,
                                  87, 110, 74, 35, 34, 116, 9, 4, 5, 4, 3, 65,
                                  77, 70, 0, 10, 6, 2, 66, 67, 4, 70, 5, 1, 20,
                                  34, 29, 19, 14, 19, 12, 17, 21, 65, 22, 18,
                                  27, 89, 17, 33, 30, 62, 62, 44, 56, 62, 62,
                                  55, 62, 62, 62, 62, 62, 59, 46, 59, 62, 62,
                                  62, 62, 62, 57, 48, 62, 54, 62, 21, 62, 62,
                                  62, 62, 62, 62, 62, 62, 62, 60, 55, 46, 38,
                                  32, 15, 75, 72, 79, 25, 28, 24, 28, 14, 16,
                                  14, 31, 5, 67, 3, 75, 69, 113, 106, 67, 4, 10,
                                  64, 74, 77, 81, 84, 118, 95, 25, 12, 4, 72,
                                  73, 86, 100, 104, 115, 73, 22, 14, 9, 8, 68,
                                  67, 68, 72, 83, 66, 32, 31, 30, 10, 9, 66, 73,
                                  87, 11, 58, 53, 51, 40, 26, 3, 71, 69, 77, 62,
                                  120, 118, 105, 119, 117, 100, 114, 110, 97,
                                  110, 109, 113, 92, 96, 93, 106, 107, 87, 79,
                                  81, 82, 79, 71, 65, 67, 5, 69, 69, 70, 67, 65,
                                  73, 0, 2, 65, 0, 6, 64, 65, 1, 10, 65, 70, 74,
                                  69, 69, 0, 22, 16, 24, 24, 19, 20, 15, 19, 19,
                                  4, 13, 19, 66, 9, 62, 62, 60, 62, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 62, 46, 62, 62, 62,
                                  62, 62, 62, 62, 54, 54, 42, 30, 21, 5, 67, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 62, 57, 57,
                                  36, 26, 13, 12, 12, 12, 36, 36, 36, 35, 29,
                                  32, 23, 17, 18, 9, 73, 4, 74, 85, 25, 9, 4,
                                  83, 79, 74, 79, 75, 68, 73, 80, 68, 64, 3, 64,
                                  1, 4, 4, 62, 62, 62, 56, 50, 44, 36, 20, 68,
                                  69, 39, 28, 22, 12, 9, 2, 64, 66, 80, 80, 75,
                                  70, 76, 69, 64, 69, 74, 64, 3, 6, 3, 6, 9, 5,
                                  62, 62, 62, 56, 50, 44, 36, 20, 68 },

                                {

                                62,
                                  9, 74, 62, 9, 74, 118, 96, 12, 10, 10, 32, 53,
                                  58, 55, 21, 108, 65, 69, 74, 10, 11, 69, 6,
                                  21, 36, 51, 44, 15, 77, 112, 96, 74, 69, 74,
                                  10, 70, 85, 11, 18, 68, 80, 92, 4, 75, 86, 99,
                                  7, 73, 83, 4, 80, 83, 93, 65, 76, 70, 85, 70,
                                  2, 22, 0, 0, 0, 80, 87, 97, 69, 18, 1, 44, 10,
                                  80, 114, 85, 90, 72, 87, 94, 89, 110, 91, 103,
                                  96, 115, 80, 87, 91, 90, 24, 65, 79, 116, 72,
                                  100, 88, 117, 8, 5, 6, 0, 11, 68, 71, 85, 98,
                                  86, 86, 87, 73, 83, 102, 97, 74, 105, 93, 102,
                                  105, 111, 112, 64, 76, 69, 69, 4, 9, 67, 73,
                                  86, 108, 74, 33, 32, 113, 9, 4, 5, 4, 3, 64,
                                  76, 69, 0, 10, 6, 2, 66, 66, 3, 69, 5, 0, 20,
                                  33, 29, 19, 14, 19, 12, 17, 20, 64, 21, 18,
                                  27, 89, 17, 32, 29, 62, 62, 43, 55, 62, 62,
                                  53, 62, 62, 62, 62, 61, 57, 44, 57, 62, 60,
                                  62, 62, 62, 55, 46, 62, 52, 62, 19, 62, 62,
                                  62, 62, 62, 62, 62, 62, 61, 58, 53, 44, 37,
                                  30, 13, 75, 72, 79, 24, 27, 23, 27, 13, 15,
                                  13, 29, 4, 68, 2, 76, 70, 112, 104, 66, 5, 10,
                                  64, 73, 77, 81, 83, 116, 94, 25, 12, 5, 71,
                                  72, 85, 99, 103, 113, 72, 23, 15, 10, 8, 67,
                                  66, 67, 72, 83, 66, 32, 31, 29, 10, 9, 66, 73,
                                  86, 11, 57, 52, 50, 39, 26, 3, 71, 69, 76, 62,
                                  119, 116, 103, 117, 116, 99, 112, 108, 96,
                                  108, 107, 111, 91, 95, 92, 105, 105, 87, 79,
                                  80, 82, 78, 71, 65, 67, 5, 69, 69, 71, 66, 65,
                                  72, 0, 2, 65, 0, 6, 64, 65, 1, 10, 65, 70, 74,
                                  69, 69, 64, 21, 16, 23, 23, 19, 19, 15, 19,
                                  18, 4, 13, 18, 66, 8, 62, 62, 59, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 44, 62, 62,
                                  62, 62, 62, 62, 61, 52, 52, 40, 29, 19, 5, 68,
                                  62, 62, 62, 62, 62, 62, 62, 62, 62, 61, 55,
                                  54, 34, 24, 12, 12, 11, 10, 35, 34, 34, 33,
                                  27, 30, 21, 16, 17, 8, 73, 3, 75, 86, 24, 8,
                                  3, 83, 79, 73, 78, 74, 67, 72, 79, 68, 64, 3,
                                  0, 2, 4, 4, 62, 62, 59, 53, 47, 40, 32, 16,
                                  71, 69, 39, 28, 22, 12, 9, 2, 0, 65, 79, 80,
                                  75, 69, 76, 68, 0, 69, 74, 64, 3, 6, 4, 6, 9,
                                  5, 62, 62, 59, 53, 47, 40, 32, 16, 71 },

                                {

                                62,
                                  9, 75, 62, 9, 75, 116, 95, 13, 10, 10, 30, 51,
                                  57, 55, 21, 107, 65, 68, 74, 10, 10, 68, 6,
                                  20, 34, 48, 40, 12, 78, 110, 95, 74, 68, 74,
                                  10, 71, 85, 11, 17, 68, 80, 92, 4, 75, 85, 98,
                                  7, 72, 82, 4, 79, 83, 93, 65, 76, 70, 85, 70,
                                  2, 22, 0, 0, 0, 79, 87, 97, 69, 18, 0, 44, 10,
                                  80, 112, 84, 89, 71, 84, 93, 88, 108, 90, 102,
                                  95, 113, 80, 87, 91, 90, 24, 65, 78, 113, 72,
                                  99, 87, 115, 7, 5, 6, 64, 12, 68, 71, 84, 98,
                                  86, 85, 86, 73, 82, 101, 96, 74, 104, 92, 97,
                                  100, 108, 109, 64, 76, 69, 69, 4, 9, 67, 72,
                                  86, 106, 73, 31, 30, 110, 9, 4, 5, 4, 4, 64,
                                  74, 68, 0, 10, 6, 2, 65, 65, 2, 69, 5, 0, 19,
                                  32, 28, 19, 13, 19, 12, 17, 18, 64, 20, 17,
                                  26, 89, 17, 32, 29, 62, 62, 42, 53, 62, 62,
                                  51, 62, 62, 62, 62, 57, 55, 43, 55, 62, 58,
                                  62, 62, 62, 52, 44, 62, 50, 62, 17, 62, 62,
                                  62, 62, 62, 62, 62, 62, 59, 56, 50, 42, 35,
                                  29, 12, 75, 72, 80, 23, 26, 22, 26, 12, 14,
                                  12, 27, 3, 68, 1, 77, 70, 112, 103, 65, 5, 10,
                                  64, 72, 76, 80, 83, 114, 93, 26, 12, 5, 70,
                                  71, 84, 97, 101, 111, 71, 23, 15, 10, 9, 66,
                                  66, 67, 72, 82, 66, 33, 31, 28, 10, 9, 66, 73,
                                  86, 10, 57, 52, 49, 38, 25, 3, 71, 69, 76, 62,
                                  118, 115, 102, 116, 114, 98, 110, 106, 95,
                                  107, 105, 109, 91, 94, 92, 104, 103, 86, 79,
                                  80, 81, 78, 71, 65, 67, 4, 69, 69, 71, 66, 64,
                                  71, 0, 2, 64, 1, 6, 0, 64, 1, 9, 65, 70, 74,
                                  69, 68, 65, 20, 16, 22, 22, 18, 19, 15, 18,
                                  18, 4, 12, 16, 67, 7, 62, 62, 58, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 42, 62, 62,
                                  62, 62, 62, 62, 58, 50, 49, 38, 27, 18, 4, 69,
                                  62, 62, 62, 62, 62, 62, 62, 62, 61, 58, 52,
                                  51, 32, 23, 10, 11, 10, 9, 33, 33, 32, 31, 26,
                                  28, 19, 15, 15, 7, 74, 2, 76, 87, 22, 7, 2,
                                  83, 78, 73, 78, 73, 66, 72, 79, 67, 0, 3, 0,
                                  3, 4, 4, 62, 62, 57, 50, 44, 36, 28, 12, 74,
                                  69, 39, 28, 22, 12, 10, 3, 0, 65, 79, 79, 74,
                                  69, 75, 67, 1, 68, 73, 64, 3, 6, 4, 7, 9, 5,
                                  62, 62, 57, 50, 44, 36, 28, 12, 74 },

                                {

                                62,
                                  9, 75, 62, 9, 75, 114, 93, 13, 10, 9, 29, 49,
                                  56, 55, 21, 105, 65, 68, 73, 9, 10, 68, 5, 18,
                                  33, 46, 37, 10, 80, 107, 94, 74, 68, 73, 9,
                                  71, 84, 11, 17, 68, 79, 91, 4, 75, 85, 98, 7,
                                  72, 82, 4, 79, 82, 92, 65, 76, 70, 85, 69, 2,
                                  22, 0, 0, 0, 79, 87, 97, 68, 17, 0, 43, 9, 80,
                                  109, 83, 88, 69, 82, 91, 86, 107, 88, 100, 94,
                                  111, 80, 86, 90, 90, 24, 65, 77, 111, 72, 98,
                                  87, 113, 7, 4, 5, 64, 12, 68, 70, 84, 97, 85,
                                  85, 85, 72, 81, 99, 94, 73, 103, 91, 92, 96,
                                  105, 106, 64, 75, 69, 68, 4, 9, 66, 72, 85,
                                  104, 73, 29, 28, 107, 9, 5, 5, 4, 4, 0, 73,
                                  67, 1, 9, 6, 2, 65, 65, 1, 69, 5, 64, 19, 31,
                                  28, 18, 13, 19, 12, 17, 17, 64, 19, 16, 26,
                                  89, 17, 31, 28, 60, 62, 41, 51, 62, 62, 49,
                                  62, 61, 62, 62, 54, 53, 41, 52, 62, 55, 62,
                                  62, 62, 49, 42, 62, 48, 62, 16, 62, 62, 62,
                                  62, 62, 62, 62, 62, 57, 53, 48, 40, 33, 27,
                                  10, 75, 72, 80, 22, 25, 21, 24, 11, 13, 11,
                                  26, 2, 69, 0, 77, 71, 111, 101, 64, 6, 10, 0,
                                  72, 76, 80, 82, 112, 91, 26, 13, 6, 70, 70,
                                  83, 96, 100, 109, 71, 24, 16, 11, 9, 65, 65,
                                  67, 71, 82, 66, 33, 31, 28, 9, 9, 66, 73, 85,
                                  10, 56, 51, 48, 37, 25, 3, 70, 69, 76, 62,
                                  116, 113, 101, 114, 113, 97, 109, 105, 94,
                                  105, 104, 107, 90, 93, 91, 103, 101, 86, 79,
                                  80, 81, 77, 71, 66, 67, 4, 69, 69, 72, 65, 64,
                                  70, 0, 2, 64, 1, 6, 0, 64, 1, 9, 65, 70, 74,
                                  69, 68, 66, 19, 16, 21, 22, 17, 18, 15, 17,
                                  17, 4, 12, 15, 67, 6, 61, 62, 57, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 40, 62, 62,
                                  62, 62, 62, 62, 56, 48, 47, 36, 25, 16, 3, 69,
                                  62, 62, 62, 62, 62, 62, 62, 62, 59, 56, 50,
                                  48, 30, 21, 9, 10, 10, 7, 32, 31, 31, 29, 24,
                                  26, 18, 14, 14, 6, 75, 0, 77, 87, 21, 5, 0,
                                  82, 78, 72, 77, 72, 65, 72, 78, 67, 0, 3, 1,
                                  4, 4, 4, 62, 62, 54, 47, 40, 32, 24, 8, 77,
                                  68, 39, 28, 22, 12, 10, 3, 0, 65, 78, 79, 74,
                                  68, 75, 66, 2, 68, 73, 0, 4, 6, 4, 7, 9, 5,
                                  62, 62, 54, 47, 40, 32, 24, 8, 77 },

                                {

                                62,
                                  8, 75, 62, 8, 75, 113, 92, 13, 10, 9, 27, 46,
                                  55, 55, 20, 103, 66, 68, 72, 9, 9, 68, 4, 16,
                                  32, 43, 33, 7, 82, 104, 93, 74, 68, 72, 9, 72,
                                  83, 11, 16, 68, 79, 91, 3, 76, 85, 98, 7, 72,
                                  82, 4, 79, 82, 92, 65, 76, 70, 85, 69, 2, 22,
                                  0, 0, 0, 78, 88, 97, 68, 16, 0, 42, 9, 81,
                                  107, 82, 87, 68, 80, 90, 85, 105, 87, 99, 93,
                                  109, 80, 86, 90, 90, 24, 65, 76, 109, 72, 98,
                                  86, 111, 7, 4, 5, 65, 12, 68, 70, 83, 96, 84,
                                  84, 85, 72, 81, 98, 93, 73, 102, 90, 88, 92,
                                  102, 104, 64, 75, 69, 68, 3, 9, 66, 72, 85,
                                  102, 73, 27, 26, 105, 9, 5, 5, 4, 4, 0, 71,
                                  67, 1, 9, 5, 2, 64, 64, 64, 69, 5, 64, 18, 29,
                                  27, 18, 12, 19, 12, 16, 16, 64, 18, 15, 25,
                                  89, 16, 30, 27, 58, 62, 39, 49, 62, 62, 46,
                                  62, 59, 62, 62, 50, 51, 39, 50, 62, 53, 62,
                                  62, 62, 46, 40, 62, 46, 62, 14, 62, 62, 62,
                                  62, 62, 62, 62, 60, 55, 51, 46, 38, 31, 25, 8,
                                  75, 73, 81, 21, 23, 20, 23, 10, 11, 9, 24, 1,
                                  69, 64, 78, 72, 111, 100, 0, 6, 10, 0, 71, 75,
                                  79, 82, 110, 90, 26, 13, 6, 69, 69, 82, 94,
                                  98, 108, 70, 24, 16, 11, 10, 64, 65, 67, 71,
                                  81, 67, 34, 31, 27, 9, 9, 66, 73, 85, 10, 56,
                                  50, 47, 36, 25, 3, 70, 69, 76, 62, 115, 112,
                                  100, 113, 111, 96, 107, 103, 93, 104, 102,
                                  105, 90, 93, 91, 102, 100, 86, 79, 80, 80, 77,
                                  71, 66, 67, 3, 69, 69, 72, 65, 64, 69, 0, 1,
                                  64, 1, 5, 0, 64, 1, 8, 65, 70, 74, 69, 67, 67,
                                  18, 16, 19, 21, 16, 17, 14, 16, 16, 4, 12, 14,
                                  67, 4, 60, 60, 56, 62, 62, 62, 62, 62, 62, 62,
                                  62, 62, 62, 60, 38, 62, 62, 62, 62, 62, 62,
                                  53, 45, 44, 34, 23, 15, 2, 70, 62, 62, 62, 62,
                                  62, 62, 62, 62, 56, 53, 47, 45, 28, 19, 7, 9,
                                  9, 5, 30, 30, 29, 27, 22, 24, 16, 12, 12, 4,
                                  76, 64, 78, 88, 19, 4, 64, 82, 78, 72, 77, 71,
                                  64, 72, 78, 66, 1, 3, 1, 4, 4, 3, 62, 60, 51,
                                  44, 37, 28, 19, 3, 80, 68, 39, 28, 22, 12, 11,
                                  3, 0, 65, 78, 79, 74, 68, 75, 66, 2, 68, 73,
                                  0, 4, 6, 4, 8, 9, 4, 62, 60, 51, 44, 37, 28,
                                  19, 3, 80 },

                                {

                                62,
                                  8, 75, 62, 8, 75, 111, 91, 14, 10, 9, 26, 44,
                                  54, 56, 20, 101, 66, 67, 71, 9, 8, 68, 4, 15,
                                  31, 41, 29, 4, 83, 101, 92, 73, 67, 71, 9, 72,
                                  82, 11, 16, 67, 79, 90, 3, 76, 85, 98, 7, 72,
                                  81, 4, 79, 82, 92, 65, 76, 70, 84, 69, 2, 22,
                                  0, 0, 0, 77, 88, 97, 68, 15, 0, 41, 9, 81,
                                  105, 80, 86, 66, 78, 88, 84, 103, 85, 98, 91,
                                  106, 80, 86, 90, 89, 24, 65, 75, 107, 71, 97,
                                  85, 109, 7, 4, 5, 65, 12, 68, 70, 82, 95, 83,
                                  83, 84, 71, 80, 97, 91, 72, 100, 89, 83, 87,
                                  98, 101, 0, 75, 68, 67, 3, 9, 66, 71, 84, 99,
                                  73, 25, 25, 102, 9, 5, 5, 4, 4, 1, 69, 66, 1,
                                  9, 5, 2, 0, 0, 65, 68, 5, 64, 17, 28, 26, 18,
                                  11, 19, 12, 16, 15, 0, 17, 15, 24, 89, 16, 30,
                                  27, 56, 62, 38, 48, 62, 62, 44, 60, 57, 62,
                                  62, 47, 49, 37, 48, 62, 51, 62, 62, 62, 44,
                                  38, 62, 44, 62, 12, 62, 62, 62, 62, 62, 62,
                                  60, 58, 53, 49, 44, 37, 30, 24, 6, 75, 73, 81,
                                  21, 22, 19, 22, 9, 10, 8, 22, 0, 69, 65, 79,
                                  72, 110, 99, 1, 6, 10, 0, 70, 74, 78, 81, 107,
                                  89, 26, 13, 6, 68, 68, 81, 92, 96, 106, 69,
                                  25, 17, 12, 11, 0, 65, 66, 71, 80, 67, 35, 31,
                                  26, 9, 10, 65, 73, 84, 10, 56, 50, 46, 35, 25,
                                  3, 70, 69, 75, 62, 114, 111, 98, 111, 109, 95,
                                  105, 101, 92, 102, 100, 103, 89, 92, 90, 101,
                                  98, 85, 78, 79, 79, 76, 71, 66, 67, 2, 69, 69,
                                  72, 65, 0, 68, 1, 1, 0, 1, 5, 0, 64, 1, 7, 65,
                                  69, 73, 69, 66, 67, 17, 16, 18, 20, 16, 17,
                                  14, 16, 15, 4, 12, 13, 67, 3, 59, 59, 56, 61,
                                  62, 62, 62, 62, 62, 62, 62, 62, 62, 57, 36,
                                  62, 62, 62, 62, 62, 62, 50, 43, 42, 33, 22,
                                  14, 2, 71, 62, 62, 62, 62, 62, 62, 62, 62, 54,
                                  51, 45, 43, 26, 17, 5, 9, 8, 4, 29, 29, 27,
                                  25, 21, 23, 14, 11, 10, 3, 76, 65, 78, 89, 17,
                                  3, 65, 82, 77, 71, 77, 70, 1, 71, 77, 65, 2,
                                  3, 2, 5, 4, 3, 62, 58, 49, 41, 34, 24, 15, 64,
                                  83, 68, 39, 28, 23, 13, 12, 4, 1, 64, 78, 79,
                                  74, 68, 74, 65, 3, 68, 72, 0, 4, 6, 5, 9, 9,
                                  4, 62, 58, 49, 41, 34, 24, 15, 64, 83 },

                                {

                                62,
                                  8, 75, 62, 8, 75, 109, 89, 14, 10, 8, 25, 42,
                                  53, 56, 20, 99, 66, 67, 70, 8, 8, 68, 3, 13,
                                  30, 38, 26, 2, 85, 98, 91, 73, 67, 70, 8, 72,
                                  81, 11, 15, 67, 78, 89, 3, 76, 85, 98, 7, 72,
                                  81, 4, 79, 81, 91, 65, 76, 70, 84, 68, 2, 22,
                                  0, 0, 0, 77, 88, 97, 67, 14, 0, 40, 8, 81,
                                  102, 79, 85, 64, 76, 87, 82, 102, 84, 96, 90,
                                  104, 80, 85, 89, 89, 24, 65, 74, 105, 71, 96,
                                  85, 107, 7, 3, 4, 66, 12, 68, 69, 82, 94, 82,
                                  83, 83, 71, 79, 95, 90, 71, 99, 88, 78, 83,
                                  95, 98, 0, 74, 68, 67, 3, 9, 65, 71, 84, 97,
                                  73, 23, 23, 99, 9, 6, 5, 4, 4, 1, 68, 65, 2,
                                  8, 5, 2, 0, 0, 66, 68, 5, 65, 17, 27, 26, 17,
                                  11, 19, 12, 16, 14, 0, 16, 14, 24, 89, 16, 29,
                                  26, 54, 62, 37, 46, 62, 62, 42, 57, 55, 62,
                                  62, 43, 47, 35, 45, 61, 48, 62, 62, 62, 41,
                                  36, 58, 42, 62, 11, 62, 62, 62, 62, 62, 60,
                                  58, 56, 51, 46, 42, 35, 28, 22, 4, 75, 73, 82,
                                  20, 21, 18, 20, 8, 9, 7, 21, 64, 70, 66, 79,
                                  73, 109, 97, 2, 7, 10, 1, 70, 74, 78, 80, 105,
                                  87, 26, 14, 7, 68, 67, 80, 91, 95, 104, 69,
                                  26, 18, 13, 11, 1, 64, 66, 70, 80, 67, 35, 31,
                                  26, 8, 10, 65, 73, 84, 10, 55, 49, 45, 34, 25,
                                  3, 69, 69, 75, 62, 112, 109, 97, 109, 108, 94,
                                  104, 100, 91, 100, 99, 101, 88, 91, 90, 100,
                                  96, 85, 78, 79, 79, 76, 71, 67, 67, 2, 69, 69,
                                  73, 64, 0, 67, 1, 1, 0, 1, 5, 0, 64, 1, 7, 65,
                                  69, 73, 69, 66, 68, 16, 16, 17, 20, 15, 16,
                                  14, 15, 14, 4, 12, 12, 67, 2, 58, 58, 55, 59,
                                  60, 62, 62, 62, 62, 62, 62, 62, 62, 55, 34,
                                  62, 62, 62, 62, 62, 62, 48, 41, 39, 31, 20,
                                  12, 1, 71, 62, 62, 62, 62, 62, 62, 62, 62, 52,
                                  48, 43, 40, 24, 15, 4, 8, 8, 2, 28, 27, 26,
                                  23, 19, 21, 13, 10, 9, 2, 77, 67, 79, 89, 16,
                                  1, 67, 81, 77, 70, 76, 69, 2, 71, 76, 65, 2,
                                  3, 2, 6, 4, 3, 62, 56, 46, 38, 30, 20, 11, 68,
                                  86, 67, 39, 28, 23, 13, 12, 4, 1, 64, 77, 79,
                                  74, 67, 74, 64, 4, 68, 72, 1, 5, 6, 5, 9, 9,
                                  4, 62, 56, 46, 38, 30, 20, 11, 68, 86 },

                                {

                                62,
                                  8, 76, 62, 8, 76, 107, 88, 15, 10, 8, 23, 40,
                                  52, 56, 20, 98, 66, 66, 70, 8, 7, 67, 3, 12,
                                  28, 36, 22, 64, 86, 96, 90, 73, 66, 70, 8, 73,
                                  81, 11, 15, 67, 78, 89, 3, 76, 84, 97, 7, 71,
                                  80, 4, 78, 81, 91, 65, 76, 70, 84, 68, 2, 22,
                                  0, 0, 0, 76, 88, 97, 67, 14, 64, 40, 8, 81,
                                  100, 78, 84, 0, 73, 85, 81, 100, 82, 95, 89,
                                  102, 80, 85, 89, 89, 24, 65, 73, 102, 71, 95,
                                  84, 105, 6, 3, 4, 66, 13, 68, 69, 81, 94, 82,
                                  82, 82, 70, 78, 94, 88, 71, 98, 87, 73, 78,
                                  92, 95, 0, 74, 68, 66, 3, 9, 65, 70, 83, 95,
                                  72, 21, 21, 96, 9, 6, 5, 4, 5, 2, 66, 64, 2,
                                  8, 5, 2, 1, 1, 67, 68, 5, 65, 16, 26, 25, 17,
                                  10, 19, 12, 16, 12, 0, 15, 13, 23, 89, 16, 29,
                                  26, 52, 62, 36, 44, 61, 62, 40, 55, 53, 62,
                                  62, 40, 45, 34, 43, 57, 46, 62, 62, 62, 38,
                                  34, 55, 40, 62, 9, 62, 62, 62, 62, 62, 58, 55,
                                  54, 49, 44, 39, 33, 26, 21, 3, 75, 73, 82, 19,
                                  20, 17, 19, 7, 8, 6, 19, 65, 70, 67, 80, 73,
                                  109, 96, 3, 7, 10, 1, 69, 73, 77, 80, 103, 86,
                                  27, 14, 7, 67, 66, 79, 89, 93, 102, 68, 26,
                                  18, 13, 12, 2, 64, 66, 70, 79, 67, 36, 31, 25,
                                  8, 10, 65, 73, 83, 9, 55, 49, 44, 33, 24, 3,
                                  69, 69, 75, 62, 111, 108, 96, 108, 106, 93,
                                  102, 98, 90, 99, 97, 99, 88, 90, 89, 99, 94,
                                  84, 78, 79, 78, 75, 71, 67, 67, 1, 69, 69, 73,
                                  64, 1, 66, 1, 1, 1, 2, 5, 1, 0, 1, 6, 65, 69,
                                  73, 69, 65, 69, 15, 16, 16, 19, 14, 16, 14,
                                  14, 14, 4, 11, 10, 68, 1, 56, 57, 54, 58, 58,
                                  62, 62, 62, 62, 62, 62, 62, 62, 52, 32, 62,
                                  62, 62, 62, 62, 62, 45, 39, 37, 29, 18, 11, 0,
                                  72, 62, 62, 62, 62, 62, 62, 60, 59, 49, 46,
                                  40, 37, 22, 14, 2, 7, 7, 1, 26, 26, 24, 21,
                                  18, 19, 11, 9, 7, 1, 78, 68, 80, 90, 14, 0,
                                  68, 81, 76, 70, 76, 68, 3, 71, 76, 64, 3, 3,
                                  3, 7, 4, 3, 62, 54, 44, 35, 27, 16, 7, 72, 89,
                                  67, 39, 28, 23, 13, 13, 5, 1, 64, 77, 78, 73,
                                  67, 73, 0, 5, 67, 71, 1, 5, 6, 5, 10, 9, 4,
                                  62, 54, 44, 35, 27, 16, 7, 72, 89 },

                                {

                                62,
                                  8, 76, 62, 8, 76, 106, 86, 15, 10, 7, 22, 38,
                                  51, 56, 19, 96, 66, 66, 69, 8, 7, 67, 2, 10,
                                  27, 33, 19, 66, 88, 93, 89, 73, 66, 69, 8, 73,
                                  80, 11, 14, 67, 78, 88, 3, 76, 84, 97, 7, 71,
                                  80, 4, 78, 80, 91, 65, 76, 70, 84, 68, 2, 22,
                                  0, 0, 0, 76, 89, 97, 66, 13, 64, 39, 7, 81,
                                  97, 77, 83, 2, 71, 84, 79, 98, 81, 94, 88,
                                  100, 80, 85, 88, 89, 24, 65, 72, 100, 71, 95,
                                  84, 103, 6, 2, 3, 67, 13, 68, 68, 81, 93, 81,
                                  82, 81, 70, 78, 92, 87, 70, 97, 86, 68, 74,
                                  89, 92, 0, 74, 68, 66, 3, 9, 64, 70, 83, 93,
                                  72, 19, 19, 94, 9, 6, 5, 4, 5, 2, 65, 0, 2, 8,
                                  5, 2, 1, 2, 68, 68, 5, 66, 16, 25, 25, 17, 10,
                                  19, 12, 16, 11, 0, 14, 12, 23, 89, 15, 28, 25,
                                  50, 62, 35, 42, 59, 60, 38, 52, 51, 62, 62,
                                  36, 43, 32, 41, 54, 43, 58, 62, 62, 35, 32,
                                  51, 38, 62, 7, 62, 62, 62, 62, 62, 56, 53, 52,
                                  47, 42, 37, 31, 24, 19, 1, 75, 73, 83, 18, 19,
                                  16, 18, 6, 6, 5, 17, 66, 71, 68, 81, 74, 108,
                                  94, 4, 8, 10, 1, 68, 73, 77, 79, 101, 85, 27,
                                  14, 8, 66, 65, 78, 88, 92, 101, 67, 27, 19,
                                  14, 12, 3, 0, 66, 70, 79, 67, 36, 31, 24, 8,
                                  10, 65, 73, 83, 9, 54, 48, 43, 32, 24, 3, 69,
                                  69, 75, 62, 110, 106, 95, 106, 105, 92, 100,
                                  96, 89, 97, 95, 97, 87, 89, 89, 98, 93, 84,
                                  78, 79, 78, 75, 71, 67, 67, 1, 69, 69, 74, 0,
                                  1, 65, 1, 1, 1, 2, 5, 1, 0, 1, 6, 65, 69, 73,
                                  69, 65, 70, 14, 16, 15, 18, 13, 15, 14, 13,
                                  13, 4, 11, 9, 68, 0, 55, 56, 53, 56, 56, 62,
                                  61, 62, 62, 62, 62, 62, 61, 50, 30, 62, 62,
                                  62, 62, 62, 59, 43, 36, 34, 27, 16, 9, 64, 73,
                                  62, 62, 62, 62, 62, 62, 57, 56, 47, 43, 38,
                                  34, 20, 12, 1, 6, 6, 64, 25, 24, 22, 19, 16,
                                  17, 9, 8, 6, 0, 79, 69, 81, 91, 13, 64, 69,
                                  81, 76, 69, 75, 67, 4, 71, 75, 64, 3, 3, 3, 8,
                                  4, 3, 61, 52, 41, 32, 24, 12, 2, 76, 92, 67,
                                  39, 28, 23, 13, 13, 5, 1, 64, 76, 78, 73, 66,
                                  73, 0, 6, 67, 71, 1, 5, 6, 5, 10, 9, 4, 61,
                                  52, 41, 32, 24, 12, 2, 76, 92 },

                                {

                                62,
                                  8, 76, 62, 8, 76, 104, 85, 15, 10, 7, 21, 36,
                                  50, 56, 19, 94, 66, 66, 68, 7, 6, 67, 1, 8,
                                  26, 31, 15, 69, 90, 90, 88, 72, 66, 68, 7, 73,
                                  79, 11, 14, 67, 77, 87, 3, 76, 84, 97, 7, 71,
                                  80, 4, 78, 80, 90, 65, 76, 70, 84, 67, 2, 22,
                                  0, 0, 0, 75, 89, 97, 66, 12, 64, 38, 7, 81,
                                  95, 76, 82, 4, 69, 82, 78, 97, 79, 92, 87, 97,
                                  80, 84, 88, 88, 24, 65, 71, 98, 71, 94, 83,
                                  101, 6, 2, 3, 67, 13, 68, 68, 80, 92, 80, 81,
                                  80, 69, 77, 91, 85, 69, 95, 85, 0, 70, 86, 89,
                                  1, 73, 67, 65, 3, 9, 64, 70, 82, 91, 72, 17,
                                  17, 91, 9, 7, 5, 4, 5, 3, 0, 1, 3, 7, 5, 2, 2,
                                  2, 69, 67, 5, 66, 15, 24, 24, 16, 9, 19, 12,
                                  16, 10, 1, 13, 12, 22, 89, 15, 27, 24, 48, 62,
                                  34, 41, 57, 58, 36, 50, 49, 62, 62, 33, 41,
                                  30, 38, 51, 41, 55, 62, 62, 33, 30, 48, 36,
                                  62, 6, 62, 62, 62, 61, 60, 54, 51, 50, 45, 39,
                                  35, 29, 23, 17, 64, 75, 73, 83, 17, 18, 15,
                                  16, 5, 5, 4, 16, 67, 71, 69, 81, 75, 107, 93,
                                  5, 8, 10, 2, 68, 72, 76, 78, 99, 83, 27, 15,
                                  8, 66, 64, 77, 86, 90, 99, 67, 28, 20, 15, 13,
                                  4, 0, 65, 69, 78, 67, 37, 31, 24, 7, 10, 65,
                                  73, 82, 9, 54, 47, 42, 31, 24, 3, 68, 69, 74,
                                  62, 108, 105, 93, 104, 103, 91, 99, 95, 88,
                                  95, 94, 95, 86, 88, 88, 97, 91, 84, 78, 78,
                                  77, 74, 71, 68, 67, 0, 69, 69, 74, 0, 1, 64,
                                  1, 1, 1, 2, 5, 1, 0, 1, 5, 65, 69, 73, 69, 64,
                                  71, 13, 16, 14, 18, 13, 14, 14, 13, 12, 4, 11,
                                  8, 68, 64, 54, 55, 52, 54, 54, 62, 59, 61, 62,
                                  59, 62, 62, 58, 47, 28, 62, 62, 62, 62, 59,
                                  56, 40, 34, 32, 25, 15, 8, 64, 73, 62, 62, 62,
                                  62, 59, 59, 55, 53, 45, 41, 36, 31, 18, 10,
                                  64, 6, 6, 66, 24, 23, 21, 17, 14, 15, 8, 7, 4,
                                  64, 79, 71, 82, 91, 11, 66, 71, 80, 76, 68,
                                  75, 66, 5, 70, 74, 0, 4, 3, 4, 9, 4, 3, 60,
                                  50, 38, 29, 20, 8, 65, 80, 95, 66, 39, 28, 23,
                                  13, 14, 5, 2, 0, 76, 78, 73, 66, 73, 1, 7, 67,
                                  71, 2, 6, 6, 6, 11, 9, 4, 60, 50, 38, 29, 20,
                                  8, 65, 80, 95 },

                                {

                                61,
                                  8, 76, 61, 8, 76, 102, 83, 16, 10, 6, 19, 34,
                                  49, 56, 19, 92, 66, 65, 67, 7, 6, 67, 1, 7,
                                  25, 28, 12, 71, 91, 87, 87, 72, 65, 67, 7, 74,
                                  78, 11, 13, 67, 77, 87, 3, 76, 84, 97, 7, 71,
                                  79, 4, 78, 79, 90, 65, 76, 70, 84, 67, 2, 22,
                                  0, 0, 0, 75, 89, 97, 65, 11, 64, 37, 6, 81,
                                  92, 75, 81, 5, 67, 81, 76, 95, 78, 91, 86, 95,
                                  80, 84, 87, 88, 24, 65, 70, 96, 71, 93, 83,
                                  99, 6, 1, 2, 68, 13, 68, 67, 80, 91, 79, 81,
                                  79, 69, 76, 89, 84, 69, 94, 84, 5, 65, 83, 86,
                                  1, 73, 67, 65, 3, 9, 0, 69, 82, 89, 72, 15,
                                  15, 88, 9, 7, 5, 4, 5, 3, 1, 2, 3, 7, 5, 2, 2,
                                  3, 70, 67, 5, 67, 15, 23, 24, 16, 9, 19, 12,
                                  16, 9, 1, 12, 11, 22, 89, 15, 27, 24, 46, 61,
                                  33, 39, 55, 55, 34, 47, 47, 62, 62, 29, 39,
                                  28, 36, 48, 38, 52, 61, 62, 30, 28, 44, 34,
                                  62, 4, 60, 62, 60, 58, 57, 52, 49, 48, 43, 37,
                                  33, 27, 21, 16, 66, 75, 73, 84, 16, 17, 14,
                                  15, 4, 4, 3, 14, 68, 72, 70, 82, 75, 107, 91,
                                  6, 9, 10, 2, 67, 72, 76, 78, 97, 82, 27, 15,
                                  9, 65, 0, 76, 85, 89, 97, 66, 28, 20, 15, 13,
                                  5, 1, 65, 69, 78, 67, 37, 31, 23, 7, 10, 65,
                                  73, 82, 9, 53, 47, 41, 30, 24, 3, 68, 69, 74,
                                  62, 107, 103, 92, 103, 102, 90, 97, 93, 87,
                                  94, 92, 93, 86, 87, 88, 96, 89, 83, 78, 78,
                                  77, 74, 71, 68, 67, 0, 69, 69, 75, 1, 2, 0, 1,
                                  1, 2, 2, 5, 1, 0, 1, 5, 65, 69, 73, 69, 64,
                                  72, 12, 16, 13, 17, 12, 14, 14, 12, 11, 4, 11,
                                  7, 68, 65, 53, 54, 51, 53, 52, 60, 57, 59, 59,
                                  57, 62, 60, 55, 45, 26, 62, 62, 62, 62, 55,
                                  53, 38, 32, 29, 23, 13, 6, 65, 74, 62, 62, 62,
                                  60, 56, 57, 52, 50, 42, 38, 33, 28, 16, 8, 65,
                                  5, 5, 67, 22, 21, 19, 15, 13, 13, 6, 6, 3, 65,
                                  80, 72, 83, 92, 10, 67, 72, 80, 75, 68, 74,
                                  65, 6, 70, 74, 0, 4, 3, 4, 10, 4, 3, 59, 48,
                                  36, 26, 17, 4, 69, 84, 98, 66, 39, 28, 23, 13,
                                  14, 6, 2, 0, 75, 78, 73, 65, 72, 2, 8, 67, 70,
                                  2, 6, 6, 6, 11, 9, 4, 59, 48, 36, 26, 17, 4,
                                  69, 84, 98 },

                                {

                                60,
                                  8, 76, 60, 8, 76, 100, 82, 16, 10, 6, 18, 32,
                                  48, 56, 19, 90, 66, 65, 66, 7, 5, 67, 0, 5,
                                  24, 26, 8, 74, 93, 84, 86, 72, 65, 66, 7, 74,
                                  77, 11, 13, 67, 77, 86, 3, 76, 84, 97, 7, 71,
                                  79, 4, 78, 79, 90, 65, 76, 70, 84, 67, 2, 22,
                                  0, 0, 0, 74, 89, 97, 65, 10, 64, 36, 6, 81,
                                  90, 74, 80, 7, 65, 79, 75, 93, 76, 90, 85, 93,
                                  80, 84, 87, 88, 24, 65, 69, 94, 71, 92, 82,
                                  97, 6, 1, 2, 68, 13, 68, 67, 79, 90, 78, 80,
                                  78, 68, 75, 88, 82, 68, 93, 83, 10, 2, 80, 83,
                                  1, 73, 67, 64, 3, 9, 0, 69, 81, 87, 72, 13,
                                  13, 85, 9, 7, 5, 4, 5, 4, 3, 3, 3, 7, 5, 2, 3,
                                  4, 71, 67, 5, 67, 14, 22, 23, 16, 8, 19, 12,
                                  16, 8, 1, 11, 10, 21, 89, 15, 26, 23, 44, 58,
                                  32, 37, 53, 53, 32, 45, 45, 62, 62, 26, 37,
                                  26, 34, 45, 36, 49, 57, 62, 27, 26, 41, 32,
                                  62, 2, 58, 62, 58, 56, 55, 50, 47, 46, 41, 35,
                                  31, 25, 19, 14, 68, 75, 73, 84, 15, 16, 13,
                                  14, 3, 3, 2, 12, 69, 72, 71, 83, 76, 106, 90,
                                  7, 9, 10, 2, 66, 71, 75, 77, 95, 81, 27, 15,
                                  9, 64, 1, 75, 83, 87, 95, 65, 29, 21, 16, 14,
                                  6, 1, 65, 69, 77, 67, 38, 31, 22, 7, 10, 65,
                                  73, 81, 9, 53, 46, 40, 29, 24, 3, 68, 69, 74,
                                  62, 106, 102, 91, 101, 100, 89, 95, 91, 86,
                                  92, 90, 91, 85, 86, 87, 95, 87, 83, 78, 78,
                                  76, 73, 71, 68, 67, 64, 69, 69, 75, 1, 2, 1,
                                  1, 1, 2, 2, 5, 1, 0, 1, 4, 65, 69, 73, 69, 0,
                                  73, 11, 16, 12, 16, 11, 13, 14, 11, 10, 4, 11,
                                  6, 68, 66, 52, 53, 50, 51, 50, 58, 55, 57, 57,
                                  54, 61, 57, 52, 42, 24, 62, 62, 62, 62, 52,
                                  50, 35, 30, 27, 21, 11, 5, 66, 75, 62, 62, 62,
                                  58, 53, 54, 50, 47, 40, 36, 31, 25, 14, 6, 67,
                                  4, 4, 69, 21, 20, 17, 13, 11, 11, 4, 5, 1, 66,
                                  81, 73, 84, 93, 8, 68, 73, 80, 75, 67, 74, 64,
                                  7, 70, 73, 1, 5, 3, 5, 11, 4, 3, 58, 46, 33,
                                  23, 14, 0, 73, 88, 101, 66, 39, 28, 23, 13,
                                  15, 6, 2, 0, 75, 78, 73, 65, 72, 3, 9, 67, 70,
                                  2, 6, 6, 6, 12, 9, 4, 58, 46, 33, 23, 14, 0,
                                  73, 88, 101 },

                                {

                                58,
                                  7, 77, 58, 7, 77, 99, 81, 16, 10, 5, 16, 29,
                                  47, 56, 18, 89, 67, 65, 66, 6, 4, 67, 64, 3,
                                  22, 23, 4, 77, 95, 82, 86, 72, 65, 66, 6, 75,
                                  77, 11, 12, 67, 77, 86, 2, 77, 84, 97, 6, 71,
                                  79, 4, 78, 79, 90, 65, 76, 71, 84, 67, 2, 22,
                                  0, 0, 0, 74, 90, 97, 65, 9, 65, 35, 5, 82, 88,
                                  73, 79, 8, 0, 78, 74, 92, 75, 89, 84, 91, 80,
                                  84, 87, 88, 24, 65, 69, 92, 71, 92, 82, 96, 5,
                                  0, 1, 69, 13, 68, 67, 79, 90, 78, 80, 78, 68,
                                  75, 87, 81, 68, 92, 82, 14, 6, 77, 81, 1, 73,
                                  67, 64, 2, 9, 0, 69, 81, 85, 72, 11, 11, 83,
                                  9, 7, 5, 4, 5, 4, 4, 3, 3, 6, 4, 2, 3, 4, 73,
                                  67, 5, 68, 13, 20, 22, 15, 7, 19, 12, 15, 6,
                                  1, 10, 9, 20, 89, 14, 25, 22, 41, 54, 30, 35,
                                  50, 50, 29, 42, 43, 55, 62, 22, 34, 24, 31,
                                  41, 33, 45, 52, 59, 24, 24, 37, 30, 62, 0, 55,
                                  59, 55, 53, 52, 47, 44, 43, 39, 32, 28, 23,
                                  17, 12, 70, 75, 74, 85, 14, 14, 11, 12, 1, 1,
                                  0, 10, 70, 73, 72, 84, 77, 106, 89, 7, 9, 10,
                                  2, 66, 71, 75, 77, 93, 80, 27, 15, 9, 64, 1,
                                  74, 82, 86, 94, 65, 29, 21, 16, 14, 7, 1, 65,
                                  69, 77, 68, 38, 30, 21, 6, 10, 65, 73, 81, 8,
                                  52, 45, 38, 28, 23, 3, 68, 69, 74, 62, 105,
                                  101, 90, 100, 99, 88, 94, 90, 85, 91, 89, 89,
                                  85, 86, 87, 94, 86, 83, 78, 78, 76, 73, 71,
                                  69, 68, 65, 69, 70, 76, 1, 2, 2, 1, 0, 2, 2,
                                  4, 1, 0, 1, 3, 65, 69, 73, 69, 0, 74, 10, 16,
                                  10, 15, 10, 12, 13, 10, 9, 4, 10, 4, 69, 68,
                                  50, 51, 49, 49, 48, 55, 52, 54, 54, 51, 58,
                                  54, 48, 39, 22, 62, 62, 61, 60, 48, 46, 32,
                                  27, 24, 19, 9, 3, 67, 76, 59, 60, 60, 55, 50,
                                  51, 47, 43, 37, 33, 28, 22, 12, 4, 69, 3, 3,
                                  71, 19, 18, 15, 10, 9, 9, 2, 3, 64, 68, 82,
                                  75, 85, 94, 6, 70, 75, 80, 75, 67, 74, 0, 8,
                                  70, 73, 1, 5, 3, 5, 11, 4, 2, 56, 44, 30, 19,
                                  10, 67, 78, 93, 104, 66, 39, 28, 23, 13, 15,
                                  6, 2, 0, 75, 78, 73, 65, 72, 3, 9, 67, 70, 2,
                                  6, 6, 6, 12, 8, 3, 56, 44, 30, 19, 10, 67, 78,
                                  93, 104 },

                                {

                                57,
                                  7, 77, 57, 7, 77, 97, 79, 17, 11, 5, 15, 27,
                                  46, 57, 18, 87, 67, 64, 65, 6, 4, 66, 64, 2,
                                  21, 21, 1, 79, 96, 79, 85, 71, 64, 65, 6, 75,
                                  76, 11, 12, 66, 76, 85, 2, 77, 83, 96, 6, 70,
                                  78, 4, 77, 78, 89, 64, 75, 71, 83, 66, 2, 22,
                                  0, 0, 0, 73, 90, 97, 64, 9, 65, 35, 5, 82, 85,
                                  71, 77, 10, 3, 76, 72, 90, 73, 87, 82, 88, 80,
                                  83, 86, 87, 24, 65, 68, 89, 70, 91, 81, 94, 5,
                                  0, 1, 69, 14, 68, 66, 78, 89, 77, 79, 77, 67,
                                  74, 85, 79, 67, 90, 80, 19, 11, 73, 78, 2, 72,
                                  66, 0, 2, 10, 1, 68, 80, 82, 71, 9, 10, 80, 9,
                                  8, 5, 5, 6, 5, 6, 4, 4, 6, 4, 2, 4, 5, 74, 66,
                                  5, 68, 13, 19, 22, 15, 7, 19, 12, 15, 5, 2,
                                  10, 9, 20, 89, 14, 25, 22, 39, 51, 29, 34, 48,
                                  48, 27, 40, 41, 49, 62, 19, 32, 23, 29, 38,
                                  31, 42, 48, 55, 22, 22, 34, 28, 62, 64, 53,
                                  57, 53, 51, 50, 45, 42, 41, 37, 30, 26, 22,
                                  16, 11, 71, 75, 74, 85, 14, 13, 10, 11, 0, 0,
                                  64, 9, 71, 73, 73, 84, 77, 105, 87, 8, 10, 10,
                                  3, 65, 70, 74, 76, 90, 78, 28, 16, 10, 0, 2,
                                  72, 80, 84, 92, 64, 30, 22, 17, 15, 8, 2, 64,
                                  68, 76, 68, 39, 30, 21, 6, 11, 64, 73, 80, 8,
                                  52, 45, 37, 27, 23, 4, 67, 68, 73, 62, 103,
                                  99, 88, 98, 97, 86, 92, 88, 83, 89, 87, 86,
                                  84, 85, 86, 92, 84, 82, 77, 77, 75, 72, 70,
                                  69, 68, 65, 69, 70, 76, 2, 3, 3, 2, 0, 3, 3,
                                  4, 2, 1, 1, 3, 64, 68, 72, 68, 1, 74, 9, 16,
                                  9, 15, 10, 12, 13, 10, 9, 4, 10, 3, 69, 69,
                                  49, 50, 49, 48, 47, 53, 50, 52, 52, 49, 56,
                                  52, 45, 37, 20, 61, 60, 57, 56, 45, 43, 30,
                                  25, 22, 18, 8, 2, 67, 76, 57, 58, 58, 53, 48,
                                  49, 45, 40, 35, 31, 26, 20, 11, 3, 70, 3, 3,
                                  72, 18, 17, 14, 8, 8, 8, 1, 2, 65, 69, 82, 76,
                                  85, 94, 5, 71, 76, 79, 74, 66, 73, 2, 10, 69,
                                  72, 2, 6, 4, 6, 12, 4, 2, 55, 42, 28, 16, 7,
                                  71, 82, 97, 106, 65, 39, 29, 24, 14, 16, 7, 3,
                                  1, 74, 77, 72, 64, 71, 4, 10, 66, 69, 3, 7, 6,
                                  7, 13, 8, 3, 55, 42, 28, 16, 7, 71, 82, 97,
                                  106 },

                                {

                                56,
                                  7, 77, 56, 7, 77, 95, 78, 17, 11, 5, 14, 25,
                                  45, 57, 18, 85, 67, 64, 64, 6, 3, 66, 65, 0,
                                  20, 18, 66, 82, 98, 76, 84, 71, 64, 64, 6, 75,
                                  75, 11, 11, 66, 76, 84, 2, 77, 83, 96, 6, 70,
                                  78, 4, 77, 78, 89, 64, 75, 71, 83, 66, 2, 22,
                                  0, 0, 0, 72, 90, 97, 64, 8, 65, 34, 5, 82, 83,
                                  70, 76, 12, 5, 75, 71, 88, 72, 86, 81, 86, 80,
                                  83, 86, 87, 24, 65, 67, 87, 70, 90, 80, 92, 5,
                                  0, 1, 70, 14, 68, 66, 77, 88, 76, 78, 76, 67,
                                  73, 84, 78, 66, 89, 79, 24, 15, 70, 75, 2, 72,
                                  66, 0, 2, 10, 1, 68, 80, 80, 71, 7, 8, 77, 9,
                                  8, 5, 5, 6, 5, 8, 5, 4, 6, 4, 2, 5, 6, 75, 66,
                                  5, 68, 12, 18, 21, 15, 6, 19, 12, 15, 4, 2, 9,
                                  8, 19, 89, 14, 24, 21, 37, 48, 28, 32, 46, 46,
                                  25, 38, 39, 43, 62, 15, 30, 21, 27, 35, 29,
                                  39, 44, 51, 19, 20, 31, 26, 62, 66, 51, 55,
                                  51, 49, 48, 43, 40, 39, 35, 28, 24, 20, 14, 9,
                                  73, 75, 74, 86, 13, 12, 9, 10, 64, 64, 65, 7,
                                  72, 73, 74, 85, 78, 104, 86, 9, 10, 10, 3, 64,
                                  69, 73, 75, 88, 77, 28, 16, 10, 1, 3, 71, 78,
                                  82, 90, 0, 31, 23, 18, 16, 9, 2, 64, 68, 75,
                                  68, 40, 30, 20, 6, 11, 64, 73, 80, 8, 52, 44,
                                  36, 26, 23, 4, 67, 68, 73, 62, 102, 98, 87,
                                  96, 95, 85, 90, 86, 82, 87, 85, 84, 83, 84,
                                  86, 91, 82, 82, 77, 77, 74, 72, 70, 69, 68,
                                  66, 69, 70, 76, 2, 3, 4, 2, 0, 3, 3, 4, 2, 1,
                                  1, 2, 64, 68, 72, 68, 2, 75, 8, 16, 8, 14, 9,
                                  11, 13, 9, 8, 4, 10, 2, 69, 70, 48, 49, 48,
                                  46, 45, 51, 48, 50, 50, 46, 53, 49, 42, 34,
                                  18, 57, 56, 53, 51, 42, 40, 27, 23, 19, 16, 6,
                                  1, 68, 77, 55, 56, 55, 51, 45, 46, 42, 37, 33,
                                  28, 24, 17, 9, 1, 72, 2, 2, 74, 17, 16, 12, 6,
                                  6, 6, 64, 1, 67, 70, 83, 77, 86, 95, 3, 72,
                                  77, 79, 74, 65, 73, 3, 11, 69, 71, 3, 7, 4, 6,
                                  13, 4, 2, 54, 40, 25, 13, 4, 75, 86, 101, 109,
                                  65, 39, 29, 24, 14, 17, 7, 3, 1, 74, 77, 72,
                                  64, 71, 5, 11, 66, 69, 3, 7, 6, 7, 14, 8, 3,
                                  54, 40, 25, 13, 4, 75, 86, 101, 109 },

                                {

                                55,
                                  7, 77, 55, 7, 77, 93, 76, 18, 11, 4, 12, 23,
                                  44, 57, 18, 83, 67, 0, 0, 6, 3, 66, 65, 64,
                                  19, 16, 69, 84, 99, 73, 83, 71, 0, 0, 6, 76,
                                  74, 11, 11, 66, 76, 84, 2, 77, 83, 96, 6, 70,
                                  77, 4, 77, 77, 89, 64, 75, 71, 83, 66, 2, 22,
                                  0, 0, 0, 72, 90, 97, 0, 7, 65, 33, 4, 82, 80,
                                  69, 75, 13, 7, 73, 69, 86, 70, 85, 80, 84, 80,
                                  83, 85, 87, 24, 65, 66, 85, 70, 89, 80, 90, 5,
                                  64, 0, 70, 14, 68, 65, 77, 87, 75, 78, 75, 66,
                                  72, 82, 76, 66, 88, 78, 29, 20, 67, 72, 2, 72,
                                  66, 1, 2, 10, 2, 67, 79, 78, 71, 5, 6, 74, 9,
                                  8, 5, 5, 6, 6, 9, 6, 4, 6, 4, 2, 5, 7, 76, 66,
                                  5, 69, 12, 17, 21, 15, 6, 19, 12, 15, 3, 2, 8,
                                  7, 19, 89, 14, 24, 21, 35, 45, 27, 30, 44, 43,
                                  23, 35, 37, 36, 62, 12, 28, 19, 25, 32, 26,
                                  36, 40, 47, 16, 18, 27, 24, 62, 68, 49, 53,
                                  49, 46, 45, 41, 38, 37, 33, 26, 22, 18, 12, 8,
                                  75, 75, 74, 86, 12, 11, 8, 9, 65, 65, 66, 5,
                                  73, 74, 75, 86, 78, 104, 84, 10, 11, 10, 3, 0,
                                  69, 73, 75, 86, 76, 28, 16, 11, 2, 4, 70, 77,
                                  81, 88, 1, 31, 23, 18, 16, 10, 3, 64, 68, 75,
                                  68, 40, 30, 19, 6, 11, 64, 73, 79, 8, 51, 44,
                                  35, 25, 23, 4, 67, 68, 73, 62, 101, 96, 86,
                                  95, 94, 84, 88, 84, 81, 86, 83, 82, 83, 83,
                                  85, 90, 80, 81, 77, 77, 74, 71, 70, 69, 68,
                                  66, 69, 70, 77, 3, 4, 5, 2, 0, 4, 3, 4, 2, 1,
                                  1, 2, 64, 68, 72, 68, 2, 76, 7, 16, 7, 13, 8,
                                  11, 13, 8, 7, 4, 10, 1, 69, 71, 47, 48, 47,
                                  45, 43, 49, 46, 48, 47, 44, 50, 46, 39, 32,
                                  16, 53, 52, 49, 46, 38, 37, 25, 21, 17, 14, 4,
                                  64, 69, 78, 53, 53, 53, 48, 42, 44, 40, 34,
                                  30, 26, 21, 14, 7, 64, 73, 1, 1, 75, 15, 14,
                                  10, 4, 5, 4, 66, 0, 68, 71, 84, 78, 87, 96, 2,
                                  73, 78, 79, 73, 65, 72, 4, 12, 69, 71, 3, 7,
                                  4, 7, 14, 4, 2, 53, 38, 23, 10, 1, 79, 90,
                                  105, 112, 65, 39, 29, 24, 14, 17, 8, 3, 1, 73,
                                  77, 72, 0, 70, 6, 12, 66, 68, 3, 7, 6, 7, 14,
                                  8, 3, 53, 38, 23, 10, 1, 79, 90, 105, 112 },

                                {

                                53,
                                  7, 77, 53, 7, 77, 92, 75, 18, 11, 4, 11, 21,
                                  43, 57, 17, 81, 67, 0, 1, 5, 2, 66, 66, 66,
                                  18, 13, 73, 87, 101, 70, 82, 71, 0, 1, 5, 76,
                                  73, 11, 10, 66, 75, 83, 2, 77, 83, 96, 6, 70,
                                  77, 4, 77, 77, 88, 64, 75, 71, 83, 65, 2, 22,
                                  0, 0, 0, 71, 91, 97, 0, 6, 65, 32, 4, 82, 78,
                                  68, 74, 15, 9, 72, 68, 85, 69, 83, 79, 82, 80,
                                  82, 85, 87, 24, 65, 65, 83, 70, 89, 79, 88, 5,
                                  64, 0, 71, 14, 68, 65, 76, 86, 74, 77, 74, 66,
                                  72, 81, 75, 65, 87, 77, 34, 24, 64, 69, 2, 71,
                                  66, 1, 2, 10, 2, 67, 79, 76, 71, 3, 4, 72, 9,
                                  9, 5, 5, 6, 6, 11, 7, 5, 5, 4, 2, 6, 7, 77,
                                  66, 5, 69, 11, 16, 20, 14, 5, 19, 12, 15, 2,
                                  2, 7, 6, 18, 89, 13, 23, 20, 33, 41, 26, 28,
                                  42, 41, 21, 33, 35, 30, 62, 8, 26, 17, 22, 29,
                                  24, 32, 35, 43, 13, 16, 24, 22, 62, 69, 47,
                                  51, 46, 44, 43, 39, 36, 35, 31, 23, 20, 16,
                                  10, 6, 77, 75, 74, 87, 11, 10, 7, 7, 66, 67,
                                  67, 4, 74, 74, 76, 86, 79, 103, 83, 11, 11,
                                  10, 4, 0, 68, 72, 74, 84, 74, 28, 17, 11, 2,
                                  5, 69, 75, 79, 87, 1, 32, 24, 19, 17, 11, 3,
                                  64, 67, 74, 68, 41, 30, 19, 5, 11, 64, 73, 79,
                                  8, 51, 43, 34, 24, 23, 4, 66, 68, 73, 62, 99,
                                  95, 85, 93, 92, 83, 87, 83, 80, 84, 82, 80,
                                  82, 82, 85, 89, 79, 81, 77, 77, 73, 71, 70,
                                  70, 68, 67, 69, 70, 77, 3, 4, 6, 2, 0, 4, 3,
                                  4, 2, 1, 1, 1, 64, 68, 72, 68, 3, 77, 6, 16,
                                  6, 13, 7, 10, 13, 7, 6, 4, 10, 0, 69, 72, 46,
                                  47, 46, 43, 41, 47, 44, 45, 45, 41, 47, 43,
                                  36, 29, 14, 48, 48, 45, 41, 35, 33, 22, 18,
                                  14, 12, 2, 65, 70, 78, 50, 51, 50, 46, 39, 41,
                                  37, 31, 28, 23, 19, 11, 5, 66, 75, 0, 1, 77,
                                  14, 13, 9, 2, 3, 2, 67, 64, 70, 72, 85, 80,
                                  88, 96, 0, 75, 80, 78, 73, 64, 72, 5, 13, 69,
                                  70, 4, 8, 4, 7, 15, 4, 2, 52, 36, 20, 7, 66,
                                  83, 95, 109, 115, 64, 39, 29, 24, 14, 18, 8,
                                  3, 1, 73, 77, 72, 0, 70, 6, 13, 66, 68, 4, 8,
                                  6, 7, 15, 8, 3, 52, 36, 20, 7, 66, 83, 95,
                                  109, 115 },

                                {

                                52,
                                  7, 77, 52, 7, 77, 90, 73, 18, 11, 3, 10, 19,
                                  42, 57, 17, 79, 67, 0, 2, 5, 2, 66, 67, 68,
                                  17, 11, 76, 89, 103, 67, 81, 70, 0, 2, 5, 76,
                                  72, 11, 10, 66, 75, 82, 2, 77, 83, 96, 6, 70,
                                  77, 4, 77, 76, 88, 64, 75, 71, 83, 65, 2, 22,
                                  0, 0, 0, 71, 91, 97, 1, 5, 65, 31, 3, 82, 75,
                                  67, 73, 17, 11, 70, 66, 83, 67, 82, 78, 79,
                                  80, 82, 84, 86, 24, 65, 64, 81, 70, 88, 79,
                                  86, 5, 65, 64, 71, 14, 68, 64, 76, 85, 73, 77,
                                  73, 65, 71, 79, 73, 64, 85, 76, 39, 28, 2, 66,
                                  3, 71, 65, 2, 2, 10, 3, 67, 78, 74, 71, 1, 2,
                                  69, 9, 9, 5, 5, 6, 7, 12, 8, 5, 5, 4, 2, 6, 8,
                                  78, 65, 5, 70, 11, 15, 20, 14, 5, 19, 12, 15,
                                  1, 3, 6, 6, 18, 89, 13, 22, 19, 31, 38, 25,
                                  27, 40, 39, 19, 30, 33, 24, 62, 5, 24, 15, 20,
                                  26, 21, 29, 31, 39, 11, 14, 20, 20, 62, 71,
                                  45, 49, 44, 42, 41, 37, 34, 33, 29, 21, 18,
                                  14, 9, 4, 79, 75, 74, 87, 10, 9, 6, 6, 67, 68,
                                  68, 2, 75, 75, 77, 87, 80, 102, 81, 12, 12,
                                  10, 4, 1, 68, 72, 73, 82, 73, 28, 17, 12, 3,
                                  6, 68, 74, 78, 85, 2, 33, 25, 20, 17, 12, 4,
                                  0, 67, 74, 68, 41, 30, 18, 5, 11, 64, 73, 78,
                                  8, 50, 42, 33, 23, 23, 4, 66, 68, 72, 62, 98,
                                  93, 83, 91, 91, 82, 85, 81, 79, 82, 80, 78,
                                  81, 81, 84, 88, 77, 81, 77, 76, 73, 70, 70,
                                  70, 68, 67, 69, 70, 78, 4, 4, 7, 2, 0, 4, 3,
                                  4, 2, 1, 1, 1, 64, 68, 72, 68, 3, 78, 5, 16,
                                  5, 12, 7, 9, 13, 7, 5, 4, 10, 64, 69, 73, 45,
                                  46, 45, 41, 39, 45, 42, 43, 42, 38, 44, 40,
                                  33, 27, 12, 44, 44, 41, 36, 32, 30, 20, 16,
                                  12, 10, 1, 67, 70, 79, 48, 48, 48, 44, 36, 38,
                                  35, 28, 26, 21, 17, 8, 3, 68, 76, 0, 0, 79,
                                  13, 11, 7, 0, 1, 0, 69, 65, 71, 73, 85, 81,
                                  89, 97, 64, 76, 81, 78, 73, 0, 71, 6, 14, 68,
                                  69, 4, 8, 4, 8, 16, 4, 2, 51, 34, 17, 4, 69,
                                  87, 99, 113, 118, 64, 39, 29, 24, 14, 18, 8,
                                  4, 2, 72, 77, 72, 1, 70, 7, 14, 66, 68, 4, 8,
                                  6, 8, 15, 8, 3, 51, 34, 17, 4, 69, 87, 99,
                                  113, 118 },

                                {

                                51,
                                  7, 78, 51, 7, 78, 88, 72, 19, 11, 3, 8, 17,
                                  41, 57, 17, 78, 67, 1, 2, 5, 1, 65, 67, 69,
                                  15, 8, 80, 92, 104, 65, 80, 70, 1, 2, 5, 77,
                                  72, 11, 9, 66, 75, 82, 2, 77, 82, 95, 6, 69,
                                  76, 4, 76, 76, 88, 64, 75, 71, 83, 65, 2, 22,
                                  0, 0, 0, 70, 91, 97, 1, 5, 66, 31, 3, 82, 73,
                                  66, 72, 18, 14, 69, 65, 81, 66, 81, 77, 77,
                                  80, 82, 84, 86, 24, 65, 0, 78, 70, 87, 78, 84,
                                  4, 65, 64, 72, 15, 68, 64, 75, 85, 73, 76, 72,
                                  65, 70, 78, 72, 64, 84, 75, 44, 33, 5, 0, 3,
                                  71, 65, 2, 2, 10, 3, 66, 78, 72, 70, 64, 0,
                                  66, 9, 9, 5, 5, 7, 7, 14, 9, 5, 5, 4, 2, 7, 9,
                                  79, 65, 5, 70, 10, 14, 19, 14, 4, 19, 12, 15,
                                  64, 3, 5, 5, 17, 89, 13, 22, 19, 29, 35, 24,
                                  25, 37, 36, 17, 28, 31, 17, 62, 1, 22, 14, 18,
                                  22, 19, 26, 27, 34, 8, 12, 17, 18, 62, 73, 43,
                                  47, 42, 39, 38, 35, 31, 31, 27, 19, 15, 12, 7,
                                  3, 80, 75, 74, 88, 9, 8, 5, 5, 68, 69, 69, 0,
                                  76, 75, 78, 88, 80, 102, 80, 13, 12, 10, 4, 2,
                                  67, 71, 73, 80, 72, 29, 17, 12, 4, 7, 67, 72,
                                  76, 83, 3, 33, 25, 20, 18, 13, 4, 0, 67, 73,
                                  68, 42, 30, 17, 5, 11, 64, 73, 78, 7, 50, 42,
                                  32, 22, 22, 4, 66, 68, 72, 62, 97, 92, 82, 90,
                                  89, 81, 83, 79, 78, 81, 78, 76, 81, 80, 84,
                                  87, 75, 80, 77, 76, 72, 70, 70, 70, 68, 68,
                                  69, 70, 78, 4, 5, 8, 2, 0, 5, 4, 4, 3, 2, 1,
                                  0, 64, 68, 72, 68, 4, 79, 4, 16, 4, 11, 6, 9,
                                  13, 6, 5, 4, 9, 66, 70, 74, 43, 45, 44, 40,
                                  37, 43, 40, 41, 40, 36, 41, 38, 30, 24, 10,
                                  40, 40, 37, 32, 28, 27, 17, 14, 9, 8, 64, 68,
                                  71, 80, 46, 46, 45, 41, 33, 36, 32, 25, 23,
                                  18, 14, 5, 1, 69, 78, 64, 64, 80, 11, 10, 5,
                                  65, 0, 65, 71, 66, 73, 74, 86, 82, 90, 98, 66,
                                  77, 82, 78, 72, 0, 71, 7, 15, 68, 69, 5, 9, 4,
                                  8, 17, 4, 2, 50, 32, 15, 1, 72, 91, 103, 117,
                                  121, 64, 39, 29, 24, 14, 19, 9, 4, 2, 72, 76,
                                  71, 1, 69, 8, 15, 65, 67, 4, 8, 6, 8, 16, 8,
                                  3, 50, 32, 15, 1, 72, 91, 103, 117, 121 },

                                {

                                50,
                                  7, 78, 50, 7, 78, 86, 70, 19, 11, 2, 7, 15,
                                  40, 57, 17, 76, 67, 1, 3, 4, 1, 65, 68, 71,
                                  14, 6, 83, 94, 106, 1, 79, 70, 1, 3, 4, 77,
                                  71, 11, 9, 66, 74, 81, 2, 77, 82, 95, 6, 69,
                                  76, 4, 76, 75, 87, 64, 75, 71, 83, 64, 2, 22,
                                  0, 0, 0, 70, 91, 97, 2, 4, 66, 30, 2, 82, 70,
                                  65, 71, 20, 16, 67, 0, 80, 64, 79, 76, 75, 80,
                                  81, 83, 86, 24, 65, 1, 76, 70, 86, 78, 82, 4,
                                  66, 65, 72, 15, 68, 0, 75, 84, 72, 76, 71, 64,
                                  69, 76, 70, 0, 83, 74, 49, 37, 8, 3, 3, 70,
                                  65, 3, 2, 10, 4, 66, 77, 70, 70, 66, 65, 0, 9,
                                  10, 5, 5, 7, 8, 15, 10, 6, 4, 4, 2, 7, 9, 80,
                                  65, 5, 71, 10, 13, 19, 13, 4, 19, 12, 15, 65,
                                  3, 4, 4, 17, 89, 13, 21, 18, 27, 32, 23, 23,
                                  35, 34, 15, 25, 29, 11, 62, 65, 20, 12, 15,
                                  19, 16, 23, 22, 30, 5, 10, 13, 16, 62, 74, 41,
                                  45, 40, 37, 36, 33, 29, 29, 25, 16, 13, 10, 5,
                                  1, 82, 75, 74, 88, 8, 7, 4, 3, 69, 70, 70, 64,
                                  77, 76, 79, 88, 81, 101, 78, 14, 13, 10, 5, 2,
                                  67, 71, 72, 78, 70, 29, 18, 13, 4, 8, 66, 71,
                                  75, 81, 3, 34, 26, 21, 18, 14, 5, 0, 66, 73,
                                  68, 42, 30, 17, 4, 11, 64, 73, 77, 7, 49, 41,
                                  31, 21, 22, 4, 65, 68, 72, 62, 95, 90, 81, 88,
                                  88, 80, 82, 78, 77, 79, 77, 74, 80, 79, 83,
                                  86, 73, 80, 77, 76, 72, 69, 70, 71, 68, 68,
                                  69, 70, 79, 5, 5, 9, 2, 0, 5, 4, 4, 3, 2, 1,
                                  0, 64, 68, 72, 68, 4, 80, 3, 16, 3, 11, 5, 8,
                                  13, 5, 4, 4, 9, 67, 70, 75, 42, 44, 43, 38,
                                  35, 41, 38, 38, 37, 33, 38, 35, 27, 22, 8, 35,
                                  36, 33, 27, 25, 24, 15, 12, 7, 6, 66, 70, 72,
                                  80, 43, 43, 43, 39, 30, 33, 30, 22, 21, 16,
                                  12, 2, 64, 71, 79, 65, 64, 82, 10, 8, 4, 67,
                                  65, 67, 72, 67, 74, 75, 87, 84, 91, 98, 67,
                                  79, 84, 77, 72, 1, 70, 8, 16, 68, 68, 5, 9, 4,
                                  9, 18, 4, 2, 49, 30, 12, 65, 76, 95, 107, 121,
                                  124, 0, 39, 29, 24, 14, 19, 9, 4, 2, 71, 76,
                                  71, 2, 69, 9, 16, 65, 67, 5, 9, 6, 8, 16, 8,
                                  3, 49, 30, 12, 65, 76, 95, 107, 121, 124 },

                                {

                                48,
                                  6, 78, 48, 6, 78, 85, 69, 19, 11, 2, 5, 12,
                                  39, 57, 16, 74, 68, 1, 4, 4, 0, 65, 69, 73,
                                  13, 3, 87, 97, 108, 4, 78, 70, 1, 4, 4, 78,
                                  70, 11, 8, 66, 74, 81, 1, 78, 82, 95, 6, 69,
                                  76, 4, 76, 75, 87, 64, 75, 71, 83, 64, 2, 22,
                                  0, 0, 0, 69, 92, 97, 2, 3, 66, 29, 2, 83, 68,
                                  64, 70, 21, 18, 66, 1, 78, 0, 78, 75, 73, 80,
                                  81, 83, 86, 24, 65, 2, 74, 70, 86, 77, 80, 4,
                                  66, 65, 73, 15, 68, 0, 74, 83, 71, 75, 71, 64,
                                  69, 75, 69, 0, 82, 73, 53, 41, 11, 5, 3, 70,
                                  65, 3, 1, 10, 4, 66, 77, 68, 70, 68, 67, 2, 9,
                                  10, 5, 5, 7, 8, 17, 10, 6, 4, 3, 2, 8, 10, 82,
                                  65, 5, 71, 9, 11, 18, 13, 3, 19, 12, 14, 66,
                                  3, 3, 3, 16, 89, 12, 20, 17, 25, 28, 21, 21,
                                  33, 31, 12, 23, 27, 4, 62, 69, 18, 10, 13, 16,
                                  14, 19, 18, 26, 2, 8, 10, 14, 62, 76, 39, 42,
                                  37, 34, 33, 30, 27, 26, 23, 14, 11, 8, 3, 64,
                                  84, 75, 75, 89, 7, 5, 3, 2, 70, 72, 72, 66,
                                  78, 76, 80, 89, 82, 101, 77, 15, 13, 10, 5, 3,
                                  66, 70, 72, 76, 69, 29, 18, 13, 5, 9, 65, 69,
                                  73, 80, 4, 34, 26, 21, 19, 15, 5, 0, 66, 72,
                                  69, 43, 30, 16, 4, 11, 64, 73, 77, 7, 49, 40,
                                  30, 20, 22, 4, 65, 68, 72, 62, 94, 89, 80, 87,
                                  86, 79, 80, 76, 76, 78, 75, 72, 80, 79, 83,
                                  85, 72, 80, 77, 76, 71, 69, 70, 71, 68, 69,
                                  69, 70, 79, 5, 5, 10, 2, 64, 5, 4, 3, 3, 2, 1,
                                  64, 64, 68, 72, 68, 5, 81, 2, 16, 1, 10, 4, 7,
                                  12, 4, 3, 4, 9, 68, 70, 77, 41, 42, 42, 36,
                                  33, 39, 36, 36, 35, 30, 35, 32, 24, 19, 6, 31,
                                  32, 28, 22, 21, 20, 12, 9, 4, 4, 68, 71, 73,
                                  81, 41, 41, 40, 36, 27, 30, 27, 19, 18, 13, 9,
                                  64, 66, 73, 81, 66, 65, 84, 8, 7, 2, 69, 67,
                                  69, 74, 69, 76, 77, 88, 85, 92, 99, 69, 80,
                                  85, 77, 72, 1, 70, 9, 17, 68, 68, 6, 10, 4, 9,
                                  18, 4, 1, 48, 28, 9, 68, 79, 99, 112, 126,
                                  126, 0, 39, 29, 24, 14, 20, 9, 4, 2, 71, 76,
                                  71, 2, 69, 9, 16, 65, 67, 5, 9, 6, 8, 17, 8,
                                  2, 48, 28, 9, 68, 79, 99, 112, 126, 126 },

                                {

                                47,
                                  6, 78, 47, 6, 78, 83, 68, 20, 11, 2, 4, 10,
                                  38, 58, 16, 72, 68, 2, 5, 4, 64, 65, 69, 74,
                                  12, 1, 91, 100, 109, 7, 77, 69, 2, 5, 4, 78,
                                  69, 11, 8, 65, 74, 80, 1, 78, 82, 95, 6, 69,
                                  75, 4, 76, 75, 87, 64, 75, 71, 82, 64, 2, 22,
                                  0, 0, 0, 68, 92, 97, 2, 2, 66, 28, 2, 83, 66,
                                  1, 69, 23, 20, 64, 2, 76, 2, 77, 73, 70, 80,
                                  81, 83, 85, 24, 65, 3, 72, 69, 85, 76, 78, 4,
                                  66, 65, 73, 15, 68, 0, 73, 82, 70, 74, 70, 0,
                                  68, 74, 67, 1, 80, 72, 58, 46, 15, 8, 4, 70,
                                  64, 4, 1, 10, 4, 65, 76, 65, 70, 70, 68, 5, 9,
                                  10, 5, 5, 7, 9, 19, 11, 6, 4, 3, 2, 9, 11, 83,
                                  64, 5, 71, 8, 10, 17, 13, 2, 19, 12, 14, 67,
                                  4, 2, 3, 15, 89, 12, 20, 17, 23, 25, 20, 20,
                                  31, 29, 10, 21, 25, 65, 62, 72, 16, 8, 11, 13,
                                  12, 16, 14, 22, 0, 6, 7, 12, 62, 78, 37, 40,
                                  35, 32, 31, 28, 25, 24, 21, 12, 9, 7, 2, 65,
                                  86, 75, 75, 89, 7, 4, 2, 1, 71, 73, 73, 68,
                                  79, 76, 81, 90, 82, 100, 76, 16, 13, 10, 5, 4,
                                  65, 69, 71, 73, 68, 29, 18, 13, 6, 10, 64, 67,
                                  71, 78, 5, 35, 27, 22, 20, 16, 5, 1, 66, 71,
                                  69, 44, 30, 15, 4, 12, 0, 73, 76, 7, 49, 40,
                                  29, 19, 22, 4, 65, 68, 71, 62, 93, 88, 78, 85,
                                  84, 78, 78, 74, 75, 76, 73, 70, 79, 78, 82,
                                  84, 70, 79, 76, 75, 70, 68, 70, 71, 68, 70,
                                  69, 70, 79, 5, 6, 11, 3, 64, 6, 4, 3, 3, 2, 1,
                                  65, 64, 67, 71, 68, 6, 81, 1, 16, 0, 9, 4, 7,
                                  12, 4, 2, 4, 9, 69, 70, 78, 40, 41, 42, 35,
                                  31, 37, 34, 34, 33, 28, 32, 29, 21, 16, 4, 27,
                                  28, 24, 17, 18, 17, 9, 7, 2, 3, 69, 72, 73,
                                  82, 39, 39, 38, 34, 25, 28, 25, 16, 16, 11, 7,
                                  66, 68, 75, 83, 66, 66, 85, 7, 6, 0, 71, 68,
                                  70, 76, 70, 78, 78, 88, 86, 92, 100, 71, 81,
                                  86, 77, 71, 2, 70, 10, 19, 67, 67, 7, 11, 4,
                                  10, 19, 4, 1, 47, 26, 7, 71, 82, 103, 116,
                                  126, 126, 0, 39, 29, 25, 15, 21, 10, 5, 3, 71,
                                  76, 71, 2, 68, 10, 17, 65, 66, 5, 9, 6, 9, 18,
                                  8, 2, 47, 26, 7, 71, 82, 103, 116, 126, 126 },

                                {

                                46,
                                  6, 78, 46, 6, 78, 81, 66, 20, 11, 1, 3, 8, 37,
                                  58, 16, 70, 68, 2, 6, 3, 64, 65, 70, 76, 11,
                                  65, 94, 102, 111, 10, 76, 69, 2, 6, 3, 78, 68,
                                  11, 7, 65, 73, 79, 1, 78, 82, 95, 6, 69, 75,
                                  4, 76, 74, 86, 64, 75, 71, 82, 0, 2, 22, 0, 0,
                                  0, 68, 92, 97, 3, 1, 66, 27, 1, 83, 0, 2, 68,
                                  25, 22, 0, 4, 75, 3, 75, 72, 68, 80, 80, 82,
                                  85, 24, 65, 4, 70, 69, 84, 76, 76, 4, 67, 66,
                                  74, 15, 68, 1, 73, 81, 69, 74, 69, 0, 67, 72,
                                  66, 2, 79, 71, 62, 50, 18, 11, 4, 69, 64, 4,
                                  1, 10, 5, 65, 76, 0, 70, 72, 70, 8, 9, 11, 5,
                                  5, 7, 9, 20, 12, 7, 3, 3, 2, 9, 11, 84, 64, 5,
                                  72, 8, 9, 17, 12, 2, 19, 12, 14, 68, 4, 1, 2,
                                  15, 89, 12, 19, 16, 21, 22, 19, 18, 29, 27, 8,
                                  18, 23, 71, 62, 76, 14, 6, 8, 10, 9, 13, 9,
                                  18, 66, 4, 3, 10, 62, 79, 35, 38, 33, 30, 29,
                                  26, 23, 22, 19, 9, 7, 5, 0, 67, 88, 75, 75,
                                  90, 6, 3, 1, 64, 72, 74, 74, 69, 80, 77, 82,
                                  90, 83, 99, 74, 17, 14, 10, 6, 4, 65, 69, 70,
                                  71, 66, 29, 19, 14, 6, 11, 0, 66, 70, 76, 5,
                                  36, 28, 23, 20, 17, 6, 1, 65, 71, 69, 44, 30,
                                  15, 3, 12, 0, 73, 76, 7, 48, 39, 28, 18, 22,
                                  4, 64, 68, 71, 62, 91, 86, 77, 83, 83, 77, 77,
                                  73, 74, 74, 72, 68, 78, 77, 82, 83, 68, 79,
                                  76, 75, 70, 68, 70, 72, 68, 70, 69, 70, 80, 6,
                                  6, 12, 3, 64, 6, 4, 3, 3, 2, 1, 65, 64, 67,
                                  71, 68, 6, 82, 0, 16, 64, 9, 3, 6, 12, 3, 1,
                                  4, 9, 70, 70, 79, 39, 40, 41, 33, 29, 35, 32,
                                  31, 30, 25, 29, 26, 18, 14, 2, 22, 24, 20, 12,
                                  15, 14, 7, 5, 64, 1, 71, 74, 74, 82, 36, 36,
                                  35, 32, 22, 25, 22, 13, 14, 8, 5, 69, 70, 77,
                                  84, 67, 66, 87, 6, 4, 64, 73, 70, 72, 77, 71,
                                  79, 79, 89, 88, 93, 100, 72, 83, 88, 76, 71,
                                  3, 69, 11, 20, 67, 66, 7, 11, 4, 10, 20, 4, 1,
                                  46, 24, 4, 74, 86, 107, 120, 126, 126, 1, 39,
                                  29, 25, 15, 21, 10, 5, 3, 70, 76, 71, 3, 68,
                                  11, 18, 65, 66, 6, 10, 6, 9, 18, 8, 2, 46, 24,
                                  4, 74, 86, 107, 120, 126, 126 },

                                {

                                45,
                                  6, 79, 45, 6, 79, 79, 65, 21, 11, 1, 1, 6, 36,
                                  58, 16, 69, 68, 3, 6, 3, 65, 64, 70, 77, 9,
                                  67, 98, 105, 112, 12, 75, 69, 3, 6, 3, 79, 68,
                                  11, 7, 65, 73, 79, 1, 78, 81, 94, 6, 68, 74,
                                  4, 75, 74, 86, 64, 75, 71, 82, 0, 2, 22, 0, 0,
                                  0, 67, 92, 97, 3, 1, 67, 27, 1, 83, 2, 3, 67,
                                  26, 25, 2, 5, 73, 5, 74, 71, 66, 80, 80, 82,
                                  85, 24, 65, 5, 67, 69, 83, 75, 74, 3, 67, 66,
                                  74, 16, 68, 1, 72, 81, 69, 73, 68, 1, 66, 71,
                                  64, 2, 78, 70, 62, 55, 21, 14, 4, 69, 64, 5,
                                  1, 10, 5, 64, 75, 2, 69, 74, 72, 11, 9, 11, 5,
                                  5, 8, 10, 22, 13, 7, 3, 3, 2, 10, 12, 85, 64,
                                  5, 72, 7, 8, 16, 12, 1, 19, 12, 14, 70, 4, 0,
                                  1, 14, 89, 12, 19, 16, 19, 19, 18, 16, 26, 24,
                                  6, 16, 21, 78, 62, 79, 12, 5, 6, 6, 7, 10, 5,
                                  13, 69, 2, 0, 8, 62, 81, 33, 36, 31, 27, 26,
                                  24, 20, 20, 17, 7, 4, 3, 65, 68, 89, 75, 75,
                                  90, 5, 2, 0, 65, 73, 75, 75, 71, 81, 77, 83,
                                  91, 83, 99, 73, 18, 14, 10, 6, 5, 64, 68, 70,
                                  69, 65, 30, 19, 14, 7, 12, 1, 64, 68, 74, 6,
                                  36, 28, 23, 21, 18, 6, 1, 65, 70, 69, 45, 30,
                                  14, 3, 12, 0, 73, 75, 6, 48, 39, 27, 17, 21,
                                  4, 64, 68, 71, 62, 90, 85, 76, 82, 81, 76, 75,
                                  71, 73, 73, 70, 66, 78, 76, 81, 82, 66, 78,
                                  76, 75, 69, 67, 70, 72, 68, 71, 69, 70, 80, 6,
                                  7, 13, 3, 64, 7, 5, 3, 4, 3, 1, 66, 64, 67,
                                  71, 68, 7, 83, 64, 16, 65, 8, 2, 6, 12, 2, 1,
                                  4, 8, 72, 71, 80, 37, 39, 40, 32, 27, 33, 30,
                                  29, 28, 23, 26, 24, 15, 11, 0, 18, 20, 16, 8,
                                  11, 11, 4, 3, 66, 64, 73, 75, 75, 83, 34, 34,
                                  33, 29, 19, 23, 20, 10, 11, 6, 2, 72, 72, 78,
                                  86, 68, 67, 88, 4, 3, 66, 75, 71, 74, 79, 72,
                                  81, 80, 90, 89, 94, 101, 74, 84, 89, 76, 70,
                                  3, 69, 12, 21, 67, 66, 8, 12, 4, 11, 21, 4, 1,
                                  45, 22, 2, 77, 89, 111, 124, 126, 126, 1, 39,
                                  29, 25, 15, 22, 11, 5, 3, 70, 75, 70, 3, 67,
                                  12, 19, 64, 65, 6, 10, 6, 9, 19, 8, 2, 45, 22,
                                  2, 77, 89, 111, 124, 126, 126 },

                                {

                                43,
                                  6, 79, 43, 6, 79, 78, 0, 21, 11, 0, 0, 4, 35,
                                  58, 15, 67, 68, 3, 7, 3, 65, 64, 71, 79, 8,
                                  70, 101, 107, 114, 15, 74, 69, 3, 7, 3, 79,
                                  67, 11, 6, 65, 73, 78, 1, 78, 81, 94, 6, 68,
                                  74, 4, 75, 73, 86, 64, 75, 71, 82, 0, 2, 22,
                                  0, 0, 0, 67, 93, 97, 4, 0, 67, 26, 0, 83, 5,
                                  4, 66, 28, 27, 3, 7, 71, 6, 73, 70, 64, 80,
                                  80, 81, 85, 24, 65, 6, 65, 69, 83, 75, 72, 3,
                                  68, 67, 75, 16, 68, 2, 72, 80, 68, 73, 67, 1,
                                  66, 69, 0, 3, 77, 69, 62, 59, 24, 17, 4, 69,
                                  64, 5, 1, 10, 6, 64, 75, 4, 69, 76, 74, 13, 9,
                                  11, 5, 5, 8, 10, 23, 14, 7, 3, 3, 2, 10, 13,
                                  86, 64, 5, 73, 7, 7, 16, 12, 1, 19, 12, 14,
                                  71, 4, 64, 0, 14, 89, 11, 18, 15, 17, 15, 17,
                                  14, 24, 22, 4, 13, 19, 84, 62, 83, 10, 3, 4,
                                  3, 4, 6, 1, 9, 72, 0, 67, 6, 62, 83, 31, 34,
                                  28, 25, 24, 22, 18, 18, 15, 5, 2, 1, 67, 70,
                                  91, 75, 75, 91, 4, 1, 64, 66, 74, 77, 76, 73,
                                  82, 78, 84, 92, 84, 98, 71, 19, 15, 10, 6, 6,
                                  64, 68, 69, 67, 64, 30, 19, 15, 8, 13, 2, 0,
                                  67, 73, 7, 37, 29, 24, 21, 19, 7, 1, 65, 70,
                                  69, 45, 30, 13, 3, 12, 0, 73, 75, 6, 47, 38,
                                  26, 16, 21, 4, 64, 68, 71, 62, 89, 83, 75, 80,
                                  80, 75, 73, 69, 72, 71, 68, 64, 77, 75, 81,
                                  81, 65, 78, 76, 75, 69, 67, 70, 72, 68, 71,
                                  69, 70, 81, 7, 7, 14, 3, 64, 7, 5, 3, 4, 3, 1,
                                  66, 64, 67, 71, 68, 7, 84, 65, 16, 66, 7, 1,
                                  5, 12, 1, 0, 4, 8, 73, 71, 81, 36, 38, 39, 30,
                                  25, 31, 28, 27, 25, 20, 23, 21, 12, 9, 65, 14,
                                  16, 12, 3, 8, 7, 2, 0, 69, 66, 75, 77, 76, 84,
                                  32, 31, 30, 27, 16, 20, 17, 7, 9, 3, 0, 75,
                                  74, 80, 87, 69, 68, 90, 3, 1, 68, 77, 73, 76,
                                  81, 73, 82, 81, 91, 90, 95, 102, 75, 85, 90,
                                  76, 70, 4, 68, 13, 22, 67, 65, 8, 12, 4, 11,
                                  22, 4, 1, 44, 20, 64, 80, 92, 115, 126, 126,
                                  126, 1, 39, 29, 25, 15, 22, 11, 5, 3, 69, 75,
                                  70, 4, 67, 12, 20, 64, 65, 6, 10, 6, 9, 19, 8,
                                  2, 44, 20, 64, 80, 92, 115, 126, 126, 126 },

                                {

                                42,
                                  6, 79, 42, 6, 79, 76, 1, 21, 11, 0, 64, 2, 34,
                                  58, 15, 65, 68, 3, 8, 2, 66, 64, 72, 81, 7,
                                  72, 105, 110, 116, 18, 73, 68, 3, 8, 2, 79,
                                  66, 11, 6, 65, 72, 77, 1, 78, 81, 94, 6, 68,
                                  74, 4, 75, 73, 85, 64, 75, 71, 82, 1, 2, 22,
                                  0, 0, 0, 66, 93, 97, 4, 64, 67, 25, 0, 83, 7,
                                  5, 65, 30, 29, 5, 8, 70, 8, 71, 69, 2, 80, 79,
                                  81, 84, 24, 65, 7, 0, 69, 82, 74, 70, 3, 68,
                                  67, 75, 16, 68, 2, 71, 79, 67, 72, 66, 2, 65,
                                  68, 2, 4, 75, 68, 62, 62, 27, 20, 5, 68, 0, 6,
                                  1, 10, 6, 64, 74, 6, 69, 78, 76, 16, 9, 12, 5,
                                  5, 8, 11, 25, 15, 8, 2, 3, 2, 11, 13, 87, 0,
                                  5, 73, 6, 6, 15, 11, 0, 19, 12, 14, 72, 5, 65,
                                  0, 13, 89, 11, 17, 14, 15, 12, 16, 13, 22, 20,
                                  2, 11, 17, 90, 62, 86, 8, 1, 1, 0, 2, 3, 67,
                                  5, 74, 65, 70, 4, 62, 84, 29, 32, 26, 23, 22,
                                  20, 16, 16, 13, 2, 0, 64, 68, 72, 93, 75, 75,
                                  91, 3, 0, 65, 68, 75, 78, 77, 74, 83, 78, 85,
                                  92, 85, 97, 70, 20, 15, 10, 7, 6, 0, 67, 68,
                                  65, 1, 30, 20, 15, 8, 14, 3, 2, 65, 71, 7, 38,
                                  30, 25, 22, 20, 7, 2, 64, 69, 69, 46, 30, 13,
                                  2, 12, 0, 73, 74, 6, 47, 37, 25, 15, 21, 4, 0,
                                  68, 70, 62, 87, 82, 73, 78, 78, 74, 72, 68,
                                  71, 69, 67, 1, 76, 74, 80, 80, 0, 78, 76, 74,
                                  68, 66, 70, 73, 68, 72, 69, 70, 81, 7, 7, 15,
                                  3, 64, 7, 5, 3, 4, 3, 1, 67, 64, 67, 71, 68,
                                  8, 85, 66, 16, 67, 7, 1, 4, 12, 1, 64, 4, 8,
                                  74, 71, 82, 35, 37, 38, 28, 23, 29, 26, 24,
                                  23, 17, 20, 18, 9, 6, 67, 9, 12, 8, 65, 5, 4,
                                  64, 65, 71, 68, 76, 78, 76, 84, 29, 29, 28,
                                  25, 13, 17, 15, 4, 7, 1, 65, 78, 76, 82, 89,
                                  69, 68, 92, 2, 0, 69, 79, 75, 78, 82, 74, 84,
                                  82, 91, 92, 96, 102, 77, 87, 92, 75, 70, 5,
                                  68, 14, 23, 66, 64, 9, 13, 4, 12, 23, 4, 1,
                                  43, 18, 67, 83, 96, 119, 126, 126, 126, 2, 39,
                                  29, 25, 15, 23, 11, 6, 4, 69, 75, 70, 4, 67,
                                  13, 21, 64, 65, 7, 11, 6, 10, 20, 8, 2, 43,
                                  18, 67, 83, 96, 119, 126, 126, 126 },

                                {

                                41,
                                  6, 79, 41, 6, 79, 74, 3, 22, 11, 64, 66, 0,
                                  33, 58, 15, 0, 68, 4, 9, 2, 66, 64, 72, 82, 6,
                                  75, 108, 112, 117, 21, 72, 68, 4, 9, 2, 80,
                                  65, 11, 5, 65, 72, 77, 1, 78, 81, 94, 6, 68,
                                  73, 4, 75, 72, 85, 64, 75, 71, 82, 1, 2, 22,
                                  0, 0, 0, 66, 93, 97, 5, 65, 67, 24, 64, 83,
                                  10, 6, 64, 31, 31, 6, 10, 68, 9, 70, 68, 4,
                                  80, 79, 80, 84, 24, 65, 8, 2, 69, 81, 74, 68,
                                  3, 69, 68, 76, 16, 68, 3, 71, 78, 66, 72, 65,
                                  2, 64, 66, 3, 4, 74, 67, 62, 62, 30, 23, 5,
                                  68, 0, 6, 1, 10, 7, 0, 74, 8, 69, 80, 78, 19,
                                  9, 12, 5, 5, 8, 11, 26, 16, 8, 2, 3, 2, 11,
                                  14, 88, 0, 5, 74, 6, 5, 15, 11, 0, 19, 12, 14,
                                  73, 5, 66, 64, 13, 89, 11, 17, 14, 13, 9, 15,
                                  11, 20, 17, 0, 8, 15, 97, 62, 90, 6, 64, 64,
                                  66, 64, 0, 71, 1, 77, 67, 74, 2, 62, 86, 27,
                                  30, 24, 20, 19, 18, 14, 14, 11, 0, 65, 66, 70,
                                  73, 95, 75, 75, 92, 2, 64, 66, 69, 76, 79, 78,
                                  76, 84, 79, 86, 93, 85, 97, 68, 21, 16, 10, 7,
                                  7, 0, 67, 68, 0, 2, 30, 20, 16, 9, 15, 4, 3,
                                  64, 69, 8, 38, 30, 25, 22, 21, 8, 2, 64, 69,
                                  69, 46, 30, 12, 2, 12, 0, 73, 74, 6, 46, 37,
                                  24, 14, 21, 4, 0, 68, 70, 62, 86, 80, 72, 77,
                                  77, 73, 70, 66, 70, 68, 65, 3, 76, 73, 80, 79,
                                  2, 77, 76, 74, 68, 66, 70, 73, 68, 72, 69, 70,
                                  82, 8, 8, 16, 3, 64, 8, 5, 3, 4, 3, 1, 67, 64,
                                  67, 71, 68, 8, 86, 67, 16, 68, 6, 0, 4, 12, 0,
                                  65, 4, 8, 75, 71, 83, 34, 36, 37, 27, 21, 27,
                                  24, 22, 20, 15, 17, 15, 6, 4, 69, 5, 8, 4, 70,
                                  1, 1, 66, 67, 74, 70, 78, 80, 77, 85, 27, 26,
                                  25, 22, 10, 15, 12, 1, 4, 65, 68, 81, 78, 84,
                                  90, 70, 69, 93, 0, 65, 71, 81, 76, 80, 84, 75,
                                  85, 83, 92, 93, 97, 103, 78, 88, 93, 75, 69,
                                  5, 67, 15, 24, 66, 64, 9, 13, 4, 12, 24, 4, 1,
                                  42, 16, 69, 86, 99, 123, 126, 126, 126, 2, 39,
                                  29, 25, 15, 23, 12, 6, 4, 68, 75, 70, 5, 66,
                                  14, 22, 64, 64, 7, 11, 6, 10, 20, 8, 2, 42,
                                  16, 69, 86, 99, 123, 126, 126, 126 },

                                {

                                40,
                                  6, 79, 40, 6, 79, 72, 4, 22, 11, 64, 67, 65,
                                  32, 58, 15, 2, 68, 4, 10, 2, 67, 64, 73, 84,
                                  5, 77, 112, 115, 119, 24, 71, 68, 4, 10, 2,
                                  80, 64, 11, 5, 65, 72, 76, 1, 78, 81, 94, 6,
                                  68, 73, 4, 75, 72, 85, 64, 75, 71, 82, 1, 2,
                                  22, 0, 0, 0, 65, 93, 97, 5, 66, 67, 23, 64,
                                  83, 12, 7, 0, 33, 33, 8, 11, 66, 11, 69, 67,
                                  6, 80, 79, 80, 84, 24, 65, 9, 4, 69, 80, 73,
                                  66, 3, 69, 68, 76, 16, 68, 3, 70, 77, 65, 71,
                                  64, 3, 0, 65, 5, 5, 73, 66, 62, 62, 33, 26, 5,
                                  68, 0, 7, 1, 10, 7, 0, 73, 10, 69, 82, 80, 22,
                                  9, 12, 5, 5, 8, 12, 28, 17, 8, 2, 3, 2, 12,
                                  15, 89, 0, 5, 74, 5, 4, 14, 11, 64, 19, 12,
                                  14, 74, 5, 67, 65, 12, 89, 11, 16, 13, 11, 6,
                                  14, 9, 18, 15, 65, 6, 13, 103, 62, 93, 4, 66,
                                  66, 69, 66, 66, 75, 66, 80, 69, 77, 0, 62, 88,
                                  25, 28, 22, 18, 17, 16, 12, 12, 9, 65, 67, 68,
                                  72, 75, 97, 75, 75, 92, 1, 65, 67, 70, 77, 80,
                                  79, 78, 85, 79, 87, 94, 86, 96, 67, 22, 16,
                                  10, 7, 8, 1, 66, 67, 2, 3, 30, 20, 16, 10, 16,
                                  5, 5, 1, 67, 9, 39, 31, 26, 23, 22, 8, 2, 64,
                                  68, 69, 47, 30, 11, 2, 12, 0, 73, 73, 6, 46,
                                  36, 23, 13, 21, 4, 0, 68, 70, 62, 85, 79, 71,
                                  75, 75, 72, 68, 64, 69, 66, 0, 5, 75, 72, 79,
                                  78, 4, 77, 76, 74, 67, 65, 70, 73, 68, 73, 69,
                                  70, 82, 8, 8, 17, 3, 64, 8, 5, 3, 4, 3, 1, 68,
                                  64, 67, 71, 68, 9, 87, 68, 16, 69, 5, 64, 3,
                                  12, 64, 66, 4, 8, 76, 71, 84, 33, 35, 36, 25,
                                  19, 25, 22, 20, 18, 12, 14, 12, 3, 1, 71, 1,
                                  4, 0, 75, 65, 65, 69, 69, 76, 72, 80, 81, 78,
                                  86, 25, 24, 23, 20, 7, 12, 10, 65, 2, 67, 70,
                                  84, 80, 86, 92, 71, 70, 95, 64, 66, 73, 83,
                                  78, 82, 86, 76, 87, 84, 93, 94, 98, 104, 80,
                                  89, 94, 75, 69, 6, 67, 16, 25, 66, 0, 10, 14,
                                  4, 13, 25, 4, 1, 41, 14, 72, 89, 102, 126,
                                  126, 126, 126, 2, 39, 29, 25, 15, 24, 12, 6,
                                  4, 68, 75, 70, 5, 66, 15, 23, 64, 64, 7, 11,
                                  6, 10, 21, 8, 2, 41, 14, 72, 89, 102, 126,
                                  126, 126, 126 },

                                {

                                38,
                                  5, 80, 38, 5, 80, 71, 5, 22, 11, 65, 69, 68,
                                  31, 58, 14, 3, 69, 4, 10, 1, 68, 64, 74, 86,
                                  3, 80, 116, 118, 121, 26, 71, 68, 4, 10, 1,
                                  81, 64, 11, 4, 65, 72, 76, 0, 79, 81, 94, 5,
                                  68, 73, 4, 75, 72, 85, 64, 75, 72, 82, 1, 2,
                                  22, 0, 0, 0, 65, 94, 97, 5, 67, 68, 22, 65,
                                  84, 14, 8, 1, 34, 35, 9, 12, 65, 12, 68, 66,
                                  8, 80, 79, 80, 84, 24, 65, 9, 6, 69, 80, 73,
                                  65, 2, 70, 69, 77, 16, 68, 3, 70, 77, 65, 71,
                                  64, 3, 0, 64, 6, 5, 72, 65, 62, 62, 36, 28, 5,
                                  68, 0, 7, 0, 10, 7, 0, 73, 12, 69, 84, 82, 24,
                                  9, 12, 5, 5, 8, 12, 29, 17, 8, 1, 2, 2, 12,
                                  15, 91, 0, 5, 75, 4, 2, 13, 10, 65, 19, 12,
                                  13, 76, 5, 68, 66, 11, 89, 10, 15, 12, 8, 2,
                                  12, 7, 15, 12, 68, 3, 11, 110, 62, 97, 1, 68,
                                  69, 73, 69, 70, 80, 71, 83, 71, 81, 65, 62,
                                  90, 22, 25, 19, 15, 14, 13, 9, 9, 7, 68, 70,
                                  70, 74, 77, 99, 75, 76, 93, 0, 67, 69, 72, 79,
                                  82, 81, 80, 86, 80, 88, 95, 87, 96, 66, 22,
                                  16, 10, 7, 8, 1, 66, 67, 4, 4, 30, 20, 16, 10,
                                  16, 6, 6, 2, 66, 9, 39, 31, 26, 23, 23, 8, 2,
                                  64, 68, 70, 47, 29, 10, 1, 12, 0, 73, 73, 5,
                                  45, 35, 21, 12, 20, 4, 0, 68, 70, 62, 84, 78,
                                  70, 74, 74, 71, 67, 0, 68, 65, 1, 7, 75, 72,
                                  79, 77, 5, 77, 76, 74, 67, 65, 70, 74, 69, 74,
                                  69, 71, 83, 8, 8, 18, 3, 65, 8, 5, 2, 4, 3, 1,
                                  69, 64, 67, 71, 68, 9, 88, 69, 16, 71, 4, 65,
                                  2, 11, 65, 67, 4, 7, 78, 72, 86, 31, 33, 35,
                                  23, 17, 22, 19, 17, 15, 9, 11, 9, 64, 65, 73,
                                  67, 0, 68, 80, 69, 69, 72, 72, 79, 74, 82, 83,
                                  79, 87, 22, 21, 20, 17, 4, 9, 7, 69, 64, 70,
                                  73, 87, 82, 88, 94, 72, 71, 97, 66, 68, 75,
                                  86, 80, 84, 88, 78, 89, 86, 94, 96, 99, 105,
                                  82, 91, 96, 75, 69, 6, 67, 17, 26, 66, 0, 10,
                                  14, 4, 13, 25, 4, 0, 39, 12, 75, 93, 106, 126,
                                  126, 126, 126, 2, 39, 29, 25, 15, 24, 12, 6,
                                  4, 68, 75, 70, 5, 66, 15, 23, 64, 64, 7, 11,
                                  6, 10, 21, 7, 1, 39, 12, 75, 93, 106, 126,
                                  126, 126, 126 },

                                {

                                37,
                                  5, 80, 37, 5, 80, 69, 7, 23, 12, 65, 70, 70,
                                  30, 59, 14, 5, 69, 5, 11, 1, 68, 0, 74, 87, 2,
                                  82, 119, 120, 122, 29, 70, 67, 5, 11, 1, 81,
                                  0, 11, 4, 64, 71, 75, 0, 79, 80, 93, 5, 67,
                                  72, 4, 74, 71, 84, 0, 74, 72, 81, 2, 2, 22, 0,
                                  0, 0, 64, 94, 97, 6, 67, 68, 22, 65, 84, 17,
                                  10, 3, 36, 38, 11, 14, 0, 14, 66, 64, 11, 80,
                                  78, 79, 83, 24, 65, 10, 9, 68, 79, 72, 0, 2,
                                  70, 69, 77, 17, 68, 4, 69, 76, 64, 70, 0, 4,
                                  1, 1, 8, 6, 70, 0, 62, 62, 40, 31, 6, 67, 1,
                                  8, 0, 11, 8, 1, 72, 15, 68, 86, 83, 27, 9, 13,
                                  5, 6, 9, 13, 31, 18, 9, 1, 2, 2, 13, 16, 92,
                                  1, 5, 75, 4, 1, 13, 10, 65, 19, 12, 13, 77, 6,
                                  68, 66, 11, 89, 10, 15, 12, 6, 64, 11, 6, 13,
                                  10, 70, 1, 9, 116, 62, 100, 64, 69, 71, 76,
                                  71, 73, 84, 75, 85, 73, 84, 67, 62, 91, 20,
                                  23, 17, 13, 12, 11, 7, 7, 5, 70, 72, 71, 75,
                                  78, 100, 75, 76, 93, 0, 68, 70, 73, 80, 83,
                                  82, 81, 87, 80, 89, 95, 87, 95, 64, 23, 17,
                                  10, 8, 9, 2, 65, 66, 7, 6, 31, 21, 17, 11, 17,
                                  8, 8, 4, 64, 10, 40, 32, 27, 24, 24, 9, 3, 0,
                                  67, 70, 48, 29, 10, 1, 13, 1, 73, 72, 5, 45,
                                  35, 20, 11, 20, 5, 1, 67, 69, 62, 82, 76, 68,
                                  72, 72, 69, 65, 2, 66, 0, 3, 10, 74, 71, 78,
                                  75, 7, 76, 75, 73, 66, 64, 69, 74, 69, 74, 69,
                                  71, 83, 9, 9, 19, 4, 65, 9, 6, 2, 5, 4, 1, 69,
                                  0, 66, 70, 67, 10, 88, 70, 16, 72, 4, 65, 2,
                                  11, 65, 67, 4, 7, 79, 72, 87, 30, 32, 35, 22,
                                  16, 20, 17, 15, 13, 7, 9, 7, 67, 67, 75, 71,
                                  66, 72, 84, 72, 72, 74, 74, 81, 75, 83, 84,
                                  79, 87, 20, 19, 18, 15, 2, 7, 5, 72, 66, 72,
                                  75, 89, 83, 89, 95, 72, 71, 98, 67, 69, 76,
                                  88, 81, 85, 89, 79, 90, 87, 94, 97, 99, 105,
                                  83, 92, 97, 74, 68, 7, 66, 19, 28, 65, 1, 11,
                                  15, 5, 14, 26, 4, 0, 38, 10, 77, 96, 109, 126,
                                  126, 126, 126, 3, 39, 30, 26, 16, 25, 13, 7,
                                  5, 67, 74, 69, 6, 65, 16, 24, 0, 0, 8, 12, 6,
                                  11, 22, 7, 1, 38, 10, 77, 96, 109, 126, 126,
                                  126, 126 },

                                {

                                36,
                                  5, 80, 36, 5, 80, 67, 8, 23, 12, 65, 71, 72,
                                  29, 59, 14, 7, 69, 5, 12, 1, 69, 0, 75, 89, 1,
                                  85, 123, 123, 124, 32, 69, 67, 5, 12, 1, 81,
                                  1, 11, 3, 64, 71, 74, 0, 79, 80, 93, 5, 67,
                                  72, 4, 74, 71, 84, 0, 74, 72, 81, 2, 2, 22, 0,
                                  0, 0, 0, 94, 97, 6, 68, 68, 21, 65, 84, 19,
                                  11, 4, 38, 40, 12, 15, 2, 15, 65, 0, 13, 80,
                                  78, 79, 83, 24, 65, 11, 11, 68, 78, 71, 2, 2,
                                  70, 69, 78, 17, 68, 4, 68, 75, 0, 69, 1, 4, 2,
                                  2, 9, 7, 69, 1, 62, 62, 43, 34, 6, 67, 1, 8,
                                  0, 11, 8, 1, 72, 17, 68, 88, 85, 30, 9, 13, 5,
                                  6, 9, 13, 33, 19, 9, 1, 2, 2, 14, 17, 93, 1,
                                  5, 75, 3, 0, 12, 10, 66, 19, 12, 13, 78, 6,
                                  69, 67, 10, 89, 10, 14, 11, 4, 67, 10, 4, 11,
                                  8, 72, 64, 7, 122, 62, 104, 66, 71, 73, 79,
                                  73, 76, 88, 79, 88, 75, 87, 69, 62, 93, 18,
                                  21, 15, 11, 10, 9, 5, 5, 3, 72, 74, 73, 77,
                                  80, 102, 75, 76, 94, 64, 69, 71, 74, 81, 84,
                                  83, 83, 88, 80, 90, 96, 88, 94, 0, 24, 17, 10,
                                  8, 10, 3, 64, 65, 9, 7, 31, 21, 17, 12, 18, 9,
                                  10, 6, 1, 11, 41, 33, 28, 25, 25, 9, 3, 0, 66,
                                  70, 49, 29, 9, 1, 13, 1, 73, 72, 5, 45, 34,
                                  19, 10, 20, 5, 1, 67, 69, 62, 81, 75, 67, 70,
                                  70, 68, 0, 4, 65, 2, 5, 12, 73, 70, 78, 74, 9,
                                  76, 75, 73, 65, 64, 69, 74, 69, 75, 69, 71,
                                  83, 9, 9, 20, 4, 65, 9, 6, 2, 5, 4, 1, 70, 0,
                                  66, 70, 67, 11, 89, 71, 16, 73, 3, 66, 1, 11,
                                  66, 68, 4, 7, 80, 72, 88, 29, 31, 34, 20, 14,
                                  18, 15, 13, 11, 4, 6, 4, 70, 70, 77, 75, 70,
                                  76, 89, 75, 75, 77, 76, 84, 77, 85, 85, 80,
                                  88, 18, 17, 15, 13, 64, 4, 2, 75, 68, 75, 77,
                                  92, 85, 91, 97, 73, 72, 100, 68, 70, 78, 90,
                                  83, 87, 91, 80, 92, 88, 95, 98, 100, 106, 85,
                                  93, 98, 74, 68, 8, 66, 20, 29, 65, 2, 12, 16,
                                  5, 14, 27, 4, 0, 37, 8, 80, 99, 112, 126, 126,
                                  126, 126, 3, 39, 30, 26, 16, 26, 13, 7, 5, 67,
                                  74, 69, 6, 65, 17, 25, 0, 0, 8, 12, 6, 11, 23,
                                  7, 1, 37, 8, 80, 99, 112, 126, 126, 126, 126 },

                                {

                                35,
                                  5, 80, 35, 5, 80, 65, 10, 24, 12, 66, 73, 74,
                                  28, 59, 14, 9, 69, 6, 13, 1, 69, 0, 75, 90, 0,
                                  87, 126, 125, 125, 35, 68, 67, 6, 13, 1, 82,
                                  2, 11, 3, 64, 71, 74, 0, 79, 80, 93, 5, 67,
                                  71, 4, 74, 70, 84, 0, 74, 72, 81, 2, 2, 22, 0,
                                  0, 0, 0, 94, 97, 7, 69, 68, 20, 66, 84, 22,
                                  12, 5, 39, 42, 14, 17, 4, 17, 64, 1, 15, 80,
                                  78, 78, 83, 24, 65, 12, 13, 68, 77, 71, 4, 2,
                                  71, 70, 78, 17, 68, 5, 68, 74, 1, 69, 2, 5, 3,
                                  4, 11, 7, 68, 2, 62, 62, 46, 37, 6, 67, 1, 9,
                                  0, 11, 9, 2, 71, 19, 68, 90, 87, 33, 9, 13, 5,
                                  6, 9, 14, 34, 20, 9, 1, 2, 2, 14, 18, 94, 1,
                                  5, 76, 3, 64, 12, 10, 66, 19, 12, 13, 79, 6,
                                  70, 68, 10, 89, 10, 14, 11, 2, 70, 9, 2, 9, 5,
                                  74, 67, 5, 126, 62, 107, 68, 73, 75, 82, 76,
                                  79, 92, 83, 91, 77, 91, 71, 62, 95, 16, 19,
                                  13, 8, 7, 7, 3, 3, 1, 74, 76, 75, 79, 81, 104,
                                  75, 76, 94, 65, 70, 72, 75, 82, 85, 84, 85,
                                  89, 81, 91, 97, 88, 94, 2, 25, 18, 10, 8, 11,
                                  3, 64, 65, 11, 8, 31, 21, 18, 13, 19, 10, 11,
                                  7, 3, 12, 41, 33, 28, 25, 26, 10, 3, 0, 66,
                                  70, 49, 29, 8, 1, 13, 1, 73, 71, 5, 44, 34,
                                  18, 9, 20, 5, 1, 67, 69, 62, 80, 73, 66, 69,
                                  69, 67, 2, 6, 64, 3, 7, 14, 73, 69, 77, 73,
                                  11, 75, 75, 73, 65, 0, 69, 74, 69, 75, 69, 71,
                                  84, 10, 10, 21, 4, 65, 10, 6, 2, 5, 4, 1, 70,
                                  0, 66, 70, 67, 11, 90, 72, 16, 74, 2, 67, 1,
                                  11, 67, 69, 4, 7, 81, 72, 89, 28, 30, 33, 19,
                                  12, 16, 13, 11, 8, 2, 3, 1, 73, 72, 79, 79,
                                  74, 80, 94, 79, 78, 79, 78, 86, 79, 87, 87,
                                  81, 89, 16, 14, 13, 10, 67, 2, 0, 78, 71, 77,
                                  80, 95, 87, 93, 98, 74, 73, 101, 70, 72, 80,
                                  92, 84, 89, 93, 81, 93, 89, 96, 99, 101, 107,
                                  86, 94, 99, 74, 67, 8, 65, 21, 30, 65, 2, 12,
                                  16, 5, 15, 28, 4, 0, 36, 6, 82, 102, 115, 126,
                                  126, 126, 126, 3, 39, 30, 26, 16, 26, 14, 7,
                                  5, 66, 74, 69, 7, 64, 18, 26, 0, 1, 8, 12, 6,
                                  11, 23, 7, 1, 36, 6, 82, 102, 115, 126, 126,
                                  126, 126 },

                                {

                                33,
                                  5, 80, 33, 5, 80, 64, 11, 24, 12, 66, 74, 76,
                                  27, 59, 13, 11, 69, 6, 14, 0, 70, 0, 76, 92,
                                  64, 90, 126, 126, 126, 38, 67, 67, 6, 14, 0,
                                  82, 3, 11, 2, 64, 70, 73, 0, 79, 80, 93, 5,
                                  67, 71, 4, 74, 70, 83, 0, 74, 72, 81, 3, 2,
                                  22, 0, 0, 0, 1, 95, 97, 7, 70, 68, 19, 66, 84,
                                  24, 13, 6, 41, 44, 15, 18, 5, 18, 1, 2, 17,
                                  80, 77, 78, 83, 24, 65, 13, 15, 68, 77, 70, 6,
                                  2, 71, 70, 79, 17, 68, 5, 67, 73, 2, 68, 3, 5,
                                  3, 5, 12, 8, 67, 3, 62, 62, 49, 40, 6, 66, 1,
                                  9, 0, 11, 9, 2, 71, 21, 68, 92, 89, 35, 9, 14,
                                  5, 6, 9, 14, 36, 21, 10, 0, 2, 2, 15, 18, 95,
                                  1, 5, 76, 2, 65, 11, 9, 67, 19, 12, 13, 80, 6,
                                  71, 69, 9, 89, 9, 13, 10, 0, 74, 8, 0, 7, 3,
                                  76, 69, 3, 126, 62, 111, 70, 75, 78, 85, 78,
                                  83, 97, 87, 94, 79, 94, 73, 62, 96, 14, 17,
                                  10, 6, 5, 5, 1, 1, 64, 77, 78, 77, 81, 83,
                                  106, 75, 76, 95, 66, 71, 73, 77, 83, 87, 85,
                                  86, 90, 81, 92, 97, 89, 93, 3, 26, 18, 10, 9,
                                  11, 4, 0, 64, 13, 10, 31, 22, 18, 13, 20, 11,
                                  13, 9, 4, 12, 42, 34, 29, 26, 27, 10, 3, 1,
                                  65, 70, 50, 29, 8, 0, 13, 1, 73, 71, 5, 44,
                                  33, 17, 8, 20, 5, 2, 67, 69, 62, 78, 72, 65,
                                  67, 67, 66, 3, 7, 0, 5, 8, 16, 72, 68, 77, 72,
                                  12, 75, 75, 73, 64, 0, 69, 75, 69, 76, 69, 71,
                                  84, 10, 10, 22, 4, 65, 10, 6, 2, 5, 4, 1, 71,
                                  0, 66, 70, 67, 12, 91, 73, 16, 75, 2, 68, 0,
                                  11, 68, 70, 4, 7, 82, 72, 90, 27, 29, 32, 17,
                                  10, 14, 11, 8, 6, 64, 0, 65, 76, 75, 81, 84,
                                  78, 84, 99, 82, 82, 82, 81, 89, 81, 89, 88,
                                  82, 89, 13, 12, 10, 8, 70, 64, 66, 81, 73, 80,
                                  82, 98, 89, 95, 100, 75, 73, 103, 71, 73, 81,
                                  94, 86, 91, 94, 82, 95, 90, 97, 101, 102, 107,
                                  88, 96, 101, 73, 67, 9, 65, 22, 31, 65, 3, 13,
                                  17, 5, 15, 29, 4, 0, 35, 4, 85, 105, 119, 126,
                                  126, 126, 126, 4, 39, 30, 26, 16, 27, 14, 7,
                                  5, 66, 74, 69, 7, 64, 18, 27, 0, 1, 9, 13, 6,
                                  11, 24, 7, 1, 35, 4, 85, 105, 119, 126, 126,
                                  126, 126 },

                                {

                                32,
                                  5, 80, 32, 5, 80, 1, 13, 24, 12, 67, 75, 78,
                                  26, 59, 13, 13, 69, 6, 15, 0, 70, 0, 77, 94,
                                  65, 92, 126, 126, 126, 41, 66, 66, 6, 15, 0,
                                  82, 4, 11, 2, 64, 70, 72, 0, 79, 80, 93, 5,
                                  67, 71, 4, 74, 69, 83, 0, 74, 72, 81, 3, 2,
                                  22, 0, 0, 0, 1, 95, 97, 8, 71, 68, 18, 67, 84,
                                  27, 14, 7, 43, 46, 17, 20, 7, 20, 2, 3, 20,
                                  80, 77, 77, 82, 24, 65, 14, 17, 68, 76, 70, 8,
                                  2, 72, 71, 79, 17, 68, 6, 67, 72, 3, 68, 4, 6,
                                  4, 7, 14, 9, 65, 4, 62, 62, 52, 43, 7, 66, 2,
                                  10, 0, 11, 10, 2, 70, 23, 68, 94, 91, 38, 9,
                                  14, 5, 6, 9, 15, 37, 22, 10, 0, 2, 2, 15, 19,
                                  96, 2, 5, 77, 2, 66, 11, 9, 67, 19, 12, 13,
                                  81, 7, 72, 69, 9, 89, 9, 12, 9, 65, 77, 7, 64,
                                  5, 1, 78, 72, 1, 126, 62, 114, 72, 77, 80, 88,
                                  81, 86, 101, 91, 96, 81, 98, 75, 62, 98, 12,
                                  15, 8, 4, 3, 3, 64, 64, 66, 79, 80, 79, 82,
                                  85, 108, 75, 76, 95, 67, 72, 74, 78, 84, 88,
                                  86, 88, 91, 82, 93, 98, 90, 92, 5, 27, 19, 10,
                                  9, 12, 4, 0, 0, 15, 11, 31, 22, 19, 14, 21,
                                  12, 14, 10, 6, 13, 43, 35, 30, 26, 28, 11, 4,
                                  1, 65, 70, 50, 29, 7, 0, 13, 1, 73, 70, 5, 43,
                                  32, 16, 7, 20, 5, 2, 67, 68, 62, 77, 70, 0,
                                  65, 66, 65, 5, 9, 1, 7, 10, 18, 71, 67, 76,
                                  71, 14, 75, 75, 72, 64, 1, 69, 75, 69, 76, 69,
                                  71, 85, 11, 10, 23, 4, 65, 10, 6, 2, 5, 4, 1,
                                  71, 0, 66, 70, 67, 12, 92, 74, 16, 76, 1, 68,
                                  64, 11, 68, 71, 4, 7, 83, 72, 91, 26, 28, 31,
                                  15, 8, 12, 9, 6, 3, 67, 66, 68, 79, 77, 83,
                                  88, 82, 88, 104, 85, 85, 84, 83, 91, 83, 90,
                                  90, 82, 90, 11, 9, 8, 6, 73, 67, 68, 84, 75,
                                  82, 84, 101, 91, 97, 101, 75, 74, 105, 72, 75,
                                  83, 96, 88, 93, 96, 83, 96, 91, 97, 102, 103,
                                  108, 89, 97, 102, 73, 67, 10, 64, 23, 32, 64,
                                  4, 13, 17, 5, 16, 30, 4, 0, 34, 2, 88, 108,
                                  122, 126, 126, 126, 126, 4, 39, 30, 26, 16,
                                  27, 14, 8, 6, 65, 74, 69, 8, 64, 19, 28, 0, 1,
                                  9, 13, 6, 12, 24, 7, 1, 34, 2, 88, 108, 122,
                                  126, 126, 126, 126 },

                                {

                                31,
                                  5, 81, 31, 5, 81, 3, 14, 25, 12, 67, 77, 80,
                                  25, 59, 13, 14, 69, 7, 15, 0, 71, 1, 77, 95,
                                  67, 95, 126, 126, 126, 43, 65, 66, 7, 15, 0,
                                  83, 4, 11, 1, 64, 70, 72, 0, 79, 79, 92, 5,
                                  66, 70, 4, 73, 69, 83, 0, 74, 72, 81, 3, 2,
                                  22, 0, 0, 0, 2, 95, 97, 8, 71, 69, 18, 67, 84,
                                  29, 15, 8, 44, 49, 18, 21, 9, 21, 3, 4, 22,
                                  80, 77, 77, 82, 24, 65, 15, 20, 68, 75, 69,
                                  10, 1, 72, 71, 80, 18, 68, 6, 66, 72, 3, 67,
                                  5, 6, 5, 8, 15, 9, 64, 5, 62, 62, 55, 46, 7,
                                  66, 2, 10, 0, 11, 10, 3, 70, 25, 67, 96, 93,
                                  41, 9, 14, 5, 6, 10, 15, 39, 23, 10, 0, 2, 2,
                                  16, 20, 97, 2, 5, 77, 1, 67, 10, 9, 68, 19,
                                  12, 13, 83, 7, 73, 70, 8, 89, 9, 12, 9, 67,
                                  80, 6, 66, 2, 65, 80, 74, 64, 126, 62, 118,
                                  74, 78, 82, 92, 83, 89, 105, 96, 99, 83, 101,
                                  77, 62, 100, 10, 13, 6, 1, 0, 1, 67, 66, 68,
                                  81, 83, 81, 84, 86, 109, 75, 76, 96, 68, 73,
                                  75, 79, 85, 89, 87, 90, 92, 82, 94, 99, 90,
                                  92, 6, 28, 19, 10, 9, 13, 5, 1, 0, 17, 12, 32,
                                  22, 19, 15, 22, 13, 16, 12, 8, 14, 43, 35, 30,
                                  27, 29, 11, 4, 1, 64, 70, 51, 29, 6, 0, 13, 1,
                                  73, 70, 4, 43, 32, 15, 6, 19, 5, 2, 67, 68,
                                  62, 76, 69, 1, 64, 64, 64, 7, 11, 2, 8, 12,
                                  20, 71, 66, 76, 70, 16, 74, 75, 72, 0, 1, 69,
                                  75, 69, 77, 69, 71, 85, 11, 11, 24, 4, 65, 11,
                                  7, 2, 6, 5, 1, 72, 0, 66, 70, 67, 13, 93, 75,
                                  16, 77, 0, 69, 64, 11, 69, 71, 4, 6, 85, 73,
                                  92, 24, 27, 30, 14, 6, 10, 7, 4, 1, 69, 69,
                                  70, 82, 80, 85, 92, 86, 92, 108, 89, 88, 87,
                                  85, 94, 85, 92, 91, 83, 91, 9, 7, 5, 3, 76,
                                  69, 71, 87, 78, 85, 87, 104, 93, 98, 103, 76,
                                  75, 106, 74, 76, 85, 98, 89, 95, 98, 84, 98,
                                  92, 98, 103, 104, 109, 91, 98, 103, 73, 66,
                                  10, 64, 24, 33, 64, 4, 14, 18, 5, 16, 31, 4,
                                  0, 33, 0, 90, 111, 125, 126, 126, 126, 126, 4,
                                  39, 30, 26, 16, 28, 15, 8, 6, 65, 73, 68, 8,
                                  0, 20, 29, 1, 2, 9, 13, 6, 12, 25, 7, 1, 33,
                                  0, 90, 111, 125, 126, 126, 126, 126 },

                                {

                                30,
                                  5, 81, 30, 5, 81, 5, 16, 25, 12, 68, 78, 82,
                                  24, 59, 13, 16, 69, 7, 16, 64, 71, 1, 78, 97,
                                  68, 97, 126, 126, 126, 46, 64, 66, 7, 16, 64,
                                  83, 5, 11, 1, 64, 69, 71, 0, 79, 79, 92, 5,
                                  66, 70, 4, 73, 68, 82, 0, 74, 72, 81, 4, 2,
                                  22, 0, 0, 0, 2, 95, 97, 9, 72, 69, 17, 68, 84,
                                  32, 16, 9, 46, 51, 20, 23, 10, 23, 5, 5, 24,
                                  80, 76, 76, 82, 24, 65, 16, 22, 68, 74, 69,
                                  12, 1, 73, 72, 80, 18, 68, 7, 66, 71, 4, 67,
                                  6, 7, 6, 10, 17, 10, 0, 6, 62, 62, 58, 49, 7,
                                  65, 2, 11, 0, 11, 11, 3, 69, 27, 67, 98, 95,
                                  44, 9, 15, 5, 6, 10, 16, 40, 24, 11, 64, 2, 2,
                                  16, 20, 98, 2, 5, 78, 1, 68, 10, 8, 68, 19,
                                  12, 13, 84, 7, 74, 71, 8, 89, 9, 11, 8, 69,
                                  83, 5, 68, 0, 67, 82, 77, 66, 126, 62, 121,
                                  76, 80, 85, 95, 86, 92, 110, 100, 102, 85,
                                  105, 79, 62, 101, 8, 11, 4, 64, 65, 64, 69,
                                  68, 70, 84, 85, 83, 86, 88, 111, 75, 76, 96,
                                  69, 74, 76, 81, 86, 90, 88, 91, 93, 83, 95,
                                  99, 91, 91, 8, 29, 20, 10, 10, 13, 5, 1, 1,
                                  19, 14, 32, 23, 20, 15, 23, 14, 17, 13, 10,
                                  14, 44, 36, 31, 27, 30, 12, 4, 2, 64, 70, 51,
                                  29, 6, 64, 13, 1, 73, 69, 4, 42, 31, 14, 5,
                                  19, 5, 3, 67, 68, 62, 74, 67, 2, 1, 0, 0, 8,
                                  12, 3, 10, 13, 22, 70, 65, 75, 69, 18, 74, 75,
                                  72, 0, 2, 69, 76, 69, 77, 69, 71, 86, 12, 11,
                                  25, 4, 65, 11, 7, 2, 6, 5, 1, 72, 0, 66, 70,
                                  67, 13, 94, 76, 16, 78, 0, 70, 65, 11, 70, 72,
                                  4, 6, 86, 73, 93, 23, 26, 29, 12, 4, 8, 5, 1,
                                  65, 72, 72, 73, 85, 82, 87, 97, 90, 96, 113,
                                  92, 91, 89, 87, 96, 87, 94, 93, 84, 91, 6, 4,
                                  3, 1, 79, 72, 73, 90, 80, 87, 89, 107, 95,
                                  100, 104, 77, 75, 108, 75, 78, 86, 100, 91,
                                  97, 99, 85, 99, 93, 99, 105, 105, 109, 92,
                                  100, 105, 72, 66, 11, 0, 25, 34, 64, 5, 14,
                                  18, 5, 17, 32, 4, 0, 32, 65, 93, 114, 126,
                                  126, 126, 126, 126, 5, 39, 30, 26, 16, 28, 15,
                                  8, 6, 64, 73, 68, 9, 0, 21, 30, 1, 2, 10, 14,
                                  6, 12, 25, 7, 1, 32, 65, 93, 114, 126, 126,
                                  126, 126, 126 },

                                {

                                28,
                                  4, 81, 28, 4, 81, 6, 17, 25, 12, 68, 80, 85,
                                  23, 59, 12, 18, 70, 7, 17, 64, 72, 1, 79, 99,
                                  69, 100, 126, 126, 126, 49, 0, 66, 7, 17, 64,
                                  84, 6, 11, 0, 64, 69, 71, 64, 80, 79, 92, 5,
                                  66, 70, 4, 73, 68, 82, 0, 74, 72, 81, 4, 2,
                                  22, 0, 0, 0, 3, 96, 97, 9, 73, 69, 16, 68, 85,
                                  34, 17, 10, 47, 53, 21, 24, 12, 24, 6, 6, 26,
                                  80, 76, 76, 82, 24, 65, 17, 24, 68, 74, 68,
                                  14, 1, 73, 72, 81, 18, 68, 7, 65, 70, 5, 66,
                                  6, 7, 6, 11, 18, 10, 1, 7, 62, 62, 61, 51, 7,
                                  65, 2, 11, 64, 11, 11, 3, 69, 29, 67, 100, 97,
                                  46, 9, 15, 5, 6, 10, 16, 42, 24, 11, 64, 1, 2,
                                  17, 21, 100, 2, 5, 78, 0, 70, 9, 8, 69, 19,
                                  12, 12, 85, 7, 75, 72, 7, 89, 8, 10, 7, 71,
                                  87, 3, 70, 65, 70, 85, 79, 68, 126, 62, 125,
                                  78, 82, 87, 98, 88, 96, 114, 104, 105, 87,
                                  108, 81, 62, 103, 6, 8, 1, 67, 68, 67, 71, 71,
                                  72, 86, 87, 85, 88, 90, 113, 75, 77, 97, 70,
                                  76, 77, 82, 87, 92, 90, 93, 94, 83, 96, 100,
                                  92, 91, 9, 30, 20, 10, 10, 14, 6, 2, 1, 21,
                                  15, 32, 23, 20, 16, 24, 15, 19, 15, 11, 15,
                                  44, 36, 31, 28, 31, 12, 4, 2, 0, 71, 52, 29,
                                  5, 64, 13, 1, 73, 69, 4, 42, 30, 13, 4, 19, 5,
                                  3, 67, 68, 62, 73, 66, 3, 2, 2, 1, 10, 14, 4,
                                  11, 15, 24, 70, 65, 75, 68, 19, 74, 75, 72, 1,
                                  2, 69, 76, 69, 78, 69, 71, 86, 12, 11, 26, 4,
                                  66, 11, 7, 1, 6, 5, 1, 73, 0, 66, 70, 67, 14,
                                  95, 77, 16, 80, 64, 71, 66, 10, 71, 73, 4, 6,
                                  87, 73, 95, 22, 24, 28, 10, 2, 6, 3, 64, 67,
                                  75, 75, 76, 88, 85, 89, 101, 94, 101, 118, 96,
                                  95, 92, 90, 99, 89, 96, 94, 85, 92, 4, 2, 0,
                                  65, 82, 75, 76, 93, 83, 90, 92, 110, 97, 102,
                                  106, 78, 76, 110, 77, 79, 88, 102, 93, 99,
                                  101, 87, 101, 95, 100, 106, 106, 110, 94, 101,
                                  106, 72, 66, 11, 0, 26, 35, 64, 5, 15, 19, 5,
                                  17, 32, 4, 64, 31, 67, 96, 117, 126, 126, 126,
                                  126, 126, 5, 39, 30, 26, 16, 29, 15, 8, 6, 64,
                                  73, 68, 9, 0, 21, 30, 1, 2, 10, 14, 6, 12, 26,
                                  7, 0, 31, 67, 96, 117, 126, 126, 126, 126, 126 },

                                {

                                27,
                                  4, 81, 27, 4, 81, 8, 18, 26, 12, 68, 81, 87,
                                  22, 60, 12, 20, 70, 8, 18, 64, 73, 1, 79, 100,
                                  70, 102, 126, 126, 126, 52, 1, 65, 8, 18, 64,
                                  84, 7, 11, 0, 0, 69, 70, 64, 80, 79, 92, 5,
                                  66, 69, 4, 73, 68, 82, 0, 74, 72, 80, 4, 2,
                                  22, 0, 0, 0, 4, 96, 97, 9, 74, 69, 15, 68, 85,
                                  36, 19, 11, 49, 55, 23, 25, 14, 26, 7, 8, 29,
                                  80, 76, 76, 81, 24, 65, 18, 26, 67, 73, 67,
                                  16, 1, 73, 72, 81, 18, 68, 7, 64, 69, 6, 65,
                                  7, 8, 7, 12, 20, 11, 3, 8, 62, 62, 62, 54, 8,
                                  65, 3, 12, 64, 11, 11, 4, 68, 32, 67, 102, 98,
                                  49, 9, 15, 5, 6, 10, 17, 44, 25, 11, 64, 1, 2,
                                  18, 22, 101, 3, 5, 78, 64, 71, 8, 8, 70, 19,
                                  12, 12, 86, 8, 76, 72, 6, 89, 8, 10, 7, 73,
                                  90, 2, 71, 67, 72, 87, 81, 70, 126, 62, 126,
                                  80, 84, 89, 101, 90, 99, 118, 108, 107, 89,
                                  111, 83, 62, 105, 4, 6, 64, 69, 70, 69, 73,
                                  73, 74, 88, 89, 86, 89, 91, 115, 75, 77, 97,
                                  70, 77, 78, 83, 88, 93, 91, 95, 95, 83, 97,
                                  101, 92, 90, 10, 31, 20, 10, 10, 15, 7, 3, 2,
                                  24, 16, 32, 23, 20, 17, 25, 16, 21, 17, 13,
                                  16, 45, 37, 32, 29, 32, 12, 5, 2, 1, 71, 53,
                                  29, 4, 64, 14, 2, 73, 68, 4, 42, 30, 12, 3,
                                  19, 5, 3, 67, 67, 62, 72, 65, 5, 4, 4, 2, 12,
                                  16, 5, 13, 17, 26, 69, 64, 74, 67, 21, 73, 74,
                                  71, 2, 3, 69, 76, 69, 79, 69, 71, 86, 12, 12,
                                  27, 5, 66, 12, 7, 1, 6, 5, 1, 74, 0, 65, 69,
                                  67, 15, 95, 78, 16, 81, 65, 71, 66, 10, 71,
                                  74, 4, 6, 88, 73, 96, 21, 23, 28, 9, 0, 4, 1,
                                  66, 69, 77, 78, 79, 91, 88, 91, 105, 98, 105,
                                  123, 99, 98, 95, 92, 101, 90, 97, 95, 85, 93,
                                  2, 0, 65, 67, 84, 77, 78, 96, 85, 92, 94, 112,
                                  99, 104, 108, 78, 77, 111, 78, 80, 90, 104,
                                  94, 100, 103, 88, 103, 96, 100, 107, 106, 111,
                                  96, 102, 107, 72, 65, 12, 0, 27, 37, 0, 6, 16,
                                  20, 5, 18, 33, 4, 64, 30, 69, 98, 120, 126,
                                  126, 126, 126, 126, 5, 39, 30, 27, 17, 30, 16,
                                  9, 7, 64, 73, 68, 9, 1, 22, 31, 1, 3, 10, 14,
                                  6, 13, 27, 7, 0, 30, 69, 98, 120, 126, 126,
                                  126, 126, 126 },

                                {

                                26,
                                  4, 81, 26, 4, 81, 10, 20, 26, 12, 69, 82, 89,
                                  21, 60, 12, 22, 70, 8, 19, 65, 73, 1, 80, 102,
                                  71, 105, 126, 126, 126, 55, 2, 65, 8, 19, 65,
                                  84, 8, 11, 64, 0, 68, 69, 64, 80, 79, 92, 5,
                                  66, 69, 4, 73, 67, 81, 0, 74, 72, 80, 5, 2,
                                  22, 0, 0, 0, 4, 96, 97, 10, 75, 69, 14, 69,
                                  85, 39, 20, 12, 51, 57, 24, 27, 15, 27, 9, 9,
                                  31, 80, 75, 75, 81, 24, 65, 19, 28, 67, 72,
                                  67, 18, 1, 74, 73, 82, 18, 68, 8, 64, 68, 7,
                                  65, 8, 8, 8, 14, 21, 12, 4, 9, 62, 62, 62, 57,
                                  8, 64, 3, 12, 64, 11, 12, 4, 68, 34, 67, 104,
                                  100, 52, 9, 16, 5, 6, 10, 17, 45, 26, 12, 65,
                                  1, 2, 18, 22, 102, 3, 5, 79, 64, 72, 8, 7, 70,
                                  19, 12, 12, 87, 8, 77, 73, 6, 89, 8, 9, 6, 75,
                                  93, 1, 73, 69, 74, 89, 84, 72, 126, 62, 126,
                                  82, 86, 92, 104, 93, 102, 123, 112, 110, 91,
                                  115, 85, 62, 106, 2, 4, 66, 71, 72, 71, 75,
                                  75, 76, 91, 91, 88, 91, 93, 117, 75, 77, 98,
                                  71, 78, 79, 85, 89, 94, 92, 96, 96, 84, 98,
                                  101, 93, 89, 12, 32, 21, 10, 11, 15, 7, 3, 3,
                                  26, 18, 32, 24, 21, 17, 26, 17, 22, 18, 15,
                                  16, 46, 38, 33, 29, 33, 13, 5, 3, 1, 71, 53,
                                  29, 4, 65, 14, 2, 73, 68, 4, 41, 29, 11, 2,
                                  19, 5, 4, 67, 67, 62, 70, 0, 6, 6, 5, 3, 13,
                                  17, 6, 15, 18, 28, 68, 0, 74, 66, 23, 73, 74,
                                  71, 2, 3, 69, 77, 69, 79, 69, 71, 87, 13, 12,
                                  28, 5, 66, 12, 7, 1, 6, 5, 1, 74, 0, 65, 69,
                                  67, 15, 96, 79, 16, 82, 65, 72, 67, 10, 72,
                                  75, 4, 6, 89, 73, 97, 20, 22, 27, 7, 65, 2,
                                  64, 69, 72, 80, 81, 82, 94, 90, 93, 110, 102,
                                  109, 126, 102, 101, 97, 94, 104, 92, 99, 97,
                                  86, 93, 64, 66, 68, 69, 87, 80, 81, 99, 87,
                                  95, 96, 115, 101, 106, 109, 79, 77, 113, 79,
                                  82, 91, 106, 96, 102, 104, 89, 104, 97, 101,
                                  109, 107, 111, 97, 104, 109, 71, 65, 13, 1,
                                  28, 38, 0, 7, 16, 20, 5, 18, 34, 4, 64, 29,
                                  71, 101, 123, 126, 126, 126, 126, 126, 6, 39,
                                  30, 27, 17, 30, 16, 9, 7, 0, 73, 68, 10, 1,
                                  23, 32, 1, 3, 11, 15, 6, 13, 27, 7, 0, 29, 71,
                                  101, 123, 126, 126, 126, 126, 126 },

                                {

                                25,
                                  4, 82, 25, 4, 82, 12, 21, 27, 12, 69, 84, 91,
                                  20, 60, 12, 23, 70, 9, 19, 65, 74, 2, 80, 103,
                                  73, 107, 126, 126, 126, 57, 3, 65, 9, 19, 65,
                                  85, 8, 11, 64, 0, 68, 69, 64, 80, 78, 91, 5,
                                  65, 68, 4, 72, 67, 81, 0, 74, 72, 80, 5, 2,
                                  22, 0, 0, 0, 5, 96, 97, 10, 75, 70, 14, 69,
                                  85, 41, 21, 13, 52, 60, 26, 28, 17, 29, 10,
                                  10, 33, 80, 75, 75, 81, 24, 65, 20, 31, 67,
                                  71, 66, 20, 0, 74, 73, 82, 19, 68, 8, 0, 68,
                                  7, 64, 9, 9, 9, 15, 23, 12, 5, 10, 62, 62, 62,
                                  60, 8, 64, 3, 13, 64, 11, 12, 5, 67, 36, 66,
                                  106, 102, 55, 9, 16, 5, 6, 11, 18, 47, 27, 12,
                                  65, 1, 2, 19, 23, 103, 3, 5, 79, 65, 73, 7, 7,
                                  71, 19, 12, 12, 89, 8, 78, 74, 5, 89, 8, 9, 6,
                                  77, 96, 0, 75, 72, 77, 91, 86, 74, 126, 62,
                                  126, 84, 87, 94, 108, 95, 105, 126, 117, 113,
                                  93, 118, 87, 62, 108, 0, 2, 68, 74, 75, 73,
                                  78, 77, 78, 93, 94, 90, 93, 94, 118, 75, 77,
                                  98, 72, 79, 80, 86, 90, 95, 93, 98, 97, 84,
                                  99, 102, 93, 89, 13, 33, 21, 10, 11, 16, 8, 4,
                                  3, 28, 19, 33, 24, 21, 18, 27, 18, 24, 20, 17,
                                  17, 46, 38, 33, 30, 34, 13, 5, 3, 2, 71, 54,
                                  29, 3, 65, 14, 2, 73, 67, 3, 41, 29, 10, 1,
                                  18, 5, 4, 67, 67, 62, 69, 1, 7, 7, 7, 4, 15,
                                  19, 7, 16, 20, 30, 68, 1, 73, 65, 25, 72, 74,
                                  71, 3, 4, 69, 77, 69, 80, 69, 71, 87, 13, 13,
                                  29, 5, 66, 13, 8, 1, 7, 6, 1, 75, 0, 65, 69,
                                  67, 16, 97, 80, 16, 83, 66, 73, 67, 10, 73,
                                  75, 4, 5, 91, 74, 98, 18, 21, 26, 6, 67, 0,
                                  66, 71, 74, 82, 84, 84, 97, 93, 95, 114, 106,
                                  113, 126, 106, 104, 100, 96, 106, 94, 101, 98,
                                  87, 94, 66, 68, 70, 72, 90, 82, 83, 102, 90,
                                  97, 99, 118, 103, 107, 111, 80, 78, 114, 81,
                                  83, 93, 108, 97, 104, 106, 90, 106, 98, 102,
                                  110, 108, 112, 99, 105, 110, 71, 64, 13, 1,
                                  29, 39, 0, 7, 17, 21, 5, 19, 35, 4, 64, 28,
                                  73, 103, 126, 126, 126, 126, 126, 126, 6, 39,
                                  30, 27, 17, 31, 17, 9, 7, 0, 72, 67, 10, 2,
                                  24, 33, 2, 4, 11, 15, 6, 13, 28, 7, 0, 28, 73,
                                  103, 126, 126, 126, 126, 126, 126 },

                                {

                                23,
                                  4, 82, 23, 4, 82, 13, 23, 27, 12, 70, 85, 93,
                                  19, 60, 11, 25, 70, 9, 20, 65, 74, 2, 81, 105,
                                  74, 110, 126, 126, 126, 60, 4, 65, 9, 20, 65,
                                  85, 9, 11, 65, 0, 68, 68, 64, 80, 78, 91, 5,
                                  65, 68, 4, 72, 66, 81, 0, 74, 72, 80, 5, 2,
                                  22, 0, 0, 0, 5, 97, 97, 11, 76, 70, 13, 70,
                                  85, 44, 22, 14, 54, 62, 27, 30, 19, 30, 11,
                                  11, 35, 80, 75, 74, 81, 24, 65, 21, 33, 67,
                                  71, 66, 22, 0, 75, 74, 83, 19, 68, 9, 0, 67,
                                  8, 64, 10, 9, 9, 17, 24, 13, 6, 11, 62, 62,
                                  62, 62, 8, 64, 3, 13, 64, 11, 13, 5, 67, 38,
                                  66, 108, 104, 57, 9, 16, 5, 6, 11, 18, 48, 28,
                                  12, 65, 1, 2, 19, 24, 104, 3, 5, 80, 65, 74,
                                  7, 7, 71, 19, 12, 12, 90, 8, 79, 75, 5, 89, 7,
                                  8, 5, 79, 100, 64, 77, 74, 79, 93, 89, 76,
                                  126, 62, 126, 86, 89, 96, 111, 98, 109, 126,
                                  121, 116, 95, 122, 89, 62, 110, 65, 0, 71, 76,
                                  77, 75, 80, 79, 80, 95, 96, 92, 95, 96, 120,
                                  75, 77, 99, 73, 80, 81, 87, 91, 97, 94, 100,
                                  98, 85, 100, 103, 94, 88, 15, 34, 22, 10, 11,
                                  17, 8, 4, 4, 30, 20, 33, 24, 22, 19, 28, 19,
                                  25, 21, 18, 18, 47, 39, 34, 30, 35, 14, 5, 3,
                                  2, 71, 54, 29, 2, 65, 14, 2, 73, 67, 3, 40,
                                  28, 9, 0, 18, 5, 4, 67, 67, 62, 68, 3, 8, 9,
                                  8, 5, 17, 21, 8, 18, 22, 32, 67, 2, 73, 64,
                                  26, 72, 74, 71, 3, 4, 69, 77, 69, 80, 69, 71,
                                  88, 14, 13, 30, 5, 66, 13, 8, 1, 7, 6, 1, 75,
                                  0, 65, 69, 67, 16, 98, 81, 16, 84, 67, 74, 68,
                                  10, 74, 76, 4, 5, 92, 74, 99, 17, 20, 25, 4,
                                  69, 65, 68, 73, 77, 85, 87, 87, 100, 95, 97,
                                  118, 110, 117, 126, 109, 108, 102, 99, 109,
                                  96, 103, 100, 88, 95, 68, 71, 73, 74, 93, 85,
                                  86, 105, 92, 100, 101, 121, 105, 109, 112, 81,
                                  79, 116, 82, 85, 95, 110, 99, 106, 108, 91,
                                  107, 99, 103, 111, 109, 113, 100, 106, 111,
                                  71, 64, 14, 2, 30, 40, 0, 8, 17, 21, 5, 19,
                                  36, 4, 64, 27, 75, 106, 126, 126, 126, 126,
                                  126, 126, 6, 39, 30, 27, 17, 31, 17, 9, 7, 1,
                                  72, 67, 11, 2, 24, 34, 2, 4, 11, 15, 6, 13,
                                  28, 7, 0, 27, 75, 106, 126, 126, 126, 126,
                                  126, 126 },

                                {

                                22,
                                  4, 82, 22, 4, 82, 15, 24, 27, 12, 70, 86, 95,
                                  18, 60, 11, 27, 70, 9, 21, 66, 75, 2, 82, 107,
                                  75, 112, 126, 126, 126, 62, 5, 64, 9, 21, 66,
                                  85, 10, 11, 65, 0, 67, 67, 64, 80, 78, 91, 5,
                                  65, 68, 4, 72, 66, 80, 0, 74, 72, 80, 6, 2,
                                  22, 0, 0, 0, 6, 97, 97, 11, 77, 70, 12, 70,
                                  85, 46, 23, 15, 56, 62, 29, 31, 20, 32, 13,
                                  12, 38, 80, 74, 74, 80, 24, 65, 22, 35, 67,
                                  70, 65, 24, 0, 75, 74, 83, 19, 68, 9, 1, 66,
                                  9, 0, 11, 10, 10, 18, 26, 14, 8, 12, 62, 62,
                                  62, 62, 9, 0, 4, 14, 64, 11, 13, 5, 66, 40,
                                  66, 110, 106, 60, 9, 17, 5, 6, 11, 19, 50, 29,
                                  13, 66, 1, 2, 20, 24, 105, 4, 5, 80, 66, 75,
                                  6, 6, 72, 19, 12, 12, 91, 9, 80, 75, 4, 89, 7,
                                  7, 4, 81, 103, 65, 78, 76, 81, 95, 91, 78,
                                  126, 62, 126, 88, 91, 99, 114, 100, 112, 126,
                                  125, 118, 97, 125, 91, 62, 111, 67, 65, 73,
                                  78, 79, 77, 82, 81, 82, 98, 98, 94, 96, 98,
                                  122, 75, 77, 99, 74, 81, 82, 89, 92, 98, 95,
                                  101, 99, 85, 101, 103, 95, 87, 16, 35, 22, 10,
                                  12, 17, 9, 5, 5, 32, 22, 33, 25, 22, 19, 29,
                                  20, 27, 23, 20, 18, 48, 40, 35, 31, 36, 14, 6,
                                  4, 3, 71, 55, 29, 2, 66, 14, 2, 73, 66, 3, 40,
                                  27, 8, 64, 18, 5, 5, 67, 66, 62, 66, 4, 10,
                                  11, 10, 6, 18, 22, 9, 20, 23, 34, 66, 3, 72,
                                  0, 28, 72, 74, 70, 4, 5, 69, 78, 69, 81, 69,
                                  71, 88, 14, 13, 31, 5, 66, 13, 8, 1, 7, 6, 1,
                                  76, 0, 65, 69, 67, 17, 99, 82, 16, 85, 67, 74,
                                  69, 10, 74, 77, 4, 5, 93, 74, 100, 16, 19, 24,
                                  2, 71, 67, 70, 76, 79, 88, 90, 90, 103, 98,
                                  99, 123, 114, 121, 126, 112, 111, 105, 101,
                                  111, 98, 104, 101, 88, 95, 71, 73, 75, 76, 96,
                                  88, 88, 108, 94, 102, 103, 124, 107, 111, 114,
                                  81, 79, 118, 83, 86, 96, 112, 101, 108, 109,
                                  92, 109, 100, 103, 113, 110, 113, 102, 108,
                                  113, 70, 64, 15, 2, 31, 41, 1, 9, 18, 22, 5,
                                  20, 37, 4, 64, 26, 77, 109, 126, 126, 126,
                                  126, 126, 126, 7, 39, 30, 27, 17, 32, 17, 10,
                                  8, 1, 72, 67, 11, 2, 25, 35, 2, 4, 12, 16, 6,
                                  14, 29, 7, 0, 26, 77, 109, 126, 126, 126, 126,
                                  126, 126 },

                                {

                                21,
                                  4, 82, 21, 4, 82, 17, 26, 28, 12, 71, 88, 97,
                                  17, 60, 11, 29, 70, 10, 22, 66, 75, 2, 82,
                                  108, 76, 115, 126, 126, 126, 62, 6, 64, 10,
                                  22, 66, 86, 11, 11, 66, 0, 67, 67, 64, 80, 78,
                                  91, 5, 65, 67, 4, 72, 65, 80, 0, 74, 72, 80,
                                  6, 2, 22, 0, 0, 0, 6, 97, 97, 12, 78, 70, 11,
                                  71, 85, 49, 24, 16, 57, 62, 30, 33, 22, 33,
                                  14, 13, 40, 80, 74, 73, 80, 24, 65, 23, 37,
                                  67, 69, 65, 26, 0, 76, 75, 84, 19, 68, 10, 1,
                                  65, 10, 0, 12, 10, 11, 20, 27, 14, 9, 13, 62,
                                  62, 62, 62, 9, 0, 4, 14, 64, 11, 14, 6, 66,
                                  42, 66, 112, 108, 62, 9, 17, 5, 6, 11, 19, 51,
                                  30, 13, 66, 1, 2, 20, 25, 106, 4, 5, 81, 66,
                                  76, 6, 6, 72, 19, 12, 12, 92, 9, 81, 76, 4,
                                  89, 7, 7, 4, 83, 106, 66, 80, 78, 84, 97, 94,
                                  80, 126, 62, 126, 90, 93, 101, 117, 103, 115,
                                  126, 126, 121, 99, 126, 93, 62, 113, 69, 67,
                                  75, 81, 82, 79, 84, 83, 84, 100, 100, 96, 98,
                                  99, 124, 75, 77, 100, 75, 82, 83, 90, 93, 99,
                                  96, 103, 100, 86, 102, 104, 95, 87, 18, 36,
                                  23, 10, 12, 18, 9, 5, 5, 34, 23, 33, 25, 23,
                                  20, 30, 21, 28, 24, 22, 19, 48, 40, 35, 31,
                                  37, 15, 6, 4, 3, 71, 55, 29, 1, 66, 14, 2, 73,
                                  66, 3, 39, 27, 7, 65, 18, 5, 5, 67, 66, 62,
                                  65, 6, 11, 12, 11, 7, 20, 24, 10, 21, 25, 36,
                                  66, 4, 72, 1, 30, 71, 74, 70, 4, 5, 69, 78,
                                  69, 81, 69, 71, 89, 15, 14, 32, 5, 66, 14, 8,
                                  1, 7, 6, 1, 76, 0, 65, 69, 67, 17, 100, 83,
                                  16, 86, 68, 75, 69, 10, 75, 78, 4, 5, 94, 74,
                                  101, 15, 18, 23, 1, 73, 69, 72, 78, 82, 90,
                                  93, 93, 106, 100, 101, 126, 118, 125, 126,
                                  116, 114, 107, 103, 114, 100, 106, 103, 89,
                                  96, 73, 76, 78, 79, 99, 90, 91, 111, 97, 105,
                                  106, 126, 109, 113, 115, 82, 80, 119, 85, 88,
                                  98, 114, 102, 110, 111, 93, 110, 101, 104,
                                  114, 111, 114, 103, 109, 114, 70, 0, 15, 3,
                                  32, 42, 1, 9, 18, 22, 5, 20, 38, 4, 64, 25,
                                  79, 111, 126, 126, 126, 126, 126, 126, 7, 39,
                                  30, 27, 17, 32, 18, 10, 8, 2, 72, 67, 12, 3,
                                  26, 36, 2, 5, 12, 16, 6, 14, 29, 7, 0, 25, 79,
                                  111, 126, 126, 126, 126, 126, 126 },

                                {

                                20,
                                  4, 82, 20, 4, 82, 19, 27, 28, 12, 71, 89, 99,
                                  16, 60, 11, 31, 70, 10, 23, 66, 76, 2, 83,
                                  110, 77, 117, 126, 126, 126, 62, 7, 64, 10,
                                  23, 66, 86, 12, 11, 66, 0, 67, 66, 64, 80, 78,
                                  91, 5, 65, 67, 4, 72, 65, 80, 0, 74, 72, 80,
                                  6, 2, 22, 0, 0, 0, 7, 97, 97, 12, 79, 70, 10,
                                  71, 85, 51, 25, 17, 59, 62, 32, 34, 24, 35,
                                  15, 14, 42, 80, 74, 73, 80, 24, 65, 24, 39,
                                  67, 68, 64, 28, 0, 76, 75, 84, 19, 68, 10, 2,
                                  64, 11, 1, 13, 11, 12, 21, 29, 15, 10, 14, 62,
                                  62, 62, 62, 9, 0, 4, 15, 64, 11, 14, 6, 65,
                                  44, 66, 114, 110, 62, 9, 17, 5, 6, 11, 20, 53,
                                  31, 13, 66, 1, 2, 21, 26, 107, 4, 5, 81, 67,
                                  77, 5, 6, 73, 19, 12, 12, 93, 9, 82, 77, 3,
                                  89, 7, 6, 3, 85, 109, 67, 82, 80, 86, 99, 96,
                                  82, 126, 62, 126, 92, 95, 103, 120, 105, 118,
                                  126, 126, 124, 101, 126, 95, 62, 115, 71, 69,
                                  77, 83, 84, 81, 86, 85, 86, 102, 102, 98, 100,
                                  101, 126, 75, 77, 100, 76, 83, 84, 91, 94,
                                  100, 97, 105, 101, 86, 103, 105, 96, 86, 19,
                                  37, 23, 10, 12, 19, 10, 6, 6, 36, 24, 33, 25,
                                  23, 21, 31, 22, 30, 26, 24, 20, 49, 41, 36,
                                  32, 38, 15, 6, 4, 4, 71, 56, 29, 0, 66, 14, 2,
                                  73, 65, 3, 39, 26, 6, 66, 18, 5, 5, 67, 66,
                                  62, 64, 7, 12, 14, 13, 8, 22, 26, 11, 23, 27,
                                  38, 65, 5, 71, 2, 32, 71, 74, 70, 5, 6, 69,
                                  78, 69, 82, 69, 71, 89, 15, 14, 33, 5, 66, 14,
                                  8, 1, 7, 6, 1, 77, 0, 65, 69, 67, 18, 101, 84,
                                  16, 87, 69, 76, 70, 10, 76, 79, 4, 5, 95, 74,
                                  102, 14, 17, 22, 64, 75, 71, 74, 80, 84, 93,
                                  96, 96, 109, 103, 103, 126, 122, 126, 126,
                                  119, 117, 110, 105, 116, 102, 108, 104, 90,
                                  97, 75, 78, 80, 81, 102, 93, 93, 114, 99, 107,
                                  108, 126, 111, 115, 117, 83, 81, 121, 86, 89,
                                  100, 116, 104, 112, 113, 94, 112, 102, 105,
                                  115, 112, 115, 105, 110, 115, 70, 0, 16, 3,
                                  33, 43, 1, 10, 19, 23, 5, 21, 39, 4, 64, 24,
                                  81, 114, 126, 126, 126, 126, 126, 126, 7, 39,
                                  30, 27, 17, 33, 18, 10, 8, 2, 72, 67, 12, 3,
                                  27, 37, 2, 5, 12, 16, 6, 14, 30, 7, 0, 24, 81,
                                  114, 126, 126, 126, 126, 126, 126 },

                                {

                                18,
                                  3, 83, 18, 3, 83, 20, 28, 28, 12, 72, 91, 102,
                                  15, 60, 10, 32, 71, 10, 23, 67, 77, 2, 84,
                                  112, 79, 120, 126, 126, 126, 62, 7, 64, 10,
                                  23, 67, 87, 12, 11, 67, 0, 67, 66, 65, 81, 78,
                                  91, 4, 65, 67, 4, 72, 65, 80, 0, 74, 73, 80,
                                  6, 2, 22, 0, 0, 0, 7, 98, 97, 12, 80, 71, 9,
                                  72, 86, 53, 26, 18, 60, 62, 33, 35, 25, 36,
                                  16, 15, 44, 80, 74, 73, 80, 24, 65, 24, 41,
                                  67, 68, 64, 29, 64, 77, 76, 85, 19, 68, 10, 2,
                                  64, 11, 1, 13, 11, 12, 22, 30, 15, 11, 15, 62,
                                  62, 62, 62, 9, 0, 4, 15, 65, 11, 14, 6, 65,
                                  46, 66, 116, 112, 62, 9, 17, 5, 6, 11, 20, 54,
                                  31, 13, 67, 0, 2, 21, 26, 109, 4, 5, 82, 68,
                                  79, 4, 5, 74, 19, 12, 11, 95, 9, 83, 78, 2,
                                  89, 6, 5, 2, 88, 113, 69, 84, 83, 89, 102, 99,
                                  84, 126, 62, 126, 95, 97, 106, 124, 108, 122,
                                  126, 126, 126, 103, 126, 97, 62, 117, 74, 72,
                                  80, 86, 87, 84, 89, 88, 88, 105, 105, 100,
                                  102, 103, 126, 75, 78, 101, 77, 85, 86, 93,
                                  96, 102, 99, 107, 102, 87, 104, 106, 97, 86,
                                  20, 37, 23, 10, 12, 19, 10, 6, 6, 38, 25, 33,
                                  25, 23, 21, 31, 23, 31, 27, 25, 20, 49, 41,
                                  36, 32, 39, 15, 6, 4, 4, 72, 56, 28, 64, 67,
                                  14, 2, 73, 65, 2, 38, 25, 4, 67, 17, 5, 5, 67,
                                  66, 62, 0, 8, 13, 15, 14, 9, 23, 27, 12, 24,
                                  28, 40, 65, 5, 71, 3, 33, 71, 74, 70, 5, 6,
                                  69, 79, 70, 83, 69, 72, 90, 15, 14, 34, 5, 67,
                                  14, 8, 0, 7, 6, 1, 78, 0, 65, 69, 67, 18, 102,
                                  85, 16, 89, 70, 77, 71, 9, 77, 80, 4, 4, 97,
                                  75, 104, 12, 15, 21, 66, 77, 74, 77, 83, 87,
                                  96, 99, 99, 113, 106, 105, 126, 126, 126, 126,
                                  123, 121, 113, 108, 119, 104, 110, 106, 91,
                                  98, 78, 81, 83, 84, 105, 96, 96, 118, 102,
                                  110, 111, 126, 113, 117, 119, 84, 82, 123, 88,
                                  91, 102, 119, 106, 114, 115, 96, 114, 104,
                                  106, 117, 113, 116, 107, 112, 117, 70, 0, 16,
                                  3, 34, 44, 1, 10, 19, 23, 5, 21, 39, 4, 65,
                                  22, 83, 117, 126, 126, 126, 126, 126, 126, 7,
                                  39, 30, 27, 17, 33, 18, 10, 8, 2, 72, 67, 12,
                                  3, 27, 37, 2, 5, 12, 16, 6, 14, 30, 6, 64, 22,
                                  83, 117, 126, 126, 126, 126, 126, 126 },

                                {

                                17,
                                  3, 83, 17, 3, 83, 22, 30, 29, 13, 72, 92, 104,
                                  14, 61, 10, 34, 71, 11, 24, 67, 77, 3, 84,
                                  113, 80, 122, 126, 126, 126, 62, 8, 0, 11, 24,
                                  67, 87, 13, 11, 67, 1, 66, 65, 65, 81, 77, 90,
                                  4, 64, 66, 4, 71, 64, 79, 1, 73, 73, 79, 7, 2,
                                  22, 0, 0, 0, 8, 98, 97, 13, 80, 71, 9, 72, 86,
                                  56, 28, 20, 62, 62, 35, 37, 27, 38, 18, 17,
                                  47, 80, 73, 72, 79, 24, 65, 25, 44, 66, 67, 0,
                                  31, 64, 77, 76, 85, 20, 68, 11, 3, 0, 12, 2,
                                  14, 12, 13, 24, 32, 16, 13, 17, 62, 62, 62,
                                  62, 10, 1, 5, 16, 65, 12, 15, 7, 64, 49, 65,
                                  118, 113, 62, 9, 18, 5, 7, 12, 21, 56, 32, 14,
                                  67, 0, 2, 22, 27, 110, 5, 5, 82, 68, 80, 4, 5,
                                  74, 19, 12, 11, 96, 10, 83, 78, 2, 89, 6, 5,
                                  2, 90, 116, 70, 85, 85, 91, 104, 101, 86, 126,
                                  62, 126, 97, 98, 108, 126, 110, 125, 126, 126,
                                  126, 105, 126, 99, 62, 118, 76, 74, 82, 88,
                                  89, 86, 91, 90, 90, 107, 107, 101, 103, 104,
                                  126, 75, 78, 101, 77, 86, 87, 94, 97, 103,
                                  100, 108, 103, 87, 105, 106, 97, 85, 22, 38,
                                  24, 10, 13, 20, 11, 7, 7, 41, 27, 34, 26, 24,
                                  22, 32, 25, 33, 29, 27, 21, 50, 42, 37, 33,
                                  40, 16, 7, 5, 5, 72, 57, 28, 64, 67, 15, 3,
                                  73, 64, 2, 38, 25, 3, 68, 17, 6, 6, 66, 65,
                                  62, 2, 10, 15, 17, 16, 11, 25, 29, 14, 26, 30,
                                  43, 64, 6, 70, 5, 35, 70, 73, 69, 6, 7, 68,
                                  79, 70, 83, 69, 72, 90, 16, 15, 35, 6, 67, 15,
                                  9, 0, 8, 7, 1, 78, 1, 64, 68, 66, 19, 102, 86,
                                  16, 90, 70, 77, 71, 9, 77, 80, 4, 4, 98, 75,
                                  105, 11, 14, 21, 67, 78, 76, 79, 85, 89, 98,
                                  101, 101, 116, 108, 107, 126, 126, 126, 126,
                                  126, 124, 115, 110, 121, 105, 111, 107, 91,
                                  98, 80, 83, 85, 86, 107, 98, 98, 121, 104,
                                  112, 113, 126, 114, 118, 120, 84, 82, 124, 89,
                                  92, 103, 121, 107, 115, 116, 97, 115, 105,
                                  106, 118, 113, 116, 108, 113, 118, 69, 1, 17,
                                  4, 36, 46, 2, 11, 20, 24, 6, 22, 40, 4, 65,
                                  21, 85, 119, 126, 126, 126, 126, 126, 126, 8,
                                  39, 31, 28, 18, 34, 19, 11, 9, 3, 71, 66, 13,
                                  4, 28, 38, 3, 6, 13, 17, 6, 15, 31, 6, 64, 21,
                                  85, 119, 126, 126, 126, 126, 126, 126 },

                                {

                                16,
                                  3, 83, 16, 3, 83, 24, 31, 29, 13, 72, 93, 106,
                                  13, 61, 10, 36, 71, 11, 25, 67, 78, 3, 85,
                                  115, 81, 125, 126, 126, 126, 62, 9, 0, 11, 25,
                                  67, 87, 14, 11, 68, 1, 66, 64, 65, 81, 77, 90,
                                  4, 64, 66, 4, 71, 64, 79, 1, 73, 73, 79, 7, 2,
                                  22, 0, 0, 0, 9, 98, 97, 13, 81, 71, 8, 72, 86,
                                  58, 29, 21, 62, 62, 36, 38, 29, 39, 19, 18,
                                  49, 80, 73, 72, 79, 24, 65, 26, 46, 66, 66, 1,
                                  33, 64, 77, 76, 86, 20, 68, 11, 4, 1, 13, 3,
                                  15, 12, 14, 25, 33, 17, 14, 18, 62, 62, 62,
                                  62, 10, 1, 5, 16, 65, 12, 15, 7, 64, 51, 65,
                                  120, 115, 62, 9, 18, 5, 7, 12, 21, 58, 33, 14,
                                  67, 0, 2, 23, 28, 111, 5, 5, 82, 69, 81, 3, 5,
                                  75, 19, 12, 11, 97, 10, 84, 79, 1, 89, 6, 4,
                                  1, 92, 119, 71, 87, 87, 93, 106, 103, 88, 126,
                                  62, 126, 99, 100, 110, 126, 112, 126, 126,
                                  126, 126, 107, 126, 101, 62, 120, 78, 76, 84,
                                  90, 91, 88, 93, 92, 92, 109, 109, 103, 105,
                                  106, 126, 75, 78, 102, 78, 87, 88, 95, 98,
                                  104, 101, 110, 104, 87, 106, 107, 98, 84, 23,
                                  39, 24, 10, 13, 21, 12, 8, 8, 43, 28, 34, 26,
                                  24, 23, 33, 26, 35, 31, 29, 22, 51, 43, 38,
                                  34, 41, 16, 7, 5, 6, 72, 58, 28, 65, 67, 15,
                                  3, 73, 64, 2, 38, 24, 2, 69, 17, 6, 6, 66, 65,
                                  62, 3, 11, 16, 19, 18, 12, 27, 31, 15, 28, 32,
                                  45, 0, 7, 70, 6, 37, 70, 73, 69, 7, 7, 68, 79,
                                  70, 84, 69, 72, 90, 16, 15, 36, 6, 67, 15, 9,
                                  0, 8, 7, 1, 79, 1, 64, 68, 66, 20, 103, 87,
                                  16, 91, 71, 78, 72, 9, 78, 81, 4, 4, 99, 75,
                                  106, 10, 13, 20, 69, 80, 78, 81, 87, 91, 101,
                                  104, 104, 119, 111, 109, 126, 126, 126, 126,
                                  126, 126, 118, 112, 124, 107, 113, 108, 92,
                                  99, 82, 85, 88, 88, 110, 101, 101, 124, 106,
                                  115, 115, 126, 116, 120, 122, 85, 83, 126, 90,
                                  93, 105, 123, 109, 117, 118, 98, 117, 106,
                                  107, 119, 114, 117, 110, 114, 119, 69, 1, 18,
                                  4, 37, 47, 2, 12, 21, 25, 6, 22, 41, 4, 65,
                                  20, 87, 122, 126, 126, 126, 126, 126, 126, 8,
                                  39, 31, 28, 18, 35, 19, 11, 9, 3, 71, 66, 13,
                                  4, 29, 39, 3, 6, 13, 17, 6, 15, 32, 6, 64, 20,
                                  87, 122, 126, 126, 126, 126, 126, 126 },

                                {

                                15,
                                  3, 83, 15, 3, 83, 26, 33, 30, 13, 73, 95, 108,
                                  12, 61, 10, 38, 71, 12, 26, 67, 78, 3, 85,
                                  116, 82, 126, 126, 126, 126, 62, 10, 0, 12,
                                  26, 67, 88, 15, 11, 68, 1, 66, 64, 65, 81, 77,
                                  90, 4, 64, 65, 4, 71, 0, 79, 1, 73, 73, 79, 7,
                                  2, 22, 0, 0, 0, 9, 98, 97, 14, 82, 71, 7, 73,
                                  86, 61, 30, 22, 62, 62, 38, 40, 31, 41, 20,
                                  19, 51, 80, 73, 71, 79, 24, 65, 27, 48, 66,
                                  65, 1, 35, 64, 78, 77, 86, 20, 68, 12, 4, 2,
                                  14, 3, 16, 13, 15, 27, 35, 17, 15, 19, 62, 62,
                                  62, 62, 10, 1, 5, 17, 65, 12, 16, 8, 0, 53,
                                  65, 122, 117, 62, 9, 18, 5, 7, 12, 22, 59, 34,
                                  14, 67, 0, 2, 23, 29, 112, 5, 5, 83, 69, 82,
                                  3, 5, 75, 19, 12, 11, 98, 10, 85, 80, 1, 89,
                                  6, 4, 1, 94, 122, 72, 89, 89, 96, 108, 106,
                                  90, 126, 62, 126, 101, 102, 112, 126, 115,
                                  126, 126, 126, 126, 109, 126, 103, 62, 122,
                                  80, 78, 86, 93, 94, 90, 95, 94, 94, 111, 111,
                                  105, 107, 107, 126, 75, 78, 102, 79, 88, 89,
                                  96, 99, 105, 102, 112, 105, 88, 107, 108, 98,
                                  84, 25, 40, 25, 10, 13, 22, 12, 8, 8, 45, 29,
                                  34, 26, 25, 24, 34, 27, 36, 32, 31, 23, 51,
                                  43, 38, 34, 42, 17, 7, 5, 6, 72, 58, 28, 66,
                                  67, 15, 3, 73, 0, 2, 37, 24, 1, 70, 17, 6, 6,
                                  66, 65, 62, 4, 13, 17, 20, 19, 13, 29, 33, 16,
                                  29, 34, 47, 0, 8, 69, 7, 39, 69, 73, 69, 7, 8,
                                  68, 79, 70, 84, 69, 72, 91, 17, 16, 37, 6, 67,
                                  16, 9, 0, 8, 7, 1, 79, 1, 64, 68, 66, 20, 104,
                                  88, 16, 92, 72, 79, 72, 9, 79, 82, 4, 4, 100,
                                  75, 107, 9, 12, 19, 70, 82, 80, 83, 89, 94,
                                  103, 107, 107, 122, 113, 111, 126, 126, 126,
                                  126, 126, 126, 120, 114, 126, 109, 115, 110,
                                  93, 100, 84, 88, 90, 91, 113, 103, 103, 126,
                                  109, 117, 118, 126, 118, 122, 123, 86, 84,
                                  126, 92, 95, 107, 125, 110, 119, 120, 99, 118,
                                  107, 108, 120, 115, 118, 111, 115, 120, 69, 2,
                                  18, 5, 38, 48, 2, 12, 21, 25, 6, 23, 42, 4,
                                  65, 19, 89, 124, 126, 126, 126, 126, 126, 126,
                                  8, 39, 31, 28, 18, 35, 20, 11, 9, 4, 71, 66,
                                  14, 5, 30, 40, 3, 7, 13, 17, 6, 15, 32, 6, 64,
                                  19, 89, 124, 126, 126, 126, 126, 126, 126 },

                          },

                          {

                              {

                              62,
                                9, 74, 62, 9, 74, 126, 104, 10, 9, 12, 47, 62,
                                62, 12, 1, 99, 47, 85, 102, 6, 6, 73, 6, 23, 53,
                                62, 62, 21, 97, 126, 117, 74, 85, 102, 6, 93,
                                88, 19, 8, 89, 103, 116, 6, 5, 84, 96, 0, 85,
                                106, 0, 75, 90, 101, 8, 79, 75, 97, 13, 3, 22,
                                0, 0, 0, 83, 86, 97, 72, 22, 1, 29, 88, 126,
                                126, 91, 95, 84, 86, 89, 91, 126, 76, 103, 90,
                                126, 80, 76, 84, 78, 8, 2, 83, 126, 79, 104, 91,
                                126, 65, 79, 72, 92, 7, 68, 71, 98, 86, 88, 82,
                                72, 67, 72, 89, 69, 4, 66, 6, 71, 71, 5, 74, 19,
                                69, 1, 12, 16, 21, 22, 10, 76, 78, 83, 11, 67,
                                90, 67, 72, 75, 80, 83, 64, 32, 64, 94, 75, 0,
                                74, 28, 36, 91, 65, 69, 77, 66, 1, 68, 81, 33,
                                56, 40, 74, 66, 124, 26, 62, 62, 126, 24, 21,
                                29, 34, 32, 26, 21, 23, 30, 20, 27, 16, 8, 5, 3,
                                19, 19, 21, 15, 7, 11, 26, 14, 5, 15, 18, 69,
                                30, 0, 62, 62, 62, 53, 62, 62, 62, 62, 46, 38,
                                34, 30, 48, 43, 73, 29, 32, 19, 47, 27, 27, 35,
                                42, 43, 51, 47, 21, 93, 7, 6, 25, 126, 115, 82,
                                1, 10, 4, 85, 89, 94, 92, 126, 100, 6, 67, 71,
                                77, 85, 88, 104, 98, 126, 82, 15, 2, 66, 70, 75,
                                79, 83, 92, 108, 79, 69, 75, 5, 5, 78, 83, 81,
                                99, 81, 25, 1, 5, 4, 73, 76, 86, 83, 87, 62,
                                126, 126, 120, 126, 114, 117, 118, 117, 113,
                                118, 120, 124, 94, 102, 99, 106, 126, 92, 6, 86,
                                94, 91, 77, 71, 73, 64, 81, 64, 6, 67, 68, 67,
                                68, 77, 64, 68, 78, 8, 4, 65, 9, 19, 3, 70, 76,
                                86, 70, 64, 70, 8, 7, 69, 65, 74, 9, 9, 76, 82,
                                77, 77, 21, 62, 62, 62, 62, 62, 62, 62, 62, 62,
                                62, 62, 62, 62, 62, 52, 62, 62, 62, 62, 62, 62,
                                48, 62, 62, 46, 25, 18, 9, 79, 62, 62, 62, 62,
                                48, 48, 38, 41, 47, 45, 35, 22, 35, 16, 1, 32,
                                37, 39, 40, 47, 33, 34, 22, 21, 3, 11, 3, 78,
                                123, 10, 7, 2, 30, 13, 2, 78, 74, 72, 72, 75,
                                71, 0, 70, 75, 72, 67, 10, 4, 11, 68, 62, 62,
                                62, 62, 56, 51, 40, 25, 64, 71, 26, 19, 14, 7,
                                4, 0, 67, 68, 79, 78, 74, 72, 72, 75, 71, 0, 70,
                                75, 72, 67, 10, 4, 11, 68, 62, 62, 62, 62, 56,
                                51, 40, 25, 64 },

                                {

                                62,
                                  9, 74, 62, 9, 74, 125, 102, 11, 10, 12, 46,
                                  62, 62, 13, 2, 97, 46, 84, 100, 6, 6, 71, 6,
                                  22, 52, 62, 60, 19, 97, 125, 115, 73, 84, 100,
                                  6, 92, 87, 20, 8, 88, 102, 114, 5, 4, 84, 96,
                                  0, 84, 105, 0, 75, 89, 100, 8, 78, 74, 96, 14,
                                  3, 22, 0, 0, 0, 82, 86, 97, 71, 22, 1, 29, 87,
                                  125, 124, 89, 94, 82, 84, 88, 89, 125, 75,
                                  101, 89, 124, 80, 76, 84, 78, 9, 2, 82, 124,
                                  78, 103, 90, 125, 65, 78, 72, 91, 8, 68, 70,
                                  97, 85, 87, 81, 71, 66, 71, 88, 68, 5, 66, 6,
                                  70, 70, 5, 73, 20, 68, 1, 13, 17, 22, 23, 11,
                                  76, 77, 82, 11, 67, 89, 67, 71, 74, 79, 81, 1,
                                  33, 1, 92, 75, 64, 73, 29, 37, 91, 65, 68, 77,
                                  65, 1, 67, 79, 33, 56, 41, 72, 67, 122, 25,
                                  62, 62, 125, 24, 21, 29, 34, 32, 26, 21, 23,
                                  30, 20, 27, 16, 8, 5, 3, 19, 19, 21, 15, 7,
                                  11, 26, 14, 4, 15, 18, 69, 29, 0, 62, 62, 62,
                                  52, 62, 62, 62, 62, 45, 37, 32, 29, 46, 42,
                                  74, 28, 31, 18, 46, 27, 27, 34, 41, 42, 50,
                                  46, 20, 93, 7, 6, 24, 125, 113, 80, 2, 10, 4,
                                  84, 88, 93, 91, 125, 98, 7, 66, 70, 76, 83,
                                  87, 102, 97, 124, 81, 16, 3, 65, 69, 74, 78,
                                  82, 91, 106, 78, 67, 74, 6, 5, 77, 82, 80, 98,
                                  80, 26, 2, 6, 5, 72, 75, 85, 82, 86, 62, 125,
                                  125, 118, 125, 112, 115, 116, 115, 111, 116,
                                  118, 121, 93, 101, 98, 105, 123, 91, 5, 85,
                                  93, 90, 76, 71, 72, 64, 80, 64, 6, 67, 68, 66,
                                  68, 77, 64, 68, 77, 8, 4, 65, 9, 19, 3, 70,
                                  75, 84, 70, 64, 69, 8, 7, 69, 65, 73, 9, 9,
                                  75, 81, 76, 76, 20, 62, 62, 62, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 50, 62, 62,
                                  62, 62, 62, 62, 47, 60, 60, 45, 24, 17, 9, 79,
                                  62, 62, 62, 60, 46, 47, 37, 39, 46, 43, 34,
                                  20, 33, 15, 0, 31, 36, 37, 39, 46, 32, 33, 21,
                                  20, 2, 11, 3, 78, 122, 9, 6, 1, 29, 12, 1, 77,
                                  73, 71, 71, 73, 70, 1, 69, 73, 71, 66, 11, 5,
                                  12, 67, 62, 62, 62, 62, 54, 50, 38, 24, 65,
                                  70, 27, 20, 15, 8, 5, 1, 66, 67, 78, 77, 73,
                                  71, 71, 73, 70, 1, 69, 73, 71, 66, 11, 5, 12,
                                  67, 62, 62, 62, 62, 54, 50, 38, 24, 65 },

                                {

                                62,
                                  9, 74, 62, 9, 74, 123, 101, 11, 10, 12, 44,
                                  60, 62, 14, 2, 95, 44, 84, 99, 6, 6, 70, 5,
                                  21, 51, 60, 57, 17, 98, 123, 114, 73, 84, 99,
                                  6, 92, 86, 20, 8, 87, 101, 113, 4, 3, 84, 96,
                                  0, 84, 104, 0, 75, 89, 100, 8, 78, 74, 95, 14,
                                  3, 22, 0, 0, 0, 81, 86, 97, 71, 21, 1, 29, 86,
                                  124, 122, 88, 93, 80, 82, 87, 88, 123, 74,
                                  100, 88, 122, 81, 76, 84, 78, 9, 2, 81, 122,
                                  78, 102, 89, 123, 65, 78, 72, 91, 8, 68, 70,
                                  96, 85, 86, 81, 71, 66, 71, 87, 67, 5, 66, 6,
                                  70, 70, 5, 73, 20, 68, 1, 13, 17, 22, 23, 11,
                                  77, 76, 81, 10, 67, 89, 67, 70, 74, 79, 80, 2,
                                  34, 3, 90, 76, 65, 73, 29, 37, 92, 65, 68, 78,
                                  64, 1, 67, 78, 33, 56, 41, 71, 68, 121, 24,
                                  62, 62, 124, 24, 21, 29, 33, 31, 26, 21, 23,
                                  29, 19, 26, 16, 8, 5, 3, 18, 18, 20, 15, 7,
                                  11, 25, 13, 3, 14, 17, 69, 28, 64, 62, 62, 62,
                                  50, 60, 62, 62, 62, 44, 35, 30, 27, 44, 40,
                                  75, 27, 30, 16, 45, 26, 26, 33, 39, 40, 48,
                                  44, 18, 93, 6, 5, 22, 124, 112, 79, 3, 10, 4,
                                  83, 87, 92, 90, 123, 97, 8, 65, 69, 75, 82,
                                  86, 101, 96, 122, 80, 16, 3, 65, 69, 73, 77,
                                  81, 90, 105, 78, 66, 73, 6, 5, 76, 81, 80, 97,
                                  79, 26, 3, 6, 5, 71, 74, 84, 81, 85, 62, 124,
                                  123, 116, 123, 111, 114, 114, 113, 110, 114,
                                  116, 119, 92, 100, 97, 104, 120, 91, 4, 85,
                                  92, 89, 76, 71, 72, 64, 80, 64, 5, 67, 68, 65,
                                  68, 77, 64, 68, 77, 8, 4, 65, 8, 18, 3, 70,
                                  75, 83, 71, 64, 68, 7, 7, 69, 65, 73, 9, 9,
                                  75, 80, 76, 76, 18, 62, 62, 62, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 48, 62, 62,
                                  62, 62, 62, 61, 45, 58, 58, 43, 23, 16, 8, 79,
                                  62, 62, 62, 58, 44, 45, 35, 37, 44, 41, 32,
                                  18, 31, 13, 64, 30, 35, 35, 37, 44, 30, 31,
                                  20, 19, 1, 10, 2, 78, 121, 8, 5, 64, 28, 11,
                                  0, 77, 73, 70, 70, 72, 69, 2, 69, 72, 70, 65,
                                  11, 6, 13, 66, 62, 62, 62, 60, 52, 48, 36, 22,
                                  66, 69, 27, 20, 16, 9, 6, 1, 65, 67, 77, 77,
                                  73, 70, 70, 72, 69, 2, 69, 72, 70, 65, 11, 6,
                                  13, 66, 62, 62, 62, 60, 52, 48, 36, 22, 66 },

                                {

                                62,
                                  9, 74, 62, 9, 74, 121, 99, 12, 10, 11, 42, 59,
                                  61, 14, 2, 93, 43, 84, 97, 6, 5, 69, 4, 20,
                                  50, 58, 53, 15, 99, 121, 112, 73, 84, 97, 6,
                                  91, 85, 21, 8, 86, 100, 112, 3, 2, 84, 97, 0,
                                  84, 103, 0, 76, 89, 100, 8, 78, 74, 94, 15, 3,
                                  22, 0, 0, 0, 81, 86, 97, 70, 20, 1, 28, 86,
                                  123, 120, 87, 92, 79, 81, 86, 87, 121, 73, 99,
                                  87, 120, 82, 76, 84, 78, 10, 2, 80, 120, 78,
                                  101, 88, 121, 65, 78, 72, 91, 9, 68, 69, 95,
                                  85, 85, 81, 71, 66, 70, 86, 67, 5, 66, 6, 70,
                                  70, 5, 73, 20, 68, 1, 14, 17, 23, 23, 12, 77,
                                  76, 80, 10, 67, 89, 67, 69, 74, 78, 79, 3, 35,
                                  4, 88, 76, 66, 72, 29, 37, 93, 65, 67, 78, 64,
                                  1, 67, 77, 33, 56, 41, 70, 69, 119, 23, 62,
                                  62, 122, 24, 21, 28, 32, 31, 25, 20, 23, 29,
                                  18, 25, 16, 8, 5, 2, 18, 17, 19, 14, 7, 11,
                                  24, 13, 2, 14, 16, 69, 27, 64, 62, 62, 61, 49,
                                  58, 62, 62, 62, 43, 33, 28, 26, 42, 38, 77,
                                  26, 29, 14, 44, 25, 25, 32, 38, 38, 46, 42,
                                  17, 93, 5, 4, 21, 122, 110, 77, 3, 10, 4, 82,
                                  86, 91, 89, 121, 96, 9, 64, 68, 75, 81, 85,
                                  99, 95, 120, 80, 17, 4, 64, 68, 72, 77, 81,
                                  89, 104, 78, 64, 72, 6, 5, 75, 81, 80, 96, 78,
                                  27, 4, 7, 5, 70, 74, 83, 81, 85, 62, 122, 122,
                                  115, 121, 110, 112, 113, 112, 108, 112, 114,
                                  117, 92, 99, 97, 103, 117, 91, 3, 85, 91, 88,
                                  76, 71, 72, 64, 79, 64, 4, 67, 68, 65, 68, 77,
                                  64, 68, 77, 7, 4, 65, 7, 17, 3, 70, 75, 82,
                                  72, 64, 67, 6, 7, 69, 65, 72, 9, 8, 74, 79,
                                  76, 76, 17, 62, 62, 62, 62, 62, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 46, 62, 62, 62, 62,
                                  62, 59, 43, 56, 55, 41, 22, 15, 7, 79, 62, 62,
                                  62, 56, 42, 43, 34, 35, 42, 39, 30, 16, 29,
                                  11, 65, 29, 34, 33, 36, 42, 29, 29, 18, 17, 0,
                                  9, 1, 78, 120, 7, 3, 65, 27, 10, 64, 77, 72,
                                  70, 70, 71, 68, 3, 69, 71, 69, 64, 12, 7, 13,
                                  65, 62, 62, 62, 58, 50, 46, 34, 20, 67, 69,
                                  28, 21, 17, 9, 7, 2, 65, 66, 77, 77, 72, 70,
                                  70, 71, 68, 3, 69, 71, 69, 64, 12, 7, 13, 65,
                                  62, 62, 62, 58, 50, 46, 34, 20, 67 },

                                {

                                62,
                                  9, 74, 62, 9, 74, 120, 98, 12, 10, 11, 40, 57,
                                  60, 15, 2, 92, 41, 84, 96, 5, 5, 68, 3, 18,
                                  48, 56, 50, 12, 100, 119, 111, 73, 84, 96, 5,
                                  91, 84, 21, 7, 86, 99, 110, 2, 0, 85, 97, 0,
                                  83, 102, 64, 76, 89, 100, 8, 78, 74, 94, 15,
                                  3, 22, 0, 0, 0, 80, 87, 97, 70, 19, 1, 28, 85,
                                  122, 118, 86, 91, 77, 79, 86, 86, 119, 72, 98,
                                  86, 117, 82, 77, 84, 79, 10, 1, 79, 117, 77,
                                  101, 88, 119, 65, 78, 72, 91, 9, 68, 69, 94,
                                  85, 85, 80, 71, 66, 70, 85, 66, 5, 67, 5, 70,
                                  70, 5, 73, 20, 68, 1, 14, 17, 23, 23, 12, 78,
                                  75, 80, 9, 67, 88, 67, 68, 73, 78, 77, 5, 36,
                                  6, 86, 77, 67, 72, 30, 37, 94, 65, 67, 79, 0,
                                  1, 67, 76, 33, 56, 41, 68, 70, 118, 22, 62,
                                  62, 121, 23, 21, 28, 32, 30, 25, 20, 23, 28,
                                  17, 24, 15, 8, 5, 2, 17, 17, 18, 14, 6, 10,
                                  23, 12, 1, 13, 15, 69, 25, 65, 62, 62, 59, 47,
                                  57, 62, 62, 62, 42, 31, 25, 24, 40, 36, 78,
                                  24, 28, 13, 43, 24, 24, 30, 36, 36, 44, 41,
                                  15, 93, 4, 3, 19, 121, 109, 76, 4, 10, 4, 81,
                                  85, 90, 89, 119, 94, 10, 64, 68, 74, 79, 84,
                                  98, 94, 117, 79, 17, 4, 64, 68, 71, 76, 80,
                                  89, 103, 78, 0, 71, 6, 5, 74, 80, 80, 95, 77,
                                  27, 5, 7, 5, 69, 73, 82, 80, 84, 62, 121, 120,
                                  113, 120, 109, 111, 111, 110, 107, 111, 112,
                                  114, 91, 98, 96, 102, 114, 90, 2, 84, 90, 88,
                                  76, 71, 72, 65, 79, 65, 3, 67, 68, 64, 68, 77,
                                  64, 68, 76, 7, 3, 65, 6, 16, 2, 70, 75, 81,
                                  73, 65, 67, 6, 6, 69, 65, 72, 8, 8, 74, 79,
                                  76, 76, 15, 62, 62, 62, 62, 62, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 44, 62, 62, 62, 62,
                                  62, 57, 41, 54, 53, 39, 20, 14, 6, 79, 62, 62,
                                  62, 54, 40, 41, 32, 33, 40, 37, 28, 14, 26,
                                  10, 67, 28, 33, 30, 34, 41, 27, 27, 17, 16,
                                  64, 8, 0, 78, 119, 5, 2, 67, 25, 9, 65, 77,
                                  72, 69, 69, 70, 68, 3, 68, 70, 68, 0, 12, 8,
                                  14, 65, 62, 62, 60, 56, 48, 44, 31, 18, 69,
                                  68, 28, 21, 17, 10, 7, 2, 64, 66, 76, 77, 72,
                                  69, 69, 70, 68, 3, 68, 70, 68, 0, 12, 8, 14,
                                  65, 62, 62, 60, 56, 48, 44, 31, 18, 69 },

                                {

                                62,
                                  9, 74, 62, 9, 74, 118, 96, 12, 10, 10, 38, 56,
                                  59, 16, 2, 90, 39, 83, 94, 5, 5, 67, 2, 17,
                                  47, 54, 47, 10, 100, 117, 110, 73, 83, 94, 5,
                                  91, 83, 21, 7, 85, 98, 109, 1, 64, 85, 97, 0,
                                  83, 101, 64, 76, 89, 100, 8, 77, 74, 93, 16,
                                  3, 22, 0, 0, 0, 80, 87, 97, 69, 18, 1, 27, 85,
                                  120, 115, 85, 90, 76, 78, 85, 85, 117, 71, 97,
                                  85, 115, 83, 77, 84, 79, 10, 1, 78, 115, 77,
                                  100, 87, 117, 65, 78, 72, 90, 9, 68, 68, 93,
                                  84, 84, 80, 71, 65, 69, 84, 66, 5, 67, 5, 69,
                                  70, 5, 73, 21, 68, 1, 15, 18, 23, 23, 12, 78,
                                  75, 79, 9, 67, 88, 67, 67, 73, 77, 76, 6, 37,
                                  7, 84, 77, 68, 71, 30, 37, 95, 65, 66, 79, 1,
                                  1, 67, 74, 33, 56, 41, 67, 71, 116, 21, 62,
                                  62, 120, 23, 21, 27, 31, 30, 25, 19, 23, 28,
                                  16, 23, 15, 8, 5, 2, 17, 16, 17, 13, 6, 10,
                                  22, 12, 0, 12, 15, 69, 24, 65, 62, 62, 58, 46,
                                  55, 62, 62, 62, 41, 29, 23, 23, 38, 34, 79,
                                  23, 27, 11, 42, 23, 23, 29, 35, 34, 42, 39,
                                  14, 93, 3, 2, 17, 119, 107, 75, 4, 10, 4, 80,
                                  84, 89, 88, 117, 93, 11, 0, 67, 73, 78, 83,
                                  96, 93, 115, 78, 18, 5, 0, 67, 70, 75, 80, 88,
                                  102, 77, 1, 70, 6, 5, 73, 80, 79, 94, 76, 27,
                                  6, 7, 5, 68, 72, 81, 80, 83, 62, 120, 119,
                                  112, 118, 108, 109, 110, 108, 105, 109, 110,
                                  112, 90, 97, 95, 101, 111, 90, 1, 84, 89, 87,
                                  76, 71, 72, 65, 78, 65, 2, 67, 68, 0, 68, 77,
                                  64, 68, 76, 6, 3, 65, 5, 15, 2, 70, 75, 80,
                                  73, 65, 66, 5, 6, 69, 65, 72, 8, 7, 74, 78,
                                  76, 76, 14, 62, 62, 62, 62, 62, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 42, 62, 62, 62, 62,
                                  62, 55, 40, 52, 50, 37, 19, 13, 5, 79, 62, 62,
                                  62, 52, 38, 39, 31, 31, 38, 35, 26, 12, 24, 8,
                                  68, 27, 32, 28, 33, 39, 26, 25, 16, 15, 65, 7,
                                  64, 78, 118, 4, 1, 68, 24, 8, 66, 77, 71, 69,
                                  68, 69, 67, 4, 68, 69, 67, 1, 13, 9, 14, 64,
                                  62, 62, 58, 54, 46, 42, 29, 16, 70, 68, 29,
                                  22, 18, 11, 8, 3, 64, 66, 75, 77, 71, 69, 68,
                                  69, 67, 4, 68, 69, 67, 1, 13, 9, 14, 64, 62,
                                  62, 58, 54, 46, 42, 29, 16, 70 },

                                {

                                62,
                                  9, 75, 62, 9, 75, 116, 95, 13, 10, 10, 37, 54,
                                  58, 16, 3, 88, 38, 83, 93, 5, 4, 66, 1, 16,
                                  46, 53, 43, 8, 101, 115, 108, 73, 83, 93, 5,
                                  90, 82, 22, 7, 84, 97, 108, 64, 65, 85, 98, 0,
                                  83, 101, 64, 77, 88, 100, 7, 77, 74, 92, 16,
                                  3, 22, 0, 0, 0, 79, 87, 97, 69, 18, 0, 27, 84,
                                  119, 113, 84, 89, 74, 76, 84, 84, 115, 70, 96,
                                  85, 113, 84, 77, 84, 79, 11, 1, 77, 113, 77,
                                  99, 86, 115, 65, 78, 72, 90, 10, 69, 68, 93,
                                  84, 83, 80, 70, 65, 69, 83, 65, 5, 67, 5, 69,
                                  70, 5, 73, 21, 68, 1, 15, 18, 24, 24, 13, 79,
                                  74, 78, 8, 67, 88, 67, 66, 73, 77, 75, 7, 37,
                                  9, 83, 78, 69, 71, 30, 37, 95, 66, 66, 80, 1,
                                  0, 66, 73, 33, 56, 42, 66, 72, 115, 20, 62,
                                  62, 118, 23, 21, 27, 30, 29, 24, 19, 22, 27,
                                  16, 23, 15, 7, 5, 1, 16, 15, 16, 13, 6, 10,
                                  22, 11, 65, 12, 14, 69, 23, 66, 62, 62, 56,
                                  44, 53, 62, 62, 62, 39, 27, 21, 21, 36, 32,
                                  81, 22, 25, 9, 40, 22, 22, 28, 33, 32, 40, 37,
                                  12, 93, 2, 1, 16, 118, 106, 73, 5, 10, 4, 79,
                                  84, 89, 87, 116, 92, 12, 1, 66, 73, 77, 82,
                                  95, 92, 113, 78, 18, 5, 0, 67, 69, 75, 79, 87,
                                  101, 77, 3, 69, 6, 5, 73, 79, 79, 94, 76, 28,
                                  6, 8, 5, 67, 72, 81, 79, 83, 62, 118, 117,
                                  110, 116, 106, 108, 108, 107, 104, 107, 108,
                                  110, 90, 96, 95, 101, 108, 90, 0, 84, 89, 86,
                                  76, 71, 72, 65, 78, 65, 1, 67, 68, 0, 68, 77,
                                  64, 68, 76, 6, 3, 65, 4, 14, 2, 70, 75, 79,
                                  74, 65, 65, 4, 6, 69, 65, 71, 8, 7, 73, 77,
                                  76, 76, 12, 62, 62, 62, 62, 62, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 40, 62, 62, 62, 62,
                                  62, 52, 38, 50, 48, 35, 18, 12, 4, 79, 62, 62,
                                  62, 50, 36, 38, 29, 29, 36, 32, 24, 10, 22, 6,
                                  69, 26, 30, 26, 31, 37, 24, 23, 14, 13, 66, 6,
                                  65, 79, 117, 3, 64, 70, 23, 6, 67, 76, 71, 68,
                                  68, 68, 66, 5, 68, 68, 66, 2, 13, 10, 15, 0,
                                  62, 62, 56, 52, 44, 40, 27, 14, 71, 67, 29,
                                  22, 19, 11, 9, 3, 0, 65, 75, 76, 71, 68, 68,
                                  68, 66, 5, 68, 68, 66, 2, 13, 10, 15, 0, 62,
                                  62, 56, 52, 44, 40, 27, 14, 71 },

                                {

                                62,
                                  9, 75, 62, 9, 75, 114, 93, 13, 10, 9, 35, 53,
                                  57, 17, 3, 87, 36, 83, 91, 4, 4, 65, 0, 15,
                                  45, 51, 40, 5, 102, 113, 107, 73, 83, 91, 4,
                                  90, 81, 22, 7, 84, 96, 106, 65, 66, 85, 98, 0,
                                  82, 100, 65, 77, 88, 100, 7, 77, 74, 91, 17,
                                  3, 22, 0, 0, 0, 79, 87, 97, 68, 17, 0, 26, 84,
                                  118, 111, 83, 88, 73, 75, 83, 83, 113, 69, 95,
                                  84, 110, 84, 78, 84, 80, 11, 1, 76, 110, 76,
                                  99, 86, 113, 65, 78, 72, 90, 10, 69, 67, 92,
                                  84, 82, 79, 70, 65, 68, 82, 65, 5, 68, 5, 69,
                                  70, 5, 73, 21, 68, 1, 16, 18, 24, 24, 13, 79,
                                  74, 78, 8, 67, 87, 67, 65, 72, 76, 73, 9, 38,
                                  10, 81, 78, 70, 70, 31, 37, 96, 66, 65, 80, 2,
                                  0, 66, 72, 33, 56, 42, 64, 73, 113, 19, 62,
                                  62, 117, 23, 21, 26, 30, 29, 24, 18, 22, 27,
                                  15, 22, 15, 7, 5, 1, 16, 15, 15, 12, 6, 10,
                                  21, 11, 66, 11, 13, 69, 22, 66, 62, 62, 54,
                                  43, 52, 62, 62, 62, 38, 25, 19, 20, 34, 30,
                                  82, 21, 24, 8, 39, 21, 21, 26, 32, 30, 38, 36,
                                  11, 93, 1, 0, 14, 116, 104, 72, 5, 10, 4, 78,
                                  83, 88, 87, 114, 90, 13, 2, 66, 72, 75, 81,
                                  93, 91, 110, 77, 19, 6, 1, 66, 68, 74, 79, 86,
                                  100, 77, 4, 68, 6, 5, 72, 79, 79, 93, 75, 28,
                                  7, 8, 5, 66, 71, 80, 79, 82, 62, 117, 116,
                                  109, 115, 105, 106, 107, 105, 102, 105, 106,
                                  107, 89, 95, 94, 100, 105, 89, 64, 83, 88, 85,
                                  76, 71, 72, 65, 77, 66, 0, 67, 68, 1, 68, 77,
                                  64, 68, 75, 5, 2, 65, 3, 13, 1, 70, 75, 78,
                                  75, 66, 64, 4, 5, 69, 65, 71, 7, 6, 73, 77,
                                  76, 76, 11, 62, 62, 62, 62, 62, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 38, 62, 62, 62, 62,
                                  62, 50, 36, 48, 45, 33, 17, 11, 3, 79, 62, 61,
                                  62, 48, 34, 36, 28, 27, 34, 30, 22, 8, 20, 5,
                                  71, 25, 29, 24, 30, 36, 23, 21, 13, 12, 67, 5,
                                  66, 79, 116, 1, 65, 71, 21, 5, 68, 76, 70, 68,
                                  67, 67, 65, 5, 67, 67, 65, 3, 14, 11, 15, 0,
                                  62, 60, 54, 50, 42, 38, 24, 12, 72, 67, 30,
                                  23, 19, 12, 10, 4, 0, 65, 74, 76, 70, 68, 67,
                                  67, 65, 5, 67, 67, 65, 3, 14, 11, 15, 0, 62,
                                  60, 54, 50, 42, 38, 24, 12, 72 },

                                {

                                62,
                                  8, 75, 62, 8, 75, 113, 92, 13, 10, 9, 33, 51,
                                  56, 17, 3, 85, 34, 83, 90, 4, 3, 64, 64, 13,
                                  43, 49, 36, 3, 103, 111, 106, 73, 83, 90, 4,
                                  90, 81, 22, 6, 83, 95, 105, 66, 68, 86, 99, 0,
                                  82, 99, 65, 78, 88, 100, 7, 77, 74, 91, 17, 3,
                                  22, 0, 0, 0, 78, 88, 97, 68, 16, 0, 26, 83,
                                  117, 109, 82, 88, 71, 73, 83, 82, 111, 69, 94,
                                  83, 108, 85, 78, 85, 80, 11, 0, 76, 108, 76,
                                  98, 85, 112, 65, 78, 72, 90, 10, 69, 67, 91,
                                  84, 82, 79, 70, 65, 68, 81, 64, 5, 68, 4, 69,
                                  70, 4, 73, 21, 68, 1, 16, 18, 24, 24, 13, 80,
                                  73, 77, 7, 67, 87, 67, 64, 72, 76, 72, 10, 39,
                                  12, 79, 79, 71, 70, 31, 37, 97, 66, 65, 81, 2,
                                  0, 66, 71, 33, 56, 42, 0, 74, 112, 18, 59, 62,
                                  116, 22, 21, 26, 29, 28, 23, 18, 22, 26, 14,
                                  21, 14, 7, 4, 0, 15, 14, 14, 12, 5, 9, 20, 10,
                                  67, 10, 12, 69, 20, 67, 62, 62, 52, 41, 50,
                                  60, 62, 62, 37, 23, 16, 18, 31, 28, 84, 19,
                                  23, 6, 38, 20, 20, 25, 30, 28, 36, 34, 9, 93,
                                  0, 64, 12, 115, 103, 71, 6, 10, 4, 78, 82, 87,
                                  86, 112, 89, 13, 2, 65, 72, 74, 80, 92, 90,
                                  108, 77, 19, 6, 1, 66, 68, 74, 78, 86, 99, 77,
                                  5, 67, 6, 5, 71, 78, 79, 92, 74, 28, 8, 8, 5,
                                  65, 71, 79, 78, 82, 62, 116, 114, 107, 113,
                                  104, 105, 105, 104, 101, 104, 104, 105, 89,
                                  94, 94, 99, 102, 89, 65, 83, 87, 85, 76, 71,
                                  72, 66, 77, 66, 64, 67, 68, 1, 68, 77, 65, 68,
                                  75, 5, 2, 66, 2, 12, 1, 71, 75, 77, 76, 66,
                                  64, 3, 5, 69, 66, 71, 7, 6, 73, 76, 76, 76, 9,
                                  62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
                                  62, 62, 61, 36, 62, 62, 62, 62, 61, 48, 34,
                                  45, 43, 31, 15, 9, 2, 79, 61, 59, 62, 46, 31,
                                  34, 26, 24, 32, 28, 20, 6, 17, 3, 72, 23, 28,
                                  21, 28, 34, 21, 19, 11, 10, 68, 4, 67, 79,
                                  115, 0, 67, 73, 20, 4, 69, 76, 70, 67, 67, 66,
                                  65, 6, 67, 66, 65, 4, 14, 11, 16, 1, 61, 58,
                                  52, 48, 40, 36, 22, 10, 74, 66, 30, 23, 20,
                                  12, 10, 4, 1, 65, 74, 76, 70, 67, 67, 66, 65,
                                  6, 67, 66, 65, 4, 14, 11, 16, 1, 61, 58, 52,
                                  48, 40, 36, 22, 10, 74 },

                                {

                                62,
                                  8, 75, 62, 8, 75, 111, 91, 14, 10, 9, 31, 49,
                                  56, 18, 3, 83, 33, 82, 88, 4, 3, 0, 64, 12,
                                  42, 47, 33, 1, 103, 109, 104, 72, 82, 88, 4,
                                  89, 80, 23, 6, 82, 94, 104, 67, 69, 86, 99, 0,
                                  82, 98, 65, 78, 88, 100, 7, 76, 73, 90, 17, 3,
                                  22, 0, 0, 0, 77, 88, 97, 68, 15, 0, 26, 82,
                                  115, 106, 81, 87, 69, 71, 82, 81, 109, 68, 92,
                                  82, 106, 86, 78, 85, 80, 12, 0, 75, 106, 76,
                                  97, 84, 110, 65, 77, 72, 89, 11, 69, 66, 90,
                                  83, 81, 79, 70, 64, 67, 80, 0, 5, 68, 4, 68,
                                  69, 4, 73, 22, 68, 1, 16, 19, 25, 24, 14, 80,
                                  72, 76, 6, 67, 87, 67, 0, 72, 75, 71, 11, 40,
                                  14, 77, 80, 72, 69, 31, 38, 98, 66, 65, 81, 3,
                                  0, 66, 69, 33, 56, 42, 1, 75, 111, 17, 57, 62,
                                  114, 22, 21, 26, 28, 28, 23, 18, 22, 26, 13,
                                  20, 14, 7, 4, 0, 15, 13, 14, 12, 5, 9, 19, 9,
                                  68, 10, 12, 69, 19, 67, 62, 62, 51, 40, 48,
                                  58, 62, 62, 36, 21, 14, 17, 29, 27, 85, 18,
                                  22, 4, 37, 19, 19, 24, 28, 27, 34, 32, 8, 93,
                                  0, 65, 11, 113, 101, 69, 7, 10, 4, 77, 81, 86,
                                  85, 110, 88, 14, 3, 64, 71, 73, 79, 91, 89,
                                  106, 76, 20, 7, 2, 66, 67, 73, 77, 85, 97, 76,
                                  7, 66, 7, 5, 70, 77, 78, 91, 73, 29, 9, 9, 6,
                                  64, 70, 78, 77, 81, 62, 114, 112, 105, 111,
                                  103, 104, 103, 102, 99, 102, 102, 103, 88, 93,
                                  93, 98, 98, 89, 66, 83, 86, 84, 75, 71, 72,
                                  66, 77, 66, 65, 67, 68, 2, 68, 77, 65, 68, 75,
                                  5, 2, 66, 2, 11, 1, 71, 74, 75, 76, 66, 0, 2,
                                  5, 69, 66, 70, 7, 6, 72, 75, 75, 75, 7, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
                                  62, 58, 34, 62, 62, 62, 62, 58, 46, 33, 43,
                                  41, 30, 14, 8, 1, 79, 59, 57, 60, 44, 29, 32,
                                  25, 22, 30, 26, 18, 4, 15, 1, 73, 22, 27, 19,
                                  27, 32, 20, 17, 10, 9, 69, 3, 67, 79, 114, 64,
                                  68, 75, 19, 3, 70, 76, 69, 66, 66, 64, 64, 7,
                                  67, 65, 64, 5, 15, 12, 17, 2, 60, 57, 50, 46,
                                  38, 34, 20, 8, 75, 65, 30, 24, 21, 13, 11, 5,
                                  2, 64, 73, 76, 69, 66, 66, 64, 64, 7, 67, 65,
                                  64, 5, 15, 12, 17, 2, 60, 57, 50, 46, 38, 34,
                                  20, 8, 75 },

                                {

                                62,
                                  8, 75, 62, 8, 75, 109, 89, 14, 10, 8, 29, 48,
                                  55, 19, 3, 82, 31, 82, 87, 3, 3, 1, 65, 11,
                                  41, 45, 30, 65, 104, 107, 103, 72, 82, 87, 3,
                                  89, 79, 23, 6, 82, 93, 102, 68, 70, 86, 99, 0,
                                  81, 97, 66, 78, 88, 100, 7, 76, 73, 89, 18, 3,
                                  22, 0, 0, 0, 77, 88, 97, 67, 14, 0, 25, 82,
                                  114, 104, 80, 86, 68, 70, 81, 80, 107, 67, 91,
                                  81, 103, 86, 79, 85, 81, 12, 0, 74, 103, 75,
                                  97, 84, 108, 65, 77, 72, 89, 11, 69, 66, 89,
                                  83, 80, 78, 70, 64, 67, 79, 0, 5, 69, 4, 68,
                                  69, 4, 73, 22, 68, 1, 17, 19, 25, 24, 14, 81,
                                  72, 76, 6, 67, 86, 67, 1, 71, 75, 69, 13, 41,
                                  15, 75, 80, 73, 69, 32, 38, 99, 66, 64, 82, 4,
                                  0, 66, 68, 33, 56, 42, 3, 76, 109, 16, 54, 62,
                                  113, 22, 21, 25, 28, 27, 23, 17, 22, 25, 12,
                                  19, 14, 7, 4, 0, 14, 13, 13, 11, 5, 9, 18, 9,
                                  69, 9, 11, 69, 18, 68, 60, 62, 49, 38, 47, 56,
                                  62, 62, 35, 19, 12, 15, 27, 25, 86, 17, 21, 3,
                                  36, 18, 18, 22, 27, 25, 32, 31, 6, 93, 64, 66,
                                  9, 112, 100, 68, 7, 10, 4, 76, 80, 85, 85,
                                  108, 86, 15, 4, 64, 70, 71, 78, 89, 88, 103,
                                  75, 20, 7, 2, 65, 66, 72, 77, 84, 96, 76, 8,
                                  65, 7, 5, 69, 77, 78, 90, 72, 29, 10, 9, 6, 0,
                                  69, 77, 77, 80, 62, 113, 111, 104, 110, 102,
                                  102, 102, 100, 98, 100, 100, 100, 87, 92, 92,
                                  97, 95, 88, 67, 82, 85, 83, 75, 71, 72, 66,
                                  76, 67, 66, 67, 68, 3, 68, 77, 65, 68, 74, 4,
                                  1, 66, 1, 10, 0, 71, 74, 74, 77, 67, 1, 2, 4,
                                  69, 66, 70, 6, 5, 72, 75, 75, 75, 6, 62, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
                                  56, 32, 62, 62, 62, 62, 55, 44, 31, 41, 38,
                                  28, 13, 7, 0, 79, 57, 54, 57, 42, 27, 30, 23,
                                  20, 28, 24, 16, 2, 13, 0, 75, 21, 26, 17, 25,
                                  31, 18, 15, 9, 8, 70, 2, 68, 79, 113, 66, 69,
                                  76, 17, 2, 71, 76, 69, 66, 65, 0, 0, 7, 66,
                                  64, 0, 6, 15, 13, 17, 2, 60, 55, 48, 44, 36,
                                  32, 17, 6, 76, 65, 31, 24, 21, 14, 12, 5, 2,
                                  64, 72, 76, 69, 66, 65, 0, 0, 7, 66, 64, 0, 6,
                                  15, 13, 17, 2, 60, 55, 48, 44, 36, 32, 17, 6,
                                  76 },

                                {

                                62,
                                  8, 76, 62, 8, 76, 107, 88, 15, 10, 8, 28, 46,
                                  54, 19, 4, 80, 30, 82, 85, 3, 2, 2, 66, 10,
                                  40, 44, 26, 67, 105, 105, 101, 72, 82, 85, 3,
                                  88, 78, 24, 6, 81, 92, 101, 70, 71, 86, 100,
                                  0, 81, 97, 66, 79, 87, 100, 6, 76, 73, 88, 18,
                                  3, 22, 0, 0, 0, 76, 88, 97, 67, 14, 64, 25,
                                  81, 113, 102, 79, 85, 66, 68, 80, 79, 105, 66,
                                  90, 81, 101, 87, 79, 85, 81, 13, 0, 73, 101,
                                  75, 96, 83, 106, 65, 77, 72, 89, 12, 70, 65,
                                  89, 83, 79, 78, 69, 64, 66, 78, 1, 5, 69, 4,
                                  68, 69, 4, 73, 22, 68, 1, 17, 19, 26, 25, 15,
                                  81, 71, 75, 5, 67, 86, 67, 2, 71, 74, 68, 14,
                                  41, 17, 74, 81, 74, 68, 32, 38, 99, 67, 64,
                                  82, 4, 64, 65, 67, 33, 56, 43, 4, 77, 108, 15,
                                  51, 62, 111, 22, 21, 25, 27, 27, 22, 17, 21,
                                  25, 12, 19, 14, 6, 4, 64, 14, 12, 12, 11, 5,
                                  9, 18, 8, 71, 9, 10, 69, 17, 68, 57, 62, 47,
                                  37, 45, 54, 62, 61, 33, 17, 10, 14, 25, 23,
                                  88, 16, 19, 1, 34, 17, 17, 21, 25, 23, 30, 29,
                                  5, 93, 65, 67, 8, 110, 98, 66, 8, 10, 4, 75,
                                  80, 85, 84, 107, 85, 16, 5, 0, 70, 70, 77, 88,
                                  87, 101, 75, 21, 8, 3, 65, 65, 72, 76, 83, 95,
                                  76, 10, 64, 7, 5, 69, 76, 78, 90, 72, 30, 10,
                                  10, 6, 1, 69, 77, 76, 80, 62, 111, 109, 102,
                                  108, 100, 101, 100, 99, 96, 98, 98, 98, 87,
                                  91, 92, 97, 92, 88, 68, 82, 85, 82, 75, 71,
                                  72, 66, 76, 67, 67, 67, 68, 3, 68, 77, 65, 68,
                                  74, 4, 1, 66, 0, 9, 0, 71, 74, 73, 78, 67, 2,
                                  1, 4, 69, 66, 69, 6, 5, 71, 74, 75, 75, 4, 62,
                                  61, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
                                  62, 53, 30, 62, 62, 62, 62, 53, 41, 29, 39,
                                  36, 26, 12, 6, 64, 79, 55, 52, 55, 40, 25, 29,
                                  22, 18, 26, 21, 14, 0, 11, 65, 76, 20, 24, 15,
                                  24, 29, 17, 13, 7, 6, 71, 1, 69, 80, 112, 67,
                                  71, 78, 16, 0, 72, 75, 68, 65, 65, 1, 1, 8,
                                  66, 0, 1, 7, 16, 14, 18, 3, 59, 53, 46, 42,
                                  34, 30, 15, 4, 77, 64, 31, 25, 22, 14, 13, 6,
                                  3, 0, 72, 75, 68, 65, 65, 1, 1, 8, 66, 0, 1,
                                  7, 16, 14, 18, 3, 59, 53, 46, 42, 34, 30, 15,
                                  4, 77 },

                                {

                                62,
                                  8, 76, 62, 8, 76, 106, 86, 15, 10, 7, 26, 45,
                                  53, 20, 4, 78, 28, 82, 84, 3, 2, 3, 67, 8, 38,
                                  42, 23, 69, 106, 103, 100, 72, 82, 84, 3, 88,
                                  77, 24, 5, 80, 91, 100, 71, 73, 87, 100, 0,
                                  81, 96, 66, 79, 87, 100, 6, 76, 73, 88, 19, 3,
                                  22, 0, 0, 0, 76, 89, 97, 66, 13, 64, 24, 81,
                                  112, 100, 78, 84, 65, 67, 80, 78, 103, 65, 89,
                                  80, 99, 88, 79, 85, 81, 13, 64, 72, 99, 75,
                                  95, 82, 104, 65, 77, 72, 89, 12, 70, 65, 88,
                                  83, 79, 78, 69, 64, 66, 77, 1, 5, 69, 3, 68,
                                  69, 4, 73, 22, 68, 1, 18, 19, 26, 25, 15, 82,
                                  71, 74, 5, 67, 86, 67, 3, 71, 74, 67, 15, 42,
                                  18, 72, 81, 75, 68, 32, 38, 100, 67, 0, 83, 5,
                                  64, 65, 66, 33, 56, 43, 5, 78, 106, 14, 48,
                                  60, 110, 21, 21, 24, 26, 26, 22, 16, 21, 24,
                                  11, 18, 13, 6, 4, 64, 13, 11, 11, 10, 4, 8,
                                  17, 8, 72, 8, 9, 69, 15, 69, 55, 62, 45, 35,
                                  43, 52, 62, 58, 32, 15, 7, 12, 23, 21, 89, 14,
                                  18, 64, 33, 16, 16, 20, 24, 21, 28, 27, 3, 93,
                                  66, 68, 6, 109, 97, 65, 8, 10, 4, 74, 79, 84,
                                  83, 105, 84, 17, 5, 1, 69, 69, 76, 86, 86, 99,
                                  74, 21, 8, 3, 64, 64, 71, 76, 83, 94, 76, 11,
                                  0, 7, 5, 68, 76, 78, 89, 71, 30, 11, 10, 6, 2,
                                  68, 76, 76, 79, 62, 110, 108, 101, 106, 99,
                                  99, 99, 97, 95, 97, 96, 96, 86, 90, 91, 96,
                                  89, 88, 69, 82, 84, 82, 75, 71, 72, 67, 75,
                                  67, 68, 67, 68, 4, 68, 77, 65, 68, 74, 3, 1,
                                  66, 64, 8, 0, 71, 74, 72, 79, 67, 2, 0, 4, 69,
                                  66, 69, 6, 4, 71, 73, 75, 75, 3, 62, 60, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 50,
                                  28, 62, 62, 62, 62, 50, 39, 27, 37, 33, 24,
                                  10, 5, 65, 79, 52, 50, 53, 38, 23, 27, 20, 16,
                                  24, 19, 12, 65, 8, 67, 77, 19, 23, 12, 22, 27,
                                  15, 11, 6, 5, 72, 0, 70, 80, 111, 68, 72, 79,
                                  15, 64, 73, 75, 68, 65, 64, 2, 1, 9, 66, 1, 2,
                                  8, 16, 15, 18, 4, 59, 51, 44, 40, 32, 28, 13,
                                  2, 79, 64, 32, 25, 23, 15, 13, 6, 3, 0, 71,
                                  75, 68, 65, 64, 2, 1, 9, 66, 1, 2, 8, 16, 15,
                                  18, 4, 59, 51, 44, 40, 32, 28, 13, 2, 79 },

                                {

                                62,
                                  8, 76, 62, 8, 76, 104, 85, 15, 10, 7, 24, 43,
                                  52, 21, 4, 77, 26, 81, 82, 2, 2, 4, 68, 7, 37,
                                  40, 20, 72, 106, 101, 99, 72, 81, 82, 2, 88,
                                  76, 24, 5, 80, 90, 98, 72, 74, 87, 100, 0, 80,
                                  95, 67, 79, 87, 100, 6, 75, 73, 87, 19, 3, 22,
                                  0, 0, 0, 75, 89, 97, 66, 12, 64, 24, 80, 110,
                                  97, 77, 83, 0, 65, 79, 77, 101, 64, 88, 79,
                                  96, 88, 80, 85, 82, 13, 64, 71, 96, 74, 95,
                                  82, 102, 65, 77, 72, 88, 12, 70, 64, 87, 82,
                                  78, 77, 69, 0, 65, 76, 2, 5, 70, 3, 67, 69, 4,
                                  73, 23, 68, 1, 18, 20, 26, 25, 15, 82, 70, 74,
                                  4, 67, 85, 67, 4, 70, 73, 65, 17, 43, 20, 70,
                                  82, 76, 67, 33, 38, 101, 67, 0, 83, 6, 64, 65,
                                  64, 33, 56, 43, 7, 79, 105, 13, 46, 57, 109,
                                  21, 21, 24, 26, 26, 22, 16, 21, 24, 10, 17,
                                  13, 6, 4, 64, 13, 11, 10, 10, 4, 8, 16, 7, 73,
                                  7, 9, 69, 14, 69, 53, 62, 44, 34, 42, 50, 62,
                                  56, 31, 13, 5, 11, 21, 19, 90, 13, 17, 65, 32,
                                  15, 15, 18, 22, 19, 26, 26, 2, 93, 67, 69, 4,
                                  107, 95, 64, 9, 10, 4, 73, 78, 83, 83, 103,
                                  82, 18, 6, 1, 68, 67, 75, 85, 85, 96, 73, 22,
                                  9, 4, 64, 0, 70, 75, 82, 93, 75, 12, 1, 7, 5,
                                  67, 75, 77, 88, 70, 30, 12, 10, 6, 3, 67, 75,
                                  75, 78, 62, 109, 106, 99, 105, 98, 98, 97, 95,
                                  93, 95, 94, 93, 85, 89, 90, 95, 86, 87, 70,
                                  81, 83, 81, 75, 71, 72, 67, 75, 68, 69, 67,
                                  68, 5, 68, 77, 65, 68, 73, 3, 0, 66, 65, 7,
                                  64, 71, 74, 71, 79, 68, 3, 0, 3, 69, 66, 69,
                                  5, 4, 71, 73, 75, 75, 1, 62, 59, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 62, 60, 48, 26, 62,
                                  62, 62, 62, 47, 37, 26, 35, 31, 22, 9, 4, 66,
                                  79, 50, 47, 50, 36, 21, 25, 19, 14, 22, 17,
                                  10, 67, 6, 68, 79, 18, 22, 10, 21, 26, 14, 9,
                                  5, 4, 73, 64, 71, 80, 110, 70, 73, 81, 13, 65,
                                  74, 75, 67, 64, 0, 3, 2, 9, 65, 2, 3, 9, 17,
                                  16, 19, 4, 58, 49, 42, 38, 30, 26, 10, 0, 80,
                                  0, 32, 26, 23, 16, 14, 7, 4, 0, 70, 75, 67,
                                  64, 0, 3, 2, 9, 65, 2, 3, 9, 17, 16, 19, 4,
                                  58, 49, 42, 38, 30, 26, 10, 0, 80 },

                                {

                                61,
                                  8, 76, 61, 8, 76, 102, 83, 16, 10, 6, 22, 42,
                                  51, 21, 4, 75, 25, 81, 81, 2, 1, 5, 69, 6, 36,
                                  38, 16, 74, 107, 99, 97, 72, 81, 81, 2, 87,
                                  75, 25, 5, 79, 89, 97, 73, 75, 87, 101, 0, 80,
                                  94, 67, 80, 87, 100, 6, 75, 73, 86, 20, 3, 22,
                                  0, 0, 0, 75, 89, 97, 65, 11, 64, 23, 80, 109,
                                  95, 76, 82, 1, 64, 78, 76, 99, 0, 87, 78, 94,
                                  89, 80, 85, 82, 14, 64, 70, 94, 74, 94, 81,
                                  100, 65, 77, 72, 88, 13, 70, 64, 86, 82, 77,
                                  77, 69, 0, 65, 75, 2, 5, 70, 3, 67, 69, 4, 73,
                                  23, 68, 1, 19, 20, 27, 25, 16, 83, 70, 73, 4,
                                  67, 85, 67, 5, 70, 73, 64, 18, 44, 21, 68, 82,
                                  77, 67, 33, 38, 102, 67, 1, 84, 6, 64, 65, 0,
                                  33, 56, 43, 8, 80, 103, 12, 43, 54, 107, 21,
                                  21, 23, 25, 25, 21, 15, 21, 23, 9, 16, 13, 6,
                                  4, 65, 12, 10, 9, 9, 4, 8, 15, 7, 74, 7, 8,
                                  69, 13, 70, 51, 60, 42, 32, 40, 48, 62, 53,
                                  30, 11, 3, 9, 19, 17, 92, 12, 16, 67, 31, 14,
                                  14, 17, 21, 17, 24, 24, 0, 93, 68, 70, 3, 106,
                                  94, 1, 9, 10, 4, 72, 77, 82, 82, 101, 81, 19,
                                  7, 2, 68, 66, 74, 83, 84, 94, 73, 22, 9, 4, 0,
                                  1, 70, 75, 81, 92, 75, 14, 2, 7, 5, 66, 75,
                                  77, 87, 69, 31, 13, 11, 6, 4, 67, 74, 75, 78,
                                  62, 107, 105, 98, 103, 97, 96, 96, 94, 92, 93,
                                  92, 91, 85, 88, 90, 94, 83, 87, 71, 81, 82,
                                  80, 75, 71, 72, 67, 74, 68, 70, 67, 68, 5, 68,
                                  77, 65, 68, 73, 2, 0, 66, 66, 6, 64, 71, 74,
                                  70, 80, 68, 4, 64, 3, 69, 66, 68, 5, 3, 70,
                                  72, 75, 75, 0, 62, 58, 61, 61, 61, 62, 62, 62,
                                  61, 62, 62, 62, 57, 45, 24, 62, 60, 59, 60,
                                  44, 35, 24, 33, 28, 20, 8, 3, 67, 79, 48, 45,
                                  48, 34, 19, 23, 17, 12, 20, 15, 8, 69, 4, 70,
                                  80, 17, 21, 8, 19, 24, 12, 7, 3, 2, 74, 65,
                                  72, 80, 109, 71, 75, 82, 12, 66, 75, 75, 67,
                                  64, 0, 4, 3, 10, 65, 3, 4, 10, 17, 17, 19, 5,
                                  58, 47, 40, 36, 28, 24, 8, 65, 81, 0, 33, 26,
                                  24, 16, 15, 7, 4, 1, 70, 75, 67, 64, 0, 4, 3,
                                  10, 65, 3, 4, 10, 17, 17, 19, 5, 58, 47, 40,
                                  36, 28, 24, 8, 65, 81 },

                                {

                                60,
                                  8, 76, 60, 8, 76, 100, 82, 16, 10, 6, 20, 40,
                                  50, 22, 4, 73, 23, 81, 79, 2, 1, 6, 70, 5, 35,
                                  36, 13, 76, 108, 97, 96, 72, 81, 79, 2, 87,
                                  74, 25, 5, 78, 88, 96, 74, 76, 87, 101, 0, 80,
                                  93, 67, 80, 87, 100, 6, 75, 73, 85, 20, 3, 22,
                                  0, 0, 0, 74, 89, 97, 65, 10, 64, 23, 79, 108,
                                  93, 75, 81, 3, 1, 77, 75, 97, 1, 86, 77, 92,
                                  90, 80, 85, 82, 14, 64, 69, 92, 74, 93, 80,
                                  98, 65, 77, 72, 88, 13, 70, 0, 85, 82, 76, 77,
                                  69, 0, 64, 74, 3, 5, 70, 3, 67, 69, 4, 73, 23,
                                  68, 1, 19, 20, 27, 25, 16, 83, 69, 72, 3, 67,
                                  85, 67, 6, 70, 72, 0, 19, 45, 23, 66, 83, 78,
                                  66, 33, 38, 103, 67, 1, 84, 7, 64, 65, 1, 33,
                                  56, 43, 9, 81, 102, 11, 40, 51, 106, 21, 21,
                                  23, 24, 25, 21, 15, 21, 23, 8, 15, 13, 6, 4,
                                  65, 12, 9, 8, 9, 4, 8, 14, 6, 75, 6, 7, 69,
                                  12, 70, 49, 58, 40, 31, 38, 46, 59, 51, 29, 9,
                                  1, 8, 17, 15, 93, 11, 15, 69, 30, 13, 13, 16,
                                  19, 15, 22, 22, 64, 93, 69, 71, 1, 104, 92, 2,
                                  10, 10, 4, 71, 76, 81, 81, 99, 80, 20, 8, 3,
                                  67, 65, 73, 82, 83, 92, 72, 23, 10, 5, 0, 2,
                                  69, 74, 80, 91, 75, 15, 3, 7, 5, 65, 74, 77,
                                  86, 68, 31, 14, 11, 6, 5, 66, 73, 74, 77, 62,
                                  106, 103, 96, 101, 96, 95, 94, 92, 90, 91, 90,
                                  89, 84, 87, 89, 93, 80, 87, 72, 81, 81, 79,
                                  75, 71, 72, 67, 74, 68, 71, 67, 68, 6, 68, 77,
                                  65, 68, 73, 2, 0, 66, 67, 5, 64, 71, 74, 69,
                                  81, 68, 5, 65, 3, 69, 66, 68, 5, 3, 70, 71,
                                  75, 75, 65, 61, 57, 60, 59, 59, 62, 62, 62,
                                  59, 60, 62, 61, 54, 42, 22, 61, 57, 55, 55,
                                  41, 33, 22, 31, 26, 18, 7, 2, 68, 79, 46, 43,
                                  46, 32, 17, 21, 16, 10, 18, 13, 6, 71, 2, 72,
                                  81, 16, 20, 6, 18, 22, 11, 5, 2, 1, 75, 66,
                                  73, 80, 108, 72, 76, 84, 11, 67, 76, 75, 66,
                                  0, 1, 5, 4, 11, 65, 4, 5, 11, 18, 18, 20, 6,
                                  57, 45, 38, 34, 26, 22, 6, 67, 82, 1, 33, 27,
                                  25, 17, 16, 8, 5, 1, 69, 75, 66, 0, 1, 5, 4,
                                  11, 65, 4, 5, 11, 18, 18, 20, 6, 57, 45, 38,
                                  34, 26, 22, 6, 67, 82 },

                                {

                                58,
                                  7, 77, 58, 7, 77, 99, 81, 16, 10, 5, 18, 38,
                                  49, 22, 4, 72, 21, 81, 78, 1, 0, 7, 71, 3, 33,
                                  34, 9, 79, 109, 95, 95, 72, 81, 78, 1, 87, 74,
                                  25, 4, 78, 88, 95, 76, 78, 88, 102, 64, 80,
                                  93, 68, 81, 87, 100, 5, 75, 73, 85, 20, 2, 22,
                                  0, 0, 0, 74, 90, 97, 65, 9, 65, 22, 79, 107,
                                  91, 74, 81, 4, 2, 77, 74, 96, 1, 85, 77, 90,
                                  91, 81, 86, 83, 14, 65, 69, 90, 74, 93, 80,
                                  97, 65, 77, 72, 88, 13, 71, 0, 85, 82, 76, 77,
                                  69, 0, 64, 73, 3, 5, 71, 2, 67, 69, 3, 73, 23,
                                  68, 1, 19, 20, 27, 25, 16, 84, 69, 72, 2, 67,
                                  85, 68, 6, 70, 72, 1, 20, 45, 24, 65, 84, 80,
                                  66, 33, 38, 104, 68, 1, 85, 7, 65, 65, 2, 33,
                                  55, 43, 10, 82, 101, 9, 37, 47, 105, 20, 21,
                                  22, 23, 24, 20, 14, 20, 22, 7, 14, 12, 5, 3,
                                  66, 11, 8, 7, 8, 3, 7, 13, 5, 77, 5, 6, 69,
                                  10, 71, 46, 55, 38, 29, 36, 43, 55, 48, 27, 7,
                                  65, 6, 14, 13, 95, 9, 13, 71, 28, 12, 12, 14,
                                  17, 13, 20, 20, 66, 93, 70, 72, 64, 103, 91,
                                  3, 10, 10, 4, 71, 76, 81, 81, 98, 79, 20, 8,
                                  3, 67, 64, 72, 81, 83, 90, 72, 23, 10, 5, 0,
                                  2, 69, 74, 80, 90, 75, 16, 4, 7, 4, 65, 74,
                                  77, 86, 68, 31, 14, 11, 6, 6, 66, 73, 74, 77,
                                  62, 105, 102, 95, 100, 95, 94, 93, 91, 89, 90,
                                  89, 87, 84, 87, 89, 93, 77, 87, 74, 81, 81,
                                  79, 75, 71, 72, 68, 74, 69, 72, 68, 68, 6, 69,
                                  77, 66, 68, 73, 1, 64, 67, 68, 4, 65, 72, 74,
                                  68, 82, 69, 5, 66, 2, 69, 67, 68, 4, 2, 70,
                                  71, 75, 75, 67, 59, 56, 58, 57, 56, 62, 62,
                                  62, 56, 57, 62, 58, 50, 39, 20, 57, 53, 51,
                                  49, 38, 30, 20, 28, 23, 16, 5, 0, 69, 79, 43,
                                  40, 43, 30, 14, 19, 14, 7, 16, 10, 4, 74, 64,
                                  74, 83, 14, 18, 3, 16, 20, 9, 3, 0, 64, 76,
                                  67, 74, 81, 107, 74, 78, 86, 9, 69, 78, 75,
                                  66, 0, 1, 6, 4, 11, 65, 5, 5, 12, 18, 18, 20,
                                  6, 56, 43, 36, 31, 23, 20, 3, 69, 84, 1, 33,
                                  27, 25, 17, 16, 8, 5, 1, 69, 75, 66, 0, 1, 6,
                                  4, 11, 65, 5, 5, 12, 18, 18, 20, 6, 56, 43,
                                  36, 31, 23, 20, 3, 69, 84 },

                                {

                                57,
                                  7, 77, 57, 7, 77, 97, 79, 17, 11, 5, 17, 37,
                                  49, 23, 5, 70, 20, 80, 76, 1, 0, 9, 71, 2, 32,
                                  33, 6, 81, 109, 93, 93, 71, 80, 76, 1, 86, 73,
                                  26, 4, 77, 87, 93, 77, 79, 88, 102, 64, 79,
                                  92, 68, 81, 86, 99, 5, 74, 72, 84, 21, 2, 22,
                                  0, 0, 0, 73, 90, 97, 64, 9, 65, 22, 78, 105,
                                  88, 72, 80, 6, 4, 76, 72, 94, 2, 83, 76, 87,
                                  91, 81, 86, 83, 15, 65, 68, 87, 73, 92, 79,
                                  95, 65, 76, 72, 87, 14, 71, 1, 84, 81, 75, 76,
                                  68, 1, 0, 72, 4, 6, 71, 2, 66, 68, 3, 72, 24,
                                  67, 1, 20, 21, 28, 26, 17, 84, 68, 71, 2, 67,
                                  84, 68, 7, 69, 71, 3, 22, 46, 26, 0, 84, 81,
                                  65, 34, 39, 104, 68, 2, 85, 8, 65, 64, 4, 33,
                                  55, 44, 12, 83, 99, 8, 35, 44, 103, 20, 21,
                                  22, 23, 24, 20, 14, 20, 22, 7, 14, 12, 5, 3,
                                  66, 11, 8, 7, 8, 3, 7, 13, 5, 78, 5, 6, 69, 9,
                                  71, 44, 53, 37, 28, 35, 41, 52, 46, 26, 6, 67,
                                  5, 12, 12, 96, 8, 12, 72, 27, 12, 12, 13, 16,
                                  12, 19, 19, 67, 93, 70, 72, 65, 101, 89, 5,
                                  11, 10, 4, 70, 75, 80, 80, 96, 77, 21, 9, 4,
                                  66, 1, 71, 79, 82, 87, 71, 24, 11, 6, 1, 3,
                                  68, 73, 79, 88, 74, 18, 5, 8, 4, 64, 73, 76,
                                  85, 67, 32, 15, 12, 7, 7, 65, 72, 73, 76, 62,
                                  103, 100, 93, 98, 93, 92, 91, 89, 87, 88, 87,
                                  84, 83, 86, 88, 92, 73, 86, 75, 80, 80, 78,
                                  74, 71, 71, 68, 73, 69, 72, 68, 68, 7, 69, 77,
                                  66, 68, 72, 1, 64, 67, 68, 4, 65, 72, 73, 66,
                                  82, 69, 6, 66, 2, 69, 67, 67, 4, 2, 69, 70,
                                  74, 74, 68, 58, 55, 57, 56, 54, 60, 60, 59,
                                  54, 55, 59, 56, 47, 37, 18, 54, 50, 48, 44,
                                  36, 28, 19, 26, 21, 15, 4, 64, 69, 79, 41, 38,
                                  41, 28, 12, 18, 13, 5, 15, 8, 3, 76, 66, 75,
                                  84, 13, 17, 1, 15, 19, 8, 2, 64, 65, 77, 67,
                                  74, 81, 106, 75, 79, 87, 8, 70, 79, 74, 65, 1,
                                  2, 8, 5, 12, 64, 7, 6, 13, 19, 19, 21, 7, 56,
                                  42, 35, 29, 21, 19, 1, 70, 85, 2, 34, 28, 26,
                                  18, 17, 9, 6, 2, 68, 74, 65, 1, 2, 8, 5, 12,
                                  64, 7, 6, 13, 19, 19, 21, 7, 56, 42, 35, 29,
                                  21, 19, 1, 70, 85 },

                                {

                                56,
                                  7, 77, 56, 7, 77, 95, 78, 17, 11, 5, 15, 35,
                                  48, 24, 5, 68, 18, 80, 75, 1, 0, 10, 72, 1,
                                  31, 31, 3, 83, 110, 91, 92, 71, 80, 75, 1, 86,
                                  72, 26, 4, 76, 86, 92, 78, 80, 88, 102, 64,
                                  79, 91, 68, 81, 86, 99, 5, 74, 72, 83, 21, 2,
                                  22, 0, 0, 0, 72, 90, 97, 64, 8, 65, 22, 77,
                                  104, 86, 71, 79, 8, 6, 75, 71, 92, 3, 82, 75,
                                  85, 92, 81, 86, 83, 15, 65, 67, 85, 73, 91,
                                  78, 93, 65, 76, 72, 87, 14, 71, 1, 83, 81, 74,
                                  76, 68, 1, 0, 71, 5, 6, 71, 2, 66, 68, 3, 72,
                                  24, 67, 1, 20, 21, 28, 26, 17, 85, 67, 70, 1,
                                  67, 84, 68, 8, 69, 71, 4, 23, 47, 28, 2, 85,
                                  82, 65, 34, 39, 105, 68, 2, 86, 9, 65, 64, 5,
                                  33, 55, 44, 13, 84, 98, 7, 32, 41, 102, 20,
                                  21, 22, 22, 23, 20, 14, 20, 21, 6, 13, 12, 5,
                                  3, 66, 10, 7, 6, 8, 3, 7, 12, 4, 79, 4, 5, 69,
                                  8, 72, 42, 51, 35, 26, 33, 39, 49, 44, 25, 4,
                                  69, 3, 10, 10, 97, 7, 11, 74, 26, 11, 11, 12,
                                  14, 10, 17, 17, 69, 93, 71, 73, 67, 100, 88,
                                  6, 12, 10, 4, 69, 74, 79, 79, 94, 76, 22, 10,
                                  5, 65, 2, 70, 78, 81, 85, 70, 24, 11, 6, 1, 4,
                                  67, 72, 78, 87, 74, 19, 6, 8, 4, 0, 72, 76,
                                  84, 66, 32, 16, 12, 7, 8, 64, 71, 72, 75, 62,
                                  102, 98, 91, 96, 92, 91, 89, 87, 86, 86, 85,
                                  82, 82, 85, 87, 91, 70, 86, 76, 80, 79, 77,
                                  74, 71, 71, 68, 73, 69, 73, 68, 68, 8, 69, 77,
                                  66, 68, 72, 1, 64, 67, 69, 3, 65, 72, 73, 65,
                                  83, 69, 7, 67, 2, 69, 67, 67, 4, 2, 69, 69,
                                  74, 74, 70, 57, 54, 56, 54, 52, 57, 57, 56,
                                  52, 52, 56, 53, 44, 34, 16, 50, 46, 44, 39,
                                  33, 26, 17, 24, 19, 13, 3, 65, 70, 79, 39, 36,
                                  39, 26, 10, 16, 11, 3, 13, 6, 1, 78, 68, 77,
                                  85, 12, 16, 64, 13, 17, 6, 0, 65, 66, 78, 68,
                                  75, 81, 105, 76, 80, 89, 7, 71, 80, 74, 65, 2,
                                  3, 9, 6, 13, 64, 8, 7, 14, 19, 20, 22, 8, 55,
                                  40, 33, 27, 19, 17, 64, 72, 86, 3, 34, 28, 27,
                                  19, 18, 9, 7, 2, 67, 74, 65, 2, 3, 9, 6, 13,
                                  64, 8, 7, 14, 19, 20, 22, 8, 55, 40, 33, 27,
                                  19, 17, 64, 72, 86 },

                                {

                                55,
                                  7, 77, 55, 7, 77, 93, 76, 18, 11, 4, 13, 34,
                                  47, 24, 5, 66, 17, 80, 73, 1, 64, 11, 73, 0,
                                  30, 29, 64, 85, 111, 89, 90, 71, 80, 73, 1,
                                  85, 71, 27, 4, 75, 85, 91, 79, 81, 88, 103,
                                  64, 79, 90, 68, 82, 86, 99, 5, 74, 72, 82, 22,
                                  2, 22, 0, 0, 0, 72, 90, 97, 0, 7, 65, 21, 77,
                                  103, 84, 70, 78, 9, 7, 74, 70, 90, 4, 81, 74,
                                  83, 93, 81, 86, 83, 16, 65, 66, 83, 73, 90,
                                  77, 91, 65, 76, 72, 87, 15, 71, 2, 82, 81, 73,
                                  76, 68, 1, 1, 70, 5, 6, 71, 2, 66, 68, 3, 72,
                                  24, 67, 1, 21, 21, 29, 26, 18, 85, 67, 69, 1,
                                  67, 84, 68, 9, 69, 70, 5, 24, 48, 29, 4, 85,
                                  83, 64, 34, 39, 106, 68, 3, 86, 9, 65, 64, 6,
                                  33, 55, 44, 14, 85, 96, 6, 29, 38, 100, 20,
                                  21, 21, 21, 23, 19, 13, 20, 21, 5, 12, 12, 5,
                                  3, 67, 10, 6, 5, 7, 3, 7, 11, 4, 80, 4, 4, 69,
                                  7, 72, 40, 49, 33, 25, 31, 37, 46, 41, 24, 2,
                                  71, 2, 8, 8, 99, 6, 10, 76, 25, 10, 10, 11,
                                  13, 8, 15, 15, 70, 93, 72, 74, 68, 98, 86, 8,
                                  12, 10, 4, 68, 73, 78, 78, 92, 75, 23, 11, 6,
                                  65, 3, 69, 76, 80, 83, 70, 25, 12, 7, 2, 5,
                                  67, 72, 77, 86, 74, 21, 7, 8, 4, 1, 72, 76,
                                  83, 65, 33, 17, 13, 7, 9, 64, 70, 72, 75, 62,
                                  100, 97, 90, 94, 91, 89, 88, 86, 84, 84, 83,
                                  80, 82, 84, 87, 90, 67, 86, 77, 80, 78, 76,
                                  74, 71, 71, 68, 72, 69, 74, 68, 68, 8, 69, 77,
                                  66, 68, 72, 0, 64, 67, 70, 2, 65, 72, 73, 64,
                                  84, 69, 8, 68, 2, 69, 67, 66, 4, 1, 68, 68,
                                  74, 74, 71, 56, 53, 55, 52, 50, 55, 55, 53,
                                  49, 49, 53, 50, 41, 31, 14, 46, 43, 40, 34,
                                  30, 24, 15, 22, 16, 11, 2, 66, 71, 79, 37, 34,
                                  37, 24, 8, 14, 10, 1, 11, 4, 64, 80, 70, 79,
                                  86, 11, 15, 66, 12, 15, 5, 65, 67, 68, 79, 69,
                                  76, 81, 104, 77, 82, 90, 6, 72, 81, 74, 64, 2,
                                  3, 10, 7, 14, 64, 9, 8, 15, 20, 21, 22, 9, 55,
                                  38, 31, 25, 17, 15, 66, 74, 87, 3, 35, 29, 28,
                                  19, 19, 10, 7, 3, 67, 74, 64, 2, 3, 10, 7, 14,
                                  64, 9, 8, 15, 20, 21, 22, 9, 55, 38, 31, 25,
                                  17, 15, 66, 74, 87 },

                                {

                                53,
                                  7, 77, 53, 7, 77, 92, 75, 18, 11, 4, 11, 32,
                                  46, 25, 5, 65, 15, 80, 72, 0, 64, 12, 74, 65,
                                  28, 27, 67, 88, 112, 87, 89, 71, 80, 72, 0,
                                  85, 70, 27, 3, 75, 84, 89, 80, 83, 89, 103,
                                  64, 78, 89, 69, 82, 86, 99, 5, 74, 72, 82, 22,
                                  2, 22, 0, 0, 0, 71, 91, 97, 0, 6, 65, 21, 76,
                                  102, 82, 69, 77, 11, 9, 74, 69, 88, 5, 80, 73,
                                  80, 93, 82, 86, 84, 16, 66, 65, 80, 72, 90,
                                  77, 89, 65, 76, 72, 87, 15, 71, 2, 81, 81, 73,
                                  75, 68, 1, 1, 69, 6, 6, 72, 1, 66, 68, 3, 72,
                                  24, 67, 1, 21, 21, 29, 26, 18, 86, 66, 69, 0,
                                  67, 83, 68, 10, 68, 70, 7, 26, 49, 31, 6, 86,
                                  84, 64, 35, 39, 107, 68, 3, 87, 10, 65, 64, 7,
                                  33, 55, 44, 16, 86, 95, 5, 26, 35, 99, 19, 21,
                                  21, 21, 22, 19, 13, 20, 20, 4, 11, 11, 5, 3,
                                  67, 9, 6, 4, 7, 2, 6, 10, 3, 81, 3, 3, 69, 5,
                                  73, 38, 47, 31, 23, 30, 35, 42, 39, 23, 0, 74,
                                  0, 6, 6, 100, 4, 9, 77, 24, 9, 9, 9, 11, 6,
                                  13, 14, 72, 93, 73, 75, 70, 97, 85, 9, 13, 10,
                                  4, 67, 72, 77, 78, 90, 73, 24, 11, 6, 64, 5,
                                  68, 75, 79, 80, 69, 25, 12, 7, 2, 6, 66, 71,
                                  77, 85, 74, 22, 8, 8, 4, 2, 71, 76, 82, 64,
                                  33, 18, 13, 7, 10, 0, 69, 71, 74, 62, 99, 95,
                                  88, 93, 90, 88, 86, 84, 83, 83, 81, 77, 81,
                                  83, 86, 89, 64, 85, 78, 79, 77, 76, 74, 71,
                                  71, 69, 72, 70, 75, 68, 68, 9, 69, 77, 66, 68,
                                  71, 0, 65, 67, 71, 1, 66, 72, 73, 0, 85, 70,
                                  8, 68, 1, 69, 67, 66, 3, 1, 68, 68, 74, 74,
                                  73, 55, 52, 54, 51, 47, 52, 52, 50, 47, 46,
                                  49, 47, 37, 29, 12, 42, 39, 36, 29, 27, 22,
                                  13, 20, 14, 9, 0, 67, 72, 79, 34, 31, 34, 22,
                                  6, 12, 8, 64, 9, 2, 66, 82, 73, 80, 88, 10,
                                  14, 69, 10, 14, 3, 67, 68, 69, 80, 70, 77, 81,
                                  103, 79, 83, 92, 4, 73, 82, 74, 64, 3, 4, 11,
                                  7, 14, 0, 10, 9, 16, 20, 22, 23, 9, 54, 36,
                                  29, 23, 15, 13, 69, 76, 89, 4, 35, 29, 28, 20,
                                  19, 10, 8, 3, 66, 74, 64, 3, 4, 11, 7, 14, 0,
                                  10, 9, 16, 20, 22, 23, 9, 54, 36, 29, 23, 15,
                                  13, 69, 76, 89 },

                                {

                                52,
                                  7, 77, 52, 7, 77, 90, 73, 18, 11, 3, 9, 31,
                                  45, 26, 5, 0, 13, 79, 70, 0, 64, 13, 75, 66,
                                  27, 25, 70, 90, 112, 85, 88, 71, 79, 70, 0,
                                  85, 69, 27, 3, 74, 83, 88, 81, 84, 89, 103,
                                  64, 78, 88, 69, 82, 86, 99, 5, 73, 72, 81, 23,
                                  2, 22, 0, 0, 0, 71, 91, 97, 1, 5, 65, 20, 76,
                                  100, 79, 68, 76, 12, 10, 73, 68, 86, 6, 79,
                                  72, 78, 94, 82, 86, 84, 16, 66, 64, 78, 72,
                                  89, 76, 87, 65, 76, 72, 86, 15, 71, 3, 80, 80,
                                  72, 75, 68, 2, 2, 68, 6, 6, 72, 1, 65, 68, 3,
                                  72, 25, 67, 1, 22, 22, 29, 26, 18, 86, 66, 68,
                                  0, 67, 83, 68, 11, 68, 69, 8, 27, 50, 32, 8,
                                  86, 85, 0, 35, 39, 108, 68, 4, 87, 11, 65, 64,
                                  9, 33, 55, 44, 17, 87, 93, 4, 24, 32, 98, 19,
                                  21, 20, 20, 22, 19, 12, 20, 20, 3, 10, 11, 5,
                                  3, 67, 9, 5, 3, 6, 2, 6, 9, 3, 82, 2, 3, 69,
                                  4, 73, 36, 45, 30, 22, 28, 33, 39, 36, 22, 65,
                                  76, 64, 4, 4, 101, 3, 8, 79, 23, 8, 8, 8, 10,
                                  4, 11, 12, 73, 93, 74, 76, 72, 95, 83, 10, 13,
                                  10, 4, 66, 71, 76, 77, 88, 72, 25, 12, 7, 0,
                                  6, 67, 73, 78, 78, 68, 26, 13, 8, 3, 7, 65,
                                  71, 76, 84, 73, 23, 9, 8, 4, 3, 71, 75, 81, 0,
                                  33, 19, 13, 7, 11, 1, 68, 71, 73, 62, 98, 94,
                                  87, 91, 89, 86, 85, 82, 81, 81, 79, 75, 80,
                                  82, 85, 88, 2, 85, 79, 79, 76, 75, 74, 71, 71,
                                  69, 71, 70, 76, 68, 68, 10, 69, 77, 66, 68,
                                  71, 64, 65, 67, 72, 0, 66, 72, 73, 1, 85, 70,
                                  9, 69, 1, 69, 67, 66, 3, 0, 68, 67, 74, 74,
                                  74, 54, 51, 53, 49, 45, 50, 49, 47, 44, 43,
                                  46, 44, 34, 26, 10, 38, 36, 32, 24, 24, 20,
                                  12, 18, 11, 7, 64, 68, 73, 79, 32, 29, 32, 20,
                                  4, 10, 7, 66, 7, 0, 68, 84, 75, 82, 89, 9, 13,
                                  71, 9, 12, 2, 69, 69, 70, 81, 71, 78, 81, 102,
                                  80, 84, 93, 3, 74, 83, 74, 0, 3, 5, 12, 8, 15,
                                  0, 11, 10, 17, 21, 23, 23, 10, 54, 34, 27, 21,
                                  13, 11, 71, 78, 90, 4, 36, 30, 29, 21, 20, 11,
                                  8, 3, 65, 74, 0, 3, 5, 12, 8, 15, 0, 11, 10,
                                  17, 21, 23, 23, 10, 54, 34, 27, 21, 13, 11,
                                  71, 78, 90 },

                                {

                                51,
                                  7, 78, 51, 7, 78, 88, 72, 19, 11, 3, 8, 29,
                                  44, 26, 6, 2, 12, 79, 69, 0, 65, 14, 76, 67,
                                  26, 24, 74, 92, 113, 83, 86, 71, 79, 69, 0,
                                  84, 68, 28, 3, 73, 82, 87, 83, 85, 89, 104,
                                  64, 78, 88, 69, 83, 85, 99, 4, 73, 72, 80, 23,
                                  2, 22, 0, 0, 0, 70, 91, 97, 1, 5, 66, 20, 75,
                                  99, 77, 67, 75, 14, 12, 72, 67, 84, 7, 78, 72,
                                  76, 95, 82, 86, 84, 17, 66, 0, 76, 72, 88, 75,
                                  85, 65, 76, 72, 86, 16, 72, 3, 80, 80, 71, 75,
                                  67, 2, 2, 67, 7, 6, 72, 1, 65, 68, 3, 72, 25,
                                  67, 1, 22, 22, 30, 27, 19, 87, 65, 67, 64, 67,
                                  83, 68, 12, 68, 69, 9, 28, 50, 34, 9, 87, 86,
                                  0, 35, 39, 108, 69, 4, 88, 11, 66, 0, 10, 33,
                                  55, 45, 18, 88, 92, 3, 21, 29, 96, 19, 21, 20,
                                  19, 21, 18, 12, 19, 19, 3, 10, 11, 4, 3, 68,
                                  8, 4, 2, 6, 2, 6, 9, 2, 84, 2, 2, 69, 3, 74,
                                  33, 43, 28, 20, 26, 31, 36, 34, 20, 67, 78,
                                  66, 2, 2, 103, 2, 6, 81, 21, 7, 7, 7, 8, 2, 9,
                                  10, 75, 93, 75, 77, 73, 94, 82, 12, 14, 10, 4,
                                  65, 71, 76, 76, 87, 71, 26, 13, 8, 0, 7, 66,
                                  72, 77, 76, 68, 26, 13, 8, 3, 8, 65, 70, 75,
                                  83, 73, 25, 10, 8, 4, 3, 70, 75, 81, 0, 34,
                                  19, 14, 7, 12, 1, 68, 70, 73, 62, 96, 92, 85,
                                  89, 87, 85, 83, 81, 80, 79, 77, 73, 80, 81,
                                  85, 88, 5, 85, 80, 79, 76, 74, 74, 71, 71, 69,
                                  71, 70, 77, 68, 68, 10, 69, 77, 66, 68, 71,
                                  64, 65, 67, 73, 64, 66, 72, 73, 2, 86, 70, 10,
                                  70, 1, 69, 67, 65, 3, 0, 67, 66, 74, 74, 76,
                                  53, 50, 52, 47, 43, 47, 47, 44, 42, 40, 43,
                                  41, 31, 23, 8, 35, 32, 28, 19, 22, 17, 10, 16,
                                  9, 5, 65, 69, 74, 79, 30, 27, 30, 18, 2, 9, 5,
                                  68, 5, 66, 70, 86, 77, 84, 90, 8, 11, 73, 7,
                                  10, 0, 71, 71, 72, 82, 72, 79, 82, 101, 81,
                                  86, 95, 2, 76, 84, 73, 0, 4, 5, 13, 9, 16, 0,
                                  12, 11, 18, 21, 24, 24, 11, 53, 32, 25, 19,
                                  11, 9, 73, 80, 91, 5, 36, 30, 30, 21, 21, 11,
                                  9, 4, 65, 73, 0, 4, 5, 13, 9, 16, 0, 12, 11,
                                  18, 21, 24, 24, 11, 53, 32, 25, 19, 11, 9, 73,
                                  80, 91 },

                                {

                                50,
                                  7, 78, 50, 7, 78, 86, 70, 19, 11, 2, 6, 28,
                                  43, 27, 6, 3, 10, 79, 67, 64, 65, 15, 77, 68,
                                  25, 22, 77, 95, 114, 81, 85, 71, 79, 67, 64,
                                  84, 67, 28, 3, 73, 81, 85, 84, 86, 89, 104,
                                  64, 77, 87, 70, 83, 85, 99, 4, 73, 72, 79, 24,
                                  2, 22, 0, 0, 0, 70, 91, 97, 2, 4, 66, 19, 75,
                                  98, 75, 66, 74, 15, 13, 71, 66, 82, 8, 77, 71,
                                  73, 95, 83, 86, 85, 17, 66, 1, 73, 71, 88, 75,
                                  83, 65, 76, 72, 86, 16, 72, 4, 79, 80, 70, 74,
                                  67, 2, 3, 66, 7, 6, 73, 1, 65, 68, 3, 72, 25,
                                  67, 1, 23, 22, 30, 27, 19, 87, 65, 67, 64, 67,
                                  82, 68, 13, 67, 68, 11, 30, 51, 35, 11, 87,
                                  87, 1, 36, 39, 109, 69, 5, 88, 12, 66, 0, 11,
                                  33, 55, 45, 20, 89, 90, 2, 18, 26, 95, 19, 21,
                                  19, 19, 21, 18, 11, 19, 19, 2, 9, 11, 4, 3,
                                  68, 8, 4, 1, 5, 2, 6, 8, 2, 85, 1, 1, 69, 2,
                                  74, 31, 41, 26, 19, 25, 29, 33, 31, 19, 69,
                                  80, 67, 0, 0, 104, 1, 5, 82, 20, 6, 6, 5, 7,
                                  0, 7, 9, 76, 93, 76, 78, 75, 92, 80, 13, 14,
                                  10, 4, 64, 70, 75, 76, 85, 69, 27, 14, 8, 1,
                                  9, 65, 70, 76, 73, 67, 27, 14, 9, 4, 9, 64,
                                  70, 74, 82, 73, 26, 11, 8, 4, 4, 70, 75, 80,
                                  1, 34, 20, 14, 7, 13, 2, 67, 70, 72, 62, 95,
                                  91, 84, 88, 86, 83, 82, 79, 78, 77, 75, 70,
                                  79, 80, 84, 87, 8, 84, 81, 78, 75, 73, 74, 71,
                                  71, 69, 70, 71, 78, 68, 68, 11, 69, 77, 66,
                                  68, 70, 65, 66, 67, 74, 65, 67, 72, 73, 3, 87,
                                  71, 11, 70, 0, 69, 67, 65, 2, 64, 67, 66, 74,
                                  74, 77, 52, 49, 51, 46, 40, 45, 44, 41, 39,
                                  37, 40, 38, 28, 21, 6, 31, 29, 24, 14, 19, 15,
                                  8, 14, 6, 3, 66, 70, 75, 79, 28, 24, 27, 16,
                                  0, 7, 4, 70, 3, 68, 72, 88, 79, 85, 92, 7, 10,
                                  75, 6, 9, 64, 73, 72, 73, 83, 73, 80, 82, 100,
                                  83, 87, 96, 0, 77, 85, 73, 1, 4, 6, 14, 10,
                                  16, 1, 13, 12, 19, 22, 25, 24, 11, 53, 30, 23,
                                  17, 9, 7, 76, 82, 92, 5, 37, 31, 30, 22, 22,
                                  12, 9, 4, 64, 73, 1, 4, 6, 14, 10, 16, 1, 13,
                                  12, 19, 22, 25, 24, 11, 53, 30, 23, 17, 9, 7,
                                  76, 82, 92 },

                                {

                                48,
                                  6, 78, 48, 6, 78, 85, 69, 19, 11, 2, 4, 26,
                                  42, 27, 6, 5, 8, 79, 66, 64, 66, 16, 78, 70,
                                  23, 20, 81, 97, 115, 79, 84, 71, 79, 66, 64,
                                  84, 67, 28, 2, 72, 80, 84, 85, 88, 90, 105,
                                  64, 77, 86, 70, 84, 85, 99, 4, 73, 72, 79, 24,
                                  2, 22, 0, 0, 0, 69, 92, 97, 2, 3, 66, 19, 74,
                                  97, 73, 65, 74, 17, 15, 71, 65, 80, 8, 76, 70,
                                  71, 96, 83, 87, 85, 17, 67, 1, 71, 71, 87, 74,
                                  82, 65, 76, 72, 86, 16, 72, 4, 78, 80, 70, 74,
                                  67, 2, 3, 65, 8, 6, 73, 0, 65, 68, 2, 72, 25,
                                  67, 1, 23, 22, 30, 27, 19, 88, 64, 66, 65, 67,
                                  82, 68, 14, 67, 68, 12, 31, 52, 37, 13, 88,
                                  88, 1, 36, 39, 110, 69, 5, 89, 12, 66, 0, 12,
                                  33, 55, 45, 21, 90, 89, 1, 15, 22, 94, 18, 21,
                                  19, 18, 20, 17, 11, 19, 18, 1, 8, 10, 4, 2,
                                  69, 7, 3, 0, 5, 1, 5, 7, 1, 86, 0, 0, 69, 0,
                                  75, 29, 39, 24, 17, 23, 26, 29, 29, 18, 71,
                                  83, 69, 66, 65, 106, 64, 4, 84, 19, 5, 5, 4,
                                  5, 65, 5, 7, 78, 93, 77, 79, 77, 91, 79, 14,
                                  15, 10, 4, 64, 69, 74, 75, 83, 68, 27, 14, 9,
                                  1, 10, 64, 69, 75, 71, 67, 27, 14, 9, 4, 9,
                                  64, 69, 74, 81, 73, 27, 12, 8, 4, 5, 69, 75,
                                  79, 2, 34, 21, 14, 7, 14, 2, 66, 69, 72, 62,
                                  94, 89, 82, 86, 85, 82, 80, 78, 77, 76, 73,
                                  68, 79, 79, 84, 86, 11, 84, 82, 78, 74, 73,
                                  74, 71, 71, 70, 70, 71, 79, 68, 68, 11, 69,
                                  77, 67, 68, 70, 65, 66, 68, 75, 66, 67, 73,
                                  73, 4, 88, 71, 11, 71, 0, 69, 68, 65, 2, 64,
                                  67, 65, 74, 74, 79, 51, 48, 50, 44, 38, 42,
                                  41, 38, 37, 34, 36, 35, 24, 18, 4, 27, 25, 20,
                                  9, 16, 13, 6, 11, 4, 1, 68, 72, 76, 79, 25,
                                  22, 25, 14, 66, 5, 2, 73, 1, 70, 74, 90, 82,
                                  87, 93, 5, 9, 78, 4, 7, 66, 75, 74, 75, 84,
                                  74, 81, 82, 99, 84, 89, 98, 64, 78, 86, 73, 1,
                                  5, 6, 15, 10, 17, 1, 14, 12, 20, 22, 25, 25,
                                  12, 52, 28, 21, 15, 7, 5, 78, 84, 94, 6, 37,
                                  31, 31, 22, 22, 12, 10, 4, 64, 73, 1, 5, 6,
                                  15, 10, 17, 1, 14, 12, 20, 22, 25, 25, 12, 52,
                                  28, 21, 15, 7, 5, 78, 84, 94 },

                                {

                                47,
                                  6, 78, 47, 6, 78, 83, 68, 20, 11, 2, 2, 24,
                                  42, 28, 6, 7, 7, 78, 64, 64, 66, 17, 78, 71,
                                  22, 18, 84, 99, 115, 77, 82, 70, 78, 64, 64,
                                  83, 66, 29, 2, 71, 79, 83, 86, 89, 90, 105,
                                  64, 77, 85, 70, 84, 85, 99, 4, 72, 71, 78, 24,
                                  2, 22, 0, 0, 0, 68, 92, 97, 2, 2, 66, 19, 73,
                                  95, 70, 64, 73, 19, 17, 70, 64, 78, 9, 74, 69,
                                  69, 97, 83, 87, 85, 18, 67, 2, 69, 71, 86, 73,
                                  80, 65, 75, 72, 85, 17, 72, 5, 77, 79, 69, 74,
                                  67, 3, 4, 64, 9, 6, 73, 0, 64, 67, 2, 72, 26,
                                  67, 1, 23, 23, 31, 27, 20, 88, 0, 65, 66, 67,
                                  82, 68, 15, 67, 67, 13, 32, 53, 39, 15, 89,
                                  89, 2, 36, 40, 111, 69, 5, 89, 13, 66, 0, 14,
                                  33, 55, 45, 22, 91, 88, 0, 13, 19, 92, 18, 21,
                                  19, 17, 20, 17, 11, 19, 18, 0, 7, 10, 4, 2,
                                  69, 7, 2, 0, 5, 1, 5, 6, 0, 87, 0, 0, 69, 64,
                                  75, 27, 37, 23, 16, 21, 24, 26, 27, 17, 73,
                                  85, 70, 68, 66, 107, 65, 3, 86, 18, 4, 4, 3,
                                  3, 66, 3, 5, 79, 93, 77, 80, 78, 89, 77, 16,
                                  16, 10, 4, 0, 68, 73, 74, 81, 67, 28, 15, 10,
                                  2, 11, 0, 68, 74, 69, 66, 28, 15, 10, 4, 10,
                                  0, 68, 73, 79, 72, 29, 13, 9, 4, 6, 68, 74,
                                  78, 3, 35, 22, 15, 8, 15, 3, 65, 68, 71, 62,
                                  92, 87, 80, 84, 84, 81, 78, 76, 75, 74, 71,
                                  66, 78, 78, 83, 85, 15, 84, 83, 78, 73, 72,
                                  73, 71, 71, 70, 70, 71, 80, 68, 68, 12, 69,
                                  77, 67, 68, 70, 65, 66, 68, 75, 67, 67, 73,
                                  72, 6, 88, 71, 12, 72, 0, 69, 68, 64, 2, 64,
                                  66, 64, 73, 73, 81, 50, 47, 49, 42, 36, 39,
                                  39, 35, 35, 32, 33, 33, 21, 15, 2, 23, 22, 17,
                                  4, 13, 11, 5, 9, 2, 0, 69, 73, 77, 79, 23, 20,
                                  23, 12, 68, 3, 1, 75, 64, 72, 76, 92, 84, 89,
                                  94, 4, 8, 80, 3, 5, 67, 77, 75, 76, 85, 75,
                                  81, 82, 98, 85, 90, 100, 65, 79, 87, 73, 2, 6,
                                  7, 17, 11, 18, 1, 15, 13, 21, 23, 26, 26, 13,
                                  51, 27, 19, 13, 5, 3, 80, 86, 95, 7, 37, 32,
                                  32, 23, 23, 13, 11, 5, 0, 73, 2, 6, 7, 17, 11,
                                  18, 1, 15, 13, 21, 23, 26, 26, 13, 51, 27, 19,
                                  13, 5, 3, 80, 86, 95 },

                                {

                                46,
                                  6, 78, 46, 6, 78, 81, 66, 20, 11, 1, 0, 23,
                                  41, 29, 6, 8, 5, 78, 0, 65, 66, 18, 79, 72,
                                  21, 16, 87, 102, 116, 75, 81, 70, 78, 0, 65,
                                  83, 65, 29, 2, 71, 78, 81, 87, 90, 90, 105,
                                  64, 76, 84, 71, 84, 85, 99, 4, 72, 71, 77, 25,
                                  2, 22, 0, 0, 0, 68, 92, 97, 3, 1, 66, 18, 73,
                                  94, 68, 0, 72, 20, 18, 69, 0, 76, 10, 73, 68,
                                  66, 97, 84, 87, 86, 18, 67, 3, 66, 70, 86, 73,
                                  78, 65, 75, 72, 85, 17, 72, 5, 76, 79, 68, 73,
                                  67, 3, 4, 0, 9, 6, 74, 0, 64, 67, 2, 72, 26,
                                  67, 1, 24, 23, 31, 27, 20, 89, 0, 65, 66, 67,
                                  81, 68, 16, 66, 67, 15, 34, 54, 40, 17, 89,
                                  90, 2, 37, 40, 112, 69, 6, 90, 14, 66, 0, 15,
                                  33, 55, 45, 24, 92, 86, 64, 10, 16, 91, 18,
                                  21, 18, 17, 19, 17, 10, 19, 17, 64, 6, 10, 4,
                                  2, 69, 6, 2, 64, 4, 1, 5, 5, 0, 88, 64, 64,
                                  69, 65, 76, 25, 35, 21, 14, 20, 22, 23, 24,
                                  16, 75, 87, 72, 70, 68, 108, 66, 2, 87, 17, 3,
                                  3, 1, 2, 68, 1, 4, 81, 93, 78, 81, 80, 88, 76,
                                  17, 16, 10, 4, 1, 67, 72, 74, 79, 65, 29, 16,
                                  10, 3, 13, 1, 66, 73, 66, 65, 28, 15, 10, 5,
                                  11, 1, 68, 72, 78, 72, 30, 14, 9, 4, 7, 68,
                                  74, 77, 4, 35, 23, 15, 8, 16, 4, 64, 68, 70,
                                  62, 91, 86, 79, 83, 83, 79, 77, 74, 74, 72,
                                  69, 0, 77, 77, 82, 84, 18, 83, 84, 77, 72, 71,
                                  73, 71, 71, 70, 69, 72, 81, 68, 68, 13, 69,
                                  77, 67, 68, 69, 66, 67, 68, 76, 68, 68, 73,
                                  72, 7, 89, 72, 13, 72, 64, 69, 68, 64, 1, 65,
                                  66, 64, 73, 73, 82, 49, 46, 48, 41, 33, 37,
                                  36, 32, 32, 29, 30, 30, 18, 13, 0, 19, 18, 13,
                                  64, 10, 9, 3, 7, 64, 65, 70, 74, 78, 79, 21,
                                  17, 20, 10, 70, 1, 64, 77, 66, 74, 78, 94, 86,
                                  90, 96, 3, 7, 82, 1, 4, 69, 79, 76, 77, 86,
                                  76, 82, 82, 97, 87, 91, 101, 67, 80, 88, 73,
                                  2, 6, 8, 18, 12, 18, 2, 16, 14, 22, 23, 27,
                                  26, 13, 51, 25, 17, 11, 3, 1, 83, 88, 96, 7,
                                  38, 32, 32, 24, 24, 13, 11, 5, 1, 73, 2, 6, 8,
                                  18, 12, 18, 2, 16, 14, 22, 23, 27, 26, 13, 51,
                                  25, 17, 11, 3, 1, 83, 88, 96 },

                                {

                                45,
                                  6, 79, 45, 6, 79, 79, 65, 21, 11, 1, 64, 21,
                                  40, 29, 7, 10, 4, 78, 2, 65, 67, 19, 80, 73,
                                  20, 15, 91, 104, 117, 73, 79, 70, 78, 2, 65,
                                  82, 64, 30, 2, 70, 77, 80, 89, 91, 90, 106,
                                  64, 76, 84, 71, 85, 84, 99, 3, 72, 71, 76, 25,
                                  2, 22, 0, 0, 0, 67, 92, 97, 3, 1, 67, 18, 72,
                                  93, 66, 1, 71, 22, 20, 68, 1, 74, 11, 72, 68,
                                  64, 98, 84, 87, 86, 19, 67, 4, 64, 70, 85, 72,
                                  76, 65, 75, 72, 85, 18, 73, 6, 76, 79, 67, 73,
                                  66, 3, 5, 1, 10, 6, 74, 0, 64, 67, 2, 72, 26,
                                  67, 1, 24, 23, 32, 28, 21, 89, 1, 64, 67, 67,
                                  81, 68, 17, 66, 66, 16, 35, 54, 42, 18, 90,
                                  91, 3, 37, 40, 112, 70, 6, 90, 14, 67, 1, 16,
                                  33, 55, 46, 25, 93, 85, 65, 7, 13, 89, 18, 21,
                                  18, 16, 19, 16, 10, 18, 17, 64, 6, 10, 3, 2,
                                  70, 6, 1, 65, 4, 1, 5, 5, 64, 90, 64, 65, 69,
                                  66, 76, 22, 33, 19, 13, 18, 20, 20, 22, 14,
                                  77, 89, 73, 72, 70, 110, 67, 0, 89, 15, 2, 2,
                                  0, 0, 70, 64, 2, 82, 93, 79, 82, 81, 86, 74,
                                  19, 17, 10, 4, 2, 67, 72, 73, 78, 64, 30, 17,
                                  11, 3, 14, 2, 65, 72, 64, 65, 29, 16, 11, 5,
                                  12, 1, 67, 71, 77, 72, 32, 15, 9, 4, 7, 67,
                                  74, 77, 4, 36, 23, 16, 8, 17, 4, 64, 67, 70,
                                  62, 89, 84, 77, 81, 81, 78, 75, 73, 72, 70,
                                  67, 2, 77, 76, 82, 84, 21, 83, 85, 77, 72, 70,
                                  73, 71, 71, 70, 69, 72, 82, 68, 68, 13, 69,
                                  77, 67, 68, 69, 66, 67, 68, 77, 69, 68, 73,
                                  72, 8, 90, 72, 14, 73, 64, 69, 68, 0, 1, 65,
                                  65, 0, 73, 73, 84, 48, 45, 47, 39, 31, 34, 34,
                                  29, 30, 26, 27, 27, 15, 10, 65, 16, 15, 9, 69,
                                  8, 6, 1, 5, 66, 67, 71, 75, 79, 79, 19, 15,
                                  18, 8, 72, 0, 65, 79, 68, 77, 80, 96, 88, 92,
                                  97, 2, 5, 84, 0, 2, 70, 81, 78, 79, 87, 77,
                                  83, 83, 96, 88, 93, 103, 68, 82, 89, 72, 3, 7,
                                  8, 19, 13, 19, 2, 17, 15, 23, 24, 28, 27, 14,
                                  50, 23, 15, 9, 1, 64, 85, 90, 97, 8, 38, 33,
                                  33, 24, 25, 14, 12, 6, 1, 72, 3, 7, 8, 19, 13,
                                  19, 2, 17, 15, 23, 24, 28, 27, 14, 50, 23, 15,
                                  9, 1, 64, 85, 90, 97 },

                                {

                                43,
                                  6, 79, 43, 6, 79, 78, 0, 21, 11, 0, 66, 20,
                                  39, 30, 7, 12, 2, 78, 3, 65, 67, 20, 81, 75,
                                  18, 13, 94, 106, 118, 71, 78, 70, 78, 3, 65,
                                  82, 0, 30, 1, 69, 76, 79, 90, 93, 91, 106, 64,
                                  76, 83, 71, 85, 84, 99, 3, 72, 71, 76, 26, 2,
                                  22, 0, 0, 0, 67, 93, 97, 4, 0, 67, 17, 72, 92,
                                  64, 2, 70, 23, 21, 68, 2, 72, 12, 71, 67, 1,
                                  99, 84, 87, 86, 19, 68, 5, 1, 70, 84, 71, 74,
                                  65, 75, 72, 85, 18, 73, 6, 75, 79, 67, 73, 66,
                                  3, 5, 2, 10, 6, 74, 64, 64, 67, 2, 72, 26, 67,
                                  1, 25, 23, 32, 28, 21, 90, 1, 0, 67, 67, 81,
                                  68, 18, 66, 66, 17, 36, 55, 43, 20, 90, 92, 3,
                                  37, 40, 113, 70, 7, 91, 15, 67, 1, 17, 33, 55,
                                  46, 26, 94, 83, 66, 4, 10, 88, 17, 21, 17, 15,
                                  18, 16, 9, 18, 16, 65, 5, 9, 3, 2, 70, 5, 0,
                                  66, 3, 0, 4, 4, 64, 91, 65, 66, 69, 68, 77,
                                  20, 31, 17, 11, 16, 18, 16, 19, 13, 79, 92,
                                  75, 74, 72, 111, 69, 64, 91, 14, 1, 1, 64, 64,
                                  72, 66, 0, 84, 93, 80, 83, 83, 85, 73, 20, 17,
                                  10, 4, 3, 66, 71, 72, 76, 0, 31, 17, 12, 4,
                                  15, 3, 0, 71, 1, 64, 29, 16, 11, 6, 13, 2, 67,
                                  71, 76, 72, 33, 16, 9, 4, 8, 67, 74, 76, 5,
                                  36, 24, 16, 8, 18, 5, 0, 67, 69, 62, 88, 83,
                                  76, 79, 80, 76, 74, 71, 71, 69, 65, 4, 76, 75,
                                  81, 83, 24, 83, 86, 77, 71, 70, 73, 71, 71,
                                  71, 68, 72, 83, 68, 68, 14, 69, 77, 67, 68,
                                  69, 67, 67, 68, 78, 70, 68, 73, 72, 9, 91, 72,
                                  14, 74, 64, 69, 68, 0, 1, 66, 65, 1, 73, 73,
                                  85, 47, 44, 46, 37, 29, 32, 31, 26, 27, 23,
                                  23, 24, 11, 7, 67, 12, 11, 5, 74, 5, 4, 64, 3,
                                  69, 69, 73, 76, 80, 79, 16, 13, 16, 6, 74, 65,
                                  67, 81, 70, 79, 82, 98, 91, 94, 98, 1, 4, 87,
                                  65, 0, 72, 83, 79, 80, 88, 78, 84, 83, 95, 89,
                                  94, 104, 69, 83, 90, 72, 3, 7, 9, 20, 13, 20,
                                  2, 18, 16, 24, 24, 29, 27, 15, 50, 21, 13, 7,
                                  64, 66, 87, 92, 99, 8, 39, 33, 34, 25, 25, 14,
                                  12, 6, 2, 72, 3, 7, 9, 20, 13, 20, 2, 18, 16,
                                  24, 24, 29, 27, 15, 50, 21, 13, 7, 64, 66, 87,
                                  92, 99 },

                                {

                                42,
                                  6, 79, 42, 6, 79, 76, 1, 21, 11, 0, 68, 18,
                                  38, 31, 7, 13, 0, 77, 5, 66, 67, 21, 82, 76,
                                  17, 11, 97, 109, 118, 69, 77, 70, 77, 5, 66,
                                  82, 1, 30, 1, 69, 75, 77, 91, 94, 91, 106, 64,
                                  75, 82, 72, 85, 84, 99, 3, 71, 71, 75, 26, 2,
                                  22, 0, 0, 0, 66, 93, 97, 4, 64, 67, 17, 71,
                                  90, 2, 3, 69, 25, 23, 67, 3, 70, 13, 70, 66,
                                  4, 99, 85, 87, 87, 19, 68, 6, 4, 69, 84, 71,
                                  72, 65, 75, 72, 84, 18, 73, 7, 74, 78, 66, 72,
                                  66, 4, 6, 3, 11, 6, 75, 64, 0, 67, 2, 72, 27,
                                  67, 1, 25, 24, 32, 28, 21, 90, 2, 0, 68, 67,
                                  80, 68, 19, 65, 65, 19, 38, 56, 45, 22, 91,
                                  93, 4, 38, 40, 114, 70, 7, 91, 16, 67, 1, 19,
                                  33, 55, 46, 28, 95, 82, 67, 2, 7, 87, 17, 21,
                                  17, 15, 18, 16, 9, 18, 16, 66, 4, 9, 3, 2, 70,
                                  5, 0, 67, 3, 0, 4, 3, 65, 92, 66, 66, 69, 69,
                                  77, 18, 29, 16, 10, 15, 16, 13, 17, 12, 81,
                                  94, 76, 76, 74, 112, 70, 65, 92, 13, 0, 0, 66,
                                  66, 74, 68, 64, 85, 93, 81, 84, 85, 83, 71,
                                  21, 18, 10, 4, 4, 65, 70, 72, 74, 2, 32, 18,
                                  12, 5, 17, 4, 1, 70, 4, 0, 30, 17, 12, 6, 14,
                                  3, 66, 70, 75, 71, 34, 17, 9, 4, 9, 66, 73,
                                  75, 6, 36, 25, 16, 8, 19, 6, 1, 66, 68, 62,
                                  87, 81, 74, 78, 79, 75, 72, 69, 69, 67, 0, 7,
                                  75, 74, 80, 82, 27, 82, 87, 76, 70, 69, 73,
                                  71, 71, 71, 68, 73, 84, 68, 68, 15, 69, 77,
                                  67, 68, 68, 67, 68, 68, 79, 71, 69, 73, 72,
                                  10, 91, 73, 15, 74, 65, 69, 68, 0, 0, 66, 65,
                                  1, 73, 73, 87, 46, 43, 45, 36, 26, 29, 28, 23,
                                  25, 20, 20, 21, 8, 5, 69, 8, 8, 1, 79, 2, 2,
                                  65, 1, 71, 71, 74, 77, 81, 79, 14, 10, 13, 4,
                                  76, 67, 68, 83, 72, 81, 84, 100, 93, 95, 100,
                                  0, 3, 89, 66, 64, 73, 85, 80, 81, 89, 79, 85,
                                  83, 94, 91, 95, 106, 71, 84, 91, 72, 4, 8, 10,
                                  21, 14, 20, 3, 19, 17, 25, 25, 30, 28, 15, 49,
                                  19, 11, 5, 66, 68, 90, 94, 100, 9, 39, 34, 34,
                                  26, 26, 15, 13, 6, 3, 72, 4, 8, 10, 21, 14,
                                  20, 3, 19, 17, 25, 25, 30, 28, 15, 49, 19, 11,
                                  5, 66, 68, 90, 94, 100 },

                                {

                                41,
                                  6, 79, 41, 6, 79, 74, 3, 22, 11, 64, 70, 17,
                                  37, 31, 7, 15, 64, 77, 6, 66, 68, 22, 83, 77,
                                  16, 9, 101, 111, 119, 67, 75, 70, 77, 6, 66,
                                  81, 2, 31, 1, 68, 74, 76, 92, 95, 91, 107, 64,
                                  75, 81, 72, 86, 84, 99, 3, 71, 71, 74, 27, 2,
                                  22, 0, 0, 0, 66, 93, 97, 5, 65, 67, 16, 71,
                                  89, 4, 4, 68, 26, 24, 66, 4, 68, 14, 69, 65,
                                  6, 100, 85, 87, 87, 20, 68, 7, 6, 69, 83, 70,
                                  70, 65, 75, 72, 84, 19, 73, 7, 73, 78, 65, 72,
                                  66, 4, 6, 4, 11, 6, 75, 64, 0, 67, 2, 72, 27,
                                  67, 1, 26, 24, 33, 28, 22, 91, 2, 1, 68, 67,
                                  80, 68, 20, 65, 65, 20, 39, 57, 46, 24, 91,
                                  94, 4, 38, 40, 115, 70, 8, 92, 16, 67, 1, 20,
                                  33, 55, 46, 29, 96, 80, 68, 64, 4, 85, 17, 21,
                                  16, 14, 17, 15, 8, 18, 15, 67, 3, 9, 3, 2, 71,
                                  4, 64, 68, 2, 0, 4, 2, 65, 93, 66, 67, 69, 70,
                                  78, 16, 27, 14, 8, 13, 14, 10, 14, 11, 83, 96,
                                  78, 78, 76, 114, 71, 66, 94, 12, 64, 64, 67,
                                  67, 76, 70, 66, 87, 93, 82, 85, 86, 82, 70,
                                  23, 18, 10, 4, 5, 64, 69, 71, 72, 3, 33, 19,
                                  13, 5, 18, 5, 3, 69, 6, 0, 30, 17, 12, 7, 15,
                                  3, 66, 69, 74, 71, 36, 18, 9, 4, 10, 66, 73,
                                  74, 7, 37, 26, 17, 8, 20, 6, 2, 66, 68, 62,
                                  85, 80, 73, 76, 78, 73, 71, 68, 68, 65, 2, 9,
                                  75, 73, 80, 81, 30, 82, 88, 76, 69, 68, 73,
                                  71, 71, 71, 67, 73, 85, 68, 68, 15, 69, 77,
                                  67, 68, 68, 68, 68, 68, 80, 72, 69, 73, 72,
                                  11, 92, 73, 16, 75, 65, 69, 68, 1, 0, 67, 64,
                                  2, 73, 73, 88, 45, 42, 44, 34, 24, 27, 26, 20,
                                  22, 17, 17, 18, 5, 2, 71, 4, 4, 66, 84, 64, 0,
                                  67, 64, 74, 73, 75, 78, 82, 79, 12, 8, 11, 2,
                                  78, 69, 70, 85, 74, 83, 86, 102, 95, 97, 101,
                                  64, 2, 91, 68, 66, 75, 87, 82, 83, 90, 80, 86,
                                  83, 93, 92, 97, 107, 72, 85, 92, 72, 4, 8, 10,
                                  22, 15, 21, 3, 20, 18, 26, 25, 31, 28, 16, 49,
                                  17, 9, 3, 68, 70, 92, 96, 101, 9, 40, 34, 35,
                                  26, 27, 15, 13, 7, 3, 72, 4, 8, 10, 22, 15,
                                  21, 3, 20, 18, 26, 25, 31, 28, 16, 49, 17, 9,
                                  3, 68, 70, 92, 96, 101 },

                                {

                                40,
                                  6, 79, 40, 6, 79, 72, 4, 22, 11, 64, 72, 15,
                                  36, 32, 7, 17, 66, 77, 8, 66, 68, 23, 84, 78,
                                  15, 7, 104, 113, 120, 65, 74, 70, 77, 8, 66,
                                  81, 3, 31, 1, 67, 73, 75, 93, 96, 91, 107, 64,
                                  75, 80, 72, 86, 84, 99, 3, 71, 71, 73, 27, 2,
                                  22, 0, 0, 0, 65, 93, 97, 5, 66, 67, 16, 70,
                                  88, 6, 5, 67, 28, 26, 65, 5, 66, 15, 68, 64,
                                  8, 101, 85, 87, 87, 20, 68, 8, 8, 69, 82, 69,
                                  68, 65, 75, 72, 84, 19, 73, 8, 72, 78, 64, 72,
                                  66, 4, 7, 5, 12, 6, 75, 64, 0, 67, 2, 72, 27,
                                  67, 1, 26, 24, 33, 28, 22, 91, 3, 2, 69, 67,
                                  80, 68, 21, 65, 64, 21, 40, 58, 48, 26, 92,
                                  95, 5, 38, 40, 116, 70, 8, 92, 17, 67, 1, 21,
                                  33, 55, 46, 30, 97, 79, 69, 67, 1, 84, 17, 21,
                                  16, 13, 17, 15, 8, 18, 15, 68, 2, 9, 3, 2, 71,
                                  4, 65, 69, 2, 0, 4, 1, 66, 94, 67, 68, 69, 71,
                                  78, 14, 25, 12, 7, 11, 12, 7, 12, 10, 85, 98,
                                  79, 80, 78, 115, 72, 67, 96, 11, 65, 65, 68,
                                  69, 78, 72, 68, 88, 93, 83, 86, 88, 80, 68,
                                  24, 19, 10, 4, 6, 0, 68, 70, 70, 4, 34, 20,
                                  14, 6, 19, 6, 4, 68, 8, 1, 31, 18, 13, 7, 16,
                                  4, 65, 68, 73, 71, 37, 19, 9, 4, 11, 65, 73,
                                  73, 8, 37, 27, 17, 8, 21, 7, 3, 65, 67, 62,
                                  84, 78, 71, 74, 77, 72, 69, 66, 66, 0, 4, 11,
                                  74, 72, 79, 80, 33, 82, 89, 76, 68, 67, 73,
                                  71, 71, 71, 67, 73, 86, 68, 68, 16, 69, 77,
                                  67, 68, 68, 68, 68, 68, 81, 73, 69, 73, 72,
                                  12, 93, 73, 17, 76, 65, 69, 68, 1, 0, 67, 64,
                                  3, 73, 73, 90, 44, 41, 43, 32, 22, 24, 23, 17,
                                  20, 14, 14, 15, 2, 64, 73, 0, 1, 70, 89, 67,
                                  65, 69, 66, 76, 75, 76, 79, 83, 79, 10, 6, 9,
                                  0, 80, 71, 71, 87, 76, 85, 88, 104, 97, 99,
                                  102, 65, 1, 93, 69, 68, 76, 89, 83, 84, 91,
                                  81, 87, 83, 92, 93, 98, 109, 73, 86, 93, 72,
                                  5, 9, 11, 23, 16, 22, 3, 21, 19, 27, 26, 32,
                                  29, 17, 48, 15, 7, 1, 70, 72, 94, 98, 102, 10,
                                  40, 35, 36, 27, 28, 16, 14, 7, 4, 72, 5, 9,
                                  11, 23, 16, 22, 3, 21, 19, 27, 26, 32, 29, 17,
                                  48, 15, 7, 1, 70, 72, 94, 98, 102 },

                                {

                                38,
                                  5, 80, 38, 5, 80, 71, 5, 22, 11, 65, 74, 13,
                                  35, 32, 7, 18, 68, 77, 9, 67, 69, 24, 85, 80,
                                  13, 5, 108, 116, 121, 0, 73, 70, 77, 9, 67,
                                  81, 3, 31, 0, 67, 73, 74, 95, 98, 92, 108, 65,
                                  75, 80, 73, 87, 84, 99, 2, 71, 71, 73, 27, 1,
                                  22, 0, 0, 0, 65, 94, 97, 5, 67, 68, 15, 70,
                                  87, 8, 6, 67, 29, 27, 65, 6, 65, 15, 67, 64,
                                  10, 102, 86, 88, 88, 20, 69, 8, 10, 69, 82,
                                  69, 67, 65, 75, 72, 84, 19, 74, 8, 72, 78, 64,
                                  72, 66, 4, 7, 6, 12, 6, 76, 65, 0, 67, 1, 72,
                                  27, 67, 1, 26, 24, 33, 28, 22, 92, 3, 2, 70,
                                  67, 80, 69, 21, 65, 64, 22, 41, 58, 49, 27,
                                  93, 97, 5, 38, 40, 117, 71, 8, 93, 17, 68, 1,
                                  22, 33, 54, 46, 31, 98, 78, 71, 70, 66, 83,
                                  16, 21, 15, 12, 16, 14, 7, 17, 14, 69, 1, 8,
                                  2, 1, 72, 3, 66, 70, 1, 64, 3, 0, 67, 96, 68,
                                  69, 69, 73, 79, 11, 22, 10, 5, 9, 9, 3, 9, 8,
                                  87, 101, 81, 83, 80, 117, 74, 69, 98, 9, 66,
                                  66, 70, 71, 80, 74, 70, 90, 93, 84, 87, 90,
                                  79, 67, 25, 19, 10, 4, 6, 0, 68, 70, 69, 5,
                                  34, 20, 14, 6, 20, 7, 5, 68, 10, 1, 31, 18,
                                  13, 7, 16, 4, 65, 68, 72, 71, 38, 20, 9, 3,
                                  11, 65, 73, 73, 8, 37, 27, 17, 8, 22, 7, 3,
                                  65, 67, 62, 83, 77, 70, 73, 76, 71, 68, 65,
                                  65, 1, 5, 13, 74, 72, 79, 80, 36, 82, 91, 76,
                                  68, 67, 73, 71, 71, 72, 67, 74, 87, 69, 68,
                                  16, 70, 77, 68, 68, 68, 69, 69, 69, 82, 74,
                                  70, 74, 72, 13, 94, 74, 17, 77, 66, 69, 69, 1,
                                  64, 68, 64, 3, 73, 73, 92, 42, 40, 41, 30, 19,
                                  21, 20, 14, 17, 11, 10, 12, 65, 67, 75, 67,
                                  66, 74, 95, 70, 68, 71, 69, 79, 77, 78, 81,
                                  84, 79, 7, 3, 6, 65, 83, 73, 73, 90, 78, 88,
                                  90, 107, 100, 101, 104, 67, 64, 96, 71, 70,
                                  78, 91, 85, 86, 92, 82, 88, 84, 91, 95, 100,
                                  111, 75, 88, 95, 72, 5, 9, 11, 24, 16, 22, 3,
                                  22, 19, 28, 26, 32, 29, 17, 47, 13, 5, 65, 73,
                                  74, 97, 100, 104, 10, 40, 35, 36, 27, 28, 16,
                                  14, 7, 4, 72, 5, 9, 11, 24, 16, 22, 3, 22, 19,
                                  28, 26, 32, 29, 17, 47, 13, 5, 65, 73, 74, 97,
                                  100, 104 },

                                {

                                37,
                                  5, 80, 37, 5, 80, 69, 7, 23, 12, 65, 75, 12,
                                  35, 33, 8, 20, 69, 76, 11, 67, 69, 26, 85, 81,
                                  12, 4, 111, 118, 121, 2, 71, 69, 76, 11, 67,
                                  80, 4, 32, 0, 66, 72, 72, 96, 99, 92, 108, 65,
                                  74, 79, 73, 87, 83, 98, 2, 70, 70, 72, 28, 1,
                                  22, 0, 0, 0, 64, 94, 97, 6, 67, 68, 15, 69,
                                  85, 11, 8, 66, 31, 29, 64, 8, 0, 16, 65, 0,
                                  13, 102, 86, 88, 88, 21, 69, 9, 13, 68, 81,
                                  68, 65, 65, 74, 72, 83, 20, 74, 9, 71, 77, 0,
                                  71, 65, 5, 8, 7, 13, 7, 76, 65, 1, 66, 1, 71,
                                  28, 66, 1, 27, 25, 34, 29, 23, 92, 4, 3, 70,
                                  67, 79, 69, 22, 64, 0, 24, 43, 59, 51, 29, 93,
                                  98, 6, 39, 41, 117, 71, 9, 93, 18, 68, 2, 24,
                                  33, 54, 47, 33, 99, 76, 72, 72, 69, 81, 16,
                                  21, 15, 12, 16, 14, 7, 17, 14, 69, 1, 8, 2, 1,
                                  72, 3, 66, 70, 1, 64, 3, 0, 67, 97, 68, 69,
                                  69, 74, 79, 9, 20, 9, 4, 8, 7, 0, 7, 7, 88,
                                  103, 82, 85, 81, 118, 75, 70, 99, 8, 66, 66,
                                  71, 72, 81, 75, 71, 91, 93, 84, 87, 91, 77,
                                  65, 27, 20, 10, 4, 7, 1, 67, 69, 67, 7, 35,
                                  21, 15, 7, 22, 8, 7, 67, 13, 2, 32, 19, 14, 8,
                                  17, 5, 64, 67, 70, 70, 40, 21, 10, 3, 12, 64,
                                  72, 72, 9, 38, 28, 18, 9, 23, 8, 4, 64, 66,
                                  62, 81, 75, 68, 71, 74, 69, 66, 0, 0, 3, 7,
                                  16, 73, 71, 78, 79, 40, 81, 92, 75, 67, 66,
                                  72, 71, 70, 72, 66, 74, 87, 69, 68, 17, 70,
                                  77, 68, 68, 67, 69, 69, 69, 82, 74, 70, 74,
                                  71, 15, 94, 74, 18, 77, 66, 69, 69, 2, 64, 68,
                                  0, 4, 72, 72, 93, 41, 39, 40, 29, 17, 19, 18,
                                  11, 15, 9, 7, 10, 68, 69, 77, 70, 69, 77, 100,
                                  72, 70, 72, 71, 81, 78, 79, 82, 84, 79, 5, 1,
                                  4, 67, 85, 74, 74, 92, 79, 90, 91, 109, 102,
                                  102, 105, 68, 65, 98, 72, 71, 79, 92, 86, 87,
                                  93, 82, 88, 84, 90, 96, 101, 112, 76, 89, 96,
                                  71, 6, 10, 12, 26, 17, 23, 4, 24, 20, 29, 27,
                                  33, 30, 18, 47, 12, 4, 67, 75, 75, 99, 101,
                                  105, 11, 41, 36, 37, 28, 29, 17, 15, 8, 5, 71,
                                  6, 10, 12, 26, 17, 23, 4, 24, 20, 29, 27, 33,
                                  30, 18, 47, 12, 4, 67, 75, 75, 99, 101, 105 },

                                {

                                36,
                                  5, 80, 36, 5, 80, 67, 8, 23, 12, 65, 77, 10,
                                  34, 34, 8, 22, 71, 76, 12, 67, 69, 27, 86, 82,
                                  11, 2, 114, 120, 122, 4, 70, 69, 76, 12, 67,
                                  80, 5, 32, 0, 65, 71, 71, 97, 100, 92, 108,
                                  65, 74, 78, 73, 87, 83, 98, 2, 70, 70, 71, 28,
                                  1, 22, 0, 0, 0, 0, 94, 97, 6, 68, 68, 15, 68,
                                  84, 13, 9, 65, 33, 31, 0, 9, 2, 17, 64, 1, 15,
                                  103, 86, 88, 88, 21, 69, 10, 15, 68, 80, 67,
                                  0, 65, 74, 72, 83, 20, 74, 9, 70, 77, 1, 71,
                                  65, 5, 8, 8, 14, 7, 76, 65, 1, 66, 1, 71, 28,
                                  66, 1, 27, 25, 34, 29, 23, 93, 5, 4, 71, 67,
                                  79, 69, 23, 64, 0, 25, 44, 60, 53, 31, 94, 99,
                                  6, 39, 41, 118, 71, 9, 94, 19, 68, 2, 25, 33,
                                  54, 47, 34, 100, 75, 73, 75, 72, 80, 16, 21,
                                  15, 11, 15, 14, 7, 17, 13, 70, 0, 8, 2, 1, 72,
                                  2, 67, 71, 1, 64, 3, 64, 68, 98, 69, 70, 69,
                                  75, 80, 7, 18, 7, 2, 6, 5, 66, 5, 6, 90, 105,
                                  84, 87, 83, 119, 76, 71, 101, 7, 67, 67, 72,
                                  74, 83, 77, 73, 93, 93, 85, 88, 93, 76, 64,
                                  28, 21, 10, 4, 8, 2, 66, 68, 65, 8, 36, 22,
                                  16, 8, 23, 9, 8, 66, 15, 3, 32, 19, 14, 8, 18,
                                  6, 0, 66, 69, 70, 41, 22, 10, 3, 13, 0, 72,
                                  71, 10, 38, 29, 18, 9, 24, 9, 5, 0, 65, 62,
                                  80, 73, 66, 69, 73, 68, 64, 2, 1, 5, 9, 18,
                                  72, 70, 77, 78, 43, 81, 93, 75, 66, 65, 72,
                                  71, 70, 72, 66, 74, 88, 69, 68, 18, 70, 77,
                                  68, 68, 67, 69, 69, 69, 83, 75, 70, 74, 71,
                                  16, 95, 74, 19, 78, 66, 69, 69, 2, 64, 68, 0,
                                  5, 72, 72, 95, 40, 38, 39, 27, 15, 16, 15, 8,
                                  13, 6, 4, 7, 71, 72, 79, 74, 73, 81, 105, 75,
                                  72, 74, 73, 83, 80, 80, 83, 85, 79, 3, 64, 2,
                                  69, 87, 76, 76, 94, 81, 92, 93, 111, 104, 104,
                                  106, 69, 66, 100, 74, 73, 81, 94, 87, 88, 94,
                                  83, 89, 84, 89, 97, 102, 114, 77, 90, 97, 71,
                                  6, 11, 13, 27, 18, 24, 4, 25, 21, 30, 27, 34,
                                  31, 19, 46, 10, 2, 69, 77, 77, 101, 103, 106,
                                  12, 41, 36, 38, 29, 30, 17, 16, 8, 6, 71, 6,
                                  11, 13, 27, 18, 24, 4, 25, 21, 30, 27, 34, 31,
                                  19, 46, 10, 2, 69, 77, 77, 101, 103, 106 },

                                {

                                35,
                                  5, 80, 35, 5, 80, 65, 10, 24, 12, 66, 79, 9,
                                  33, 34, 8, 24, 72, 76, 14, 67, 70, 28, 87, 83,
                                  10, 0, 118, 122, 123, 6, 68, 69, 76, 14, 67,
                                  79, 6, 33, 0, 64, 70, 70, 98, 101, 92, 109,
                                  65, 74, 77, 73, 88, 83, 98, 2, 70, 70, 70, 29,
                                  1, 22, 0, 0, 0, 0, 94, 97, 7, 69, 68, 14, 68,
                                  83, 15, 10, 64, 34, 32, 1, 10, 4, 18, 0, 2,
                                  17, 104, 86, 88, 88, 22, 69, 11, 17, 68, 79,
                                  66, 2, 65, 74, 72, 83, 21, 74, 10, 69, 77, 2,
                                  71, 65, 5, 9, 9, 14, 7, 76, 65, 1, 66, 1, 71,
                                  28, 66, 1, 28, 25, 35, 29, 24, 93, 5, 5, 71,
                                  67, 79, 69, 24, 64, 1, 26, 45, 61, 54, 33, 94,
                                  100, 7, 39, 41, 119, 71, 10, 94, 19, 68, 2,
                                  26, 33, 54, 47, 35, 101, 73, 74, 78, 75, 78,
                                  16, 21, 14, 10, 15, 13, 6, 17, 13, 71, 64, 8,
                                  2, 1, 73, 2, 68, 72, 0, 64, 3, 65, 68, 99, 69,
                                  71, 69, 76, 80, 5, 16, 5, 1, 4, 3, 69, 2, 5,
                                  92, 107, 85, 89, 85, 121, 77, 72, 103, 6, 68,
                                  68, 73, 75, 85, 79, 75, 94, 93, 86, 89, 94,
                                  74, 1, 30, 21, 10, 4, 9, 3, 65, 67, 0, 9, 37,
                                  23, 17, 8, 24, 10, 10, 65, 17, 3, 33, 20, 15,
                                  9, 19, 6, 0, 65, 68, 70, 43, 23, 10, 3, 14, 0,
                                  72, 70, 11, 39, 30, 19, 9, 25, 9, 6, 0, 65,
                                  62, 78, 72, 65, 67, 72, 66, 0, 3, 3, 7, 11,
                                  20, 72, 69, 77, 77, 46, 81, 94, 75, 65, 64,
                                  72, 71, 70, 72, 65, 74, 89, 69, 68, 18, 70,
                                  77, 68, 68, 67, 70, 69, 69, 84, 76, 70, 74,
                                  71, 17, 96, 74, 20, 79, 66, 69, 69, 3, 64, 69,
                                  1, 6, 72, 72, 96, 39, 37, 38, 25, 13, 14, 13,
                                  5, 10, 3, 1, 4, 74, 75, 81, 78, 76, 85, 110,
                                  78, 74, 76, 75, 86, 82, 81, 84, 86, 79, 1, 66,
                                  0, 71, 89, 78, 77, 96, 83, 94, 95, 113, 106,
                                  106, 107, 70, 67, 102, 75, 75, 82, 96, 89, 90,
                                  95, 84, 90, 84, 88, 98, 104, 115, 78, 91, 98,
                                  71, 7, 11, 13, 28, 19, 25, 4, 26, 22, 31, 28,
                                  35, 31, 20, 46, 8, 0, 71, 79, 79, 103, 105,
                                  107, 12, 42, 37, 39, 29, 31, 18, 16, 9, 6, 71,
                                  7, 11, 13, 28, 19, 25, 4, 26, 22, 31, 28, 35,
                                  31, 20, 46, 8, 0, 71, 79, 79, 103, 105, 107 },

                                {

                                33,
                                  5, 80, 33, 5, 80, 64, 11, 24, 12, 66, 81, 7,
                                  32, 35, 8, 25, 74, 76, 15, 68, 70, 29, 88, 85,
                                  8, 65, 121, 125, 124, 8, 67, 69, 76, 15, 68,
                                  79, 7, 33, 64, 64, 69, 68, 99, 103, 93, 109,
                                  65, 73, 76, 74, 88, 83, 98, 2, 70, 70, 70, 29,
                                  1, 22, 0, 0, 0, 1, 95, 97, 7, 70, 68, 14, 67,
                                  82, 17, 11, 0, 36, 34, 1, 11, 6, 19, 1, 3, 20,
                                  104, 87, 88, 89, 22, 70, 12, 20, 67, 79, 66,
                                  4, 65, 74, 72, 83, 21, 74, 10, 68, 77, 2, 70,
                                  65, 5, 9, 10, 15, 7, 77, 66, 1, 66, 1, 71, 28,
                                  66, 1, 28, 25, 35, 29, 24, 94, 6, 5, 72, 67,
                                  78, 69, 25, 0, 1, 28, 47, 62, 56, 35, 95, 101,
                                  7, 40, 41, 120, 71, 10, 95, 20, 68, 2, 27, 33,
                                  54, 47, 37, 102, 72, 75, 81, 78, 77, 15, 21,
                                  14, 10, 14, 13, 6, 17, 12, 72, 65, 7, 2, 1,
                                  73, 1, 68, 73, 0, 65, 2, 66, 69, 100, 70, 72,
                                  69, 78, 81, 3, 14, 3, 64, 3, 1, 73, 0, 4, 94,
                                  110, 87, 91, 87, 122, 79, 73, 104, 5, 69, 69,
                                  75, 77, 87, 81, 76, 96, 93, 87, 90, 96, 73, 2,
                                  31, 22, 10, 4, 10, 4, 64, 67, 2, 11, 38, 23,
                                  17, 9, 26, 11, 11, 64, 20, 4, 33, 20, 15, 9,
                                  20, 7, 1, 65, 67, 70, 44, 24, 10, 3, 15, 1,
                                  72, 69, 12, 39, 31, 19, 9, 26, 10, 7, 1, 64,
                                  62, 77, 70, 0, 66, 71, 65, 2, 5, 4, 8, 13, 23,
                                  71, 68, 76, 76, 49, 80, 95, 74, 64, 64, 72,
                                  71, 70, 73, 65, 75, 90, 69, 68, 19, 70, 77,
                                  68, 68, 66, 70, 70, 69, 85, 77, 71, 74, 71,
                                  18, 97, 75, 20, 79, 67, 69, 69, 3, 65, 69, 1,
                                  6, 72, 72, 98, 38, 36, 37, 24, 10, 11, 10, 2,
                                  8, 0, 66, 1, 78, 77, 83, 82, 80, 89, 115, 81,
                                  76, 78, 77, 88, 84, 83, 85, 87, 79, 65, 69,
                                  66, 73, 91, 80, 79, 98, 85, 96, 97, 115, 109,
                                  107, 109, 71, 68, 105, 77, 76, 84, 98, 90, 91,
                                  96, 85, 91, 84, 87, 100, 105, 117, 80, 92, 99,
                                  71, 7, 12, 14, 29, 19, 25, 5, 27, 23, 32, 28,
                                  36, 32, 20, 45, 6, 65, 73, 81, 81, 106, 107,
                                  109, 13, 42, 37, 39, 30, 31, 18, 17, 9, 7, 71,
                                  7, 12, 14, 29, 19, 25, 5, 27, 23, 32, 28, 36,
                                  32, 20, 45, 6, 65, 73, 81, 81, 106, 107, 109 },

                                {

                                32,
                                  5, 80, 32, 5, 80, 1, 13, 24, 12, 67, 83, 6,
                                  31, 36, 8, 27, 76, 75, 17, 68, 70, 30, 89, 86,
                                  7, 67, 124, 126, 124, 10, 66, 69, 75, 17, 68,
                                  79, 8, 33, 64, 0, 68, 67, 100, 104, 93, 109,
                                  65, 73, 75, 74, 88, 83, 98, 2, 69, 70, 69, 30,
                                  1, 22, 0, 0, 0, 1, 95, 97, 8, 71, 68, 13, 67,
                                  80, 20, 12, 1, 37, 35, 2, 12, 8, 20, 2, 4, 22,
                                  105, 87, 88, 89, 22, 70, 13, 22, 67, 78, 65,
                                  6, 65, 74, 72, 82, 21, 74, 11, 67, 76, 3, 70,
                                  65, 6, 10, 11, 15, 7, 77, 66, 2, 66, 1, 71,
                                  29, 66, 1, 29, 26, 35, 29, 24, 94, 6, 6, 72,
                                  67, 78, 69, 26, 0, 2, 29, 48, 62, 57, 37, 95,
                                  102, 8, 40, 41, 121, 71, 11, 95, 21, 68, 2,
                                  29, 33, 54, 47, 38, 103, 70, 76, 83, 81, 76,
                                  15, 21, 13, 9, 14, 13, 5, 17, 12, 73, 66, 7,
                                  2, 1, 73, 1, 69, 74, 64, 65, 2, 67, 69, 101,
                                  71, 72, 69, 79, 81, 1, 12, 2, 65, 1, 64, 76,
                                  66, 3, 96, 112, 88, 93, 89, 123, 80, 74, 106,
                                  4, 70, 70, 76, 78, 89, 83, 78, 97, 93, 88, 91,
                                  98, 71, 4, 32, 22, 10, 4, 11, 5, 0, 66, 4, 12,
                                  39, 24, 18, 10, 27, 12, 13, 0, 22, 5, 34, 21,
                                  16, 10, 21, 8, 1, 64, 66, 69, 45, 25, 10, 3,
                                  16, 1, 71, 68, 13, 39, 32, 19, 9, 27, 11, 8,
                                  1, 0, 62, 76, 69, 1, 64, 70, 0, 3, 7, 6, 10,
                                  15, 25, 70, 67, 75, 75, 52, 80, 96, 74, 0, 0,
                                  72, 71, 70, 73, 64, 75, 91, 69, 68, 20, 70,
                                  77, 68, 68, 66, 71, 70, 69, 86, 78, 71, 74,
                                  71, 19, 97, 75, 21, 80, 67, 69, 69, 3, 65, 70,
                                  1, 7, 72, 72, 99, 37, 35, 36, 22, 8, 9, 7, 64,
                                  5, 66, 69, 65, 81, 80, 85, 86, 83, 93, 120,
                                  84, 78, 79, 79, 91, 86, 84, 86, 88, 79, 67,
                                  71, 68, 75, 93, 82, 80, 100, 87, 98, 99, 117,
                                  111, 109, 110, 72, 69, 107, 78, 78, 85, 100,
                                  91, 92, 97, 86, 92, 84, 86, 101, 106, 118, 81,
                                  93, 100, 71, 8, 12, 15, 30, 20, 26, 5, 28, 24,
                                  33, 29, 37, 32, 21, 45, 4, 67, 75, 83, 83,
                                  108, 109, 110, 13, 43, 38, 40, 31, 32, 19, 17,
                                  9, 8, 71, 8, 12, 15, 30, 20, 26, 5, 28, 24,
                                  33, 29, 37, 32, 21, 45, 4, 67, 75, 83, 83,
                                  108, 109, 110 },

                                {

                                31,
                                  5, 81, 31, 5, 81, 3, 14, 25, 12, 67, 84, 4,
                                  30, 36, 9, 29, 77, 75, 18, 68, 71, 31, 90, 87,
                                  6, 68, 126, 126, 125, 12, 64, 69, 75, 18, 68,
                                  78, 9, 34, 64, 1, 67, 66, 102, 105, 93, 110,
                                  65, 73, 75, 74, 89, 82, 98, 1, 69, 70, 68, 30,
                                  1, 22, 0, 0, 0, 2, 95, 97, 8, 71, 69, 13, 66,
                                  79, 22, 13, 2, 39, 37, 3, 13, 10, 21, 3, 4,
                                  24, 106, 87, 88, 89, 23, 70, 14, 24, 67, 77,
                                  64, 8, 65, 74, 72, 82, 22, 75, 11, 67, 76, 4,
                                  70, 64, 6, 10, 12, 16, 7, 77, 66, 2, 66, 1,
                                  71, 29, 66, 1, 29, 26, 36, 30, 25, 95, 7, 7,
                                  73, 67, 78, 69, 27, 0, 2, 30, 49, 62, 59, 38,
                                  96, 103, 8, 40, 41, 121, 72, 11, 96, 21, 69,
                                  3, 30, 33, 54, 48, 39, 104, 69, 77, 86, 84,
                                  74, 15, 21, 13, 8, 13, 12, 5, 16, 11, 73, 66,
                                  7, 1, 1, 74, 0, 70, 75, 64, 65, 2, 67, 70,
                                  103, 71, 73, 69, 80, 82, 65, 10, 0, 67, 64,
                                  66, 79, 68, 1, 98, 114, 90, 95, 91, 125, 81,
                                  76, 108, 2, 71, 71, 77, 80, 91, 85, 80, 99,
                                  93, 89, 92, 99, 70, 5, 34, 23, 10, 4, 12, 5,
                                  0, 65, 5, 13, 40, 25, 19, 10, 28, 13, 14, 1,
                                  24, 5, 34, 21, 16, 10, 22, 8, 2, 0, 65, 69,
                                  47, 26, 10, 3, 16, 2, 71, 68, 13, 40, 32, 20,
                                  9, 28, 11, 8, 2, 0, 62, 74, 67, 3, 1, 68, 1,
                                  5, 8, 7, 12, 17, 27, 70, 66, 75, 75, 55, 80,
                                  97, 74, 0, 1, 72, 71, 70, 73, 64, 75, 92, 69,
                                  68, 20, 70, 77, 68, 68, 66, 71, 70, 69, 87,
                                  79, 71, 74, 71, 20, 98, 75, 22, 81, 67, 69,
                                  69, 4, 65, 70, 2, 8, 72, 72, 101, 36, 34, 35,
                                  20, 6, 6, 5, 67, 3, 69, 72, 68, 84, 83, 87,
                                  89, 87, 97, 125, 86, 81, 81, 81, 93, 88, 85,
                                  87, 89, 79, 69, 73, 70, 77, 95, 83, 82, 102,
                                  89, 101, 101, 119, 113, 111, 111, 73, 71, 109,
                                  80, 80, 87, 102, 93, 94, 98, 87, 93, 85, 85,
                                  102, 108, 120, 82, 95, 101, 70, 8, 13, 15, 31,
                                  21, 27, 5, 29, 25, 34, 29, 38, 33, 22, 44, 2,
                                  69, 77, 85, 85, 110, 111, 111, 14, 43, 38, 41,
                                  31, 33, 19, 18, 10, 8, 70, 8, 13, 15, 31, 21,
                                  27, 5, 29, 25, 34, 29, 38, 33, 22, 44, 2, 69,
                                  77, 85, 85, 110, 111, 111 },

                                {

                                30,
                                  5, 81, 30, 5, 81, 5, 16, 25, 12, 68, 86, 3,
                                  29, 37, 9, 30, 79, 75, 20, 69, 71, 32, 91, 88,
                                  5, 70, 126, 126, 126, 14, 0, 69, 75, 20, 69,
                                  78, 10, 34, 64, 1, 66, 64, 103, 106, 93, 110,
                                  65, 72, 74, 75, 89, 82, 98, 1, 69, 70, 67, 31,
                                  1, 22, 0, 0, 0, 2, 95, 97, 9, 72, 69, 12, 66,
                                  78, 24, 14, 3, 40, 38, 4, 14, 12, 22, 4, 5,
                                  27, 106, 88, 88, 90, 23, 70, 15, 27, 66, 77,
                                  64, 10, 65, 74, 72, 82, 22, 75, 12, 66, 76, 5,
                                  69, 64, 6, 11, 13, 16, 7, 78, 66, 2, 66, 1,
                                  71, 29, 66, 1, 30, 26, 36, 30, 25, 95, 7, 7,
                                  73, 67, 77, 69, 28, 1, 3, 32, 51, 62, 60, 40,
                                  96, 104, 9, 41, 41, 122, 72, 12, 96, 22, 69,
                                  3, 31, 33, 54, 48, 41, 105, 67, 78, 89, 87,
                                  73, 15, 21, 12, 8, 13, 12, 4, 16, 11, 74, 67,
                                  7, 1, 1, 74, 0, 70, 76, 65, 65, 2, 68, 70,
                                  104, 72, 74, 69, 81, 82, 67, 8, 65, 68, 65,
                                  68, 82, 71, 0, 100, 116, 91, 97, 93, 126, 82,
                                  77, 109, 1, 72, 72, 79, 81, 93, 87, 81, 100,
                                  93, 90, 93, 101, 68, 7, 35, 23, 10, 4, 13, 6,
                                  1, 65, 7, 15, 41, 26, 19, 11, 30, 14, 16, 2,
                                  27, 6, 35, 22, 17, 11, 23, 9, 2, 1, 64, 69,
                                  48, 27, 10, 3, 17, 2, 71, 67, 14, 40, 33, 20,
                                  9, 29, 12, 9, 2, 1, 62, 73, 66, 4, 2, 67, 3,
                                  6, 10, 9, 14, 19, 30, 69, 65, 74, 74, 58, 79,
                                  98, 73, 1, 2, 72, 71, 70, 73, 0, 76, 93, 69,
                                  68, 21, 70, 77, 68, 68, 65, 72, 71, 69, 88,
                                  80, 72, 74, 71, 21, 99, 76, 23, 81, 68, 69,
                                  69, 4, 66, 71, 2, 8, 72, 72, 102, 35, 33, 34,
                                  19, 3, 4, 2, 70, 0, 72, 75, 71, 87, 85, 89,
                                  93, 90, 101, 126, 89, 83, 83, 83, 96, 90, 86,
                                  88, 90, 79, 71, 76, 73, 79, 97, 85, 83, 104,
                                  91, 103, 103, 121, 115, 112, 113, 74, 72, 111,
                                  81, 81, 88, 104, 94, 95, 99, 88, 94, 85, 84,
                                  104, 109, 121, 84, 96, 102, 70, 9, 13, 16, 32,
                                  22, 27, 6, 30, 26, 35, 30, 39, 33, 22, 44, 0,
                                  71, 79, 87, 87, 113, 113, 112, 14, 44, 39, 41,
                                  32, 34, 20, 18, 10, 9, 70, 9, 13, 16, 32, 22,
                                  27, 6, 30, 26, 35, 30, 39, 33, 22, 44, 0, 71,
                                  79, 87, 87, 113, 113, 112 },

                                {

                                28,
                                  4, 81, 28, 4, 81, 6, 17, 25, 12, 68, 88, 1,
                                  28, 37, 9, 32, 81, 75, 21, 69, 72, 33, 92, 90,
                                  3, 72, 126, 126, 126, 16, 1, 69, 75, 21, 69,
                                  78, 10, 34, 65, 2, 65, 0, 104, 108, 94, 111,
                                  65, 72, 73, 75, 90, 82, 98, 1, 69, 70, 67, 31,
                                  1, 22, 0, 0, 0, 3, 96, 97, 9, 73, 69, 12, 65,
                                  77, 26, 15, 3, 42, 40, 4, 15, 14, 22, 5, 6,
                                  29, 107, 88, 89, 90, 23, 71, 15, 29, 66, 76,
                                  0, 11, 65, 74, 72, 82, 22, 75, 12, 65, 76, 5,
                                  69, 64, 6, 11, 14, 17, 7, 78, 67, 2, 66, 0,
                                  71, 29, 66, 1, 30, 26, 36, 30, 25, 96, 8, 8,
                                  74, 67, 77, 69, 29, 1, 3, 33, 52, 62, 62, 42,
                                  97, 105, 9, 41, 41, 123, 72, 12, 97, 22, 69,
                                  3, 32, 33, 54, 48, 42, 106, 66, 79, 92, 91,
                                  72, 14, 21, 12, 7, 12, 11, 4, 16, 10, 75, 68,
                                  6, 1, 0, 75, 64, 71, 77, 65, 66, 1, 69, 71,
                                  105, 73, 75, 69, 83, 83, 69, 6, 67, 70, 67,
                                  71, 86, 73, 64, 102, 119, 93, 100, 95, 126,
                                  84, 78, 111, 0, 73, 73, 80, 83, 95, 89, 83,
                                  102, 93, 91, 94, 103, 67, 8, 36, 24, 10, 4,
                                  13, 7, 2, 64, 9, 16, 41, 26, 20, 11, 31, 15,
                                  17, 3, 29, 6, 35, 22, 17, 11, 23, 9, 3, 1, 0,
                                  69, 49, 28, 10, 3, 18, 3, 71, 66, 15, 40, 34,
                                  20, 9, 30, 12, 10, 3, 1, 62, 72, 64, 6, 4, 66,
                                  4, 8, 11, 10, 15, 21, 32, 69, 64, 74, 73, 61,
                                  79, 99, 73, 2, 2, 72, 71, 70, 74, 0, 76, 94,
                                  69, 68, 21, 70, 77, 69, 68, 65, 72, 71, 70,
                                  89, 81, 72, 75, 71, 22, 100, 76, 23, 82, 68,
                                  69, 70, 4, 66, 71, 2, 9, 72, 72, 104, 34, 32,
                                  33, 17, 1, 1, 64, 73, 65, 75, 79, 74, 91, 88,
                                  91, 97, 94, 105, 126, 92, 85, 85, 86, 98, 92,
                                  88, 90, 91, 79, 74, 78, 75, 81, 100, 87, 85,
                                  107, 93, 105, 105, 123, 118, 114, 114, 76, 73,
                                  114, 83, 83, 90, 106, 96, 97, 100, 89, 95, 85,
                                  83, 105, 111, 123, 85, 97, 103, 70, 9, 14, 16,
                                  33, 22, 28, 6, 31, 26, 36, 30, 39, 34, 23, 43,
                                  65, 73, 81, 89, 89, 115, 115, 114, 15, 44, 39,
                                  42, 32, 34, 20, 19, 10, 9, 70, 9, 14, 16, 33,
                                  22, 28, 6, 31, 26, 36, 30, 39, 34, 23, 43, 65,
                                  73, 81, 89, 89, 115, 115, 114 },

                                {

                                27,
                                  4, 81, 27, 4, 81, 8, 18, 26, 12, 68, 90, 64,
                                  28, 38, 9, 34, 82, 74, 23, 69, 72, 34, 92, 91,
                                  2, 74, 126, 126, 126, 18, 3, 68, 74, 23, 69,
                                  77, 11, 35, 65, 3, 64, 1, 105, 109, 94, 111,
                                  65, 72, 72, 75, 90, 82, 98, 1, 68, 69, 66, 31,
                                  1, 22, 0, 0, 0, 4, 96, 97, 9, 74, 69, 12, 64,
                                  75, 29, 16, 4, 44, 42, 5, 16, 16, 23, 7, 7,
                                  31, 108, 88, 89, 90, 24, 71, 16, 31, 66, 75,
                                  1, 13, 65, 73, 72, 81, 23, 75, 13, 64, 75, 6,
                                  69, 64, 7, 12, 15, 18, 7, 78, 67, 3, 65, 0,
                                  71, 30, 66, 1, 30, 27, 37, 30, 26, 96, 9, 9,
                                  75, 67, 77, 69, 30, 1, 4, 34, 53, 62, 62, 44,
                                  98, 106, 10, 41, 42, 124, 72, 12, 97, 23, 69,
                                  3, 34, 33, 54, 48, 43, 107, 65, 80, 94, 94,
                                  70, 14, 21, 12, 6, 12, 11, 4, 16, 10, 76, 69,
                                  6, 1, 0, 75, 64, 72, 77, 65, 66, 1, 70, 72,
                                  106, 73, 75, 69, 84, 83, 71, 4, 68, 71, 69,
                                  73, 89, 75, 65, 104, 121, 94, 102, 96, 126,
                                  85, 79, 113, 64, 74, 74, 81, 85, 96, 91, 85,
                                  103, 93, 91, 95, 104, 65, 10, 38, 25, 10, 4,
                                  14, 8, 3, 0, 11, 17, 42, 27, 21, 12, 32, 16,
                                  18, 4, 31, 7, 36, 23, 18, 11, 24, 10, 4, 2, 2,
                                  68, 51, 29, 11, 3, 19, 4, 70, 65, 16, 41, 35,
                                  21, 10, 31, 13, 11, 4, 2, 62, 70, 1, 8, 6, 65,
                                  5, 10, 13, 12, 17, 23, 34, 68, 0, 73, 72, 62,
                                  79, 100, 73, 3, 3, 71, 71, 70, 74, 0, 76, 95,
                                  69, 68, 22, 70, 77, 69, 68, 65, 72, 71, 70,
                                  89, 82, 72, 75, 70, 24, 100, 76, 24, 83, 68,
                                  69, 70, 5, 66, 71, 3, 10, 71, 71, 106, 33, 31,
                                  32, 15, 64, 65, 66, 76, 67, 77, 82, 76, 94,
                                  91, 93, 101, 97, 108, 126, 95, 87, 86, 88,
                                  100, 93, 89, 91, 92, 79, 76, 80, 77, 83, 102,
                                  89, 86, 109, 95, 107, 107, 125, 120, 116, 115,
                                  77, 74, 116, 84, 85, 91, 108, 97, 98, 101, 90,
                                  95, 85, 82, 106, 112, 125, 86, 98, 104, 70,
                                  10, 15, 17, 35, 23, 29, 6, 32, 27, 37, 31, 40,
                                  35, 24, 42, 66, 75, 83, 91, 91, 117, 117, 115,
                                  16, 44, 40, 43, 33, 35, 21, 20, 11, 10, 70,
                                  10, 15, 17, 35, 23, 29, 6, 32, 27, 37, 31, 40,
                                  35, 24, 42, 66, 75, 83, 91, 91, 117, 117, 115 },

                                {

                                26,
                                  4, 81, 26, 4, 81, 10, 20, 26, 12, 69, 92, 65,
                                  27, 39, 9, 35, 84, 74, 24, 70, 72, 35, 93, 92,
                                  1, 76, 126, 126, 126, 20, 4, 68, 74, 24, 70,
                                  77, 12, 35, 65, 3, 0, 3, 106, 110, 94, 111,
                                  65, 71, 71, 76, 90, 82, 98, 1, 68, 69, 65, 32,
                                  1, 22, 0, 0, 0, 4, 96, 97, 10, 75, 69, 11, 64,
                                  74, 31, 17, 5, 45, 43, 6, 17, 18, 24, 8, 8,
                                  34, 108, 89, 89, 91, 24, 71, 17, 34, 65, 75,
                                  1, 15, 65, 73, 72, 81, 23, 75, 13, 0, 75, 7,
                                  68, 64, 7, 12, 16, 18, 7, 79, 67, 3, 65, 0,
                                  71, 30, 66, 1, 31, 27, 37, 30, 26, 97, 9, 9,
                                  75, 67, 76, 69, 31, 2, 4, 36, 55, 62, 62, 46,
                                  98, 107, 10, 42, 42, 125, 72, 13, 98, 24, 69,
                                  3, 35, 33, 54, 48, 45, 108, 0, 81, 97, 97, 69,
                                  14, 21, 11, 6, 11, 11, 3, 16, 9, 77, 70, 6, 1,
                                  0, 75, 65, 72, 78, 66, 66, 1, 71, 72, 107, 74,
                                  76, 69, 85, 84, 73, 2, 70, 73, 70, 75, 92, 78,
                                  66, 106, 123, 96, 104, 98, 126, 86, 80, 114,
                                  65, 75, 75, 83, 86, 98, 93, 86, 105, 93, 92,
                                  96, 106, 64, 11, 39, 25, 10, 4, 15, 9, 4, 0,
                                  13, 19, 43, 28, 21, 13, 34, 17, 20, 5, 34, 8,
                                  36, 23, 18, 12, 25, 11, 4, 3, 3, 68, 52, 30,
                                  11, 3, 20, 4, 70, 64, 17, 41, 36, 21, 10, 32,
                                  14, 12, 4, 3, 62, 69, 2, 9, 7, 64, 7, 11, 15,
                                  13, 19, 25, 37, 67, 1, 72, 71, 62, 78, 101,
                                  72, 4, 4, 71, 71, 70, 74, 1, 77, 96, 69, 68,
                                  23, 70, 77, 69, 68, 64, 73, 72, 70, 90, 83,
                                  73, 75, 70, 25, 101, 77, 25, 83, 69, 69, 70,
                                  5, 67, 72, 3, 10, 71, 71, 107, 32, 30, 31, 14,
                                  67, 67, 69, 79, 70, 80, 85, 79, 97, 93, 95,
                                  105, 101, 112, 126, 98, 89, 88, 90, 103, 95,
                                  90, 92, 93, 79, 78, 83, 80, 85, 104, 91, 88,
                                  111, 97, 109, 109, 126, 122, 117, 117, 78, 75,
                                  118, 86, 86, 93, 110, 98, 99, 102, 91, 96, 85,
                                  81, 108, 113, 126, 88, 99, 105, 70, 10, 15,
                                  18, 36, 24, 29, 7, 33, 28, 38, 31, 41, 35, 24,
                                  42, 68, 77, 85, 93, 93, 120, 119, 116, 16, 45,
                                  40, 43, 34, 36, 21, 20, 11, 11, 70, 10, 15,
                                  18, 36, 24, 29, 7, 33, 28, 38, 31, 41, 35, 24,
                                  42, 68, 77, 85, 93, 93, 120, 119, 116 },

                                {

                                25,
                                  4, 82, 25, 4, 82, 12, 21, 27, 12, 69, 93, 67,
                                  26, 39, 10, 37, 85, 74, 26, 70, 73, 36, 94,
                                  93, 0, 77, 126, 126, 126, 22, 6, 68, 74, 26,
                                  70, 76, 13, 36, 65, 4, 1, 4, 108, 111, 94,
                                  112, 65, 71, 71, 76, 91, 81, 98, 0, 68, 69,
                                  64, 32, 1, 22, 0, 0, 0, 5, 96, 97, 10, 75, 70,
                                  11, 0, 73, 33, 18, 6, 47, 45, 7, 18, 20, 25,
                                  9, 8, 36, 109, 89, 89, 91, 25, 71, 18, 36, 65,
                                  74, 2, 17, 65, 73, 72, 81, 24, 76, 14, 0, 75,
                                  8, 68, 0, 7, 13, 17, 19, 7, 79, 67, 3, 65, 0,
                                  71, 30, 66, 1, 31, 27, 38, 31, 27, 97, 10, 10,
                                  76, 67, 76, 69, 32, 2, 5, 37, 56, 62, 62, 47,
                                  99, 108, 11, 42, 42, 125, 73, 13, 98, 24, 70,
                                  4, 36, 33, 54, 49, 46, 109, 1, 82, 100, 100,
                                  67, 14, 21, 11, 5, 11, 10, 3, 15, 9, 77, 70,
                                  6, 0, 0, 76, 65, 73, 79, 66, 66, 1, 71, 73,
                                  109, 74, 77, 69, 86, 84, 76, 0, 72, 74, 72,
                                  77, 95, 80, 68, 108, 125, 97, 106, 100, 126,
                                  87, 82, 116, 67, 76, 76, 84, 88, 100, 95, 88,
                                  106, 93, 93, 97, 107, 1, 13, 41, 26, 10, 4,
                                  16, 9, 4, 1, 14, 20, 44, 29, 22, 13, 35, 18,
                                  21, 6, 36, 8, 37, 24, 19, 12, 26, 11, 5, 4, 4,
                                  68, 54, 31, 11, 3, 20, 5, 70, 64, 17, 42, 36,
                                  22, 10, 33, 14, 12, 5, 3, 62, 67, 4, 11, 9, 1,
                                  8, 13, 16, 15, 21, 27, 39, 67, 2, 72, 71, 62,
                                  78, 102, 72, 4, 5, 71, 71, 70, 74, 1, 77, 97,
                                  69, 68, 23, 70, 77, 69, 68, 64, 73, 72, 70,
                                  91, 84, 73, 75, 70, 26, 102, 77, 26, 84, 69,
                                  69, 70, 6, 67, 72, 4, 11, 71, 71, 109, 31, 29,
                                  30, 12, 69, 70, 71, 82, 72, 83, 88, 82, 100,
                                  96, 97, 108, 104, 116, 126, 100, 92, 90, 92,
                                  105, 97, 91, 93, 94, 79, 80, 85, 82, 87, 106,
                                  92, 89, 113, 99, 112, 111, 126, 124, 119, 118,
                                  79, 77, 120, 87, 88, 94, 112, 100, 101, 103,
                                  92, 97, 86, 80, 109, 115, 126, 89, 101, 106,
                                  69, 11, 16, 18, 37, 25, 30, 7, 34, 29, 39, 32,
                                  42, 36, 25, 41, 70, 79, 87, 95, 95, 122, 121,
                                  117, 17, 45, 41, 44, 34, 37, 22, 21, 12, 11,
                                  69, 11, 16, 18, 37, 25, 30, 7, 34, 29, 39, 32,
                                  42, 36, 25, 41, 70, 79, 87, 95, 95, 122, 121,
                                  117 },

                                {

                                23,
                                  4, 82, 23, 4, 82, 13, 23, 27, 12, 70, 95, 68,
                                  25, 40, 10, 39, 87, 74, 27, 70, 73, 37, 95,
                                  95, 65, 79, 126, 126, 126, 24, 7, 68, 74, 27,
                                  70, 76, 14, 36, 66, 5, 2, 5, 109, 113, 95,
                                  112, 65, 71, 70, 76, 91, 81, 98, 0, 68, 69,
                                  64, 33, 1, 22, 0, 0, 0, 5, 97, 97, 11, 76, 70,
                                  10, 0, 72, 35, 19, 7, 48, 46, 7, 19, 22, 26,
                                  10, 9, 38, 110, 89, 89, 91, 25, 72, 19, 38,
                                  65, 73, 3, 19, 65, 73, 72, 81, 24, 76, 14, 1,
                                  75, 8, 68, 0, 7, 13, 18, 19, 7, 79, 68, 3, 65,
                                  0, 71, 30, 66, 1, 32, 27, 38, 31, 27, 98, 10,
                                  11, 76, 67, 76, 69, 33, 2, 5, 38, 57, 62, 62,
                                  49, 99, 109, 11, 42, 42, 126, 73, 14, 99, 25,
                                  70, 4, 37, 33, 54, 49, 47, 110, 3, 83, 103,
                                  103, 66, 13, 21, 10, 4, 10, 10, 2, 15, 8, 78,
                                  71, 5, 0, 0, 76, 66, 74, 80, 67, 67, 0, 72,
                                  73, 110, 75, 78, 69, 88, 85, 78, 65, 74, 76,
                                  74, 79, 99, 83, 69, 110, 126, 99, 108, 102,
                                  126, 89, 83, 118, 68, 77, 77, 85, 89, 102, 97,
                                  90, 108, 93, 94, 98, 109, 2, 14, 42, 26, 10,
                                  4, 17, 10, 5, 2, 16, 21, 45, 29, 23, 14, 36,
                                  19, 23, 7, 38, 9, 37, 24, 19, 13, 27, 12, 5,
                                  4, 5, 68, 55, 32, 11, 3, 21, 5, 70, 0, 18, 42,
                                  37, 22, 10, 34, 15, 13, 5, 4, 62, 66, 5, 12,
                                  11, 2, 10, 14, 18, 16, 22, 29, 41, 66, 3, 71,
                                  70, 62, 78, 103, 72, 5, 5, 71, 71, 70, 75, 2,
                                  77, 98, 69, 68, 24, 70, 77, 69, 68, 64, 74,
                                  72, 70, 92, 85, 73, 75, 70, 27, 103, 77, 26,
                                  85, 69, 69, 70, 6, 67, 73, 4, 12, 71, 71, 110,
                                  30, 28, 29, 10, 71, 72, 74, 85, 75, 86, 92,
                                  85, 104, 99, 99, 112, 108, 120, 126, 103, 94,
                                  92, 94, 108, 99, 93, 94, 95, 79, 83, 87, 84,
                                  89, 108, 94, 91, 115, 101, 114, 113, 126, 126,
                                  121, 119, 80, 78, 123, 89, 90, 96, 114, 101,
                                  102, 104, 93, 98, 86, 79, 110, 116, 126, 90,
                                  102, 107, 69, 11, 16, 19, 38, 25, 31, 7, 35,
                                  30, 40, 32, 43, 36, 26, 41, 72, 81, 89, 97,
                                  97, 124, 123, 119, 17, 46, 41, 45, 35, 37, 22,
                                  21, 12, 12, 69, 11, 16, 19, 38, 25, 31, 7, 35,
                                  30, 40, 32, 43, 36, 26, 41, 72, 81, 89, 97,
                                  97, 124, 123, 119 },

                                {

                                22,
                                  4, 82, 22, 4, 82, 15, 24, 27, 12, 70, 97, 70,
                                  24, 41, 10, 40, 89, 73, 29, 71, 73, 38, 96,
                                  96, 66, 81, 126, 126, 126, 26, 8, 68, 73, 29,
                                  71, 76, 15, 36, 66, 5, 3, 7, 110, 114, 95,
                                  112, 65, 70, 69, 77, 91, 81, 98, 0, 67, 69, 0,
                                  33, 1, 22, 0, 0, 0, 6, 97, 97, 11, 77, 70, 10,
                                  1, 70, 38, 20, 8, 50, 48, 8, 20, 24, 27, 11,
                                  10, 41, 110, 90, 89, 92, 25, 72, 20, 41, 64,
                                  73, 3, 21, 65, 73, 72, 80, 24, 76, 15, 2, 74,
                                  9, 67, 0, 8, 14, 19, 20, 7, 80, 68, 4, 65, 0,
                                  71, 31, 66, 1, 32, 28, 38, 31, 27, 98, 11, 11,
                                  77, 67, 75, 69, 34, 3, 6, 40, 59, 62, 62, 51,
                                  100, 110, 12, 43, 42, 126, 73, 14, 99, 26, 70,
                                  4, 39, 33, 54, 49, 49, 111, 4, 84, 105, 106,
                                  65, 13, 21, 10, 4, 10, 10, 2, 15, 8, 79, 72,
                                  5, 0, 0, 76, 66, 74, 81, 67, 67, 0, 73, 74,
                                  111, 76, 78, 69, 89, 85, 80, 67, 75, 77, 75,
                                  81, 102, 85, 70, 112, 126, 100, 110, 104, 126,
                                  90, 84, 119, 69, 78, 78, 87, 91, 104, 99, 91,
                                  109, 93, 95, 99, 111, 4, 16, 43, 27, 10, 4,
                                  18, 11, 6, 2, 18, 23, 46, 30, 23, 15, 38, 20,
                                  24, 8, 41, 10, 38, 25, 20, 13, 28, 13, 6, 5,
                                  6, 67, 56, 33, 11, 3, 22, 6, 69, 1, 19, 42,
                                  38, 22, 10, 35, 16, 14, 6, 5, 62, 65, 7, 14,
                                  12, 3, 11, 16, 20, 18, 24, 31, 44, 65, 4, 70,
                                  69, 62, 77, 104, 71, 6, 6, 71, 71, 70, 75, 2,
                                  78, 99, 69, 68, 25, 70, 77, 69, 68, 0, 74, 73,
                                  70, 93, 86, 74, 75, 70, 28, 103, 78, 27, 85,
                                  70, 69, 70, 6, 68, 73, 4, 12, 71, 71, 112, 29,
                                  27, 28, 9, 74, 75, 77, 88, 77, 89, 95, 88,
                                  107, 101, 101, 116, 111, 124, 126, 106, 96,
                                  93, 96, 110, 101, 94, 95, 96, 79, 85, 90, 87,
                                  91, 110, 96, 92, 117, 103, 116, 115, 126, 126,
                                  122, 121, 81, 79, 125, 90, 91, 97, 116, 102,
                                  103, 105, 94, 99, 86, 78, 112, 117, 126, 92,
                                  103, 108, 69, 12, 17, 20, 39, 26, 31, 8, 36,
                                  31, 41, 33, 44, 37, 26, 40, 74, 83, 91, 99,
                                  99, 126, 125, 120, 18, 46, 42, 45, 36, 38, 23,
                                  22, 12, 13, 69, 12, 17, 20, 39, 26, 31, 8, 36,
                                  31, 41, 33, 44, 37, 26, 40, 74, 83, 91, 99,
                                  99, 126, 125, 120 },

                                {

                                21,
                                  4, 82, 21, 4, 82, 17, 26, 28, 12, 71, 99, 71,
                                  23, 41, 10, 42, 90, 73, 30, 71, 74, 39, 97,
                                  97, 67, 83, 126, 126, 126, 28, 10, 68, 73, 30,
                                  71, 75, 16, 37, 66, 6, 4, 8, 111, 115, 95,
                                  113, 65, 70, 68, 77, 92, 81, 98, 0, 67, 69, 1,
                                  34, 1, 22, 0, 0, 0, 6, 97, 97, 12, 78, 70, 9,
                                  1, 69, 40, 21, 9, 51, 49, 9, 21, 26, 28, 12,
                                  11, 43, 111, 90, 89, 92, 26, 72, 21, 43, 64,
                                  72, 4, 23, 65, 73, 72, 80, 25, 76, 15, 3, 74,
                                  10, 67, 0, 8, 14, 20, 20, 7, 80, 68, 4, 65, 0,
                                  71, 31, 66, 1, 33, 28, 39, 31, 28, 99, 11, 12,
                                  77, 67, 75, 69, 35, 3, 6, 41, 60, 62, 62, 53,
                                  100, 111, 12, 43, 42, 126, 73, 15, 100, 26,
                                  70, 4, 40, 33, 54, 49, 50, 112, 6, 85, 108,
                                  109, 0, 13, 21, 9, 3, 9, 9, 1, 15, 7, 80, 73,
                                  5, 0, 0, 77, 67, 75, 82, 68, 67, 0, 74, 74,
                                  112, 76, 79, 69, 90, 86, 82, 69, 77, 79, 77,
                                  83, 105, 88, 71, 114, 126, 102, 112, 106, 126,
                                  91, 85, 121, 70, 79, 79, 88, 92, 106, 101, 93,
                                  111, 93, 96, 100, 112, 5, 17, 45, 27, 10, 4,
                                  19, 12, 7, 3, 20, 24, 47, 31, 24, 15, 39, 21,
                                  26, 9, 43, 10, 38, 25, 20, 14, 29, 13, 6, 6,
                                  7, 67, 58, 34, 11, 3, 23, 6, 69, 2, 20, 43,
                                  39, 23, 10, 36, 16, 15, 6, 5, 62, 0, 8, 15,
                                  14, 4, 13, 17, 21, 19, 26, 33, 46, 65, 5, 70,
                                  68, 62, 77, 105, 71, 7, 7, 71, 71, 70, 75, 3,
                                  78, 100, 69, 68, 25, 70, 77, 69, 68, 0, 75,
                                  73, 70, 94, 87, 74, 75, 70, 29, 104, 78, 28,
                                  86, 70, 69, 70, 7, 68, 74, 5, 13, 71, 71, 113,
                                  28, 26, 27, 7, 76, 77, 79, 91, 80, 92, 98, 91,
                                  110, 104, 103, 120, 115, 126, 126, 109, 98,
                                  95, 98, 113, 103, 95, 96, 97, 79, 87, 92, 89,
                                  93, 112, 98, 94, 119, 105, 118, 117, 126, 126,
                                  124, 122, 82, 80, 126, 92, 93, 99, 118, 104,
                                  105, 106, 95, 100, 86, 77, 113, 119, 126, 93,
                                  104, 109, 69, 12, 17, 20, 40, 27, 32, 8, 37,
                                  32, 42, 33, 45, 37, 27, 40, 76, 85, 93, 101,
                                  101, 126, 126, 121, 18, 47, 42, 46, 36, 39,
                                  23, 22, 13, 13, 69, 12, 17, 20, 40, 27, 32, 8,
                                  37, 32, 42, 33, 45, 37, 27, 40, 76, 85, 93,
                                  101, 101, 126, 126, 121 },

                                {

                                20,
                                  4, 82, 20, 4, 82, 19, 27, 28, 12, 71, 101, 73,
                                  22, 42, 10, 44, 92, 73, 32, 71, 74, 40, 98,
                                  98, 68, 85, 126, 126, 126, 30, 11, 68, 73, 32,
                                  71, 75, 17, 37, 66, 7, 5, 9, 112, 116, 95,
                                  113, 65, 70, 67, 77, 92, 81, 98, 0, 67, 69, 2,
                                  34, 1, 22, 0, 0, 0, 7, 97, 97, 12, 79, 70, 9,
                                  2, 68, 42, 22, 10, 53, 51, 10, 22, 28, 29, 13,
                                  12, 45, 112, 90, 89, 92, 26, 72, 22, 45, 64,
                                  71, 5, 25, 65, 73, 72, 80, 25, 76, 16, 4, 74,
                                  11, 67, 0, 8, 15, 21, 21, 7, 80, 68, 4, 65, 0,
                                  71, 31, 66, 1, 33, 28, 39, 31, 28, 99, 12, 13,
                                  78, 67, 75, 69, 36, 3, 7, 42, 61, 62, 62, 55,
                                  101, 112, 13, 43, 42, 126, 73, 15, 100, 27,
                                  70, 4, 41, 33, 54, 49, 51, 113, 7, 86, 111,
                                  112, 1, 13, 21, 9, 2, 9, 9, 1, 15, 7, 81, 74,
                                  5, 0, 0, 77, 67, 76, 83, 68, 67, 0, 75, 75,
                                  113, 77, 80, 69, 91, 86, 84, 71, 79, 80, 79,
                                  85, 108, 90, 72, 116, 126, 103, 114, 108, 126,
                                  92, 86, 123, 71, 80, 80, 89, 94, 108, 103, 95,
                                  112, 93, 97, 101, 114, 7, 19, 46, 28, 10, 4,
                                  20, 13, 8, 4, 22, 25, 48, 32, 25, 16, 40, 22,
                                  27, 10, 45, 11, 39, 26, 21, 14, 30, 14, 7, 7,
                                  8, 67, 59, 35, 11, 3, 24, 7, 69, 3, 21, 43,
                                  40, 23, 10, 37, 17, 16, 7, 6, 62, 1, 10, 17,
                                  16, 5, 14, 19, 23, 21, 28, 35, 48, 64, 6, 69,
                                  67, 62, 77, 106, 71, 8, 8, 71, 71, 70, 75, 3,
                                  78, 101, 69, 68, 26, 70, 77, 69, 68, 0, 75,
                                  73, 70, 95, 88, 74, 75, 70, 30, 105, 78, 29,
                                  87, 70, 69, 70, 7, 68, 74, 5, 14, 71, 71, 115,
                                  27, 25, 26, 5, 78, 80, 82, 94, 82, 95, 101,
                                  94, 113, 107, 105, 124, 118, 126, 126, 112,
                                  100, 97, 100, 115, 105, 96, 97, 98, 79, 89,
                                  94, 91, 95, 114, 100, 95, 121, 107, 120, 119,
                                  126, 126, 126, 123, 83, 81, 126, 93, 95, 100,
                                  120, 105, 106, 107, 96, 101, 86, 76, 114, 120,
                                  126, 94, 105, 110, 69, 13, 18, 21, 41, 28, 33,
                                  8, 38, 33, 43, 34, 46, 38, 28, 39, 78, 87, 95,
                                  103, 103, 126, 126, 122, 19, 47, 43, 47, 37,
                                  40, 24, 23, 13, 14, 69, 13, 18, 21, 41, 28,
                                  33, 8, 38, 33, 43, 34, 46, 38, 28, 39, 78, 87,
                                  95, 103, 103, 126, 126, 122 },

                                {

                                18,
                                  3, 83, 18, 3, 83, 20, 28, 28, 12, 72, 103, 75,
                                  21, 42, 10, 45, 94, 73, 33, 72, 75, 41, 99,
                                  100, 70, 87, 126, 126, 126, 32, 12, 68, 73,
                                  33, 72, 75, 17, 37, 67, 7, 5, 10, 114, 118,
                                  96, 114, 66, 70, 67, 78, 93, 81, 98, 64, 67,
                                  69, 2, 34, 0, 22, 0, 0, 0, 7, 98, 97, 12, 80,
                                  71, 8, 2, 67, 44, 23, 10, 54, 52, 10, 23, 29,
                                  29, 14, 12, 47, 113, 91, 90, 93, 26, 73, 22,
                                  47, 64, 71, 5, 26, 65, 73, 72, 80, 25, 77, 16,
                                  4, 74, 11, 67, 0, 8, 15, 22, 21, 7, 81, 69, 4,
                                  65, 64, 71, 31, 66, 1, 33, 28, 39, 31, 28,
                                  100, 12, 13, 79, 67, 75, 70, 36, 3, 7, 43, 62,
                                  62, 62, 56, 102, 114, 13, 43, 42, 126, 74, 15,
                                  101, 27, 71, 4, 42, 33, 53, 49, 52, 114, 8,
                                  88, 114, 116, 2, 12, 21, 8, 1, 8, 8, 0, 14, 6,
                                  82, 75, 4, 64, 64, 78, 68, 77, 84, 69, 68, 64,
                                  76, 76, 115, 78, 81, 69, 93, 87, 87, 74, 81,
                                  82, 81, 88, 112, 93, 74, 118, 126, 105, 117,
                                  110, 126, 94, 88, 125, 73, 81, 81, 91, 96,
                                  110, 105, 97, 114, 93, 98, 102, 116, 8, 20,
                                  47, 28, 10, 4, 20, 13, 8, 4, 23, 26, 48, 32,
                                  25, 16, 41, 23, 28, 10, 47, 11, 39, 26, 21,
                                  14, 30, 14, 7, 7, 9, 67, 60, 36, 11, 2, 24, 7,
                                  69, 3, 21, 43, 40, 23, 10, 38, 17, 16, 7, 6,
                                  62, 2, 11, 18, 17, 6, 15, 20, 24, 22, 29, 36,
                                  50, 64, 6, 69, 67, 62, 77, 108, 71, 8, 8, 71,
                                  71, 70, 76, 3, 79, 102, 70, 68, 26, 71, 77,
                                  70, 68, 0, 76, 74, 71, 96, 89, 75, 76, 70, 31,
                                  106, 79, 29, 88, 71, 69, 71, 7, 69, 75, 5, 14,
                                  71, 71, 117, 25, 24, 24, 3, 81, 83, 85, 97,
                                  85, 98, 105, 97, 117, 110, 107, 126, 122, 126,
                                  126, 115, 103, 99, 103, 118, 107, 98, 99, 99,
                                  79, 92, 97, 94, 97, 117, 102, 97, 124, 109,
                                  123, 121, 126, 126, 126, 125, 85, 83, 126, 95,
                                  97, 102, 122, 107, 108, 108, 97, 102, 87, 75,
                                  116, 122, 126, 96, 107, 112, 69, 13, 18, 21,
                                  42, 28, 33, 8, 39, 33, 44, 34, 46, 38, 28, 38,
                                  80, 89, 98, 106, 105, 126, 126, 124, 19, 47,
                                  43, 47, 37, 40, 24, 23, 13, 14, 69, 13, 18,
                                  21, 42, 28, 33, 8, 39, 33, 44, 34, 46, 38, 28,
                                  38, 80, 89, 98, 106, 105, 126, 126, 124 },

                                {

                                17,
                                  3, 83, 17, 3, 83, 22, 30, 29, 13, 72, 104, 76,
                                  21, 43, 11, 47, 95, 72, 35, 72, 75, 43, 99,
                                  101, 71, 88, 126, 126, 126, 34, 14, 67, 72,
                                  35, 72, 74, 18, 38, 67, 8, 6, 12, 115, 119,
                                  96, 114, 66, 69, 66, 78, 93, 80, 97, 64, 66,
                                  68, 3, 35, 0, 22, 0, 0, 0, 8, 98, 97, 13, 80,
                                  71, 8, 3, 65, 47, 25, 11, 56, 54, 11, 25, 31,
                                  30, 16, 13, 50, 113, 91, 90, 93, 27, 73, 23,
                                  50, 0, 70, 6, 28, 65, 72, 72, 79, 26, 77, 17,
                                  5, 73, 12, 66, 1, 9, 16, 23, 22, 8, 81, 69, 5,
                                  64, 64, 70, 32, 65, 1, 34, 29, 40, 32, 29,
                                  100, 13, 14, 79, 67, 74, 70, 37, 4, 8, 45, 62,
                                  62, 62, 58, 102, 115, 14, 44, 43, 126, 74, 16,
                                  101, 28, 71, 5, 44, 33, 53, 50, 54, 115, 10,
                                  89, 116, 119, 4, 12, 21, 8, 1, 8, 8, 0, 14, 6,
                                  82, 75, 4, 64, 64, 78, 68, 77, 84, 69, 68, 64,
                                  76, 76, 116, 78, 81, 69, 94, 87, 89, 76, 82,
                                  83, 82, 90, 115, 95, 75, 119, 126, 106, 119,
                                  111, 126, 95, 89, 126, 74, 81, 81, 92, 97,
                                  111, 106, 98, 115, 93, 98, 102, 117, 10, 22,
                                  49, 29, 10, 4, 21, 14, 9, 5, 25, 28, 49, 33,
                                  26, 17, 43, 24, 30, 11, 50, 12, 40, 27, 22,
                                  15, 31, 15, 8, 8, 11, 66, 62, 37, 12, 2, 25,
                                  8, 68, 4, 22, 44, 41, 24, 11, 39, 18, 17, 8,
                                  7, 62, 4, 13, 20, 19, 8, 17, 22, 26, 24, 31,
                                  38, 53, 0, 7, 68, 66, 62, 76, 109, 70, 9, 9,
                                  70, 71, 69, 76, 4, 79, 102, 70, 68, 27, 71,
                                  77, 70, 68, 1, 76, 74, 71, 96, 89, 75, 76, 69,
                                  33, 106, 79, 30, 88, 71, 69, 71, 8, 69, 75, 6,
                                  15, 70, 70, 118, 24, 23, 23, 2, 83, 85, 87,
                                  100, 87, 100, 108, 99, 120, 112, 109, 126,
                                  125, 126, 126, 117, 105, 100, 105, 120, 108,
                                  99, 100, 99, 79, 94, 99, 96, 99, 119, 103, 98,
                                  126, 110, 125, 122, 126, 126, 126, 126, 86,
                                  84, 126, 96, 98, 103, 123, 108, 109, 109, 97,
                                  102, 87, 74, 117, 123, 126, 97, 108, 113, 68,
                                  14, 19, 22, 44, 29, 34, 9, 41, 34, 45, 35, 47,
                                  39, 29, 38, 81, 90, 100, 108, 106, 126, 126,
                                  125, 20, 48, 44, 48, 38, 41, 25, 24, 14, 15,
                                  68, 14, 19, 22, 44, 29, 34, 9, 41, 34, 45, 35,
                                  47, 39, 29, 38, 81, 90, 100, 108, 106, 126,
                                  126, 125 },

                                {

                                16,
                                  3, 83, 16, 3, 83, 24, 31, 29, 13, 72, 106, 78,
                                  20, 44, 11, 49, 97, 72, 36, 72, 75, 44, 100,
                                  102, 72, 90, 126, 126, 126, 36, 15, 67, 72,
                                  36, 72, 74, 19, 38, 67, 9, 7, 13, 116, 120,
                                  96, 114, 66, 69, 65, 78, 93, 80, 97, 64, 66,
                                  68, 4, 35, 0, 22, 0, 0, 0, 9, 98, 97, 13, 81,
                                  71, 8, 4, 64, 49, 26, 12, 58, 56, 12, 26, 33,
                                  31, 17, 14, 52, 114, 91, 90, 93, 27, 73, 24,
                                  52, 0, 69, 7, 30, 65, 72, 72, 79, 26, 77, 17,
                                  6, 73, 13, 66, 1, 9, 16, 24, 23, 8, 81, 69, 5,
                                  64, 64, 70, 32, 65, 1, 34, 29, 40, 32, 29,
                                  101, 14, 15, 80, 67, 74, 70, 38, 4, 8, 46, 62,
                                  62, 62, 60, 103, 116, 14, 44, 43, 126, 74, 16,
                                  102, 29, 71, 5, 45, 33, 53, 50, 55, 116, 11,
                                  90, 119, 122, 5, 12, 21, 8, 0, 7, 8, 0, 14, 5,
                                  83, 76, 4, 64, 64, 78, 69, 78, 85, 69, 68, 64,
                                  77, 77, 117, 79, 82, 69, 95, 88, 91, 78, 84,
                                  85, 84, 92, 118, 97, 76, 121, 126, 108, 121,
                                  113, 126, 96, 90, 126, 75, 82, 82, 93, 99,
                                  113, 108, 100, 117, 93, 99, 103, 119, 11, 23,
                                  50, 30, 10, 4, 22, 15, 10, 6, 27, 29, 50, 34,
                                  27, 18, 44, 25, 31, 12, 52, 13, 40, 27, 22,
                                  15, 32, 16, 9, 9, 12, 66, 62, 38, 12, 2, 26,
                                  9, 68, 5, 23, 44, 42, 24, 11, 40, 19, 18, 9,
                                  8, 62, 5, 15, 22, 21, 9, 18, 24, 28, 25, 33,
                                  40, 55, 1, 8, 67, 65, 62, 76, 110, 70, 10, 10,
                                  70, 71, 69, 76, 4, 79, 103, 70, 68, 28, 71,
                                  77, 70, 68, 1, 76, 74, 71, 97, 90, 75, 76, 69,
                                  34, 107, 79, 31, 89, 71, 69, 71, 8, 69, 75, 6,
                                  16, 70, 70, 120, 23, 22, 22, 0, 85, 88, 90,
                                  103, 89, 103, 111, 102, 123, 115, 111, 126,
                                  126, 126, 126, 120, 107, 102, 107, 122, 110,
                                  100, 101, 100, 79, 96, 101, 98, 101, 121, 105,
                                  100, 126, 112, 126, 124, 126, 126, 126, 126,
                                  87, 85, 126, 98, 100, 105, 125, 109, 110, 110,
                                  98, 103, 87, 73, 118, 124, 126, 98, 109, 114,
                                  68, 14, 20, 23, 45, 30, 35, 9, 42, 35, 46, 35,
                                  48, 40, 30, 37, 83, 92, 102, 110, 108, 126,
                                  126, 126, 21, 48, 44, 49, 39, 42, 25, 25, 14,
                                  16, 68, 14, 20, 23, 45, 30, 35, 9, 42, 35, 46,
                                  35, 48, 40, 30, 37, 83, 92, 102, 110, 108,
                                  126, 126, 126 },

                                {

                                15,
                                  3, 83, 15, 3, 83, 26, 33, 30, 13, 73, 108, 79,
                                  19, 44, 11, 51, 98, 72, 38, 72, 76, 45, 101,
                                  103, 73, 92, 126, 126, 126, 38, 17, 67, 72,
                                  38, 72, 73, 20, 39, 67, 10, 8, 14, 117, 121,
                                  96, 115, 66, 69, 64, 78, 94, 80, 97, 64, 66,
                                  68, 5, 36, 0, 22, 0, 0, 0, 9, 98, 97, 14, 82,
                                  71, 7, 4, 0, 51, 27, 13, 59, 57, 13, 27, 35,
                                  32, 18, 15, 54, 115, 91, 90, 93, 28, 73, 25,
                                  54, 0, 68, 8, 32, 65, 72, 72, 79, 27, 77, 18,
                                  7, 73, 14, 66, 1, 9, 17, 25, 23, 8, 81, 69, 5,
                                  64, 64, 70, 32, 65, 1, 35, 29, 41, 32, 30,
                                  101, 14, 16, 80, 67, 74, 70, 39, 4, 9, 47, 62,
                                  62, 62, 62, 103, 117, 15, 44, 43, 126, 74, 17,
                                  102, 29, 71, 5, 46, 33, 53, 50, 56, 117, 13,
                                  91, 122, 125, 7, 12, 21, 7, 64, 7, 7, 64, 14,
                                  5, 84, 77, 4, 64, 64, 79, 69, 79, 86, 70, 68,
                                  64, 78, 77, 118, 79, 83, 69, 96, 88, 93, 80,
                                  86, 86, 86, 94, 121, 100, 77, 123, 126, 109,
                                  123, 115, 126, 97, 91, 126, 76, 83, 83, 94,
                                  100, 115, 110, 102, 118, 93, 100, 104, 120,
                                  13, 25, 52, 30, 10, 4, 23, 16, 11, 7, 29, 30,
                                  51, 35, 28, 18, 45, 26, 33, 13, 54, 13, 41,
                                  28, 23, 16, 33, 16, 9, 10, 13, 66, 62, 39, 12,
                                  2, 27, 9, 68, 6, 24, 45, 43, 25, 11, 41, 19,
                                  19, 9, 8, 62, 7, 16, 23, 23, 10, 20, 25, 29,
                                  27, 35, 42, 57, 1, 9, 67, 64, 62, 76, 111, 70,
                                  11, 11, 70, 71, 69, 76, 5, 79, 104, 70, 68,
                                  28, 71, 77, 70, 68, 1, 77, 74, 71, 98, 91, 75,
                                  76, 69, 35, 108, 79, 32, 90, 71, 69, 71, 9,
                                  69, 76, 7, 17, 70, 70, 121, 22, 21, 21, 65,
                                  87, 90, 92, 106, 92, 106, 114, 105, 126, 118,
                                  113, 126, 126, 126, 126, 123, 109, 104, 109,
                                  125, 112, 101, 102, 101, 79, 98, 103, 100,
                                  103, 123, 107, 101, 126, 114, 126, 126, 126,
                                  126, 126, 126, 88, 86, 126, 99, 102, 106, 126,
                                  111, 112, 111, 99, 104, 87, 72, 119, 126, 126,
                                  99, 110, 115, 68, 15, 20, 23, 46, 31, 36, 9,
                                  43, 36, 47, 36, 49, 40, 31, 37, 85, 94, 104,
                                  112, 110, 126, 126, 126, 21, 49, 45, 50, 39,
                                  43, 26, 25, 15, 16, 68, 15, 20, 23, 46, 31,
                                  36, 9, 43, 36, 47, 36, 49, 40, 31, 37, 85, 94,
                                  104, 112, 110, 126, 126, 126 },

                          },

                          {

                              {

                              62,
                                9, 74, 62, 9, 74, 126, 104, 10, 9, 12, 30, 61,
                                62, 54, 14, 118, 6, 78, 65, 1, 14, 73, 13, 64,
                                20, 62, 67, 90, 104, 126, 104, 67, 78, 65, 1,
                                86, 95, 2, 18, 69, 81, 96, 8, 67, 86, 88, 5, 76,
                                94, 9, 69, 81, 88, 67, 74, 74, 80, 72, 5, 22, 0,
                                0, 0, 83, 86, 97, 72, 22, 1, 52, 8, 69, 126,
                                102, 82, 74, 107, 126, 126, 126, 95, 126, 114,
                                126, 123, 115, 122, 115, 0, 68, 84, 104, 70, 93,
                                90, 126, 74, 97, 91, 126, 7, 82, 76, 125, 93,
                                87, 77, 71, 0, 68, 84, 1, 65, 2, 7, 66, 64, 2,
                                78, 13, 11, 28, 19, 25, 18, 17, 19, 46, 12, 13,
                                44, 30, 1, 108, 100, 101, 91, 94, 88, 84, 86,
                                83, 87, 94, 70, 72, 74, 4, 102, 100, 95, 75, 72,
                                75, 71, 17, 69, 1, 65, 26, 72, 6, 9, 1, 72, 62,
                                54, 38, 45, 54, 44, 26, 45, 34, 30, 33, 18, 5,
                                1, 2, 25, 18, 24, 21, 19, 18, 22, 14, 29, 21, 8,
                                12, 17, 89, 62, 62, 62, 62, 62, 62, 62, 62, 62,
                                62, 62, 62, 62, 62, 46, 62, 60, 41, 62, 62, 62,
                                62, 60, 58, 62, 47, 41, 15, 26, 3, 68, 97, 71,
                                21, 13, 9, 1, 5, 0, 72, 74, 91, 67, 36, 24, 19,
                                17, 64, 68, 78, 77, 86, 92, 8, 3, 1, 65, 73, 76,
                                80, 88, 110, 97, 84, 79, 73, 74, 86, 96, 97,
                                117, 78, 30, 15, 10, 1, 71, 79, 86, 90, 97, 62,
                                93, 84, 79, 66, 71, 1, 3, 4, 75, 1, 5, 66, 79,
                                71, 68, 19, 1, 27, 23, 36, 34, 19, 27, 31, 21,
                                15, 1, 17, 64, 104, 97, 96, 88, 85, 85, 85, 88,
                                66, 77, 76, 76, 5, 76, 83, 99, 95, 95, 76, 74,
                                70, 75, 68, 65, 73, 1, 1, 68, 75, 8, 64, 70, 57,
                                44, 47, 49, 50, 52, 48, 47, 40, 40, 43, 37, 19,
                                23, 16, 46, 42, 41, 36, 34, 28, 13, 6, 0, 77,
                                82, 94, 69, 109, 62, 62, 62, 62, 62, 62, 62, 62,
                                62, 62, 62, 61, 50, 28, 5, 62, 62, 33, 62, 62,
                                62, 60, 62, 58, 52, 58, 51, 52, 34, 37, 24, 66,
                                42, 32, 13, 120, 112, 114, 85, 92, 89, 71, 81,
                                80, 68, 70, 7, 68, 13, 74, 62, 62, 62, 62, 60,
                                57, 29, 9, 82, 75, 40, 29, 20, 9, 8, 2, 64, 68,
                                92, 106, 97, 90, 90, 88, 73, 79, 86, 73, 70, 69,
                                66, 64, 5, 4, 62, 62, 62, 62, 60, 54, 43, 27, 67 },

                                {

                                62,
                                  9, 74, 62, 9, 74, 125, 102, 11, 10, 12, 29,
                                  60, 62, 54, 14, 115, 6, 77, 64, 1, 14, 72, 12,
                                  65, 20, 62, 68, 91, 104, 124, 102, 67, 77, 64,
                                  1, 85, 93, 3, 18, 68, 80, 95, 8, 67, 85, 88,
                                  5, 75, 93, 9, 69, 80, 88, 66, 73, 73, 79, 71,
                                  5, 22, 0, 0, 0, 82, 86, 97, 71, 22, 1, 52, 8,
                                  69, 125, 101, 82, 73, 105, 125, 125, 125, 93,
                                  125, 112, 125, 121, 114, 121, 114, 1, 67, 83,
                                  103, 69, 92, 89, 125, 73, 96, 90, 125, 8, 81,
                                  75, 123, 92, 86, 76, 70, 1, 67, 83, 2, 64, 2,
                                  7, 65, 64, 2, 77, 13, 11, 28, 19, 25, 18, 17,
                                  19, 45, 12, 13, 43, 29, 1, 107, 99, 100, 90,
                                  93, 87, 83, 85, 82, 86, 92, 70, 72, 73, 3,
                                  101, 99, 95, 74, 72, 74, 70, 17, 68, 1, 65,
                                  25, 71, 6, 8, 1, 72, 62, 54, 38, 45, 54, 44,
                                  26, 45, 34, 29, 33, 18, 5, 1, 2, 25, 18, 24,
                                  21, 19, 17, 22, 14, 28, 20, 8, 11, 16, 89, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
                                  62, 60, 44, 62, 59, 40, 62, 62, 62, 62, 58,
                                  56, 61, 45, 39, 15, 25, 2, 68, 97, 70, 22, 14,
                                  10, 2, 5, 0, 71, 73, 90, 66, 37, 25, 20, 17,
                                  0, 67, 77, 76, 85, 91, 9, 4, 2, 64, 72, 75,
                                  79, 87, 108, 96, 82, 78, 72, 73, 85, 95, 96,
                                  115, 77, 31, 16, 11, 2, 70, 78, 85, 89, 96,
                                  62, 92, 83, 78, 66, 70, 1, 4, 5, 74, 2, 6, 65,
                                  78, 71, 68, 19, 2, 27, 23, 35, 34, 19, 26, 30,
                                  21, 15, 1, 16, 64, 103, 96, 95, 87, 84, 84,
                                  84, 87, 66, 76, 75, 75, 5, 75, 82, 98, 94, 95,
                                  76, 73, 70, 74, 68, 65, 72, 1, 1, 67, 74, 8,
                                  64, 70, 57, 44, 47, 49, 49, 52, 48, 47, 40,
                                  40, 43, 37, 19, 22, 15, 45, 41, 40, 35, 33,
                                  27, 13, 6, 0, 76, 81, 93, 69, 108, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 62, 61, 59, 48, 27, 5,
                                  62, 62, 32, 62, 62, 62, 58, 62, 56, 50, 56,
                                  49, 50, 33, 35, 23, 67, 41, 31, 12, 118, 110,
                                  112, 84, 91, 88, 69, 80, 79, 68, 69, 9, 66,
                                  15, 73, 62, 62, 62, 62, 58, 55, 27, 7, 83, 74,
                                  41, 29, 20, 9, 9, 2, 64, 68, 91, 105, 96, 89,
                                  89, 86, 72, 78, 85, 72, 69, 68, 65, 0, 6, 4,
                                  62, 62, 62, 62, 59, 53, 41, 26, 67 },

                                {

                                62,
                                  9, 74, 62, 9, 74, 123, 101, 11, 10, 12, 28,
                                  59, 61, 54, 14, 113, 6, 76, 0, 1, 13, 72, 11,
                                  66, 19, 60, 70, 92, 105, 121, 101, 67, 76, 0,
                                  1, 85, 92, 3, 17, 68, 80, 94, 8, 67, 85, 88,
                                  5, 75, 92, 9, 69, 80, 88, 66, 73, 73, 79, 71,
                                  5, 22, 0, 0, 0, 81, 86, 97, 71, 21, 1, 52, 8,
                                  69, 124, 100, 82, 73, 104, 123, 123, 124, 92,
                                  123, 111, 123, 120, 113, 120, 113, 2, 67, 82,
                                  102, 69, 92, 88, 123, 73, 96, 90, 124, 8, 81,
                                  75, 122, 92, 85, 76, 70, 1, 67, 82, 2, 64, 1,
                                  7, 65, 64, 2, 77, 13, 11, 27, 19, 24, 18, 17,
                                  19, 43, 12, 13, 41, 28, 0, 106, 98, 99, 89,
                                  92, 86, 82, 84, 82, 85, 91, 70, 72, 73, 2,
                                  101, 98, 95, 74, 72, 73, 70, 16, 67, 1, 65,
                                  24, 70, 5, 7, 1, 73, 60, 53, 37, 44, 53, 43,
                                  25, 44, 34, 28, 32, 18, 5, 1, 2, 24, 17, 23,
                                  20, 18, 16, 21, 13, 26, 19, 7, 10, 15, 89, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
                                  62, 58, 41, 62, 57, 38, 62, 62, 62, 62, 56,
                                  54, 58, 43, 37, 14, 23, 1, 69, 97, 70, 22, 14,
                                  10, 2, 5, 0, 71, 73, 89, 66, 37, 25, 20, 17,
                                  1, 67, 76, 76, 84, 90, 10, 5, 2, 64, 71, 75,
                                  79, 86, 107, 95, 81, 77, 72, 73, 84, 94, 95,
                                  114, 77, 31, 16, 11, 2, 69, 77, 84, 88, 95,
                                  62, 92, 83, 78, 66, 70, 1, 4, 5, 74, 2, 6, 64,
                                  78, 71, 68, 18, 2, 26, 22, 34, 33, 19, 25, 29,
                                  21, 15, 0, 15, 65, 102, 95, 94, 87, 84, 84,
                                  83, 86, 66, 76, 75, 75, 4, 75, 82, 98, 93, 95,
                                  76, 73, 70, 73, 68, 65, 71, 1, 1, 67, 73, 7,
                                  64, 71, 56, 44, 47, 48, 48, 51, 47, 46, 39,
                                  39, 42, 36, 18, 21, 14, 43, 40, 38, 33, 32,
                                  26, 12, 5, 0, 76, 81, 93, 70, 107, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 62, 59, 57, 46, 26, 4,
                                  62, 60, 31, 62, 62, 62, 56, 60, 54, 48, 54,
                                  47, 48, 31, 33, 21, 68, 39, 29, 10, 117, 109,
                                  111, 83, 90, 87, 67, 79, 78, 68, 68, 10, 65,
                                  16, 72, 62, 62, 62, 62, 55, 52, 24, 5, 84, 74,
                                  41, 29, 20, 9, 9, 2, 64, 68, 90, 104, 95, 88,
                                  88, 85, 71, 77, 84, 71, 68, 67, 65, 1, 6, 4,
                                  62, 62, 62, 61, 57, 51, 39, 24, 68 },

                                {

                                62,
                                  9, 74, 62, 9, 74, 121, 99, 12, 10, 11, 26, 57,
                                  60, 54, 14, 111, 6, 75, 1, 1, 12, 72, 10, 67,
                                  19, 58, 71, 93, 105, 118, 100, 67, 75, 1, 1,
                                  84, 91, 4, 17, 68, 79, 93, 7, 68, 85, 88, 5,
                                  75, 92, 9, 69, 80, 88, 65, 73, 73, 79, 70, 5,
                                  22, 0, 0, 0, 81, 86, 97, 70, 20, 1, 52, 8, 69,
                                  123, 99, 82, 72, 103, 121, 121, 122, 91, 121,
                                  110, 121, 119, 112, 119, 112, 3, 67, 81, 101,
                                  69, 91, 88, 121, 73, 95, 89, 123, 8, 81, 74,
                                  120, 91, 84, 76, 70, 1, 67, 81, 3, 0, 1, 7,
                                  65, 64, 2, 77, 13, 10, 27, 19, 23, 18, 17, 19,
                                  41, 12, 12, 39, 27, 64, 105, 97, 98, 88, 91,
                                  86, 81, 84, 81, 84, 90, 70, 72, 73, 1, 100,
                                  97, 95, 74, 72, 72, 70, 15, 66, 1, 65, 23, 69,
                                  5, 6, 1, 74, 59, 52, 37, 43, 52, 42, 25, 43,
                                  33, 27, 31, 18, 5, 1, 1, 23, 16, 22, 19, 17,
                                  15, 20, 13, 24, 18, 7, 9, 14, 89, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 55,
                                  39, 62, 55, 37, 62, 61, 62, 59, 54, 51, 56,
                                  41, 34, 13, 21, 0, 70, 97, 70, 23, 14, 10, 2,
                                  5, 0, 71, 73, 89, 66, 37, 25, 20, 17, 2, 66,
                                  76, 75, 84, 89, 11, 5, 3, 64, 70, 74, 78, 86,
                                  106, 94, 80, 76, 71, 73, 83, 93, 94, 113, 76,
                                  31, 16, 11, 2, 68, 77, 83, 87, 94, 62, 91, 82,
                                  77, 66, 70, 1, 4, 5, 74, 2, 6, 64, 78, 71, 68,
                                  18, 3, 25, 21, 33, 32, 19, 24, 28, 21, 15, 0,
                                  14, 65, 101, 94, 93, 86, 83, 83, 83, 85, 66,
                                  76, 75, 74, 4, 75, 82, 97, 92, 95, 76, 73, 70,
                                  72, 68, 65, 70, 1, 1, 67, 72, 6, 64, 72, 55,
                                  43, 46, 47, 47, 50, 46, 45, 38, 38, 41, 35,
                                  17, 20, 13, 42, 39, 37, 31, 30, 25, 11, 5, 64,
                                  76, 81, 93, 70, 106, 62, 62, 62, 62, 62, 62,
                                  62, 62, 62, 62, 57, 54, 44, 24, 3, 61, 59, 29,
                                  62, 62, 60, 54, 58, 52, 46, 52, 45, 45, 29,
                                  31, 19, 69, 37, 27, 9, 116, 108, 110, 82, 89,
                                  86, 66, 78, 77, 68, 67, 12, 0, 18, 71, 62, 62,
                                  62, 62, 52, 49, 21, 3, 85, 74, 41, 29, 20, 9,
                                  9, 2, 64, 68, 90, 103, 94, 87, 87, 84, 71, 77,
                                  83, 71, 68, 67, 65, 1, 6, 4, 62, 62, 62, 59,
                                  55, 49, 37, 22, 69 },

                                {

                                62,
                                  9, 74, 62, 9, 74, 120, 98, 12, 10, 11, 25, 56,
                                  58, 54, 14, 108, 5, 74, 1, 1, 11, 72, 9, 68,
                                  18, 56, 73, 94, 106, 115, 99, 67, 74, 1, 1,
                                  84, 90, 4, 16, 68, 79, 93, 7, 68, 84, 88, 5,
                                  75, 91, 8, 70, 80, 88, 65, 72, 73, 78, 70, 5,
                                  22, 0, 0, 0, 80, 87, 97, 70, 19, 1, 52, 8, 69,
                                  122, 98, 82, 72, 101, 120, 119, 121, 90, 120,
                                  108, 119, 118, 112, 118, 112, 3, 67, 80, 100,
                                  69, 91, 87, 119, 73, 95, 89, 122, 8, 80, 74,
                                  119, 91, 84, 76, 69, 1, 67, 81, 3, 0, 0, 6,
                                  65, 64, 2, 77, 13, 10, 26, 19, 23, 18, 17, 18,
                                  39, 12, 12, 37, 26, 65, 104, 96, 97, 87, 91,
                                  85, 80, 83, 81, 83, 89, 70, 72, 72, 0, 100,
                                  96, 95, 74, 72, 72, 70, 14, 65, 1, 65, 21, 68,
                                  4, 5, 1, 75, 57, 51, 36, 42, 51, 41, 24, 42,
                                  33, 25, 30, 17, 5, 1, 1, 22, 16, 21, 19, 16,
                                  14, 19, 12, 22, 17, 6, 8, 13, 89, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 62, 59, 53,
                                  36, 62, 54, 35, 62, 59, 62, 57, 51, 49, 53,
                                  39, 32, 12, 20, 65, 71, 97, 70, 23, 15, 10, 2,
                                  5, 0, 71, 73, 88, 65, 38, 25, 20, 17, 3, 66,
                                  75, 75, 83, 89, 12, 6, 3, 64, 70, 74, 78, 85,
                                  105, 94, 79, 76, 71, 73, 82, 92, 94, 112, 76,
                                  32, 16, 11, 2, 67, 76, 83, 86, 93, 62, 91, 82,
                                  77, 66, 70, 1, 4, 5, 73, 2, 6, 0, 78, 71, 68,
                                  17, 3, 24, 20, 32, 31, 19, 22, 27, 20, 15, 64,
                                  13, 66, 101, 94, 92, 86, 83, 83, 82, 84, 67,
                                  76, 75, 74, 3, 75, 82, 97, 91, 95, 76, 72, 70,
                                  72, 68, 65, 69, 1, 0, 67, 71, 6, 65, 73, 54,
                                  43, 46, 46, 46, 49, 45, 44, 37, 37, 40, 34,
                                  16, 19, 12, 40, 37, 35, 29, 29, 24, 10, 4, 64,
                                  76, 81, 93, 71, 106, 62, 62, 62, 62, 62, 62,
                                  62, 62, 62, 60, 55, 52, 42, 23, 2, 59, 57, 28,
                                  62, 62, 58, 52, 55, 50, 44, 50, 43, 43, 27,
                                  29, 17, 70, 35, 25, 7, 115, 107, 109, 82, 88,
                                  85, 64, 77, 76, 68, 66, 13, 1, 19, 71, 62, 62,
                                  62, 62, 49, 46, 18, 1, 86, 74, 41, 29, 20, 9,
                                  9, 2, 64, 68, 89, 102, 93, 86, 87, 83, 70, 76,
                                  82, 70, 67, 66, 64, 2, 7, 4, 62, 62, 62, 57,
                                  53, 47, 35, 20, 70 },

                                {

                                62,
                                  9, 74, 62, 9, 74, 118, 96, 12, 10, 10, 23, 54,
                                  57, 54, 14, 106, 5, 73, 2, 1, 11, 71, 8, 69,
                                  18, 54, 75, 95, 106, 112, 97, 67, 73, 2, 1,
                                  84, 89, 4, 16, 68, 79, 92, 7, 69, 84, 88, 5,
                                  75, 90, 8, 70, 80, 88, 64, 72, 72, 78, 69, 5,
                                  22, 0, 0, 0, 80, 87, 97, 69, 18, 1, 52, 8, 69,
                                  121, 97, 82, 71, 100, 118, 117, 119, 89, 118,
                                  107, 117, 117, 111, 117, 111, 4, 67, 79, 99,
                                  69, 90, 86, 117, 73, 95, 88, 120, 9, 80, 73,
                                  118, 90, 83, 76, 69, 2, 66, 80, 4, 1, 0, 6,
                                  65, 64, 2, 77, 13, 9, 25, 19, 22, 18, 17, 18,
                                  37, 12, 11, 36, 25, 66, 103, 95, 96, 86, 90,
                                  84, 79, 82, 80, 82, 88, 70, 72, 72, 64, 99,
                                  95, 95, 73, 72, 71, 70, 13, 64, 1, 65, 20, 67,
                                  4, 4, 1, 75, 56, 50, 36, 41, 50, 40, 23, 42,
                                  33, 24, 29, 17, 5, 1, 0, 22, 15, 20, 18, 15,
                                  13, 19, 11, 20, 16, 5, 7, 12, 89, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 62, 57, 51,
                                  34, 60, 52, 33, 62, 57, 60, 55, 49, 47, 50,
                                  37, 29, 11, 18, 66, 71, 97, 70, 23, 15, 10, 2,
                                  5, 0, 71, 73, 88, 65, 38, 25, 20, 17, 4, 65,
                                  74, 75, 82, 88, 13, 7, 3, 0, 69, 73, 77, 85,
                                  104, 93, 77, 75, 71, 72, 81, 91, 93, 111, 75,
                                  32, 17, 11, 2, 66, 75, 82, 85, 92, 62, 91, 82,
                                  76, 66, 70, 1, 4, 5, 73, 2, 7, 0, 78, 71, 68,
                                  16, 4, 23, 19, 31, 31, 19, 21, 26, 20, 15, 65,
                                  12, 66, 100, 93, 91, 85, 82, 82, 82, 83, 67,
                                  76, 75, 74, 2, 75, 82, 96, 90, 95, 76, 72, 70,
                                  71, 68, 65, 68, 1, 0, 67, 70, 5, 65, 73, 53,
                                  43, 45, 46, 45, 48, 44, 43, 37, 36, 39, 33,
                                  15, 18, 11, 39, 36, 34, 27, 28, 23, 9, 3, 65,
                                  76, 80, 93, 71, 105, 62, 62, 62, 62, 62, 62,
                                  62, 62, 60, 58, 53, 50, 40, 21, 1, 57, 55, 27,
                                  61, 62, 56, 50, 53, 48, 42, 48, 41, 40, 25,
                                  27, 15, 71, 33, 23, 6, 114, 105, 108, 81, 87,
                                  84, 1, 76, 75, 68, 65, 15, 3, 21, 70, 62, 62,
                                  62, 62, 47, 43, 16, 64, 87, 74, 41, 29, 20, 9,
                                  9, 2, 64, 68, 89, 101, 92, 85, 86, 82, 69, 76,
                                  81, 69, 66, 65, 64, 2, 7, 4, 62, 62, 62, 56,
                                  51, 45, 33, 18, 71 },

                                {

                                62,
                                  9, 75, 62, 9, 75, 116, 95, 13, 10, 10, 22, 53,
                                  56, 54, 14, 104, 5, 73, 3, 1, 10, 71, 7, 70,
                                  17, 53, 76, 96, 107, 109, 96, 67, 73, 3, 1,
                                  83, 88, 5, 15, 67, 78, 91, 6, 69, 84, 88, 5,
                                  74, 90, 8, 70, 79, 88, 64, 72, 72, 78, 69, 5,
                                  22, 0, 0, 0, 79, 87, 97, 69, 18, 0, 52, 8, 69,
                                  120, 97, 82, 71, 99, 116, 115, 118, 88, 116,
                                  106, 115, 116, 110, 116, 110, 5, 67, 78, 99,
                                  68, 90, 86, 115, 73, 94, 88, 119, 9, 80, 73,
                                  116, 90, 82, 75, 69, 2, 66, 79, 4, 1, 64, 6,
                                  65, 64, 2, 77, 13, 9, 25, 19, 21, 18, 17, 18,
                                  35, 12, 11, 34, 24, 67, 103, 94, 96, 86, 89,
                                  84, 78, 82, 80, 82, 86, 70, 72, 72, 65, 99,
                                  94, 95, 73, 72, 70, 69, 12, 64, 1, 65, 19, 66,
                                  3, 3, 1, 76, 54, 49, 35, 41, 49, 40, 23, 41,
                                  32, 23, 28, 17, 5, 1, 0, 21, 14, 19, 17, 15,
                                  12, 18, 11, 18, 15, 5, 6, 11, 89, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 62, 62, 62, 54, 48,
                                  31, 58, 50, 32, 62, 54, 57, 52, 47, 44, 48,
                                  34, 27, 10, 16, 67, 72, 97, 69, 24, 15, 11, 2,
                                  5, 0, 71, 73, 87, 65, 38, 26, 20, 17, 5, 65,
                                  74, 74, 82, 87, 14, 7, 4, 0, 68, 73, 77, 84,
                                  103, 92, 76, 74, 70, 72, 81, 91, 92, 109, 75,
                                  32, 17, 11, 3, 66, 75, 81, 85, 91, 62, 90, 81,
                                  76, 66, 70, 1, 4, 5, 73, 3, 7, 1, 78, 71, 69,
                                  16, 4, 22, 18, 30, 30, 19, 20, 25, 20, 15, 65,
                                  11, 67, 99, 92, 90, 85, 82, 82, 81, 83, 67,
                                  75, 74, 73, 2, 75, 82, 96, 89, 95, 76, 72, 70,
                                  70, 68, 65, 67, 0, 0, 67, 70, 4, 65, 74, 52,
                                  42, 45, 45, 44, 48, 44, 42, 36, 36, 38, 32,
                                  14, 17, 10, 37, 35, 32, 25, 26, 21, 8, 3, 65,
                                  76, 80, 92, 72, 104, 62, 62, 62, 62, 62, 62,
                                  62, 62, 58, 55, 51, 47, 38, 20, 1, 56, 54, 25,
                                  59, 62, 54, 48, 51, 46, 40, 45, 39, 38, 23,
                                  25, 14, 73, 31, 21, 4, 113, 104, 107, 80, 86,
                                  83, 2, 75, 74, 68, 64, 16, 4, 22, 69, 62, 62,
                                  62, 59, 44, 41, 13, 66, 89, 73, 41, 29, 20, 9,
                                  9, 2, 64, 68, 88, 100, 92, 84, 85, 81, 69, 75,
                                  80, 69, 66, 65, 64, 3, 7, 4, 62, 62, 61, 54,
                                  50, 44, 30, 17, 72 },

                                {

                                62,
                                  9, 75, 62, 9, 75, 114, 93, 13, 10, 9, 20, 51,
                                  54, 54, 14, 101, 4, 72, 3, 1, 9, 71, 6, 71,
                                  17, 51, 78, 97, 107, 106, 95, 67, 72, 3, 1,
                                  83, 87, 5, 15, 67, 78, 91, 6, 70, 83, 88, 5,
                                  74, 89, 7, 70, 79, 88, 0, 71, 72, 77, 68, 5,
                                  22, 0, 0, 0, 79, 87, 97, 68, 17, 0, 52, 8, 69,
                                  119, 96, 82, 70, 97, 115, 113, 116, 87, 115,
                                  104, 113, 115, 109, 115, 110, 6, 67, 77, 98,
                                  68, 89, 85, 113, 73, 94, 87, 118, 9, 79, 72,
                                  115, 89, 82, 75, 68, 2, 66, 78, 5, 2, 64, 5,
                                  65, 64, 2, 77, 13, 8, 24, 19, 21, 18, 17, 17,
                                  33, 12, 10, 32, 23, 68, 102, 93, 95, 85, 88,
                                  83, 77, 81, 79, 81, 85, 70, 72, 71, 66, 98,
                                  93, 95, 73, 72, 70, 69, 11, 0, 1, 65, 17, 65,
                                  3, 2, 1, 77, 53, 48, 35, 40, 48, 39, 22, 40,
                                  32, 22, 27, 17, 5, 1, 64, 20, 14, 18, 17, 14,
                                  11, 17, 10, 16, 14, 4, 5, 10, 89, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 62, 60, 61, 52, 46,
                                  29, 56, 49, 30, 62, 52, 55, 50, 44, 42, 45,
                                  32, 24, 9, 15, 69, 73, 97, 69, 24, 16, 11, 2,
                                  5, 0, 71, 73, 87, 64, 39, 26, 20, 17, 6, 64,
                                  73, 74, 81, 86, 15, 8, 4, 0, 67, 72, 76, 84,
                                  102, 92, 75, 74, 70, 72, 80, 90, 92, 108, 74,
                                  33, 17, 11, 3, 65, 74, 80, 84, 90, 62, 90, 81,
                                  75, 66, 70, 1, 4, 5, 72, 3, 7, 1, 78, 71, 69,
                                  15, 5, 21, 17, 29, 29, 19, 19, 24, 19, 15, 66,
                                  10, 67, 98, 92, 89, 84, 81, 81, 81, 82, 67,
                                  75, 74, 73, 1, 75, 82, 95, 88, 95, 76, 71, 70,
                                  70, 68, 65, 66, 0, 0, 67, 69, 4, 66, 75, 51,
                                  42, 44, 44, 43, 47, 43, 41, 35, 35, 37, 31,
                                  13, 16, 9, 36, 33, 31, 23, 25, 20, 7, 2, 66,
                                  76, 80, 92, 72, 103, 62, 62, 62, 62, 62, 62,
                                  62, 61, 56, 53, 49, 45, 36, 18, 0, 54, 52, 24,
                                  57, 62, 52, 46, 49, 44, 38, 43, 37, 35, 21,
                                  23, 12, 74, 29, 19, 3, 112, 103, 106, 80, 85,
                                  82, 4, 74, 73, 68, 0, 18, 6, 24, 69, 62, 62,
                                  61, 56, 41, 38, 10, 68, 90, 73, 41, 29, 20, 9,
                                  9, 2, 64, 68, 88, 99, 91, 83, 84, 80, 68, 75,
                                  79, 68, 65, 64, 0, 3, 8, 4, 62, 62, 59, 52,
                                  48, 42, 28, 15, 73 },

                                {

                                62,
                                  8, 75, 62, 8, 75, 113, 92, 13, 10, 9, 19, 50,
                                  53, 54, 14, 99, 4, 71, 4, 1, 8, 71, 5, 73, 16,
                                  49, 80, 98, 108, 104, 94, 67, 71, 4, 1, 83,
                                  86, 5, 14, 67, 78, 90, 5, 70, 83, 89, 5, 74,
                                  89, 7, 71, 79, 88, 0, 71, 72, 77, 68, 5, 22,
                                  0, 0, 0, 78, 88, 97, 68, 16, 0, 52, 8, 69,
                                  118, 95, 82, 70, 96, 113, 111, 115, 86, 113,
                                  103, 112, 114, 109, 114, 109, 6, 67, 76, 97,
                                  68, 89, 85, 112, 73, 94, 87, 117, 9, 79, 72,
                                  114, 89, 81, 75, 68, 2, 66, 78, 5, 2, 65, 5,
                                  65, 64, 2, 77, 13, 8, 23, 19, 20, 18, 17, 17,
                                  31, 12, 10, 30, 22, 69, 101, 92, 94, 84, 88,
                                  83, 76, 81, 79, 80, 84, 70, 72, 71, 68, 98,
                                  92, 95, 73, 73, 69, 69, 10, 1, 1, 65, 16, 64,
                                  2, 1, 1, 78, 51, 47, 34, 39, 47, 38, 21, 39,
                                  31, 20, 26, 16, 5, 1, 64, 19, 13, 17, 16, 13,
                                  10, 16, 9, 14, 12, 3, 4, 9, 89, 62, 62, 62,
                                  62, 62, 62, 62, 62, 62, 61, 58, 58, 49, 43,
                                  26, 54, 47, 28, 61, 50, 52, 47, 42, 39, 42,
                                  30, 22, 8, 13, 70, 74, 98, 69, 24, 16, 11, 2,
                                  5, 0, 71, 73, 86, 64, 39, 26, 20, 17, 7, 64,
                                  73, 74, 81, 86, 16, 8, 4, 0, 67, 72, 76, 83,
                                  101, 91, 74, 73, 70, 72, 79, 89, 91, 107, 74,
                                  33, 17, 11, 3, 64, 74, 80, 83, 90, 62, 90, 81,
                                  75, 66, 70, 1, 4, 5, 72, 3, 7, 2, 78, 71, 69,
                                  14, 5, 20, 16, 28, 28, 19, 17, 22, 19, 15, 67,
                                  9, 68, 98, 91, 88, 84, 81, 81, 80, 81, 68, 75,
                                  74, 73, 0, 75, 82, 95, 88, 96, 76, 71, 70, 69,
                                  68, 65, 66, 0, 64, 67, 68, 3, 66, 76, 50, 41,
                                  44, 43, 41, 46, 42, 40, 34, 34, 36, 30, 12,
                                  15, 8, 34, 32, 29, 21, 23, 19, 6, 1, 66, 76,
                                  80, 92, 73, 103, 62, 62, 62, 62, 62, 62, 61,
                                  58, 54, 51, 47, 42, 34, 17, 64, 52, 50, 22,
                                  55, 61, 49, 43, 46, 41, 36, 41, 34, 33, 19,
                                  20, 10, 75, 27, 17, 1, 111, 102, 105, 79, 84,
                                  82, 5, 73, 73, 68, 0, 19, 7, 25, 68, 62, 62,
                                  58, 53, 38, 35, 7, 70, 91, 73, 41, 29, 20, 9,
                                  9, 2, 64, 68, 87, 99, 90, 82, 84, 79, 68, 74,
                                  79, 68, 65, 64, 0, 4, 8, 3, 62, 62, 57, 50,
                                  46, 40, 26, 13, 74 },

                                {

                                62,
                                  8, 75, 62, 8, 75, 111, 91, 14, 10, 9, 18, 49,
                                  52, 54, 14, 97, 4, 70, 5, 1, 8, 70, 4, 74, 15,
                                  47, 81, 99, 109, 101, 92, 67, 70, 5, 1, 82,
                                  85, 6, 13, 67, 77, 89, 5, 70, 83, 89, 5, 74,
                                  88, 7, 71, 79, 88, 0, 71, 71, 77, 68, 5, 22,
                                  0, 0, 0, 77, 88, 97, 68, 15, 0, 52, 8, 69,
                                  117, 94, 82, 70, 95, 111, 109, 113, 84, 111,
                                  102, 110, 113, 108, 113, 108, 7, 66, 75, 96,
                                  68, 88, 84, 110, 73, 93, 87, 115, 10, 79, 72,
                                  112, 89, 80, 75, 68, 3, 65, 77, 5, 2, 65, 5,
                                  64, 64, 2, 76, 13, 8, 23, 19, 19, 18, 17, 17,
                                  29, 12, 10, 29, 21, 69, 100, 91, 93, 83, 87,
                                  82, 75, 80, 79, 79, 83, 70, 72, 71, 69, 97,
                                  91, 95, 72, 73, 68, 69, 9, 2, 1, 65, 15, 0, 1,
                                  0, 1, 78, 50, 46, 34, 38, 46, 37, 21, 39, 31,
                                  19, 25, 16, 5, 1, 64, 19, 12, 16, 15, 12, 9,
                                  16, 9, 13, 11, 3, 3, 8, 89, 62, 62, 62, 62,
                                  62, 62, 62, 62, 62, 59, 56, 56, 46, 41, 23,
                                  53, 45, 27, 59, 48, 50, 45, 40, 37, 40, 28,
                                  20, 8, 11, 71, 74, 98, 69, 25, 16, 11, 3, 5,
                                  0, 70, 73, 85, 64, 39, 26, 21, 17, 8, 0, 72,
                                  73, 80, 85, 17, 9, 5, 1, 66, 71, 76, 82, 100,
                                  90, 72, 72, 69, 71, 78, 88, 90, 106, 73, 33,
                                  18, 12, 3, 0, 73, 79, 82, 89, 62, 89, 80, 74,
                                  66, 70, 1, 5, 6, 72, 3, 8, 3, 78, 71, 69, 14,
                                  5, 19, 16, 27, 28, 19, 16, 21, 19, 15, 67, 8,
                                  69, 97, 90, 87, 84, 80, 81, 79, 80, 68, 75,
                                  74, 72, 0, 75, 82, 95, 87, 96, 76, 71, 70, 68,
                                  68, 65, 65, 0, 64, 67, 67, 2, 66, 76, 49, 41,
                                  44, 43, 40, 45, 41, 39, 34, 33, 35, 30, 12,
                                  14, 7, 33, 31, 27, 19, 22, 18, 6, 1, 66, 75,
                                  79, 92, 74, 102, 62, 62, 62, 62, 62, 62, 59,
                                  56, 52, 49, 45, 40, 32, 16, 65, 50, 49, 21,
                                  53, 59, 47, 41, 44, 39, 34, 39, 32, 31, 18,
                                  18, 8, 76, 25, 15, 64, 110, 100, 103, 78, 83,
                                  81, 7, 72, 72, 68, 1, 21, 8, 27, 67, 62, 62,
                                  56, 50, 36, 32, 5, 72, 92, 73, 41, 29, 20, 9,
                                  10, 2, 64, 68, 86, 98, 89, 81, 83, 77, 67, 73,
                                  78, 67, 64, 0, 0, 5, 8, 3, 62, 61, 56, 49, 44,
                                  38, 24, 11, 74 },

                                {

                                62,
                                  8, 75, 62, 8, 75, 109, 89, 14, 10, 8, 16, 47,
                                  50, 54, 14, 94, 3, 69, 5, 1, 7, 70, 3, 75, 15,
                                  45, 83, 100, 109, 98, 91, 67, 69, 5, 1, 82,
                                  84, 6, 13, 67, 77, 89, 5, 71, 82, 89, 5, 74,
                                  87, 6, 71, 79, 88, 1, 70, 71, 76, 67, 5, 22,
                                  0, 0, 0, 77, 88, 97, 67, 14, 0, 52, 8, 69,
                                  116, 93, 82, 69, 93, 110, 107, 112, 83, 110,
                                  100, 108, 112, 107, 112, 108, 8, 66, 74, 95,
                                  68, 88, 83, 108, 73, 93, 86, 114, 10, 78, 71,
                                  111, 88, 80, 75, 67, 3, 65, 76, 6, 3, 66, 4,
                                  64, 64, 2, 76, 13, 7, 22, 19, 19, 18, 17, 16,
                                  27, 12, 9, 27, 20, 70, 99, 90, 92, 82, 86, 81,
                                  74, 79, 78, 78, 82, 70, 72, 70, 70, 97, 90,
                                  95, 72, 73, 68, 69, 8, 3, 1, 65, 13, 1, 1, 64,
                                  1, 79, 48, 45, 33, 37, 45, 36, 20, 38, 31, 18,
                                  24, 16, 5, 1, 65, 18, 12, 15, 15, 11, 8, 15,
                                  8, 11, 10, 2, 2, 7, 89, 62, 62, 62, 62, 62,
                                  62, 62, 62, 62, 57, 54, 53, 44, 39, 21, 51,
                                  44, 25, 56, 46, 48, 43, 37, 35, 37, 26, 17, 7,
                                  10, 73, 75, 98, 69, 25, 17, 11, 3, 5, 0, 70,
                                  73, 85, 0, 40, 26, 21, 17, 9, 0, 71, 73, 79,
                                  84, 18, 10, 5, 1, 65, 71, 75, 82, 99, 90, 71,
                                  72, 69, 71, 77, 87, 90, 105, 73, 34, 18, 12,
                                  3, 1, 72, 78, 81, 88, 62, 89, 80, 74, 66, 70,
                                  1, 5, 6, 71, 3, 8, 3, 78, 71, 69, 13, 6, 18,
                                  15, 26, 27, 19, 15, 20, 18, 15, 68, 7, 69, 96,
                                  90, 86, 83, 80, 80, 79, 79, 68, 75, 74, 72,
                                  64, 75, 82, 94, 86, 96, 76, 70, 70, 68, 68,
                                  65, 64, 0, 64, 67, 66, 2, 67, 77, 48, 41, 43,
                                  42, 39, 44, 40, 38, 33, 32, 34, 29, 11, 13, 6,
                                  31, 29, 26, 17, 21, 17, 5, 0, 67, 75, 79, 92,
                                  74, 101, 62, 62, 62, 62, 62, 60, 57, 53, 50,
                                  47, 43, 38, 30, 14, 66, 48, 47, 20, 51, 57,
                                  45, 39, 42, 37, 32, 37, 30, 28, 16, 16, 6, 77,
                                  23, 13, 65, 109, 99, 102, 78, 82, 80, 9, 71,
                                  71, 68, 2, 22, 10, 28, 67, 62, 60, 53, 47, 33,
                                  29, 2, 74, 93, 73, 41, 29, 20, 9, 10, 2, 64,
                                  68, 86, 97, 88, 80, 82, 76, 66, 73, 77, 66, 0,
                                  1, 1, 5, 9, 3, 60, 59, 54, 47, 42, 36, 22, 9,
                                  75 },

                                {

                                62,
                                  8, 76, 62, 8, 76, 107, 88, 15, 10, 8, 15, 46,
                                  49, 54, 14, 92, 3, 69, 6, 1, 6, 70, 2, 76, 14,
                                  44, 84, 101, 110, 95, 90, 67, 69, 6, 1, 81,
                                  83, 7, 12, 66, 76, 88, 4, 71, 82, 89, 5, 73,
                                  87, 6, 71, 78, 88, 1, 70, 71, 76, 67, 5, 22,
                                  0, 0, 0, 76, 88, 97, 67, 14, 64, 52, 8, 69,
                                  115, 93, 82, 69, 92, 108, 105, 110, 82, 108,
                                  99, 106, 111, 106, 111, 107, 9, 66, 73, 95,
                                  67, 87, 83, 106, 73, 92, 86, 113, 10, 78, 71,
                                  109, 88, 79, 74, 67, 3, 65, 75, 6, 3, 66, 4,
                                  64, 64, 2, 76, 13, 7, 22, 19, 18, 18, 17, 16,
                                  25, 12, 9, 25, 19, 71, 99, 89, 92, 82, 85, 81,
                                  73, 79, 78, 78, 80, 70, 72, 70, 71, 96, 89,
                                  95, 72, 73, 67, 68, 7, 3, 1, 65, 12, 2, 0, 65,
                                  1, 80, 47, 44, 33, 37, 44, 36, 20, 37, 30, 17,
                                  23, 16, 5, 1, 65, 17, 11, 14, 14, 11, 7, 14,
                                  8, 9, 9, 2, 1, 6, 89, 62, 62, 62, 62, 62, 62,
                                  62, 62, 62, 54, 52, 51, 41, 36, 18, 49, 42,
                                  24, 54, 43, 45, 40, 35, 32, 35, 23, 15, 6, 8,
                                  74, 76, 98, 68, 26, 17, 12, 3, 5, 0, 70, 73,
                                  84, 0, 40, 27, 21, 17, 10, 1, 71, 72, 79, 83,
                                  19, 10, 6, 1, 64, 70, 75, 81, 98, 89, 70, 71,
                                  68, 71, 77, 87, 89, 103, 72, 34, 18, 12, 4, 1,
                                  72, 77, 81, 87, 62, 88, 79, 73, 66, 70, 1, 5,
                                  6, 71, 4, 8, 4, 78, 71, 70, 13, 6, 17, 14, 25,
                                  26, 19, 14, 19, 18, 15, 68, 6, 70, 95, 89, 85,
                                  83, 79, 80, 78, 79, 68, 74, 73, 71, 64, 75,
                                  82, 94, 85, 96, 76, 70, 70, 67, 68, 65, 0, 64,
                                  64, 67, 66, 1, 67, 78, 47, 40, 43, 41, 38, 44,
                                  40, 37, 32, 32, 33, 28, 10, 12, 5, 30, 28, 24,
                                  15, 19, 15, 4, 0, 67, 75, 79, 91, 75, 100, 62,
                                  62, 62, 62, 62, 58, 55, 51, 48, 44, 41, 35,
                                  28, 13, 66, 47, 46, 18, 49, 54, 43, 37, 40,
                                  35, 30, 34, 28, 26, 14, 14, 5, 79, 21, 11, 67,
                                  108, 98, 101, 77, 81, 79, 10, 70, 70, 68, 3,
                                  24, 11, 30, 66, 61, 59, 51, 44, 30, 27, 64,
                                  76, 95, 72, 41, 29, 20, 9, 10, 2, 64, 68, 85,
                                  96, 88, 79, 81, 75, 66, 72, 76, 66, 0, 1, 1,
                                  6, 9, 3, 59, 58, 52, 45, 41, 35, 19, 8, 76 },

                                {

                                62,
                                  8, 76, 62, 8, 76, 106, 86, 15, 10, 7, 13, 44,
                                  48, 54, 14, 90, 3, 68, 7, 1, 5, 70, 1, 77, 14,
                                  42, 86, 102, 110, 92, 89, 67, 68, 7, 1, 81,
                                  82, 7, 12, 66, 76, 87, 4, 72, 82, 89, 5, 73,
                                  86, 6, 72, 78, 88, 2, 70, 71, 76, 66, 5, 22,
                                  0, 0, 0, 76, 89, 97, 66, 13, 64, 52, 8, 69,
                                  114, 92, 82, 68, 91, 106, 103, 109, 81, 106,
                                  98, 104, 110, 106, 110, 106, 9, 66, 72, 94,
                                  67, 87, 82, 104, 73, 92, 85, 112, 10, 78, 70,
                                  108, 87, 78, 74, 67, 3, 65, 75, 7, 4, 67, 4,
                                  64, 64, 2, 76, 13, 6, 21, 19, 17, 18, 17, 16,
                                  23, 12, 8, 23, 18, 72, 98, 88, 91, 81, 85, 80,
                                  72, 78, 77, 77, 79, 70, 72, 70, 72, 96, 88,
                                  95, 72, 73, 66, 68, 6, 4, 1, 65, 11, 3, 0, 66,
                                  1, 81, 45, 43, 32, 36, 43, 35, 19, 36, 30, 15,
                                  22, 15, 5, 1, 66, 16, 10, 13, 13, 10, 6, 13,
                                  7, 7, 8, 1, 0, 5, 89, 62, 62, 61, 62, 62, 62,
                                  62, 62, 61, 52, 50, 48, 39, 34, 16, 47, 40,
                                  22, 52, 41, 43, 38, 33, 30, 32, 21, 12, 5, 6,
                                  75, 77, 98, 68, 26, 17, 12, 3, 5, 0, 70, 73,
                                  84, 0, 40, 27, 21, 17, 11, 1, 70, 72, 78, 83,
                                  20, 11, 6, 1, 64, 70, 74, 81, 97, 88, 69, 70,
                                  68, 71, 76, 86, 88, 102, 72, 34, 18, 12, 4, 2,
                                  71, 77, 80, 86, 62, 88, 79, 73, 66, 70, 1, 5,
                                  6, 71, 4, 8, 4, 78, 71, 70, 12, 7, 16, 13, 24,
                                  25, 19, 12, 18, 18, 15, 69, 5, 70, 95, 88, 84,
                                  82, 79, 79, 78, 78, 69, 74, 73, 71, 65, 75,
                                  82, 93, 84, 96, 76, 70, 70, 66, 68, 65, 1, 64,
                                  65, 67, 65, 0, 67, 79, 46, 40, 42, 40, 37, 43,
                                  39, 36, 31, 31, 32, 27, 9, 11, 4, 28, 27, 23,
                                  13, 18, 14, 3, 64, 68, 75, 79, 91, 75, 100,
                                  62, 62, 62, 62, 62, 56, 53, 48, 46, 42, 39,
                                  33, 26, 11, 67, 45, 44, 17, 47, 52, 41, 35,
                                  37, 33, 28, 32, 26, 23, 12, 12, 3, 80, 19, 9,
                                  68, 107, 97, 100, 76, 80, 78, 12, 69, 69, 68,
                                  4, 25, 13, 31, 65, 59, 57, 48, 41, 27, 24, 67,
                                  78, 96, 72, 41, 29, 20, 9, 10, 2, 64, 68, 85,
                                  95, 87, 78, 81, 74, 65, 72, 75, 65, 1, 2, 1,
                                  6, 9, 3, 58, 56, 50, 43, 39, 33, 17, 6, 77 },

                                {

                                62,
                                  8, 76, 62, 8, 76, 104, 85, 15, 10, 7, 12, 43,
                                  46, 54, 14, 87, 2, 67, 7, 1, 5, 69, 0, 78, 13,
                                  40, 88, 103, 111, 89, 87, 67, 67, 7, 1, 81,
                                  81, 7, 11, 66, 76, 87, 4, 72, 81, 89, 5, 73,
                                  85, 5, 72, 78, 88, 2, 69, 70, 75, 66, 5, 22,
                                  0, 0, 0, 75, 89, 97, 66, 12, 64, 52, 8, 69,
                                  113, 91, 82, 68, 89, 105, 101, 107, 80, 105,
                                  96, 102, 109, 105, 109, 106, 10, 66, 71, 93,
                                  67, 86, 81, 102, 73, 92, 85, 110, 11, 77, 70,
                                  107, 87, 78, 74, 66, 4, 64, 74, 7, 4, 67, 3,
                                  64, 64, 2, 76, 13, 6, 20, 19, 17, 18, 17, 15,
                                  21, 12, 8, 22, 17, 73, 97, 87, 90, 80, 84, 79,
                                  71, 77, 77, 76, 78, 70, 72, 69, 73, 95, 87,
                                  95, 71, 73, 66, 68, 5, 5, 1, 65, 9, 4, 64, 67,
                                  1, 81, 44, 42, 32, 35, 42, 34, 18, 36, 30, 14,
                                  21, 15, 5, 1, 66, 16, 10, 12, 13, 9, 5, 13, 6,
                                  5, 7, 0, 64, 4, 89, 61, 62, 59, 62, 61, 60,
                                  60, 60, 59, 50, 48, 46, 36, 32, 13, 45, 39,
                                  20, 49, 39, 41, 36, 30, 28, 29, 19, 10, 4, 5,
                                  77, 77, 98, 68, 26, 18, 12, 3, 5, 0, 70, 73,
                                  83, 1, 41, 27, 21, 17, 12, 2, 69, 72, 77, 82,
                                  21, 12, 6, 2, 0, 69, 74, 80, 96, 88, 67, 70,
                                  68, 70, 75, 85, 88, 101, 71, 35, 19, 12, 4, 3,
                                  70, 76, 79, 85, 62, 88, 79, 72, 66, 70, 1, 5,
                                  6, 70, 4, 9, 5, 78, 71, 70, 11, 7, 15, 12, 23,
                                  25, 19, 11, 17, 17, 15, 70, 4, 71, 94, 88, 83,
                                  82, 78, 79, 77, 77, 69, 74, 73, 71, 66, 75,
                                  82, 93, 83, 96, 76, 69, 70, 66, 68, 65, 2, 64,
                                  65, 67, 64, 0, 68, 79, 45, 40, 42, 40, 36, 42,
                                  38, 35, 31, 30, 31, 26, 8, 10, 3, 27, 25, 21,
                                  11, 17, 13, 2, 65, 68, 75, 78, 91, 76, 99, 62,
                                  62, 62, 62, 60, 54, 51, 46, 44, 40, 37, 31,
                                  24, 10, 68, 43, 42, 16, 45, 50, 39, 33, 35,
                                  31, 26, 30, 24, 21, 10, 10, 1, 81, 17, 7, 70,
                                  106, 95, 99, 76, 79, 77, 14, 68, 68, 68, 5,
                                  27, 14, 33, 65, 58, 55, 46, 38, 25, 21, 69,
                                  80, 97, 72, 41, 29, 20, 9, 10, 2, 64, 68, 84,
                                  94, 86, 77, 80, 73, 64, 71, 74, 64, 2, 3, 2,
                                  7, 10, 3, 56, 55, 49, 42, 37, 31, 15, 4, 78 },

                                {

                                61,
                                  8, 76, 61, 8, 76, 102, 83, 16, 10, 6, 10, 41,
                                  45, 54, 14, 85, 2, 66, 8, 1, 4, 69, 64, 79,
                                  13, 38, 89, 104, 111, 86, 86, 67, 66, 8, 1,
                                  80, 80, 8, 11, 66, 75, 86, 3, 73, 81, 89, 5,
                                  73, 85, 5, 72, 78, 88, 3, 69, 70, 75, 65, 5,
                                  22, 0, 0, 0, 75, 89, 97, 65, 11, 64, 52, 8,
                                  69, 112, 90, 82, 67, 88, 103, 99, 106, 79,
                                  103, 95, 100, 108, 104, 108, 105, 11, 66, 70,
                                  92, 67, 86, 81, 100, 73, 91, 84, 109, 11, 77,
                                  69, 105, 86, 77, 74, 66, 4, 64, 73, 8, 5, 68,
                                  3, 64, 64, 2, 76, 13, 5, 20, 19, 16, 18, 17,
                                  15, 19, 12, 7, 20, 16, 74, 96, 86, 89, 79, 83,
                                  79, 70, 77, 76, 75, 77, 70, 72, 69, 74, 95,
                                  86, 95, 71, 73, 65, 68, 4, 6, 1, 65, 8, 5, 64,
                                  68, 1, 82, 42, 41, 31, 34, 41, 33, 18, 35, 29,
                                  13, 20, 15, 5, 1, 67, 15, 9, 11, 12, 8, 4, 12,
                                  6, 3, 6, 0, 65, 3, 89, 60, 61, 58, 62, 59, 58,
                                  58, 58, 56, 47, 46, 43, 34, 29, 11, 43, 37,
                                  19, 47, 37, 38, 33, 28, 25, 27, 17, 7, 3, 3,
                                  78, 78, 98, 68, 27, 18, 12, 3, 5, 0, 70, 73,
                                  83, 1, 41, 27, 21, 17, 13, 2, 69, 71, 77, 81,
                                  22, 12, 7, 2, 1, 69, 73, 80, 95, 87, 66, 69,
                                  67, 70, 74, 84, 87, 100, 71, 35, 19, 12, 4, 4,
                                  70, 75, 78, 84, 62, 87, 78, 72, 66, 70, 1, 5,
                                  6, 70, 4, 9, 5, 78, 71, 70, 11, 8, 14, 11, 22,
                                  24, 19, 10, 16, 17, 15, 70, 3, 71, 93, 87, 82,
                                  81, 78, 78, 77, 76, 69, 74, 73, 70, 66, 75,
                                  82, 92, 82, 96, 76, 69, 70, 65, 68, 65, 3, 64,
                                  65, 67, 0, 64, 68, 80, 44, 39, 41, 39, 35, 41,
                                  37, 34, 30, 29, 30, 25, 7, 9, 2, 25, 24, 20,
                                  9, 15, 12, 1, 65, 69, 75, 78, 91, 76, 98, 62,
                                  62, 61, 61, 57, 52, 49, 43, 42, 38, 35, 28,
                                  22, 8, 69, 41, 41, 14, 43, 48, 37, 31, 33, 29,
                                  24, 28, 22, 18, 8, 8, 64, 82, 15, 5, 71, 105,
                                  94, 98, 75, 78, 76, 15, 67, 67, 68, 6, 28, 16,
                                  34, 64, 56, 54, 43, 35, 22, 18, 72, 82, 98,
                                  72, 41, 29, 20, 9, 10, 2, 64, 68, 84, 93, 85,
                                  76, 79, 72, 64, 71, 73, 64, 2, 3, 2, 7, 10, 3,
                                  55, 53, 47, 40, 35, 29, 13, 2, 79 },

                                {

                                60,
                                  8, 76, 60, 8, 76, 100, 82, 16, 10, 6, 9, 40,
                                  44, 54, 14, 83, 2, 65, 9, 1, 3, 69, 65, 80,
                                  12, 36, 91, 105, 112, 83, 85, 67, 65, 9, 1,
                                  80, 79, 8, 10, 66, 75, 85, 3, 73, 81, 89, 5,
                                  73, 84, 5, 72, 78, 88, 3, 69, 70, 75, 65, 5,
                                  22, 0, 0, 0, 74, 89, 97, 65, 10, 64, 52, 8,
                                  69, 111, 89, 82, 67, 87, 101, 97, 104, 78,
                                  101, 94, 98, 107, 103, 107, 104, 12, 66, 69,
                                  91, 67, 85, 80, 98, 73, 91, 84, 108, 11, 77,
                                  69, 104, 86, 76, 74, 66, 4, 64, 72, 8, 5, 68,
                                  3, 64, 64, 2, 76, 13, 5, 19, 19, 15, 18, 17,
                                  15, 17, 12, 7, 18, 15, 75, 95, 85, 88, 78, 82,
                                  78, 69, 76, 76, 74, 76, 70, 72, 69, 75, 94,
                                  85, 95, 71, 73, 64, 68, 3, 7, 1, 65, 7, 6, 65,
                                  69, 1, 83, 41, 40, 31, 33, 40, 32, 17, 34, 29,
                                  12, 19, 15, 5, 1, 67, 14, 8, 10, 11, 7, 3, 11,
                                  5, 1, 5, 64, 66, 2, 89, 58, 60, 56, 60, 57,
                                  56, 56, 56, 54, 45, 44, 41, 31, 27, 8, 41, 35,
                                  17, 45, 35, 36, 31, 26, 23, 24, 15, 5, 2, 1,
                                  79, 79, 98, 68, 27, 18, 12, 3, 5, 0, 70, 73,
                                  82, 1, 41, 27, 21, 17, 14, 3, 68, 71, 76, 80,
                                  23, 13, 7, 2, 2, 68, 73, 79, 94, 86, 65, 68,
                                  67, 70, 73, 83, 86, 99, 70, 35, 19, 12, 4, 5,
                                  69, 74, 77, 83, 62, 87, 78, 71, 66, 70, 1, 5,
                                  6, 70, 4, 9, 6, 78, 71, 70, 10, 8, 13, 10, 21,
                                  23, 19, 9, 15, 17, 15, 71, 2, 72, 92, 86, 81,
                                  81, 77, 78, 76, 75, 69, 74, 73, 70, 67, 75,
                                  82, 92, 81, 96, 76, 69, 70, 64, 68, 65, 4, 64,
                                  65, 67, 1, 65, 68, 81, 43, 39, 41, 38, 34, 40,
                                  36, 33, 29, 28, 29, 24, 6, 8, 1, 24, 23, 18,
                                  7, 14, 11, 0, 66, 69, 75, 78, 91, 77, 97, 62,
                                  62, 59, 59, 54, 50, 47, 41, 40, 36, 33, 26,
                                  20, 7, 70, 39, 39, 13, 41, 46, 35, 29, 31, 27,
                                  22, 26, 20, 16, 6, 6, 66, 83, 13, 3, 73, 104,
                                  93, 97, 74, 77, 75, 17, 66, 66, 68, 7, 30, 17,
                                  36, 0, 55, 52, 41, 32, 19, 15, 75, 84, 99, 72,
                                  41, 29, 20, 9, 10, 2, 64, 68, 83, 92, 84, 75,
                                  78, 71, 0, 70, 72, 0, 3, 4, 2, 8, 10, 3, 54,
                                  52, 45, 38, 33, 27, 11, 0, 80 },

                                {

                                58,
                                  7, 77, 58, 7, 77, 99, 81, 16, 10, 5, 7, 38,
                                  42, 53, 14, 81, 1, 65, 9, 0, 2, 69, 67, 82,
                                  11, 34, 93, 106, 113, 81, 84, 68, 65, 9, 0,
                                  80, 78, 8, 9, 66, 75, 85, 2, 74, 81, 90, 5,
                                  73, 84, 4, 73, 78, 88, 3, 69, 70, 75, 65, 4,
                                  22, 0, 0, 0, 74, 90, 97, 65, 9, 65, 52, 7, 69,
                                  110, 89, 82, 67, 86, 100, 96, 103, 77, 100,
                                  93, 97, 106, 103, 106, 104, 12, 66, 69, 91,
                                  67, 85, 80, 97, 73, 91, 84, 107, 11, 77, 69,
                                  103, 86, 76, 74, 66, 4, 64, 72, 8, 5, 69, 2,
                                  64, 65, 2, 76, 12, 4, 18, 19, 14, 17, 17, 14,
                                  15, 11, 6, 16, 14, 76, 95, 85, 88, 78, 82, 78,
                                  68, 76, 76, 74, 75, 71, 72, 69, 77, 94, 85,
                                  95, 71, 74, 64, 68, 2, 7, 1, 65, 5, 6, 66, 70,
                                  1, 84, 39, 39, 30, 32, 39, 31, 16, 33, 28, 10,
                                  18, 14, 4, 1, 68, 13, 7, 9, 10, 6, 2, 10, 4,
                                  64, 3, 65, 68, 0, 89, 56, 58, 54, 58, 55, 53,
                                  53, 53, 51, 42, 41, 38, 28, 24, 5, 39, 33, 15,
                                  42, 32, 33, 28, 23, 20, 21, 12, 2, 1, 64, 81,
                                  80, 99, 68, 27, 18, 12, 3, 5, 64, 70, 73, 82,
                                  1, 41, 27, 21, 17, 15, 3, 68, 71, 76, 80, 23,
                                  13, 7, 2, 2, 68, 73, 79, 93, 86, 64, 68, 67,
                                  70, 73, 83, 86, 98, 70, 35, 19, 12, 4, 5, 69,
                                  74, 77, 83, 62, 87, 78, 71, 66, 70, 1, 5, 6,
                                  70, 4, 9, 6, 78, 71, 71, 9, 8, 12, 9, 20, 22,
                                  18, 7, 13, 16, 14, 72, 0, 73, 92, 86, 80, 81,
                                  77, 78, 76, 75, 70, 74, 73, 70, 68, 75, 82,
                                  92, 81, 97, 76, 69, 70, 64, 69, 65, 4, 65, 66,
                                  67, 1, 66, 69, 82, 42, 38, 40, 37, 32, 39, 35,
                                  32, 28, 27, 28, 23, 5, 6, 64, 22, 21, 16, 5,
                                  12, 9, 64, 67, 70, 75, 78, 91, 78, 97, 62, 61,
                                  57, 56, 51, 47, 44, 38, 37, 33, 30, 23, 17, 5,
                                  71, 37, 37, 11, 39, 43, 32, 26, 28, 24, 20,
                                  23, 17, 13, 4, 3, 68, 85, 11, 1, 75, 103, 92,
                                  96, 74, 77, 75, 18, 66, 66, 68, 7, 31, 18, 37,
                                  0, 53, 50, 38, 28, 16, 12, 78, 87, 101, 72,
                                  41, 28, 19, 9, 10, 2, 65, 68, 83, 92, 84, 75,
                                  78, 70, 0, 70, 72, 0, 3, 4, 2, 8, 10, 2, 52,
                                  50, 43, 36, 31, 25, 8, 65, 81 },

                                {

                                57,
                                  7, 77, 57, 7, 77, 97, 79, 17, 11, 5, 6, 37,
                                  41, 53, 14, 78, 1, 64, 10, 0, 2, 68, 68, 83,
                                  11, 33, 94, 107, 113, 78, 82, 68, 64, 10, 0,
                                  79, 76, 9, 9, 65, 74, 84, 2, 74, 80, 90, 5,
                                  72, 83, 4, 73, 77, 88, 4, 68, 69, 74, 64, 4,
                                  22, 0, 0, 0, 73, 90, 97, 64, 9, 65, 52, 7, 69,
                                  108, 88, 82, 66, 84, 98, 94, 101, 75, 98, 91,
                                  95, 104, 102, 105, 103, 13, 65, 68, 90, 66,
                                  84, 79, 95, 72, 90, 83, 105, 12, 76, 68, 101,
                                  85, 75, 73, 65, 5, 0, 71, 9, 6, 69, 2, 0, 65,
                                  2, 75, 12, 4, 18, 19, 14, 17, 17, 14, 14, 11,
                                  6, 15, 13, 76, 94, 84, 87, 77, 81, 77, 67, 75,
                                  75, 73, 73, 71, 72, 68, 78, 93, 84, 95, 70,
                                  74, 0, 67, 2, 8, 1, 65, 4, 7, 66, 71, 1, 84,
                                  38, 39, 30, 32, 39, 31, 16, 33, 28, 9, 18, 14,
                                  4, 1, 68, 13, 7, 9, 10, 6, 1, 10, 4, 65, 2,
                                  65, 69, 64, 89, 55, 57, 53, 57, 54, 51, 51,
                                  51, 49, 40, 39, 36, 26, 22, 3, 38, 32, 14, 40,
                                  30, 31, 26, 21, 18, 19, 10, 0, 1, 65, 82, 80,
                                  99, 67, 28, 19, 13, 4, 5, 64, 69, 72, 81, 2,
                                  42, 28, 22, 17, 16, 4, 67, 70, 75, 79, 24, 14,
                                  8, 3, 3, 67, 72, 78, 91, 85, 1, 67, 66, 69,
                                  72, 82, 85, 96, 69, 36, 20, 13, 5, 6, 68, 73,
                                  76, 82, 62, 86, 77, 70, 66, 69, 1, 6, 7, 69,
                                  5, 10, 7, 77, 71, 71, 9, 9, 12, 9, 19, 22, 18,
                                  6, 12, 16, 14, 72, 64, 73, 91, 85, 79, 80, 76,
                                  77, 75, 74, 70, 73, 72, 69, 68, 74, 81, 91,
                                  80, 97, 76, 68, 70, 0, 69, 65, 5, 65, 66, 66,
                                  2, 66, 69, 82, 42, 38, 40, 37, 31, 39, 35, 32,
                                  28, 27, 28, 23, 5, 5, 65, 21, 20, 15, 4, 11,
                                  8, 64, 67, 70, 74, 77, 90, 78, 96, 60, 59, 55,
                                  54, 49, 45, 42, 36, 35, 31, 28, 21, 15, 4, 71,
                                  36, 36, 10, 38, 41, 30, 24, 26, 22, 18, 21,
                                  15, 11, 3, 1, 69, 86, 10, 0, 76, 101, 90, 94,
                                  73, 76, 74, 20, 65, 65, 68, 8, 33, 20, 39, 1,
                                  52, 49, 36, 25, 14, 10, 80, 89, 102, 71, 42,
                                  28, 19, 9, 11, 2, 65, 68, 82, 91, 83, 74, 77,
                                  68, 1, 69, 71, 1, 4, 5, 3, 9, 11, 2, 51, 49,
                                  42, 35, 30, 24, 6, 66, 81 },

                                {

                                56,
                                  7, 77, 56, 7, 77, 95, 78, 17, 11, 5, 5, 36,
                                  40, 53, 14, 76, 1, 0, 11, 0, 1, 68, 69, 84,
                                  10, 31, 96, 108, 114, 75, 81, 68, 0, 11, 0,
                                  79, 75, 9, 8, 65, 74, 83, 2, 74, 80, 90, 5,
                                  72, 82, 4, 73, 77, 88, 4, 68, 69, 74, 64, 4,
                                  22, 0, 0, 0, 72, 90, 97, 64, 8, 65, 52, 7, 69,
                                  107, 87, 82, 66, 83, 96, 92, 100, 74, 96, 90,
                                  93, 103, 101, 104, 102, 14, 65, 67, 89, 66,
                                  84, 78, 93, 72, 90, 83, 104, 12, 76, 68, 100,
                                  85, 74, 73, 65, 5, 0, 70, 9, 6, 70, 2, 0, 65,
                                  2, 75, 12, 4, 17, 19, 13, 17, 17, 14, 12, 11,
                                  6, 13, 12, 77, 93, 83, 86, 76, 80, 76, 66, 74,
                                  75, 72, 72, 71, 72, 68, 79, 93, 83, 95, 70,
                                  74, 1, 67, 1, 9, 1, 65, 3, 8, 67, 72, 1, 85,
                                  36, 38, 29, 31, 38, 30, 15, 32, 28, 8, 17, 14,
                                  4, 1, 68, 12, 6, 8, 9, 5, 0, 9, 3, 67, 1, 66,
                                  70, 65, 89, 53, 56, 51, 55, 52, 49, 49, 49,
                                  46, 38, 37, 33, 23, 20, 0, 36, 30, 12, 38, 28,
                                  29, 24, 19, 16, 16, 8, 65, 0, 67, 83, 81, 99,
                                  67, 28, 19, 13, 4, 5, 64, 69, 72, 80, 2, 42,
                                  28, 22, 17, 17, 4, 66, 70, 74, 78, 25, 15, 8,
                                  3, 4, 67, 72, 77, 90, 84, 2, 66, 66, 69, 71,
                                  81, 84, 95, 69, 36, 20, 13, 5, 7, 67, 72, 75,
                                  81, 62, 86, 77, 70, 66, 69, 1, 6, 7, 69, 5,
                                  10, 8, 77, 71, 71, 8, 9, 11, 8, 18, 21, 18, 5,
                                  11, 16, 14, 73, 65, 74, 90, 84, 78, 80, 76,
                                  77, 74, 73, 70, 73, 72, 69, 69, 74, 81, 91,
                                  79, 97, 76, 68, 70, 1, 69, 65, 6, 65, 66, 66,
                                  3, 67, 69, 83, 41, 38, 40, 36, 30, 38, 34, 31,
                                  27, 26, 27, 22, 4, 4, 66, 19, 19, 13, 2, 10,
                                  7, 65, 68, 70, 74, 77, 90, 79, 95, 58, 57, 53,
                                  52, 46, 43, 40, 33, 33, 29, 26, 19, 13, 3, 72,
                                  34, 34, 9, 36, 39, 28, 22, 24, 20, 16, 19, 13,
                                  9, 1, 64, 71, 87, 8, 65, 78, 100, 89, 93, 72,
                                  75, 73, 22, 64, 64, 68, 9, 34, 21, 40, 2, 51,
                                  47, 33, 22, 11, 7, 83, 91, 103, 71, 42, 28,
                                  19, 9, 11, 2, 65, 68, 81, 90, 82, 73, 76, 67,
                                  2, 68, 70, 2, 5, 6, 3, 10, 11, 2, 50, 47, 40,
                                  33, 28, 22, 4, 68, 82 },

                                {

                                55,
                                  7, 77, 55, 7, 77, 93, 76, 18, 11, 4, 3, 34,
                                  39, 53, 14, 74, 1, 1, 12, 0, 0, 68, 70, 85,
                                  10, 29, 97, 109, 114, 72, 80, 68, 1, 12, 0,
                                  78, 74, 10, 8, 65, 73, 82, 1, 75, 80, 90, 5,
                                  72, 82, 4, 73, 77, 88, 5, 68, 69, 74, 0, 4,
                                  22, 0, 0, 0, 72, 90, 97, 0, 7, 65, 52, 7, 69,
                                  106, 86, 82, 65, 82, 94, 90, 98, 73, 94, 89,
                                  91, 102, 100, 103, 101, 15, 65, 66, 88, 66,
                                  83, 78, 91, 72, 89, 82, 103, 12, 76, 67, 98,
                                  84, 73, 73, 65, 5, 0, 69, 10, 7, 70, 2, 0, 65,
                                  2, 75, 12, 3, 17, 19, 12, 17, 17, 14, 10, 11,
                                  5, 11, 11, 78, 92, 82, 85, 75, 79, 76, 65, 74,
                                  74, 71, 71, 71, 72, 68, 80, 92, 82, 95, 70,
                                  74, 2, 67, 0, 10, 1, 65, 2, 9, 67, 73, 1, 86,
                                  35, 37, 29, 30, 37, 29, 15, 31, 27, 7, 16, 14,
                                  4, 1, 69, 11, 5, 7, 8, 4, 64, 8, 3, 69, 0, 66,
                                  71, 66, 89, 52, 54, 50, 53, 50, 47, 47, 47,
                                  44, 35, 35, 31, 21, 17, 65, 34, 28, 11, 36,
                                  26, 26, 21, 17, 13, 14, 6, 68, 64, 69, 84, 82,
                                  99, 67, 29, 19, 13, 4, 5, 64, 69, 72, 80, 2,
                                  42, 28, 22, 17, 18, 5, 66, 69, 74, 77, 26, 15,
                                  9, 3, 5, 66, 71, 77, 89, 83, 3, 65, 65, 69,
                                  70, 80, 83, 94, 68, 36, 20, 13, 5, 8, 67, 71,
                                  74, 80, 62, 85, 76, 69, 66, 69, 1, 6, 7, 69,
                                  5, 10, 8, 77, 71, 71, 8, 10, 10, 7, 17, 20,
                                  18, 4, 10, 16, 14, 73, 66, 74, 89, 83, 77, 79,
                                  75, 76, 74, 72, 70, 73, 72, 68, 69, 74, 81,
                                  90, 78, 97, 76, 68, 70, 2, 69, 65, 7, 65, 66,
                                  66, 4, 68, 69, 84, 40, 37, 39, 35, 29, 37, 33,
                                  30, 26, 25, 26, 21, 3, 3, 67, 18, 18, 12, 0,
                                  8, 6, 66, 68, 71, 74, 77, 90, 79, 94, 56, 55,
                                  51, 50, 43, 41, 38, 31, 31, 27, 24, 16, 11, 1,
                                  73, 32, 33, 7, 34, 37, 26, 20, 22, 18, 14, 17,
                                  11, 6, 64, 66, 73, 88, 6, 67, 79, 99, 88, 92,
                                  71, 74, 72, 23, 0, 0, 68, 10, 36, 23, 42, 3,
                                  49, 46, 31, 19, 8, 4, 86, 93, 104, 71, 42, 28,
                                  19, 9, 11, 2, 65, 68, 81, 89, 81, 72, 75, 66,
                                  2, 68, 69, 2, 5, 6, 3, 10, 11, 2, 49, 46, 38,
                                  31, 26, 20, 2, 70, 83 },

                                {

                                53,
                                  7, 77, 53, 7, 77, 92, 75, 18, 11, 4, 2, 33,
                                  37, 53, 14, 71, 0, 2, 12, 0, 64, 68, 71, 86,
                                  9, 27, 99, 110, 115, 69, 79, 68, 2, 12, 0, 78,
                                  73, 10, 7, 65, 73, 82, 1, 75, 79, 90, 5, 72,
                                  81, 3, 74, 77, 88, 5, 67, 69, 73, 0, 4, 22, 0,
                                  0, 0, 71, 91, 97, 0, 6, 65, 52, 7, 69, 105,
                                  85, 82, 65, 80, 93, 88, 97, 72, 93, 87, 89,
                                  101, 100, 102, 101, 15, 65, 65, 87, 66, 83,
                                  77, 89, 72, 89, 82, 102, 12, 75, 67, 97, 84,
                                  73, 73, 64, 5, 0, 69, 10, 7, 71, 1, 0, 65, 2,
                                  75, 12, 3, 16, 19, 12, 17, 17, 13, 8, 11, 5,
                                  9, 10, 79, 91, 81, 84, 74, 79, 75, 64, 73, 74,
                                  70, 70, 71, 72, 67, 81, 92, 81, 95, 70, 74, 2,
                                  67, 64, 11, 1, 65, 0, 10, 68, 74, 1, 87, 33,
                                  36, 28, 29, 36, 28, 14, 30, 27, 5, 15, 13, 4,
                                  1, 69, 10, 5, 6, 8, 3, 65, 7, 2, 71, 64, 67,
                                  72, 67, 89, 50, 53, 48, 51, 48, 45, 44, 45,
                                  41, 33, 33, 28, 18, 15, 68, 32, 27, 9, 33, 24,
                                  24, 19, 14, 11, 11, 4, 70, 65, 70, 86, 83, 99,
                                  67, 29, 20, 13, 4, 5, 64, 69, 72, 79, 3, 43,
                                  28, 22, 17, 19, 5, 65, 69, 73, 77, 27, 16, 9,
                                  3, 5, 66, 71, 76, 88, 83, 4, 65, 65, 69, 69,
                                  79, 83, 93, 68, 37, 20, 13, 5, 9, 66, 71, 73,
                                  79, 62, 85, 76, 69, 66, 69, 1, 6, 7, 68, 5,
                                  10, 9, 77, 71, 71, 7, 10, 9, 6, 16, 19, 18, 2,
                                  9, 15, 14, 74, 67, 75, 89, 83, 76, 79, 75, 76,
                                  73, 71, 71, 73, 72, 68, 70, 74, 81, 90, 77,
                                  97, 76, 67, 70, 2, 69, 65, 8, 65, 67, 66, 5,
                                  68, 70, 85, 39, 37, 39, 34, 28, 36, 32, 29,
                                  25, 24, 25, 20, 2, 2, 68, 16, 16, 10, 65, 7,
                                  5, 67, 69, 71, 74, 77, 90, 80, 94, 53, 52, 49,
                                  47, 40, 39, 36, 28, 29, 25, 22, 14, 9, 0, 74,
                                  30, 31, 6, 32, 35, 24, 18, 19, 16, 12, 15, 9,
                                  4, 66, 68, 75, 89, 4, 69, 81, 98, 87, 91, 71,
                                  73, 71, 25, 1, 1, 68, 11, 37, 24, 43, 3, 48,
                                  44, 28, 16, 5, 1, 89, 95, 105, 71, 42, 28, 19,
                                  9, 11, 2, 65, 68, 80, 88, 80, 71, 75, 65, 3,
                                  67, 68, 3, 6, 7, 4, 11, 12, 2, 47, 44, 36, 29,
                                  24, 18, 0, 72, 84 },

                                {

                                52,
                                  7, 77, 52, 7, 77, 90, 73, 18, 11, 3, 0, 31,
                                  36, 53, 14, 69, 0, 3, 13, 0, 64, 67, 72, 87,
                                  9, 25, 101, 111, 115, 66, 77, 68, 3, 13, 0,
                                  78, 72, 10, 7, 65, 73, 81, 1, 76, 79, 90, 5,
                                  72, 80, 3, 74, 77, 88, 6, 67, 68, 73, 1, 4,
                                  22, 0, 0, 0, 71, 91, 97, 1, 5, 65, 52, 7, 69,
                                  104, 84, 82, 64, 79, 91, 86, 95, 71, 91, 86,
                                  87, 100, 99, 101, 100, 16, 65, 64, 86, 66, 82,
                                  76, 87, 72, 89, 81, 100, 13, 75, 66, 96, 83,
                                  72, 73, 64, 6, 1, 68, 11, 8, 71, 1, 0, 65, 2,
                                  75, 12, 2, 15, 19, 11, 17, 17, 13, 6, 11, 4,
                                  8, 9, 80, 90, 80, 83, 73, 78, 74, 0, 72, 73,
                                  69, 69, 71, 72, 67, 82, 91, 80, 95, 69, 74, 3,
                                  67, 65, 12, 1, 65, 64, 11, 68, 75, 1, 87, 32,
                                  35, 28, 28, 35, 27, 13, 30, 27, 4, 14, 13, 4,
                                  1, 70, 10, 4, 5, 7, 2, 66, 7, 1, 73, 65, 68,
                                  73, 68, 89, 48, 52, 46, 49, 47, 43, 42, 43,
                                  39, 31, 31, 26, 16, 13, 70, 30, 25, 7, 31, 22,
                                  22, 17, 12, 9, 8, 2, 73, 66, 72, 87, 83, 99,
                                  67, 29, 20, 13, 4, 5, 64, 69, 72, 79, 3, 43,
                                  28, 22, 17, 20, 6, 64, 69, 72, 76, 28, 17, 9,
                                  4, 6, 65, 70, 76, 87, 82, 6, 64, 65, 68, 68,
                                  78, 82, 92, 67, 37, 21, 13, 5, 10, 65, 70, 72,
                                  78, 62, 85, 76, 68, 66, 69, 1, 6, 7, 68, 5,
                                  11, 9, 77, 71, 71, 6, 11, 8, 5, 15, 19, 18, 1,
                                  8, 15, 14, 75, 68, 75, 88, 82, 75, 78, 74, 75,
                                  73, 70, 71, 73, 72, 68, 71, 74, 81, 89, 76,
                                  97, 76, 67, 70, 3, 69, 65, 9, 65, 67, 66, 6,
                                  69, 70, 85, 38, 37, 38, 34, 27, 35, 31, 28,
                                  25, 23, 24, 19, 1, 1, 69, 15, 15, 9, 67, 6, 4,
                                  68, 70, 72, 74, 76, 90, 80, 93, 51, 50, 47,
                                  45, 38, 37, 34, 26, 27, 23, 20, 12, 7, 65, 75,
                                  28, 29, 5, 30, 33, 22, 16, 17, 14, 10, 13, 7,
                                  1, 68, 70, 77, 90, 2, 71, 82, 97, 85, 90, 70,
                                  72, 70, 27, 2, 2, 68, 12, 39, 26, 45, 4, 46,
                                  42, 26, 13, 3, 65, 91, 97, 106, 71, 42, 28,
                                  19, 9, 11, 2, 65, 68, 80, 87, 79, 70, 74, 64,
                                  4, 67, 67, 4, 7, 8, 4, 11, 12, 2, 46, 43, 35,
                                  28, 22, 16, 65, 74, 85 },

                                {

                                51,
                                  7, 78, 51, 7, 78, 88, 72, 19, 11, 3, 64, 30,
                                  35, 53, 14, 67, 0, 3, 14, 0, 65, 67, 73, 88,
                                  8, 24, 102, 112, 116, 0, 76, 68, 3, 14, 0, 77,
                                  71, 11, 6, 64, 72, 80, 0, 76, 79, 90, 5, 71,
                                  80, 3, 74, 76, 88, 6, 67, 68, 73, 1, 4, 22, 0,
                                  0, 0, 70, 91, 97, 1, 5, 66, 52, 7, 69, 103,
                                  84, 82, 64, 78, 89, 84, 94, 70, 89, 85, 85,
                                  99, 98, 100, 99, 17, 65, 0, 86, 65, 82, 76,
                                  85, 72, 88, 81, 99, 13, 75, 66, 94, 83, 71,
                                  72, 64, 6, 1, 67, 11, 8, 72, 1, 0, 65, 2, 75,
                                  12, 2, 15, 19, 10, 17, 17, 13, 4, 11, 4, 6, 8,
                                  81, 90, 79, 83, 73, 77, 74, 1, 72, 73, 69, 67,
                                  71, 72, 67, 83, 91, 79, 95, 69, 74, 4, 66, 66,
                                  12, 1, 65, 65, 12, 69, 76, 1, 88, 30, 34, 27,
                                  28, 34, 27, 13, 29, 26, 3, 13, 13, 4, 1, 70,
                                  9, 3, 4, 6, 2, 67, 6, 1, 75, 66, 68, 74, 69,
                                  89, 47, 50, 45, 47, 45, 41, 40, 41, 36, 28,
                                  29, 23, 13, 10, 73, 28, 23, 6, 29, 19, 19, 14,
                                  10, 6, 6, 64, 75, 67, 74, 88, 84, 99, 66, 30,
                                  20, 14, 4, 5, 64, 69, 72, 78, 3, 43, 29, 22,
                                  17, 21, 6, 64, 68, 72, 75, 29, 17, 10, 4, 7,
                                  65, 70, 75, 86, 81, 7, 0, 64, 68, 68, 78, 81,
                                  90, 67, 37, 21, 13, 6, 10, 65, 69, 72, 77, 62,
                                  84, 75, 68, 66, 69, 1, 6, 7, 68, 6, 11, 10,
                                  77, 71, 72, 6, 11, 7, 4, 14, 18, 18, 0, 7, 15,
                                  14, 75, 69, 76, 87, 81, 74, 78, 74, 75, 72,
                                  70, 71, 72, 71, 67, 71, 74, 81, 89, 75, 97,
                                  76, 67, 70, 4, 69, 65, 10, 66, 67, 66, 6, 70,
                                  70, 86, 37, 36, 38, 33, 26, 35, 31, 27, 24,
                                  23, 23, 18, 0, 0, 70, 13, 14, 7, 69, 4, 2, 69,
                                  70, 72, 74, 76, 89, 81, 92, 49, 48, 45, 43,
                                  35, 35, 32, 23, 25, 20, 18, 9, 5, 66, 75, 27,
                                  28, 3, 28, 30, 20, 14, 15, 12, 8, 10, 5, 64,
                                  70, 72, 78, 92, 0, 73, 84, 96, 84, 89, 69, 71,
                                  69, 28, 3, 3, 68, 13, 40, 27, 46, 5, 45, 41,
                                  23, 10, 0, 67, 94, 99, 108, 70, 42, 28, 19, 9,
                                  11, 2, 65, 68, 79, 86, 79, 69, 73, 0, 4, 66,
                                  66, 4, 7, 8, 4, 12, 12, 2, 45, 41, 33, 26, 21,
                                  15, 68, 75, 86 },

                                {

                                50,
                                  7, 78, 50, 7, 78, 86, 70, 19, 11, 2, 66, 28,
                                  33, 53, 14, 64, 64, 4, 14, 0, 66, 67, 74, 89,
                                  8, 22, 104, 113, 116, 3, 75, 68, 4, 14, 0, 77,
                                  70, 11, 6, 64, 72, 80, 0, 77, 78, 90, 5, 71,
                                  79, 2, 74, 76, 88, 7, 66, 68, 72, 2, 4, 22, 0,
                                  0, 0, 70, 91, 97, 2, 4, 66, 52, 7, 69, 102,
                                  83, 82, 0, 76, 88, 82, 92, 69, 88, 83, 83, 98,
                                  97, 99, 99, 18, 65, 1, 85, 65, 81, 75, 83, 72,
                                  88, 80, 98, 13, 74, 65, 93, 82, 71, 72, 0, 6,
                                  1, 66, 12, 9, 72, 0, 0, 65, 2, 75, 12, 1, 14,
                                  19, 10, 17, 17, 12, 2, 11, 3, 4, 7, 82, 89,
                                  78, 82, 72, 76, 73, 2, 71, 72, 68, 66, 71, 72,
                                  66, 84, 90, 78, 95, 69, 74, 4, 66, 67, 13, 1,
                                  65, 67, 13, 69, 77, 1, 89, 29, 33, 27, 27, 33,
                                  26, 12, 28, 26, 2, 12, 13, 4, 1, 71, 8, 3, 3,
                                  6, 1, 68, 5, 0, 77, 67, 69, 75, 70, 89, 45,
                                  49, 43, 45, 43, 39, 37, 39, 34, 26, 27, 21,
                                  11, 8, 75, 26, 22, 4, 26, 17, 17, 12, 7, 4, 3,
                                  66, 78, 68, 75, 90, 85, 99, 66, 30, 21, 14, 4,
                                  5, 64, 69, 72, 78, 4, 44, 29, 22, 17, 22, 7,
                                  0, 68, 71, 74, 30, 18, 10, 4, 8, 64, 69, 75,
                                  85, 81, 8, 0, 64, 68, 67, 77, 81, 89, 66, 38,
                                  21, 13, 6, 11, 64, 68, 71, 76, 62, 84, 75, 67,
                                  66, 69, 1, 6, 7, 67, 6, 11, 10, 77, 71, 72, 5,
                                  12, 6, 3, 13, 17, 18, 64, 6, 14, 14, 76, 70,
                                  76, 86, 81, 73, 77, 73, 74, 72, 69, 71, 72,
                                  71, 67, 72, 74, 81, 88, 74, 97, 76, 66, 70, 4,
                                  69, 65, 11, 66, 67, 66, 7, 70, 71, 87, 36, 36,
                                  37, 32, 25, 34, 30, 26, 23, 22, 22, 17, 64,
                                  64, 71, 12, 12, 6, 71, 3, 1, 70, 71, 73, 74,
                                  76, 89, 81, 91, 47, 46, 43, 40, 32, 33, 30,
                                  21, 23, 18, 16, 7, 3, 68, 76, 25, 26, 2, 26,
                                  28, 18, 12, 13, 10, 6, 8, 3, 67, 72, 74, 80,
                                  93, 65, 75, 85, 95, 83, 88, 69, 70, 68, 30, 4,
                                  4, 68, 14, 42, 29, 48, 5, 43, 39, 21, 7, 66,
                                  70, 97, 101, 109, 70, 42, 28, 19, 9, 11, 2,
                                  65, 68, 79, 85, 78, 68, 72, 1, 5, 66, 65, 5,
                                  8, 9, 5, 12, 13, 2, 43, 40, 31, 24, 19, 13,
                                  70, 77, 87 },

                                {

                                48,
                                  6, 78, 48, 6, 78, 85, 69, 19, 11, 2, 67, 27,
                                  32, 53, 14, 1, 64, 5, 15, 0, 67, 67, 75, 91,
                                  7, 20, 106, 114, 117, 5, 74, 68, 5, 15, 0, 77,
                                  69, 11, 5, 64, 72, 79, 64, 77, 78, 91, 5, 71,
                                  79, 2, 75, 76, 88, 7, 66, 68, 72, 2, 4, 22, 0,
                                  0, 0, 69, 92, 97, 2, 3, 66, 52, 7, 69, 101,
                                  82, 82, 0, 75, 86, 80, 91, 68, 86, 82, 82, 97,
                                  97, 98, 98, 18, 65, 2, 84, 65, 81, 75, 82, 72,
                                  88, 80, 97, 13, 74, 65, 92, 82, 70, 72, 0, 6,
                                  1, 66, 12, 9, 73, 0, 0, 65, 2, 75, 12, 1, 13,
                                  19, 9, 17, 17, 12, 0, 11, 3, 2, 6, 83, 88, 77,
                                  81, 71, 76, 73, 3, 71, 72, 67, 65, 71, 72, 66,
                                  86, 90, 77, 95, 69, 75, 5, 66, 68, 14, 1, 65,
                                  68, 14, 70, 78, 1, 90, 27, 32, 26, 26, 32, 25,
                                  11, 27, 25, 0, 11, 12, 4, 1, 71, 7, 2, 2, 5,
                                  0, 69, 4, 64, 79, 69, 70, 76, 71, 89, 43, 47,
                                  41, 43, 41, 37, 35, 37, 31, 23, 25, 18, 8, 5,
                                  78, 24, 20, 2, 24, 15, 14, 9, 5, 1, 0, 68, 80,
                                  69, 77, 91, 86, 100, 66, 30, 21, 14, 4, 5, 64,
                                  69, 72, 77, 4, 44, 29, 22, 17, 23, 7, 0, 68,
                                  71, 74, 31, 18, 10, 4, 8, 64, 69, 74, 84, 80,
                                  9, 1, 64, 68, 66, 76, 80, 88, 66, 38, 21, 13,
                                  6, 12, 64, 68, 70, 76, 62, 84, 75, 67, 66, 69,
                                  1, 6, 7, 67, 6, 11, 11, 77, 71, 72, 4, 12, 5,
                                  2, 12, 16, 18, 66, 4, 14, 14, 77, 71, 77, 86,
                                  80, 72, 77, 73, 74, 71, 68, 72, 72, 71, 67,
                                  73, 74, 81, 88, 74, 98, 76, 66, 70, 5, 69, 65,
                                  11, 66, 68, 66, 8, 71, 71, 88, 35, 35, 37, 31,
                                  23, 33, 29, 25, 22, 21, 21, 16, 65, 65, 72,
                                  10, 11, 4, 73, 1, 0, 71, 72, 73, 74, 76, 89,
                                  82, 91, 44, 43, 41, 38, 29, 30, 27, 18, 21,
                                  16, 14, 4, 1, 69, 77, 23, 24, 0, 24, 26, 15,
                                  9, 10, 7, 4, 6, 0, 69, 74, 77, 82, 94, 67, 77,
                                  87, 94, 82, 87, 68, 69, 68, 31, 5, 4, 68, 14,
                                  43, 30, 49, 6, 42, 37, 18, 4, 69, 73, 100,
                                  103, 110, 70, 42, 28, 19, 9, 11, 2, 65, 68,
                                  78, 85, 77, 67, 72, 2, 5, 65, 65, 5, 8, 9, 5,
                                  13, 13, 1, 42, 38, 29, 22, 17, 11, 72, 79, 88 },

                                {

                                47,
                                  6, 78, 47, 6, 78, 83, 68, 20, 11, 2, 68, 26,
                                  31, 53, 14, 3, 64, 6, 16, 0, 67, 66, 76, 92,
                                  6, 18, 107, 115, 118, 8, 72, 68, 6, 16, 0, 76,
                                  68, 12, 4, 64, 71, 78, 64, 77, 78, 91, 5, 71,
                                  78, 2, 75, 76, 88, 7, 66, 67, 72, 2, 4, 22, 0,
                                  0, 0, 68, 92, 97, 2, 2, 66, 52, 7, 69, 100,
                                  81, 82, 0, 74, 84, 78, 89, 66, 84, 81, 80, 96,
                                  96, 97, 97, 19, 64, 3, 83, 65, 80, 74, 80, 72,
                                  87, 80, 95, 14, 74, 65, 90, 82, 69, 72, 0, 7,
                                  2, 65, 12, 9, 73, 0, 1, 65, 2, 74, 12, 1, 13,
                                  19, 8, 17, 17, 12, 65, 11, 3, 1, 5, 83, 87,
                                  76, 80, 70, 75, 72, 4, 70, 72, 66, 64, 71, 72,
                                  66, 87, 89, 76, 95, 68, 75, 6, 66, 69, 15, 1,
                                  65, 69, 15, 71, 79, 1, 90, 26, 31, 26, 25, 31,
                                  24, 11, 27, 25, 64, 10, 12, 4, 1, 71, 7, 1, 1,
                                  4, 64, 70, 4, 64, 80, 70, 70, 77, 72, 89, 42,
                                  46, 40, 42, 40, 35, 33, 35, 29, 21, 23, 16, 5,
                                  3, 81, 23, 18, 1, 22, 13, 12, 7, 3, 64, 65,
                                  70, 82, 69, 79, 92, 86, 100, 66, 31, 21, 14,
                                  5, 5, 64, 68, 72, 76, 4, 44, 29, 23, 17, 24,
                                  8, 1, 67, 70, 73, 32, 19, 11, 5, 9, 0, 69, 73,
                                  83, 79, 11, 2, 0, 67, 65, 75, 79, 87, 65, 38,
                                  22, 14, 6, 13, 0, 67, 69, 75, 62, 83, 74, 66,
                                  66, 69, 1, 7, 8, 67, 6, 12, 12, 77, 71, 72, 4,
                                  12, 4, 2, 11, 16, 18, 67, 3, 14, 14, 77, 72,
                                  78, 85, 79, 71, 77, 72, 74, 70, 67, 72, 72,
                                  71, 66, 73, 74, 81, 88, 73, 98, 76, 66, 70, 6,
                                  69, 65, 12, 66, 68, 66, 9, 72, 71, 88, 34, 35,
                                  37, 31, 22, 32, 28, 24, 22, 20, 20, 16, 65,
                                  66, 73, 9, 10, 2, 75, 0, 64, 71, 72, 73, 73,
                                  75, 89, 83, 90, 42, 41, 39, 36, 27, 28, 25,
                                  16, 19, 14, 12, 2, 64, 70, 78, 21, 23, 64, 22,
                                  24, 13, 7, 8, 5, 2, 4, 65, 71, 75, 79, 84, 95,
                                  69, 79, 89, 93, 80, 85, 67, 68, 67, 33, 6, 5,
                                  68, 15, 45, 31, 51, 7, 41, 36, 16, 1, 71, 76,
                                  102, 105, 111, 70, 42, 28, 19, 9, 12, 2, 65,
                                  68, 77, 84, 76, 66, 71, 4, 6, 64, 64, 6, 9,
                                  10, 5, 14, 13, 1, 41, 37, 28, 21, 15, 9, 74,
                                  81, 88 },

                                {

                                46,
                                  6, 78, 46, 6, 78, 81, 66, 20, 11, 1, 70, 24,
                                  29, 53, 14, 6, 65, 7, 16, 0, 68, 66, 77, 93,
                                  6, 16, 109, 116, 118, 11, 71, 68, 7, 16, 0,
                                  76, 67, 12, 4, 64, 71, 78, 64, 78, 77, 91, 5,
                                  71, 77, 1, 75, 76, 88, 8, 65, 67, 71, 3, 4,
                                  22, 0, 0, 0, 68, 92, 97, 3, 1, 66, 52, 7, 69,
                                  99, 80, 82, 1, 72, 83, 76, 88, 65, 83, 79, 78,
                                  95, 95, 96, 97, 20, 64, 4, 82, 65, 80, 73, 78,
                                  72, 87, 79, 94, 14, 73, 64, 89, 81, 69, 72, 1,
                                  7, 2, 64, 13, 10, 74, 64, 1, 65, 2, 74, 12, 0,
                                  12, 19, 8, 17, 17, 11, 67, 11, 2, 64, 4, 84,
                                  86, 75, 79, 69, 74, 71, 5, 69, 71, 65, 0, 71,
                                  72, 65, 88, 89, 75, 95, 68, 75, 6, 66, 70, 16,
                                  1, 65, 71, 16, 71, 80, 1, 91, 24, 30, 25, 24,
                                  30, 23, 10, 26, 25, 65, 9, 12, 4, 1, 72, 6, 1,
                                  0, 4, 65, 71, 3, 65, 82, 71, 71, 78, 73, 89,
                                  40, 45, 38, 40, 38, 33, 30, 33, 26, 19, 21,
                                  13, 3, 1, 83, 21, 17, 64, 19, 11, 10, 5, 0,
                                  66, 68, 72, 85, 70, 80, 94, 87, 100, 66, 31,
                                  22, 14, 5, 5, 64, 68, 72, 76, 5, 45, 29, 23,
                                  17, 25, 8, 2, 67, 69, 72, 33, 20, 11, 5, 10,
                                  0, 68, 73, 82, 79, 12, 2, 0, 67, 64, 74, 79,
                                  86, 65, 39, 22, 14, 6, 14, 1, 66, 68, 74, 62,
                                  83, 74, 66, 66, 69, 1, 7, 8, 66, 6, 12, 12,
                                  77, 71, 72, 3, 13, 3, 1, 10, 15, 18, 68, 2,
                                  13, 14, 78, 73, 78, 84, 79, 70, 76, 72, 73,
                                  70, 66, 72, 72, 71, 66, 74, 74, 81, 87, 72,
                                  98, 76, 65, 70, 6, 69, 65, 13, 66, 68, 66, 10,
                                  72, 72, 89, 33, 35, 36, 30, 21, 31, 27, 23,
                                  21, 19, 19, 15, 66, 67, 74, 7, 8, 1, 77, 64,
                                  65, 72, 73, 74, 73, 75, 89, 83, 89, 40, 39,
                                  37, 33, 24, 26, 23, 13, 17, 12, 10, 0, 66, 72,
                                  79, 19, 21, 65, 20, 22, 11, 5, 6, 3, 0, 2, 67,
                                  74, 77, 81, 86, 96, 71, 81, 90, 92, 79, 84,
                                  67, 67, 66, 35, 7, 6, 68, 16, 46, 33, 52, 7,
                                  39, 34, 13, 65, 74, 79, 105, 107, 112, 70, 42,
                                  28, 19, 9, 12, 2, 65, 68, 77, 83, 75, 65, 70,
                                  5, 7, 64, 0, 7, 10, 11, 6, 14, 14, 1, 39, 35,
                                  26, 19, 13, 7, 76, 83, 89 },

                                {

                                45,
                                  6, 79, 45, 6, 79, 79, 65, 21, 11, 1, 71, 23,
                                  28, 53, 14, 8, 65, 7, 17, 0, 69, 66, 78, 94,
                                  5, 15, 110, 117, 119, 14, 70, 68, 7, 17, 0,
                                  75, 66, 13, 3, 0, 70, 77, 65, 78, 77, 91, 5,
                                  70, 77, 1, 75, 75, 88, 8, 65, 67, 71, 3, 4,
                                  22, 0, 0, 0, 67, 92, 97, 3, 1, 67, 52, 7, 69,
                                  98, 80, 82, 1, 71, 81, 74, 86, 64, 81, 78, 76,
                                  94, 94, 95, 96, 21, 64, 5, 82, 64, 79, 73, 76,
                                  72, 86, 79, 93, 14, 73, 64, 87, 81, 68, 71, 1,
                                  7, 2, 0, 13, 10, 74, 64, 1, 65, 2, 74, 12, 0,
                                  12, 19, 7, 17, 17, 11, 69, 11, 2, 66, 3, 85,
                                  86, 74, 79, 69, 73, 71, 6, 69, 71, 65, 2, 71,
                                  72, 65, 89, 88, 74, 95, 68, 75, 7, 65, 71, 16,
                                  1, 65, 72, 17, 72, 81, 1, 92, 23, 29, 25, 24,
                                  29, 23, 10, 25, 24, 66, 8, 12, 4, 1, 72, 5, 0,
                                  64, 3, 65, 72, 2, 65, 84, 72, 71, 79, 74, 89,
                                  39, 43, 37, 38, 36, 31, 28, 31, 24, 16, 19,
                                  11, 0, 65, 86, 19, 15, 65, 17, 8, 7, 2, 65,
                                  69, 70, 75, 87, 71, 82, 95, 88, 100, 65, 32,
                                  22, 15, 5, 5, 64, 68, 72, 75, 5, 45, 30, 23,
                                  17, 26, 9, 2, 66, 69, 71, 34, 20, 12, 5, 11,
                                  1, 68, 72, 81, 78, 13, 3, 1, 67, 64, 74, 78,
                                  84, 64, 39, 22, 14, 7, 14, 1, 65, 68, 73, 62,
                                  82, 73, 65, 66, 69, 1, 7, 8, 66, 7, 12, 13,
                                  77, 71, 73, 3, 13, 2, 0, 9, 14, 18, 69, 1, 13,
                                  14, 78, 74, 79, 83, 78, 69, 76, 71, 73, 69,
                                  66, 72, 71, 70, 65, 74, 74, 81, 87, 71, 98,
                                  76, 65, 70, 7, 69, 65, 14, 67, 68, 66, 10, 73,
                                  72, 90, 32, 34, 36, 29, 20, 31, 27, 22, 20,
                                  19, 18, 14, 67, 68, 75, 6, 7, 64, 79, 66, 67,
                                  73, 73, 74, 73, 75, 88, 84, 88, 38, 37, 35,
                                  31, 21, 24, 21, 11, 15, 9, 8, 66, 68, 73, 79,
                                  18, 20, 67, 18, 19, 9, 3, 4, 1, 65, 64, 69,
                                  76, 79, 83, 87, 98, 73, 83, 92, 91, 78, 83,
                                  66, 66, 65, 36, 8, 7, 68, 17, 48, 34, 54, 8,
                                  38, 33, 11, 68, 77, 81, 108, 109, 114, 69, 42,
                                  28, 19, 9, 12, 2, 65, 68, 76, 82, 75, 64, 69,
                                  6, 7, 0, 1, 7, 10, 11, 6, 15, 14, 1, 38, 34,
                                  24, 17, 12, 6, 79, 84, 90 },

                                {

                                43,
                                  6, 79, 43, 6, 79, 78, 0, 21, 11, 0, 73, 21,
                                  27, 53, 14, 10, 65, 8, 18, 0, 70, 66, 79, 95,
                                  5, 13, 112, 118, 119, 17, 69, 68, 8, 18, 0,
                                  75, 65, 13, 3, 0, 70, 76, 65, 79, 77, 91, 5,
                                  70, 76, 1, 76, 75, 88, 9, 65, 67, 71, 4, 4,
                                  22, 0, 0, 0, 67, 93, 97, 4, 0, 67, 52, 7, 69,
                                  97, 79, 82, 2, 70, 79, 72, 85, 0, 79, 77, 74,
                                  93, 94, 94, 95, 21, 64, 6, 81, 64, 79, 72, 74,
                                  72, 86, 78, 92, 14, 73, 0, 86, 80, 67, 71, 1,
                                  7, 2, 0, 14, 11, 75, 64, 1, 65, 2, 74, 12, 64,
                                  11, 19, 6, 17, 17, 11, 71, 11, 1, 68, 2, 86,
                                  85, 73, 78, 68, 73, 70, 7, 68, 70, 64, 3, 71,
                                  72, 65, 90, 88, 73, 95, 68, 75, 8, 65, 72, 17,
                                  1, 65, 73, 18, 72, 82, 1, 93, 21, 28, 24, 23,
                                  28, 22, 9, 24, 24, 68, 7, 11, 4, 1, 73, 4, 64,
                                  65, 2, 66, 73, 1, 66, 86, 73, 72, 80, 75, 89,
                                  37, 42, 35, 36, 34, 29, 26, 29, 21, 14, 17, 8,
                                  65, 67, 88, 17, 13, 67, 15, 6, 5, 0, 67, 71,
                                  73, 77, 90, 72, 84, 96, 89, 100, 65, 32, 22,
                                  15, 5, 5, 64, 68, 72, 75, 5, 45, 30, 23, 17,
                                  27, 9, 3, 66, 68, 71, 35, 21, 12, 5, 11, 1,
                                  67, 72, 80, 77, 14, 4, 1, 67, 0, 73, 77, 83,
                                  64, 39, 22, 14, 7, 15, 2, 65, 67, 72, 62, 82,
                                  73, 65, 66, 69, 1, 7, 8, 66, 7, 12, 13, 77,
                                  71, 73, 2, 14, 1, 64, 8, 13, 18, 71, 0, 13,
                                  14, 79, 75, 79, 83, 77, 68, 75, 71, 72, 69,
                                  65, 73, 71, 70, 65, 75, 74, 81, 86, 70, 98,
                                  76, 65, 70, 8, 69, 65, 15, 67, 69, 66, 11, 74,
                                  72, 91, 31, 34, 35, 28, 19, 30, 26, 21, 19,
                                  18, 17, 13, 68, 69, 76, 4, 6, 65, 81, 67, 68,
                                  74, 74, 75, 73, 75, 88, 84, 88, 35, 34, 33,
                                  29, 18, 22, 19, 8, 13, 7, 6, 68, 70, 75, 80,
                                  16, 18, 68, 16, 17, 7, 1, 1, 64, 67, 66, 71,
                                  79, 81, 85, 89, 99, 75, 85, 93, 90, 77, 82,
                                  65, 65, 64, 38, 9, 8, 68, 18, 49, 36, 55, 9,
                                  36, 31, 8, 71, 80, 84, 111, 111, 115, 69, 42,
                                  28, 19, 9, 12, 2, 65, 68, 76, 81, 74, 0, 69,
                                  7, 8, 0, 2, 8, 11, 12, 6, 15, 14, 1, 37, 32,
                                  22, 15, 10, 4, 81, 86, 91 },

                                {

                                42,
                                  6, 79, 42, 6, 79, 76, 1, 21, 11, 0, 74, 20,
                                  25, 53, 14, 13, 66, 9, 18, 0, 70, 65, 80, 96,
                                  4, 11, 114, 119, 120, 20, 67, 68, 9, 18, 0,
                                  75, 64, 13, 2, 0, 70, 76, 65, 79, 76, 91, 5,
                                  70, 75, 0, 76, 75, 88, 9, 64, 66, 70, 4, 4,
                                  22, 0, 0, 0, 66, 93, 97, 4, 64, 67, 52, 7, 69,
                                  96, 78, 82, 2, 68, 78, 70, 83, 1, 78, 75, 72,
                                  92, 93, 93, 95, 22, 64, 7, 80, 64, 78, 71, 72,
                                  72, 86, 78, 90, 15, 72, 0, 85, 80, 67, 71, 2,
                                  8, 3, 1, 14, 11, 75, 65, 1, 65, 2, 74, 12, 64,
                                  10, 19, 6, 17, 17, 10, 73, 11, 1, 69, 1, 87,
                                  84, 72, 77, 67, 72, 69, 8, 67, 70, 0, 4, 71,
                                  72, 64, 91, 87, 72, 95, 67, 75, 8, 65, 73, 18,
                                  1, 65, 75, 19, 73, 83, 1, 93, 20, 27, 24, 22,
                                  27, 21, 8, 24, 24, 69, 6, 11, 4, 1, 73, 4, 64,
                                  66, 2, 67, 74, 1, 67, 88, 74, 73, 81, 76, 89,
                                  35, 41, 33, 34, 33, 27, 23, 27, 19, 12, 15, 6,
                                  68, 69, 91, 15, 12, 69, 12, 4, 3, 65, 70, 73,
                                  76, 79, 92, 73, 85, 98, 89, 100, 65, 32, 23,
                                  15, 5, 5, 64, 68, 72, 74, 6, 46, 30, 23, 17,
                                  28, 10, 4, 66, 67, 70, 36, 22, 12, 6, 12, 2,
                                  67, 71, 79, 77, 16, 4, 1, 66, 1, 72, 77, 82,
                                  0, 40, 23, 14, 7, 16, 3, 64, 66, 71, 62, 82,
                                  73, 64, 66, 69, 1, 7, 8, 65, 7, 13, 14, 77,
                                  71, 73, 1, 14, 0, 65, 7, 13, 18, 72, 64, 12,
                                  14, 80, 76, 80, 82, 77, 67, 75, 70, 72, 68,
                                  64, 73, 71, 70, 65, 76, 74, 81, 86, 69, 98,
                                  76, 64, 70, 8, 69, 65, 16, 67, 69, 66, 12, 74,
                                  73, 91, 30, 34, 35, 28, 18, 29, 25, 20, 19,
                                  17, 16, 12, 69, 70, 77, 3, 4, 67, 83, 68, 69,
                                  75, 75, 75, 73, 74, 88, 85, 87, 33, 32, 31,
                                  26, 16, 20, 17, 6, 11, 5, 4, 70, 72, 76, 81,
                                  14, 16, 69, 14, 15, 5, 64, 64, 66, 69, 68, 73,
                                  81, 83, 87, 91, 100, 77, 87, 95, 89, 75, 81,
                                  65, 64, 0, 40, 10, 9, 68, 19, 51, 37, 57, 9,
                                  35, 29, 6, 74, 82, 87, 113, 113, 116, 69, 42,
                                  28, 19, 9, 12, 2, 65, 68, 75, 80, 73, 1, 68,
                                  8, 9, 1, 3, 9, 12, 13, 7, 16, 15, 1, 35, 31,
                                  21, 14, 8, 2, 83, 88, 92 },

                                {

                                41,
                                  6, 79, 41, 6, 79, 74, 3, 22, 11, 64, 76, 18,
                                  24, 53, 14, 15, 66, 10, 19, 0, 71, 65, 81, 97,
                                  4, 9, 115, 120, 120, 23, 66, 68, 10, 19, 0,
                                  74, 0, 14, 2, 0, 69, 75, 66, 80, 76, 91, 5,
                                  70, 75, 0, 76, 75, 88, 10, 64, 66, 70, 5, 4,
                                  22, 0, 0, 0, 66, 93, 97, 5, 65, 67, 52, 7, 69,
                                  95, 77, 82, 3, 67, 76, 68, 82, 2, 76, 74, 70,
                                  91, 92, 92, 94, 23, 64, 8, 79, 64, 78, 71, 70,
                                  72, 85, 77, 89, 15, 72, 1, 83, 79, 66, 71, 2,
                                  8, 3, 2, 15, 12, 76, 65, 1, 65, 2, 74, 12, 65,
                                  10, 19, 5, 17, 17, 10, 75, 11, 0, 71, 0, 88,
                                  83, 71, 76, 66, 71, 69, 9, 67, 69, 1, 5, 71,
                                  72, 64, 92, 87, 71, 95, 67, 75, 9, 65, 74, 19,
                                  1, 65, 76, 20, 73, 84, 1, 94, 18, 26, 23, 21,
                                  26, 20, 8, 23, 23, 70, 5, 11, 4, 1, 74, 3, 65,
                                  67, 1, 68, 75, 0, 67, 90, 75, 73, 82, 77, 89,
                                  34, 39, 32, 32, 31, 25, 21, 25, 16, 9, 13, 3,
                                  70, 72, 93, 13, 10, 70, 10, 2, 0, 68, 72, 76,
                                  78, 81, 95, 74, 87, 99, 90, 100, 65, 33, 23,
                                  15, 5, 5, 64, 68, 72, 74, 6, 46, 30, 23, 17,
                                  29, 10, 4, 65, 67, 69, 37, 22, 13, 6, 13, 2,
                                  66, 71, 78, 76, 17, 5, 2, 66, 2, 71, 76, 81,
                                  0, 40, 23, 14, 7, 17, 3, 0, 65, 70, 62, 81,
                                  72, 64, 66, 69, 1, 7, 8, 65, 7, 13, 14, 77,
                                  71, 73, 1, 15, 64, 66, 6, 12, 18, 73, 65, 12,
                                  14, 80, 77, 80, 81, 76, 66, 74, 70, 71, 68, 0,
                                  73, 71, 70, 64, 76, 74, 81, 85, 68, 98, 76,
                                  64, 70, 9, 69, 65, 17, 67, 69, 66, 13, 75, 73,
                                  92, 29, 33, 34, 27, 17, 28, 24, 19, 18, 16,
                                  15, 11, 70, 71, 78, 1, 3, 68, 85, 70, 70, 76,
                                  75, 76, 73, 74, 88, 85, 86, 31, 30, 29, 24,
                                  13, 18, 15, 3, 9, 3, 2, 73, 74, 78, 82, 12,
                                  15, 71, 12, 13, 3, 66, 66, 68, 71, 70, 75, 84,
                                  85, 89, 93, 101, 79, 89, 96, 88, 74, 80, 64,
                                  0, 1, 41, 11, 10, 68, 20, 52, 39, 58, 10, 33,
                                  28, 3, 77, 85, 90, 116, 115, 117, 69, 42, 28,
                                  19, 9, 12, 2, 65, 68, 75, 79, 72, 2, 67, 9, 9,
                                  1, 4, 9, 12, 13, 7, 16, 15, 1, 34, 29, 19, 12,
                                  6, 0, 85, 90, 93 },

                                {

                                40,
                                  6, 79, 40, 6, 79, 72, 4, 22, 11, 64, 77, 17,
                                  23, 53, 14, 17, 66, 11, 20, 0, 72, 65, 82, 98,
                                  3, 7, 117, 121, 121, 26, 65, 68, 11, 20, 0,
                                  74, 1, 14, 1, 0, 69, 74, 66, 80, 76, 91, 5,
                                  70, 74, 0, 76, 75, 88, 10, 64, 66, 70, 5, 4,
                                  22, 0, 0, 0, 65, 93, 97, 5, 66, 67, 52, 7, 69,
                                  94, 76, 82, 3, 66, 74, 66, 80, 3, 74, 73, 68,
                                  90, 91, 91, 93, 24, 64, 9, 78, 64, 77, 70, 68,
                                  72, 85, 77, 88, 15, 72, 1, 82, 79, 65, 71, 2,
                                  8, 3, 3, 15, 12, 76, 65, 1, 65, 2, 74, 12, 65,
                                  9, 19, 4, 17, 17, 10, 77, 11, 0, 73, 64, 89,
                                  82, 70, 75, 65, 70, 68, 10, 66, 69, 2, 6, 71,
                                  72, 64, 93, 86, 70, 95, 67, 75, 10, 65, 75,
                                  20, 1, 65, 77, 21, 74, 85, 1, 95, 17, 25, 23,
                                  20, 25, 19, 7, 22, 23, 71, 4, 11, 4, 1, 74, 2,
                                  66, 68, 0, 69, 76, 64, 68, 92, 76, 74, 83, 78,
                                  89, 32, 38, 30, 30, 29, 23, 19, 23, 14, 7, 11,
                                  1, 73, 74, 96, 11, 8, 72, 8, 0, 65, 70, 74,
                                  78, 81, 83, 97, 75, 89, 100, 91, 100, 65, 33,
                                  23, 15, 5, 5, 64, 68, 72, 73, 6, 46, 30, 23,
                                  17, 30, 11, 5, 65, 66, 68, 38, 23, 13, 6, 14,
                                  3, 66, 70, 77, 75, 18, 6, 2, 66, 3, 70, 75,
                                  80, 1, 40, 23, 14, 7, 18, 4, 1, 64, 69, 62,
                                  81, 72, 0, 66, 69, 1, 7, 8, 65, 7, 13, 15, 77,
                                  71, 73, 0, 15, 65, 67, 5, 11, 18, 74, 66, 12,
                                  14, 81, 78, 81, 80, 75, 65, 74, 69, 71, 67, 1,
                                  73, 71, 70, 64, 77, 74, 81, 85, 67, 98, 76,
                                  64, 70, 10, 69, 65, 18, 67, 69, 66, 14, 76,
                                  73, 93, 28, 33, 34, 26, 16, 27, 23, 18, 17,
                                  15, 14, 10, 71, 72, 79, 0, 2, 70, 87, 71, 71,
                                  77, 76, 76, 73, 74, 88, 86, 85, 29, 28, 27,
                                  22, 10, 16, 13, 1, 7, 1, 0, 75, 76, 79, 83,
                                  10, 13, 72, 10, 11, 1, 68, 68, 70, 73, 72, 77,
                                  86, 87, 91, 95, 102, 81, 91, 98, 87, 73, 79,
                                  0, 1, 2, 43, 12, 11, 68, 21, 54, 40, 60, 11,
                                  32, 26, 1, 80, 88, 93, 119, 117, 118, 69, 42,
                                  28, 19, 9, 12, 2, 65, 68, 74, 78, 71, 3, 66,
                                  10, 10, 2, 5, 10, 13, 14, 7, 17, 15, 1, 33,
                                  28, 17, 10, 4, 65, 87, 92, 94 },

                                {

                                38,
                                  5, 80, 38, 5, 80, 71, 5, 22, 11, 65, 79, 15,
                                  21, 52, 14, 19, 67, 11, 20, 64, 73, 65, 84,
                                  100, 2, 5, 119, 122, 122, 28, 64, 69, 11, 20,
                                  64, 74, 2, 14, 0, 0, 69, 74, 67, 81, 76, 92,
                                  5, 70, 74, 64, 77, 75, 88, 10, 64, 66, 70, 5,
                                  3, 22, 0, 0, 0, 65, 94, 97, 5, 67, 68, 52, 6,
                                  69, 93, 76, 82, 3, 65, 73, 65, 79, 4, 73, 72,
                                  67, 89, 91, 90, 93, 24, 64, 9, 78, 64, 77, 70,
                                  67, 72, 85, 77, 87, 15, 72, 1, 81, 79, 65, 71,
                                  2, 8, 3, 3, 15, 12, 77, 66, 1, 66, 2, 74, 11,
                                  66, 8, 19, 3, 16, 17, 9, 79, 10, 64, 75, 65,
                                  90, 82, 70, 75, 65, 70, 68, 11, 66, 69, 2, 7,
                                  72, 72, 64, 95, 86, 70, 95, 67, 76, 10, 65,
                                  76, 20, 1, 65, 79, 21, 75, 86, 1, 96, 15, 24,
                                  22, 19, 24, 18, 6, 21, 22, 73, 3, 10, 3, 1,
                                  75, 1, 67, 69, 64, 70, 77, 65, 69, 94, 78, 75,
                                  85, 80, 89, 30, 36, 28, 28, 27, 20, 16, 20,
                                  11, 4, 8, 65, 76, 77, 99, 9, 6, 74, 5, 66, 68,
                                  73, 77, 81, 84, 86, 100, 76, 91, 102, 92, 101,
                                  65, 33, 23, 15, 5, 5, 65, 68, 72, 73, 6, 46,
                                  30, 23, 17, 31, 11, 5, 65, 66, 68, 38, 23, 13,
                                  6, 14, 3, 66, 70, 76, 75, 19, 6, 2, 66, 3, 70,
                                  75, 79, 1, 40, 23, 14, 7, 18, 4, 1, 64, 69,
                                  62, 81, 72, 0, 66, 69, 1, 7, 8, 65, 7, 13, 15,
                                  77, 71, 74, 64, 15, 66, 68, 4, 10, 17, 76, 68,
                                  11, 13, 82, 80, 82, 80, 75, 64, 74, 69, 71,
                                  67, 1, 74, 71, 70, 64, 78, 74, 81, 85, 67, 99,
                                  76, 64, 70, 10, 70, 65, 18, 68, 70, 66, 14,
                                  77, 74, 94, 27, 32, 33, 25, 14, 26, 22, 17,
                                  16, 14, 13, 9, 72, 74, 81, 65, 0, 72, 89, 73,
                                  73, 78, 77, 77, 73, 74, 88, 87, 85, 26, 25,
                                  25, 19, 7, 13, 10, 65, 4, 65, 66, 78, 79, 81,
                                  84, 8, 11, 74, 8, 8, 65, 71, 71, 73, 75, 75,
                                  80, 89, 89, 94, 97, 104, 83, 93, 100, 86, 72,
                                  78, 0, 1, 2, 44, 12, 11, 68, 21, 55, 41, 61,
                                  11, 30, 24, 65, 84, 91, 96, 122, 120, 120, 69,
                                  42, 27, 18, 9, 12, 2, 66, 68, 74, 78, 71, 3,
                                  66, 11, 10, 2, 5, 10, 13, 14, 7, 17, 15, 0,
                                  31, 26, 15, 8, 2, 67, 90, 94, 95 },

                                {

                                37,
                                  5, 80, 37, 5, 80, 69, 7, 23, 12, 65, 80, 14,
                                  20, 52, 14, 22, 67, 12, 21, 64, 73, 64, 85,
                                  101, 2, 4, 120, 123, 122, 31, 1, 69, 12, 21,
                                  64, 73, 4, 15, 0, 1, 68, 73, 67, 81, 75, 92,
                                  5, 69, 73, 64, 77, 74, 88, 11, 0, 65, 69, 6,
                                  3, 22, 0, 0, 0, 64, 94, 97, 6, 67, 68, 52, 6,
                                  69, 91, 75, 82, 4, 0, 71, 0, 77, 6, 71, 70,
                                  65, 87, 90, 89, 92, 25, 0, 10, 77, 0, 76, 69,
                                  65, 71, 84, 76, 85, 16, 71, 2, 79, 78, 64, 70,
                                  3, 9, 4, 4, 16, 13, 77, 66, 2, 66, 2, 73, 11,
                                  66, 8, 19, 3, 16, 17, 9, 80, 10, 64, 76, 66,
                                  90, 81, 69, 74, 64, 69, 67, 12, 65, 68, 3, 9,
                                  72, 72, 0, 96, 85, 69, 95, 66, 76, 11, 64, 76,
                                  21, 1, 65, 80, 22, 75, 87, 1, 96, 14, 24, 22,
                                  19, 24, 18, 6, 21, 22, 74, 3, 10, 3, 1, 75, 1,
                                  67, 69, 64, 70, 78, 65, 69, 95, 79, 75, 86,
                                  81, 89, 29, 35, 27, 27, 26, 18, 14, 18, 9, 2,
                                  6, 67, 78, 79, 101, 8, 5, 75, 3, 68, 70, 75,
                                  79, 83, 86, 88, 102, 76, 92, 103, 92, 101, 64,
                                  34, 24, 16, 6, 5, 65, 67, 71, 72, 7, 47, 31,
                                  24, 17, 32, 12, 6, 64, 65, 67, 39, 24, 14, 7,
                                  15, 4, 65, 69, 74, 74, 21, 7, 3, 65, 4, 69,
                                  74, 77, 2, 41, 24, 15, 8, 19, 5, 2, 0, 68, 62,
                                  80, 71, 1, 66, 68, 1, 8, 9, 64, 8, 14, 16, 76,
                                  71, 74, 64, 16, 66, 68, 3, 10, 17, 77, 69, 11,
                                  13, 82, 81, 82, 79, 74, 0, 73, 68, 70, 66, 2,
                                  74, 70, 69, 0, 78, 73, 80, 84, 66, 99, 76, 0,
                                  70, 11, 70, 65, 19, 68, 70, 65, 15, 77, 74,
                                  94, 27, 32, 33, 25, 13, 26, 22, 17, 16, 14,
                                  13, 9, 72, 75, 82, 66, 64, 73, 90, 74, 74, 78,
                                  77, 77, 72, 73, 87, 87, 84, 24, 23, 23, 17, 5,
                                  11, 8, 67, 2, 67, 68, 80, 81, 82, 84, 7, 10,
                                  75, 7, 6, 67, 73, 73, 75, 77, 77, 82, 91, 90,
                                  96, 98, 105, 84, 94, 101, 84, 70, 76, 1, 2, 3,
                                  46, 13, 12, 68, 22, 57, 43, 62, 12, 29, 23,
                                  67, 87, 93, 98, 124, 122, 121, 68, 43, 27, 18,
                                  9, 13, 2, 66, 68, 73, 77, 70, 4, 65, 13, 11,
                                  3, 6, 11, 14, 15, 8, 18, 16, 0, 30, 25, 14, 7,
                                  1, 68, 92, 95, 95 },

                                {

                                36,
                                  5, 80, 36, 5, 80, 67, 8, 23, 12, 65, 81, 13,
                                  19, 52, 14, 24, 67, 13, 22, 64, 74, 64, 86,
                                  102, 1, 2, 122, 124, 123, 34, 2, 69, 13, 22,
                                  64, 73, 5, 15, 64, 1, 68, 72, 67, 81, 75, 92,
                                  5, 69, 72, 64, 77, 74, 88, 11, 0, 65, 69, 6,
                                  3, 22, 0, 0, 0, 0, 94, 97, 6, 68, 68, 52, 6,
                                  69, 90, 74, 82, 4, 1, 69, 2, 76, 7, 69, 69, 0,
                                  86, 89, 88, 91, 26, 0, 11, 76, 0, 76, 68, 0,
                                  71, 84, 76, 84, 16, 71, 2, 78, 78, 0, 70, 3,
                                  9, 4, 5, 16, 13, 78, 66, 2, 66, 2, 73, 11, 66,
                                  7, 19, 2, 16, 17, 9, 82, 10, 64, 78, 67, 91,
                                  80, 68, 73, 0, 68, 66, 13, 64, 68, 4, 10, 72,
                                  72, 0, 97, 85, 68, 95, 66, 76, 12, 64, 77, 22,
                                  1, 65, 81, 23, 76, 88, 1, 97, 12, 23, 21, 18,
                                  23, 17, 5, 20, 22, 75, 2, 10, 3, 1, 75, 0, 68,
                                  70, 65, 71, 79, 66, 70, 97, 80, 76, 87, 82,
                                  89, 27, 34, 25, 25, 24, 16, 12, 16, 6, 0, 4,
                                  70, 81, 81, 104, 6, 3, 77, 1, 70, 72, 77, 81,
                                  85, 89, 90, 104, 77, 94, 104, 93, 101, 64, 34,
                                  24, 16, 6, 5, 65, 67, 71, 71, 7, 47, 31, 24,
                                  17, 33, 12, 7, 64, 64, 66, 40, 25, 14, 7, 16,
                                  4, 65, 68, 73, 73, 22, 8, 3, 65, 5, 68, 73,
                                  76, 2, 41, 24, 15, 8, 20, 6, 3, 1, 67, 62, 80,
                                  71, 1, 66, 68, 1, 8, 9, 64, 8, 14, 17, 76, 71,
                                  74, 65, 16, 67, 69, 2, 9, 17, 78, 70, 11, 13,
                                  83, 82, 83, 78, 73, 1, 73, 68, 70, 65, 3, 74,
                                  70, 69, 0, 79, 73, 80, 84, 65, 99, 76, 0, 70,
                                  12, 70, 65, 20, 68, 70, 65, 16, 78, 74, 95,
                                  26, 32, 33, 24, 12, 25, 21, 16, 15, 13, 12, 8,
                                  73, 76, 83, 68, 65, 75, 92, 75, 75, 79, 78,
                                  77, 72, 73, 87, 88, 83, 22, 21, 21, 15, 2, 9,
                                  6, 70, 0, 69, 70, 82, 83, 83, 85, 5, 8, 76, 5,
                                  4, 69, 75, 75, 77, 79, 79, 84, 93, 92, 98,
                                  100, 106, 86, 96, 103, 83, 69, 75, 2, 3, 4,
                                  48, 14, 13, 68, 23, 58, 44, 62, 13, 28, 21,
                                  70, 90, 96, 101, 126, 124, 122, 68, 43, 27,
                                  18, 9, 13, 2, 66, 68, 72, 76, 69, 5, 64, 14,
                                  12, 4, 7, 12, 15, 16, 8, 19, 16, 0, 29, 23,
                                  12, 5, 64, 70, 94, 97, 96 },

                                {

                                35,
                                  5, 80, 35, 5, 80, 65, 10, 24, 12, 66, 83, 11,
                                  18, 52, 14, 26, 67, 14, 23, 64, 75, 64, 87,
                                  103, 1, 0, 123, 125, 123, 37, 3, 69, 14, 23,
                                  64, 72, 6, 16, 64, 1, 67, 71, 68, 82, 75, 92,
                                  5, 69, 72, 64, 77, 74, 88, 12, 0, 65, 69, 7,
                                  3, 22, 0, 0, 0, 0, 94, 97, 7, 69, 68, 52, 6,
                                  69, 89, 73, 82, 5, 2, 67, 4, 74, 8, 67, 68, 2,
                                  85, 88, 87, 90, 27, 0, 12, 75, 0, 75, 68, 2,
                                  71, 83, 75, 83, 16, 71, 3, 76, 77, 1, 70, 3,
                                  9, 4, 6, 17, 14, 78, 66, 2, 66, 2, 73, 11, 67,
                                  7, 19, 1, 16, 17, 9, 84, 10, 65, 80, 68, 92,
                                  79, 67, 72, 1, 67, 66, 14, 64, 67, 5, 11, 72,
                                  72, 0, 98, 84, 67, 95, 66, 76, 13, 64, 78, 23,
                                  1, 65, 82, 24, 76, 89, 1, 98, 11, 22, 21, 17,
                                  22, 16, 5, 19, 21, 76, 1, 10, 3, 1, 76, 64,
                                  69, 71, 66, 72, 80, 67, 70, 99, 81, 76, 88,
                                  83, 89, 26, 32, 24, 23, 22, 14, 10, 14, 4, 66,
                                  2, 72, 83, 84, 106, 4, 1, 78, 64, 72, 75, 80,
                                  83, 88, 91, 92, 107, 78, 96, 105, 94, 101, 64,
                                  35, 24, 16, 6, 5, 65, 67, 71, 71, 7, 47, 31,
                                  24, 17, 34, 13, 7, 0, 64, 65, 41, 25, 15, 7,
                                  17, 5, 64, 68, 72, 72, 23, 9, 4, 65, 6, 67,
                                  72, 75, 3, 41, 24, 15, 8, 21, 6, 4, 2, 66, 62,
                                  79, 70, 2, 66, 68, 1, 8, 9, 64, 8, 14, 17, 76,
                                  71, 74, 65, 17, 68, 70, 1, 8, 17, 79, 71, 11,
                                  13, 83, 83, 83, 77, 72, 2, 72, 67, 69, 65, 4,
                                  74, 70, 69, 1, 79, 73, 80, 83, 64, 99, 76, 0,
                                  70, 13, 70, 65, 21, 68, 70, 65, 17, 79, 74,
                                  96, 25, 31, 32, 23, 11, 24, 20, 15, 14, 12,
                                  11, 7, 74, 77, 84, 69, 66, 76, 94, 77, 76, 80,
                                  78, 78, 72, 73, 87, 88, 82, 20, 19, 19, 13,
                                  64, 7, 4, 72, 65, 71, 72, 85, 85, 85, 86, 3,
                                  7, 78, 3, 2, 71, 77, 77, 79, 81, 81, 86, 96,
                                  94, 100, 102, 107, 88, 98, 104, 82, 68, 74, 3,
                                  4, 5, 49, 15, 14, 68, 24, 60, 46, 62, 14, 26,
                                  20, 72, 93, 99, 104, 126, 126, 123, 68, 43,
                                  27, 18, 9, 13, 2, 66, 68, 72, 75, 68, 6, 0,
                                  15, 12, 4, 8, 12, 15, 16, 8, 19, 16, 0, 28,
                                  22, 10, 3, 66, 72, 96, 99, 97 },

                                {

                                33,
                                  5, 80, 33, 5, 80, 64, 11, 24, 12, 66, 84, 10,
                                  16, 52, 14, 29, 68, 15, 23, 64, 76, 64, 88,
                                  104, 0, 65, 125, 126, 124, 40, 4, 69, 15, 23,
                                  64, 72, 7, 16, 65, 1, 67, 71, 68, 82, 74, 92,
                                  5, 69, 71, 65, 78, 74, 88, 12, 1, 65, 68, 7,
                                  3, 22, 0, 0, 0, 1, 95, 97, 7, 70, 68, 52, 6,
                                  69, 88, 72, 82, 5, 4, 66, 6, 73, 9, 66, 66, 4,
                                  84, 88, 86, 90, 27, 0, 13, 74, 0, 75, 67, 4,
                                  71, 83, 75, 82, 16, 70, 3, 75, 77, 1, 70, 4,
                                  9, 4, 6, 17, 14, 79, 67, 2, 66, 2, 73, 11, 67,
                                  6, 19, 1, 16, 17, 8, 86, 10, 65, 82, 69, 93,
                                  78, 66, 71, 2, 67, 65, 15, 0, 67, 6, 12, 72,
                                  72, 1, 99, 84, 66, 95, 66, 76, 13, 64, 79, 24,
                                  1, 65, 84, 25, 77, 90, 1, 99, 9, 21, 20, 16,
                                  21, 15, 4, 18, 21, 78, 0, 9, 3, 1, 76, 65, 69,
                                  72, 66, 73, 81, 68, 71, 101, 82, 77, 89, 84,
                                  89, 24, 31, 22, 21, 20, 12, 7, 12, 1, 68, 0,
                                  75, 86, 86, 109, 2, 0, 80, 67, 74, 77, 82, 86,
                                  90, 94, 94, 109, 79, 97, 107, 95, 101, 64, 35,
                                  25, 16, 6, 5, 65, 67, 71, 70, 8, 48, 31, 24,
                                  17, 35, 13, 8, 0, 0, 65, 42, 26, 15, 7, 17, 5,
                                  64, 67, 71, 72, 24, 9, 4, 65, 7, 66, 72, 74,
                                  3, 42, 24, 15, 8, 22, 7, 4, 3, 65, 62, 79, 70,
                                  2, 66, 68, 1, 8, 9, 0, 8, 14, 18, 76, 71, 74,
                                  66, 17, 69, 71, 0, 7, 17, 81, 72, 10, 13, 84,
                                  84, 84, 77, 72, 3, 72, 67, 69, 64, 5, 75, 70,
                                  69, 1, 80, 73, 80, 83, 0, 99, 76, 1, 70, 13,
                                  70, 65, 22, 68, 71, 65, 18, 79, 75, 97, 24,
                                  31, 32, 22, 10, 23, 19, 14, 13, 11, 10, 6, 75,
                                  78, 85, 71, 68, 78, 96, 78, 77, 81, 79, 78,
                                  72, 73, 87, 89, 82, 17, 16, 17, 10, 67, 5, 2,
                                  75, 67, 73, 74, 87, 87, 86, 87, 1, 5, 79, 1,
                                  0, 73, 79, 80, 81, 83, 83, 88, 98, 96, 102,
                                  104, 108, 90, 100, 106, 81, 67, 73, 3, 5, 6,
                                  51, 16, 15, 68, 25, 61, 47, 62, 14, 25, 18,
                                  75, 96, 102, 107, 126, 126, 124, 68, 43, 27,
                                  18, 9, 13, 2, 66, 68, 71, 74, 67, 7, 0, 16,
                                  13, 5, 9, 13, 16, 17, 9, 20, 17, 0, 26, 20, 8,
                                  1, 68, 74, 98, 101, 98 },

                                {

                                32,
                                  5, 80, 32, 5, 80, 1, 13, 24, 12, 67, 86, 8,
                                  15, 52, 14, 31, 68, 16, 24, 64, 76, 0, 89,
                                  105, 0, 67, 126, 126, 124, 43, 6, 69, 16, 24,
                                  64, 72, 8, 16, 65, 1, 67, 70, 68, 83, 74, 92,
                                  5, 69, 70, 65, 78, 74, 88, 13, 1, 64, 68, 8,
                                  3, 22, 0, 0, 0, 1, 95, 97, 8, 71, 68, 52, 6,
                                  69, 87, 71, 82, 6, 5, 64, 8, 71, 10, 64, 65,
                                  6, 83, 87, 85, 89, 28, 0, 14, 73, 0, 74, 66,
                                  6, 71, 83, 74, 80, 17, 70, 4, 74, 76, 2, 70,
                                  4, 10, 5, 7, 18, 15, 79, 67, 2, 66, 2, 73, 11,
                                  68, 5, 19, 0, 16, 17, 8, 88, 10, 66, 83, 70,
                                  94, 77, 65, 70, 3, 66, 64, 16, 1, 66, 7, 13,
                                  72, 72, 1, 100, 83, 65, 95, 65, 76, 14, 64,
                                  80, 25, 1, 65, 85, 26, 77, 91, 1, 99, 8, 20,
                                  20, 15, 20, 14, 3, 18, 21, 79, 64, 9, 3, 1,
                                  77, 65, 70, 73, 67, 74, 82, 68, 72, 103, 83,
                                  78, 90, 85, 89, 22, 30, 20, 19, 19, 10, 5, 10,
                                  64, 70, 65, 77, 88, 88, 111, 0, 65, 82, 69,
                                  76, 79, 84, 88, 92, 97, 96, 112, 80, 99, 108,
                                  95, 101, 64, 35, 25, 16, 6, 5, 65, 67, 71, 70,
                                  8, 48, 31, 24, 17, 36, 14, 9, 0, 1, 64, 43,
                                  27, 15, 8, 18, 6, 0, 67, 70, 71, 26, 10, 4,
                                  64, 8, 65, 71, 73, 4, 42, 25, 15, 8, 23, 8, 5,
                                  4, 64, 62, 79, 70, 3, 66, 68, 1, 8, 9, 0, 8,
                                  15, 18, 76, 71, 74, 67, 18, 70, 72, 64, 7, 17,
                                  82, 73, 10, 13, 85, 85, 84, 76, 71, 4, 71, 66,
                                  68, 64, 6, 75, 70, 69, 1, 81, 73, 80, 82, 1,
                                  99, 76, 1, 70, 14, 70, 65, 23, 68, 71, 65, 19,
                                  80, 75, 97, 23, 31, 31, 22, 9, 22, 18, 13, 13,
                                  10, 9, 5, 76, 79, 86, 72, 69, 79, 98, 79, 78,
                                  82, 80, 79, 72, 72, 87, 89, 81, 15, 14, 15, 8,
                                  69, 3, 0, 77, 69, 75, 76, 89, 89, 88, 88, 64,
                                  3, 80, 64, 65, 75, 81, 82, 83, 85, 85, 90,
                                  101, 98, 104, 106, 109, 92, 102, 107, 80, 65,
                                  72, 4, 6, 7, 53, 17, 16, 68, 26, 62, 49, 62,
                                  15, 23, 16, 77, 99, 104, 110, 126, 126, 125,
                                  68, 43, 27, 18, 9, 13, 2, 66, 68, 71, 73, 66,
                                  8, 1, 17, 14, 5, 10, 14, 17, 18, 9, 20, 17, 0,
                                  25, 19, 7, 0, 70, 76, 100, 103, 99 },

                                {

                                31,
                                  5, 81, 31, 5, 81, 3, 14, 25, 12, 67, 87, 7,
                                  14, 52, 14, 33, 68, 16, 25, 64, 77, 0, 90,
                                  106, 64, 68, 126, 126, 125, 46, 7, 69, 16, 25,
                                  64, 71, 9, 17, 66, 2, 66, 69, 69, 83, 74, 92,
                                  5, 68, 70, 65, 78, 73, 88, 13, 1, 64, 68, 8,
                                  3, 22, 0, 0, 0, 2, 95, 97, 8, 71, 69, 52, 6,
                                  69, 86, 71, 82, 6, 6, 1, 10, 70, 11, 1, 64, 8,
                                  82, 86, 84, 88, 29, 0, 15, 73, 1, 74, 66, 8,
                                  71, 82, 74, 79, 17, 70, 4, 72, 76, 3, 69, 4,
                                  10, 5, 8, 18, 15, 80, 67, 2, 66, 2, 73, 11,
                                  68, 5, 19, 64, 16, 17, 8, 90, 10, 66, 85, 71,
                                  95, 77, 64, 70, 3, 65, 64, 17, 1, 66, 7, 15,
                                  72, 72, 1, 101, 83, 64, 95, 65, 76, 15, 0, 81,
                                  25, 1, 65, 86, 27, 78, 92, 1, 100, 6, 19, 19,
                                  15, 19, 14, 3, 17, 20, 80, 65, 9, 3, 1, 77,
                                  66, 71, 74, 68, 74, 83, 69, 72, 105, 84, 78,
                                  91, 86, 89, 21, 28, 19, 17, 17, 8, 3, 8, 67,
                                  73, 67, 80, 91, 91, 114, 65, 67, 83, 71, 79,
                                  82, 87, 90, 95, 99, 99, 114, 81, 101, 109, 96,
                                  101, 0, 36, 25, 17, 6, 5, 65, 67, 71, 69, 8,
                                  48, 32, 24, 17, 37, 14, 9, 1, 1, 0, 44, 27,
                                  16, 8, 19, 6, 0, 66, 69, 70, 27, 11, 5, 64, 8,
                                  65, 70, 71, 4, 42, 25, 15, 9, 23, 8, 6, 4, 0,
                                  62, 78, 69, 3, 66, 68, 1, 8, 9, 0, 9, 15, 19,
                                  76, 71, 75, 67, 18, 71, 73, 65, 6, 17, 83, 74,
                                  10, 13, 85, 86, 85, 75, 70, 5, 71, 66, 68, 0,
                                  6, 75, 69, 68, 2, 81, 73, 80, 82, 2, 99, 76,
                                  1, 70, 15, 70, 65, 24, 69, 71, 65, 19, 81, 75,
                                  98, 22, 30, 31, 21, 8, 22, 18, 12, 12, 10, 8,
                                  4, 77, 80, 87, 74, 70, 81, 100, 81, 80, 83,
                                  80, 79, 72, 72, 86, 90, 80, 13, 12, 13, 6, 72,
                                  1, 65, 80, 71, 78, 78, 92, 91, 89, 88, 65, 2,
                                  82, 66, 68, 77, 83, 84, 85, 87, 88, 92, 103,
                                  100, 106, 107, 111, 94, 104, 109, 79, 64, 71,
                                  5, 7, 8, 54, 18, 17, 68, 27, 62, 50, 62, 16,
                                  22, 15, 80, 102, 107, 112, 126, 126, 126, 67,
                                  43, 27, 18, 9, 13, 2, 66, 68, 70, 72, 66, 9,
                                  2, 18, 14, 6, 11, 14, 17, 18, 9, 21, 17, 0,
                                  24, 17, 5, 65, 71, 77, 103, 104, 100 },

                                {

                                30,
                                  5, 81, 30, 5, 81, 5, 16, 25, 12, 68, 89, 5,
                                  12, 52, 14, 36, 69, 17, 25, 64, 78, 0, 91,
                                  107, 64, 70, 126, 126, 125, 49, 8, 69, 17, 25,
                                  64, 71, 10, 17, 66, 2, 66, 69, 69, 84, 73, 92,
                                  5, 68, 69, 66, 78, 73, 88, 14, 2, 64, 67, 9,
                                  3, 22, 0, 0, 0, 2, 95, 97, 9, 72, 69, 52, 6,
                                  69, 85, 70, 82, 7, 8, 2, 12, 68, 12, 2, 1, 10,
                                  81, 85, 83, 88, 30, 0, 16, 72, 1, 73, 65, 10,
                                  71, 82, 73, 78, 17, 69, 5, 71, 75, 3, 69, 5,
                                  10, 5, 9, 19, 16, 80, 68, 2, 66, 2, 73, 11,
                                  69, 4, 19, 64, 16, 17, 7, 92, 10, 67, 87, 72,
                                  96, 76, 0, 69, 4, 64, 0, 18, 2, 65, 8, 16, 72,
                                  72, 2, 102, 82, 0, 95, 65, 76, 15, 0, 82, 26,
                                  1, 65, 88, 28, 78, 93, 1, 101, 5, 18, 19, 14,
                                  18, 13, 2, 16, 20, 81, 66, 9, 3, 1, 78, 67,
                                  71, 75, 68, 75, 84, 70, 73, 107, 85, 79, 92,
                                  87, 89, 19, 27, 17, 15, 15, 6, 0, 6, 69, 75,
                                  69, 82, 93, 93, 116, 67, 68, 85, 74, 81, 84,
                                  89, 93, 97, 102, 101, 117, 82, 102, 111, 97,
                                  101, 0, 36, 26, 17, 6, 5, 65, 67, 71, 69, 9,
                                  49, 32, 24, 17, 38, 15, 10, 1, 2, 1, 45, 28,
                                  16, 8, 20, 7, 1, 66, 68, 70, 28, 11, 5, 64, 9,
                                  64, 70, 70, 5, 43, 25, 15, 9, 24, 9, 7, 5, 1,
                                  62, 78, 69, 4, 66, 68, 1, 8, 9, 1, 9, 15, 19,
                                  76, 71, 75, 68, 19, 72, 74, 66, 5, 17, 84, 75,
                                  9, 13, 86, 87, 85, 74, 70, 6, 70, 65, 67, 0,
                                  7, 75, 69, 68, 2, 82, 73, 80, 81, 3, 99, 76,
                                  2, 70, 15, 70, 65, 25, 69, 71, 65, 20, 81, 76,
                                  99, 21, 30, 30, 20, 7, 21, 17, 11, 11, 9, 7,
                                  3, 78, 81, 88, 75, 72, 82, 102, 82, 81, 84,
                                  81, 80, 72, 72, 86, 90, 79, 11, 10, 11, 3, 75,
                                  64, 67, 82, 73, 80, 80, 94, 93, 91, 89, 67, 0,
                                  83, 68, 70, 79, 85, 86, 87, 89, 90, 94, 106,
                                  102, 108, 109, 112, 96, 106, 110, 78, 0, 70,
                                  5, 8, 9, 56, 19, 18, 68, 28, 62, 52, 62, 16,
                                  20, 13, 82, 105, 110, 115, 126, 126, 126, 67,
                                  43, 27, 18, 9, 13, 2, 66, 68, 70, 71, 65, 10,
                                  3, 19, 15, 6, 12, 15, 18, 19, 10, 21, 18, 0,
                                  22, 16, 3, 67, 73, 79, 105, 106, 101 },

                                {

                                28,
                                  4, 81, 28, 4, 81, 6, 17, 25, 12, 68, 90, 4,
                                  11, 52, 14, 38, 69, 18, 26, 64, 79, 0, 92,
                                  109, 65, 72, 126, 126, 126, 51, 9, 69, 18, 26,
                                  64, 71, 11, 17, 67, 2, 66, 68, 70, 84, 73, 93,
                                  5, 68, 69, 66, 79, 73, 88, 14, 2, 64, 67, 9,
                                  3, 22, 0, 0, 0, 3, 96, 97, 9, 73, 69, 52, 6,
                                  69, 84, 69, 82, 7, 9, 4, 14, 67, 13, 4, 2, 11,
                                  80, 85, 82, 87, 30, 0, 17, 71, 1, 73, 65, 11,
                                  71, 82, 73, 77, 17, 69, 5, 70, 75, 4, 69, 5,
                                  10, 5, 9, 19, 16, 81, 68, 2, 66, 2, 73, 11,
                                  69, 3, 19, 65, 16, 17, 7, 94, 10, 67, 89, 73,
                                  97, 75, 1, 68, 5, 64, 0, 19, 2, 65, 9, 17, 72,
                                  72, 2, 104, 82, 1, 95, 65, 77, 16, 0, 83, 27,
                                  1, 65, 89, 29, 79, 94, 1, 102, 3, 17, 18, 13,
                                  17, 12, 1, 15, 19, 83, 67, 8, 3, 1, 78, 68,
                                  72, 76, 69, 76, 85, 71, 74, 109, 87, 80, 93,
                                  88, 89, 17, 25, 15, 13, 13, 4, 65, 4, 72, 78,
                                  71, 85, 96, 96, 119, 69, 70, 87, 76, 83, 87,
                                  92, 95, 100, 105, 103, 119, 83, 104, 112, 98,
                                  102, 0, 36, 26, 17, 6, 5, 65, 67, 71, 68, 9,
                                  49, 32, 24, 17, 39, 15, 10, 1, 2, 1, 46, 28,
                                  16, 8, 20, 7, 1, 65, 67, 69, 29, 12, 5, 64,
                                  10, 0, 69, 69, 5, 43, 25, 15, 9, 25, 9, 7, 6,
                                  1, 62, 78, 69, 4, 66, 68, 1, 8, 9, 1, 9, 15,
                                  20, 76, 71, 75, 69, 19, 73, 75, 67, 4, 17, 86,
                                  77, 9, 13, 87, 88, 86, 74, 69, 7, 70, 65, 67,
                                  1, 8, 76, 69, 68, 2, 83, 73, 80, 81, 3, 100,
                                  76, 2, 70, 16, 70, 65, 25, 69, 72, 65, 21, 82,
                                  76, 100, 20, 29, 30, 19, 5, 20, 16, 10, 10, 8,
                                  6, 2, 79, 82, 89, 77, 73, 84, 104, 84, 82, 85,
                                  82, 80, 72, 72, 86, 91, 79, 8, 7, 9, 1, 78,
                                  67, 70, 85, 75, 82, 82, 97, 95, 92, 90, 69,
                                  65, 85, 70, 72, 82, 88, 89, 90, 91, 92, 97,
                                  108, 104, 111, 111, 113, 98, 108, 112, 77, 1,
                                  69, 6, 9, 9, 57, 20, 18, 68, 28, 62, 53, 62,
                                  17, 19, 11, 85, 108, 113, 118, 126, 126, 126,
                                  67, 43, 27, 18, 9, 13, 2, 66, 68, 69, 71, 64,
                                  11, 3, 20, 15, 7, 12, 15, 18, 19, 10, 22, 18,
                                  64, 21, 14, 1, 69, 75, 81, 107, 108, 102 },

                                {

                                27,
                                  4, 81, 27, 4, 81, 8, 18, 26, 12, 68, 91, 3,
                                  10, 52, 14, 40, 69, 19, 27, 64, 79, 1, 93,
                                  110, 66, 74, 126, 126, 126, 54, 11, 69, 19,
                                  27, 64, 70, 12, 18, 68, 2, 65, 67, 70, 84, 73,
                                  93, 5, 68, 68, 66, 79, 73, 88, 14, 2, 0, 67,
                                  9, 3, 22, 0, 0, 0, 4, 96, 97, 9, 74, 69, 52,
                                  6, 69, 83, 68, 82, 7, 10, 6, 16, 65, 15, 6, 3,
                                  13, 79, 84, 81, 86, 31, 1, 18, 70, 1, 72, 64,
                                  13, 71, 81, 73, 75, 18, 69, 5, 68, 75, 5, 69,
                                  5, 11, 6, 10, 19, 16, 81, 68, 3, 66, 2, 72,
                                  11, 69, 3, 19, 66, 16, 17, 7, 96, 10, 67, 90,
                                  74, 97, 74, 2, 67, 6, 0, 1, 20, 3, 65, 10, 18,
                                  72, 72, 2, 105, 81, 2, 95, 64, 77, 17, 0, 84,
                                  28, 1, 65, 90, 30, 80, 95, 1, 102, 2, 16, 18,
                                  12, 16, 11, 1, 15, 19, 84, 68, 8, 3, 1, 78,
                                  68, 73, 77, 70, 77, 86, 71, 74, 110, 88, 80,
                                  94, 89, 89, 16, 24, 14, 12, 12, 2, 67, 2, 74,
                                  80, 73, 87, 99, 98, 122, 70, 72, 88, 78, 85,
                                  89, 94, 97, 102, 107, 105, 121, 83, 106, 113,
                                  98, 102, 0, 37, 26, 17, 7, 5, 65, 66, 71, 67,
                                  9, 49, 32, 25, 17, 40, 16, 11, 2, 3, 2, 47,
                                  29, 17, 9, 21, 8, 1, 64, 66, 68, 31, 13, 6, 0,
                                  11, 1, 68, 68, 6, 43, 26, 16, 9, 26, 10, 8, 7,
                                  2, 62, 77, 68, 5, 66, 68, 1, 9, 10, 1, 9, 16,
                                  21, 76, 71, 75, 69, 19, 74, 75, 68, 4, 17, 87,
                                  78, 9, 13, 87, 89, 87, 73, 68, 8, 70, 64, 67,
                                  2, 9, 76, 69, 68, 3, 83, 73, 80, 81, 4, 100,
                                  76, 2, 70, 17, 70, 65, 26, 69, 72, 65, 22, 83,
                                  76, 100, 19, 29, 30, 19, 4, 19, 15, 9, 10, 7,
                                  5, 2, 79, 83, 90, 78, 74, 86, 106, 85, 83, 85,
                                  82, 80, 71, 71, 86, 92, 78, 6, 5, 7, 64, 80,
                                  69, 72, 87, 77, 84, 84, 99, 97, 93, 91, 71,
                                  66, 86, 72, 74, 84, 90, 91, 92, 93, 94, 99,
                                  110, 105, 113, 113, 114, 100, 110, 114, 76, 3,
                                  67, 7, 10, 10, 59, 21, 19, 68, 29, 62, 54, 62,
                                  18, 18, 10, 87, 111, 115, 121, 126, 126, 126,
                                  67, 43, 27, 18, 9, 14, 2, 66, 68, 68, 70, 0,
                                  12, 4, 22, 16, 8, 13, 16, 19, 20, 10, 23, 18,
                                  64, 20, 13, 0, 70, 77, 83, 109, 110, 102 },

                                {

                                26,
                                  4, 81, 26, 4, 81, 10, 20, 26, 12, 69, 93, 1,
                                  8, 52, 14, 43, 70, 20, 27, 64, 80, 1, 94, 111,
                                  66, 76, 126, 126, 126, 57, 12, 69, 20, 27, 64,
                                  70, 13, 18, 68, 2, 65, 67, 70, 85, 72, 93, 5,
                                  68, 67, 67, 79, 73, 88, 15, 3, 0, 66, 10, 3,
                                  22, 0, 0, 0, 4, 96, 97, 10, 75, 69, 52, 6, 69,
                                  82, 67, 82, 8, 12, 7, 18, 64, 16, 7, 5, 15,
                                  78, 83, 80, 86, 32, 1, 19, 69, 1, 72, 0, 15,
                                  71, 81, 72, 74, 18, 68, 6, 67, 74, 5, 69, 6,
                                  11, 6, 11, 20, 17, 82, 69, 3, 66, 2, 72, 11,
                                  70, 2, 19, 66, 16, 17, 6, 98, 10, 68, 92, 75,
                                  98, 73, 3, 66, 7, 1, 2, 21, 4, 64, 11, 19, 72,
                                  72, 3, 106, 81, 3, 95, 64, 77, 17, 0, 85, 29,
                                  1, 65, 92, 31, 80, 96, 1, 103, 0, 15, 17, 11,
                                  15, 10, 0, 14, 19, 85, 69, 8, 3, 1, 79, 69,
                                  73, 78, 70, 78, 87, 72, 75, 112, 89, 81, 95,
                                  90, 89, 14, 23, 12, 10, 10, 0, 70, 0, 77, 82,
                                  75, 90, 101, 100, 124, 72, 73, 90, 81, 87, 91,
                                  96, 100, 104, 110, 107, 124, 84, 107, 115, 99,
                                  102, 0, 37, 27, 17, 7, 5, 65, 66, 71, 67, 10,
                                  50, 32, 25, 17, 41, 16, 12, 2, 4, 3, 48, 30,
                                  17, 9, 22, 8, 2, 64, 65, 68, 32, 13, 6, 0, 12,
                                  2, 68, 67, 6, 44, 26, 16, 9, 27, 11, 9, 8, 3,
                                  62, 77, 68, 5, 66, 68, 1, 9, 10, 2, 9, 16, 21,
                                  76, 71, 75, 70, 20, 75, 76, 69, 3, 17, 88, 79,
                                  8, 13, 88, 90, 87, 72, 68, 9, 69, 64, 66, 2,
                                  10, 76, 69, 68, 3, 84, 73, 80, 80, 5, 100, 76,
                                  3, 70, 17, 70, 65, 27, 69, 72, 65, 23, 83, 77,
                                  101, 18, 29, 29, 18, 3, 18, 14, 8, 9, 6, 4, 1,
                                  80, 84, 91, 80, 76, 87, 108, 86, 84, 86, 83,
                                  81, 71, 71, 86, 92, 77, 4, 3, 5, 67, 83, 71,
                                  74, 90, 79, 86, 86, 101, 99, 95, 92, 73, 68,
                                  87, 74, 76, 86, 92, 93, 94, 95, 96, 101, 113,
                                  107, 115, 115, 115, 102, 112, 115, 75, 4, 66,
                                  7, 11, 11, 61, 22, 20, 68, 30, 62, 56, 62, 18,
                                  16, 8, 90, 114, 118, 124, 126, 126, 126, 67,
                                  43, 27, 18, 9, 14, 2, 66, 68, 68, 69, 1, 13,
                                  5, 23, 17, 8, 14, 17, 20, 21, 11, 23, 19, 64,
                                  18, 11, 65, 72, 79, 85, 111, 112, 103 },

                                {

                                25,
                                  4, 82, 25, 4, 82, 12, 21, 27, 12, 69, 94, 0,
                                  7, 52, 14, 45, 70, 20, 28, 64, 81, 1, 95, 112,
                                  67, 77, 126, 126, 126, 60, 13, 69, 20, 28, 64,
                                  69, 14, 19, 69, 3, 64, 66, 71, 85, 72, 93, 5,
                                  67, 67, 67, 79, 72, 88, 15, 3, 0, 66, 10, 3,
                                  22, 0, 0, 0, 5, 96, 97, 10, 75, 70, 52, 6, 69,
                                  81, 67, 82, 8, 13, 9, 20, 1, 17, 9, 6, 17, 77,
                                  82, 79, 85, 33, 1, 20, 69, 2, 71, 0, 17, 71,
                                  80, 72, 73, 18, 68, 6, 65, 74, 6, 68, 6, 11,
                                  6, 12, 20, 17, 82, 69, 3, 66, 2, 72, 11, 70,
                                  2, 19, 67, 16, 17, 6, 100, 10, 68, 94, 76, 99,
                                  73, 4, 66, 7, 2, 2, 22, 4, 64, 11, 21, 72, 72,
                                  3, 107, 80, 4, 95, 64, 77, 18, 1, 86, 29, 1,
                                  65, 93, 32, 81, 97, 1, 104, 64, 14, 17, 11,
                                  14, 10, 0, 13, 18, 86, 70, 8, 3, 1, 79, 70,
                                  74, 79, 71, 78, 88, 73, 75, 114, 90, 81, 96,
                                  91, 89, 13, 21, 11, 8, 8, 65, 72, 65, 79, 85,
                                  77, 92, 104, 103, 126, 74, 75, 91, 83, 90, 94,
                                  99, 102, 107, 112, 110, 126, 85, 109, 116,
                                  100, 102, 1, 38, 27, 18, 7, 5, 65, 66, 71, 66,
                                  10, 50, 33, 25, 17, 42, 17, 12, 3, 4, 4, 49,
                                  30, 18, 9, 23, 9, 2, 0, 64, 67, 33, 14, 7, 0,
                                  12, 2, 67, 65, 7, 44, 26, 16, 10, 27, 11, 10,
                                  8, 4, 62, 76, 67, 6, 66, 68, 1, 9, 10, 2, 10,
                                  16, 22, 76, 71, 76, 70, 20, 76, 77, 70, 2, 17,
                                  89, 80, 8, 13, 88, 91, 88, 71, 67, 10, 69, 0,
                                  66, 3, 10, 76, 68, 67, 4, 84, 73, 80, 80, 6,
                                  100, 76, 3, 70, 18, 70, 65, 28, 70, 72, 65,
                                  23, 84, 77, 102, 17, 28, 29, 17, 2, 18, 14, 7,
                                  8, 6, 3, 0, 81, 85, 92, 81, 77, 89, 110, 88,
                                  86, 87, 83, 81, 71, 71, 85, 93, 76, 2, 1, 3,
                                  69, 86, 73, 76, 92, 81, 89, 88, 104, 101, 96,
                                  92, 74, 69, 89, 76, 79, 88, 94, 95, 96, 97,
                                  99, 103, 115, 109, 117, 116, 117, 104, 114,
                                  117, 74, 5, 65, 8, 12, 12, 62, 23, 21, 68, 31,
                                  62, 57, 62, 19, 15, 7, 92, 117, 121, 126, 126,
                                  126, 126, 66, 43, 27, 18, 9, 14, 2, 66, 68,
                                  67, 68, 1, 14, 6, 24, 17, 9, 15, 17, 20, 21,
                                  11, 24, 19, 64, 17, 10, 67, 74, 80, 86, 114,
                                  113, 104 },

                                {

                                23,
                                  4, 82, 23, 4, 82, 13, 23, 27, 12, 70, 96, 65,
                                  6, 52, 14, 47, 70, 21, 29, 64, 82, 1, 96, 113,
                                  67, 79, 126, 126, 126, 62, 14, 69, 21, 29, 64,
                                  69, 15, 19, 69, 3, 64, 65, 71, 86, 72, 93, 5,
                                  67, 66, 67, 80, 72, 88, 16, 3, 0, 66, 11, 3,
                                  22, 0, 0, 0, 5, 97, 97, 11, 76, 70, 52, 6, 69,
                                  80, 66, 82, 9, 14, 11, 22, 2, 18, 11, 7, 19,
                                  76, 82, 78, 84, 33, 1, 21, 68, 2, 71, 1, 19,
                                  71, 80, 71, 72, 18, 68, 7, 64, 73, 7, 68, 6,
                                  11, 6, 12, 21, 18, 83, 69, 3, 66, 2, 72, 11,
                                  71, 1, 19, 68, 16, 17, 6, 102, 10, 69, 96, 77,
                                  100, 72, 5, 65, 8, 2, 3, 23, 5, 0, 12, 22, 72,
                                  72, 3, 108, 80, 5, 95, 64, 77, 19, 1, 87, 30,
                                  1, 65, 94, 33, 81, 98, 1, 105, 66, 13, 16, 10,
                                  13, 9, 64, 12, 18, 88, 71, 7, 3, 1, 80, 71,
                                  75, 80, 72, 79, 89, 74, 76, 116, 91, 82, 97,
                                  92, 89, 11, 20, 9, 6, 6, 67, 74, 67, 82, 87,
                                  79, 95, 106, 105, 126, 76, 77, 93, 85, 92, 96,
                                  101, 104, 109, 115, 112, 126, 86, 111, 117,
                                  101, 102, 1, 38, 27, 18, 7, 5, 65, 66, 71, 66,
                                  10, 50, 33, 25, 17, 43, 17, 13, 3, 5, 4, 50,
                                  31, 18, 9, 23, 9, 3, 0, 0, 66, 34, 15, 7, 0,
                                  13, 3, 66, 64, 7, 44, 26, 16, 10, 28, 12, 10,
                                  9, 5, 62, 76, 67, 6, 66, 68, 1, 9, 10, 2, 10,
                                  16, 22, 76, 71, 76, 71, 21, 77, 78, 71, 1, 17,
                                  91, 81, 8, 13, 89, 92, 88, 71, 66, 11, 68, 0,
                                  65, 3, 11, 77, 68, 67, 4, 85, 73, 80, 79, 7,
                                  100, 76, 3, 70, 19, 70, 65, 29, 70, 73, 65,
                                  24, 85, 77, 103, 16, 28, 28, 16, 1, 17, 13, 6,
                                  7, 5, 2, 64, 82, 86, 93, 83, 78, 90, 112, 89,
                                  87, 88, 84, 82, 71, 71, 85, 93, 76, 64, 65, 1,
                                  71, 89, 75, 78, 95, 83, 91, 90, 106, 103, 98,
                                  93, 76, 71, 90, 78, 81, 90, 96, 98, 98, 99,
                                  101, 105, 118, 111, 119, 118, 118, 106, 116,
                                  118, 73, 6, 64, 9, 13, 13, 62, 24, 22, 68, 32,
                                  62, 59, 62, 20, 13, 5, 95, 120, 124, 126, 126,
                                  126, 126, 66, 43, 27, 18, 9, 14, 2, 66, 68,
                                  67, 67, 2, 15, 6, 25, 18, 9, 16, 18, 21, 22,
                                  11, 24, 19, 64, 16, 8, 69, 76, 82, 88, 116,
                                  115, 105 },

                                {

                                22,
                                  4, 82, 22, 4, 82, 15, 24, 27, 12, 70, 97, 66,
                                  4, 52, 14, 50, 71, 22, 29, 64, 82, 2, 97, 114,
                                  68, 81, 126, 126, 126, 62, 16, 69, 22, 29, 64,
                                  69, 16, 19, 70, 3, 64, 65, 71, 86, 71, 93, 5,
                                  67, 65, 68, 80, 72, 88, 16, 4, 1, 65, 11, 3,
                                  22, 0, 0, 0, 6, 97, 97, 11, 77, 70, 52, 6, 69,
                                  79, 65, 82, 9, 16, 12, 24, 4, 19, 12, 9, 21,
                                  75, 81, 77, 84, 34, 1, 22, 67, 2, 70, 2, 21,
                                  71, 80, 71, 70, 19, 67, 7, 0, 73, 7, 68, 7,
                                  12, 7, 13, 21, 18, 83, 70, 3, 66, 2, 72, 11,
                                  71, 0, 19, 68, 16, 17, 5, 104, 10, 69, 97, 78,
                                  101, 71, 6, 64, 9, 3, 4, 24, 6, 0, 13, 23, 72,
                                  72, 4, 109, 79, 6, 95, 0, 77, 19, 1, 88, 31,
                                  1, 65, 96, 34, 82, 99, 1, 105, 67, 12, 16, 9,
                                  12, 8, 65, 12, 18, 89, 72, 7, 3, 1, 80, 71,
                                  75, 81, 72, 80, 90, 74, 77, 118, 92, 83, 98,
                                  93, 89, 9, 19, 7, 4, 5, 69, 77, 69, 84, 89,
                                  81, 97, 109, 107, 126, 78, 78, 95, 88, 94, 98,
                                  103, 107, 111, 118, 114, 126, 87, 112, 119,
                                  101, 102, 1, 38, 28, 18, 7, 5, 65, 66, 71, 65,
                                  11, 51, 33, 25, 17, 44, 18, 14, 3, 6, 5, 51,
                                  32, 18, 10, 24, 10, 3, 1, 1, 66, 36, 15, 7, 1,
                                  14, 4, 66, 0, 8, 45, 27, 16, 10, 29, 13, 11,
                                  10, 6, 62, 76, 67, 7, 66, 68, 1, 9, 10, 3, 10,
                                  17, 23, 76, 71, 76, 72, 21, 78, 79, 72, 1, 17,
                                  92, 82, 7, 13, 90, 93, 89, 70, 66, 12, 68, 1,
                                  65, 4, 12, 77, 68, 67, 4, 86, 73, 80, 79, 8,
                                  100, 76, 4, 70, 19, 70, 65, 30, 70, 73, 65,
                                  25, 85, 78, 103, 15, 28, 28, 16, 0, 16, 12, 5,
                                  7, 4, 1, 65, 83, 87, 94, 84, 80, 92, 114, 90,
                                  88, 89, 85, 82, 71, 70, 85, 94, 75, 66, 67,
                                  64, 74, 91, 77, 80, 97, 85, 93, 92, 108, 105,
                                  99, 94, 78, 73, 91, 80, 83, 92, 98, 100, 100,
                                  101, 103, 107, 120, 113, 121, 120, 119, 108,
                                  118, 120, 72, 8, 0, 9, 14, 14, 62, 25, 23, 68,
                                  33, 62, 60, 62, 20, 12, 3, 97, 123, 126, 126,
                                  126, 126, 126, 66, 43, 27, 18, 9, 14, 2, 66,
                                  68, 66, 66, 3, 16, 7, 26, 19, 10, 17, 19, 22,
                                  23, 12, 25, 20, 64, 14, 7, 70, 77, 84, 90,
                                  118, 117, 106 },

                                {

                                21,
                                  4, 82, 21, 4, 82, 17, 26, 28, 12, 71, 99, 68,
                                  3, 52, 14, 52, 71, 23, 30, 64, 83, 2, 98, 115,
                                  68, 83, 126, 126, 126, 62, 17, 69, 23, 30, 64,
                                  68, 17, 20, 70, 3, 0, 64, 72, 87, 71, 93, 5,
                                  67, 65, 68, 80, 72, 88, 17, 4, 1, 65, 12, 3,
                                  22, 0, 0, 0, 6, 97, 97, 12, 78, 70, 52, 6, 69,
                                  78, 64, 82, 10, 17, 14, 26, 5, 20, 14, 10, 23,
                                  74, 80, 76, 83, 35, 1, 23, 66, 2, 70, 2, 23,
                                  71, 79, 70, 69, 19, 67, 8, 2, 72, 8, 68, 7,
                                  12, 7, 14, 22, 19, 84, 70, 3, 66, 2, 72, 11,
                                  72, 0, 19, 69, 16, 17, 5, 106, 10, 70, 99, 79,
                                  102, 70, 7, 0, 10, 4, 4, 25, 6, 1, 14, 24, 72,
                                  72, 4, 110, 79, 7, 95, 0, 77, 20, 1, 89, 32,
                                  1, 65, 97, 35, 82, 100, 1, 106, 69, 11, 15, 8,
                                  11, 7, 65, 11, 17, 90, 73, 7, 3, 1, 81, 72,
                                  76, 82, 73, 81, 91, 75, 77, 120, 93, 83, 99,
                                  94, 89, 8, 17, 6, 2, 3, 71, 79, 71, 87, 92,
                                  83, 100, 111, 110, 126, 80, 80, 96, 90, 96,
                                  101, 106, 109, 114, 120, 116, 126, 88, 114,
                                  120, 102, 102, 1, 39, 28, 18, 7, 5, 65, 66,
                                  71, 65, 11, 51, 33, 25, 17, 45, 18, 14, 4, 6,
                                  6, 52, 32, 19, 10, 25, 10, 4, 1, 2, 65, 37,
                                  16, 8, 1, 15, 5, 65, 1, 8, 45, 27, 16, 10, 30,
                                  13, 12, 11, 7, 62, 75, 66, 7, 66, 68, 1, 9,
                                  10, 3, 10, 17, 23, 76, 71, 76, 72, 22, 79, 80,
                                  73, 0, 17, 93, 83, 7, 13, 90, 94, 89, 69, 65,
                                  13, 67, 1, 64, 4, 13, 77, 68, 67, 5, 86, 73,
                                  80, 78, 9, 100, 76, 4, 70, 20, 70, 65, 31, 70,
                                  73, 65, 26, 86, 78, 104, 14, 27, 27, 15, 64,
                                  15, 11, 4, 6, 3, 0, 66, 84, 88, 95, 86, 81,
                                  93, 116, 92, 89, 90, 85, 83, 71, 70, 85, 94,
                                  74, 68, 69, 66, 76, 94, 79, 82, 100, 87, 95,
                                  94, 111, 107, 101, 95, 80, 74, 93, 82, 85, 94,
                                  100, 102, 102, 103, 105, 109, 123, 115, 123,
                                  122, 120, 110, 120, 121, 71, 9, 1, 10, 15, 15,
                                  62, 26, 24, 68, 34, 62, 62, 62, 21, 10, 2,
                                  100, 126, 126, 126, 126, 126, 126, 66, 43, 27,
                                  18, 9, 14, 2, 66, 68, 66, 65, 4, 17, 8, 27,
                                  19, 10, 18, 19, 22, 23, 12, 25, 20, 64, 13, 5,
                                  72, 79, 86, 92, 120, 119, 107 },

                                {

                                20,
                                  4, 82, 20, 4, 82, 19, 27, 28, 12, 71, 100, 69,
                                  2, 52, 14, 54, 71, 24, 31, 64, 84, 2, 99, 116,
                                  69, 85, 126, 126, 126, 62, 18, 69, 24, 31, 64,
                                  68, 18, 20, 71, 3, 0, 0, 72, 87, 71, 93, 5,
                                  67, 64, 68, 80, 72, 88, 17, 4, 1, 65, 12, 3,
                                  22, 0, 0, 0, 7, 97, 97, 12, 79, 70, 52, 6, 69,
                                  77, 0, 82, 10, 18, 16, 28, 7, 21, 16, 11, 25,
                                  73, 79, 75, 82, 36, 1, 24, 65, 2, 69, 3, 25,
                                  71, 79, 70, 68, 19, 67, 8, 3, 72, 9, 68, 7,
                                  12, 7, 15, 22, 19, 84, 70, 3, 66, 2, 72, 11,
                                  72, 64, 19, 70, 16, 17, 5, 108, 10, 70, 101,
                                  80, 103, 69, 8, 1, 11, 5, 5, 26, 7, 1, 15, 25,
                                  72, 72, 4, 111, 78, 8, 95, 0, 77, 21, 1, 90,
                                  33, 1, 65, 98, 36, 83, 101, 1, 107, 70, 10,
                                  15, 7, 10, 6, 66, 10, 17, 91, 74, 7, 3, 1, 81,
                                  73, 77, 83, 74, 82, 92, 76, 78, 122, 94, 84,
                                  100, 95, 89, 6, 16, 4, 0, 1, 73, 81, 73, 89,
                                  94, 85, 102, 114, 112, 126, 82, 82, 98, 92,
                                  98, 103, 108, 111, 116, 123, 118, 126, 89,
                                  116, 121, 103, 102, 1, 39, 28, 18, 7, 5, 65,
                                  66, 71, 64, 11, 51, 33, 25, 17, 46, 19, 15, 4,
                                  7, 7, 53, 33, 19, 10, 26, 11, 4, 2, 3, 64, 38,
                                  17, 8, 1, 16, 6, 64, 2, 9, 45, 27, 16, 10, 31,
                                  14, 13, 12, 8, 62, 75, 66, 8, 66, 68, 1, 9,
                                  10, 3, 10, 17, 24, 76, 71, 76, 73, 22, 80, 81,
                                  74, 64, 17, 94, 84, 7, 13, 91, 95, 90, 68, 64,
                                  14, 67, 2, 64, 5, 14, 77, 68, 67, 5, 87, 73,
                                  80, 78, 10, 100, 76, 4, 70, 21, 70, 65, 32,
                                  70, 73, 65, 27, 87, 78, 105, 13, 27, 27, 14,
                                  65, 14, 10, 3, 5, 2, 64, 67, 85, 89, 96, 87,
                                  82, 95, 118, 93, 90, 91, 86, 83, 71, 70, 85,
                                  95, 73, 70, 71, 68, 78, 97, 81, 84, 102, 89,
                                  97, 96, 113, 109, 102, 96, 82, 76, 94, 84, 87,
                                  96, 102, 104, 104, 105, 107, 111, 125, 117,
                                  125, 124, 121, 112, 122, 123, 70, 10, 2, 11,
                                  16, 16, 62, 27, 25, 68, 35, 62, 62, 62, 22, 9,
                                  0, 102, 126, 126, 126, 126, 126, 126, 66, 43,
                                  27, 18, 9, 14, 2, 66, 68, 65, 64, 5, 18, 9,
                                  28, 20, 11, 19, 20, 23, 24, 12, 26, 20, 64,
                                  12, 4, 74, 81, 88, 94, 122, 121, 108 },

                                {

                                18,
                                  3, 83, 18, 3, 83, 20, 28, 28, 12, 72, 102, 71,
                                  0, 51, 14, 56, 72, 24, 31, 65, 85, 2, 101,
                                  118, 70, 87, 126, 126, 126, 62, 19, 70, 24,
                                  31, 65, 68, 19, 20, 72, 3, 0, 0, 73, 88, 71,
                                  94, 5, 67, 64, 69, 81, 72, 88, 17, 4, 1, 65,
                                  12, 2, 22, 0, 0, 0, 7, 98, 97, 12, 80, 71, 52,
                                  5, 69, 76, 0, 82, 10, 19, 17, 29, 8, 22, 17,
                                  12, 26, 72, 79, 74, 82, 36, 1, 24, 65, 2, 69,
                                  3, 26, 71, 79, 70, 67, 19, 67, 8, 4, 72, 9,
                                  68, 7, 12, 7, 15, 22, 19, 85, 71, 3, 67, 2,
                                  72, 10, 73, 65, 19, 71, 15, 17, 4, 110, 9, 71,
                                  103, 81, 104, 69, 8, 1, 11, 5, 5, 27, 7, 1,
                                  15, 26, 73, 72, 4, 113, 78, 8, 95, 0, 78, 21,
                                  1, 91, 33, 1, 65, 100, 36, 84, 102, 1, 108,
                                  72, 9, 14, 6, 9, 5, 67, 9, 16, 93, 75, 6, 2,
                                  1, 82, 74, 78, 84, 75, 83, 93, 77, 79, 124,
                                  96, 85, 102, 97, 89, 4, 14, 2, 65, 64, 76, 84,
                                  76, 92, 97, 88, 105, 117, 115, 126, 84, 84,
                                  100, 95, 101, 106, 111, 114, 119, 126, 121,
                                  126, 90, 118, 123, 104, 103, 1, 39, 28, 18, 7,
                                  5, 66, 66, 71, 64, 11, 51, 33, 25, 17, 47, 19,
                                  15, 4, 7, 7, 53, 33, 19, 10, 26, 11, 4, 2, 4,
                                  64, 39, 17, 8, 1, 16, 6, 64, 3, 9, 45, 27, 16,
                                  10, 31, 14, 13, 12, 8, 62, 75, 66, 8, 66, 68,
                                  1, 9, 10, 3, 10, 17, 24, 76, 71, 77, 74, 22,
                                  81, 82, 75, 65, 16, 96, 86, 6, 12, 92, 97, 91,
                                  68, 64, 15, 67, 2, 64, 5, 14, 78, 68, 67, 5,
                                  88, 73, 80, 78, 10, 101, 76, 4, 70, 21, 71,
                                  65, 32, 71, 74, 65, 27, 88, 79, 106, 12, 26,
                                  26, 13, 67, 13, 9, 2, 4, 1, 65, 68, 86, 91,
                                  98, 89, 84, 97, 120, 95, 92, 92, 87, 84, 71,
                                  70, 85, 96, 73, 73, 74, 70, 81, 100, 84, 87,
                                  105, 92, 100, 99, 116, 112, 104, 97, 84, 78,
                                  96, 86, 90, 99, 105, 107, 107, 107, 110, 114,
                                  126, 119, 126, 126, 123, 114, 124, 125, 69,
                                  11, 3, 11, 16, 16, 62, 27, 25, 68, 35, 62, 62,
                                  62, 22, 7, 65, 105, 126, 126, 126, 126, 126,
                                  126, 66, 43, 26, 17, 9, 14, 2, 67, 68, 65, 64,
                                  5, 18, 9, 29, 20, 11, 19, 20, 23, 24, 12, 26,
                                  20, 65, 10, 2, 76, 83, 90, 96, 125, 123, 109 },

                                {

                                17,
                                  3, 83, 17, 3, 83, 22, 30, 29, 13, 72, 103, 72,
                                  64, 51, 14, 59, 72, 25, 32, 65, 85, 3, 102,
                                  119, 70, 88, 126, 126, 126, 62, 21, 70, 25,
                                  32, 65, 67, 21, 21, 72, 4, 1, 1, 73, 88, 70,
                                  94, 5, 66, 0, 69, 81, 71, 88, 18, 5, 2, 64,
                                  13, 2, 22, 0, 0, 0, 8, 98, 97, 13, 80, 71, 52,
                                  5, 69, 74, 1, 82, 11, 21, 19, 31, 10, 24, 19,
                                  14, 28, 70, 78, 73, 81, 37, 2, 25, 64, 3, 68,
                                  4, 28, 70, 78, 69, 65, 20, 66, 9, 6, 71, 10,
                                  67, 8, 13, 8, 16, 23, 20, 85, 71, 4, 67, 2,
                                  71, 10, 73, 65, 19, 71, 15, 17, 4, 111, 9, 71,
                                  104, 82, 104, 68, 9, 2, 12, 6, 6, 28, 8, 2,
                                  16, 28, 73, 72, 5, 114, 77, 9, 95, 1, 78, 22,
                                  2, 91, 34, 1, 65, 101, 37, 84, 103, 1, 108,
                                  73, 9, 14, 6, 9, 5, 67, 9, 16, 94, 75, 6, 2,
                                  1, 82, 74, 78, 84, 75, 83, 94, 77, 79, 125,
                                  97, 85, 103, 98, 89, 3, 13, 1, 66, 65, 78, 86,
                                  78, 94, 99, 90, 107, 119, 117, 126, 85, 85,
                                  101, 97, 103, 108, 113, 116, 121, 126, 123,
                                  126, 90, 119, 124, 104, 103, 2, 40, 29, 19, 8,
                                  5, 66, 65, 70, 0, 12, 52, 34, 26, 17, 48, 20,
                                  16, 5, 8, 8, 54, 34, 20, 11, 27, 12, 5, 3, 6,
                                  0, 41, 18, 9, 2, 17, 7, 0, 5, 10, 46, 28, 17,
                                  11, 32, 15, 14, 13, 9, 62, 74, 65, 9, 66, 67,
                                  1, 10, 11, 4, 11, 18, 25, 75, 71, 77, 74, 23,
                                  81, 82, 76, 65, 16, 97, 87, 6, 12, 92, 98, 91,
                                  67, 0, 16, 66, 3, 0, 6, 15, 78, 67, 66, 6, 88,
                                  72, 79, 77, 11, 101, 76, 5, 70, 22, 71, 65,
                                  33, 71, 74, 64, 28, 88, 79, 106, 12, 26, 26,
                                  13, 68, 13, 9, 2, 4, 1, 65, 68, 86, 92, 99,
                                  90, 85, 98, 121, 96, 93, 92, 87, 84, 70, 69,
                                  84, 96, 72, 75, 76, 72, 83, 102, 86, 89, 107,
                                  94, 102, 101, 118, 114, 105, 97, 85, 79, 97,
                                  87, 92, 101, 107, 109, 109, 109, 112, 116,
                                  126, 120, 126, 126, 124, 115, 125, 126, 67,
                                  13, 5, 12, 17, 17, 62, 28, 26, 68, 36, 62, 62,
                                  62, 23, 6, 66, 107, 126, 126, 126, 126, 126,
                                  126, 65, 44, 26, 17, 9, 15, 2, 67, 68, 64, 0,
                                  6, 19, 10, 31, 21, 12, 20, 21, 24, 25, 13, 27,
                                  21, 65, 9, 1, 77, 84, 91, 97, 126, 124, 109 },

                                {

                                16,
                                  3, 83, 16, 3, 83, 24, 31, 29, 13, 72, 104, 73,
                                  65, 51, 14, 61, 72, 26, 33, 65, 86, 3, 103,
                                  120, 71, 90, 126, 126, 126, 62, 22, 70, 26,
                                  33, 65, 67, 22, 21, 73, 4, 1, 2, 73, 88, 70,
                                  94, 5, 66, 1, 69, 81, 71, 88, 18, 5, 2, 64,
                                  13, 2, 22, 0, 0, 0, 9, 98, 97, 13, 81, 71, 52,
                                  5, 69, 73, 2, 82, 11, 22, 21, 33, 11, 25, 21,
                                  15, 30, 69, 77, 72, 80, 38, 2, 26, 0, 3, 68,
                                  5, 30, 70, 78, 69, 64, 20, 66, 9, 7, 71, 11,
                                  67, 8, 13, 8, 17, 23, 20, 86, 71, 4, 67, 2,
                                  71, 10, 73, 66, 19, 72, 15, 17, 4, 113, 9, 71,
                                  106, 83, 105, 67, 10, 3, 13, 7, 7, 29, 9, 2,
                                  17, 29, 73, 72, 5, 115, 77, 10, 95, 1, 78, 23,
                                  2, 92, 35, 1, 65, 102, 38, 85, 104, 1, 109,
                                  75, 8, 13, 5, 8, 4, 68, 8, 16, 95, 76, 6, 2,
                                  1, 82, 75, 79, 85, 76, 84, 95, 78, 80, 126,
                                  98, 86, 104, 99, 89, 1, 12, 64, 68, 67, 80,
                                  88, 80, 97, 101, 92, 110, 122, 119, 126, 87,
                                  87, 103, 99, 105, 110, 115, 118, 123, 126,
                                  125, 126, 91, 121, 125, 105, 103, 2, 40, 29,
                                  19, 8, 5, 66, 65, 70, 1, 12, 52, 34, 26, 17,
                                  49, 20, 17, 5, 9, 9, 55, 35, 20, 11, 28, 12,
                                  5, 4, 7, 1, 42, 19, 9, 2, 18, 8, 1, 6, 10, 46,
                                  28, 17, 11, 33, 16, 15, 14, 10, 62, 74, 65, 9,
                                  66, 67, 1, 10, 11, 4, 11, 18, 26, 75, 71, 77,
                                  75, 23, 82, 83, 77, 66, 16, 98, 88, 6, 12, 93,
                                  99, 92, 66, 1, 17, 66, 3, 0, 7, 16, 78, 67,
                                  66, 6, 89, 72, 79, 77, 12, 101, 76, 5, 70, 23,
                                  71, 65, 34, 71, 74, 64, 29, 89, 79, 107, 11,
                                  26, 26, 12, 69, 12, 8, 1, 3, 0, 66, 69, 87,
                                  93, 100, 92, 86, 100, 123, 97, 94, 93, 88, 84,
                                  70, 69, 84, 97, 71, 77, 78, 74, 85, 105, 88,
                                  91, 110, 96, 104, 103, 120, 116, 106, 98, 87,
                                  81, 98, 89, 94, 103, 109, 111, 111, 111, 114,
                                  118, 126, 122, 126, 126, 125, 117, 126, 126,
                                  66, 14, 6, 13, 18, 18, 62, 29, 27, 68, 37, 62,
                                  62, 62, 24, 5, 68, 110, 126, 126, 126, 126,
                                  126, 126, 65, 44, 26, 17, 9, 15, 2, 67, 68, 0,
                                  1, 7, 20, 11, 32, 22, 13, 21, 22, 25, 26, 13,
                                  28, 21, 65, 8, 64, 79, 86, 93, 99, 126, 126,
                                  110 },

                                {

                                15,
                                  3, 83, 15, 3, 83, 26, 33, 30, 13, 73, 106, 75,
                                  66, 51, 14, 62, 72, 27, 34, 65, 87, 3, 104,
                                  121, 71, 92, 126, 126, 126, 62, 23, 70, 27,
                                  34, 65, 66, 23, 22, 73, 4, 2, 3, 74, 89, 70,
                                  94, 5, 66, 1, 69, 81, 71, 88, 19, 5, 2, 64,
                                  14, 2, 22, 0, 0, 0, 9, 98, 97, 14, 82, 71, 52,
                                  5, 69, 72, 3, 82, 12, 23, 23, 35, 13, 26, 23,
                                  16, 32, 68, 76, 71, 79, 39, 2, 27, 1, 3, 67,
                                  5, 32, 70, 77, 68, 0, 20, 66, 10, 9, 70, 12,
                                  67, 8, 13, 8, 18, 24, 21, 86, 71, 4, 67, 2,
                                  71, 10, 74, 66, 19, 73, 15, 17, 4, 115, 9, 72,
                                  108, 84, 106, 66, 11, 4, 14, 8, 7, 30, 9, 3,
                                  18, 30, 73, 72, 5, 116, 76, 11, 95, 1, 78, 24,
                                  2, 93, 36, 1, 65, 103, 39, 85, 105, 1, 110,
                                  76, 7, 13, 4, 7, 3, 68, 7, 15, 96, 77, 6, 2,
                                  1, 83, 76, 80, 86, 77, 85, 96, 79, 80, 126,
                                  99, 86, 105, 100, 89, 0, 10, 65, 70, 69, 82,
                                  90, 82, 99, 104, 94, 112, 124, 122, 126, 89,
                                  89, 104, 101, 107, 113, 118, 120, 126, 126,
                                  126, 126, 92, 123, 126, 106, 103, 2, 41, 29,
                                  19, 8, 5, 66, 65, 70, 1, 12, 52, 34, 26, 17,
                                  50, 21, 17, 6, 9, 10, 56, 35, 21, 11, 29, 13,
                                  6, 4, 8, 2, 43, 20, 10, 2, 19, 9, 2, 7, 11,
                                  46, 28, 17, 11, 34, 16, 16, 15, 11, 62, 73,
                                  64, 10, 66, 67, 1, 10, 11, 4, 11, 18, 26, 75,
                                  71, 77, 75, 24, 83, 84, 78, 67, 16, 99, 89, 6,
                                  12, 93, 100, 92, 65, 2, 18, 65, 4, 1, 7, 17,
                                  78, 67, 66, 7, 89, 72, 79, 76, 13, 101, 76, 5,
                                  70, 24, 71, 65, 35, 71, 74, 64, 30, 90, 79,
                                  108, 10, 25, 25, 11, 70, 11, 7, 0, 2, 64, 67,
                                  70, 88, 94, 101, 93, 87, 101, 125, 99, 95, 94,
                                  88, 85, 70, 69, 84, 97, 70, 79, 80, 76, 87,
                                  108, 90, 93, 112, 98, 106, 105, 123, 118, 108,
                                  99, 89, 82, 100, 91, 96, 105, 111, 113, 113,
                                  113, 116, 120, 126, 124, 126, 126, 126, 119,
                                  126, 126, 65, 15, 7, 14, 19, 19, 62, 30, 28,
                                  68, 38, 62, 62, 62, 25, 3, 69, 112, 126, 126,
                                  126, 126, 126, 126, 65, 44, 26, 17, 9, 15, 2,
                                  67, 68, 0, 2, 8, 21, 12, 33, 22, 13, 22, 22,
                                  25, 26, 13, 28, 21, 65, 7, 65, 81, 88, 95,
                                  101, 126, 126, 111 },

                          },

                    };


